/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.zos;

import com.sas.tools.installs.it.tasks.MvsextractTask;
import com.sas.tools.installs.it.view.SSNResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataSetParamValidator {
    private static final String ALLOC = "/zos/alloc.rexx";
    private static final String FINDVOL = "/zos/findvol";
    private static final String BIT_COUNT = "zos.bit.count";
    private static final String BIT_COUNT_31 = "31";
    private static final String BIT_COUNT_64 = "64";
    private static final String CNTL_QUALIFIER = "cntl.qualifier";
    private static final String JOB_DISKUNIT = "job.diskunit";
    private static final String HIGH_LEVEL_QUALIFIER = "high.level.qualifier";
    private static final String SMS = "sms";
    private static final String SMS_PDSE = "sms.pdse";
    private static final String SMS_DC = ".dc";
    private static final String SMS_MC = ".mc";
    private static final String SMS_SC = ".sc";
    private static final String PREFIX_ZOS = "zos.";
    private static final String PREFIX_Z64 = "z64.";
    private static final String ALLOC_HLQ = "hlq";
    private static final String ALLOC_PDSE = "pdse";
    private static final String ALLOC_TEMP = "temp";
    private static final String ALLOC_TEST = "test";
    private static final String ALLOC_VALIDATE = "validate";
    private static final String FORMAT = "%s(%s)";
    private static final String DATACLAS = "dataclas";
    private static final String MGMTCLAS = "mgmtclas";
    private static final String STORCLAS = "storclas";
    private static final String CNTL = ".CNTL";
    private static final String PDSE = ".PDSE";
    private static final String TEST = ".TEST";
    private static final String TEMP = "&&";
    private static final String UNIT = "unit";
    private static final String VOL = "vol";
    private static final String OLD = "old";
    private static final String DISKUNIT = "DISKUNIT";
    private static final String HLQ = "High-Level Qualifier";
    private static final String SMS_PARAMETERS = "SMS";
    private static final String SMS_PDSE_PARAMETERS = "PDS/E SMS";
    private static final String TMPUNI = "TMPUNI";
    private static final String VOLDISK = "VOLDISK";
    private static final String MSG_KEY_DATA_SET_CHECK_ERROR = "DataSetParamValidator.DataSetCheckError";
    private static final String MSG_KEY_HIGH_LEVEL_QUALIFIER_USED = "DataSetParamValidator.HighLevelQualifierUsed";
    private static final String MSG_KEY_INVALID_SMS_VALUE = "DataSetParamValidator.InvalidSMSValue";
    private static final String MSG_KEY_INVALID_VALUE = "DataSetParamValidator.InvalidValue";
    private static final String MSG_KEY_SMS_VALUE_CHECK_ERROR = "DataSetParamValidator.SmsValueCheckError";
    private static final String MSG_KEY_VALUE_CHECK_ERROR = "DataSetParamValidator.ValueCheckError";
    private static final String MSG_KEY_VOLUME_NOT_FOUND = "DataSetParamValidator.VolumeNotFound";
    private Properties dsProperties;
    private String propPrefix;
    private String commandAlloc;
    private String commandFindvol;
    private Logger log;
    private SSNResource bundle = new SSNResource(DataSetParamValidator.class);
    private SSNResource enBundle = SSNResource.EnglishResource(DataSetParamValidator.class);

    public DataSetParamValidator(Properties dsProperties, String runLocation, Logger sdwLog, boolean quiet) {
        String bitCount;
        boolean z64;
        this.commandAlloc = runLocation.concat(ALLOC);
        this.commandFindvol = runLocation.concat(FINDVOL);
        this.dsProperties = dsProperties;
        this.log = sdwLog;
        if (quiet) {
            this.bundle = this.enBundle;
        }
        this.propPrefix = (z64 = BIT_COUNT_64.equals(bitCount = this.getDsProperty(null, BIT_COUNT, BIT_COUNT_31))) ? PREFIX_Z64 : PREFIX_ZOS;
    }

    public boolean cntlDsAvailable(StringBuffer msgs) {
        if (MvsextractTask.isHotfix()) {
            return true;
        }
        String hlq = this.getDsProperty(this.getPropPrefix(), HIGH_LEVEL_QUALIFIER, "");
        String inst = this.getDsProperty(null, CNTL_QUALIFIER, "");
        String cntlDsn = hlq.concat(".");
        cntlDsn = cntlDsn.concat(inst);
        if (!MvsextractTask.datasetExists(cntlDsn = cntlDsn.concat(CNTL))) {
            return true;
        }
        String command = this.getCommandAlloc();
        String[] commandArray = new String[]{command, ALLOC_TEST, cntlDsn, OLD};
        int rc = this.runProcess(commandArray, MSG_KEY_DATA_SET_CHECK_ERROR, cntlDsn, msgs);
        return rc == 0;
    }

    public boolean checkHighLevelQualifier(String hlq, StringBuffer msgs) {
        String dsn = this.uniqueQualifer(hlq.toUpperCase());
        dsn = dsn.concat(TEST);
        String command = this.getCommandAlloc();
        String logMsg = this.getEnBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, HLQ, hlq);
        String failMsg = this.getBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, HLQ, hlq);
        String[] commandArray = new String[]{command, ALLOC_HLQ, dsn};
        int rc = this.runProcess(commandArray, failMsg, logMsg, msgs);
        if (rc != 0) {
            if (rc != -1) {
                String msg = this.getBundle().messageString(MSG_KEY_INVALID_VALUE, HLQ, hlq);
                msgs.append(msg);
            }
            return false;
        }
        return true;
    }

    public boolean checkHighLevelQualifierUsed(String hlq, StringBuffer msgs) {
        String zosHlq;
        String z64Hlq = this.getDsProperty(PREFIX_Z64, HIGH_LEVEL_QUALIFIER, "");
        String inst = this.getDsProperty(null, CNTL_QUALIFIER, "");
        String cntlDsn = z64Hlq.concat(".");
        cntlDsn = cntlDsn.concat(inst);
        if (MvsextractTask.datasetExists(cntlDsn = cntlDsn.concat(CNTL)) && (zosHlq = hlq.toUpperCase()).equals(z64Hlq)) {
            String failMsg = this.bundle.messageString(MSG_KEY_HIGH_LEVEL_QUALIFIER_USED, cntlDsn, zosHlq);
            String logMsg = this.enBundle.messageString(MSG_KEY_HIGH_LEVEL_QUALIFIER_USED, cntlDsn, zosHlq);
            this.log.warning(logMsg);
            msgs.append(failMsg);
            return false;
        }
        return true;
    }

    public boolean checkDiskUnit(String diskUnit, StringBuffer msgs) {
        if (diskUnit != null && diskUnit.trim().length() > 0) {
            diskUnit = diskUnit.trim().toUpperCase();
            String hlq = this.getDsProperty(this.getPropPrefix(), HIGH_LEVEL_QUALIFIER, "");
            String dsn = this.uniqueQualifer(hlq);
            dsn = dsn.concat(TEST);
            String command = this.getCommandAlloc();
            String failMsg = this.getBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, DISKUNIT, diskUnit);
            String logMsg = this.getEnBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, DISKUNIT, diskUnit);
            String unit = String.format(FORMAT, UNIT, diskUnit);
            String[] commandArray = new String[]{command, ALLOC_VALIDATE, dsn, "", "", "", "", unit};
            int rc = this.runProcess(commandArray, failMsg, logMsg, msgs);
            if (rc != 0) {
                if (rc != -1) {
                    String msg = this.getBundle().messageString(MSG_KEY_INVALID_VALUE, DISKUNIT, diskUnit);
                    msgs.append(msg);
                }
                return false;
            }
        }
        return true;
    }

    public boolean checkSMS(StringBuffer msgs) {
        String hlq = this.getDsProperty(this.getPropPrefix(), HIGH_LEVEL_QUALIFIER, "");
        String dsn = this.uniqueQualifer(hlq);
        dsn = dsn.concat(TEST);
        return this.validateSms(dsn, ALLOC_VALIDATE, SMS, msgs);
    }

    public boolean checkSMSPDSE(StringBuffer msgs) {
        String hlq = this.getDsProperty(this.getPropPrefix(), HIGH_LEVEL_QUALIFIER, "");
        String dsn = this.uniqueQualifer(hlq);
        dsn = dsn.concat(PDSE);
        return this.validateSms(dsn, ALLOC_PDSE, SMS_PDSE, msgs);
    }

    private boolean validateSms(String dsn, String arg, String propQual, StringBuffer msgs) {
        String dataclas;
        String mgmtclas;
        String insert = arg.equals(ALLOC_PDSE) ? SMS_PDSE_PARAMETERS : SMS_PARAMETERS;
        String failMsg = this.getBundle().messageString(MSG_KEY_SMS_VALUE_CHECK_ERROR, insert);
        String logMsg = this.getEnBundle().messageString(MSG_KEY_SMS_VALUE_CHECK_ERROR, insert);
        String command = this.getCommandAlloc();
        String vol = "";
        String unit = "";
        String sc = this.getDsProperty(this.propPrefix, propQual.concat(SMS_SC), "");
        String mc = this.getDsProperty(this.propPrefix, propQual.concat(SMS_MC), "");
        String dc = this.getDsProperty(this.propPrefix, propQual.concat(SMS_DC), "");
        String storclas = sc.isEmpty() ? "" : String.format(FORMAT, STORCLAS, sc);
        String[] commandArray = new String[]{command, arg, dsn, storclas, mgmtclas = mc.isEmpty() ? "" : String.format(FORMAT, MGMTCLAS, mc), dataclas = dc.isEmpty() ? "" : String.format(FORMAT, DATACLAS, dc), vol, unit};
        int rc = this.runProcess(commandArray, failMsg, logMsg, msgs);
        if (rc != 0) {
            if (rc != -1) {
                String msg = this.getBundle().messageString(MSG_KEY_INVALID_SMS_VALUE, insert);
                msgs.append(msg);
            }
            return false;
        }
        return true;
    }

    public boolean checkTempUnit(String tempUnit, StringBuffer msgs) {
        String dsn = this.uniqueQualifer(null);
        String command = this.getCommandAlloc();
        String failMsg = this.getBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, TMPUNI, tempUnit);
        String logMsg = this.getEnBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, TMPUNI, tempUnit);
        String unit = String.format(FORMAT, UNIT, tempUnit.toUpperCase());
        String[] commandArray = new String[]{command, ALLOC_TEMP, dsn, unit};
        int rc = this.runProcess(commandArray, failMsg, logMsg, msgs);
        if (rc != 0) {
            if (rc != -1) {
                String msg = this.getBundle().messageString(MSG_KEY_INVALID_VALUE, TMPUNI, tempUnit);
                msgs.append(msg);
            }
            return false;
        }
        return true;
    }

    public boolean checkVolDisk(String volDisk, StringBuffer msgs) {
        if (volDisk != null && volDisk.trim().length() > 0) {
            String logMsg;
            String failMsg;
            String volser = volDisk.trim().toUpperCase();
            String command = this.getCommandFindvol();
            String[] commandArray = new String[]{command, volser};
            int rc = this.runProcess(commandArray, failMsg = this.getBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, VOLDISK, volser), logMsg = this.getEnBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, VOLDISK, volser), msgs);
            if (rc != 0) {
                if (rc != -1) {
                    failMsg = this.getBundle().messageString(MSG_KEY_VOLUME_NOT_FOUND, volser);
                    msgs.append(failMsg);
                    logMsg = this.getEnBundle().messageString(MSG_KEY_VOLUME_NOT_FOUND, volser);
                    this.log.info(logMsg);
                    failMsg = this.getBundle().messageString(MSG_KEY_INVALID_VALUE, VOLDISK, volser);
                    msgs.append(failMsg);
                }
                return false;
            }
            String hlq = this.getDsProperty(this.getPropPrefix(), HIGH_LEVEL_QUALIFIER, "");
            String diskUnit = this.getDsProperty(this.getPropPrefix(), JOB_DISKUNIT, "");
            String dsn = this.uniqueQualifer(hlq);
            dsn = dsn.concat(TEST);
            command = this.getCommandAlloc();
            failMsg = this.getBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, VOLDISK, volser);
            logMsg = this.getEnBundle().messageString(MSG_KEY_VALUE_CHECK_ERROR, VOLDISK, volser);
            String unit = String.format(FORMAT, UNIT, diskUnit);
            String vol = String.format(FORMAT, VOL, volser);
            String[] commandArray2 = new String[]{command, ALLOC_VALIDATE, dsn, "", "", "", vol, unit};
            rc = this.runProcess(commandArray2, failMsg, logMsg, msgs);
            if (rc != 0) {
                if (rc != -1) {
                    String msg = this.getBundle().messageString(MSG_KEY_INVALID_VALUE, VOLDISK, volser);
                    msgs.append(msg);
                }
                return false;
            }
        }
        return true;
    }

    private String getDsProperty(String propPrefix, String propSuffix, String defaultValue) {
        String propKey = propPrefix == null || propPrefix.isEmpty() ? propSuffix : propPrefix.concat(propSuffix);
        String value = this.getDsProperties().getProperty(propKey, defaultValue);
        value = value.toUpperCase();
        return value;
    }

    private String uniqueQualifer(String hlq) {
        long nano = System.nanoTime();
        String nanoString = String.format("%d", nano);
        int start = nanoString.length() - 7;
        String qualifier = hlq != null ? String.format("%s.T%s", hlq, nanoString.substring(start)) : String.format("%sT%s", TEMP, nanoString.substring(start));
        return qualifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runProcess(String[] cmdArray, String msg, String logMsg, StringBuffer outMsgs) {
        String exMsg = null;
        Process p = null;
        int rc = -1;
        try {
            this.log.info("Executing command: " + this.arrayAsString(cmdArray));
            ProcessBuilder pb = new ProcessBuilder(cmdArray);
            if (cmdArray[1].equals("error")) {
                throw new IOException("I/O error");
            }
            p = pb.start();
            try (BufferedReader output = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                while ((line = output.readLine()) != null) {
                    if (!line.startsWith("alloc.rexx:")) {
                        outMsgs.append(line);
                        outMsgs.append("\n");
                    }
                    this.log.info(line);
                }
            }
            rc = p.waitFor();
        }
        catch (IOException ioEx) {
            this.log.log(Level.WARNING, logMsg, ioEx);
            outMsgs.append(msg);
            exMsg = ioEx.getMessage();
            if (null != exMsg) {
                outMsgs.append(exMsg.replace(":", "\n"));
            }
        }
        catch (InterruptedException iEx) {
            this.log.log(Level.WARNING, logMsg, iEx);
            outMsgs.append(msg);
            exMsg = iEx.getMessage();
            if (null != exMsg) {
                outMsgs.append(exMsg.replace(":", "\n"));
            }
        }
        finally {
            if (null != p) {
                p.destroy();
            }
        }
        return rc;
    }

    private String arrayAsString(String[] array) {
        StringBuffer result = new StringBuffer();
        for (String s : array) {
            result.append(s + " ");
        }
        return result.toString();
    }

    private String getCommandAlloc() {
        return this.commandAlloc;
    }

    private String getCommandFindvol() {
        return this.commandFindvol;
    }

    private Properties getDsProperties() {
        return this.dsProperties;
    }

    private String getPropPrefix() {
        return this.propPrefix;
    }

    private SSNResource getBundle() {
        return this.bundle;
    }

    private SSNResource getEnBundle() {
        return this.enBundle;
    }
}

