/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.view;

import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.view.CustMsgBox;
import com.sas.tools.installs.it.view.KitHelp;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.it.view.WizardPanelIface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class Wizard
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -1552508274681083934L;
    protected static Logger log = (Logger)LogManager.getLogger(Wizard.class);
    private final int INITIAL_WIDTH = 650;
    private final int INITIAL_HEIGHT = 500;
    private final int MIN_WIDTH = 550;
    private final int MIN_HEIGHT = 400;
    public static SSNResource bundle = new SSNResource(Wizard.class);
    private final KitHelp m_helpDlg = new KitHelp(this);
    private WizardPanelIface m_currentPanel = null;
    private final JPanel m_contentPane = new JPanel(new GridBagLayout());
    private final JPanel m_headerPanel = new JPanel(new GridBagLayout());
    private final JPanel m_gutsPanel = new JPanel(new GridBagLayout());
    private final JPanel m_fillerPanel = new JPanel();
    private final JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JLabel m_header = null;
    private JTextArea m_headerDesc = null;
    private ImageIcon m_bannerRight = null;
    private JLabel m_bannerLabelRight = null;
    private final JSeparator m_separator = new JSeparator();
    private final JSeparator m_buttonSeparator = new JSeparator();
    private JButton m_cancelButton = null;
    private JButton m_nextButton = null;
    private JButton m_backButton = null;
    private JButton m_helpButton = null;
    private Hashtable<String, WizardPanelIface> m_panelsHash = null;
    private final LinkedList<String> m_wizardChain = new LinkedList();
    private final PrintWriter m_responseFile = null;
    private final PrintWriter m_chainResponseFile = null;
    private String m_currentPanelID = null;
    private boolean m_wizardActive = true;
    private boolean complete = false;
    private cKeyHandler m_keyHandler;
    protected Controller _controller;

    public Wizard(Hashtable<String, WizardPanelIface> panels, String startingPanel, Controller controller) {
        this._controller = controller;
        this.m_panelsHash = panels;
        this.m_currentPanelID = startingPanel;
        this.m_currentPanel = this.m_panelsHash.get(this.m_currentPanelID);
        if (!this.m_currentPanel.displayPanel()) {
            this.m_currentPanelID = this.getNextPanelID(true);
            if (this.m_currentPanelID != null) {
                this.m_currentPanel = this.m_panelsHash.get(this.m_currentPanelID);
            }
        }
        if (!Controller.silent && this.m_currentPanelID != null) {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Wizard.this.onCancel();
                }
            });
            this.m_keyHandler = new cKeyHandler();
            this.initialize();
            this.layoutWidgets();
            this.pack();
            this.resizeButtons();
            this.setSize(new Dimension(650, 500));
            this.setLocationRelativeTo(null);
            ImageIcon wizardIcon = bundle.getImageIcon("Common.icon.image");
            if (wizardIcon != null) {
                this.setIconImage(wizardIcon.getImage());
            }
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int width = Wizard.this.getWidth();
                    int height = Wizard.this.getHeight();
                    if (width < 550) {
                        width = 550;
                    }
                    if (height < 400) {
                        height = 400;
                    }
                    Wizard.this.setSize(width, height);
                }
            });
        }
    }

    @Override
    public void show() {
        if (!Controller.silent) {
            this.loadPanel();
            super.show();
        } else {
            this.exitWizard(0);
        }
    }

    private void initialize() {
        this.m_header = new JLabel();
        this.m_header.setOpaque(true);
        this.m_header.setBackground(Color.WHITE);
        Font headerFont = this.m_header.getFont();
        this.m_header.setFont(headerFont.deriveFont(1));
        this.m_headerDesc = new JTextArea();
        this.m_headerDesc.setEditable(false);
        this.m_headerDesc.setFocusable(false);
        this.m_headerDesc.setLineWrap(true);
        this.m_headerDesc.setWrapStyleWord(true);
        this.m_headerDesc.setOpaque(true);
        this.m_headerDesc.setBackground(Color.WHITE);
        this.m_bannerRight = bundle.getImageIcon("Wizard.banner_right.image");
        this.m_bannerLabelRight = new JLabel(this.m_bannerRight, 0);
        this.m_bannerLabelRight.setOpaque(true);
        this.m_bannerLabelRight.setBackground(Color.WHITE);
        String mtxt = bundle.getString("Wizard.Help.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        int mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_helpButton = new JButton(txt);
        this.m_helpButton.setMnemonic(mkey);
        mtxt = bundle.getString("Wizard.Next.txt");
        txt = Util.getLabelWithoutMnemonic(mtxt);
        mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_nextButton = new JButton(txt);
        this.m_nextButton.setMnemonic(mkey);
        mtxt = bundle.getString("Wizard.Back.txt");
        txt = Util.getLabelWithoutMnemonic(mtxt);
        mkey = Util.getDisplayedMnemonic(mtxt);
        this.m_backButton = new JButton(txt);
        this.m_backButton.setMnemonic(mkey);
        this.m_cancelButton = new JButton(bundle.getString("Common.Cancel.txt"));
        this.m_cancelButton.addActionListener(this);
        this.m_nextButton.addActionListener(this);
        this.m_backButton.addActionListener(this);
        this.m_helpButton.addActionListener(this);
        this.setTitle(bundle.getString("Common.Title.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_cancelButton) {
            this.onCancel();
        } else if (src == this.m_nextButton) {
            this.onNext();
        } else if (src == this.m_backButton) {
            this.onBack();
        } else if (src == this.m_helpButton) {
            this.onHelp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitWizard(int exitCode) {
        if (!Controller.silent) {
            this.saveWizardResponses();
        }
        if (this.m_responseFile != null) {
            this.m_responseFile.close();
        }
        if (this.m_chainResponseFile != null) {
            this.m_chainResponseFile.close();
        }
        this.dispose();
        Wizard wizard = this;
        synchronized (wizard) {
            this.complete = true;
            this.notify();
        }
    }

    private void onCancel() {
        boolean valid = false;
        String closeMsg = this.m_currentPanel.getCancelMsg();
        if (closeMsg == null && this.m_wizardActive) {
            closeMsg = bundle.messageString("Wizard.CloseEndMsg.txt", bundle.getString("Common.Title.txt"));
        }
        if (CustMsgBox.showConfirmDialog((Component)this, closeMsg, this.getTitle(), 0, 3, 1) == 0) {
            valid = true;
        }
        if (valid) {
            this.m_helpDlg.dispose();
            if (this.m_currentPanel.onCancel()) {
                this.exitWizard(-1);
            }
        } else {
            this.m_currentPanel.cancelCancelled();
        }
    }

    public void onNext() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_currentPanel.validateData()) {
            String nextPanel = this.getNextPanelID(true);
            if (nextPanel != null) {
                this.m_wizardChain.add(this.m_currentPanelID);
                this.m_currentPanelID = nextPanel;
                this.m_currentPanel = this.m_panelsHash.get(this.m_currentPanelID);
                if (this.m_currentPanelID != null) {
                    this.loadPanel();
                } else {
                    this.exitWizard(0);
                }
            } else {
                this.exitWizard(0);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void onBack() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_currentPanel.backEvent();
        this.m_currentPanelID = this.m_wizardChain.removeLast();
        this.m_currentPanel = this.m_panelsHash.get(this.m_currentPanelID);
        this.loadPanel();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void loadPanel() {
        this.m_header.setText(this.m_currentPanel.getHeader());
        this.m_headerDesc.setText(this.m_currentPanel.getHeaderDesc());
        if (this.isVisible()) {
            this.removeKeyListeners(this.m_gutsPanel, this.m_keyHandler);
        }
        this.m_gutsPanel.removeAll();
        this.layoutGuts();
        this.adjustConstraints();
        this.enableButtons();
        this.m_currentPanel.preShowUpdates(this);
        if (this.isVisible()) {
            this.addKeyListeners(this.m_gutsPanel, this.m_keyHandler);
        }
        this.validate();
        this.repaint();
        if (this.m_currentPanel.initialFocus() == null) {
            this.m_currentPanel.getPanel().requestFocus();
            this.m_currentPanel.getPanel().transferFocus();
        } else {
            this.m_currentPanel.initialFocus().requestFocus();
        }
        this.m_helpDlg.setHelp(this.m_currentPanel.getHelpTopic());
    }

    private void adjustConstraints() {
        this.m_contentPane.remove(this.m_gutsPanel);
        this.m_contentPane.remove(this.m_fillerPanel);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridy = 2;
        if (this.m_currentPanel.staticHeight()) {
            c.weighty = 0.0;
            c.fill = 2;
        } else {
            c.weighty = 1.0;
            c.fill = 1;
        }
        c.anchor = 11;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_contentPane.add((Component)this.m_gutsPanel, c);
        c.gridy = 3;
        if (this.m_currentPanel.staticHeight()) {
            c.weighty = 1.0;
            c.fill = 1;
        } else {
            c.weighty = 0.0;
            c.fill = 2;
        }
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_contentPane.add((Component)this.m_fillerPanel, c);
    }

    private void onHelp() {
        this.m_helpDlg.show();
    }

    public void enableButtons() {
        this.m_helpButton.setEnabled(this.m_currentPanel.getHelpTopic() != null);
        this.m_backButton.setEnabled(this.m_wizardChain.size() > 0);
        if (this.getNextPanelID(false) == null) {
            String mtxt = bundle.getString("Wizard.Finish.txt");
            String txt = Util.getLabelWithoutMnemonic(mtxt);
            int mkey = Util.getDisplayedMnemonic(mtxt);
            this.m_nextButton.setText(txt);
            this.m_nextButton.setMnemonic(mkey);
            this.m_cancelButton.setEnabled(this.m_wizardActive);
        } else {
            String mtxt = bundle.getString("Wizard.Next.txt");
            String txt = Util.getLabelWithoutMnemonic(mtxt);
            int mkey = Util.getDisplayedMnemonic(mtxt);
            this.m_nextButton.setText(txt);
            this.m_nextButton.setMnemonic(mkey);
            this.m_cancelButton.setEnabled(true);
        }
        this.getRootPane().setDefaultButton(this.m_nextButton);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        this.layoutHeader();
        c.gridy = 0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_contentPane.add((Component)this.m_headerPanel, c);
        c.gridy = 1;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 11;
        c.insets = new Insets(0, 1, 0, 1);
        this.m_contentPane.add((Component)this.m_separator, c);
        this.loadPanel();
        c.gridy = 4;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(0, 1, 0, 1);
        this.m_contentPane.add((Component)this.m_buttonSeparator, c);
        this.layoutButtons();
        c.gridy = 5;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_contentPane.add((Component)this.m_buttonPanel, c);
        this.m_contentPane.setOpaque(true);
        this.setContentPane(this.m_contentPane);
        this.addKeyListeners(this, this.m_keyHandler);
    }

    private void layoutHeader() {
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 15, 0, 0);
        this.m_headerPanel.add((Component)this.m_header, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(3, 30, 5, 0);
        this.m_headerPanel.add((Component)this.m_headerDesc, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_headerPanel.add((Component)this.m_bannerLabelRight, c);
        this.m_headerPanel.setOpaque(true);
        this.m_headerPanel.setBackground(Color.WHITE);
    }

    private void layoutGuts() {
        if (this.m_currentPanel != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.anchor = 18;
            c.insets = new Insets(0, 0, 0, 0);
            this.m_gutsPanel.add((Component)this.m_currentPanel.getPanel(), c);
        }
    }

    public void replaceContentWithJPanel(JPanel content) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(5, 15, 0, 0);
        this.m_contentPane.add((Component)content, c);
    }

    private void layoutButtons() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.insets = new Insets(15, 15, 15, 0);
        this.m_buttonPanel.add((Component)this.m_helpButton, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.insets = new Insets(15, 0, 15, 0);
        this.m_buttonPanel.add((Component)this.m_backButton, c);
        c.gridx = 2;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(15, 0, 15, 10);
        this.m_buttonPanel.add((Component)this.m_nextButton, c);
        c.gridx = 3;
        c.weightx = 0.0;
        c.anchor = 13;
        c.insets = new Insets(15, 0, 15, 15);
        this.m_buttonPanel.add((Component)this.m_cancelButton, c);
    }

    public void resizeButtons() {
        Dimension buttonSize = this.m_cancelButton.getSize();
        double maxWidth = buttonSize.getWidth();
        double maxHeight = buttonSize.getHeight();
        if ((buttonSize = this.m_nextButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if ((buttonSize = this.m_backButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if ((buttonSize = this.m_helpButton.getSize(buttonSize)).getWidth() > maxWidth) {
            maxWidth = buttonSize.getWidth();
        }
        if (buttonSize.getHeight() > maxHeight) {
            maxHeight = buttonSize.getHeight();
        }
        if (maxWidth < 75.0) {
            maxWidth = 75.0;
        }
        if (maxHeight < 23.0) {
            maxHeight = 23.0;
        }
        buttonSize.setSize(maxWidth, maxHeight);
        this.m_cancelButton.setPreferredSize(buttonSize);
        this.m_nextButton.setPreferredSize(buttonSize);
        this.m_backButton.setPreferredSize(buttonSize);
        this.m_helpButton.setPreferredSize(buttonSize);
    }

    public JButton getCancelButton() {
        return this.m_cancelButton;
    }

    public JButton getNextButton() {
        return this.m_nextButton;
    }

    public JButton getBackButton() {
        return this.m_backButton;
    }

    public JButton getHelpButton() {
        return this.m_helpButton;
    }

    public JLabel getHeader() {
        return this.m_header;
    }

    public JTextArea getHeaderDesc() {
        return this.m_headerDesc;
    }

    public String getWizardTitle() {
        return this.getTitle();
    }

    public void setWizardActive(boolean active) {
        this.m_wizardActive = active;
    }

    public boolean getWizardActive() {
        return this.m_wizardActive;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void addPanel(String panelID, WizardPanelIface panel) {
        this.m_panelsHash.remove(panelID);
        this.m_panelsHash.put(panelID, panel);
    }

    public void removePanel(String panelID) {
        this.m_panelsHash.remove(panelID);
    }

    public void clearWizardChain(boolean saveResponses) {
        if (saveResponses) {
            this.saveWizardResponses();
        }
        this.m_wizardChain.clear();
    }

    public Object getPanel(String panelID) {
        return this.m_panelsHash.get(panelID);
    }

    public void saveWizardResponses() {
    }

    public static void logResponseMissing(String panel, String field) {
        log.error("Response data missing for:\n   Panel: " + panel + "\n   Field: " + field);
    }

    public static void logResponseInvalid(String panel, String field, String value, String notes) {
        String logEntry = "Response data invalid for:\n   Panel: " + panel + "\n   Field: " + field + "\n   Value: " + value;
        if (notes != null) {
            logEntry = logEntry + "\n   Notes: " + notes;
        }
        log.error(logEntry);
    }

    private String getNextPanelID(boolean loadPanels) {
        String nextPanelID = null;
        try {
            nextPanelID = this.m_currentPanel.getNextPanelID();
        }
        catch (Exception e) {
            try {
                this.getController().getView().applicationFailure(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (nextPanelID != null) {
            WizardPanelIface panel = this.m_panelsHash.get(nextPanelID);
            boolean found = panel.displayPanel();
            while (!found) {
                if (loadPanels) {
                    panel.initializePanel();
                }
                nextPanelID = panel.getNextPanelID();
                panel = this.m_panelsHash.get(nextPanelID);
                found = panel.displayPanel();
            }
            if (!found) {
                nextPanelID = null;
            }
        }
        return nextPanelID;
    }

    private void addKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].addKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.addKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    private void removeKeyListeners(Container container, cKeyHandler keyHandler) {
        Component[] componentArray = container.getComponents();
        int nComps = componentArray.length;
        for (int iComp = 0; iComp < nComps; ++iComp) {
            componentArray[iComp].removeKeyListener(keyHandler);
            if (!(componentArray[iComp] instanceof Container)) continue;
            this.removeKeyListeners((Container)componentArray[iComp], keyHandler);
        }
    }

    public Controller getController() {
        return this._controller;
    }

    public void setController(Controller controller) {
        this._controller = controller;
    }

    private class cKeyHandler
    extends KeyAdapter {
        private cKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int eKeyCode = e.getKeyCode();
            switch (eKeyCode) {
                case 27: {
                    Wizard.this.onCancel();
                    break;
                }
                case 112: 
                case 156: {
                    Wizard.this.onHelp();
                }
            }
        }
    }
}

