/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.view;

import com.sas.tools.installs.it.view.DocClassLoader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class SSNResource {
    protected Logger log = (Logger)LogManager.getLogger("com.sas.mit.view.SSNResource");
    protected static Hashtable m_bundleCache;
    protected static Hashtable<String, ResourceBundle> enBundleCache;
    protected boolean m_bResourceFileMissing = false;
    protected String m_strResourceFileName;
    protected ResourceBundle m_bundle;
    protected ClassLoader m_classLoader;

    public SSNResource(String strResourceFileName) {
        this.m_bundle = this._getBundle(strResourceFileName);
    }

    public SSNResource() {
    }

    public SSNResource(String strResourceFileName, ClassLoader classLoader) {
        this.m_classLoader = classLoader;
        this.m_bundle = this._getBundle(strResourceFileName, classLoader);
    }

    public static SSNResource EnglishResource(Class source) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        return SSNResource.EnglishResource(strPackageName + ".PropertyBundle");
    }

    public static SSNResource EnglishResource(String strResourceFileName) {
        SSNResource retval = new SSNResource();
        retval.m_bundle = retval._getEnglishBundle(strResourceFileName);
        return retval;
    }

    public static SSNResource EnglishResource(String strResourceFileName, ClassLoader classLoader) {
        SSNResource retval = new SSNResource();
        retval.m_bundle = retval._getEnglishBundle(strResourceFileName, classLoader);
        return retval;
    }

    public SSNResource(Class source) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this._getBundle(strPackageName + ".PropertyBundle");
    }

    protected ResourceBundle getCachedBundle(String key) {
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        }
        return (ResourceBundle)m_bundleCache.get(key);
    }

    protected ResourceBundle getCachedEnBundle(String key) {
        if (enBundleCache == null) {
            enBundleCache = new Hashtable();
        }
        return enBundleCache.get(key);
    }

    protected void cacheBundle(String key, ResourceBundle bundle) {
        m_bundleCache.put(key, bundle);
    }

    protected void cacheEnBundle(String key, ResourceBundle bundle) {
        enBundleCache.put(key, bundle);
    }

    protected ResourceBundle _getBundle(String strBundlePath) {
        return this._getBundle(strBundlePath, null);
    }

    protected ResourceBundle _getEnglishBundle(String strBundlePath) {
        return this._getEnglishBundle(strBundlePath, null);
    }

    protected ResourceBundle _getBundle(String strBundlePath, ClassLoader classLoader) {
        ResourceBundle returnValue;
        String cacheKey = strBundlePath;
        if (classLoader != null) {
            cacheKey = classLoader instanceof DocClassLoader ? cacheKey + ((DocClassLoader)classLoader).getPath() : cacheKey + classLoader.hashCode();
        }
        if ((returnValue = this.getCachedBundle(cacheKey)) != null) {
            return returnValue;
        }
        Locale locale = null;
        String userLang = System.getProperty("user.language");
        if (userLang != null) {
            String reigion = System.getProperty("user.country");
            String resultLang = userLang;
            if (userLang.equalsIgnoreCase("zh") && (reigion.equalsIgnoreCase("HK") || reigion.equalsIgnoreCase("TW"))) {
                resultLang = "zt";
            }
            locale = new Locale(resultLang);
        }
        if (locale == null) {
            locale = Locale.US;
        }
        try {
            returnValue = classLoader != null ? ResourceBundle.getBundle(strBundlePath, locale, classLoader) : ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                returnValue = classLoader != null ? PropertyResourceBundle.getBundle(strBundlePath, locale, classLoader) : PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                this.m_bResourceFileMissing = true;
                return null;
            }
        }
        if (classLoader == null) {
            this.cacheBundle(strBundlePath, returnValue);
        } else if (classLoader instanceof DocClassLoader) {
            this.cacheBundle(strBundlePath + ((DocClassLoader)classLoader).getPath(), returnValue);
        } else {
            this.cacheBundle(strBundlePath + classLoader.hashCode(), returnValue);
        }
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    protected ResourceBundle _getEnglishBundle(String strBundlePath, ClassLoader classLoader) {
        ResourceBundle returnValue = this.getCachedEnBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = Locale.US;
        try {
            returnValue = classLoader != null ? ResourceBundle.getBundle(strBundlePath, locale, classLoader) : ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                returnValue = classLoader != null ? PropertyResourceBundle.getBundle(strBundlePath, locale, classLoader) : PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                this.m_bResourceFileMissing = true;
                return null;
            }
        }
        if (classLoader == null) {
            this.cacheEnBundle(strBundlePath, returnValue);
        } else {
            this.cacheEnBundle(strBundlePath + classLoader.hashCode(), returnValue);
        }
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    public void clearBundleCache() {
        m_bundleCache.clear();
    }

    public void clearEnBundleCache() {
        enBundleCache.clear();
    }

    public String getString(String key) {
        String retValue;
        block5: {
            retValue = "";
            if (this.m_bundle == null) {
                try {
                    throw new Throwable();
                }
                catch (Throwable t) {
                    this.log.warn("No localization resources defined for key #" + key + ".  Skipping Resolution.");
                    break block5;
                }
            }
            try {
                retValue = this.m_bundle.getString(key);
            }
            catch (Throwable t) {
                retValue = "No localization resources defined for key #" + key + ".  Skipping Resolution.";
                System.err.println(retValue + ". Have you copied your resources?");
                System.err.println("Missing resource is called from the following:");
                this.log.warn(retValue);
                t.printStackTrace();
            }
        }
        return retValue;
    }

    public String getRawString(String key) {
        String retValue = null;
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            try {
                retValue = this.m_bundle.getString(key);
                retValue = retValue.trim();
            }
            catch (Throwable t) {
                this.log.warn("No localization resources defined for key #" + key + ".  Skipping Resolution.");
            }
        }
        return retValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        try {
            String strValue = this.m_bundle.getString(key);
            return new Integer(strValue);
        }
        catch (Throwable t) {
            this.log.warn("No localization resources defined for key #" + key + ".  Skipping Resolution.");
            return notFoundReturnValue;
        }
    }

    public ImageIcon getImageIcon(String sResourceName) {
        if (sResourceName == null) {
            return null;
        }
        ImageIcon image = null;
        String sImagePath = this.getString("ImageLocation.notrans") + this.getString(sResourceName);
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        } else {
            image = (ImageIcon)m_bundleCache.get(sImagePath);
            if (image != null) {
                return image;
            }
        }
        try {
            URL url = ClassLoader.getSystemResource(sImagePath);
            image = new ImageIcon(url);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage());
            e.printStackTrace();
            String sDefaultPath = this.getString("ImageLocation.notrans") + this.getString("Common.Default.Image");
            try {
                URL urlDefault = this.m_classLoader.getResource(sDefaultPath);
                image = new ImageIcon(urlDefault);
            }
            catch (Exception e2) {
                this.log.warn(e2.getMessage());
            }
        }
        if (image != null) {
            m_bundleCache.put(sImagePath, image);
        }
        return image;
    }

    public String messageString(String key) {
        String pattern = this.getString(key);
        return pattern;
    }

    public String messageString(String key, Object ... parms) {
        String pattern = this.getString(key);
        return MessageFormat.format(pattern, parms);
    }
}

