/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deploy.util.SASRuntimeWrapper;
import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.tasks.Globals;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.LogLineWriter;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.resource.InputStreamConsumer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class TaskHelper {
    public static final int OS_UNDEFINED = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_HPUX = 4;
    public static final int OS_AIX = 5;
    public static final int OS_OPENVMS = 6;
    public static final int OS_ALX = 7;
    public static final int OS_MVS = 8;
    public static final int OS_MAC = 9;
    public static final String OS_SUFFIX_SAX = "sax";
    public static final String OS_SUFFIX_S64 = "s64";
    public static final String OS_SUFFIX_LIX = "lix";
    public static final String OS_SUFFIX_LAX = "lax";
    public static final String OS_SUFFIX_LNX = "lnx";
    public static final String OS_SUFFIX_H6I = "h6i";
    public static final String OS_SUFFIX_H64 = "h64";
    public static final String OS_SUFFIX_R64 = "r64";
    public static final String OS_SUFFIX_ALX = "alx";
    public static final String OS_SUFFIX_W64 = "w64";
    public static final String OS_SUFFIX_WX6 = "wx6";
    public static final String OS_SUFFIX_WIN = "win";
    public static final String OS_SUFFIX_MVS = "mvs";
    public static final String OS_SUFFIX_MAC = "mac";
    public static final String OS_SUFFIX_VMI = "vmi";
    protected static Logger log = (Logger)LogManager.getLogger(TaskHelper.class);
    protected static int gc_count = 0;
    protected static int m_os = 0;
    protected static String m_osSuffix = null;
    private static SSNResource _bundle = new SSNResource(InstallationTask.class);
    protected static boolean m_isunix = false;

    public static int getOS(boolean realValue) {
        int rc = 0;
        String osName = System.getProperty("os.name");
        if (!realValue) {
            rc = TaskHelper.getOS();
        } else if (osName.startsWith("Windows")) {
            rc = 1;
        } else if (osName.equalsIgnoreCase("Linux")) {
            rc = 2;
        } else if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
            rc = 3;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            rc = 4;
        } else if (osName.equalsIgnoreCase("AIX")) {
            rc = 5;
        } else if (osName.equalsIgnoreCase("OpenVMS")) {
            rc = 6;
        } else if (osName.equalsIgnoreCase("Compaq's Digital UNIX") || osName.equalsIgnoreCase("OSF1")) {
            rc = 7;
        } else if (osName.equalsIgnoreCase("z/OS")) {
            rc = 8;
        } else if (osName.startsWith("Mac")) {
            rc = 9;
        } else if (osName.startsWith("OpenVMS")) {
            rc = 6;
        }
        return rc;
    }

    public static boolean isUnix() {
        if (m_os != 0) {
            return m_isunix;
        }
        TaskHelper.getOS();
        return m_isunix;
    }

    public static boolean isWindows() {
        return TaskHelper.getOS() == 1;
    }

    public static int getOS() {
        int rc = 0;
        if (m_os != 0) {
            rc = m_os;
        } else {
            if (Globals.g_debugPlatform != null) {
                if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_SAX) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_S64)) {
                    rc = 3;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_LIX) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_LAX) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_LNX)) {
                    rc = 2;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_H6I) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_H64)) {
                    rc = 4;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_R64)) {
                    rc = 5;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_VMI)) {
                    rc = 6;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_ALX)) {
                    rc = 7;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_W64) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_WX6) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_WIN)) {
                    rc = 1;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_MVS)) {
                    rc = 8;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_MAC)) {
                    rc = 9;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_VMI)) {
                    rc = 6;
                }
            } else {
                rc = TaskHelper.getOS(true);
            }
            m_os = rc;
            if (rc == 2 || rc == 3 || rc == 4 || rc == 5 || rc == 7) {
                m_isunix = true;
            }
        }
        return rc;
    }

    private static boolean isWindows64OS() {
        return System.getenv("ProgramFiles(x86)") != null;
    }

    private static boolean is32bJavaOn64bWin() {
        boolean is32bJavaProcess;
        boolean is64OS = TaskHelper.isWindows64OS();
        String osArch = System.getProperty("os.arch");
        boolean bl = is32bJavaProcess = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
        return is64OS && is32bJavaProcess;
    }

    private static boolean is64bJavaOn64bWin() {
        boolean is32bJavaProcess;
        boolean is64OS = TaskHelper.isWindows64OS();
        String osArch = System.getProperty("os.arch");
        boolean bl = is32bJavaProcess = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
        return is64OS && !is32bJavaProcess;
    }

    public static String getOS_Suffix() {
        String suffix = "";
        if (m_osSuffix != null) {
            suffix = m_osSuffix;
        } else {
            if (Globals.g_debugPlatform != null) {
                suffix = Globals.g_debugPlatform;
            } else {
                String osArch = System.getProperty("os.arch");
                boolean itanium = osArch.length() >= 4 && osArch.substring(0, 4).equalsIgnoreCase("ia64");
                boolean x86 = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
                boolean x86_64 = osArch.length() >= 5 && osArch.substring(0, 5).equalsIgnoreCase("amd64");
                switch (TaskHelper.getOS()) {
                    case 3: {
                        if (x86) {
                            suffix = OS_SUFFIX_SAX;
                            break;
                        }
                        if (x86_64) {
                            suffix = OS_SUFFIX_SAX;
                            break;
                        }
                        suffix = OS_SUFFIX_S64;
                        break;
                    }
                    case 2: {
                        if (!x86_64) {
                            try {
                                String[] cmd = new String[]{"uname", "-m"};
                                Process p = Runtime.getRuntime().exec(cmd);
                                BufferedInputStream in = new BufferedInputStream(p.getInputStream());
                                byte[] output = new byte[6];
                                in.read(output, 0, 6);
                                if (new String(output).equals("x86_64")) {
                                    x86_64 = true;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (itanium) {
                            suffix = OS_SUFFIX_LIX;
                            break;
                        }
                        if (x86_64) {
                            suffix = OS_SUFFIX_LAX;
                            break;
                        }
                        suffix = OS_SUFFIX_LNX;
                        break;
                    }
                    case 4: {
                        if (itanium) {
                            suffix = OS_SUFFIX_H6I;
                            break;
                        }
                        suffix = OS_SUFFIX_H64;
                        break;
                    }
                    case 5: {
                        suffix = OS_SUFFIX_R64;
                        break;
                    }
                    case 6: {
                        suffix = OS_SUFFIX_VMI;
                        break;
                    }
                    case 7: {
                        suffix = OS_SUFFIX_ALX;
                        break;
                    }
                    case 1: {
                        if (itanium) {
                            suffix = OS_SUFFIX_W64;
                            break;
                        }
                        if (TaskHelper.is32bJavaOn64bWin()) {
                            suffix = OS_SUFFIX_WX6;
                            break;
                        }
                        if (TaskHelper.is64bJavaOn64bWin()) {
                            suffix = OS_SUFFIX_WX6;
                            break;
                        }
                        suffix = OS_SUFFIX_WIN;
                        break;
                    }
                    case 8: {
                        suffix = OS_SUFFIX_MVS;
                        break;
                    }
                    case 9: {
                        suffix = OS_SUFFIX_MAC;
                    }
                }
            }
            m_osSuffix = suffix;
        }
        return suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeProcess(String command, String script, String rcLog) throws IOException, InterruptedException {
        int returnCode = -1;
        if (TaskHelper.getOS() == 1) {
            Process p = SASRuntimeWrapper.getRuntime().exec(command);
            p.waitFor();
            returnCode = p.exitValue();
        } else if (TaskHelper.getOS() != 6) {
            if (command.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            File scriptFile = new File(script);
            File rcFile = new File(rcLog);
            PrintStream out = new PrintStream(new FileOutputStream(scriptFile));
            out.println("#!/bin/sh");
            out.println("if [ -x /usr/bin/echo ]; then ");
            out.println("  echo=/usr/bin/echo");
            out.println("elif [ -x /bin/echo ] ; then ");
            out.println("  echo=/bin/echo");
            out.println("fi");
            out.println("if [ -f \"" + rcFile.getAbsolutePath() + "\" ]; then ");
            out.println("  rm -f \"" + rcFile.getAbsolutePath() + "\"");
            out.println("fi");
            out.println(command);
            out.println("$echo $? >\"" + rcFile.getAbsolutePath() + "\"");
            out.close();
            try {
                if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, DiskInfoAPI.libNames)) {
                    String missingLib = JNIUtils.getJniLib(DiskInfoAPI.libNames);
                    throw new InstallException(2, null, _bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
                }
                DiskInfoAPI.SetFileMode(scriptFile.getAbsolutePath(), 755);
                String[] cmd = new String[]{"/bin/sh", "-c", script};
                Process p = Runtime.getRuntime().exec(cmd);
                p.waitFor();
            }
            finally {
                if (scriptFile.isFile() && !Globals.g_debug) {
                    scriptFile.delete();
                }
                if (rcFile.isFile()) {
                    try {
                        BufferedReader in = new BufferedReader(new FileReader(rcFile));
                        returnCode = Integer.parseInt(in.readLine());
                        in.close();
                        in = null;
                    }
                    catch (Exception exception) {}
                    if (!Globals.g_debug) {
                        rcFile.delete();
                    }
                }
            }
        }
        return returnCode;
    }

    public static String executeCommand(String command) {
        return TaskHelper.executeCommand(command, true);
    }

    public static String executeCommand(String command, boolean wait) {
        int intp = -1;
        String results = "";
        LogLineWriter stdOutWriter = new LogLineWriter(log, Level.INFO, "info: ");
        LogLineWriter stdErrWriter = new LogLineWriter(log, Level.ERROR, "error: ");
        try {
            Process process = SASRuntimeWrapper.getRuntime().exec(command);
            InputStreamConsumer stdoutConsumer = new InputStreamConsumer(process.getInputStream(), stdOutWriter);
            InputStreamConsumer stderrConsumer = new InputStreamConsumer(process.getErrorStream(), stdErrWriter);
            stdoutConsumer.start();
            stderrConsumer.start();
            intp = process.waitFor();
            results = intp == 0 ? command + " was done successfully." : command + " failed";
        }
        catch (Exception e) {
            log.error("Could not run " + command + "\n" + e);
        }
        return results;
    }

    public static InputStream getResourceInputStream(Class<?> cl, String resourcePath) {
        InputStream is = cl.getClassLoader().getResourceAsStream(resourcePath);
        return is;
    }

    public static String getResourceString(Class<?> cl, String resourcePath) throws IOException {
        InputStream is = TaskHelper.getResourceInputStream(cl, resourcePath);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer resourceBuffer = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            resourceBuffer.append(line);
            resourceBuffer.append("\n");
        }
        return resourceBuffer.toString();
    }

    public static void getResourceFile(Class<?> cl, String resourcePath, File destFile) throws IOException {
        InputStream is = TaskHelper.getResourceInputStream(cl, resourcePath);
        FileOutputStream fos = new FileOutputStream(destFile);
        int max = 65536;
        boolean offset = false;
        byte[] buffer = new byte[65536];
        int len = 0;
        while ((len = is.read(buffer, 0, 65536)) > 0) {
            fos.write(buffer, 0, len);
        }
        is.close();
        fos.close();
    }

    public static String getDescriptionForLog(String taskName, Map<String, String> args) {
        StringBuffer description = new StringBuffer();
        description.append(taskName);
        description.append("\n\t");
        for (String key : args.keySet()) {
            String val = args.get(key);
            description.append(key);
            description.append(": ");
            description.append(val);
            description.append("\n\t");
        }
        description.setLength(description.length() - 1);
        return description.toString();
    }

    public static void resetMOS() {
        m_os = 0;
    }

    public static String join(Collection<?> parts, String delimiter) {
        if (parts == null) {
            parts = Collections.EMPTY_LIST;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object part : parts) {
            sb.append(part != null ? part.toString() : "");
            sb.append(delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    public static void extractTaz(String tazFile, String destDir) throws InstallException {
        int rc = -1;
        try {
            String DATE_FORMAT_NOW = "yyyy-MM-dd-HH.mm.ss";
            Date backupDate = Calendar.getInstance().getTime();
            String tazLogFilenameFormat = "'tazscript_'yyyy-MM-dd-HH.mm.ss'.log'";
            SimpleDateFormat sdf = new SimpleDateFormat(tazLogFilenameFormat);
            String tazLogFile = sdf.format(backupDate);
            File destDirFile = new File(destDir);
            if (!destDirFile.exists()) {
                destDirFile.mkdirs();
            }
            File logDir = Controller.defaultController().getLogPath();
            File scriptFile = new File(logDir, "tazscript");
            PrintStream out = new PrintStream(new FileOutputStream(scriptFile));
            out.println("#!/bin/sh");
            out.println("if [ -x /usr/bin/echo ]; then ");
            out.println("  echo=/usr/bin/echo");
            out.println("elif [ -x /bin/echo ] ; then ");
            out.println("  echo=/bin/echo");
            out.println("else ");
            out.println("  echo=echo");
            out.println("fi");
            out.println("cd " + destDir);
            out.println("zcat <" + tazFile + " | tar xvf - 1>" + logDir.getAbsolutePath() + "/" + tazLogFile + " 2>&1");
            out.close();
            String[] cmd = new String[]{"chmod", "755", scriptFile.getAbsolutePath()};
            Process scriptProc = Runtime.getRuntime().exec(cmd);
            scriptProc.waitFor();
            scriptProc = null;
            String[] command = new String[]{"/bin/sh", "-c", scriptFile.getAbsolutePath()};
            Process runCmd = Runtime.getRuntime().exec(command);
            rc = runCmd.waitFor();
        }
        catch (Exception e) {
            String msg = "Error extracting: " + tazFile;
            throw new InstallException(2, null, msg, msg, e);
        }
        if (rc != 0) {
            String msg = "Extracting " + tazFile + " failed with the following return code: " + rc;
            throw new InstallException(2, null, msg, msg, null);
        }
    }

    public static void extractZip(File sourceFile, String targetDir) throws InstallException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(sourceFile);
            List<File> filesToExtract = TaskHelper.getFilesToExtract(zipFile);
            TaskHelper.extractFilesFromZip(zipFile, filesToExtract, targetDir);
        }
        catch (Exception e) {
            String msg = "Error extracting: " + sourceFile.getAbsolutePath();
            throw new InstallException(2, null, msg, msg, e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close zip file " + sourceFile.getAbsolutePath());
                }
            }
        }
    }

    private static List<File> getFilesToExtract(ZipFile zipFile) throws InstallException {
        ArrayList<File> filesToExtract = new ArrayList<File>();
        try {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                filesToExtract.add(new File(zipEntry.getName()));
            }
        }
        catch (Exception e) {
            String msg = "Error determining list of files to extract from: " + zipFile.getName();
            throw new InstallException(2, null, msg, msg, e);
        }
        return filesToExtract;
    }

    private static void extractFilesFromZip(ZipFile zipFile, List<File> filesToExtract, String extractLocation) throws InstallException {
        try {
            for (File fileToExtract : filesToExtract) {
                TaskHelper.extractFileFromZip(zipFile, fileToExtract, extractLocation);
            }
        }
        catch (Exception e) {
            String msg = "Error extracting files from: " + zipFile.getName();
            throw new InstallException(2, null, msg, msg, e);
        }
    }

    private static void extractFileFromZip(ZipFile zipFile, File fileToExtract, String extractLocation) throws InstallException {
        String key = TaskHelper.join(Arrays.asList(fileToExtract.getPath().split("\\\\")), "/");
        ZipEntry zipEntry = zipFile.getEntry(key);
        InputStream zipEntryStream = null;
        try {
            zipEntryStream = zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            String msg = "Error reading file " + fileToExtract.getPath() + " from " + zipFile.getName();
            throw new InstallException(2, null, msg, msg, e);
        }
        FileOutputStream fileOutputStream = null;
        File outputFile = new File(extractLocation, fileToExtract.getPath());
        File outputFileDir = new File(outputFile.getParent());
        if (!outputFileDir.exists() && !outputFileDir.mkdirs()) {
            String msg = "Error creating a directory for file extraction: " + outputFileDir.getAbsolutePath();
            throw new InstallException(2, null, msg, msg, null);
        }
        try {
            fileOutputStream = new FileOutputStream(outputFile);
        }
        catch (Exception e) {
            String msg = "Error opening target file during extraction: " + outputFile.getAbsolutePath();
            throw new InstallException(2, null, msg, msg, e);
        }
        try {
            TaskHelper.streamData(zipEntryStream, fileOutputStream);
        }
        catch (Exception e) {
            String msg = "Error writing target file during extraction: " + outputFile.getAbsolutePath();
            throw new InstallException(2, null, msg, msg, e);
        }
        try {
            zipEntryStream.close();
        }
        catch (IOException e) {
            log.warn("Error closing package file: " + zipFile.getName());
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException e) {
            log.warn("Error closing target file: " + outputFile.getAbsolutePath());
        }
    }

    private static void streamData(InputStream is, OutputStream os) throws IOException {
        int n;
        int bufferSize = 65536;
        byte[] buf = new byte[65536];
        while ((n = is.read(buf)) > -1) {
            os.write(buf, 0, n);
        }
    }

    public static class FileMode {
        public static final int OWNERRWX = 448;
        public static final int OWNERR = 256;
        public static final int OWNERW = 128;
        public static final int OWNERX = 64;
        public static final int GROUPRWX = 56;
        public static final int GROUPR = 32;
        public static final int GROUPW = 16;
        public static final int GROUPX = 8;
        public static final int OTHERRWX = 7;
        public static final int OTHERR = 4;
        public static final int OTHERW = 2;
        public static final int OTHERX = 1;
        private String filename;
        private int mode = -1;

        public FileMode(File filepath) throws NullPointerException, FileNotFoundException {
            if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, DiskInfoAPI.libNames)) {
                String missingLib = JNIUtils.getJniLib(DiskInfoAPI.libNames);
                throw new InstallException(2, null, _bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
            }
            if (filepath == null) {
                throw new NullPointerException();
            }
            if (!filepath.exists()) {
                throw new FileNotFoundException();
            }
            this.filename = filepath.getAbsolutePath();
            this.mode = TaskHelper.getOS() == 1 || TaskHelper.getOS() == 6 || TaskHelper.getOS() == 8 ? 0 : DiskInfoAPI.GetFileMode(this.filename);
        }

        public FileMode(String filepath) throws NullPointerException, FileNotFoundException {
            this(new File(filepath));
        }

        public int getPerm() {
            return this.mode;
        }

        public boolean checkPerm(int flag) {
            int result = this.mode & flag;
            return result != 0;
        }

        public void addPerm(int flag) {
            this.mode |= flag;
        }

        public void remPerm(int flag) {
            this.mode &= ~flag;
        }

        public void setPerm(int permission) {
            this.mode = permission;
        }

        public int commit() {
            if (TaskHelper.getOS() == 1 || TaskHelper.getOS() == 6 || TaskHelper.getOS() == 8) {
                return 0;
            }
            return DiskInfoAPI.SetFileMode(this.filename, this.mode);
        }
    }
}

