/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.Utilities;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.tasks.ConfigParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SASConfigFile {
    protected File _originalConfigFile;
    protected Document _configDocument;
    protected ConfigParser _parser;
    protected int os;
    protected String _nlsPath;
    protected Logger log = (Logger)LogManager.getLogger(this.getClass().getName());

    public String descriptionForLog() {
        return "SASConfigFile";
    }

    public SASConfigFile() {
        this.setOS(Utilities.getOS());
        this.setParser(new ConfigParser());
    }

    public SASConfigFile(File configFile) throws Exception {
        this();
        this.setOriginalConfigFile(configFile);
    }

    public File getOriginalConfigFile() {
        return this._originalConfigFile;
    }

    public void setOriginalConfigFile(File originalConfigFile) throws Exception {
        if (originalConfigFile == null) {
            this._originalConfigFile = null;
            return;
        }
        if (this._originalConfigFile != null && this._originalConfigFile.equals(originalConfigFile)) {
            return;
        }
        this._originalConfigFile = originalConfigFile;
        this.getParser().setOriginalConfigFile(this._originalConfigFile);
        this.getParser().parseOriginal();
        this.setConfigDocument(this.getParser().getConfigDocument());
        this.setNlsPath();
    }

    public String getNlsPath() {
        return this._nlsPath;
    }

    public void setNlsPath() {
        if (this.getConfigDocument() == null) {
            this._nlsPath = "";
        } else {
            Integer num = 0;
            while (num >= 0) {
                String extFile = "sasext";
                if (this.optionExists(extFile = extFile.concat(num.toString()))) {
                    String extPath = this.getScalarOptionValue(extFile);
                    if (extPath.toLowerCase().endsWith("nls\"")) {
                        this._nlsPath = extFile;
                    }
                    Integer n = num;
                    num = num + 1;
                    continue;
                }
                num = -99;
            }
        }
    }

    public void replaceAll(String originalString, String replacementString) {
        this.replaceAll(originalString, replacementString, this.getConfigDocument());
    }

    public void replaceAll(String originalString, String replacementString, Node topNode) {
        NodeList nodes = topNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Text text;
            Node node = nodes.item(i);
            if (node instanceof Attr) {
                Attr attribute = (Attr)node;
                if (attribute.getValue().contains(originalString)) {
                    attribute.setValue(Utils.stringReplaceAll(attribute.getValue(), originalString, replacementString));
                }
            } else if (node instanceof CDATASection) {
                CDATASection cdata = (CDATASection)node;
                if (cdata.getTextContent().contains(originalString)) {
                    cdata.setTextContent(Utils.stringReplaceAll(cdata.getTextContent(), originalString, replacementString));
                }
            } else if (node instanceof Comment) {
                Comment comment = (Comment)node;
                if (comment.getTextContent().contains(originalString)) {
                    comment.setTextContent(Utils.stringReplaceAll(comment.getTextContent(), originalString, replacementString));
                }
            } else if (node instanceof Text && (text = (Text)node).getData().contains(originalString)) {
                text.setData(Utils.stringReplaceAll(text.getData(), originalString, replacementString));
            }
            this.replaceAll(originalString, replacementString, node);
        }
    }

    public Vector<String> sortArrayOption(Vector<String> newArray) {
        Vector<String> sortedArray = new Vector<String>();
        if (this.getOS() == 1) {
            Vector<String> zeroPriorityArray = new Vector<String>();
            Vector<String> firstPriorityArray = new Vector<String>();
            Vector<String> secondPriorityArray = new Vector<String>();
            Vector<String> thirdPriorityArray = new Vector<String>();
            Vector<String> fourthPriorityArray = new Vector<String>();
            Vector<String> finalPriorityArray = new Vector<String>();
            for (String item : newArray) {
                if (item.contains("testauto")) {
                    zeroPriorityArray.add(item);
                    continue;
                }
                if (item.startsWith("\"!SASCFG")) {
                    firstPriorityArray.add(item);
                    continue;
                }
                if (item.startsWith("\"!" + this.getNlsPath()) && this.getNlsPath() != "") {
                    secondPriorityArray.add(item);
                    continue;
                }
                if (item.toLowerCase().matches("\\\"\\!sas(root|ext\\d)\\\\nls.*")) {
                    secondPriorityArray.add(item);
                    continue;
                }
                if (item.toLowerCase().matches("\\\"\\!sas(root|ext\\d)\\\\dbcs.*")) {
                    thirdPriorityArray.add(item);
                    continue;
                }
                if (item.toLowerCase().matches("\\\"\\!sas(root|ext\\d)\\\\core.*")) {
                    fourthPriorityArray.add(item);
                    continue;
                }
                finalPriorityArray.add(item);
            }
            Collections.sort(zeroPriorityArray);
            Collections.sort(firstPriorityArray);
            Collections.sort(secondPriorityArray);
            Collections.sort(thirdPriorityArray);
            Collections.sort(fourthPriorityArray);
            Collections.sort(finalPriorityArray);
            sortedArray.addAll(zeroPriorityArray);
            sortedArray.addAll(firstPriorityArray);
            sortedArray.addAll(secondPriorityArray);
            sortedArray.addAll(thirdPriorityArray);
            sortedArray.addAll(fourthPriorityArray);
            sortedArray.addAll(finalPriorityArray);
        } else if (this.getOS() != 1 && this.getOS() != 6 && this.getOS() != 8) {
            Vector<String> firstPriorityArray = new Vector<String>();
            Vector<String> secondPriorityArray = new Vector<String>();
            Vector<String> finalPriorityArray = new Vector<String>();
            for (String item : newArray) {
                if (item.toLowerCase().matches("\\'\\!sasroot/nls/en.*")) {
                    secondPriorityArray.add(item);
                    continue;
                }
                if (item.toLowerCase().matches("\\'\\!sasroot/nls.*")) {
                    firstPriorityArray.add(item);
                    continue;
                }
                finalPriorityArray.add(item);
            }
            Collections.sort(firstPriorityArray);
            Collections.sort(secondPriorityArray);
            Collections.sort(finalPriorityArray);
            sortedArray.addAll(firstPriorityArray);
            sortedArray.addAll(secondPriorityArray);
            sortedArray.addAll(finalPriorityArray);
        }
        return sortedArray;
    }

    public boolean replaceArrayOption(String optionName, String listTag, Vector<String> newArray, String prefix) {
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        Element firstOption = null;
        int numOptions = options.getLength();
        if (numOptions == 0) {
            return false;
        }
        if (numOptions > 1) {
            for (int i = 0; i < numOptions; ++i) {
                Element parentNode = (Element)options.item(i).getParentNode();
                if (parentNode != null) {
                    if ((prefix == null || prefix.equals("")) && parentNode.getNodeName().equalsIgnoreCase("config")) {
                        firstOption = (Element)options.item(i);
                        continue;
                    }
                    if (prefix == null || prefix.equals("") || !parentNode.getNodeName().equalsIgnoreCase(prefix)) continue;
                    firstOption = (Element)options.item(i);
                    continue;
                }
                this.log.warn("replaceArrayOption: Parent config node is null for :" + options.item(i).getNodeName());
            }
            if (firstOption == null) {
                this.log.warn("replaceArrayOption: Corrent option could not be determined, defaulting to the first one in the list :" + options.item(0).getNodeName());
                firstOption = (Element)options.item(0);
            }
        } else {
            firstOption = (Element)options.item(0);
        }
        NodeList paths = firstOption.getChildNodes();
        Vector<Object> sortedArray = new Vector();
        int originalLength = paths.getLength();
        for (int i = 0; i < originalLength; ++i) {
            Node node = paths.item(0);
            if (!(node instanceof Element)) continue;
            firstOption.removeChild(node);
        }
        firstOption.setAttribute("size", String.valueOf(newArray.size()));
        sortedArray = this.sortArrayOption(newArray);
        for (String string : sortedArray) {
            Element child = this.getConfigDocument().createElement(listTag);
            child.setTextContent(string);
            firstOption.appendChild(child);
        }
        return true;
    }

    public boolean replaceScalarOptionValue(String optionName, String optionValue) {
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        if (options.getLength() == 0) {
            return false;
        }
        Element firstOption = (Element)options.item(0);
        firstOption.setTextContent(optionValue);
        return true;
    }

    public String getScalarOptionValue(String optionName) {
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        if (options.getLength() == 0) {
            return null;
        }
        String value = "";
        for (int i = 0; i < options.getLength(); ++i) {
            Element firstOption = (Element)options.item(i);
            value = value + firstOption.getTextContent();
        }
        return value;
    }

    public Element newTag(String tagName, String optionPrefix) {
        Element newTag = this.getConfigDocument().createElement(tagName);
        Element parentTag = (Element)this.getConfigDocument().getFirstChild();
        if (optionPrefix != null && optionPrefix.length() != 0) {
            Element setTag = this.getConfigDocument().createElement(optionPrefix);
            parentTag.appendChild(setTag);
            parentTag = setTag;
        }
        parentTag.appendChild(newTag);
        return newTag;
    }

    public void addScalarOption(String optionName, String optionValue, String optionPrefix) {
        this.newTag(optionName, optionPrefix).setTextContent(optionValue);
    }

    public void addScalarOption(String optionName, String optionPrefix) {
        this.newTag(optionName, optionPrefix);
    }

    public Vector<String> getArrayOption(String optionName) {
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        if (options.getLength() == 0) {
            return null;
        }
        Element firstOption = (Element)options.item(0);
        NodeList paths = firstOption.getChildNodes();
        Vector<String> returnValue = new Vector<String>();
        for (int i = 0; i < paths.getLength(); ++i) {
            Node child = paths.item(i);
            if (!(child instanceof Element)) continue;
            returnValue.add(child.getTextContent());
        }
        return returnValue;
    }

    public void addArrayOption(String optionName, String listTag, String optionPrefix, Vector<String> options) {
        Element option = this.newTag(optionName, optionPrefix);
        String separator = " ";
        for (String optionTag : options) {
            Element newChild = this.getConfigDocument().createElement(listTag);
            if (listTag.equalsIgnoreCase("entry")) {
                optionTag = "-" + optionTag;
                separator = "=";
            }
            newChild.setTextContent(optionTag);
            option.appendChild(newChild);
        }
        option.setAttribute("size", String.valueOf(options.size()));
        option.setAttribute("separator", separator);
        if (listTag.equalsIgnoreCase("location")) {
            Vector<String> newArray = this.getArrayOption(optionName);
            this.replaceArrayOption(optionName, listTag, newArray, optionPrefix);
        }
    }

    public boolean addArrayOptionValue(String optionName, String listTag, Integer index, String optionValue) {
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        if (options.getLength() == 0) {
            return false;
        }
        Element option = (Element)options.item(0);
        if (option == null) {
            return false;
        }
        Element newChild = this.getConfigDocument().createElement(listTag);
        if (listTag.equalsIgnoreCase("entry")) {
            optionValue = "-" + optionValue;
        }
        newChild.setTextContent(optionValue);
        if (index == null) {
            option.appendChild(newChild);
        } else {
            NodeList allChildren = option.getChildNodes();
            option.insertBefore(newChild, allChildren.item(index + 1));
        }
        return true;
    }

    public boolean addArrayOptionValue(String optionName, String listTag, String optionValue, String prefix) {
        Vector<String> newArray = this.getArrayOption(optionName);
        if (newArray == null) {
            this.addArrayOption(optionName, listTag, prefix, new Vector<String>());
            newArray = this.getArrayOption(optionName);
        }
        newArray.add(optionValue);
        this.replaceArrayOption(optionName, listTag, newArray, prefix);
        return true;
    }

    public boolean removeOption(String optionName) {
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        if (options.getLength() == 0) {
            return false;
        }
        Element option = (Element)options.item(0);
        if (option == null) {
            return false;
        }
        Element parent = (Element)option.getParentNode();
        if (parent.getNodeName().equalsIgnoreCase("SET") || parent.getNodeName().equalsIgnoreCase("insert")) {
            parent.getParentNode().removeChild(parent);
        } else {
            parent.removeChild(option);
        }
        return true;
    }

    public boolean optionExists(String optionName) {
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        if (options.getLength() == 0) {
            return false;
        }
        Element option = (Element)options.item(0);
        return option != null;
    }

    public boolean removeArrayOptionValue(String optionName, String optionValue) {
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        if (options.getLength() == 0) {
            return false;
        }
        Element option = (Element)options.item(0);
        if (option == null) {
            return false;
        }
        NodeList list = option.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element child = (Element)list.item(i);
            if (!child.getTextContent().matches("[\"|']??" + optionValue.replaceAll("\\\\", "\\\\\\\\") + "[\"|']??")) continue;
            option.removeChild(child);
            return true;
        }
        return false;
    }

    public boolean arrayValueExists(String optionName, String optionValue, String prefix) {
        NodeList paths;
        int originalLength;
        NodeList options = this.getConfigDocument().getElementsByTagName(optionName);
        Element firstOption = null;
        String pathItem = "";
        int numOptions = options.getLength();
        if (numOptions == 0) {
            return false;
        }
        if (numOptions > 1) {
            for (int i = 0; i < numOptions; ++i) {
                Element parentNode = (Element)options.item(i).getParentNode();
                if (parentNode != null) {
                    if ((prefix == null || prefix.equals("")) && parentNode.getNodeName().equalsIgnoreCase("config")) {
                        firstOption = (Element)options.item(i);
                        continue;
                    }
                    if (prefix == null || prefix.equals("") || !parentNode.getNodeName().equalsIgnoreCase(prefix)) continue;
                    firstOption = (Element)options.item(i);
                    continue;
                }
                this.log.warn("arrayValueExists: Parent config node is null for :" + options.item(i).getNodeName());
            }
            if (firstOption == null) {
                this.log.warn("arrayValueExists: Corrent option could not be determined, defaulting to the first one in the list :" + options.item(0).getNodeName());
                firstOption = (Element)options.item(0);
            }
        } else {
            firstOption = (Element)options.item(0);
        }
        if ((originalLength = (paths = firstOption.getChildNodes()).getLength()) == 1 && (pathItem = firstOption.getFirstChild().getNodeValue()) != null) {
            return optionValue.equals(pathItem);
        }
        for (int i = 0; i < originalLength; ++i) {
            pathItem = paths.item(i).getChildNodes().item(0).getNodeValue().toString();
            if (optionValue.equals(pathItem)) {
                return true;
            }
            if (!(pathItem.startsWith("\"") && pathItem.endsWith("\"") ? pathItem.equals("\"" + optionValue + "\"") : pathItem.startsWith("'") && pathItem.endsWith("'") && pathItem.equals("'" + optionValue + "'"))) continue;
            return true;
        }
        return false;
    }

    public boolean arrayValueExists(String optionName, String optionValue) {
        Vector<String> newArray = this.getArrayOption(optionName);
        if (newArray == null) {
            return false;
        }
        for (int i = 0; i < newArray.size(); ++i) {
            if (newArray.get(i).trim().equalsIgnoreCase(optionValue.trim())) {
                return true;
            }
            if (!(newArray.get(i).startsWith("\"") && newArray.get(i).endsWith("\"") ? newArray.get(i).equals("\"" + optionValue + "\"") : newArray.get(i).startsWith("'") && newArray.get(i).endsWith("'") && newArray.get(i).equals("'" + optionValue + "'"))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfigFile() throws TransformerException, IOException {
        InputStream xsltStream = this.getClass().getClassLoader().getResourceAsStream("com/sas/tools/installs/it/tasks/SASConfigFile.xslt");
        DOMSource xmlSource = new DOMSource(this.getConfigDocument().getFirstChild());
        StreamSource xsltSource = new StreamSource(xsltStream);
        FileWriter outFile = null;
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xsltSource);
        try {
            outFile = new FileWriter(this.getOriginalConfigFile());
            trans.transform(xmlSource, new StreamResult(outFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
        }
        FileReader inFile = null;
        BufferedReader in = null;
        inFile = new FileReader(this.getOriginalConfigFile());
        in = new BufferedReader(inFile);
        String line = "";
        Vector<String> buffer = new Vector<String>();
        boolean beginningOfFile = false;
        if (this._parser._originalUserConfigSectionString != null) {
            buffer.add(this._parser._originalUserConfigSectionString);
        }
        while (in.ready()) {
            line = in.readLine();
            if (line == null) continue;
            if (line.length() != 0 && !beginningOfFile) {
                beginningOfFile = true;
            }
            if (!beginningOfFile) continue;
            buffer.add(line);
        }
        in.close();
        inFile.close();
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.getOriginalConfigFile())));
        for (String bufferLine : buffer) {
            String testLine;
            if (bufferLine.contains("-Dlog4j.configuration=") && (testLine = bufferLine.trim()).startsWith("-Dlog4j.configuration=") && testLine.endsWith("sas.log4j.properties")) continue;
            if (!this._parser.borderLineFound) {
                output.write(bufferLine + System.getProperty("line.separator"));
                continue;
            }
            if (this._parser._originalUserConfigSectionString != null && bufferLine.indexOf(this._parser._originalUserConfigSectionString) < 0) {
                output.write(bufferLine + System.getProperty("line.separator"));
                continue;
            }
            output.write(bufferLine);
        }
        output.close();
    }

    public Document getConfigDocument() {
        return this._configDocument;
    }

    public void setConfigDocument(Document configDocument) {
        this._configDocument = configDocument;
    }

    public ConfigParser getParser() {
        return this._parser;
    }

    public void setParser(ConfigParser parser) {
        this._parser = parser;
    }

    public int getOS() {
        return this.os;
    }

    public void setOS(int os) {
        this.os = os;
    }
}

