/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.util.ArrayList;

public class RunRegistrationAtEndTask
extends InstallationTask {
    private static RunRegistrationAtEndTask _runRegistrationAtEndTask = null;
    private static ArrayList<String> _12bytesToRegister = new ArrayList();

    public RunRegistrationAtEndTask() {
        _runRegistrationAtEndTask = this;
        if (!this.isUndo()) {
            String key = Controller.defaultController().getAltSku().concat(this.getClass().getName());
            Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(this.getClass().getName(), "runRegistrationAtEnd"));
            Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this.getClass(), "runRegistrationAtEnd"));
        }
    }

    public static int runRegistrationAtEnd() throws Exception {
        return _runRegistrationAtEndTask.executeAtEnd();
    }

    @Override
    public String descriptionForLog() {
        return "Run Registration at the end";
    }

    @Override
    public void preExecute() throws Exception {
        if (this.isUndo()) {
            return;
        }
        this.notifySetup("Running Registration at the end");
        this.log.info("in RunRegistrationAtEnd preExecute");
        _12bytesToRegister.add(this.getController().getProperty("12ByteCode"));
    }

    @Override
    public void execute() throws InstallException {
        if (this.isUndo()) {
            this.rollback();
            return;
        }
        this.log.info("Running Registration At End");
    }

    public int executeAtEnd() {
        this.log.info("POSTPROCESS: runRegistrationAtEndTask called");
        String command = "";
        for (int i = 0; i < _12bytesToRegister.size(); ++i) {
            String twelvebyte = _12bytesToRegister.get(i);
            if (twelvebyte.contains("eguide")) {
                command = this.resolveProperty("${eguideHome}\\SEGuide.exe").concat(" /register");
                this.log.info("POSTPROCESS: executing " + command);
                TaskHelper.executeCommand(command);
                command = this.resolveProperty("${eguideHome}\\RegTasks.exe").concat(" /register");
                this.log.info("POSTPROCESS: executing " + command);
                TaskHelper.executeCommand(command);
                continue;
            }
            if (!twelvebyte.contains("msofficeint")) continue;
            command = this.resolveProperty("${msofficeintHome}\\RegTasks.exe").concat(" /register");
            this.log.info("POSTPROCESS: executing " + command);
            TaskHelper.executeCommand(command);
        }
        this.log.info("POSTPROCESS: runRegistrationAtEndTask finished");
        return 0;
    }

    @Override
    public void postExecute() throws Exception {
        this.log.debug("in RunRegistrationAtEnd postExecute");
    }

    @Override
    public void retry() throws InstallException {
        this.log.debug("in RunRegistrationAtEnd retry");
    }

    @Override
    public void rollback() throws InstallException {
        this.log.debug("in RunRegistrationAtEnd rollback");
        String command = "";
        if (this.getController().getProperty("12ByteCode").equalsIgnoreCase("eguide")) {
            command = this.resolveProperty("${eguideHome}\\RegTasks.exe");
            if (new File(command).exists()) {
                command = command.concat(" /unregister");
                TaskHelper.executeCommand(command);
                this.log.info("POSTPROCESS: executing " + command);
            }
            if (new File(command = this.resolveProperty("${eguideHome}\\SEGuide.exe")).exists()) {
                command = command.concat(" /unregister");
                TaskHelper.executeCommand(command);
                this.log.info("POSTPROCESS: executing " + command);
            }
        }
        if (this.getController().getProperty("12ByteCode").equalsIgnoreCase("msofficeint") && new File(command = this.resolveProperty("${msofficeintHome}\\RegTasks.exe")).exists()) {
            command = command.concat(" /unregister");
            TaskHelper.executeCommand(command);
            this.log.info("POSTPROCESS: executing " + command);
        }
    }

    @Override
    public InstallationTask.UninstallTarget getUninstallTarget() {
        return InstallationTask.UninstallTarget.PREINSTALL;
    }
}

