/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.tasks.IPicklistFilehandler;
import com.sas.tools.installs.it.tasks.Picklist;
import com.sas.tools.installs.it.tasks.PicklistEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class PicklistFilehandler
implements IPicklistFilehandler {
    private static Logger log = (Logger)LogManager.getLogger("com.sas.tools.installs.it.tasks.PicklistFilehandler");
    private static Pattern ignorePattern = PicklistFilehandler.sasHomeIgnorePatternCompiled();

    @Override
    public List<String> getAllPicklistsForDirectory(String directory) {
        ArrayList<String> picklists = new ArrayList<String>();
        File dir = new File(directory);
        if (dir.isDirectory()) {
            File[] directoryList = dir.listFiles();
            if (directoryList == null) {
                String msg = String.format("Warning,  unable to read directory %s", dir.getAbsolutePath());
                log.warn(msg);
                return picklists;
            }
            String MVAPicklistRootDir = "SASVersionedJarRepository" + File.separator + "picklist";
            String instqualToolBackupDirForStandalone = String.format("%s%s%s", "instqualtool", File.separator, ".backup");
            for (int i = 0; i < directoryList.length; ++i) {
                if (directoryList[i].isFile()) {
                    if (!directoryList[i].getPath().contains(MVAPicklistRootDir) && !directoryList[i].getName().matches("picklist") && !directoryList[i].getName().matches(".*\\.picklist") || directoryList[i].getPath().contains("SASDeploymentManager") || ignorePattern.matcher(directoryList[i].getPath()).find() || directoryList[i].getPath().contains(instqualToolBackupDirForStandalone)) continue;
                    String pickListPath = directoryList[i].getAbsolutePath();
                    picklists.add(pickListPath);
                    continue;
                }
                if (!directoryList[i].canRead() || !directoryList[i].isDirectory()) continue;
                List<String> morePicklists = this.getAllPicklistsForDirectory(directoryList[i].getAbsolutePath());
                picklists.addAll(morePicklists);
            }
        } else {
            String msg = String.format("Warning, directory %s does not exist!", dir.getAbsolutePath());
            log.warn(msg);
        }
        return picklists;
    }

    @Override
    public Map<String, PicklistEntry> getPicklistEntries(String picklist) throws IOException {
        FileInputStream inputStream = new FileInputStream(picklist);
        Picklist helper = new Picklist();
        Map<String, PicklistEntry> pickListEntries = helper.read(inputStream);
        ((InputStream)inputStream).close();
        return pickListEntries;
    }

    private static Pattern sasHomeIgnorePatternCompiled() {
        String sasHome = System.getProperty("SASHome");
        File sasHomeF = sasHome != null ? new File(sasHome) : null;
        String sasHome_Name = sasHomeF != null ? sasHomeF.getName() : ".*";
        String ingorePatternText = ".*[/\\\\]" + sasHome_Name + "[/\\\\].*(...*)[/\\\\]installs[/\\\\].*\\1.*[/\\\\].*picklist.*(?<!.xml)$";
        Pattern ignorePatternCompiled = Pattern.compile(ingorePatternText);
        return ignorePatternCompiled;
    }
}

