/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.RegistryAccess;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.MergePicklistsForMultipleProducts;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.DeploymentRegistryEntry;
import com.sas.tools.installs.it.tasks.IPicklistFilehandler;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.MergePicklistTask;
import com.sas.tools.installs.it.tasks.PicklistEntry;
import com.sas.tools.installs.it.tasks.PicklistFilehandler;
import com.sas.tools.installs.it.tasks.VjrPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MergePicklistsForMultipleProductsTask
extends InstallationTask {
    private static final String VJR_DIR = "SASVersionedJarRepository";
    private boolean abortTask = false;
    private IPicklistFilehandler picklistFilehandler;
    private Map<String, VjrPlugin> allPluginsToCheck;
    private Map<String, Set<String>> pluginsToApply;
    private List<MergePicklistTask> mergePickListTasks;
    private List<DeploymentRegistryEntry> deploymentRegistryEntries;
    private Map<String, String> productCodes;
    private final String payloadDirectory = Controller.defaultController().getInstallFile().getParent();

    public boolean abortTask() {
        return this.abortTask;
    }

    private void addPlugin(MergePicklistsForMultipleProducts.Plugins.Plugin plugin, Map<String, VjrPlugin> plugins) {
        VjrPlugin picklistPlugin = new VjrPlugin();
        MergePicklistsForMultipleProducts.Plugins.Plugin.Target target = plugin.getTarget();
        String mergePicklistFilename = plugin.getFile();
        picklistPlugin.setPicklistMergeFile(mergePicklistFilename);
        String targetName = target.getName();
        picklistPlugin.setTargetName(targetName);
        MergePicklistsForMultipleProducts.Plugins.Plugin.Target.Versions versions = target.getVersions();
        List<String> versionStrings = versions.getVersion();
        picklistPlugin.setTargetVersions(versionStrings);
        String updateVersion = this.getPluginUpdateVersion(mergePicklistFilename, targetName);
        picklistPlugin.setUpdateVersion(updateVersion);
        plugins.put(mergePicklistFilename, picklistPlugin);
    }

    private void checkProductForPlugins(String productCode, String productVersion, String productHome, Set<String> visitedProductHomes, Set<String> productHomesToUpdate) {
        boolean checkProduct = false;
        Map<String, Set<String>> plugins = this.getPluginsToApply();
        if (visitedProductHomes.contains(productHome)) {
            if (productHomesToUpdate.contains(productHome)) {
                checkProduct = true;
            }
        } else {
            visitedProductHomes.add(productHome);
            String msg = String.format("Scanning directory %s", productHome);
            this.log.info(msg);
            checkProduct = this.findPluginsToApplyForTargetDirectory(productHome, plugins);
        }
        if (checkProduct) {
            productHomesToUpdate.add(productHome);
            boolean eligibleProduct = this.isProductEligible(productCode, productVersion);
            if (!eligibleProduct) {
                String msg = String.format("ERROR: The product  %s %s is not in the list of products whose picklists are to be updated, but references a jar targeted for removal.", productCode, productVersion);
                this.log.error(msg);
                this.setAbortTask(true);
            }
        }
    }

    private void checkDirectoryForPlugins(File directory) {
        if (directory.isDirectory()) {
            String msg = String.format("Scanning directory %s recursively to update all qualifying picklists.", directory);
            this.log.info(msg);
            Map<String, Set<String>> plugins = this.getPluginsToApply();
            this.findPluginsToApplyForTargetDirectory(directory.getAbsolutePath(), plugins);
        } else {
            String.format("Warning, directory %s does not exist!", directory.getAbsolutePath());
        }
    }

    private String copyPicklist(String mergePicklistFilename, String targetPicklist) {
        String packageDir = this.getController().getPackageDir();
        File source = new File(packageDir, mergePicklistFilename);
        String destinationPath = String.format("%s.merge", targetPicklist);
        File destination = new File(destinationPath);
        try {
            Utils.copyFile(source, destination);
            return destinationPath;
        }
        catch (IOException e) {
            String msg = String.format("Error copying %s to %s", source.getAbsolutePath(), destination.getAbsolutePath());
            throw new InstallException(2, this, msg, msg, e);
        }
    }

    private List<String> copyPickLists(String picklistMergeFile, Set<String> picklists) {
        ArrayList<String> mergePicklistFiles = new ArrayList<String>();
        for (String picklist : picklists) {
            File picklistFile = new File(picklist);
            if (picklistFile.exists()) {
                String mergePicklistFile = this.copyPicklist(picklistMergeFile, picklist);
                mergePicklistFiles.add(mergePicklistFile);
                continue;
            }
            String msg = String.format("%s no longer present and will be removed from list of picklists to update.", picklist);
            this.log.info(msg);
        }
        return mergePicklistFiles;
    }

    @Override
    public String descriptionForLog() {
        return null;
    }

    public void determinePluginsToApply() {
        Map<String, String> products = this.getEligibleProductCodes();
        if (products.isEmpty()) {
            String sashome = Controller.defaultController().getProperty("SASHome");
            File directory = new File(sashome);
            this.checkDirectoryForPlugins(directory);
        } else {
            this.logEligibleProducts(products);
            HashSet<String> visitedProductHomes = new HashSet<String>();
            HashSet<String> productHomesToUpdate = new HashSet<String>();
            List<DeploymentRegistryEntry> entries = this.getDeploymentRegistryEntries();
            for (DeploymentRegistryEntry entry : entries) {
                String productCode = entry.getProductCode();
                String productVersion = entry.getProductVersion();
                String productHome = entry.getProductHome();
                this.checkProductForPlugins(productCode, productVersion, productHome, visitedProductHomes, productHomesToUpdate);
                if (!this.isVjrHomeDir(productHome)) continue;
                String vjrHomeDir = this.getVjrPicklistDir();
                this.checkProductForPlugins(productCode, productVersion, vjrHomeDir, visitedProductHomes, productHomesToUpdate);
            }
        }
        this.checkAdditionalDirectoriesForPlugins();
    }

    private void checkAdditionalDirectoriesForPlugins() {
        MergePicklistsForMultipleProducts.AdditionalDirectoriesToScan directoriesToScan = this.getJAXB().getAdditionalDirectoriesToScan();
        if (directoriesToScan != null) {
            this.log.info("Scanning additional directories for eligible picklists.");
            List<MergePicklistsForMultipleProducts.AdditionalDirectoriesToScan.Directory> directories = directoriesToScan.getDirectory();
            for (MergePicklistsForMultipleProducts.AdditionalDirectoriesToScan.Directory directory : directories) {
                String dir = this.resolveProperty(directory.getPath());
                File path = new File(dir);
                String msg = String.format("Checking additional directory %s.", path.getAbsolutePath());
                this.log.info(msg);
                this.checkDirectoryForPlugins(path);
            }
        }
    }

    private boolean isVjrHomeDir(String productHome) {
        File dir = new File(productHome);
        return dir.getPath().contains(VJR_DIR);
    }

    private String getVjrPicklistDir() {
        String sashome = Controller.defaultController().getProperty("SASHome");
        String dir = String.format("%s%s%s%s%s", sashome, File.separator, VJR_DIR, File.separator, "picklist");
        return dir;
    }

    @Override
    public void execute() throws InstallException {
        boolean abortTask = this.abortTask();
        if (abortTask) {
            String msg = String.format("ERROR one or more products were detected requiring a picklist update that are not present on the list of valid products to update. This task will abort and not alter any picklists in the sashome.", new Object[0]);
            throw new InstallException(2, this, msg, msg, null);
        }
        if (!this.logOnly()) {
            this.log.info("Checking plugins again during execute mode");
            List<String> allPicklists = this.checkPlugins();
            this.logAffectedProducts(allPicklists);
            this.processPlugins();
        }
    }

    public boolean findPluginsToApplyForTargetDirectory(String directory, Map<String, Set<String>> pluginsToApply) {
        boolean atLeastOnePicklistToUpdateFound = false;
        IPicklistFilehandler picklistFilehandler = this.getPicklistFilehandler();
        List<String> picklists = picklistFilehandler.getAllPicklistsForDirectory(directory);
        for (String picklist : picklists) {
            String msg = String.format("Reading picklist file %s", picklist);
            this.log.info(msg);
            Map<String, PicklistEntry> entryMap = this.getPicklistEntries(picklist);
            Map<String, VjrPlugin> picklistPlugins = this.getAllPluginsToCheck();
            Set<String> picklistMergeFiles = picklistPlugins.keySet();
            for (String picklistMergeFile : picklistMergeFiles) {
                VjrPlugin vjrPlugin = picklistPlugins.get(picklistMergeFile);
                String targetName = vjrPlugin.getTargetName();
                PicklistEntry picklistEntry = entryMap.get(targetName);
                if (picklistEntry == null) continue;
                List<String> targetVersions = vjrPlugin.getTargetVersions();
                for (String targetVersion : targetVersions) {
                    String updateVersion;
                    String currentVersion = picklistEntry.getVersion();
                    if (currentVersion.equals(updateVersion = vjrPlugin.getUpdateVersion())) {
                        msg = String.format("Plugin %s is already at the update version as defined in picklist file to merge %s. Ths picklist merge file will not be applied to %s.", targetName, updateVersion, picklistMergeFile, picklist);
                        this.log.info(msg);
                        continue;
                    }
                    if (currentVersion.equals(targetVersion)) {
                        msg = String.format("Target version %s for plugin %s found, picklist file %s will be updated with picklist merge file %s.", targetVersion, targetName, picklist, picklistMergeFile);
                        this.log.info(msg);
                        atLeastOnePicklistToUpdateFound = true;
                        Set<String> picklistsForPlugins = pluginsToApply.get(picklistMergeFile);
                        if (picklistsForPlugins == null) {
                            picklistsForPlugins = new HashSet<String>();
                            pluginsToApply.put(picklistMergeFile, picklistsForPlugins);
                        }
                        picklistsForPlugins.add(picklist);
                        continue;
                    }
                    msg = String.format("Plugin %s present but current version, %s, of plugin does not match target version, %s, in picklist file %s. Picklist merge file %s will not be applied.", targetName, currentVersion, targetVersion, picklist, picklistMergeFile);
                    this.log.warn(msg);
                }
            }
        }
        return atLeastOnePicklistToUpdateFound;
    }

    private Map<String, VjrPlugin> getAllPluginsToCheck() {
        if (this.allPluginsToCheck == null) {
            this.allPluginsToCheck = new HashMap<String, VjrPlugin>();
        }
        return this.allPluginsToCheck;
    }

    private List<DeploymentRegistryEntry> getDeploymentRegistryEntries() {
        if (this.deploymentRegistryEntries == null) {
            this.deploymentRegistryEntries = new ArrayList<DeploymentRegistryEntry>(100);
            try {
                String[] hosts;
                this.getRegistryAccess().open();
                for (String host : hosts = this.getRegistryAccess().getInstallHosts()) {
                    String[] products;
                    for (String product : products = this.getRegistryAccess().getInstallCodes(host)) {
                        String[] versions = this.getRegistryAccess().getInstallVersions(product, host);
                        if (versions == null || versions.length == 0) {
                            String msg = String.format("Unexpected error with deployment registry, no product version found for %s %s", product, host);
                            throw new InstallException(2, this, msg, msg, null);
                        }
                        for (String version : versions) {
                            String productHome = this.getRegistryAccess().getInstallLoc(product, version, host);
                            String productDisplayName = this.getRegistryAccess().getInstallDisplayName(product, version, host);
                            DeploymentRegistryEntry entry = new DeploymentRegistryEntry(product, version, host, productHome, productDisplayName);
                            this.deploymentRegistryEntries.add(entry);
                        }
                    }
                }
            }
            catch (Exception e) {
                String msg = "Error reading the deployment registry.";
                throw new InstallException(2, this, msg, msg, e);
            }
            finally {
                this.getRegistryAccess().close();
            }
        }
        return this.deploymentRegistryEntries;
    }

    private List<DeploymentRegistryEntry> getDeploymentRegistryEntriesForPicklistPath(String path) {
        List<DeploymentRegistryEntry> entries = this.getDeploymentRegistryEntries();
        ArrayList<DeploymentRegistryEntry> foundEntries = new ArrayList<DeploymentRegistryEntry>(3);
        for (DeploymentRegistryEntry entry : entries) {
            String entryHome = entry.getProductHome();
            if (entryHome == null || "".equals(entryHome)) {
                String productCode = entry.getProductCode();
                String productHost = entry.getProductHost();
                String productVersion = entry.getProductVersion();
                String msg = String.format("Product home not defined in the deployment registry for %s %s %s", productCode, productHost, productVersion);
                this.log.info(msg);
                continue;
            }
            if (!path.startsWith(entryHome)) continue;
            foundEntries.add(entry);
        }
        return foundEntries;
    }

    private Map<String, String> getEligibleProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new HashMap<String, String>();
            MergePicklistsForMultipleProducts.Products products = this.getJAXB().getProducts();
            if (products != null) {
                List<MergePicklistsForMultipleProducts.Products.Product> productList = products.getProduct();
                for (MergePicklistsForMultipleProducts.Products.Product product : productList) {
                    String code = product.getCode();
                    String version = product.getVersion();
                    this.productCodes.put(code, version);
                }
            }
        }
        return this.productCodes;
    }

    private MergePicklistsForMultipleProducts getJAXB() {
        return (MergePicklistsForMultipleProducts)this.getData();
    }

    private List<MergePicklistTask> getMergePicklistTasks() {
        if (this.mergePickListTasks == null) {
            this.mergePickListTasks = new ArrayList<MergePicklistTask>();
        }
        return this.mergePickListTasks;
    }

    private Map<String, PicklistEntry> getPicklistEntries(String picklist) {
        try {
            IPicklistFilehandler picklistFilehandler = this.getPicklistFilehandler();
            return picklistFilehandler.getPicklistEntries(picklist);
        }
        catch (IOException e) {
            String msg = String.format("Error occurred reading picklist %s.", picklist);
            throw new InstallException(2, this, msg, msg, e);
        }
    }

    private IPicklistFilehandler getPicklistFilehandler() {
        if (this.picklistFilehandler == null) {
            this.picklistFilehandler = new PicklistFilehandler();
        }
        return this.picklistFilehandler;
    }

    private Set<String> getPicklistsToUpdate() {
        Map<String, Set<String>> pluginsToApply = this.getPluginsToApply();
        Set<String> plugins = pluginsToApply.keySet();
        HashSet<String> picklistsToUpdate = new HashSet<String>();
        for (String plugin : plugins) {
            Set<String> picklists = pluginsToApply.get(plugin);
            picklistsToUpdate.addAll(picklists);
        }
        return picklistsToUpdate;
    }

    private List<MergePicklistsForMultipleProducts.Plugins.Plugin> getPlugins() {
        MergePicklistsForMultipleProducts.Plugins plugins = this.getJAXB().getPlugins();
        return plugins.getPlugin();
    }

    public Map<String, Set<String>> getPluginsToApply() {
        if (this.pluginsToApply == null) {
            this.pluginsToApply = new HashMap<String, Set<String>>();
        }
        return this.pluginsToApply;
    }

    private String getPluginUpdateVersion(String mergePicklistFilename, String plugin) {
        String packageDir = this.getPayloadDirectory();
        File source = new File(packageDir, mergePicklistFilename);
        String file = source.getAbsolutePath();
        Map<String, PicklistEntry> entryMap = this.getPicklistEntries(file);
        PicklistEntry entry = entryMap.get(plugin);
        if (entry == null) {
            String msg = String.format("An error occurred getting the version of the plugin %s in the merge picklist file %s", plugin, mergePicklistFilename);
            throw new InstallException(2, this, msg, msg, null);
        }
        return entry.getVersion();
    }

    private RegistryAccess getRegistryAccess() {
        return this.getController().getSASController().getAccess();
    }

    private boolean isProductEligible(String productCode, String productVersion) {
        Map<String, String> products = this.getEligibleProductCodes();
        String foundProductVersion = products.get(productCode);
        return productVersion.equals(foundProductVersion);
    }

    private void loadAllPluginsToCheck() {
        List<MergePicklistsForMultipleProducts.Plugins.Plugin> plugins = this.getPlugins();
        for (MergePicklistsForMultipleProducts.Plugins.Plugin plugin : plugins) {
            Map<String, VjrPlugin> allPlugins = this.getAllPluginsToCheck();
            this.addPlugin(plugin, allPlugins);
        }
    }

    private void logAffectedProducts(List<String> picklists) {
        HashSet<String> loggedPicklist = new HashSet<String>();
        HashSet<String> loggedProduct = new HashSet<String>();
        for (String picklist : picklists) {
            File file = new File(picklist);
            String picklistPath = file.getParent();
            List<DeploymentRegistryEntry> entries = this.getDeploymentRegistryEntriesForPicklistPath(picklistPath);
            int size = entries.size();
            if (size == 0) {
                if (loggedPicklist.contains(picklist)) continue;
                String msg = String.format("Cannot determine product and version for picklist file %s", picklist);
                this.log.info(msg);
                loggedPicklist.add(picklist);
                continue;
            }
            for (DeploymentRegistryEntry entry : entries) {
                String name = entry.getProductDisplayName();
                String code = entry.getProductCode();
                String version = entry.getProductVersion();
                String productHome = entry.getProductHome();
                String key = String.format("%s.%s.%s", name, code, version);
                if (loggedProduct.contains(key)) continue;
                String msg = String.format("Picklists will be updated for %s (%s) %s at the product home directory %s.", name, code, version, productHome);
                this.log.info(msg);
                loggedProduct.add(key);
            }
        }
    }

    private void logEligibleProducts(Map<String, String> products) {
        this.log.info("List of products verified to have their picklists updated:");
        Set<String> productCodes = products.keySet();
        ArrayList<String> sortedProductCodes = new ArrayList<String>(productCodes);
        Collections.sort(sortedProductCodes);
        for (String productCode : sortedProductCodes) {
            String productVersion = products.get(productCode);
            String msg = String.format("%s %s", productCode, productVersion);
            this.log.info(msg);
        }
    }

    private boolean logOnly() {
        String logOnly = this.getJAXB().getLogOnly();
        return "true".equalsIgnoreCase(logOnly);
    }

    private void mergePicklists(List<String> mergePicklistFiles) {
        MergePicklistTask mergePicklistTask = new MergePicklistTask();
        this.getMergePicklistTasks().add(mergePicklistTask);
        mergePicklistTask.setController(this.getController());
        mergePicklistTask.setFiles(mergePicklistFiles);
        mergePicklistTask.execute();
    }

    private void notifyPicklistsToUpdate() {
        Set<String> picklists = this.getPicklistsToUpdate();
        if (picklists.size() == 0) {
            return;
        }
        this.log.info("The following picklists will be modified.");
        ArrayList<String> sortedPicklists = new ArrayList<String>(picklists);
        Collections.sort(sortedPicklists);
        for (String picklist : sortedPicklists) {
            EntryData mergeData = new EntryData(picklist);
            String action = "Changed";
            this.log.info(picklist);
            this.notifySetup("Changed", mergeData, null);
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void preExecute() throws Exception {
        this.reset();
        this.loadAllPluginsToCheck();
        this.log.info("Checking plugins during preexecute mode");
        List<String> allPicklists = this.checkPlugins();
        this.notifyPicklistsToUpdate();
    }

    private List<String> checkPlugins() {
        this.determinePluginsToApply();
        Map<String, Set<String>> filteredPlugins = this.getPluginsToApply();
        if (filteredPlugins.isEmpty()) {
            this.log.info("There are no plugins to apply, possibly a new deployment?");
        }
        Set<String> plugins = filteredPlugins.keySet();
        ArrayList<String> allPicklists = new ArrayList<String>();
        for (String plugin : plugins) {
            Set<String> picklists = filteredPlugins.get(plugin);
            allPicklists.addAll(picklists);
        }
        return allPicklists;
    }

    private void processPlugins() {
        Map<String, Set<String>> filteredPlugins = this.getPluginsToApply();
        Set<String> picklistMergeFiles = filteredPlugins.keySet();
        for (String picklistMergeFile : picklistMergeFiles) {
            Set<String> picklists = filteredPlugins.get(picklistMergeFile);
            List<String> mergePicklistFiles = this.copyPickLists(picklistMergeFile, picklists);
            this.mergePicklists(mergePicklistFiles);
        }
    }

    public void reset() {
        this.getPicklistsToUpdate().clear();
        this.getPluginsToApply().clear();
        this.getMergePicklistTasks().clear();
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
        List<MergePicklistTask> tasks = this.getMergePicklistTasks();
        for (MergePicklistTask task : tasks) {
            task.rollback();
        }
    }

    private void setAbortTask(boolean abortTask) {
        this.abortTask = abortTask;
    }

    public void setAllPluginsToCheck(Map<String, VjrPlugin> plugins) {
        this.allPluginsToCheck = plugins;
    }

    public void setDeploymentRegistryEntries(List<DeploymentRegistryEntry> entries) {
        this.deploymentRegistryEntries = entries;
    }

    public void setPicklistFilehandler(IPicklistFilehandler filehandler) {
        this.picklistFilehandler = filehandler;
    }

    public void setProductCodes(Map<String, String> productCodes) {
        this.productCodes = productCodes;
    }

    private String getPayloadDirectory() {
        return this.payloadDirectory;
    }
}

