/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.MergePicklist;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.Picklist;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class MergePicklistTask
extends InstallationTask {
    public static boolean bPickListInUse = false;
    private List<String> providedFiles;
    private static List<String> visitedFilesForRestore;
    private static final String TASK_NAME = "MergePicklist";
    private final Set<EntryData> originalPicklists = new HashSet<EntryData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void execute() throws InstallException {
        if (Utilities.getOS() == 1 && !JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, DiskInfoAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib(DiskInfoAPI.libNames);
            throw new InstallException(2, this, this.getBundle().messageString("InstallationTask.MissingJNILib", missingLib), this.getEnBundle().messageString("InstallationTask.MissingJNILib", missingLib), null);
        }
        for (String mergeName : this.getFiles()) {
            File mergeFile;
            block14: {
                File existingFile;
                long mergeTimestamp;
                block15: {
                    InputStream mergeStream;
                    InputStream existingStream;
                    mergeName = this.resolveProperty(mergeName);
                    mergeFile = new File(mergeName);
                    mergeTimestamp = mergeFile.lastModified();
                    if (!mergeFile.exists() || !mergeName.endsWith(".merge")) break block14;
                    String existingName = this.resolveProperty(mergeName.replaceAll("\\.merge$", ""));
                    existingFile = new File(existingName);
                    if (this.getController().getProperty("12ByteCode").equalsIgnoreCase("basejars") && !existingFile.exists()) {
                        String fullPicklistName = existingName + ".full";
                        File fullPicklistFile = new File(fullPicklistName);
                        this.log.info("Maintenance for " + this.getController().getProperty("12ByteCode") + "contains a new picklist.");
                        if (fullPicklistFile.exists()) {
                            this.log.info("Copying new picklist: source: " + fullPicklistFile.getAbsolutePath() + "destination: " + existingFile.getAbsolutePath());
                            try {
                                this.getController().getFS().copyFile(fullPicklistFile, existingFile);
                            }
                            catch (Exception e) {
                                this.log.warn("Unable to copy new picklist to: " + existingFile.getAbsolutePath());
                                this.log.warn(Utils.getFormattedLogMsg(e));
                            }
                        } else {
                            this.log.warn("Full picklist does not exist: " + fullPicklistFile.getAbsolutePath());
                        }
                    } else {
                        existingStream = null;
                        mergeStream = null;
                        Picklist merge = new Picklist();
                        mergeStream = this.getController().getFS().getInputStream(mergeName);
                        merge.read(mergeStream);
                        Picklist existing = new Picklist();
                        if (existingFile.exists()) {
                            existingStream = this.getController().getFS().getInputStream(existingName);
                            existing.read(existingStream);
                        }
                        existing.mergeWith(merge);
                        bPickListInUse = true;
                        this.write(existing, existingFile);
                        this.closeQuietly(mergeStream);
                        this.closeQuietly(existingStream);
                        bPickListInUse = false;
                    }
                    break block15;
                    catch (Exception e) {
                        try {
                            this.log.error("Picklist file error, skipping merge for " + mergeFile, (Throwable)e);
                            this.closeQuietly(mergeStream);
                        }
                        catch (Throwable throwable) {
                            this.closeQuietly(mergeStream);
                            this.closeQuietly(existingStream);
                            bPickListInUse = false;
                            throw throwable;
                        }
                        this.closeQuietly(existingStream);
                        bPickListInUse = false;
                    }
                }
                this.log.info("setting " + existingFile + " timestamp to " + mergeTimestamp);
                existingFile.setLastModified(mergeTimestamp);
                EntryData mergeData = new EntryData(mergeFile);
                String action = "Removed";
                this.notifySetup("Removed", mergeData, "Removing merge file");
                if (mergeFile.delete()) {
                    this.notifyProgressComplete("Removed", mergeData);
                    continue;
                }
                this.notifyProgressFailure("Removed", mergeData);
                continue;
            }
            this.log.error("Merge picklist " + mergeFile + " doesn't exist or has bad name");
        }
    }

    private boolean closeQuietly(InputStream stream) {
        boolean closed = false;
        try {
            if (stream != null) {
                stream.close();
            }
            closed = true;
        }
        catch (IOException e) {
            this.log.error("Error closing stream", (Throwable)e);
        }
        return closed;
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
        for (EntryData original : this.originalPicklists) {
            original.performRestoreForTask(this);
        }
    }

    @Override
    public String descriptionForLog() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("fileList", this.getFiles().toString());
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    private List<String> getVisitedFilesForRestore() {
        if (visitedFilesForRestore == null) {
            visitedFilesForRestore = new ArrayList<String>();
        }
        return visitedFilesForRestore;
    }

    private boolean backupFile(String path) {
        return !this.getVisitedFilesForRestore().contains(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Picklist picklist, File file) throws IOException {
        EntryData data = new EntryData(file);
        String action = "Added";
        try {
            String path = file.getAbsolutePath();
            boolean backupFile = this.backupFile(path);
            if (backupFile && file.exists()) {
                action = "Changed";
                data.setCompareby("NONE");
                data.setBackup(true);
                data.initializeBackupData();
                data.performBackupForTask(this);
                this.getVisitedFilesForRestore().add(path);
            }
        }
        catch (InstallException e) {
            this.log.warn("Backup of " + file + " failed, trying to write anyway");
        }
        finally {
            this.notifySetup(action, data, "Merging pick list");
            try (OutputStream out = this.getController().getFS().getOutputStream(file.getPath());){
                picklist.write(out);
            }
            this.notifyProgressComplete(action, data);
            this.originalPicklists.add(data);
        }
    }

    private List<String> getFiles() {
        if (this.providedFiles == null || this.providedFiles.isEmpty()) {
            return ((MergePicklist)this.getData()).getFileList().getFile();
        }
        return this.providedFiles;
    }

    public void setFiles(List<String> files) {
        if (this.providedFiles == null) {
            this.providedFiles = new ArrayList<String>();
        }
        this.providedFiles = files;
    }
}

