/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.schema.install.gen.ArgList;
import com.sas.tools.installs.it.schema.install.gen.EmbedJava;
import com.sas.tools.installs.it.tasks.CommandLineArgTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class EmbedJavaTask
extends CommandLineArgTask {
    private static final String TASK_NAME = "EmbedJavaTask";
    private static Logger log = (Logger)LogManager.getLogger("com.sas.tools.installs.it.tasks.EmbedJavaTask");

    @Override
    public void postExecute() {
    }

    @Override
    public void preExecute() {
    }

    @Override
    public void retry() {
        log.info("Retrying by rerunning execute");
        this.execute();
    }

    @Override
    public void rollback() {
    }

    @Override
    public void execute() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getController().getProperty("JAVAEXE"));
        command.addAll(this.getResolvedArgs(this.getJavaArgList()));
        if (this.getJar() != null) {
            command.add("-cp");
            command.add(this.getJar());
        }
        if (this.getMainClass() != null) {
            command.add(this.getMainClass());
        }
        command.addAll(this.getResolvedArgs((EmbedJava)this.getData()));
        ProcessBuilder pb = new ProcessBuilder(command);
        log.info("exec-ing process with the following params:  " + command);
        try {
            Process conf = pb.start();
            conf.waitFor();
            int rc = conf.exitValue();
            if (rc != 0) {
                throw new InstallException(1, this, this.getBundle().messageString("EmbedJavaTask.JavaProcessFailed", rc), this.getEnBundle().messageString("EmbedJavaTask.JavaProcessFailed", rc), null);
            }
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException(1, this, this.getBundle().messageString("EmbedJavaTask.JavaProcessThrew"), this.getEnBundle().messageString("EmbedJavaTask.JavaProcessThrew"), e);
        }
    }

    private String getJar() {
        return ((EmbedJava)this.getData()).getJar();
    }

    private String getMainClass() {
        return ((EmbedJava)this.getData()).getMainClass();
    }

    private String getArgs() {
        return ((EmbedJava)this.getData()).getArgs();
    }

    private List<String> getArgList() {
        return this.getArgsList(((EmbedJava)this.getData()).getArgList());
    }

    private List<String> getJavaArgList() {
        return this.getArgsList(((EmbedJava)this.getData()).getJavaArgList());
    }

    private List<String> getArgsList(ArgList arglist) {
        if (arglist != null) {
            return arglist.getArg();
        }
        return Collections.emptyList();
    }

    @Override
    public String descriptionForLog() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (this.getJavaArgList() != null) {
            params.put("java args", this.getJavaArgList().toString());
        }
        if (this.getJar() != null) {
            params.put("jar", this.getJar());
        }
        if (this.getMainClass() != null) {
            params.put("main class", this.getMainClass());
        }
        if (this.getArgs() != null) {
            params.put("class args (attribute)", this.getArgs());
        }
        if (this.getArgList() != null) {
            params.put("class args (element)", this.getArgList().toString());
        }
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }
}

