/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.schema.install.gen.EditRegistration;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;

public class EditRegistrationTask
extends InstallationTask {
    private String _action;
    private int _hive;
    private int _type;
    private String _key;
    private String _value;
    private String _valueName;
    private String _existingAction = null;
    private long _existingType = -1L;
    private String _existingValue = null;
    private boolean _newKey = false;
    public static final String NEW = "new";
    public static final String ENTRY = "entry";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private WindowsRegistry _winReg = null;

    public EditRegistrationTask() {
        if (TaskHelper.getOS() == 1) {
            this._winReg = new WindowsRegistry();
        }
    }

    @Override
    public void execute() throws InstallException {
        if (TaskHelper.getOS() != 1) {
            this.log.info("Skipping execute for RegistryEditor task running on non-Windows OS");
            return;
        }
        this._winReg.setUninstallLog(this.getController().metadataBackupDirectory(), "EditRegistration");
        if (this.isUndo()) {
            this._winReg.uninstallRegistryKeys();
            return;
        }
        String key = "";
        String name = "";
        String value = "";
        boolean result = false;
        name = this.getValueName();
        if (name != null && "@".equals(name)) {
            name = "";
        }
        if (this.getValue() != null && !this.getValue().equals("")) {
            value = this.resolveProperty(this.getValue());
        }
        if (this.getKey() != null && !this.getKey().equals("")) {
            key = this.resolveProperty(this.getKey());
        }
        if ("addKey".equals(this.getAction()) || "removeKey".equals(this.getAction())) {
            this.log.info("perform registry operation: " + this.getAction() + ": " + WindowsRegistry.hiveToString(this.getHive()) + "\\" + key);
        } else {
            this.log.info("perform registry operation: " + this.getAction() + ": " + WindowsRegistry.hiveToString(this.getHive()) + "\\" + key + "\\" + this.getValueName() + " data: " + value + " type: " + WindowsRegistry.typeToString(this.getType()));
        }
        if (this.getAction().equals("addKey")) {
            result = this._winReg.createKey(this.getHive(), key);
        } else if (this.getAction().equals("addKey32")) {
            this._winReg.setBitMode(32);
            result = this._winReg.createKey(this.getHive(), key);
        } else if (this.getAction().equals("logKeyTree")) {
            result = this._winReg.logKeyTree(this.getHive(), key);
        } else if (this.getAction().equals("delKeyTree")) {
            result = this._winReg.delKeyTree(this.getHive(), key);
        } else if (this.getAction().equals("removeKey")) {
            result = this._winReg.deleteKey(this.getHive(), key);
        } else if (this.getAction().equals("removeKey32")) {
            this._winReg.setBitMode(32);
            result = this._winReg.deleteKey(this.getHive(), key);
        } else if (this.getAction().equals("setValue")) {
            result = this._winReg.setValue(this.getHive(), key, name, value, this.getType());
        } else if (this.getAction().equals("setValue32")) {
            this._winReg.setBitMode(32);
            result = this._winReg.setValue(this.getHive(), key, name, value, this.getType());
        } else if (this.getAction().equals("removeValue")) {
            result = this._winReg.deleteValue(this.getHive(), key, this.getValueName());
        } else if (this.getAction().equals("removeValue32")) {
            this._winReg.setBitMode(32);
            result = this._winReg.deleteValue(this.getHive(), key, this.getValueName());
        } else {
            this.log.error("unrecognized action: " + this.getAction());
        }
        if (!result) {
            String info = this.getAction() + ": " + WindowsRegistry.hiveToString(this.getHive()) + "\\" + key + "\\" + this.getValueName() + " " + this.getValue() + " " + WindowsRegistry.typeToString(this.getType());
            throw new InstallException(1, null, this.getController().getBundle().messageString("RegistryEditor.execute", info), "error occurred modifying Windows Registry: " + info, null);
        }
        this._winReg.writeUninstallData();
    }

    @Override
    public void postExecute() {
    }

    @Override
    public void preExecute() {
        this.notifySetup(this.getBundle().messageString("RegistryEditor.PreExecute"), this.getEnBundle().messageString("RegistryEditor.PreExecute"));
        this.setAction(((EditRegistration)this.getData()).getAction());
        this.setHive(((EditRegistration)this.getData()).getHive());
        this.setKey(((EditRegistration)this.getData()).getKey());
        this.setValueName(((EditRegistration)this.getData()).getName());
        this.setValue(((EditRegistration)this.getData()).getData());
        this.setType(((EditRegistration)this.getData()).getType());
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
        if (TaskHelper.getOS() != 1) {
            this.log.info("Skipping rollback for RegistryEditor task running on non-Windows OS");
            return;
        }
        this._winReg.rollbackRegistryKeys();
    }

    @Override
    public String descriptionForLog() {
        return null;
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        this._action = action;
    }

    public int getHive() {
        return this._hive;
    }

    public void setHive(String hive) {
        this._hive = WindowsRegistry.stringToHive(hive);
    }

    public int getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = WindowsRegistry.stringToType(type);
    }

    public String getKey() {
        return this._key;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String getValueName() {
        return this._valueName;
    }

    public void setValueName(String valueName) {
        this._valueName = valueName;
    }

    public String getExistingAction() {
        return this._existingAction;
    }

    public void setExistingAction(String existingAction) {
        this._existingAction = existingAction;
    }

    public long getExistingType() {
        return this._existingType;
    }

    public void setExistingType(long existingType) {
        this._existingType = existingType;
    }

    public String getExistingValue() {
        return this._existingValue;
    }

    public void setExistingValue(String existingValue) {
        this._existingValue = existingValue;
    }

    public boolean isNewKey() {
        return this._newKey;
    }

    public void setNewKey(boolean newKey) {
        this._newKey = newKey;
    }
}

