/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.schema.install.gen.CreateLauncherShortcut;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class CreateLauncherShortcutTask
extends InstallationTask {
    protected Logger log = (Logger)LogManager.getLogger(this.getClass().getName());

    @Override
    public String descriptionForLog() {
        return null;
    }

    @Override
    public void execute() throws InstallException {
        if (TaskHelper.isUnix()) {
            try {
                this.generateScript();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String addSASRootPath(String str) {
        String temp = "";
        File sas = new File(this.getSasRoot());
        temp = str.replaceAll("@ABSOLUTE_SAS_ROOT@", sas.getAbsolutePath());
        return temp;
    }

    public String addConfigFilePath1(String str) {
        String temp = "";
        String cfgFilePrefix = this.getSasConfigFile().replaceAll("\\..*$", "");
        String cfgFile1 = this.isLangDBCS() ? "\"!SASROOT/" + this.getSasConfigFile() + ", !SASROOT/dbcs/" + this.getSasConfigFile() + ", !SASROOT/nls/" + this.getLangCode() + "/" + this.getSasConfigFile() + ", !SASROOT/" + cfgFilePrefix + "_local.cfg," : "\"!SASROOT/" + this.getSasConfigFile() + ", !SASROOT/nls/" + this.getLangCode() + "/" + this.getSasConfigFile() + ", !SASROOT/" + cfgFilePrefix + "_local.cfg,";
        temp = str.replace("@SET_SASCFGPATH_1@", cfgFile1);
        return temp;
    }

    public String addConfigFilePath2(String str) {
        String temp = "";
        String cfgFile2 = "";
        String cfgFilePrefix = this.getSasConfigFile().replaceAll("\\..*$", "");
        cfgFile2 = this.isLangDBCS() ? "\"!SASROOT/" + this.getSasConfigFile() + ", !SASROOT/dbcs/" + this.getSasConfigFile() + ", !SASROOT/nls/" + this.getLangCode() + "/" + this.getSasConfigFile() + ", !SASROOT/" + cfgFilePrefix + "_local.cfg\"" : "\"!SASROOT/" + this.getSasConfigFile() + ", !SASROOT/nls/" + this.getLangCode() + "/" + this.getSasConfigFile() + ", !SASROOT/" + cfgFilePrefix + "_local.cfg\"";
        temp = str.replace("@SET_SASCFGPATH_2@", cfgFile2);
        return temp;
    }

    public String addH64Check(String str) {
        String temp = "";
        temp = TaskHelper.getOS_Suffix() == "h64" ? str.replace("<HP>", "") : str.replace("<HP>.*\n", "");
        return temp;
    }

    public void generateScript() throws Exception {
        String updatedScriptFile = "";
        String temp = "";
        this.log.info("Creating " + this.getLangCode() + " launcher script...");
        try {
            File script = new File(this.getScriptPath());
            if (script.exists()) {
                StringBuffer buffer = new StringBuffer();
                BufferedReader reader = new BufferedReader(new FileReader(script));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    buffer.append(line).append("\n");
                }
                reader.close();
                FileWriter writer = new FileWriter(script);
                temp = this.addSASRootPath(buffer.toString());
                temp = this.addConfigFilePath1(temp);
                temp = this.addConfigFilePath2(temp);
                updatedScriptFile = this.addH64Check(temp);
                writer.write(updatedScriptFile);
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.warn("Error writing launcher invocation script ");
        }
        this.log.info("Created launcher invocation script");
    }

    public void setConfigLookthrough() throws Exception {
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    public String getLangCode() {
        return ((CreateLauncherShortcut)this.getData()).getLangCode();
    }

    public boolean isLangDBCS() {
        return ((CreateLauncherShortcut)this.getData()).isLangDBCS();
    }

    public String getSasConfigFile() {
        return ((CreateLauncherShortcut)this.getData()).getFile();
    }

    public String getSasRoot() {
        return Controller.defaultController().getProperty("ProductHome");
    }

    public String getScriptPath() {
        return this.getSasRoot() + "/bin/sas_" + this.getLangCode();
    }
}

