/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;

public class ConfigurePCFileSrvTask
extends InstallationTask {
    WindowsRegistry _winRegLog = null;
    WindowsRegistry _winRegNoLog = null;
    private static ConfigurePCFileSrvTask _configurePCFileSrvTask = null;
    private static String _serviceName = "\"SAS PC Files Server\"";
    protected String _svcAuto = "auto";
    protected String _svcPort = "9621";

    public ConfigurePCFileSrvTask() {
        _configurePCFileSrvTask = this;
        this._winRegLog = new WindowsRegistry();
        this._winRegNoLog = new WindowsRegistry();
    }

    @Override
    public String descriptionForLog() {
        return "PCFiles Server";
    }

    @Override
    public void preExecute() throws Exception {
        this._winRegLog.setUninstallLog(this.getController().metadataBackupDirectory(), "ConfigurePCFileSrv");
        if (this.getController().getProperty("Host").equalsIgnoreCase("win")) {
            this._winRegNoLog.setBitMode(32);
            this._winRegLog.setBitMode(32);
            this.log.debug("Installing 32-bit product");
        } else if (this.getController().getProperty("Host").equalsIgnoreCase("wx6")) {
            this._winRegNoLog.setBitMode(64);
            this._winRegLog.setBitMode(64);
            this.log.debug("Installing 64-bit product");
        } else {
            this.log.debug("Detected 'Host' property is: " + this.getController().getProperty("Host"));
        }
        if (this.isUndo()) {
            return;
        }
        if (!JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, WinRegAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib(WinRegAPI.libNames);
            throw new InstallException(2, null, this._bundle.messageString("Shared.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        this.notifySetup("Installing PCFileSrv");
        this.log.debug("in PCFileSrv preExecute");
    }

    @Override
    public void execute() throws InstallException {
        if (this.isUndo()) {
            this._winRegLog.uninstallRegistryKeys();
            this.rollback();
            return;
        }
        this.log.info("Configuring PCFiles Server");
        this._svcAuto = Controller.installProperties.getProperty("pcfilesrv.service.auto");
        this._svcPort = Controller.installProperties.getProperty("pcfilesrv.port");
        this.log.info("ConfigPCFileSrv Execute:  _svcAuto = " + this._svcAuto);
        this.log.info("ConfigPCFileSrv Execute:  _svcPort = " + this._svcPort);
        this.setRegKeys();
        String command = "";
        command = this.resolveProperty("${ProductHome}\\pcfservice.exe -install");
        this.log.info("ConfigPCFileSrv Execute: " + command);
        TaskHelper.executeCommand(command);
        String app = this.resolveProperty("${WINSYSDIR32}\\sc.exe");
        String description = " \"Enables SAS/ACCESS interface to PC Files, such as Excel and MS Access.\"";
        command = app + " description " + _serviceName + description;
        this.log.info("ConfigPCFileSrv Execute: " + command);
        TaskHelper.executeCommand(command);
        command = app + " failure " + _serviceName + " reset= 3600 actions= restart/1000/restart/1000//";
        this.log.info("ConfigPCFileSrv Execute: " + command);
        TaskHelper.executeCommand(command);
        command = "false".equalsIgnoreCase(Controller.installProperties.getProperty("pcfilesrv.service.auto")) ? app + " config " + _serviceName + " start= demand" : app + " config " + _serviceName + " start= auto";
        this.log.info("ConfigPCFileSrv Execute: " + command);
        TaskHelper.executeCommand(command);
        if ("true".equalsIgnoreCase(Controller.installProperties.getProperty("pcfilesrv.service.auto"))) {
            command = app + " start " + _serviceName;
            this.log.info("ConfigPCFileSrv Execute: " + command);
            TaskHelper.executeCommand(command);
        }
        this._winRegLog.writeUninstallData();
    }

    private void setRegKeys() {
        int hKey = 8;
        String prodname = this.getController().getProperty("ProductName");
        String prodversion = this.getController().getProperty("ProductVersion");
        String subKey = "SOFTWARE\\SAS Institute Inc.";
        if (!this._winRegLog.keyExists(hKey, subKey)) {
            this._winRegLog.createKey(hKey, subKey);
        }
        if (!this._winRegLog.keyExists(hKey, subKey = this.resolveProperty(subKey.concat("\\" + prodname)))) {
            this._winRegLog.createKey(hKey, subKey);
        }
        String valueName = "Path";
        String value = this.resolveProperty("${ProductHome}");
        this._winRegLog.setValue(hKey, subKey, valueName, value, 109);
        subKey = this.resolveProperty(subKey.concat("\\Settings"));
        if (!this._winRegLog.keyExists(hKey, subKey)) {
            this._winRegLog.createKey(hKey, subKey);
        }
        valueName = "Port";
        value = this._svcPort;
        this._winRegLog.setValue(hKey, subKey, valueName, value, 109);
        this.cleanUp();
    }

    public void cleanUp() {
        int hKey = 4;
        String subKey = "SOFTWARE\\SAS Institute Inc.\\PCFILES Server";
        this._winRegNoLog.setBitMode(64);
        this._winRegNoLog.delKeyTree(hKey, subKey);
        this._winRegNoLog.setBitMode(32);
        this._winRegNoLog.delKeyTree(hKey, subKey);
        hKey = 16;
        subKey = ".DEFAULT\\Software\\SAS Institute Inc.\\PCFILES Server";
        this._winRegNoLog.delKeyTree(hKey, subKey);
        this._winRegNoLog.setBitMode(64);
        this._winRegNoLog.delKeyTree(hKey, subKey);
    }

    @Override
    public void postExecute() throws Exception {
        this.log.debug("in PCFiles Server postExecute");
    }

    @Override
    public void retry() throws InstallException {
        this.log.debug("in PCFiles Server retry");
    }

    @Override
    public void rollback() throws InstallException {
        this.log.debug("in PCFiles Server rollback");
        String app = this.resolveProperty("${WINSYSDIR32}\\sc.exe");
        String command = app + " stop " + _serviceName;
        TaskHelper.executeCommand(command);
        command = app + " delete " + _serviceName;
        TaskHelper.executeCommand(command);
        if (!this.isUndo()) {
            this._winRegLog.rollbackRegistryKeys();
        }
    }
}

