/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.tasks.InstallationTask;
import java.util.logging.Logger;

public class ConfigureMSOfficeIntTask
extends InstallationTask {
    private static Logger log = Logger.getLogger("com.sas.tools.installs.it.tasks.Configure.MSOfficeIntTask");
    private static final String propertyHeader = "msofficeint.office.";
    private static final String msofficeintLiteProp = "msofficeint.is_lite";
    private static final String msofficeintRegisterProp = "msofficeint.register.options";
    private static final String REGISTER = "+";
    private static final String UNREGISTER = "-";
    private static final String DISALLOW = "#";

    @Override
    public String descriptionForLog() {
        return "Add-in for Microsoft Office Configuration";
    }

    @Override
    public void execute() throws InstallException {
        if (this.isUndo()) {
            this.rollback();
            return;
        }
        String registrationOptions = "";
        String msofficeintLite = Controller.installProperties.getProperty(msofficeintLiteProp);
        for (OfficeProperty prop : OfficeProperty.values()) {
            String action = UNREGISTER;
            String propValue = Controller.installProperties.getProperty(propertyHeader + prop.toString());
            if (msofficeintLite != null && msofficeintLite.equalsIgnoreCase("true")) {
                action = prop.toString().equals("excel") ? REGISTER : DISALLOW;
            } else if (propValue == null) {
                action = null;
            } else if (propValue.equalsIgnoreCase("true")) {
                action = REGISTER;
            }
            if (action == null) continue;
            String officeProduct = prop.toString().toUpperCase();
            registrationOptions = registrationOptions.concat(officeProduct + "=\"" + action + officeProduct + "\" ");
        }
        Controller.installProperties.setProperty(msofficeintRegisterProp, registrationOptions);
        log.info("Add-In for Microsoft Office registration options: " + registrationOptions);
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    public static enum OfficeProperty {
        excel,
        word,
        powerpoint,
        outlook;

    }
}

