/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigParser {
    private FileInputStream systemSectionFIS = null;
    protected File _originalConfigFile;
    protected String _originalUserConfigSectionString = "";
    protected String _originalSystemConfigSectionString = "";
    protected boolean borderLineFound = false;
    protected Document _configDocument;
    protected Logger log = (Logger)LogManager.getLogger(this.getClass().getName());
    protected String userStatement = "";
    protected final String borderLine = "DO NOT EDIT BELOW THIS LINE - INSTALL Application edits below this line";

    public ConfigParser() {
    }

    public ConfigParser(File configFile) {
        this();
        this.setOriginalConfigFile(configFile);
    }

    public void parseOriginal() throws ParserConfigurationException, IOException {
        if (this.getOriginalConfigFile() == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.newDocument();
        this.setConfigDocument(doc);
        Element root = doc.createElement("config");
        doc.appendChild(root);
        try {
            String data;
            this.systemSectionFIS = this.systemSectionConfigFile(this.getOriginalConfigFile());
            if (this.systemSectionFIS == null) {
                return;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(this.systemSectionFIS));
            StringBuffer prepend = new StringBuffer();
            while ((data = in.readLine()) != null) {
                if (data.length() == 0 || data.matches("\\s*")) {
                    prepend.append("\n");
                    while ((data = in.readLine()) != null) {
                        if (data.length() == 0 || data.matches("\\s*")) {
                            prepend.append("\n");
                            continue;
                        }
                        data = prepend.toString() + data;
                        prepend = new StringBuffer();
                        break;
                    }
                }
                if (data == null) {
                    break;
                }
                if (data.matches("\\s*\\/\\*.*")) {
                    StringBuffer comment = new StringBuffer(data + "\n");
                    if (!data.matches("\\s*\\/\\*.*?\\*\\/\\s*")) {
                        while ((data = in.readLine()) != null) {
                            comment.append(data + "\n");
                            if (data.length() == 0) {
                                comment.append("\n");
                                continue;
                            }
                            if (!data.matches(".*\\*\\/")) continue;
                        }
                    }
                    Element commentElement = doc.createElement("commentBlock");
                    commentElement.setTextContent(comment.toString().substring(0, comment.length() - 1));
                    root.appendChild(commentElement);
                    continue;
                }
                if (data.matches("\\s*-\\S*\\s*[^\"']*\\(.*")) {
                    Pattern pattern;
                    Matcher matcher;
                    StringBuffer propertyData = new StringBuffer(data);
                    if (!data.matches("\\s*-.*?\\s*\\(.*?\\)\\s*")) {
                        while ((data = in.readLine()) != null) {
                            propertyData.append(data);
                            if (data.length() == 0) {
                                propertyData.append("\n");
                                continue;
                            }
                            if (data.replaceAll("\\(([^()]*?)\\)", "").matches(".*\\)[^\"']*\\s*")) break;
                            if (!data.matches("\\s*\\S.*")) continue;
                            propertyData.append("^$CFG_FILE_EOL");
                        }
                    }
                    if (!(matcher = (pattern = Pattern.compile("\\s*-(\\S*([\\s*?|\\s*=\\s*])\\S*?)\\s*?\\((.*?)\\)\\s*$", 32)).matcher(propertyData.toString())).find()) continue;
                    String preList = matcher.group(1);
                    if ((preList = preList.trim()).endsWith("=")) {
                        preList = preList.substring(0, preList.length() - 1);
                    }
                    preList = preList.toUpperCase(Locale.ENGLISH);
                    String list = matcher.group(3);
                    Element listContainer = this.appendTagsFromString(preList, false);
                    listContainer.setAttribute("separator", matcher.group(2));
                    Pattern listPattern = Pattern.compile("\\s*(\".*?\"|.*?)\\^\\$CFG_FILE_EOL");
                    Matcher listMatcher = listPattern.matcher(list);
                    int size = 0;
                    while (listMatcher.find()) {
                        ++size;
                        String tagName = "location";
                        if (listMatcher.group(1).startsWith("-")) {
                            tagName = "entry";
                        }
                        Element listElement = doc.createElement(tagName);
                        listElement.setTextContent(listMatcher.group(1));
                        listContainer.appendChild(listElement);
                    }
                    listContainer.setAttribute("size", String.valueOf(size));
                    continue;
                }
                if (data.matches("\\s*-\\S*?\\s*")) {
                    String singleEntry = data.replaceFirst("\\s*-", "").trim().toUpperCase(Locale.ENGLISH);
                    Element singleElement = doc.createElement(singleEntry);
                    root.appendChild(singleElement);
                    continue;
                }
                String[] optionArr = data.replaceFirst("\\s*-", "").split(" ");
                if (optionArr[0].length() > 0) {
                    optionArr[0] = optionArr[0].toUpperCase(Locale.ENGLISH);
                    if (optionArr[0].equalsIgnoreCase("SET")) {
                        optionArr[1] = optionArr[1].toUpperCase(Locale.ENGLISH);
                    }
                    String option = ConfigParser.join(optionArr, " ");
                    this.appendTagsFromString(option, true);
                    continue;
                }
                this.appendTagsFromString(data.replaceFirst("\\s*-", ""), true);
            }
        }
        catch (DOMException e) {
            this.log.info("The line '" + this.userStatement + "' in " + this.getOriginalConfigFile().getAbsolutePath() + " cannot be parsed.");
            if (TaskHelper.getOS() == 1) {
                this.log.info("Try placing the line in the top section of the config file above the 'DO NOT EDIT BELOW THIS LINE - INSTALL Application edits below this line'.");
            }
            Controller.logStackTrace(e);
            throw e;
        }
        finally {
            if (null != this.systemSectionFIS) {
                this.systemSectionFIS.close();
            }
        }
    }

    public Element appendTagsFromString(String logSnippet, boolean lastContentIsTextEntry) {
        Pattern pattern = Pattern.compile("\".*?\"|\\S+|[^\\s*?=\\s*?]");
        Matcher matcher = pattern.matcher(logSnippet);
        this.userStatement = logSnippet;
        Node nextTag = null;
        if (matcher.find()) {
            String tag;
            while ((tag = matcher.group()) != null) {
                Element newTag;
                if (matcher.find()) {
                    newTag = this.getConfigDocument().createElement(tag);
                    if (nextTag == null) {
                        this.getConfigDocument().getFirstChild().appendChild(newTag);
                    } else {
                        nextTag.appendChild(newTag);
                    }
                    nextTag = newTag;
                    continue;
                }
                if (lastContentIsTextEntry) {
                    nextTag.setTextContent(tag);
                    return nextTag;
                }
                newTag = this.getConfigDocument().createElement(tag);
                if (nextTag == null) {
                    this.getConfigDocument().getFirstChild().appendChild(newTag);
                } else {
                    nextTag.appendChild(newTag);
                }
                return newTag;
            }
        }
        return nextTag;
    }

    public File getOriginalConfigFile() {
        return this._originalConfigFile;
    }

    public void setOriginalConfigFile(File originalConfigFile) {
        this._originalConfigFile = originalConfigFile;
    }

    public Document getConfigDocument() {
        return this._configDocument;
    }

    public void setConfigDocument(Document configDocument) {
        this._configDocument = configDocument;
    }

    public static String join(String[] s, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            buffer.append(s[i]);
            buffer.append(delimiter);
        }
        return buffer.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInputStream systemSectionConfigFile(File orgConfigFile) {
        String userSectionFileName = "userSection.cfg";
        String systemSectionFileName = "systemSection.cfg";
        String configFilePath = orgConfigFile.getParent();
        BufferedWriter userSectionFile = null;
        BufferedWriter systemSectionFile = null;
        String userline = "";
        String systemline = "";
        this.borderLineFound = false;
        try {
            Scanner scanner = new Scanner(orgConfigFile);
            userSectionFile = new BufferedWriter(new FileWriter(userSectionFileName));
            systemSectionFile = new BufferedWriter(new FileWriter(systemSectionFileName));
            try {
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    if (line.indexOf("DO NOT EDIT BELOW THIS LINE - INSTALL Application edits below this line") > 0) {
                        this.borderLineFound = true;
                    }
                    if (!this.borderLineFound) {
                        userline = userline + line + System.getProperty("line.separator");
                        continue;
                    }
                    this._originalSystemConfigSectionString = systemline = systemline + line + System.getProperty("line.separator");
                }
                if (!userline.equals("") && this.borderLineFound) {
                    if (TaskHelper.getOS() == 1) {
                        userline = this.replaceFormCharForAnsi(configFilePath, userline);
                    }
                    this._originalUserConfigSectionString = userline;
                }
                if (!this.borderLineFound) {
                    this._originalUserConfigSectionString = null;
                    this.log.info("The line with 'DO NOT EDIT BELOW THIS LINE - INSTALL Application edits below this line' is not found in sasv9.cfg");
                }
            }
            catch (Exception e) {
                Controller.logStackTrace(e);
            }
            finally {
                scanner.close();
            }
            try {
                if (this.borderLineFound) {
                    systemSectionFile.write(systemline);
                } else {
                    systemSectionFile.write(userline);
                }
            }
            catch (IOException e) {
                Controller.logStackTrace(e);
            }
            finally {
                try {
                    if (userSectionFile != null) {
                        userSectionFile.close();
                    }
                    if (systemSectionFile != null) {
                        systemSectionFile.close();
                    }
                    return new FileInputStream(systemSectionFileName);
                }
                catch (IOException e) {
                    Controller.logStackTrace(e);
                }
            }
        }
        catch (IOException e) {
            Controller.logStackTrace(e);
        }
        return null;
    }

    private String replaceFormCharForAnsi(String configFilePath, String originalUserSection) {
        String updatedUserSection = null;
        updatedUserSection = configFilePath.endsWith("en") || configFilePath.endsWith("fr") || configFilePath.endsWith("it") || configFilePath.endsWith("es") || configFilePath.endsWith("de") || configFilePath.endsWith("da") || configFilePath.endsWith("sv") ? originalUserSection : originalUserSection.replace("'82838485868788898A8B8C2B3D7C2D2F5C3C3E2A'x", "'7c2d2d2d2d7c2b7c2d2d2d2b3d7c2d2f5c3c3e2a'x");
        return updatedUserSection;
    }
}

