/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.deploy.util.SASRuntimeWrapper;
import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.tasks.EditSASConfigTask;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.resource.InputStreamConsumer;
import com.sas.tools.installs.schema.ittasks.ExecutableType;
import com.sas.tools.installs.schema.ittasks.FalseSkuType;
import com.sas.tools.installs.schema.ittasks.FileCheckType;
import com.sas.tools.installs.schema.ittasks.ObjectFactory;
import com.sas.tools.installs.schema.ittasks.PreRegCheckType;
import com.sas.tools.installs.schema.ittasks.RegActionType;
import com.sas.tools.installs.schema.ittasks.RegCheckType;
import jakarta.xml.bind.JAXBContext;
import java.io.File;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class CheckPairsGroupTypeTask
extends InstallationTask {
    private static final String HKEY_CLASSES_ROOT = "HKEY_CLASSES_ROOT";
    private static final String HKEY_CURRENT_USER = "HKEY_CURRENT_USER";
    private static final String HKEY_LOCAL_MACHINE = "HKEY_LOCAL_MACHINE";
    private static final String HKEY_USERS = "HKEY_USERS";
    private static final String HKEY_CURRENT_CONFIG = "HKEY_CURRENT_CONFIG";
    private static final String DELETE = "DELETE";
    private static final String GREATERTHAN = "GREATERTHAN";
    private static final String LESSTHAN = "LESSTHAN";
    private static final String NOTEXIST = "NOTEXIST";
    private static final String NOTEQUAL = "NOTEQUAL";
    private static final String BIT64_EXECUTABLE_PATH = "\\wx6";
    private static final long VER_NT_WORKSTATION = 1L;
    private static final long VER_SUITE_DATACENTER = 128L;
    private static final long VER_SUITE_ENTERPRISE = 2L;
    private static final long VER_SUITE_BLADE = 1024L;
    private static final int REG_DWORD = 4;
    private static JAXBContext jc;
    private static ObjectFactory objFactory;
    private static final String WINDOWS_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
    private boolean notApplicable;

    @Override
    public String descriptionForLog() {
        return "FalseSkuTypeTask";
    }

    @Override
    public String getDescription() {
        return "FalseSkuTypeTask";
    }

    @Override
    public void preExecute() throws Exception {
        this.notifySetup("sysReq." + this.getController().getProperty("12ByteCode") + ".found", "Notifying SDW that " + this.getController().getProperty("12ByteCode") + " is a system Requisite.");
        boolean willInstall = false;
        this.notApplicable = true;
        Iterator<ExecutableType> exeIter = this.getController().getDeployment().getFalseSkus().getExecutables().iterator();
        while (!willInstall && exeIter.hasNext()) {
            ExecutableType exe = exeIter.next();
            willInstall = this.checkExecutable(exe);
        }
        if (this.notApplicable) {
            this.notifySetup("sysReq." + this.getController().getProperty("12ByteCode") + ".isNotApplicable", "Notifying SDW that " + this.getController().getProperty("12ByteCode") + " is not applicable.");
        } else if (willInstall) {
            this.notifySetup("sysReq." + this.getController().getProperty("12ByteCode") + ".willInstall", "Notifying SDW that " + this.getController().getProperty("12ByteCode") + " will be installed.");
        } else {
            this.notifySetup("sysReq." + this.getController().getProperty("12ByteCode") + ".willNotInstall", "Notifying SDW that " + this.getController().getProperty("12ByteCode") + " will not be installed.");
        }
    }

    @Override
    public void execute() throws InstallException {
        this.processFalseSku(this.getController().getDeployment().getFalseSkus());
    }

    private void processFalseSku(FalseSkuType srwInfo) {
        for (ExecutableType exe : srwInfo.getExecutables()) {
            this.processExecutable(exe);
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    public CheckPairsGroupTypeTask() {
        this.log.info("IN FalseSkuTypeTask constructor");
    }

    private void processExecutable(ExecutableType exe) {
        this.notApplicable = true;
        this.log.info("Beginning Check for: " + exe.getName());
        Iterator<ExecutableType> preReqIter = exe.getPreReqs().iterator();
        while (preReqIter.hasNext()) {
            this.processExecutable(preReqIter.next());
        }
        boolean is32bit = true;
        if (exe.getPath().startsWith(BIT64_EXECUTABLE_PATH)) {
            is32bit = false;
        }
        if (this.processCheck(exe, is32bit) || !this.notApplicable && Controller.installProperties.getProperty("create.batch.file") == "TRUE") {
            this.runExecute(exe);
            for (RegActionType ra : exe.getPostUpdate()) {
                this.runPostUpdate(ra, is32bit);
            }
        }
    }

    private boolean checkExecutable(ExecutableType exe) {
        this.log.info("Beginning Check for: " + exe.getName());
        boolean is32bit = true;
        if (exe.getPath().startsWith(BIT64_EXECUTABLE_PATH)) {
            is32bit = false;
        }
        return this.processCheck(exe, is32bit);
    }

    private void runPostUpdate(RegActionType ra, boolean is32bit) {
        this.log.info("Running post update");
        if (ra.getRegAction().value().equalsIgnoreCase(DELETE)) {
            if (ra.getRegName() == null) {
                WinRegAPI.DelRegKey(this.getIntValueForRegistryKey(ra.getRegRoot()), ra.getRegKey());
            } else if (is32bit) {
                WinRegAPI.DelRegKeyValue(this.getIntValueForRegistryKey(ra.getRegRoot()), ra.getRegKey(), ra.getRegName());
            } else {
                WinRegAPI.DelRegKeyValue64(this.getIntValueForRegistryKey(ra.getRegRoot()), ra.getRegKey(), ra.getRegName());
            }
        }
    }

    private boolean processCheck(ExecutableType cp, boolean is32bit) {
        this.log.info("Executing Checks for: " + cp.getName());
        if (TaskHelper.getOS_Suffix().equals("win") && !is32bit) {
            this.log.info("Executable is 64 bit and os is not, returning false");
            return false;
        }
        List<Object> preChecks = cp.getRegCheckOrPreRegCheckOrFileCheck();
        ArrayList<Object> checks = new ArrayList<Object>();
        if (this.getController().getProperty("12ByteCode").equalsIgnoreCase("DOTNET40") && (System.getProperty("os.name").equals("Windows 8") || System.getProperty("os.name").equals("Windows Server 2012"))) {
            this.notApplicable = false;
        }
        if (!this.checkOs(cp.getOsFilter())) {
            return false;
        }
        if (!this.checkLanguage(cp.getLangFilter())) {
            return false;
        }
        this.notApplicable = false;
        for (Object preCheck : preChecks) {
            if (preCheck instanceof PreRegCheckType) {
                PreRegCheckType prc = (PreRegCheckType)preCheck;
                if (!this.doRegComparison(prc.getRegRoot(), prc.getRegKey(), prc.getRegName(), prc.getRegValue(), prc.getRegCmp().value(), is32bit)) continue;
                return true;
            }
            checks.add(preCheck);
        }
        for (Object check : checks) {
            FileCheckType fc;
            if (check instanceof RegCheckType) {
                RegCheckType rc = (RegCheckType)check;
                try {
                    if (rc.getRegMode() != null) {
                        if (rc.getRegMode().equalsIgnoreCase("32bit")) {
                            is32bit = true;
                            this.log.info("32bit regMode is FORCED!");
                        } else if (rc.getRegMode().equalsIgnoreCase("64bit")) {
                            is32bit = false;
                            this.log.info("64bit regMode is FORCED!");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.doRegComparison(rc.getRegRoot(), rc.getRegKey(), rc.getRegName(), rc.getRegValue(), rc.getRegCmp().value(), is32bit)) {
                    return true;
                }
            }
            if (!(check instanceof FileCheckType) || !this.doFileComparison(fc = (FileCheckType)check)) continue;
            return true;
        }
        return false;
    }

    private boolean checkOs(List<String> osFilter) {
        String osInfo = SASWinAPI.GetWinVerStr();
        String systemOS = "";
        this.log.info("Checking Operating System");
        this.log.info("osInfo= " + osInfo);
        if (osInfo != null) {
            String[] items = osInfo.split("\\.");
            if (items.length == 8) {
                long architecture;
                block28: {
                    long osMajor = Long.parseLong(items[0]);
                    long osMinor = Long.parseLong(items[1]);
                    long prodType = Long.parseLong(items[5]);
                    architecture = Long.parseLong(items[6]);
                    int buildNumber = 0;
                    try {
                        buildNumber = Integer.parseInt(WinRegAPI.getWindowsRegistryValue(8, WINDOWS_KEY, "CurrentBuildNumber"));
                        this.log.info("buildNumber=" + buildNumber);
                        if (osMajor == 10L && buildNumber >= 20348) {
                            osMajor = 11L;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.log.info("WinRegAPI failed to get CurrentBuildNumber.");
                    }
                    if (osMajor == 6L) {
                        if (osMinor == 3L) {
                            systemOS = prodType == 1L ? "Windows 8.1" : "Windows Server 2012 R2";
                        } else if (osMinor == 2L) {
                            systemOS = prodType == 1L ? "Windows 8" : "Windows Server 2012";
                        } else if (osMinor == 1L) {
                            systemOS = prodType == 1L ? "Windows 7" : "Windows Server 2008 R2";
                        } else if (osMinor == 0L) {
                            systemOS = prodType == 1L ? "Windows Vista" : "Windows Server 2008";
                        }
                    } else if (osMajor == 10L) {
                        if (osMinor == 0L) {
                            if (prodType == 1L) {
                                systemOS = "Windows 10";
                            } else {
                                try {
                                    if (buildNumber < 17763) {
                                        systemOS = "Windows Server 2016";
                                        break block28;
                                    }
                                    systemOS = "Windows Server 2019";
                                }
                                catch (NumberFormatException ex) {
                                    systemOS = "";
                                }
                            }
                        }
                    } else if (osMajor == 11L && osMinor == 0L) {
                        systemOS = prodType == 1L ? "Windows 11" : (buildNumber >= 26100 ? "Windows Server 2025" : "Windows Server 2022");
                    }
                }
                if (architecture == 0L) {
                    systemOS = systemOS + " 32-bit";
                } else if (architecture == 9L) {
                    systemOS = systemOS + " 64-bit";
                }
            }
        } else {
            this.log.error("JNI call for system info returned unexpected results.");
        }
        this.log.info("System OS reported: " + systemOS);
        for (String s : osFilter) {
            if (!s.equalsIgnoreCase(systemOS)) continue;
            this.log.info("os matched");
            return true;
        }
        this.log.info("Could not find OS, returning false");
        return false;
    }

    private boolean checkLanguage(List<String> langFilter) {
        if (langFilter.size() == 0) {
            this.log.info("No Language Filters - returning true");
            return true;
        }
        this.log.info("Checking Language");
        String systemLanguage = EditSASConfigTask.localeToLang2(Locale.getDefault().toString());
        this.log.info("IT Controller Language is: " + systemLanguage);
        for (String s : langFilter) {
            if (!systemLanguage.equalsIgnoreCase(s)) continue;
            this.log.info("Language matched, returning true");
            return true;
        }
        this.log.info("Could not find applicable language, returning false");
        return false;
    }

    private String getSystemDirectory() {
        return WinRegAPI.getWindowsRegistryValue(8, WINDOWS_KEY, "PathName");
    }

    private boolean doFileComparison(FileCheckType fc) {
        this.log.info("Checking File Versions");
        String comparisonValue = fc.getRegCmp().value();
        this.log.info("comparisonValue is: " + comparisonValue);
        String fileName = fc.getName();
        if (fileName.contains("${WINDIR}")) {
            String sysDir = this.getSystemDirectory().replaceFirst("\\\\", "\\\\\\\\");
            fileName = fileName.replaceFirst("\\$\\{WINDIR\\}", sysDir);
        }
        if (fileName.contains("${WINSYSDIR}")) {
            fileName = this.resolveProperty(fileName);
        }
        if (fileName.contains("${WINSYSDIR32}")) {
            fileName = this.resolveProperty(fileName);
        }
        if (fileName.contains("${WINSYSDIR64}")) {
            fileName = this.resolveProperty(fileName);
        }
        this.log.info("fileName " + fileName);
        File file = new File(fileName);
        if (!file.exists()) {
            this.log.info("File " + file.getAbsolutePath() + " not found.  returning true.");
            return true;
        }
        try {
            int comparisonMade = DiskInfoAPI.compareFileVersionToString(file, fc.getVersion());
            if (comparisonValue.equalsIgnoreCase(GREATERTHAN) && comparisonMade < 0) {
                this.log.info("returning true");
                return true;
            }
            if (comparisonValue.equalsIgnoreCase(LESSTHAN) && comparisonMade > 0) {
                this.log.info("returning true");
                return true;
            }
            if (comparisonValue.equalsIgnoreCase(NOTEQUAL) && comparisonMade != 0) {
                this.log.info("returning true");
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.info("returning false");
        return false;
    }

    private boolean doRegComparison(String root, String key, String name, String expectedValue, String comparisonValue, boolean is32bit) {
        this.log.info("Checking Registry Values");
        this.log.info("registryvalue for " + root + " " + key + " " + name);
        this.log.info("comparison is: " + comparisonValue);
        this.log.info("expectedValue is: " + expectedValue);
        JNIUtils.libraryLoaded(this.getDllPath(), WinRegAPI.libNames);
        if (!comparisonValue.equalsIgnoreCase(NOTEXIST)) {
            String value = null;
            value = (TaskHelper.getOS_Suffix().equals("wx6") || TaskHelper.getOS_Suffix().equals("w64")) && is32bit ? (WinRegAPI.getWinRegType32(this.getIntValueForRegistryKey(root), key, name) == 4L ? String.valueOf(WinRegAPI.getWinRegDwordValue32(this.getIntValueForRegistryKey(root), key, name)) : WinRegAPI.getWinRegValue32(this.getIntValueForRegistryKey(root), key, name)) : (WinRegAPI.getWinRegType64(this.getIntValueForRegistryKey(root), key, name) == 4L ? String.valueOf(WinRegAPI.getWinRegDwordValue(this.getIntValueForRegistryKey(root), key, name)) : WinRegAPI.getWindowsRegistryValue(this.getIntValueForRegistryKey(root), key, name));
            this.log.info("actual value is: " + value);
            if (value == null || value.length() == 0) {
                this.log.info("found to be true:" + value);
                return true;
            }
            if (value != null && value.length() > 0) {
                int comparisonMade = DiskInfoAPI.compareFileVersionStrings(expectedValue, value);
                if (comparisonValue.equalsIgnoreCase(GREATERTHAN) && comparisonMade > 0) {
                    this.log.info("found to be true");
                    return true;
                }
                if (comparisonValue.equalsIgnoreCase(LESSTHAN) && comparisonMade < 0) {
                    this.log.info("found to be true");
                    return true;
                }
                if (comparisonValue.equalsIgnoreCase(NOTEQUAL) && comparisonMade != 0) {
                    this.log.info("found to be true");
                    return true;
                }
            }
            this.log.info("found to be false");
            return false;
        }
        boolean found = false;
        found = is32bit ? WinRegAPI.isWindowsRegistryKey32(this.getIntValueForRegistryKey(root), key) : WinRegAPI.isWindowsRegistryKey64(this.getIntValueForRegistryKey(root), key);
        if (found) {
            this.log.info("key found, returning false for NOTEXIST");
            return false;
        }
        this.log.info("key not found, returning true for NOTEXIST");
        return true;
    }

    private int getIntValueForRegistryKey(String key) {
        if (key.equalsIgnoreCase(HKEY_CLASSES_ROOT)) {
            return 1;
        }
        if (key.equalsIgnoreCase(HKEY_CURRENT_USER)) {
            return 4;
        }
        if (key.equalsIgnoreCase(HKEY_LOCAL_MACHINE)) {
            return 8;
        }
        if (key.equalsIgnoreCase(HKEY_USERS)) {
            return 16;
        }
        if (key.equalsIgnoreCase(HKEY_CURRENT_CONFIG)) {
            return 2;
        }
        return 8;
    }

    private void runExecute(ExecutableType executable) {
        String exeFile = null;
        String cmdArgs = executable.getArguments();
        File InstallLogsArea = this.getInstallLogs();
        String InstallLogsA = InstallLogsArea.toString();
        if (executable.getFileName().endsWith(".msi")) {
            exeFile = "msiexec.exe /i \"" + this.getController().getCurrentContext().getPayloadDir() + executable.getPath() + executable.getFileName() + "\" " + cmdArgs;
        } else if (executable.getFileName().contains("ocsetup.exe")) {
            exeFile = "ocsetup.exe " + cmdArgs;
        } else if (executable.getFileName().contains("dism.exe") && TaskHelper.getOS_Suffix().equals("wx6")) {
            exeFile = "cmd.exe /C %WINDIR%\\SysNative\\dism.exe " + cmdArgs;
        } else if (executable.getFileName().contains("dism.exe") && TaskHelper.getOS_Suffix().equals("win")) {
            exeFile = "cmd.exe /C %WINDIR%\\System32\\dism.exe " + cmdArgs;
        } else {
            if (cmdArgs.contains("${InstallLogs}")) {
                cmdArgs = cmdArgs.replace("${InstallLogs}", InstallLogsA);
            }
            exeFile = "\"" + this.getController().getCurrentContext().getPayloadDir() + executable.getPath() + executable.getFileName() + "\" " + cmdArgs;
        }
        if (Controller.installProperties.getProperty("create.batch.file") == "TRUE") {
            if (this.getController().getProperty("12ByteCode").equalsIgnoreCase("DOTNET40") && (System.getProperty("os.name").equals("Windows 8") || System.getProperty("os.name").equals("Windows Server 2012"))) {
                exeFile = ":: " + this.getController().getProperty("ProductName") + " is included by default in " + System.getProperty("os.name") + "." + System.getProperty("line.separator") + ":: Therefore, commands for its installation are not included in this batch file.";
            }
            this.notifySetup(exeFile, null);
        } else {
            this.log.info("Calling system update installation file: " + exeFile);
            SASRuntimeWrapper run = SASRuntimeWrapper.getRuntime();
            try {
                StringWriter stdoutWriter = new StringWriter();
                StringWriter stderrWriter = new StringWriter();
                Process pp = run.exec(exeFile);
                InputStreamConsumer stdoutConsumer = new InputStreamConsumer(pp.getInputStream(), stdoutWriter);
                InputStreamConsumer stderrConsumer = new InputStreamConsumer(pp.getErrorStream(), stderrWriter);
                stdoutConsumer.start();
                stderrConsumer.start();
                int returnCode = pp.waitFor();
                this.notifySetup("sysReq." + this.getController().getProperty("12ByteCode") + ".returnCode." + returnCode, "Notifying SDW that " + this.getController().getProperty("12ByteCode") + " installed with a returnCode of: " + returnCode);
                if (!this.isSystemRebootNeeded(returnCode) && !this.hasVcredist2015UpdateFailed(returnCode) && returnCode != 0) {
                    this.log.error("Error installing " + this.getController().getProperty("12ByteCode") + ": " + ((Object)stderrWriter).toString());
                    throw new InstallException(2, this, this.getBundle().messageString("CheckPairsGroupType.RunExecuteFailed", exeFile), this.getEnBundle().messageString("CheckPairsGroupType.RunExecuteFailed", exeFile), new Exception());
                }
            }
            catch (Exception e) {
                throw new InstallException(2, this, this.getBundle().messageString("CheckPairsGroupType.RunExecuteFailed", exeFile), this.getEnBundle().messageString("CheckPairsGroupType.RunExecuteFailed", exeFile), e);
            }
        }
    }

    protected String getDllPath() {
        URL url = WinRegAPI.class.getProtectionDomain().getCodeSource().getLocation();
        File file = null;
        try {
            file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        file = file.getParentFile();
        return file.getAbsolutePath();
    }

    private boolean isSystemRebootNeeded(int returnCode) {
        if (returnCode == 3010 || returnCode == -5015) {
            this.notifyReboot("Reboot pending due to installation of " + this.getController().getProperty("12ByteCode") + ".");
            return true;
        }
        return false;
    }

    private boolean hasVcredist2015UpdateFailed(int returnCode) {
        String twelvebyte = this.getController().getProperty("12ByteCode");
        if (returnCode == 23 && twelvebyte.equalsIgnoreCase("VCREDIST2015")) {
            this.log.error("Although the " + twelvebyte + " installation was successful, the " + twelvebyte + " update failed to install.");
            return true;
        }
        return false;
    }
}

