/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.schema.install.gen.ApplyTKLasrLicense;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.resource.FileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;

public class ApplyTKLasrLicenseTask
extends InstallationTask {
    private static final String TASK_NAME = "applyTKLasrLicence";
    private static String TKLasrLicenseInfo = null;
    private static String TKLasrUtilityName = null;
    private static String TKLasrModuleName = null;
    private static boolean rmdtestbit = false;
    private static boolean postProcessingInitialized = false;

    @Override
    public void preExecute() {
        if (Controller.defaultController().getProperty("SID") == null) {
            String tkModuleName = this.getTkLicModuleFQPath();
            String tkModuleNameBak = tkModuleName + ".bak";
            File srcFile = new File(tkModuleName);
            File destFile = new File(tkModuleNameBak);
            if (srcFile.exists()) {
                this.log.info("copying " + srcFile + " to " + destFile);
                if (destFile.exists() && destFile.delete()) {
                    this.log.info(destFile + " is deleted. ");
                }
                try {
                    this.getFS().copyFile(srcFile, destFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (TaskHelper.isUnix()) {
                    Runtime myruntime = Runtime.getRuntime();
                    try {
                        String[] mycommand = new String[]{"chmod", "555", tkModuleNameBak};
                        Process scriptProc = myruntime.exec(mycommand);
                        scriptProc.waitFor();
                        scriptProc = null;
                    }
                    catch (IOException e1) {
                        Controller.logStackTrace(e1);
                    }
                    catch (InterruptedException e2) {
                        Controller.logStackTrace(e2);
                    }
                }
            }
        }
    }

    public int postInstall() {
        int returnCode = 2;
        String sResultCode = null;
        if (Controller.defaultController().getProperty("SID") == null) {
            this.log.info("License was not provided, skipping ApplyTKLasrLicenseTask");
            return 0;
        }
        this.log.info("Starting to retrieve the TKLasr license information");
        try {
            if (!ApplyTKLasrLicenseTask.retrieveTkLasrLicense()) {
                this.log.warn("SAS LASR Analytic Server license information was not provided or invalid so skipping the ApplyTKLasrLicenseTask.");
                this.log.warn("No need to apply the license unless you have a valid SAS LASR Analytic Server license.");
                if (Controller.installProperties.getProperty("sdm.postinstall") == "TRUE") {
                    this.notifyWarning("SAS LASR Analytic Server license information was not provided or invalid in SID file.");
                }
                return 0;
            }
            if (rmdtestbit) {
                this.log.info("Running the install in rmdtest environment so skipping the ApplyTKLasrLicenseTask.");
                return 0;
            }
            String tkLasrLicCommand = null;
            if (TaskHelper.isUnix() || TaskHelper.isWindows()) {
                tkLasrLicCommand = TaskHelper.isWindows() ? this.getTkLicUtilityFQPath() + ".exe  " + TKLasrLicenseInfo : this.getTkLicUtilityFQPath() + " " + TKLasrLicenseInfo;
                this.log.info("Starting to apply TKLasr license " + tkLasrLicCommand);
                try {
                    File licenseModule = new File(this.getTkLicModuleFQPath());
                    EntryData metadata = new EntryData(licenseModule);
                    this.notifySetup("Changed", metadata, null);
                    sResultCode = TaskHelper.executeCommand(tkLasrLicCommand);
                    this.log.info(sResultCode);
                    if (sResultCode.indexOf("successfully") > 0) {
                        this.notifyProgressComplete("Changed", metadata);
                        returnCode = 0;
                        this.log.info("Running the TK Lasr License Utility is successfully finished");
                    }
                }
                catch (Exception e) {
                    this.log.error("Failed to run the utility to apply the TKLasr License." + e);
                    return -1;
                }
            }
            if (returnCode != 0) {
                this.log.error("There were error(s) in the SAS log while applying the TKLasr License.");
            }
        }
        catch (FileNotFoundException e) {
            this.log.error("The Sid file is not found.");
            this.log.trace(e);
        }
        return returnCode;
    }

    private String getTkLicModuleFQPath() {
        String moduleFQPath = null;
        moduleFQPath = this.getController().getFS().append(this.resolveProperty(this.getLicenseModule()), TKLasrModuleName);
        return moduleFQPath;
    }

    private String getTkLicUtilityFQPath() {
        String utilityPath = null;
        utilityPath = this.getController().getFS().append(this.resolveProperty(this.getLicenseUtility()), TKLasrUtilityName);
        return utilityPath;
    }

    private String getLicenseModule() {
        return ((ApplyTKLasrLicense)this.getData()).getLicenseModule();
    }

    private String getLicenseUtility() {
        return ((ApplyTKLasrLicense)this.getData()).getLicenseUtility();
    }

    private String getSidPath() {
        return ((ApplyTKLasrLicense)this.getData()).getSidPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean retrieveTkLasrLicense() throws FileNotFoundException {
        Controller controller = Controller.defaultController();
        LogManager.getLogger("ApplyTKLasrLicenseTask").info("Checking TK Lasr License in the file  " + controller.getProperty("SID"));
        File sid = new File(controller.getProperty("SID"));
        boolean validatedLic = false;
        StringBuilder fileContents = new StringBuilder((int)sid.length());
        String sNewLicenseLine = null;
        try {
            String delims;
            try (Scanner sidFile = new Scanner(sid);){
                while (sidFile.hasNextLine()) {
                    String line1 = sidFile.nextLine().trim();
                    if (line1.matches("^SITE=1$")) {
                        rmdtestbit = true;
                        boolean bl = true;
                        return bl;
                    }
                    if (!line1.startsWith("applylasrlic")) continue;
                    fileContents.append(line1.trim());
                    fileContents.append(sidFile.nextLine().trim());
                }
            }
            sNewLicenseLine = fileContents.toString();
            String[] tokens = sNewLicenseLine.split(delims = "[ *]");
            if (tokens.length >= 2) {
                for (int i = 0; i < tokens.length; ++i) {
                    if (tokens[i].startsWith("apply")) {
                        TKLasrUtilityName = tokens[i];
                    } else if (tokens[i].indexOf(",,") > 1) {
                        TKLasrLicenseInfo = tokens[i];
                    }
                    validatedLic = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!validatedLic) return validatedLic;
        LogManager.getLogger("ApplyTKLasrLicenseTask").info("TK Lasr License is  " + TKLasrLicenseInfo);
        return validatedLic;
    }

    @Override
    public String descriptionForLog() {
        HashMap<String, String> params = new HashMap<String, String>();
        return TaskHelper.getDescriptionForLog(TASK_NAME, params);
    }

    protected static Writer getWriter(File license) throws IOException {
        return new FileWriter(license);
    }

    public static String getTaskName() {
        return TASK_NAME;
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void execute() throws InstallException {
        if (Controller.installProperties.getProperty("sdm.postinstall") == "FALSE") {
            if (!postProcessingInitialized) {
                String key = Controller.defaultController().getAltSku().concat(this.getClass().getName());
                Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(true, this.getClass().getName(), "postInstall", ProcessingTaskInfo.Priority.HIGHEST));
                Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this, this.getClass(), "postInstall", ProcessingTask.Priority.HIGHEST));
            }
            postProcessingInitialized = true;
        } else {
            int post = this.postInstall();
            if (post != 0) {
                throw new InstallException(3, this, this.getBundle().messageString("ApplyTKLasrLicenseTask.ReturnCode", post), this.getEnBundle().messageString("ApplyTKLasrLicenseTask.ReturnCode", post), null);
            }
        }
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void rollback() throws InstallException {
    }

    private void restoreSavedLicensedModules() {
        File destFile = new File(this.getTkLicModuleFQPath());
        File srcFile = new File(destFile + ".bak");
        if (srcFile.exists()) {
            this.log.info("copying " + srcFile + " to " + destFile);
            if (destFile.delete()) {
                this.log.info(destFile + " is deleted. ");
                if (srcFile.renameTo(destFile)) {
                    this.log.info(srcFile + " was renamed to " + destFile);
                } else {
                    this.log.info("File " + srcFile + " was not renamed to " + destFile);
                }
            } else {
                this.log.info("File " + destFile + " was not deleted.");
            }
        } else {
            this.log.info("File " + srcFile + " was not found.");
        }
    }

    private FileSystem getFS() {
        return this.getController().getFS();
    }

    public static void setPostProcessingInitialized(boolean postProcessingInitialized) {
        ApplyTKLasrLicenseTask.postProcessingInitialized = postProcessingInitialized;
    }
}

