/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.tasks;

import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.WindowsRegistry;
import com.sas.tools.installs.it.schema.install.gen.ApplyRegistryFile;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApplyRegistryFileTask
extends InstallationTask {
    private String _registryFile = null;
    protected Map<String, Map<String, String>> ini;
    private WindowsRegistry _winReg = null;
    public static final boolean WINDOWS_OS = TaskHelper.getOS() == 1;

    public ApplyRegistryFileTask() {
        if (WINDOWS_OS) {
            this._winReg = new WindowsRegistry();
        }
    }

    @Override
    public String descriptionForLog() {
        return null;
    }

    @Override
    public void execute() throws InstallException {
        if (!WINDOWS_OS) {
            this.log.info("Skipping execute for ApplyRegistryFile task running on non-Windows OS");
            return;
        }
        this._winReg.setUninstallLog(this.getController().metadataBackupDirectory(), "ApplyRegistryFile");
        if (this.isUndo()) {
            this._winReg.uninstallRegistryKeys();
            return;
        }
        this._registryFile = this.resolveProperty(((ApplyRegistryFile)this.getData()).getFile());
        this.log.info("Applying Windows registry file: " + this._registryFile);
        HashSet<String> keys = new HashSet();
        try {
            this.parseIni(this._registryFile);
        }
        catch (FileNotFoundException e) {
            throw new InstallException(3, this, this.getBundle().messageString("ApplyRegistryFile.RegFileNotFound", this._registryFile), "The registry file to process can not be found: " + this._registryFile, new Exception());
        }
        catch (IOException e) {
            throw new InstallException(3, this, this.getBundle().messageString("ApplyRegistryFile.ErrorReadingRegFile", this._registryFile), "An error occurred while reading registry file " + this._registryFile, new Exception());
        }
        keys = this.ini.keySet();
        this.setBitMode();
        this.processRegistryFile(keys);
        if (this.processForThirtyTwoBit()) {
            this.log.info("In addition to applying the registry file to the 64-bit Windows registry, applying registry file " + this._registryFile + " to the 32-bit Windows registry");
            this.processRegistryFile(keys);
        }
        this._winReg.writeUninstallData();
    }

    protected void setBitMode() {
        if (TaskHelper.getOS() == 1) {
            this.log.info("is windows");
            if (TaskHelper.getOS_Suffix().equals("win")) {
                return;
            }
            if (((ApplyRegistryFile)this.getData()).getWriteBitMode() != null && ((ApplyRegistryFile)this.getData()).getWriteBitMode().equals("32")) {
                this.log.info("Windows 64-bit: Applying registry file to 32-bit Windows registry");
                this._winReg.setBitMode(32);
            }
        }
    }

    protected boolean processForThirtyTwoBit() {
        if (TaskHelper.getOS_Suffix().equals("wx6") && ((ApplyRegistryFile)this.getData()).getWriteBitMode() != null && ((ApplyRegistryFile)this.getData()).getWriteBitMode().equals("32and64")) {
            this._winReg.setBitMode(32);
            return true;
        }
        return false;
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
        this.execute();
    }

    @Override
    public void rollback() throws InstallException {
        if (!WINDOWS_OS) {
            this.log.info("Skipping rollback for ApplyRegistryFile task running on non-Windows OS");
            return;
        }
        this._winReg.rollbackRegistryKeys();
    }

    protected void processRegistryFile(Set<String> keys) {
        for (String key : keys) {
            Map<String, String> data = this.ini.get(key);
            this.processRegistryKey(key, data);
        }
    }

    protected void processRegistryKey(String keyWithHive, Map<String, String> section) {
        int hive = WindowsRegistry.stringToHive(keyWithHive);
        String key = WindowsRegistry.determineKey(keyWithHive);
        this.log.info("Processing registry key :" + keyWithHive);
        if (!this._winReg.createKey(hive, this.resolveProperty(key))) {
            throw new InstallException(1, null, this.getController().getBundle().messageString("AppleRegistryFile.ErrorCreatingKey", keyWithHive), "an error occurred creating the registry key: " + keyWithHive, null);
        }
        this.processNameDataPairs(hive, key, section);
    }

    protected boolean processNameDataPairs(int hive, String key, Map<String, String> section) {
        boolean result = true;
        String tmpName = "";
        if (section != null && !section.isEmpty()) {
            Set<Object> names = new HashSet();
            names = section.keySet();
            for (String string : names) {
                if (string.equals("")) continue;
                this.log.info("Processing name: " + string);
                String data = ApplyRegistryFileTask.removeOuterQuotes(section.get(string));
                tmpName = string.equals("@") ? "" : ApplyRegistryFileTask.removeOuterQuotes(string);
                if (this._winReg.setValue(hive, key, this.resolveProperty(tmpName), this.resolveProperty(data), 109)) continue;
                throw new InstallException(1, null, this.getController().getBundle().messageString("ApplyRegistryFile.ErrorWritingValue", string, WindowsRegistry.determineKeyWithHive(hive, key)), "An error occurred setting the value for " + string + " in the registry key " + WindowsRegistry.determineKeyWithHive(hive, key), null);
            }
        }
        return result;
    }

    protected void parseIni(String path) throws IOException {
        String line;
        String section = null;
        InputStream is = this.getController().getFS().getInputStream(path);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Pattern sectionRegex = Pattern.compile("^\\[([^]]+)\\]");
        Pattern keyValueRegex = Pattern.compile("^\\s*([^=]+)=(.*)$");
        LinkedHashMap<String, String> props = null;
        this.ini = new LinkedHashMap<String, Map<String, String>>();
        while ((line = br.readLine()) != null) {
            Matcher sectionMatch = sectionRegex.matcher(line);
            Matcher keyValueMatch = keyValueRegex.matcher(line);
            if (sectionMatch.matches()) {
                if (props != null) {
                    this.ini.put(section, props);
                }
                section = sectionMatch.group(1);
                props = null;
                continue;
            }
            if (!keyValueMatch.matches()) continue;
            if (props == null) {
                props = new LinkedHashMap<String, String>();
            }
            props.put(keyValueMatch.group(1), keyValueMatch.group(2));
        }
        this.ini.put(section, props);
    }

    static String removeOuterQuotes(String str) {
        if (str.startsWith("\"")) {
            str = str.substring(1, str.length());
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

