/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.schema;

import com.sas.tools.installs.it.schema.extension.ExtensionsType;
import com.sas.tools.installs.it.schema.extension.ObjectFactory;
import com.sas.tools.installs.it.schema.install.gen.Project;
import com.sas.tools.installs.it.schema.metadata.ObjectFactoryEx;
import com.sas.tools.installs.it.schema.metadata.gen.Zip;
import com.sas.tools.installs.it.schema.mvsdsdata.gen.DSTable;
import com.sas.tools.installs.schema.ittasks.DestinationType;
import com.sas.tools.installs.schema.ittasks.ItTasks;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;

public class SchemaUtils {
    private static final ObjectFactory extensionFactory = new ObjectFactory();
    private static final Map<String, JAXBContext> jaxbContextCache = new HashMap<String, JAXBContext>();
    private static final Map<Class<?>, Unmarshaller> unmarshallerCache = new HashMap();
    private static final Map<Class<?>, Marshaller> marshallerCache = new HashMap();
    private static final ClassLoader classloader = SchemaUtils.class.getClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JAXBContext getJAXBContext(String packageName) throws JAXBException {
        JAXBContext context = null;
        Map<String, JAXBContext> map = jaxbContextCache;
        synchronized (map) {
            context = jaxbContextCache.get(packageName);
            if (context == null) {
                context = JAXBContext.newInstance(packageName, classloader);
                jaxbContextCache.put(packageName, context);
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Unmarshaller getUnmarshaller(Class<?> rootClass) throws JAXBException {
        Unmarshaller unmarshaller = null;
        Map<Class<?>, Unmarshaller> map = unmarshallerCache;
        synchronized (map) {
            unmarshaller = unmarshallerCache.get(rootClass);
            if (unmarshaller == null) {
                JAXBContext jc = SchemaUtils.getJAXBContext(rootClass.getPackage().getName());
                unmarshaller = jc.createUnmarshaller();
                SchemaUtils.initUnmarshaller(rootClass, unmarshaller);
                unmarshallerCache.put(rootClass, unmarshaller);
            }
        }
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Marshaller getMarshaller(Class<?> rootClass) throws JAXBException {
        Marshaller marshaller = null;
        Map<Class<?>, Marshaller> map = marshallerCache;
        synchronized (map) {
            marshaller = marshallerCache.get(rootClass);
            if (marshaller == null) {
                JAXBContext jc = SchemaUtils.getJAXBContext(rootClass.getPackage().getName());
                marshaller = jc.createMarshaller();
                SchemaUtils.initMarshaller(rootClass, marshaller);
                marshallerCache.put(rootClass, marshaller);
            }
        }
        return marshaller;
    }

    private static void initUnmarshaller(Class<?> rootClass, Unmarshaller unmarshaller) throws JAXBException {
        String object_factory_property = "org.glassfish.jaxb.core.ObjectFactory";
        if (rootClass.equals(Project.class)) {
            unmarshaller.setProperty("org.glassfish.jaxb.core.ObjectFactory", new Object[]{new com.sas.tools.installs.it.schema.install.ObjectFactoryEx(), new ObjectFactoryEx()});
        } else if (rootClass.equals(Zip.class)) {
            unmarshaller.setEventHandler(new DefaultValidationEventHandler());
            unmarshaller.setProperty("org.glassfish.jaxb.core.ObjectFactory", new ObjectFactoryEx());
        } else if (rootClass.equals(DSTable.class)) {
            unmarshaller.setEventHandler(new DefaultValidationEventHandler());
            unmarshaller.setProperty("org.glassfish.jaxb.core.ObjectFactory", new com.sas.tools.installs.it.schema.mvsdsdata.ObjectFactoryEx());
        }
    }

    private static void initMarshaller(Class<?> rootClass, Marshaller marshaller) throws JAXBException {
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T unmarshal(StreamSource streamSource, Class<T> declaredType) throws JAXBException {
        Unmarshaller unmarshaller;
        T ret = null;
        Unmarshaller unmarshaller2 = unmarshaller = SchemaUtils.getUnmarshaller(declaredType);
        synchronized (unmarshaller2) {
            try {
                JAXBElement<T> jaxb = unmarshaller.unmarshal(streamSource, declaredType);
                ret = jaxb.getValue();
            }
            finally {
                try {
                    InputStream is = streamSource.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    public static <T> T unmarshal(InputStream stream, Class<T> declaredType) throws JAXBException {
        return SchemaUtils.unmarshal(new StreamSource(stream), declaredType);
    }

    public static <T> T unmarshal(File xmlFile, Class<T> declaredType) throws JAXBException {
        return SchemaUtils.unmarshal(new StreamSource(xmlFile), declaredType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void marshal(T jaxbObject, Class<T> declaredType, File outputFile, WriteOption copyOption) throws JAXBException, IOException {
        File target = outputFile;
        boolean writingNotInPlace = false;
        if (outputFile.isFile() && copyOption == WriteOption.NOT_IN_PLACE) {
            target = new File(outputFile.getAbsolutePath() + "_new");
            writingNotInPlace = true;
        }
        FileOutputStream fos = null;
        OutputStreamWriter fileWriter = null;
        try {
            fos = new FileOutputStream(target);
            fileWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            SchemaUtils.marshal(jaxbObject, declaredType, new PrintWriter((Writer)fileWriter, true));
        }
        finally {
            if (fos != null) {
                fos.close();
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
        }
        if (writingNotInPlace) {
            File backupFile = new File(outputFile.getAbsolutePath() + "_orig");
            try {
                outputFile.renameTo(backupFile);
                target.renameTo(outputFile);
                backupFile.delete();
            }
            catch (Throwable t) {
                if (!outputFile.isFile() && backupFile.isFile()) {
                    backupFile.renameTo(outputFile);
                }
                target.delete();
            }
        }
    }

    public static <T> void marshal(T jaxbObject, Class<T> declaredType, Writer writer) throws JAXBException {
        Marshaller m = SchemaUtils.getMarshaller(declaredType);
        if (jaxbObject instanceof ExtensionsType) {
            ExtensionsType extensions = (ExtensionsType)jaxbObject;
            m.marshal(extensionFactory.createExtensions(extensions), writer);
        } else {
            m.marshal(jaxbObject, writer);
        }
    }

    public static void marshalExtensionsXml(ExtensionsType extensionReg, Writer writer) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance(ExtensionsType.class.getPackage().getName(), classloader);
        Marshaller m = jc.createMarshaller();
        ObjectFactory factory = new ObjectFactory();
        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
        m.marshal(factory.createExtensions(extensionReg), writer);
    }

    public static void marshalDeploymentXml(ItTasks itTask, Writer writer) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance(DestinationType.class.getPackage().getName(), classloader);
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", Boolean.TRUE);
        m.marshal((Object)itTask, writer);
    }

    public static enum WriteOption {
        IN_PLACE,
        NOT_IN_PLACE;

    }
}

