/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.plugins;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.plugins.InstallationPlugin;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.schema.validation.ObjectFactory;
import com.sas.tools.installs.it.schema.validation.ValidationListType;
import com.sas.tools.installs.it.schema.validation.ValidationType;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class WriteValidationFile
extends InstallationPlugin
implements InstallationProgressListener {
    protected static Logger log = (Logger)LogManager.getLogger("com.sas.tools.installs.it.plugins.WriteValidationFile");
    private static File validationFile;
    private static Map<String, ValidationType> _validationData;
    private static ObjectFactory of;
    private String twelveByte;
    private final String changedCheckSumString = "ffffffffffffffffffffffffffffffff";
    private static final String TWELVEBYTECODE = "12ByteCode";
    private static final String VALIDATION_FILE_NAME = "ValidationFileList.xml";
    private static final String VALIDATION_FILE_BACKUP_NAME = "ValidationFileList_backup.xml";
    private static final String VALIDATION_FILE_MSG = "Validation file: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteValidationFile(Controller controller) {
        String key = Controller.defaultController().getAltSku().concat(this.getClass().getName());
        Controller.defaultController().getPostProcessingTasks().put(key, new ProcessingTaskInfo(this.getClass().getName(), "marshalData", ProcessingTaskInfo.Priority.LOWEST));
        Controller.defaultController().getPostProcessingQueue().add(new ProcessingTask(this.getClass(), "marshalData", ProcessingTask.Priority.LOWEST));
        validationFile = new File(controller.getLogPath(), VALIDATION_FILE_NAME);
        this.twelveByte = controller.getProperty(TWELVEBYTECODE);
        _validationData = TaskHelper.getOS() == 1 ? new TreeMap<String, ValidationType>(String.CASE_INSENSITIVE_ORDER) : new TreeMap<String, ValidationType>();
        Map<String, ValidationType> map = _validationData;
        synchronized (map) {
            ValidationListType fileData = null;
            if (_validationData.isEmpty() && validationFile.exists()) {
                try {
                    JAXBContext jc = JAXBContext.newInstance(ValidationListType.class);
                    Unmarshaller u = jc.createUnmarshaller();
                    JAXBElement<ValidationListType> installJax = u.unmarshal(new StreamSource(validationFile), ValidationListType.class);
                    fileData = installJax.getValue();
                }
                catch (JAXBException e) {
                    log.error("Unable to parse validation file " + validationFile + ". Previous validation data will not be preserved. Consider restoring from backup file.", (Throwable)e);
                    throw new RuntimeException(VALIDATION_FILE_MSG + validationFile, e);
                }
                for (ValidationType data : fileData.getSasfile()) {
                    data.setName(Utils.canonicalizePath(data.getName()));
                    File fullName = new File(data.getName()).exists() ? new File(data.getName()) : new File(System.getProperty("SASHome"), data.getName());
                    String fullNameFilePath = fullName.toString();
                    if (TaskHelper.getOS() == 1) {
                        String newCheckSum = data.getChecksum();
                        ValidationType dupPathFound = _validationData.put(fullNameFilePath, data);
                        if (dupPathFound != null) {
                            String oldCheckSum = dupPathFound.getChecksum();
                            String diskCheckSum = Utils.getMd5sum(fullNameFilePath);
                            if (newCheckSum.equals(diskCheckSum)) {
                                data.setChecksum(newCheckSum);
                            } else if (oldCheckSum.equals(diskCheckSum)) {
                                data.setChecksum(oldCheckSum);
                            } else {
                                data.setChecksum("ffffffffffffffffffffffffffffffff");
                                log.info("The file " + fullNameFilePath + " is not the same as the original install image. The checksum value for the file in ValidationFileList.xml is changed to " + "ffffffffffffffffffffffffffffffff" + ".");
                            }
                        }
                    }
                    _validationData.put(fullName.toString(), data);
                }
            }
        }
        WriteValidationFile.backup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sdmCleanup(String path) {
        validationFile = new File(path, VALIDATION_FILE_NAME);
        _validationData = TaskHelper.getOS() == 1 ? new TreeMap<String, ValidationType>(String.CASE_INSENSITIVE_ORDER) : new TreeMap<String, ValidationType>();
        Map<String, ValidationType> map = _validationData;
        synchronized (map) {
            ValidationListType fileData = null;
            if (_validationData.isEmpty() && validationFile.exists()) {
                try {
                    JAXBContext jc = JAXBContext.newInstance(ValidationListType.class);
                    Unmarshaller u = jc.createUnmarshaller();
                    JAXBElement<ValidationListType> installJax = u.unmarshal(new StreamSource(validationFile), ValidationListType.class);
                    fileData = installJax.getValue();
                }
                catch (JAXBException e) {
                    log.error("Unable to parse validation file " + validationFile + ". Previous validation data will not be preserved. Consider restoring from backup file.", (Throwable)e);
                    throw new RuntimeException(VALIDATION_FILE_MSG + validationFile, e);
                }
                for (ValidationType data : fileData.getSasfile()) {
                    File fullName;
                    data.setName(Utils.canonicalizePath(data.getName()));
                    if (new File(data.getName()).exists()) {
                        fullName = new File(data.getName());
                    } else {
                        fullName = new File(System.getProperty("SASHome"), data.getName());
                        if (!fullName.exists() && fullName.getPath().contains("SASDeploymentManager") && (fullName.getPath().contains("deploywiz") || fullName.getPath().contains("cfgwizard"))) continue;
                    }
                    _validationData.put(fullName.toString(), data);
                }
            }
        }
        WriteValidationFile.marshalData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int marshalData() throws InstallException {
        ValidationListType vList = of.createValidationListType();
        if (_validationData.size() > 0) {
            for (String file : _validationData.keySet()) {
                vList.getSasfile().add(_validationData.get(file));
            }
            FileOutputStream fos = null;
            try {
                log.info("Marshaling validation file: " + validationFile);
                JAXBElement<ValidationListType> vl = of.createInstalledFiles(vList);
                JAXBContext context = JAXBContext.newInstance(vList.getClass().getPackage().getName());
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                fos = new FileOutputStream(validationFile);
                m.marshal(vl, fos);
                int n = 0;
                WriteValidationFile.closeQuietly(fos, validationFile);
                return n;
            }
            catch (Exception jbe) {
                log.error("Error marshaling the validation data to file.", (Throwable)jbe);
                int n = -4;
                return n;
            }
            finally {
                WriteValidationFile.closeQuietly(fos, validationFile);
            }
        }
        log.info("No files processed during installation. Validation xml file not created.");
        return 0;
    }

    private static void closeQuietly(Closeable closeable, File file) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioEx) {
                log.warn("An error has occurred while closing file '" + file + "'.", (Throwable)ioEx);
            }
        }
    }

    private ValidationType createValidationType(EntryData data) {
        ValidationType vType = of.createValidationType();
        String sasHome = System.getProperty("SASHome");
        String relativeFile = data.getDestination().toString().replace(sasHome + System.getProperty("file.separator"), System.getProperty("file.separator"));
        vType.setName(Utils.canonicalizePath(relativeFile));
        vType.setChecksum(data.getMd5());
        vType.setProdcode(this.twelveByte);
        return vType;
    }

    public static void backup() {
        File backupFilePath = new File(validationFile.getParent(), VALIDATION_FILE_BACKUP_NAME);
        boolean backedUp = true;
        if (validationFile.exists()) {
            log.info("Backing up previous validation file: " + validationFile.toString());
            backedUp = Utils.moveFile(validationFile, backupFilePath);
        }
        if (!backedUp) {
            log.info("Error backing up the previous validation file.");
        }
    }

    public File getValidationFilePath() {
        return validationFile;
    }

    @Override
    public void bytesMoved(long numBytes) {
    }

    @Override
    public void installStartedAction() {
        Controller controller = Controller.defaultController();
        this.twelveByte = controller.getProperty(TWELVEBYTECODE);
    }

    @Override
    public void progressBeginningAction(String action, EntryData metaData) {
    }

    @Override
    public void progressBeginningAction(String description) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void progressCompleteAction(String action, EntryData metaData) {
        Controller controller = Controller.defaultController();
        this.twelveByte = controller.getProperty(TWELVEBYTECODE);
        String file = metaData.getDestination().toString();
        Map<String, ValidationType> map = _validationData;
        synchronized (map) {
            if (action.equals("Added") && !metaData.isLink().booleanValue()) {
                metaData.getMd5();
                _validationData.put(file, this.createValidationType(metaData));
            } else if (action.equals("Removed")) {
                _validationData.remove(file);
            } else if (action.equals("Changed")) {
                if (metaData.getDestination().isDirectory()) {
                    log.info("Running validation on directory: " + metaData.getDestination());
                    for (File f : metaData.getDestination().listFiles()) {
                        log.info("Validating file " + f);
                        if (!_validationData.containsKey(f.toString())) continue;
                        EntryData batchMetadata = new EntryData(f);
                        batchMetadata.getMd5();
                        _validationData.put(f.toString(), this.createValidationType(batchMetadata));
                    }
                } else {
                    metaData.getMd5();
                    _validationData.put(file, this.createValidationType(metaData));
                }
            }
        }
    }

    @Override
    public void progressCompleteAction(String description) {
    }

    @Override
    public void progressFailedAction(String action, EntryData metaData) {
    }

    @Override
    public void taskStartedAction(InstallationTask task) {
    }

    @Override
    public void installCompletedAction() {
        WriteValidationFile.marshalData();
    }

    @Override
    public String descriptionForLog() {
        return null;
    }

    @Override
    public void execute() throws InstallException {
    }

    @Override
    public void postExecute() throws Exception {
    }

    @Override
    public void retry() throws InstallException {
    }

    @Override
    public void rollback() throws InstallException {
    }

    static {
        _validationData = null;
        of = new ObjectFactory();
    }
}

