/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it.cleaner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class Cleaner
extends JFrame {
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.sas.tools.installs.it.cleaner.PropertyBundle");
    private static String EOL = System.getProperty("line.separator");
    private File m_SASHome = null;
    private long m_filesRemoved = 0L;
    private long m_filesNotRemoved = 0L;
    private double m_spaceReclaimed = 0.0;
    private double m_spaceNotReclaimed = 0.0;
    private boolean m_isRunning = false;
    private JPanel ivjJFrameContentPane = null;
    private JPanel ivjApplicationPane = null;
    private JPanel ivjStatusPane = null;
    private JPanel ivjButtonPane = null;
    private final JFrame m_me;
    private final JLabel m_lScanningVal = new JLabel("");
    private final JLabel m_lDeletingVal = new JLabel("");
    private final JLabel m_lRemovedVal = new JLabel("");
    private final JLabel m_lReclaimedVal = new JLabel("");
    private final JLabel m_lNotRemovedVal = new JLabel("");
    private final JLabel m_lNotReclaimedVal = new JLabel("");
    JButton m_btnClose;
    DefaultListModel<String> listModel = new DefaultListModel();
    JList<String> itemList = new JList<String>(this.listModel);
    private final JLabel m_valSASHome = new JLabel();
    Action onRun = new AbstractAction(){

        @Override
        public boolean isEnabled() {
            return !Cleaner.this.m_isRunning;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cleaner.this.preRunInitialization();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Cleaner.this.clean();
                    Cleaner.this.done();
                }
            }).start();
        }
    };
    Action onClose = new AbstractAction(){

        @Override
        public boolean isEnabled() {
            return !Cleaner.this.m_isRunning;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cleaner.this.m_me.dispatchEvent(new WindowEvent(Cleaner.this.m_me, 201));
        }
    };
    KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
    Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cleaner.this.m_me.dispatchEvent(new WindowEvent(Cleaner.this.m_me, 201));
        }
    };
    File m_logFile;
    PrintStream m_log = null;

    public Cleaner() {
        this.m_me = this;
        this.initialize();
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("ContentPane");
                this.ivjJFrameContentPane.setLayout(new BorderLayout());
                this.ivjJFrameContentPane.add((Component)this.getApplicationPane(), "North");
                this.ivjJFrameContentPane.add((Component)this.getButtonPane(), "South");
                this.ivjJFrameContentPane.add((Component)this.getStatusPane(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JPanel getApplicationPane() {
        if (this.ivjApplicationPane == null) {
            try {
                this.ivjApplicationPane = new JPanel();
                this.ivjApplicationPane.setName("ApplicationPane");
                this.ivjApplicationPane.setLayout(new GridBagLayout());
                this.initApplicationPane();
            }
            catch (Throwable ivjExc) {
                this.initApplicationPane();
                this.handleException(ivjExc);
            }
        }
        return this.ivjApplicationPane;
    }

    private JPanel getStatusPane() {
        if (this.ivjStatusPane == null) {
            try {
                this.ivjStatusPane = new JPanel();
                this.ivjStatusPane.setName("StatusPane");
                this.ivjStatusPane.setLayout(new BorderLayout());
                this.initStatusPane();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatusPane;
    }

    private void initStatusPane() {
        JPanel gbStatus = new JPanel();
        gbStatus.setLayout(new GridBagLayout());
        EmptyBorder eb = new EmptyBorder(new Insets(3, 3, 3, 3));
        TitledBorder tb = new TitledBorder(bundle.getString("Results.txt"));
        CompoundBorder cb = new CompoundBorder(eb, tb);
        gbStatus.setBorder(cb);
        JLabel lScanning = new JLabel(bundle.getString("Scanning.txt"));
        JLabel lDeleting = new JLabel(bundle.getString("Deleting.txt"));
        JLabel lRemoved = new JLabel(bundle.getString("Removed.txt"));
        JLabel lReclaimed = new JLabel(bundle.getString("Reclaimed.txt"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbStatus.add((Component)lScanning, gbc);
        gbc.gridx = 2;
        gbc.weightx = 100.0;
        gbStatus.add((Component)this.m_lScanningVal, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbStatus.add((Component)lDeleting, gbc);
        gbc.gridx = 2;
        gbc.weightx = 100.0;
        gbStatus.add((Component)this.m_lDeletingVal, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbStatus.add((Component)lRemoved, gbc);
        gbc.gridx = 2;
        gbc.weightx = 100.0;
        gbStatus.add((Component)this.m_lRemovedVal, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbStatus.add((Component)lReclaimed, gbc);
        gbc.gridx = 2;
        gbc.weightx = 100.0;
        gbStatus.add((Component)this.m_lReclaimedVal, gbc);
        this.ivjStatusPane.add((Component)gbStatus, "Center");
    }

    private JPanel getButtonPane() {
        if (this.ivjButtonPane == null) {
            try {
                this.ivjButtonPane = new JPanel();
                this.ivjButtonPane.setName("ButtonPane");
                this.ivjButtonPane.setLayout(new GridBagLayout());
                this.initButtonPane();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonPane;
    }

    private void initButtonPane() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.onRun.putValue("Name", bundle.getString("Run.txt"));
        JButton btnRun = new JButton(this.onRun);
        this.ivjButtonPane.add((Component)btnRun, gbc);
        gbc.gridx = 2;
        this.onClose.putValue("Name", bundle.getString("Close.txt"));
        this.m_btnClose = new JButton(this.onClose);
        this.ivjButtonPane.add((Component)this.m_btnClose, gbc);
        this.m_btnClose.requestFocus();
    }

    private void handleException(Throwable exception) {
        exception.printStackTrace(System.out);
    }

    private void initialize() {
        try {
            this.setName(bundle.getString("ApplicationTitle.txt"));
            ClassLoader myCL = this.getClass().getClassLoader();
            URL iconURL = myCL.getResource("com/sas/tools/installs/it/cleaner/SASLogo.gif");
            ImageIcon appIcon = new ImageIcon(iconURL);
            this.setIconImage(appIcon.getImage());
            this.setDefaultCloseOperation(2);
            this.setSize(600, 700);
            this.setResizable(false);
            String title = bundle.getString("ApplicationTitle.txt");
            this.setTitle(title);
            this.setContentPane(this.getJFrameContentPane());
            this.getRootPane().getInputMap(2).put(this.escapeKeyStroke, "ESCAPE");
            this.getRootPane().getActionMap().put("ESCAPE", this.escapeAction);
            this.getRootPane().setDefaultButton(this.m_btnClose);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void initApplicationPane() {
        File jarPath;
        GridBagConstraints gbc = new GridBagConstraints();
        JTextArea taDisclaimer = new JTextArea(1, 72);
        taDisclaimer.setText(bundle.getString("Disclaimer.txt"));
        taDisclaimer.setFont(this.m_valSASHome.getFont());
        taDisclaimer.setEditable(false);
        taDisclaimer.setBackground(SystemColor.control);
        taDisclaimer.setBorder(new EmptyBorder(3, 3, 3, 3));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 2;
        gbc.anchor = 17;
        this.getApplicationPane().add((Component)taDisclaimer, gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        JLabel lSASHome = new JLabel(bundle.getString("SASHome.txt"));
        lSASHome.setBorder(new EmptyBorder(3, 3, 3, 3));
        gbc.gridy = 2;
        this.getApplicationPane().add((Component)lSASHome, gbc);
        URL url = Cleaner.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            jarPath = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            jarPath = new File(url.getPath());
        }
        this.m_SASHome = jarPath.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
        this.m_valSASHome.setText(this.m_SASHome.getPath());
        gbc.gridx = 2;
        this.getApplicationPane().add((Component)this.m_valSASHome, gbc);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Cleaner aCleaner = new Cleaner();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            aCleaner.pack();
            Dimension frameSize = aCleaner.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            aCleaner.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            aCleaner.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    System.exit(0);
                }
            });
            aCleaner.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of Cleaner");
            exception.printStackTrace(System.out);
        }
    }

    protected void clean() {
        this.setRunning(true);
        File curDir = new File(this.m_SASHome.getPath(), "InstallMisc/InstallLogs");
        try {
            this.m_logFile = File.createTempFile("Cleanup_", ".log", curDir);
            this.m_log = new PrintStream(this.m_logFile);
        }
        catch (IOException e) {
            this.m_log = System.out;
        }
        this.cleanSearch(this.m_SASHome, false);
        this.confirmWindow();
        this.deleteExtraFiles();
        this.logSummary();
        this.m_log.close();
        this.setRunning(false);
    }

    private void deleteExtraFiles() {
        File uninst = new File(this.m_SASHome.getPath() + "/InstallMisc/uninstall.xml");
        long len = uninst.length();
        if (uninst.exists()) {
            boolean deleted = uninst.delete();
            this.m_log.print("Deleting " + uninst.getPath() + " ...");
            this.updateDeleting(uninst.getName(), len, deleted);
            this.m_log.print((deleted ? "SUCCESS" : "FAIL") + EOL);
        }
    }

    private void logSummary() {
        this.m_log.print(EOL + "Results:" + EOL);
        this.m_log.print("Files removed:       " + this.m_lRemovedVal.getText() + EOL);
        this.m_log.print("Space reclaimed:     " + this.m_lReclaimedVal.getText() + EOL);
        this.m_log.print("Files not removed:   " + this.m_lNotRemovedVal.getText() + EOL);
        this.m_log.print("Space not reclaimed: " + this.m_lNotReclaimedVal.getText() + EOL);
    }

    private void setRunning(boolean running) {
        this.m_isRunning = running;
        this.setCursor(running ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor());
        this.setDefaultCloseOperation(running ? 0 : 2);
        this.onRun.setEnabled(this.onRun.isEnabled());
        this.onClose.setEnabled(this.onClose.isEnabled());
    }

    private void cleanSearch(File dir, boolean prune) {
        Path startPath = Paths.get(dir.getPath(), new String[0]);
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Cleaner.this.updateSearching(file.getFileName().toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (dir.getFileName().toString().matches(".*[^_]_HF[^_].*")) {
                        Cleaner.this.listModel.addElement(dir.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateDeleting(String name, long size, boolean removed) {
        this.m_lDeletingVal.setText(name);
        if (removed) {
            ++this.m_filesRemoved;
            this.m_spaceReclaimed += (double)size;
            this.m_lRemovedVal.setText(Long.toString(this.m_filesRemoved));
            this.m_lReclaimedVal.setText(this.formatDiskSpace(this.m_spaceReclaimed));
        } else {
            ++this.m_filesNotRemoved;
            this.m_spaceNotReclaimed += (double)size;
            this.m_lNotRemovedVal.setText(Long.toString(this.m_filesNotRemoved));
            this.m_lNotReclaimedVal.setText(this.formatDiskSpace(this.m_spaceNotReclaimed));
        }
        this.repaintNow();
    }

    private void preRunInitialization() {
        this.m_lScanningVal.setText("");
        this.m_lDeletingVal.setText("");
        this.m_filesRemoved = 0L;
        this.m_spaceReclaimed = 0.0;
        this.m_lRemovedVal.setText(Long.toString(this.m_filesRemoved));
        this.m_lReclaimedVal.setText(this.formatDiskSpace(this.m_spaceReclaimed));
        this.m_filesNotRemoved = 0L;
        this.m_spaceNotReclaimed = 0.0;
        this.m_lNotRemovedVal.setText(Long.toString(this.m_filesNotRemoved));
        this.m_lNotReclaimedVal.setText(this.formatDiskSpace(this.m_spaceNotReclaimed));
        this.itemList = new JList<String>(this.listModel);
        this.repaintNow();
    }

    private void updateSearching(String name) {
        this.m_lScanningVal.setText(name);
        this.repaintNow();
    }

    private void repaintNow() {
        this.repaint();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String formatDiskSpace(double size) {
        String formatted = size > 1.0E12 ? String.format("%.1f TB", size / 1.0E12) : (size > 1.0E9 ? String.format("%.1f GB", size / 1.0E9) : (size > 1000000.0 ? String.format("%.1f MB", size / 1000000.0) : (size > 1000.0 ? String.format("%.1f KB", size / 1000.0) : ((int)size == 1 ? String.format("%d byte", (int)size) : String.format("%d bytes", (int)size)))));
        return formatted;
    }

    private void done() {
        String msg = MessageFormat.format(bundle.getString("Done.txt"), this.m_logFile.getPath());
        JOptionPane.showMessageDialog(this, msg, bundle.getString("DoneTitle.txt"), 1);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void confirmWindow() {
        if (this.itemList.getModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, "No Directory to delete ", "Info", 1);
            System.exit(0);
        }
        String msg = MessageFormat.format(bundle.getString("searchDone.txt"), this.m_logFile.getPath());
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout());
        messagePanel.add((Component)new JLabel(msg), "North");
        JScrollPane searchScrollPane = new JScrollPane(this.itemList);
        searchScrollPane.setPreferredSize(new Dimension(400, 200));
        messagePanel.add((Component)searchScrollPane, "Center");
        int result = JOptionPane.showConfirmDialog(this, messagePanel, bundle.getString("DoneTitle.txt"), 0, 3);
        if (result == 0) {
            this.processSelectedItems(this.itemList);
        } else if (result == 1) {
            System.exit(0);
        }
    }

    private void processSelectedItems(JList<String> itemList) {
        ListModel<String> model = itemList.getModel();
        ArrayList<String> selectedItems = new ArrayList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            selectedItems.add(model.getElementAt(i));
        }
        for (String dirPath : selectedItems) {
            File dir = new File(dirPath);
            if (dir.exists() && dir.isDirectory()) {
                if (this.deleteDirectory(dir)) {
                    this.m_log.print("Deleting " + dirPath + " ..." + EOL);
                    continue;
                }
                System.err.println("Failed to delete directory: " + dirPath);
                JOptionPane.showMessageDialog(this, "Failed to delete directory: " + dirPath, "Error", 0);
                continue;
            }
            System.err.println("Invalid directory path: " + dirPath);
            JOptionPane.showMessageDialog(this, "Invalid directory path: " + dirPath, "Error", 0);
        }
    }

    private boolean deleteDirectory(File dir) {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File file : contents) {
                if (this.deleteDirectory(file)) continue;
                return false;
            }
        }
        long len = dir.length();
        boolean deleted = dir.delete();
        this.updateDeleting(dir.getName(), len, deleted);
        return deleted;
    }
}

