/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.HiveKeyRegistry;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.SASController;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.it.schema.uninstall.EditWindowsRegistry;
import com.sas.tools.installs.it.schema.uninstall.Uninstallregistrydata;
import com.sas.tools.installs.it.tasks.TaskHelper;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class WindowsRegistry
implements HiveKeyRegistry {
    private SASController _sasController = null;
    private final Logger log = (Logger)LogManager.getLogger(this.getClass().getName());
    private int _mode = 0;
    public static final int mode32 = 32;
    public static final int mode64 = 64;
    public static final int HKEY_CLASSES_ROOT = 1;
    public static final int HKEY_LOCAL_MACHINE = 8;
    public static final int HKEY_USERS = 16;
    public static final int HKEY_CURRENT_USER = 4;
    public static final int HKEY_CURRENT_CONFIG = 2;
    public static final int REG_NONE = 107;
    public static final int REG_SZ = 109;
    public static final int REG_EXPAND_SZ = 104;
    public static final int REG_BINARY = 100;
    public static final int REG_DWORD = 101;
    public static final int REG_DWORD_LITTLE_ENDIAN = 102;
    public static final int REG_DWORD_BIG_ENDIAN = 103;
    public static final int REG_LINK = 105;
    public static final int REG_MULTI_SZ = 106;
    public static final int REG_RESOURCE_LIST = 108;
    private final Map<String, EditWindowsRegistry> _keysToUninstall = new LinkedHashMap<String, EditWindowsRegistry>();
    private final Set<String> _childKeys = new HashSet<String>();
    private static Map<String, Integer> _stringToType = null;
    private static Map<Integer, String> _typeToString = null;
    private File _uninstallLog = null;
    private String _metadataDirectory = null;
    public static final String ADD_KEY = "addKey";
    public static final String ADD_KEY32 = "addKey32";
    public static final String LOG_KEY_TREE = "logKeyTree";
    public static final String DEL_KEY_TREE = "delKeyTree";
    public static final String REMOVE_KEY = "removeKey";
    public static final String REMOVE_KEY32 = "removeKey32";
    public static final String SET_VALUE = "setValue";
    public static final String SET_VALUE32 = "setValue32";
    public static final String IMPORT = "import";
    public static final String REMOVE_VALUE = "removeValue";
    public static final String REMOVE_VALUE32 = "removeValue32";

    public WindowsRegistry() {
        this._sasController = Controller._defaultController.getSASController();
        if (!JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, WinRegAPI.libNames)) {
            String missingLib = JNIUtils.getJniLib(SASWinAPI.libNames);
            throw new InstallException(1, null, this._sasController.getBundle().messageString("Controller.MissingJNILib", missingLib), "Unable to load library:  " + missingLib, null);
        }
        this.setDefaultBitMode();
    }

    protected void setDefaultBitMode() {
        this._mode = TaskHelper.getOS_Suffix().equals("win") ? 32 : 64;
    }

    @Override
    public void setUninstallLog(String metadataDirectory, String taskName) {
        this._uninstallLog = new File(Utils.joinPath(metadataDirectory, "win_registry_" + taskName + ".xml"));
        this._metadataDirectory = metadataDirectory;
        this.log.info("Windows Registry uninstall log: " + this._uninstallLog.getAbsolutePath());
        this.loadUninstallData();
    }

    protected File getUninstallLog() {
        return this._uninstallLog;
    }

    protected String getMetadataDirectory() {
        return this._metadataDirectory;
    }

    @Override
    public void setBitMode(int mode) {
        this._mode = TaskHelper.getOS_Suffix().equals("win") ? 32 : mode;
        this.log.info("bit mode set to: " + this._mode);
    }

    @Override
    public boolean setRegistryReflection(boolean state) {
        this.log.warn("registry reflection API has not been implemented");
        return false;
    }

    @Override
    public boolean logKeyTree(int hive, String key) {
        if (!this.keyExists(hive, key)) {
            this.logKey(hive, key, DEL_KEY_TREE);
        }
        return true;
    }

    @Override
    public boolean delKeyTree(int hive, String key) {
        boolean result = true;
        if (this.keyExists(hive, key)) {
            result = WinRegAPI.DelRegTree(hive, key);
        }
        if (result) {
            this.log.info("registry key tree does not exist or was successfully deleted: " + WindowsRegistry.determineKeyWithHive(hive, key));
        } else {
            this.log.warn("could not delete registry key tree: " + WindowsRegistry.determineKeyWithHive(hive, key));
        }
        return result;
    }

    @Override
    public boolean createKey(int hive, String key) {
        return this.createKey(hive, key, true);
    }

    @Override
    public boolean createKey(int hive, String key, boolean writeToLog) {
        String parentKey = "";
        if (!this.validateRegistryArgs(hive, key)) {
            this.log.warn("arguments for createKey are not valid: hive: " + hive + " key: " + key);
            return false;
        }
        boolean result = false;
        if (key.contains("\\")) {
            String[] keysToCreate = key.split("\\\\");
            for (int i = 0; i < keysToCreate.length && (keysToCreate[i].equals("") || (result = this.createEachKey(hive, parentKey = parentKey.equals("") ? keysToCreate[i] : Utils.joinPath(parentKey, keysToCreate[i]), writeToLog))); ++i) {
            }
        } else {
            result = this.createEachKey(hive, key, writeToLog);
        }
        return result;
    }

    protected boolean createEachKey(int hive, String key, boolean writeToLog) {
        boolean result = false;
        String uninstallAction = "";
        if (!this.keyExists(hive, key)) {
            if (TaskHelper.getOS_Suffix().equals("win") || this._mode == 64) {
                result = WinRegAPI.CreateRegKey(hive, key);
                uninstallAction = REMOVE_KEY;
            } else {
                result = WinRegAPI.CreateRegKey32(hive, key);
                uninstallAction = REMOVE_KEY32;
            }
            if (result && writeToLog) {
                this.logKey(hive, key, uninstallAction);
            }
            if (result) {
                this.log.info("registry key successfully created: " + WindowsRegistry.determineKeyWithHive(hive, key));
            } else {
                this.log.warn("could not create registry key: " + WindowsRegistry.determineKeyWithHive(hive, key));
            }
        } else {
            result = true;
        }
        return result;
    }

    @Override
    public boolean keyExists(int hive, String key) {
        if (!this.validateRegistryArgs(hive, key)) {
            this.log.warn("arguments for keyExists are not valid: hive: " + hive + " key: " + key);
            return false;
        }
        if (this._mode == 32) {
            return WinRegAPI.isWindowsRegistryKey32(hive, key);
        }
        return WinRegAPI.isWindowsRegistryKey64(hive, key);
    }

    @Override
    public boolean deleteKey(int hive, String key) {
        return this.deleteKey(hive, key, true);
    }

    protected boolean deleteKey(int hive, String key, boolean writeToLog) {
        if (!this.validateRegistryArgs(hive, key)) {
            this.log.warn("arguments for deleteKey are not valid: hive: " + hive + " key: " + key);
            return false;
        }
        boolean result = false;
        String uninstallAction = "";
        if (this.keyExists(hive, key)) {
            if (TaskHelper.getOS_Suffix().equals("win") || this._mode == 64) {
                result = WinRegAPI.DelRegKey(hive, key);
                uninstallAction = ADD_KEY;
            } else {
                result = WinRegAPI.DelRegKeyWow6432(hive, key);
                uninstallAction = ADD_KEY32;
            }
            if (result && writeToLog) {
                this.logKey(hive, key, uninstallAction);
            }
        } else {
            result = true;
        }
        if (result) {
            this.log.info("registry key does not exist or successfully deleted: " + WindowsRegistry.determineKeyWithHive(hive, key));
        } else {
            this.log.warn("could not delete registry key: " + WindowsRegistry.determineKeyWithHive(hive, key));
        }
        return result;
    }

    @Override
    public boolean childKeyExist(int hive, String key) {
        if (!this.validateRegistryArgs(hive, key)) {
            this.log.warn("arguments for childKeyExist are not valid: hive: " + hive + " key: " + key);
            return false;
        }
        String[] keys = this.getChildrenForKey(hive, key);
        return keys.length > 0;
    }

    protected void buildKeyTree(int hive, String parentKey) {
        if (this.keyExists(hive, parentKey)) {
            String[] keys;
            for (String childKey : keys = this.getChildrenForKey(hive, parentKey)) {
                this._childKeys.add(WindowsRegistry.hiveToString(hive) + "\\" + parentKey + "\\" + childKey);
                this.buildKeyTree(hive, Utils.joinPath(parentKey, childKey));
            }
        }
    }

    protected void clearKeyTree() {
        this._childKeys.clear();
    }

    @Override
    public Set<String> getKeyTree(int hive, String key) {
        if (!this.validateRegistryArgs(hive, key)) {
            this.log.warn("arguments for getKeyTree are not valid: hive: " + hive + " key: " + key);
            return null;
        }
        this.clearKeyTree();
        this.buildKeyTree(hive, key);
        return this._childKeys;
    }

    @Override
    public boolean deleteValue(int hive, String key, String name) {
        return this.deleteValue(hive, key, name, true);
    }

    protected boolean deleteValue(int hive, String key, String name, boolean writeToLog) {
        if (!this.validateRegistryArgs(hive, key, name)) {
            this.log.warn("arguments for deleteValue are not valid: hive: " + hive + " key: " + key + " name: " + name);
            return false;
        }
        boolean result = false;
        String uninstallAction = "";
        if (this.keyExists(hive, key)) {
            String value = this.getValue(hive, key, name);
            int type = this.getValueType(hive, key, name);
            if (value != null && !"".equals(value)) {
                if (TaskHelper.getOS_Suffix().equals("win") || this._mode == 32) {
                    result = WinRegAPI.DelRegKeyValue(hive, key, name);
                    uninstallAction = SET_VALUE32;
                } else {
                    result = WinRegAPI.DelRegKeyValue64(hive, key, name);
                    uninstallAction = SET_VALUE;
                }
                if (result && writeToLog) {
                    this.logKey(hive, key, name, value, type, uninstallAction);
                }
            }
        } else {
            result = true;
        }
        if (result) {
            this.log.info("registry data does not exist or successfully deleted: " + WindowsRegistry.determineKeyWithHive(hive, key) + "\\" + name);
        } else {
            this.log.warn("could not delete registry data: " + WindowsRegistry.determineKeyWithHive(hive, key) + "\\" + name);
        }
        return result;
    }

    @Override
    public boolean setValue(int hive, String key, String name, String data, int type) {
        return this.setValue(hive, key, name, data, type, true);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean setValue(int hive, String key, String name, String data, int type, boolean writeToLog) {
        if (!this.validateRegistryArgs(hive, key, name, data, type)) {
            this.log.warn("arguments for setValue are not valid: hive: " + hive + " key: " + key + " name: " + name + " data: " + data + " type: " + type);
            return false;
        }
        existingData = null;
        existingType = -1;
        result = false;
        uninstallSetAction = "";
        uninstallRemoveAction = "";
        if (!this.keyExists(hive, key)) {
            this.createKey(hive, key);
        }
        if (this.keyExists(hive, key)) {
            intValue = -1;
            if (type == 101) {
                intValue = this.convertToInteger(data);
            }
            existingData = this.getValue(hive, key, name);
            existingType = this.getValueType(hive, key, name);
            try {
                if (TaskHelper.getOS_Suffix().equals("win") || this._mode == 64) {
                    uninstallSetAction = "setValue";
                    uninstallRemoveAction = "removeValue";
                    if (type == 109 || type == 104) {
                        result = WinRegAPI.SetRegValue(hive, key, name, data, type);
                    } else if (type == 101) {
                        result = false;
                        if (intValue != -1) {
                            result = WinRegAPI.SetRegDwordValue(hive, key, name, intValue, type);
                        }
                    } else {
                        this.log.warn("Registry data type not supported: " + type);
                    }
                } else {
                    uninstallSetAction = "setValue32";
                    uninstallRemoveAction = "removeValue32";
                    if (type == 109 || type == 104) {
                        result = WinRegAPI.SetRegValue32(hive, key, name, data, type);
                    } else if (type == 101) {
                        result = false;
                        if (intValue != -1) {
                            result = WinRegAPI.SetRegDwordValue32(hive, key, name, intValue, type);
                        }
                    } else {
                        this.log.warn("Registry data type not supported: " + type);
                    }
                }
                if (!writeToLog || !result) ** GOTO lbl57
                logName = name;
                if ("".equals(logName)) {
                    logName = "@";
                }
                if (existingData == null) {
                    this.logKey(hive, key, logName, data, type, uninstallRemoveAction);
                }
                this.logKey(hive, key, logName, existingData, existingType, uninstallSetAction);
            }
            catch (Exception e) {
                this.log.error("exception occurred setting registry value for: " + WindowsRegistry.determineKeyWithHive(hive, key) + "\\" + name + " data: " + data + " type: " + WindowsRegistry.typeToString(type));
                this.log.error(e.getMessage());
                return result;
            }
        } else {
            result = false;
        }
lbl57:
        // 4 sources

        if (result) {
            this.log.info("registry data set for: " + WindowsRegistry.determineKeyWithHive(hive, key) + "\\" + name + " data: " + data + " type: " + WindowsRegistry.typeToString(type));
        } else {
            this.log.warn("could not set registry data for: " + WindowsRegistry.determineKeyWithHive(hive, key) + "\\" + name + " data: " + data + " type: " + WindowsRegistry.typeToString(type));
        }
        return result;
    }

    @Override
    public String getValue(int hive, String key, String name) {
        if (!this.validateRegistryArgs(hive, key, name)) {
            this.log.warn("arguments for getValue are not valid: hive: " + hive + " key: " + key + " name: " + name);
            return "";
        }
        int type = this.getValueType(hive, key, name);
        if (type == 107) {
            return null;
        }
        if (TaskHelper.getOS_Suffix().equals("win") || this._mode == 64) {
            if (type == 109 || type == 104) {
                return WinRegAPI.getWindowsRegistryValue(hive, key, name);
            }
            if (type == 101) {
                return Integer.toString(WinRegAPI.getWinRegDwordValue(hive, key, name));
            }
            this.log.warn("Registry data type not supported: " + type);
            return null;
        }
        if (type == 109 || type == 104) {
            return WinRegAPI.getWinRegValue32(hive, key, name);
        }
        if (type == 101) {
            return Integer.toString(WinRegAPI.getWinRegDwordValue32(hive, key, name));
        }
        this.log.warn("Registry data type not supported: " + type);
        return null;
    }

    @Override
    public int getValueType(int hive, String key, String name) {
        if (!this.validateRegistryArgs(hive, key, name)) {
            this.log.warn("arguments for getValueType are not valid: hive: " + hive + " key: " + key + " name: " + name);
            return -1;
        }
        if (!this.keyExists(hive, key)) {
            return 107;
        }
        Long type = null;
        HashMap<Long, Integer> valueTypes = new HashMap<Long, Integer>();
        valueTypes.put(0L, 107);
        valueTypes.put(1L, 109);
        valueTypes.put(2L, 104);
        valueTypes.put(3L, 100);
        valueTypes.put(4L, 101);
        valueTypes.put(5L, 103);
        valueTypes.put(6L, 105);
        valueTypes.put(7L, 106);
        valueTypes.put(8L, 108);
        type = this._mode == 32 ? Long.valueOf(WinRegAPI.getWinRegType32(hive, key, name)) : Long.valueOf(WinRegAPI.getWinRegType64(hive, key, name));
        if (type == null || !valueTypes.containsKey(type)) {
            return 107;
        }
        return (Integer)valueTypes.get(type);
    }

    @Override
    public String[] getChildrenForKey(int hive, String key) {
        String[] children = null;
        if (!this.validateRegistryArgs(hive, key)) {
            this.log.warn("arguments for getChildrenForKey are not valid: hive: " + hive + " key: " + key);
        }
        if ((children = this._mode == 32 ? WinRegAPI.childrenForKey32(hive, key) : WinRegAPI.childrenForKey64(hive, key)) == null) {
            this.log.info("No children found for " + hive + "\\" + key);
            children = new String[]{};
        }
        return children;
    }

    @Override
    public void uninstallRegistryKeys() {
        this.log.info("processing registry uninstall log: " + this.getUninstallLog().getAbsolutePath());
        this.rollbackRegistryKeys();
        this.log.info("removing registry uninstall log: " + this.getUninstallLog().delete());
    }

    protected void loadUninstallData() {
        if (this.getUninstallLog().exists()) {
            try {
                Uninstallregistrydata uninstallData = SchemaUtils.unmarshal(this.getUninstallLog(), Uninstallregistrydata.class);
                List<EditWindowsRegistry> registryEdits = uninstallData.getEditWindowsRegistry();
                for (EditWindowsRegistry registryEdit : registryEdits) {
                    if (registryEdit.getName() == null || registryEdit.getName().equals("")) {
                        this.logKey(WindowsRegistry.stringToHive(registryEdit.getHive()), registryEdit.getKey(), registryEdit.getAction());
                        continue;
                    }
                    this.logKey(WindowsRegistry.stringToHive(registryEdit.getHive()), registryEdit.getKey(), registryEdit.getName(), registryEdit.getData(), WindowsRegistry.stringToType(registryEdit.getType()), registryEdit.getAction());
                }
            }
            catch (JAXBException e) {
                throw new InstallException(1, null, this._sasController.getBundle().messageString("WindowsRegistry.JAXBReadError", this.getUninstallLog()), "exception occurred while loading Windows Registry uninstall data file " + this.getUninstallLog(), e);
            }
        }
    }

    @Override
    public void rollbackRegistryKeys() {
        boolean writeToLog = false;
        boolean result = false;
        EditWindowsRegistry keyInfo = new EditWindowsRegistry();
        Comparator reverse = Collections.reverseOrder();
        TreeSet ss = new TreeSet(reverse);
        ss.addAll(this._keysToUninstall.keySet());
        Iterator iterKeys = ss.iterator();
        while (iterKeys.hasNext()) {
            this.setDefaultBitMode();
            String uninstallKey = (String)iterKeys.next();
            keyInfo = this._keysToUninstall.get(uninstallKey);
            if (keyInfo == null) {
                this.log.warn("uninstall: key is null for " + uninstallKey);
                continue;
            }
            String action = keyInfo.getAction();
            String hive = keyInfo.getHive();
            String key = keyInfo.getKey();
            String name = keyInfo.getName();
            String data = keyInfo.getData();
            String type = keyInfo.getType();
            if ("@".equals(name)) {
                name = "";
            }
            if (ADD_KEY.equals(action) || REMOVE_KEY.equals(action) || DEL_KEY_TREE.equals(action)) {
                this.log.info("uninstall action: " + action + ": " + hive + "\\" + key);
            } else {
                this.log.info("uninstall action: " + action + ": " + hive + "\\" + key + "\\" + name + " data: " + data + " type: " + type);
            }
            if (ADD_KEY.equals(action)) {
                result = this.createKey(WindowsRegistry.stringToHive(hive), key, writeToLog);
            } else if (ADD_KEY32.equals(action)) {
                this.setBitMode(32);
                result = this.createKey(WindowsRegistry.stringToHive(hive), key, writeToLog);
            } else if (REMOVE_KEY.equals(action)) {
                result = this.deleteKey(WindowsRegistry.stringToHive(hive), key);
            } else if (REMOVE_KEY32.equals(action)) {
                this.setBitMode(32);
                result = this.deleteKey(WindowsRegistry.stringToHive(hive), key);
            } else if (SET_VALUE.equals(action)) {
                result = this.setValue(WindowsRegistry.stringToHive(hive), key, name, data, WindowsRegistry.stringToType(type), writeToLog);
            } else if (SET_VALUE32.equals(action)) {
                this.setBitMode(32);
                result = this.setValue(WindowsRegistry.stringToHive(hive), key, name, data, WindowsRegistry.stringToType(type), writeToLog);
            } else if (REMOVE_VALUE.equals(action)) {
                result = this.deleteValue(WindowsRegistry.stringToHive(hive), key, name, writeToLog);
            } else if (REMOVE_VALUE32.equals(action)) {
                this.setBitMode(32);
                result = this.deleteValue(WindowsRegistry.stringToHive(hive), key, name, writeToLog);
            } else if (DEL_KEY_TREE.equals(action)) {
                result = this.delKeyTree(WindowsRegistry.stringToHive(hive), key);
            }
            if (result) continue;
            this.log.warn("warnings occurred while rolling back registry keys");
        }
    }

    protected void logKey(int hive, String key, String action) {
        this.logKey(hive, key, "", "", -1, action);
    }

    protected void logKey(int hive, String key, String name, String data, int type, String action) {
        String uninstallKey = action.concat(WindowsRegistry.determineKeyWithHiveAndName(hive, key, name));
        EditWindowsRegistry keyInfo = null;
        if (this.getUninstallLog() != null && !this._keysToUninstall.containsKey(uninstallKey)) {
            keyInfo = new EditWindowsRegistry();
            keyInfo.setHive(WindowsRegistry.hiveToString(hive));
            keyInfo.setKey(key);
            keyInfo.setName(name);
            keyInfo.setData(data);
            keyInfo.setType(WindowsRegistry.typeToString(type));
            keyInfo.setAction(action);
            this._keysToUninstall.put(uninstallKey, keyInfo);
        }
    }

    public static String determineKeyWithHive(int hive, String key) {
        return Utils.joinPath(WindowsRegistry.hiveToString(hive), key);
    }

    protected static String determineKeyWithHiveAndName(int hive, String key, String name) {
        return Utils.joinPath(WindowsRegistry.hiveToString(hive), key, name);
    }

    public static String determineKey(String keyWithHive) {
        return keyWithHive.substring(keyWithHive.indexOf("\\") + 1);
    }

    public static int stringToHive(String keyWithHive) {
        int hive = 0;
        if (keyWithHive.indexOf("HKEY_CLASSES_ROOT") == 0) {
            hive = 1;
        } else if (keyWithHive.indexOf("HKEY_LOCAL_MACHINE") == 0) {
            hive = 8;
        } else if (keyWithHive.indexOf("HKEY_USERS") == 0) {
            hive = 16;
        } else if (keyWithHive.indexOf("HKEY_CURRENT_USER") == 0) {
            hive = 4;
        } else if (keyWithHive.indexOf("HKEY_CURRENT_CONFIG") == 0) {
            hive = 2;
        }
        return hive;
    }

    public static String hiveToString(int hive) {
        if (hive == 1) {
            return "HKEY_CLASSES_ROOT";
        }
        if (hive == 8) {
            return "HKEY_LOCAL_MACHINE";
        }
        if (hive == 16) {
            return "HKEY_USERS";
        }
        if (hive == 4) {
            return "HKEY_CURRENT_USER";
        }
        if (hive == 2) {
            return "HKEY_CURRENT_CONFIG";
        }
        return "";
    }

    private static void setTypes() {
        _stringToType = new HashMap<String, Integer>();
        _typeToString = new HashMap<Integer, String>();
        _stringToType.put("REG_BINARY", 100);
        _stringToType.put("REG_DWORD", 101);
        _stringToType.put("REG_DWORD_LITTLE_ENDIAN", 102);
        _stringToType.put("REG_DWORD_BIG_ENDIAN", 103);
        _stringToType.put("REG_EXPAND_SZ", 104);
        _stringToType.put("REG_LINK", 105);
        _stringToType.put("REG_NONE", 107);
        _stringToType.put("REG_RESOURCE_LIST", 108);
        _stringToType.put("REG_SZ", 109);
        _typeToString.put(100, "REG_BINARY");
        _typeToString.put(101, "REG_DWORD");
        _typeToString.put(102, "REG_DWORD_LITTLE_ENDIAN");
        _typeToString.put(103, "REG_DWORD_BIG_ENDIAN");
        _typeToString.put(104, "REG_EXPAND_SZ");
        _typeToString.put(105, "REG_LINK");
        _typeToString.put(107, "REG_NONE");
        _typeToString.put(108, "REG_RESOURCE_LIST");
        _typeToString.put(109, "REG_SZ");
    }

    public static int stringToType(String type) {
        WindowsRegistry.setTypes();
        if (type != null && !type.equals("")) {
            return _stringToType.get(type);
        }
        return -1;
    }

    public static String typeToString(int type) {
        WindowsRegistry.setTypes();
        String result = _typeToString.get(type);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    public void writeUninstallData() {
        String uninstallKey2 = null;
        EditWindowsRegistry keyInfo = null;
        try {
            JAXBContext jc = JAXBContext.newInstance("com.sas.tools.installs.it.schema.uninstall", this.getClass().getClassLoader());
            Uninstallregistrydata uninstallData = new Uninstallregistrydata();
            for (String uninstallKey2 : this._keysToUninstall.keySet()) {
                keyInfo = this._keysToUninstall.get(uninstallKey2);
                if (keyInfo == null) {
                    this.log.warn("uninstall: key is null for " + uninstallKey2);
                    continue;
                }
                uninstallData.getEditWindowsRegistry().add(keyInfo);
            }
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.encoding", "UTF-8");
            m.setProperty("jaxb.formatted.output", Boolean.TRUE);
            m.marshal((Object)uninstallData, new FileOutputStream(this.getUninstallLog().getAbsolutePath()));
        }
        catch (JAXBException e) {
            throw new InstallException(1, null, this._sasController.getBundle().messageString("WindowsRegistry.JAXBWriteError", this.getUninstallLog()), "exception occurred while writing Windows Registry uninstall data file " + this.getUninstallLog(), e);
        }
        catch (FileNotFoundException e) {
            throw new InstallException(1, null, this._sasController.getBundle().messageString("WindowsRegistry.JAXBWriteError", this.getUninstallLog()), "exception occurred while writing Windows Registry uninstall data file " + this.getUninstallLog(), e);
        }
    }

    protected String handleSpecialChars(String line) {
        return line.replace("&", "&amp;");
    }

    protected boolean validateRegistryArgs(int hive, String key) {
        return this.validateRegistryArgs(hive, key, "name", "data", 107);
    }

    protected boolean validateRegistryArgs(int hive, String key, String name) {
        return this.validateRegistryArgs(hive, key, name, "data", 107);
    }

    protected boolean validateRegistryArgs(int hive, String key, String name, String data, int type) {
        if ("".equals(WindowsRegistry.hiveToString(hive))) {
            this.log.warn("invalid value for hive: " + hive);
            return false;
        }
        if (key == null || "".equals(key)) {
            this.log.warn("invalid value for key: " + key);
            return false;
        }
        if (name == null) {
            this.log.warn("invalid value for name: " + name);
            return false;
        }
        if ("".equals(WindowsRegistry.typeToString(type))) {
            this.log.warn("invalid value for type: " + type);
            return false;
        }
        return true;
    }

    protected int convertToInteger(String data) {
        int value = -1;
        try {
            value = data.startsWith("0x") ? Integer.parseInt(data.substring(data.indexOf("x") + 1), 16) : Integer.parseInt(data);
        }
        catch (Exception e) {
            value = -1;
        }
        return value;
    }
}

