/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.PreExecuteRunnable;
import com.sas.tools.installs.it.PreExecuteThreadPool;
import com.sas.tools.installs.it.tasks.TaskHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ExecutorService;

public class TestHarness {
    protected static Controller _controller = new Controller();
    protected static Vector<PreExecuteRunnable> preExecuteRunnables = new Vector();
    protected static ExecutorService threadPool = null;

    public static ExecutorService getPreExecuteThreadPool() {
        if (threadPool == null) {
            threadPool = PreExecuteThreadPool.newPreExecuteThreadPool();
        }
        return threadPool;
    }

    public static Controller getController() {
        return _controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File sasHome;
        File dReg;
        String depotRoot = null;
        String altskuData = null;
        List<Object> altskus = new Vector();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-depotroot")) {
                depotRoot = args[i + 1];
                ++i;
                continue;
            }
            if (arg.equalsIgnoreCase("-altskus")) {
                altskuData = args[i + 1];
                ++i;
                altskus = Arrays.asList(altskuData.split(":"));
                continue;
            }
            if (arg.equalsIgnoreCase("-debugpause")) {
                int secs = new Integer(args[i + 1]);
                try {
                    for (int j = 0; j < secs; ++j) {
                        Thread.sleep(new Long(1000L));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
                continue;
            }
            if (arg.equalsIgnoreCase("-sashome")) {
                System.setProperty("SASHome", args[i + 1]);
                ++i;
                continue;
            }
            if (!arg.equalsIgnoreCase("-installProperties")) continue;
            Properties installProperties = new Properties();
            String propertiesPath = new File(args[i + 1]).getAbsolutePath();
            try (FileInputStream is = null;){
                is = new FileInputStream(propertiesPath);
                installProperties.load(is);
            }
            installProperties.setProperty("selected.languages", "en");
            Controller.setInstallProperties(installProperties);
        }
        File depot = null;
        if (depotRoot != null) {
            depot = new File(depotRoot);
        }
        if (depotRoot == null || !depot.isDirectory()) {
            TestHarness.failure(null, "The depot location specified by the -depotroot parameter (" + depotRoot + ") either wasn't specified or did not exist.  Exiting...");
        }
        if (altskus.size() == 0) {
            TestHarness.failure(null, "The colon separated test alt-sku locations specified by the -altskus parameter did not exist.  Exiting...");
        }
        if (System.getProperty("SASHome") == null) {
            TestHarness.failure(null, "No -sashome <SASHome> parameter was specified.  Exiting...");
        }
        if (!(dReg = new File(sasHome = new File(System.getProperty("SASHome")), "deploymntreg")).exists() && !dReg.mkdirs()) {
            TestHarness.failure(null, "Unable to create directory in specified sashome to install the deployment registry tooling:  " + dReg.getAbsolutePath());
        }
        if (!(dReg = new File(dReg, "sas.tools.deploymntreg.jar")).exists()) {
            FilenameFilter deploywizFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("deploywiz");
                }
            };
            File deploymntreg = new File(depot, "products");
            deploymntreg = deploymntreg.listFiles(deploywizFilter)[0];
            deploymntreg = new File(deploymntreg, "deploywiz");
            deploymntreg = new File(deploymntreg, "deploymntreg");
            deploymntreg = new File(deploymntreg, "sas.tools.deploymntreg.jar");
            try {
                TestHarness.getController().getFS().copyFile(deploymntreg, dReg);
            }
            catch (IOException e1) {
                TestHarness.failure(e1, "Failure setting up SASHome for testing");
            }
        }
        LinkedHashMap<File, File> productFileMap = new LinkedHashMap<File, File>();
        LinkedHashMap<File, String> altSkuFileMap = new LinkedHashMap<File, String>();
        for (String string : altskus) {
            File installXML;
            File skuData = new File(depotRoot, "product_data");
            if (!(skuData = new File(skuData, string)).isDirectory()) {
                TestHarness.failure(null, "One of the alt-skus specified by the -altskus parameter (" + altskuData + ") did not exist in the specified depot (" + depotRoot + ").  Exiting...");
            }
            if (!(installXML = new File(skuData, "install.xml")).isFile()) {
                installXML = new File(depotRoot, "products");
                installXML = new File(installXML, string);
                installXML = new File(installXML, "install.xml");
            }
            File productXML = new File(skuData, "product.xml");
            try {
                TestHarness.primeInstallTool(installXML, productXML, depot);
                productFileMap.put(installXML, productXML);
                altSkuFileMap.put(installXML, string);
            }
            catch (Throwable e) {
                TestHarness.failure(e, "Failed to initialize InstallTool correctly for " + installXML.getAbsolutePath() + " and " + productXML.getAbsolutePath());
            }
        }
        for (File file : productFileMap.keySet()) {
            TestHarness.preExecute(file, (File)productFileMap.get(file), (String)altSkuFileMap.get(file));
        }
        for (PreExecuteRunnable preExecuteRunnable : TestHarness.getPreExecuteRunnables()) {
            preExecuteRunnable.waitForCompletion();
            if (preExecuteRunnable.getPreExecuteReturnCode() == 0) continue;
            String twelveByte = preExecuteRunnable.getInstallProperty("12ByteCode");
            TestHarness.failure(null, "preExecute failed for " + twelveByte);
        }
        for (File file : productFileMap.keySet()) {
            try {
                int rc = TestHarness.execute(file, (File)productFileMap.get(file), depot);
                if (rc == 0) continue;
                TestHarness.failure(null, "Non-zero return code (" + rc + ") when installing " + file.getAbsolutePath());
            }
            catch (Throwable t) {
                TestHarness.failure(t, "execute failed when installing " + file.getAbsolutePath());
            }
        }
        int rc = 0;
        try {
            rc = TestHarness.postProcess();
            if (rc != 0) {
                TestHarness.failure(null, "post processing failed with return code" + rc);
            }
        }
        catch (Throwable throwable) {
            TestHarness.failure(throwable, "post processing failed with exception");
        }
        System.out.println("Success!");
        System.exit(0);
    }

    public static int execute(File installXMLFile, File productXMLFile, File depot) throws Exception {
        TestHarness.primeInstallTool(installXMLFile, productXMLFile, depot);
        Integer retVal = TestHarness.getController().runInstallation();
        return retVal;
    }

    public static void preExecute(File installXML, File productData, String altsku) {
        PreExecuteRunnable preExecute = new PreExecuteRunnable(installXML, productData, altsku);
        preExecuteRunnables.add(preExecute);
        TestHarness.getPreExecuteThreadPool().execute(preExecute);
    }

    public static int postProcess() {
        Integer retVal = TestHarness.getController().postProcess();
        return retVal;
    }

    public static Vector<PreExecuteRunnable> getPreExecuteRunnables() {
        return preExecuteRunnables;
    }

    public static void primeInstallTool(File installXMLFile, File productXMLFile, File depot) throws Exception {
        File sid = new File(depot, "order_data/SPS/SID");
        sid = sid.listFiles()[0];
        Vector<String> args = new Vector<String>(Arrays.asList("-skipversioncheck", "-skiplanguagecheck", "-file", installXMLFile.getAbsolutePath(), "-productData", productXMLFile.getAbsolutePath(), "-payloadDir", productXMLFile.getParent(), "-platform", TaskHelper.getOS_Suffix(), "-sashome", System.getProperty("SASHome"), "-vjrhome", System.getProperty("SASHome") + "/SAS93/SASVersionedJarRepository/9.3", "-sid", sid.getAbsolutePath(), "-silent"));
        TestHarness.getController().setupInstallationForArgs(args.toArray(new String[args.size()]));
    }

    public static void failure(Throwable t, String message) {
        System.out.println("Failure!");
        if (message != null) {
            System.out.println(message);
        }
        if (t != null) {
            System.out.println(Controller.stackTraceForError(t));
        }
        System.exit(1);
    }
}

