/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.view.SSNResource;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.PriorityQueue;

public class ProcessingQueue
extends PriorityQueue<ProcessingTask> {
    private static final long serialVersionUID = -438349810951997534L;
    protected SSNResource bundle = new SSNResource(this.getClass());
    protected SSNResource enBundle = SSNResource.EnglishResource(this.getClass());
    private int[] priorityCount = new int[ProcessingTask.Priority.values().length];
    private boolean alreadyExecuted = false;

    @Override
    public boolean add(ProcessingTask task) {
        return this.offer(task);
    }

    @Override
    public boolean offer(ProcessingTask task) {
        boolean added = false;
        try {
            this.unserializeTasks();
        }
        catch (IOException e) {
            throw new InstallException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new InstallException(e.getMessage(), e);
        }
        if (task != null && !this.contains(task)) {
            int n = task.getPriority().ordinal();
            int n2 = this.priorityCount[n];
            this.priorityCount[n] = n2 + 1;
            task.setOrder(n2);
            added = super.offer(task);
            if (added) {
                try {
                    this.serializeTasks();
                }
                catch (IOException e) {
                    throw new InstallException(e.getMessage(), e);
                }
            }
        }
        return added;
    }

    @Override
    public ProcessingTask poll() {
        ProcessingTask task = (ProcessingTask)super.poll();
        return task;
    }

    private void unserializeTasks() throws IOException, ClassNotFoundException {
        if (Controller.installProperties.getProperty("sdw.resume.chain").equals("TRUE") && !this.alreadyExecuted) {
            FileInputStream fileInput = new FileInputStream(Utils.joinPath(Controller.installProperties.getProperty("sdw.log.path"), "postProcessingTasks.ser"));
            ObjectInputStream in = new ObjectInputStream(fileInput);
            Controller.defaultController().setPostProcessingTasks((Map)in.readObject());
            in.close();
            fileInput.close();
            this.alreadyExecuted = true;
        }
    }

    private void serializeTasks() throws IOException {
        FileOutputStream fileOutput = new FileOutputStream(Utils.joinPath(Controller.installProperties.getProperty("sdw.log.path"), "postProcessingTasks.ser"));
        ObjectOutputStream out = new ObjectOutputStream(fileOutput);
        out.writeObject(Controller.defaultController().getPostProcessingTasks());
        out.close();
        fileOutput.close();
    }
}

