/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.listener.InstallationCompletionListener;
import com.sas.tools.installs.it.listener.InstallationProgressListener;
import com.sas.tools.installs.it.listener.InstallationSetupListener;
import com.sas.tools.installs.it.listener.RebootListener;
import com.sas.tools.installs.it.listener.RollbackProgressListener;
import com.sas.tools.installs.it.listener.WarningListener;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.InstallationTask;
import java.util.Vector;

public class NotificationHandler {
    protected Vector<InstallationCompletionListener> _installationCompletionListeners = new Vector();
    protected Vector<InstallationProgressListener> _installationProgressListeners = new Vector();
    protected Vector<RollbackProgressListener> _rollbackProgressListeners = new Vector();
    protected Vector<InstallationSetupListener> _installationSetupListeners = new Vector();
    protected Vector<RebootListener> _rebootListeners = new Vector();
    protected Vector<WarningListener> _warningListeners = new Vector();
    protected Controller _controller = Controller.defaultController();
    protected static NotificationHandler _defaultHandler;

    private NotificationHandler() {
    }

    public static NotificationHandler defaultHandler() {
        if (_defaultHandler == null) {
            _defaultHandler = new NotificationHandler();
        }
        Controller currentController = _defaultHandler.getController();
        Controller defaultController = Controller.defaultController();
        if (currentController == null || currentController != defaultController) {
            _defaultHandler.setController(defaultController);
        }
        return _defaultHandler;
    }

    public String getAltSku() {
        return this._controller.getAltSku();
    }

    public void addProgressListener(InstallationProgressListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().addProgressListener(listener);
        } else {
            this.getInstallationProgressListeners().add(listener);
        }
    }

    public void removeProgressListener(InstallationProgressListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().removeProgressListener(listener);
        } else {
            this.getInstallationProgressListeners().remove(listener);
        }
    }

    public void addRollbackProgressListener(RollbackProgressListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().addRollbackProgressListener(listener);
        } else {
            this.getRollbackProgressListeners().add(listener);
        }
    }

    public void removeRollbackProgressListener(RollbackProgressListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().removeRollbackProgressListener(listener);
        } else {
            this.getRollbackProgressListeners().remove(listener);
        }
    }

    public void addSetupListener(InstallationSetupListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().addSetupListener(listener);
        } else {
            this.getInstallationSetupListeners().add(listener);
        }
    }

    public void removeSetupListener(InstallationSetupListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().removeSetupListener(listener);
        } else {
            this.getInstallationSetupListeners().remove(listener);
        }
    }

    public void addCompletionListener(InstallationCompletionListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().addCompletionListener(listener);
        } else {
            this.getInstallationCompletionListeners().add(listener);
        }
    }

    public void removeCompletionListener(InstallationCompletionListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().removeCompletionListener(listener);
        } else {
            this.getInstallationCompletionListeners().remove(listener);
        }
    }

    public void addRebootListener(RebootListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().addRebootListener(listener);
        } else {
            this.getRebootListeners().add(listener);
        }
    }

    public void removeRebootListener(RebootListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().removeRebootListener(listener);
        } else {
            this.getRebootListeners().remove(listener);
        }
    }

    public void addWarningListener(WarningListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().addWarningListener(listener);
        } else {
            this.getWarningListeners().add(listener);
        }
    }

    public void removeWarningListener(WarningListener listener) {
        if (listener instanceof InstallationTask && this.getAltSku() != null) {
            this._controller.getCurrentContext().removeWarningListener(listener);
        } else {
            this.getWarningListeners().remove(listener);
        }
    }

    public void fireSetupNotification(String action, EntryData metaData, String message) {
        for (InstallationSetupListener listener : this.getInstallationSetupListeners()) {
            try {
                listener.setupAction(action, metaData);
            }
            catch (Exception e) {
                Controller.logStackTrace(e);
            }
        }
        for (InstallationSetupListener listener : this._controller.getCurrentContext().getInstallationSetupListeners()) {
            listener.setupAction(action, metaData);
        }
    }

    public void fireSetupNotification(String description) {
        for (InstallationSetupListener listener : this._installationSetupListeners) {
            listener.setupAction(description);
        }
        for (InstallationSetupListener listener : this._controller.getCurrentContext().getInstallationSetupListeners()) {
            listener.setupAction(description);
        }
    }

    public void fireProgressCompleteNotification(String action, EntryData metaData) {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.progressCompleteAction(action, metaData);
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.progressCompleteAction(action, metaData);
        }
    }

    public void fireInstallStartedNotification() {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.installStartedAction();
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.installStartedAction();
        }
    }

    public void fireInstallCompleteNotification() {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.installCompletedAction();
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.installCompletedAction();
        }
    }

    public void fireTaskStartedNotification(InstallationTask task) {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.taskStartedAction(task);
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.taskStartedAction(task);
        }
    }

    public void fireInstallationCompleteNotification() {
        for (InstallationCompletionListener listener : this._installationCompletionListeners) {
            listener.installationComplete();
        }
        for (InstallationCompletionListener listener : this._controller.getCurrentContext().getInstallationCompletionListeners()) {
            listener.installationComplete();
        }
    }

    public void fireInstallationCancelledNotification() {
        for (InstallationCompletionListener listener : this._installationCompletionListeners) {
            listener.installationCancelled();
        }
        for (InstallationCompletionListener listener : this._controller.getCurrentContext().getInstallationCompletionListeners()) {
            listener.installationCancelled();
        }
    }

    public void fireInstallationFailureNotification(String description) {
        for (InstallationCompletionListener listener : this._installationCompletionListeners) {
            listener.installationFailure(description);
        }
        for (InstallationCompletionListener listener : this._controller.getCurrentContext().getInstallationCompletionListeners()) {
            listener.installationFailure(description);
        }
    }

    public void fireRollbackProgressCompleteNotification(String action, EntryData metaData) {
        for (RollbackProgressListener listener : this.getRollbackProgressListeners()) {
            listener.rollbackProgressCompleteAction(action, metaData);
        }
        for (RollbackProgressListener listener : this._controller.getCurrentContext().getRollbackProgressListeners()) {
            listener.rollbackProgressCompleteAction(action, metaData);
        }
    }

    public void fireProgressCompleteNotification(String description) {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.progressCompleteAction(description);
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.progressCompleteAction(description);
        }
    }

    public void fireRollbackProgressCompleteNotification(String description) {
        for (RollbackProgressListener listener : this.getRollbackProgressListeners()) {
            listener.rollbackProgressCompleteAction(description);
        }
        for (RollbackProgressListener listener : this._controller.getCurrentContext().getRollbackProgressListeners()) {
            listener.rollbackProgressCompleteAction(description);
        }
    }

    public void fireProgressBeginNotification(String action, EntryData metaData) {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.progressBeginningAction(action, metaData);
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.progressBeginningAction(action, metaData);
        }
    }

    public void fireProgressFailedNotification(String action, EntryData metaData) {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.progressFailedAction(action, metaData);
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.progressFailedAction(action, metaData);
        }
    }

    public void fireRollbackProgressBeginNotification(String action, EntryData metaData) {
        for (RollbackProgressListener listener : this.getRollbackProgressListeners()) {
            listener.rollbackProgressBeginningAction(action, metaData);
        }
        for (RollbackProgressListener listener : this._controller.getCurrentContext().getRollbackProgressListeners()) {
            listener.rollbackProgressBeginningAction(action, metaData);
        }
    }

    public void fireProgressBeginNotification(String description) {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.progressBeginningAction(description);
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.progressBeginningAction(description);
        }
    }

    public void fireRollbackProgressBeginNotification(String description) {
        for (RollbackProgressListener listener : this._rollbackProgressListeners) {
            listener.rollbackProgressBeginningAction(description);
        }
        for (RollbackProgressListener listener : this._controller.getCurrentContext().getRollbackProgressListeners()) {
            listener.rollbackProgressBeginningAction(description);
        }
    }

    public void fireRebootFlagNotification(String description) {
        for (RebootListener listener : this._rebootListeners) {
            listener.rebootAction(description);
        }
        for (RebootListener listener : this._controller.getCurrentContext().getRebootListeners()) {
            listener.rebootAction(description);
        }
    }

    public void fireWarningFlagNotification(String description) {
        for (WarningListener listener : this._warningListeners) {
            listener.warningAction(description);
        }
        for (WarningListener listener : this._controller.getCurrentContext().getWarningListeners()) {
            listener.warningAction(description);
        }
    }

    public void bytesMoved(long numBytes) {
        for (InstallationProgressListener listener : this._installationProgressListeners) {
            listener.bytesMoved(numBytes);
        }
        for (InstallationProgressListener listener : this._controller.getCurrentContext().getInstallationProgressListeners()) {
            listener.bytesMoved(numBytes);
        }
    }

    public void rollbackBytesMoved(long numBytes) {
        for (RollbackProgressListener listener : this.getRollbackProgressListeners()) {
            listener.rollbackBytesMoved(numBytes);
        }
        for (RollbackProgressListener listener : this._controller.getCurrentContext().getRollbackProgressListeners()) {
            listener.rollbackBytesMoved(numBytes);
        }
    }

    public void fireFailureNotification(String description) {
        for (InstallationCompletionListener listener : this._installationCompletionListeners) {
            listener.installationFailure(description);
        }
        for (InstallationCompletionListener listener : this._controller.getCurrentContext().getInstallationCompletionListeners()) {
            listener.installationFailure(description);
        }
    }

    public void fireAllRollbackCompleteNotification() {
        for (RollbackProgressListener listener : this._rollbackProgressListeners) {
            listener.allRollbackCompleteAction();
        }
        for (RollbackProgressListener listener : this._controller.getCurrentContext().getRollbackProgressListeners()) {
            listener.allRollbackCompleteAction();
        }
    }

    public void fireRollbackFailureNotification(String description) {
        for (RollbackProgressListener listener : this._rollbackProgressListeners) {
            listener.rollbackFailure(description);
        }
        for (RollbackProgressListener listener : this._controller.getCurrentContext().getRollbackProgressListeners()) {
            listener.rollbackFailure(description);
        }
    }

    public Vector<InstallationCompletionListener> getInstallationCompletionListeners() {
        return this._installationCompletionListeners;
    }

    public Vector<InstallationProgressListener> getInstallationProgressListeners() {
        return this._installationProgressListeners;
    }

    public Vector<InstallationSetupListener> getInstallationSetupListeners() {
        return this._installationSetupListeners;
    }

    public Vector<RollbackProgressListener> getRollbackProgressListeners() {
        return this._rollbackProgressListeners;
    }

    public Vector<RebootListener> getRebootListeners() {
        return this._rebootListeners;
    }

    public Vector<WarningListener> getWarningListeners() {
        return this._warningListeners;
    }

    public void setController(Controller controller) {
        this._controller = controller;
    }

    public Controller getController() {
        return this._controller;
    }
}

