/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.it;

import com.sas.tools.deployjni.Utilities;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.AltskuProperties;
import com.sas.tools.installs.it.AuditLogger;
import com.sas.tools.installs.it.DeploymentPackage;
import com.sas.tools.installs.it.DeploymentParameters;
import com.sas.tools.installs.it.ExecutionThread;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.InstallationContext;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.PerfLogDelegateTask;
import com.sas.tools.installs.it.PreExecuteRunnable;
import com.sas.tools.installs.it.PreExecuteThread;
import com.sas.tools.installs.it.ProcessingQueue;
import com.sas.tools.installs.it.ProcessingTask;
import com.sas.tools.installs.it.ProcessingTaskInfo;
import com.sas.tools.installs.it.SASController;
import com.sas.tools.installs.it.UninstallsDisabledException;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.plugins.BuildHelpIndexDiskSpaceChecking;
import com.sas.tools.installs.it.plugins.WriteValidationFile;
import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.it.schema.install.gen.InstallType;
import com.sas.tools.installs.it.schema.install.gen.Project;
import com.sas.tools.installs.it.schema.install.gen.Target;
import com.sas.tools.installs.it.schema.product.ProdPkg;
import com.sas.tools.installs.it.tasks.ApplySASLicenseTask;
import com.sas.tools.installs.it.tasks.ApplyTKLasrLicenseTask;
import com.sas.tools.installs.it.tasks.BuildSASRegistryTask;
import com.sas.tools.installs.it.tasks.ExtractTask;
import com.sas.tools.installs.it.tasks.ExtractVJRContentTask;
import com.sas.tools.installs.it.tasks.Globals;
import com.sas.tools.installs.it.tasks.InstallationTask;
import com.sas.tools.installs.it.tasks.MvsextractTask;
import com.sas.tools.installs.it.tasks.TaskHelper;
import com.sas.tools.installs.it.view.ConfigurationException;
import com.sas.tools.installs.it.view.MITView;
import com.sas.tools.installs.it.view.SSNResource;
import com.sas.tools.installs.resource.FileSystem;
import com.sas.tools.installs.resource.JavaIOFileSystem;
import com.sas.tools.installs.schema.ittasks.DestinationType;
import com.sas.tools.installs.schema.ittasks.Hotfix;
import com.sas.tools.installs.schema.ittasks.ItTasks;
import com.sas.tools.installs.schema.ittasks.Version;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Controller {
    public static final String DEFAULT_LOG_PATH = "InstallMisc/InstallLogs";
    private static final String TASK_PACKAGE = "com.sas.tools.installs.it.tasks.";
    public static final String INSTALL_FILENAME = "Install Filename";
    public static final String TITLE = "Install Tool";
    public static final String MODE = "mode";
    public static final String INSTALL = "install";
    public static final String UNINSTALL = "uninstall";
    public static final String SRWONLY = "sdw.srwonly";
    public static boolean silent = false;
    public static String language = "en";
    public static boolean uninstall_mode = false;
    public static boolean skipUserChk = false;
    private boolean _loggingConfigured = false;
    protected static Logger log = (Logger)LogManager.getLogger(Controller.class.getName());
    private File logPath = null;
    protected File _installFile = null;
    protected String _altSku = null;
    protected boolean _started = false;
    private List<String> targets = Collections.emptyList();
    protected Map<String, Vector<InstallationTask>> _installTasksPerAltSku = new HashMap<String, Vector<InstallationTask>>();
    protected HashMap<String, InstallationContext> _installContexts = new HashMap();
    protected Map<String, Map<String, String>> _propertyHelpers = new HashMap<String, Map<String, String>>();
    private Map<String, ProcessingTaskInfo> postProcessingTasks = new HashMap<String, ProcessingTaskInfo>();
    protected String _viewClassname;
    protected String _sourceLocation = null;
    protected String _toolVersion = null;
    protected MITView _view;
    private SSNResource _bundle;
    private SSNResource _enBundle;
    protected SASController _sasController;
    protected File _chainFile;
    List<String> _altSkus = new Vector<String>();
    protected boolean _versionCheckingBypassed = false;
    protected boolean _maintenanceVersionCheckingSkipped = false;
    protected boolean _languageCheckSkipped = false;
    protected boolean _alwaysOverwrite = false;
    protected String _packageIdentifier = null;
    protected boolean _clientserver = false;
    protected boolean _interrupt = false;
    protected boolean _prtPackage = false;
    protected boolean _solstice = false;
    protected static Controller _defaultController;
    private List<String> _chainfileLines = new Vector<String>();
    private boolean _warning = false;
    public static HashMap<String, String> _productHomeInfo;
    protected Vector<String> _installLanguages = new Vector();
    protected Vector<String> _allInstallAltskus = new Vector();
    protected String _chainFileEntry;
    protected Set<String> defaultPlugins = new LinkedHashSet<String>(Arrays.asList("com.sas.tools.installs.it.plugins.WriteValidationFile", "com.sas.tools.installs.it.plugins.BuildHelpIndexDiskSpaceChecking"));
    protected Set<String> defaultOSPlugins = new LinkedHashSet<String>();
    public static final String SYSREQPACKAGE = "sysreqpackage";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final String PLATFORMVIASDW = "platformviasdw";
    public FileSystem _fs = new JavaIOFileSystem();
    public static final String MAINTENANCE = "maintenance";
    public static final String VERSION = "version";
    public static final String TWELVE_BYTE = "twelveByte";
    public static final String HOST = "host";
    public static final String MVS_HOST = "mvs";
    public static final String Z64_HOST = "z64";
    public static final int CHECK_CNTL_IN_USE = 1;
    public static final int CHECK_HLQ_USED = 2;
    public static final int CHECK_HLQ = 3;
    public static final int CHECK_SMS = 4;
    public static final int CHECK_SMS_PDSE = 5;
    public static final int CHECK_DISKUNIT = 6;
    public static final int CHECK_TMPUNI = 7;
    public static final int CHECK_VOLDISK = 8;
    protected HashSet<String> analyzedUninstallXMLs = new HashSet();
    protected String _buildFileLocation;
    protected String _chainFilePath;
    public static Properties installProperties;
    public static final String TWELVE_BYTE_CODE = "12ByteCode";
    public static final String PRODUCT = "Product";
    public static final String PRODUCT_NAME = "ProductName";
    public static final String PRODUCT_VERSION = "ProductVersion";
    public static final String CUSTOMER_FACING_VERSION = "CustomerFacingVersion";
    public static final String PRODUCT_LANGUAGE = "ProductLanguage";
    public static final String HOTFIX_VERSION = "HotFixVersion";
    public static final String ALLOW_UNINSTALL = "AllowUninstall";
    public static final String PROVIDE_AUDIT_LOGS = "ProvideAuditLogs";
    public static final String CREATE_BACKUP_LOC = "CreateBackupLoc";
    public static final String MAINTENANCE_VERSION = "MaintVersion";
    public static final String MINIMUM_MAINT_VERSION = "MinimumMaintVersion";
    public static final String MAXIMUM_MAINT_EXCLUSIVE = "MaximumMaintExclusive";
    public static final String MAXIMUM_MAINT_VERSION = "MaximumMaintVersion";
    public static final String ALT_SKU_TYPE = "AltSkuType";
    private static final String LOCALE = "Locale";
    private static final String DISPLAY_LANGUAGE = "ProductDisplayLanguage";
    private static final String SOURCE_LOCATION = "SourceLocation";
    protected volatile boolean _installCancelled = false;
    public static final String INSTALL_XML_OPTION = "-file";
    public static final String PRODUCT_DATA_OPTION = "-productdata";
    public static final String PAYLOAD_OPTION = "-payloadDir";
    public static final String TARGET_OPTION = "-target";
    static final String PACKAGEDIR_OPTION_RE = "(-packageDir)";
    static final String CHAINFILE_OPTION_RE = "(-chain|-chainFile)";
    static final String FILE_OPTION_RE = "(-f|-buildfile|-file)";
    public static final String SASRELEASE = "9.4";
    public static final String SASFOUNDATION;
    public static final String DEPOT_LOCATION = "DepotLocation";
    public static final String PRODUCT_XML = "product.xml";
    public static final String INSTALL_XML = "install.xml";
    public static final String DEPLOYMENT_XML = "deployment.xml";
    public static final String SETINIT = "setinit.log";
    protected static ExecutionThread _executionThread;
    private static final String UNQUOTED_ARG_RE = "[^\\s]+";
    private static final String QUOTED_ARG_RE = "\\\"[^\\\"]+\\\"";
    private static final String FILE_ARG_RE = "\\\"[^\\\"]+\\\"|[^\\s]+";
    private final ProcessingQueue postProcessingQueue = new ProcessingQueue();
    private DeploymentParameters deploymentParameters = null;
    private static final String DATE_FORMAT_NOW = "yyyy-MM-dd-HH.mm.ss";
    private static final Date logDate;
    public static final String INITIAL_INSTALL_LOCATION = "iil";
    public static final String ALT_SKU = "AltSku";
    public static String _selectedPCFSversion;
    protected static Stack<File> dirDeleteOnExit;
    protected static Stack<File> fileDeleteOnExit;
    protected static boolean baseDeleteOnExit;
    public String sharedHomePath;
    private WriteValidationFile writeValidiationInstance;
    private boolean _rollbackSuccessful;
    private Throwable _throwable;

    public static Controller defaultController() {
        return _defaultController;
    }

    File getDefaultLog() {
        String logFormat = "'IT_'yyyy-MM-dd-HH.mm.ss'.log'";
        SimpleDateFormat sdf = new SimpleDateFormat(logFormat);
        return new File(this.getLogPath(), sdf.format(logDate));
    }

    File getDefaultNotificationLog() {
        String filelistLogFormat = "'IT_'yyyy-MM-dd-HH.mm.ss'_filelist.log'";
        SimpleDateFormat sdf = new SimpleDateFormat(filelistLogFormat);
        return new File(this.getLogPath(), sdf.format(logDate));
    }

    File getDefaultSetinitLog(String path) {
        String setinitLogFormat = "'setinit_'yyyy-MM-dd-HH.mm.ss'.log'";
        SimpleDateFormat sdf = new SimpleDateFormat(setinitLogFormat);
        if (TaskHelper.isWindows()) {
            return new File(path, SETINIT);
        }
        return new File(path, sdf.format(logDate));
    }

    public String getITLog() {
        return this.getDefaultLog().getPath();
    }

    public String getSetinitLog() {
        if (TaskHelper.isWindows()) {
            return this.getDefaultSetinitLog(installProperties.getProperty("base.home")).getPath();
        }
        return this.getDefaultSetinitLog(installProperties.getProperty("base.home") + "/install/admin/logs/").getPath();
    }

    public InstallationContext getCurrentContext() {
        if (this.getAltSku() == null) {
            return null;
        }
        return this.getInstallContexts().get(this.getAltSku());
    }

    public void reset() {
        this.setChainFile(null);
        this.setAlwaysOverwrite(false);
        this.setChainFilePath(null);
        this.setLanguageCheckSkipped(false);
        this.setProductVersionCheckingBypassed(false);
        this.setMaintenanceVersionCheckingSkipped(false);
        try {
            this.setViewClassname(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInstallFile(null);
        this.setChainfileLines(new Vector<String>());
        this.setAltSkus(new Vector<String>());
        ExtractVJRContentTask.reset();
    }

    public void clearController() {
        _defaultController = null;
    }

    public void resetMvsextractTask() {
        MvsextractTask.reset();
    }

    public Controller() {
        _defaultController = this;
        this.setBundle(new SSNResource(Controller.class));
        this.setEnBundle(SSNResource.EnglishResource(Controller.class));
        this.reset();
    }

    public Controller(DeploymentParameters deploymentParameters) {
        this();
        this.deploymentParameters = deploymentParameters;
    }

    public Controller(String[] args) throws Exception {
        this(args, true);
    }

    public Controller(String[] args, boolean automaticallyExecute) throws Exception {
        this();
        this.setupInstallationForArgs(args);
        if (silent && automaticallyExecute) {
            this.runInstallation();
        }
    }

    public int runPreExecute() {
        int numBuildFiles = this.getAltSkus().size();
        try {
            for (int i = 0; i < numBuildFiles; ++i) {
                this.switchToAltSkuAtIndex(i);
                String allowUninstall = this.getProperty(ALLOW_UNINSTALL);
                if (uninstall_mode && allowUninstall != null && allowUninstall.equalsIgnoreCase(FALSE) || this.getCurrentContext().getUninstallableReason() != null || this.preExecute()) continue;
                return -1;
            }
        }
        catch (Exception e) {
            Controller.logStackTrace(e);
            return -1;
        }
        return 0;
    }

    public int runInstallation() {
        return this.runInstallation(null);
    }

    public int runInstallation(String bitnessPCFS) {
        try {
            _selectedPCFSversion = bitnessPCFS;
            Controller.setExecutionThread(new ExecutionThread(this, null));
            Controller.getExecutionThread().start();
            Controller.getExecutionThread().join();
            if (Controller.getExecutionThread().isRollbackFailed()) {
                Controller.setExecutionThread(null);
                return -4;
            }
            if (Controller.getExecutionThread().isRolledBack()) {
                Controller.setExecutionThread(null);
                return -3;
            }
            if (Controller.getExecutionThread().isWarning()) {
                Controller.setExecutionThread(null);
                return 5;
            }
            Controller.setExecutionThread(null);
            return 0;
        }
        catch (Exception e) {
            Controller.logStackTrace(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupInstallationForArgs(String[] args) throws Exception {
        this.reset();
        if (this.getLogPath() == null) {
            this.setLogPath(new File(this.getProperty("SASHome"), DEFAULT_LOG_PATH));
        }
        if (!this.getLogPath().exists()) {
            this.getLogPath().mkdirs();
        }
        this.configureLogging(args);
        this.setProperty(SOURCE_LOCATION, this.getFS().getParent(this.getInstallAppLocation()));
        this.configure(args);
        if (this.getViewClassname() == null && !silent) {
            log.info("View class not specified.");
            this.setViewClassname("com.sas.tools.installs.it.view.SwingView");
            log.info("Defaulting to SwingView because we are not in silent mode");
        }
        if (silent) {
            this.setViewClassname("com.sas.tools.installs.it.view.HeadlessView");
            log.warn("Defaulting to HeadlessView because we are in silent mode");
        }
        this.setSASController(new SASController(this));
        this.getSASController().initialize();
        log.info("Location of loaded sas.tools.installs.it.jar: " + this.getInstallAppLocation());
        log.info("Software Version(sas.tools.installs.it.jar): " + this.getToolVersion());
        BufferedWriter out = null;
        String hotfixID = null;
        String uninstallXML = null;
        if (this.uninstallExists()) {
            try {
                if (this.getChainFile() != null) {
                    LinkedHashMap<String, String> refs = this.referencedHotfixIDs(this.getChainFilePath(), this.getPackageDir());
                    hotfixID = (String)refs.keySet().toArray()[0];
                    uninstallXML = refs.get(hotfixID);
                } else {
                    hotfixID = this.referencedHotfixID(this.getBuildFileLocation());
                    uninstallXML = this.getBuildFileLocation();
                }
                Vector<String> prereqs = this.getPrerequisiteUninstalls(hotfixID, uninstallXML);
                if (prereqs.size() > 0) {
                    this.setChainfileLines(prereqs);
                    File newChain = new File(this.getPackageDir(), "prereqChain.xml");
                    out = new BufferedWriter(new FileWriter(newChain));
                    for (String uninstallLine : this.getChainfileLines()) {
                        out.write(uninstallLine + System.getProperty("line.separator"));
                    }
                    this.setChainFile(newChain);
                }
            }
            catch (UninstallsDisabledException prereqs) {
            }
            catch (Exception e) {
                this.getView().improperConfiguration(this.getBundle().messageString("Controller.UninstallDeterminationError"), e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        if (this.getChainFile() != null) {
            if (this.getChainfileLines().size() == 0) {
                Object inFile = null;
                BufferedReader in = null;
                log.info("processing chain file:  " + this.getChainFile());
                try {
                    inFile = new FileReader(this.getChainFile());
                    in = new BufferedReader((Reader)inFile);
                    String line = "";
                    while (in.ready()) {
                        line = in.readLine();
                        while (line != null && line.length() > 0) {
                            this.getChainfileLines().add(line);
                            line = in.readLine();
                        }
                    }
                }
                finally {
                    in.close();
                    ((InputStreamReader)inFile).close();
                }
            }
            for (String line : this.getChainfileLines()) {
                File buildFile = new File(line);
                if (!buildFile.isFile() && this.getPackageDir() != null) {
                    buildFile = new File(this.getPackageDir(), line);
                }
                if (!buildFile.isFile()) {
                    throw new ConfigurationException("Build file specified in chain file (" + buildFile + ") does not exist");
                }
                File parent = buildFile.getParentFile();
                File productFile = new File(parent, PRODUCT_XML);
                if (!productFile.isFile()) {
                    throw new ConfigurationException("Product information file (" + productFile + ") does not exist");
                }
                this.setProductData(productFile.getAbsolutePath());
                log.info("adding alt sku " + this.getAltSku() + " to list of installs to process");
                this.getAltSkus().add(this.getAltSku());
            }
        } else {
            log.info("no chain file specified.  Install will work from the install.xml directly");
            this.getAltSkus().add(this.getProperty(ALT_SKU));
        }
        int numAltSkus = this.getAltSkus().size();
        Vector<String> uninstallLines = new Vector<String>();
        for (int i = 0; i < numAltSkus; ++i) {
            this.initializeInstallAtIndex(i);
            if (this.getCurrentContext().getUninstallableReason() != null || uninstall_mode || this.getBackupRoot() == null || !TRUE.equalsIgnoreCase(this.getProperty(CREATE_BACKUP_LOC))) continue;
            if (this.getCurrentContext().getInstallLanguages().get(i) != null) {
                uninstallLines.add(0, this.getCurrentContext().getInstallLanguages().get(i) + this.getFS().separator() + this.getChainFileEntry());
            } else {
                uninstallLines.add(0, this.getChainFileEntry());
            }
            this.writeBackupChainFile(uninstallLines);
        }
    }

    void configureLogging(String[] args) throws FileNotFoundException, IOException {
        if (!this._loggingConfigured) {
            String logProps = new File(this.getInstallAppLocation(), "log4j.properties").getAbsolutePath();
            if (this.getLogPath() != null && !Arrays.asList(args).contains("-consoleMode")) {
                System.setProperty("logfilename", this.getDefaultLog().getPath());
                System.setProperty("logfilename2", this.getDefaultNotificationLog().getPath());
            }
            LoggerContext ctx = Configurator.initialize(null, logProps);
            ctx.reconfigure();
            this._loggingConfigured = true;
        }
    }

    public Vector<String> getUninstallChainFromInvocation(String originalUninstallInvocation) throws Exception {
        Pattern p = Pattern.compile(".*(\\-chain|\\-chainFile)\\s\\\"*([^-&&[^\\\"]]*).*", 34);
        Matcher m = p.matcher(originalUninstallInvocation);
        Pattern packageDirPattern = Pattern.compile(".*-packageDir\\s\\\"*([^-&&[^\\\"]]*).*", 34);
        Matcher packageDirMatcher = packageDirPattern.matcher(originalUninstallInvocation);
        if (m.matches() && packageDirMatcher.matches()) {
            String chainFile = m.group(2).trim();
            String packageDir = packageDirMatcher.group(1);
            LinkedHashMap<String, String> refs = this.referencedHotfixIDs(chainFile, packageDir);
            String key = (String)refs.keySet().toArray()[0];
            return this.getPrerequisiteUninstalls(key, refs.get(key));
        }
        p = Pattern.compile(".*(\\-f|\\-buildfile|\\-file)\\s\\\"*([^-&&[^\\\"]]*).*", 34);
        m = p.matcher(originalUninstallInvocation);
        if (m.matches() && packageDirMatcher.matches()) {
            String uninstallLine = m.group(2).trim();
            String packageDir = packageDirMatcher.group(1);
            String lineHotfixID = this.referencedHotfixID(uninstallLine);
            String fullPath = new File(packageDir, uninstallLine).getPath();
            return this.getPrerequisiteUninstalls(lineHotfixID, fullPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getPrerequisiteUninstalls(String hotfixID, String uninstallXML) throws Exception, UninstallsDisabledException {
        Vector<String> hfIDs = new Vector<String>();
        Vector<String> installXMLs = new Vector<String>();
        log.info("=============== begin determining prerequisite uninstalls ===============");
        this.getSASController().getAccess().open();
        try {
            this.getPrerequisiteUninstalls(hotfixID, uninstallXML, null, hfIDs, installXMLs, 0, new Vector<String>());
        }
        finally {
            this.getSASController().getAccess().close();
        }
        log.info("===============  end determining prerequisite uninstalls  ===============");
        return installXMLs;
    }

    public void getPrerequisiteUninstalls(String hotfixID, String uninstallXML, HashMap<String, HashMap<String, String>> hotfixProperties, Vector<String> hfIDs, Vector<String> installXMLs, int level, Vector<String> visitedChains) throws Exception, UninstallsDisabledException {
        StringBuffer indentionBuffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            indentionBuffer.append("\t");
        }
        String indent = indentionBuffer.toString();
        ++level;
        if (hotfixProperties == null) {
            hotfixProperties = this.hotfixProperties();
        }
        log.info(indent + "processing hot fix " + hotfixID);
        Vector<String> removableHotfixes = this.getSASController().getRemovableHotfixes(hotfixID, hotfixProperties.get(hotfixID).get(TWELVE_BYTE), hotfixProperties.get(hotfixID).get(VERSION), hotfixProperties.get(hotfixID).get(HOST));
        if (removableHotfixes.size() < 2) {
            log.info(indent + hotfixID + " has no newer hotfixes");
            this.getUninstallDataUninstalls(hotfixID, uninstallXML, hotfixProperties, hfIDs, installXMLs, level, visitedChains, removableHotfixes.size() == 0);
        } else {
            Collections.reverse(removableHotfixes);
            log.info(indent + "Processing newer hotfixes for " + hotfixID);
            for (String removableHotfix : removableHotfixes) {
                if (hfIDs.contains(removableHotfix)) continue;
                if (removableHotfix.equals(hotfixID)) {
                    log.info(indent + " Almost done!  Just need to process the chain!");
                    this.getUninstallDataUninstalls(hotfixID, null, hotfixProperties, hfIDs, installXMLs, level, visitedChains, removableHotfixes.size() == 0);
                    return;
                }
                this.getPrerequisiteUninstalls(removableHotfix, null, hotfixProperties, hfIDs, installXMLs, level, visitedChains);
            }
        }
    }

    public void getUninstallDataUninstalls(String hotfixID, String uninstallXML, HashMap<String, HashMap<String, String>> hotfixProperties, Vector<String> hfIDs, Vector<String> installXMLs, int level, Vector<String> visitedChains, boolean hotfixIDPreCurrentMaint) throws Exception, UninstallsDisabledException {
        StringBuffer indentionBuffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            indentionBuffer.append("\t");
        }
        String indent = indentionBuffer.toString();
        String invocation = this.getSASController().uninstallStringForHotfix(hotfixID);
        if (invocation == null) {
            log.info("Missing data for required uninstall dependency.  Hotfix ID:  " + hotfixID);
            throw new Exception(this.getBundle().messageString("Controller.MissingUninstall", hotfixID));
        }
        String packageDir = this.getUninstallOption(invocation, PACKAGEDIR_OPTION_RE);
        String chainFile = this.getUninstallOption(invocation, CHAINFILE_OPTION_RE);
        if (chainFile != null && packageDir != null) {
            if (visitedChains.contains(chainFile)) {
                if (!hotfixIDPreCurrentMaint) {
                    HashMap<String, String> uninstallXMLProperties;
                    String allowUninstall;
                    if (uninstallXML == null) {
                        uninstallXML = this.referencedHotfixIDs(chainFile, packageDir).get(hotfixID);
                    }
                    if ((allowUninstall = (uninstallXMLProperties = this.propertiesForBuildFile(uninstallXML)).get(ALLOW_UNINSTALL)).equalsIgnoreCase(FALSE)) {
                        throw new UninstallsDisabledException();
                    }
                    hfIDs.add(hotfixID);
                    installXMLs.add(uninstallXML);
                }
                return;
            }
            visitedChains.add(chainFile);
            log.info(indent + "processing " + hotfixID + " chain reference:  " + chainFile);
            InputStream is = this.getFS().getInputStream(chainFile);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String line = null;
            String lineFile = null;
            while (in.ready()) {
                line = in.readLine();
                lineFile = new File(packageDir, line).getPath();
                String lineHotfixID = this.referencedHotfixID(lineFile);
                if (hotfixIDPreCurrentMaint && hotfixID.equals(lineHotfixID)) {
                    log.info(indent + "even though " + hotfixID + " is in the path of hotfixes to remove, we will not remove it because a newer maintenance version has been applied to its product");
                    continue;
                }
                if (installXMLs.contains(lineFile)) continue;
                if (lineHotfixID.equals(hotfixID)) {
                    HashMap<String, String> uninstallXMLProperties = this.propertiesForBuildFile(lineFile);
                    String allowUninstall = uninstallXMLProperties.get(ALLOW_UNINSTALL);
                    if (allowUninstall.equalsIgnoreCase(FALSE)) {
                        throw new UninstallsDisabledException();
                    }
                    log.info(indent + "adding " + lineHotfixID + " uninstall line to returned values");
                    hfIDs.add(lineHotfixID);
                    installXMLs.add(lineFile);
                    continue;
                }
                this.getPrerequisiteUninstalls(lineHotfixID, lineFile, hotfixProperties, hfIDs, installXMLs, level, visitedChains);
            }
        } else {
            String uninstallLine = this.getUninstallOption(invocation, FILE_OPTION_RE);
            if (uninstallLine != null && packageDir != null) {
                String lineHotfixID = this.referencedHotfixID(uninstallLine);
                if (hotfixIDPreCurrentMaint) {
                    log.info(indent + "even though " + hotfixID + " is in the path of hotfixes to remove, we will not remove it because a newer maintenance version has been applied to its product");
                    return;
                }
                HashMap<String, String> uninstallXMLProperties = this.propertiesForBuildFile(uninstallLine);
                String allowUninstall = uninstallXMLProperties.get(ALLOW_UNINSTALL);
                if (allowUninstall.equalsIgnoreCase(FALSE)) {
                    throw new UninstallsDisabledException();
                }
                log.info(indent + "adding " + uninstallLine + " uninstall line to returned values");
                hfIDs.add(lineHotfixID);
                installXMLs.add(uninstallLine);
            }
        }
    }

    String getUninstallOption(String invocation, String option_re) {
        String re = ".*" + option_re + "\\s+(" + FILE_ARG_RE + ").*";
        Pattern p = Pattern.compile(re, 34);
        Matcher m = p.matcher(invocation);
        String option = null;
        if (m.matches()) {
            option = this.fixArgumentString(m.group(2));
        }
        return option;
    }

    private String fixArgumentString(String argument) {
        if (argument != null && (argument = argument.trim()).startsWith("\"")) {
            argument = argument.replace("\"", "");
        }
        return argument;
    }

    public HashMap<String, HashMap<String, String>> hotfixProperties() throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(this.getSASController().getUninstallXML());
        String xpathString = "//hotfix";
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList hotfixes = null;
        hotfixes = (NodeList)xPath.evaluate(xpathString, document, XPathConstants.NODESET);
        HashMap<String, HashMap<String, String>> retval = new HashMap<String, HashMap<String, String>>();
        HashMap<String, String> properties = null;
        for (int i = 0; i < hotfixes.getLength(); ++i) {
            properties = new HashMap<String, String>();
            Element hotfixTag = (Element)hotfixes.item(i);
            Element maintenanceLevelTag = (Element)hotfixTag.getParentNode();
            Element versionTag = (Element)maintenanceLevelTag.getParentNode();
            Element productTag = (Element)versionTag.getParentNode();
            Element hostTag = (Element)productTag.getParentNode();
            properties.put(MAINTENANCE, maintenanceLevelTag.getAttribute("id"));
            properties.put(VERSION, versionTag.getAttribute("id"));
            properties.put(TWELVE_BYTE, productTag.getAttribute(TWELVE_BYTE));
            properties.put(HOST, hostTag.getAttribute("id"));
            retval.put(hotfixTag.getAttribute("id"), properties);
        }
        return retval;
    }

    public String referencedHotfixID(String installXMLPath) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(installXMLPath);
        String xpathString = "//property[@name='HotFixVersion']";
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        Element target = null;
        target = (Element)xPath.evaluate(xpathString, document, XPathConstants.NODE);
        if (target == null) {
            return null;
        }
        return target.getAttribute("value");
    }

    public LinkedHashMap<String, String> referencedHotfixIDs(String chainFile, String packageDir) throws Exception {
        LinkedHashMap<String, String> retval = new LinkedHashMap<String, String>();
        log.info("looking up referenced hotfixIDs for chain " + chainFile);
        InputStream is = this.getFS().getInputStream(chainFile);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while (in.ready()) {
            line = packageDir + File.separator + in.readLine();
            while (line != null && line.length() > 0) {
                String hotfixID = this.referencedHotfixID(line);
                if (hotfixID != null) {
                    retval.put(hotfixID, line);
                }
                if ((line = in.readLine()) == null || line.length() <= 0) continue;
                line = packageDir + File.separator + line;
            }
        }
        return retval;
    }

    public boolean uninstallExists() throws Exception {
        String uninstallValue;
        String buildLocation = null;
        if (this.getChainFilePath() != null) {
            InputStream is = this.getFS().getInputStream(this.getChainFilePath());
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            buildLocation = in.readLine();
        } else {
            buildLocation = this.getBuildFileLocation();
        }
        String fullBuildLocation = buildLocation;
        if (!new File(fullBuildLocation).exists() && this.getPackageDir() != null) {
            fullBuildLocation = new File(this.getPackageDir(), buildLocation).getPath();
        }
        if ((uninstallValue = this.propertiesForBuildFile(fullBuildLocation).get(UNINSTALL)) == null) {
            return false;
        }
        return uninstallValue.equalsIgnoreCase(TRUE);
    }

    public HashMap<String, String> propertiesForBuildFile(String buildFilePath) throws Exception {
        HashMap<String, String> retval = new HashMap<String, String>();
        return retval;
    }

    public String getProperty(String key) {
        return this.getProperty(this.getAltSku(), key);
    }

    public String getProperty(String altSku, String key) {
        String value;
        Map<String, String> propertyHelper = this.getPropertyHelpers().get(altSku);
        if (propertyHelper == null) {
            propertyHelper = new HashMap<String, String>();
            this.getPropertyHelpers().put(altSku, propertyHelper);
        }
        if ((value = propertyHelper.get(key.toLowerCase())) == null && (propertyHelper = this.getPropertyHelpers().get(null)) != null) {
            value = propertyHelper.get(key.toLowerCase());
        }
        if (value == null && key.startsWith("install_")) {
            key = key.toLowerCase().replaceFirst("^install_", "");
            value = installProperties.getProperty(key);
        }
        if (value == null && key.startsWith("system_")) {
            key = key.replaceFirst("^system_", "");
            value = System.getenv().get(key);
        }
        if (value == null && key.startsWith("java_")) {
            key = key.toLowerCase().replaceFirst("^java_", "");
            value = System.getProperty(key);
        }
        if (value == null && key.startsWith("string_")) {
            key = key.replaceFirst("^string_", "");
            value = this.getBundle().messageString(key);
            if (value.contains(PRODUCT_VERSION)) {
                value = value.replace("${ProductVersion}", this.getProperty(PRODUCT_VERSION));
            }
        }
        if (value == null && key.startsWith("home_")) {
            DeploymentPackage pkg;
            key = key.replaceFirst("^home_", "");
            value = this.getProductHomeInfo().get(key.concat("Home"));
            if (value == null && this.deploymentParameters != null && (pkg = this.deploymentParameters.getProductPackage(key)) != null) {
                value = pkg.getDestination();
            }
            if (value == null) {
                log.warn("Destination for " + key + " not found");
            }
        }
        if (value == null && key.startsWith("jmp_")) {
            value = System.getProperty("os.name").contains("Windows XP") ? this.getFS().append(System.getenv().get("ALLUSERSPROFILE"), "Application Data") : System.getenv().get("ALLUSERSPROFILE");
        }
        return value;
    }

    public void setPropertyForAltSku(String key, String value, String altSku) {
        Map<String, String> propertyHelper = this.getPropertyHelpers().get(altSku);
        if (propertyHelper == null) {
            propertyHelper = new HashMap<String, String>();
            this.getPropertyHelpers().put(altSku, propertyHelper);
        }
        propertyHelper.put(key.toLowerCase(), value);
    }

    public void setProperty(String key, String value) {
        this.setPropertyForAltSku(key, value, this.getAltSku());
    }

    public HashMap<String, String> getProductHomeInfo() {
        return _productHomeInfo;
    }

    public void initializeInstallAtIndex(int index) throws Exception {
        this.setAltSku(this.getAltSkus().get(index));
        File installFile = new File(this.getProperty(INITIAL_INSTALL_LOCATION));
        log.info("initializing install file:  " + installFile);
        this.setInstallFile(installFile);
        if (this.getChainfileLines().size() > 0 && index <= this.getChainfileLines().size()) {
            this.setChainFileEntry(this.getChainfileLines().get(index));
        }
        this.setDeploymentData();
        if (!_productHomeInfo.containsKey(this.buildHostHomeKey())) {
            if (this.isHostMVS()) {
                _productHomeInfo.put(this.buildHostHomeKey(), this.getProperty("zos.high.level.qualifier"));
            } else if (this.isHostZ64()) {
                _productHomeInfo.put(this.buildHostHomeKey(), this.getProperty("z64.high.level.qualifier"));
            }
        }
        Object language = null;
        this.setProperty("SASHome", System.getProperty("SASHome"));
        this.getCurrentContext().getInstallLanguages().add((String)language);
        if ((MVS_HOST.equalsIgnoreCase(this.getHost()) || Z64_HOST.equalsIgnoreCase(this.getHost())) && this.getProperty("HostMultiPlatform") == null) {
            this.setProperty(PROVIDE_AUDIT_LOGS, FALSE);
            this.setProperty(CREATE_BACKUP_LOC, FALSE);
        } else {
            this.setProperty(PROVIDE_AUDIT_LOGS, TRUE);
            this.setProperty(CREATE_BACKUP_LOC, TRUE);
        }
        if (this.getProperty(PRODUCT_NAME) == null) {
            this.getView().improperConfiguration(this._bundle.messageString("Controller.MissingProductName"), null);
        }
        if (this.getProperty(PRODUCT_VERSION) == null) {
            this.getView().improperConfiguration(this._bundle.messageString("Controller.MissingProductVersion"), null);
        }
        if (this.getHost() == null) {
            this.getView().improperConfiguration(this._bundle.messageString("Controller.MissingHost"), null);
        }
        if (this.getProperty("uninstallProvided") != null && this.getProperty("uninstallProvided").equalsIgnoreCase(TRUE)) {
            this.setProperty("uninstallProvided", TRUE);
        }
        this.switchToAltSkuAtIndex(index);
        if (this.getSASController().preExecute(index)) {
            String allowUninstall = this.getProperty(ALLOW_UNINSTALL);
            if (uninstall_mode && allowUninstall != null && allowUninstall.equalsIgnoreCase(FALSE)) {
                log.info("skipping " + installFile + " because uninstall isn't allowed");
                this.getCurrentContext().setUninstallableReason(this.getBundle().messageString("Controller.RemovalNotAllowed"));
                return;
            }
            if (this.getProductHome() != null) {
                String productHome = this.getFS().getAbsolutePath(this.getProductHome());
                this.setProperty("BackupRoot", this.getFS().append(productHome, "installs", this.getPackageIdentifier()));
            } else {
                this.setProperty("ProductHome", System.getProperty("SASHome") + File.separator + this.getProperty(TWELVE_BYTE_CODE));
                this.setProperty("BackupRoot", this.getFS().append(this.getProductHome(), ".backup", this.getPackageIdentifier()));
            }
            this.loadInstall();
            if (!this.someTaskApplies()) {
                this.getCurrentContext().setUninstallableReason(this.getBundle().messageString("Controller.WrongHost"));
                return;
            }
            String pal = this.getProperty(PROVIDE_AUDIT_LOGS);
            if (pal != null && pal.equalsIgnoreCase(TRUE)) {
                this.getCurrentContext().setAuditLogger(new AuditLogger(this));
                this.getCurrentContext().addSetupListener(this.getAuditLogger());
                this.getCurrentContext().addProgressListener(this.getAuditLogger());
            }
            this.initializePlugins();
            this.getAllInstallAltskus().add(this.getAltSku());
            log.info(installFile + " initializion complete");
        }
    }

    public AuditLogger getAuditLogger() {
        return this.getCurrentContext().getAuditLogger();
    }

    public NotificationHandler getNotifier() {
        return NotificationHandler.defaultHandler();
    }

    public boolean isRegistryUpdateByScript() {
        return this.isZosHost() && this.getProperty("HostMultiPlatform") == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int postProcess() {
        try {
            ProcessingTask task;
            int retval = 0;
            String src = Utils.joinPath(this.getInstallAppLocation(), "sas.java.ext.config");
            String dest = Utils.joinPath(System.getProperty("SASHome"), "sas.java.ext.config");
            log.info("copying " + src + " to " + dest);
            this.getFS().copyFile(src, dest);
            log.info("Post processing across alt-skus: " + this.getPostProcessingQueue());
            while ((task = this.getPostProcessingQueue().poll()) != null) {
                if (task.getInstance() instanceof InstallationTask) {
                    InstallationTask installTask = (InstallationTask)task.getInstance();
                    this.setAltSku(installTask.getAltsku());
                }
                if ((retval = task.invoke()) == 0) continue;
                log.info("returning " + retval + " since post-processing task had non-zero return status");
                int n = retval;
                return n;
            }
            log.info("Multi-alt-sku post processing complete.  Updating deployment registry with new maintenance levels");
            for (String altSku : this.getAllInstallAltskus()) {
                log.info("switching context to " + altSku);
                this.setAltSku(altSku);
                this.getCurrentContext().serializeUninstallMetadata((List<InstallationTask>)this.getInstallTasksPerAltSku().get(this.getAltSku()));
            }
            log.info("all installs complete.  Returning 0");
            int n = 0;
            return n;
        }
        catch (Exception e) {
            Controller.logStackTrace(e);
            int n = -1;
            return n;
        }
        finally {
            LogManager.shutdown();
        }
    }

    public void copyITLogFileToSDWPath() {
        try {
            LogManager.shutdown();
            if (this.isUninstall()) {
                File itUninstallLogFile = new File(this.getDefaultLog().getPath());
                String itUninstallLogFileName = this.appendTaskNameInLogFileName(itUninstallLogFile.getName(), false);
                File sdwUninstallLogPath = new File(installProperties.getProperty("sdw.log.path"));
                if (!sdwUninstallLogPath.isDirectory()) {
                    sdwUninstallLogPath.mkdir();
                }
                File itUninstallLogFileinSDW = new File(sdwUninstallLogPath, itUninstallLogFileName);
                this.getFS().copyFile(itUninstallLogFile, itUninstallLogFileinSDW);
            } else {
                File itLogFile = new File(this.getDefaultLog().getPath());
                String itLogFileName = this.appendTaskNameInLogFileName(itLogFile.getName(), true);
                File sdwInstallLogPath = new File(installProperties.getProperty("sdw.log.path"));
                if (!sdwInstallLogPath.isDirectory()) {
                    sdwInstallLogPath.mkdir();
                }
                File itLogFileinSDW = new File(sdwInstallLogPath, itLogFileName);
                this.getFS().copyFile(itLogFile, itLogFileinSDW);
            }
        }
        catch (Exception e) {
            Controller.logStackTrace(e);
        }
    }

    public ProcessingQueue getPostProcessingQueue() {
        return this.postProcessingQueue;
    }

    public String interpretHost(String hostValueInInstallFile) {
        if (!hostValueInInstallFile.equalsIgnoreCase("PRT")) {
            if (hostValueInInstallFile.equalsIgnoreCase("W32")) {
                return "win";
            }
            return hostValueInInstallFile.toLowerCase();
        }
        return TaskHelper.getOS_Suffix();
    }

    public void switchToAltSkuAtIndex(int index) throws Exception {
        this.setAltSku(this.getAltSkus().get(index));
    }

    public static void setInstallProperties(Properties properties) {
        if (TaskHelper.getOS() == 8) {
            MvsextractTask.setInstallProperties(properties);
        }
        installProperties = properties;
    }

    public boolean isChainedInstall() {
        return this.getChainFile() != null;
    }

    public String getInstallLocation() {
        if (MVS_HOST.equalsIgnoreCase(this.getHost()) && this.getProperty("HostMultiPlatform") == null) {
            return MvsextractTask.installProperties.getProperty("zos.high.level.qualifier");
        }
        if (Z64_HOST.equalsIgnoreCase(this.getHost()) && this.getProperty("HostMultiPlatform") == null) {
            String loc = MvsextractTask.installProperties.getProperty("z64.high.level.qualifier");
            if (loc == null) {
                loc = MvsextractTask.installProperties.getProperty("zos.high.level.qualifier");
            }
            return loc;
        }
        return this.getProductHome();
    }

    public boolean isHotfix() {
        return this.getProperty(HOTFIX_VERSION) != null;
    }

    public boolean isMaintenance() {
        boolean isMaint;
        boolean bl = isMaint = !this.isHotfix();
        if (isMaint) {
            isMaint = Integer.parseInt(this.getProperty(MAINTENANCE_VERSION)) > 0;
        }
        return isMaint;
    }

    public boolean isUninstall() {
        return TRUE.equals(this.getProperty(UNINSTALL));
    }

    public boolean isSrwonly() {
        return TRUE.equalsIgnoreCase(installProperties.getProperty(SRWONLY));
    }

    public String getBackupRootDirectory() {
        if (this.getProperty(PRODUCT_LANGUAGE) != null) {
            return this.getFS().append(this.getBackupRoot(), "SASHome", this.getProperty(PRODUCT_LANGUAGE));
        }
        return this.getFS().append(this.getBackupRoot(), "SASHome");
    }

    public String getBackupDestination(String location, boolean createParents) {
        String retval = null;
        String canonicalLocation = null;
        String canonicalSASHome = null;
        try {
            canonicalLocation = this.getFS().getCanonicalPath(location);
            canonicalSASHome = this.getFS().getCanonicalPath(System.getProperty("SASHome"));
        }
        catch (Exception e) {
            throw new InstallException(1, null, this.getBundle().messageString("Controller.BackupCreationFailure", location), "Failure determining backup destination " + location, e);
        }
        if (canonicalLocation.indexOf(canonicalSASHome) == 0) {
            String postfix = canonicalLocation.substring(canonicalSASHome.length(), canonicalLocation.length());
            if (postfix.startsWith("/") || postfix.startsWith("\\")) {
                postfix = postfix.substring(1, postfix.length());
            }
            retval = this.getProperty(PRODUCT_LANGUAGE) != null ? this.getFS().append(this.getBackupRoot(), "SASHome", this.getProperty(PRODUCT_LANGUAGE), postfix) : this.getFS().append(this.getBackupRoot(), "SASHome", postfix);
        } else if (location.matches("^[a-zA-Z]:\\\\.*")) {
            retval = this.getProperty(PRODUCT_LANGUAGE) != null ? this.getFS().append(this.getBackupRoot(), "drive_" + location.substring(0, 1), this.getProperty(PRODUCT_LANGUAGE), location.substring(3, location.length())) : this.getFS().append(this.getBackupRoot(), "drive_" + location.substring(0, 1), location.substring(3, location.length()));
        } else {
            String postfix = location;
            if (postfix.startsWith("/") || postfix.startsWith("\\")) {
                postfix = postfix.substring(1, postfix.length());
            }
            retval = this.getProperty(PRODUCT_LANGUAGE) != null ? this.getFS().append(this.getBackupRoot(), this.getProperty(PRODUCT_LANGUAGE), postfix) : this.getFS().append(this.getBackupRoot(), postfix);
        }
        if (createParents && !this.getFS().exists(retval) && createParents && (this.getFS().isDirectory(location) ? !this.getFS().mkdirs(retval) : !this.getFS().exists(this.getFS().getParent(retval)) && !this.getFS().mkdirs(this.getFS().getParent(retval)))) {
            throw new InstallException(1, null, this.getBundle().messageString("Controller.BackupCreationFailure", retval), "Failure creating backup directory at " + retval, null);
        }
        return retval;
    }

    public String metadataBackupDirectory() {
        String chainFileEntry;
        String uninstallData = null;
        String metadataPath = this.getFS().append(this.getBackupRoot(), "Metadata");
        if (this.getProperty(PRODUCT_LANGUAGE) != null) {
            uninstallData = this.getFS().append(metadataPath, this.getProperty(PRODUCT_LANGUAGE));
        }
        if ((chainFileEntry = this.getChainFileEntry()) != null) {
            uninstallData = new File(chainFileEntry).exists() ? this.getFS().getParent(chainFileEntry) : this.getFS().getParent(this.getFS().append(metadataPath, this.getChainFileEntry()));
            if (!this.getFS().exists(uninstallData) && !this.getFS().mkdirs(uninstallData)) {
                throw new InstallException(1, null, this.getBundle().messageString("Controller.DirectoryCreationError", uninstallData), "Error creating directory:  " + uninstallData, null);
            }
        }
        return uninstallData;
    }

    public void setupBackup(String chainFileLine) throws Exception {
        if (FALSE.equalsIgnoreCase(this.getProperty(CREATE_BACKUP_LOC))) {
            return;
        }
        String backupFile = this.getFS().getAbsolutePath(this.getBackupRoot());
        String language = this.getProperty(PRODUCT_LANGUAGE);
        if (this.isHotfix()) {
            String backupSASHome = this.getFS().append(backupFile, "SASHome", language);
            if (!this.getFS().isDirectory(backupSASHome) && !this.getFS().mkdirs(backupSASHome)) {
                this.getView().setupFailure(this._bundle.messageString("Controller.BackupCreationFailure"), null);
            }
            log.info("Created backup directory for files located within SAS Home:  " + backupSASHome);
        }
        String backupMetadata = this.getFS().append(backupFile, "Metadata", language);
        if (!this.getFS().isDirectory(backupMetadata) && !this.getFS().mkdirs(backupMetadata)) {
            this.getView().setupFailure(this._bundle.messageString("Controller.BackupCreationFailure"), null);
        }
        log.info("Created backup directory for install metadata:  " + backupMetadata);
        String backup = new String(backupMetadata);
        if (chainFileLine == null) {
            Vector<String> dirComponents = new Vector<String>(Arrays.asList(this.getBuildFileLocation().split("/|\\\\")));
            backup = this.getFS().append(backup, dirComponents.get(dirComponents.size() - 1));
        } else {
            backup = this.getFS().append(backup, chainFileLine);
            String parent = this.getFS().getParent(backup);
            if (!this.getFS().isDirectory(parent) && !this.getFS().mkdirs(parent)) {
                throw new InstallException(1, null, this.getBundle().messageString("Controller.UninstallSetupError"), "Error setting up uninstall tooling", null);
            }
        }
        log.info("copying " + this.getInstallFile().getAbsolutePath() + " to " + backupMetadata);
        File uninstallMetadata = new File(backup);
        this.getCurrentContext().setUninstallMetadata(uninstallMetadata);
        this.getFS().copyFile(this.getInstallFile(), uninstallMetadata);
        if (this.getProductDataPath() != null) {
            backup = this.getFS().append(backupMetadata, new File(this.getProductDataPath()).getName());
            log.info("copying " + this.getProductDataPath() + " to " + backup);
            this.getFS().copyFile(this.getProductDataPath(), backup);
        }
        backup = this.getFS().append(backupMetadata, new File(this.getDeploymentDataPath()).getName());
        log.info("Marshalling deployment.xml to " + backup);
        FileWriter fw = new FileWriter(backup);
        SchemaUtils.marshalDeploymentXml(this.getCurrentContext().getDeployment(), fw);
        fw.close();
        String destination = null;
        String docBackupDir = null;
        if (chainFileLine == null) {
            docBackupDir = new String(backupMetadata);
        } else {
            String chainFilePath = new File(chainFileLine).getParent();
            docBackupDir = this.getFS().append(backupFile, chainFilePath, "Metadata", language);
            if (!this.getFS().isDirectory(docBackupDir) && !this.getFS().mkdirs(docBackupDir)) {
                throw new InstallException(1, null, this.getBundle().messageString("Controller.UninstallSetupError"), "Error setting up uninstall tooling.", null);
            }
        }
        String[] docs = this.getFS().getChildren(this.getPackageDir());
        for (int i = 0; i < docs.length; ++i) {
            String packageFile = this.getFS().append(this.getPackageDir(), docs[i]);
            if (this.getFS().isDirectory(packageFile) || !docs[i].startsWith("info") || !docs[i].endsWith(".properties")) continue;
            destination = this.getFS().append(docBackupDir, docs[i]);
            try {
                this.getFS().copyFile(packageFile, destination);
                log.info("Archived package information for uninstallation purposes:  " + destination);
                break;
            }
            catch (Exception e) {
                this.getView().setupFailure(this._bundle.messageString("Controller.MITCopyFailure", packageFile, destination), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCleanupScript(String backupDir) {
        String scriptFile = null;
        String javaLoc = this.getProperty("JREHOME");
        javaLoc = Utils.joinPath(javaLoc, "bin", "java");
        String jarFile = Utils.joinPath(backupDir, "sas.tools.installs.it.jar");
        Writer writer = null;
        String script = null;
        if (TaskHelper.getOS() == 1) {
            scriptFile = Utils.joinPath(backupDir, "cleanup.bat");
            script = "\"" + javaLoc + "\" -cp \"" + jarFile + "\" com.sas.tools.installs.it.cleaner.Cleaner";
        } else if (TaskHelper.isUnix() || TaskHelper.getOS() == 8) {
            scriptFile = Utils.joinPath(backupDir, "cleanup.sh");
            script = javaLoc + " -cp " + jarFile + " com.sas.tools.installs.it.cleaner.Cleaner";
        } else {
            log.info("Cleanup script not supported unless Windows or Unix");
            return;
        }
        try {
            writer = new OutputStreamWriter(this.getFS().getOutputStream(scriptFile));
            writer.write(script);
        }
        catch (IOException e) {
            log.error("Error writing cleanup script: " + scriptFile, (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                log.error("Error closing cleanup script: " + scriptFile, (Throwable)e);
            }
        }
        if (TaskHelper.isUnix() || TaskHelper.getOS() == 8) {
            try {
                DiskInfoAPI.SetOctalFileMode(scriptFile, 755);
            }
            catch (Exception e) {
                log.error("Error changing cleanup script permissions: " + scriptFile, (Throwable)e);
            }
        }
        log.info("Created cleanup script:  " + scriptFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeBackupChainFile(Vector<String> installLines) throws Exception {
        block11: {
            String destinationChainFile;
            block12: {
                if (this.getChainFile() == null) break block11;
                destinationChainFile = this.getFS().append(this.getBackupRoot(), "Metadata", this.getChainFile().getName());
                Writer output = null;
                output = new BufferedWriter(new OutputStreamWriter(this.getFS().getOutputStream(destinationChainFile)));
                for (String line : installLines) {
                    output.write(line + System.getProperty("line.separator"));
                }
                try {
                    output.close();
                }
                catch (IOException e) {
                    log.error("Error moving " + this.getChainFilePath() + " to " + destinationChainFile + " while preserving the install tool data for rollbacks", (Throwable)e);
                    this.getView().setupFailure(this._bundle.messageString("Controller.MITDataCopyFailure", this.getChainFilePath(), destinationChainFile), e);
                }
                break block12;
                catch (IOException e) {
                    try {
                        log.error("Error moving " + this.getChainFilePath() + " to " + destinationChainFile + " while preserving the install tool data for rollbacks", (Throwable)e);
                        this.getView().setupFailure(this._bundle.messageString("Controller.MITDataCopyFailure", this.getChainFilePath(), destinationChainFile), e);
                    }
                    catch (Throwable throwable) {
                        try {
                            output.close();
                        }
                        catch (IOException e2) {
                            log.error("Error moving " + this.getChainFilePath() + " to " + destinationChainFile + " while preserving the install tool data for rollbacks", (Throwable)e2);
                            this.getView().setupFailure(this._bundle.messageString("Controller.MITDataCopyFailure", this.getChainFilePath(), destinationChainFile), e2);
                        }
                        throw throwable;
                    }
                    try {
                        output.close();
                    }
                    catch (IOException e3) {
                        log.error("Error moving " + this.getChainFilePath() + " to " + destinationChainFile + " while preserving the install tool data for rollbacks", (Throwable)e3);
                        this.getView().setupFailure(this._bundle.messageString("Controller.MITDataCopyFailure", this.getChainFilePath(), destinationChainFile), e3);
                    }
                }
            }
            log.info("Archived chain file for uninstallation purposes:  " + destinationChainFile);
        }
    }

    public void configure(String[] args) throws ConfigurationException {
        log.info("Configuring with arguments " + Arrays.asList(args));
        File payloadDir = null;
        File installXML = null;
        String productData = null;
        String sidProperty = null;
        String platformProperty = null;
        String scConsumerProperty = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-chainFile")) {
                try {
                    if (this.getPackageDir() != null) {
                        this.setChainFile(new File(this.getPackageDir(), args[i + 1]));
                    } else {
                        this.setChainFile(new File(args[i + 1]));
                    }
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException("You must specify a filename when using the -chainFile argument");
                }
            }
            if (arg.equalsIgnoreCase("-release")) {
                try {
                    System.setProperty("MajorRelease", args[i + 1]);
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException("You must specify a release value when using the -release argument");
                }
            }
            if (arg.equalsIgnoreCase("-vjrhome")) {
                try {
                    System.setProperty("VJRHome", args[i + 1]);
                    this.setProperty("VJRHome", args[i + 1]);
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException("You must specify a value when using the -vjrhome argument");
                }
            }
            if (arg.equalsIgnoreCase("-chain")) {
                try {
                    this.setChainFile(new File(args[i + 1]));
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException("You must specify a filename when using the -chain argument");
                }
            }
            if (arg.equalsIgnoreCase("-bypassVersionCheck")) {
                this.setProductVersionCheckingBypassed(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-skipVersionCheck")) {
                this.setMaintenanceVersionCheckingSkipped(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-alwaysOverwrite")) {
                this.setAlwaysOverwrite(true);
                this.setMaintenanceVersionCheckingSkipped(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-skipFileVersionCheck")) {
                this.setAlwaysOverwrite(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-skipLanguageCheck")) {
                this.setLanguageCheckSkipped(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-view")) {
                try {
                    this.setViewClassname(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException("You must specify a classname when using the -view argument");
                }
            }
            if (arg.equalsIgnoreCase("-language")) {
                try {
                    language = args[i + 1];
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException("You must specify a value when using the -language argument");
                }
            }
            if (arg.equalsIgnoreCase("-sashome")) {
                try {
                    System.setProperty("SASHome", args[i + 1]);
                    this.setProperty("SASHome", args[i + 1]);
                    ++i;
                    continue;
                }
                catch (Exception e) {
                    throw new ConfigurationException("You must specify a value when using the -SASHome argument");
                }
            }
            if (arg.equalsIgnoreCase(PAYLOAD_OPTION)) {
                try {
                    payloadDir = new File(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ConfigurationException("You must specify a directory when using the -payloadDir argument");
                }
            }
            if (arg.equalsIgnoreCase("-buildfile") || arg.equalsIgnoreCase(INSTALL_XML_OPTION) || arg.equalsIgnoreCase("-f")) {
                try {
                    installXML = new File(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ConfigurationException("You must specify a buildfile when using the -buildfile argument");
                }
            }
            if (arg.equalsIgnoreCase("-sid")) {
                try {
                    sidProperty = args[i + 1];
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ConfigurationException("You must specify the fully qualified path to the license data file when using the -sid argument");
                }
            }
            if (arg.equalsIgnoreCase(PRODUCT_DATA_OPTION)) {
                try {
                    productData = args[i + 1];
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ConfigurationException("You must specify the fully qualified path to the product data (product.xml) when using the -productdata argument");
                }
            }
            if (arg.equalsIgnoreCase(TARGET_OPTION)) {
                try {
                    String argument = args[i + 1];
                    log.info("Using targets " + argument);
                    this.targets = Arrays.asList(argument.split(","));
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ConfigurationException("You must specify the comma separated targets when using the -target argument");
                }
            }
            if (arg.equalsIgnoreCase("-silent")) {
                silent = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-skipusercheck")) {
                skipUserChk = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-skipadmincheck")) {
                skipUserChk = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-consoleMode")) continue;
            if (arg.equalsIgnoreCase("-platform")) {
                try {
                    log.info("platform passed via command line");
                    platformProperty = args[i + 1];
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ConfigurationException("You must specify a platform value when using the -platform argument");
                }
            }
            if (arg.equalsIgnoreCase("-scc")) {
                try {
                    scConsumerProperty = args[i + 1];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ConfigurationException("You must specify a SAS shared component consumer value when using the -sc argument");
                }
            }
            if (!arg.startsWith("-") || args[i + 1] == null || args[i + 1].startsWith("-")) continue;
            System.setProperty(arg.substring(1, arg.length()), args[i + 1]);
            ++i;
        }
        if (installXML != null) {
            if (!installXML.exists()) {
                throw new ConfigurationException("Install file: " + installXML + " does not exist");
            }
        } else if (this.getChainFile() == null) {
            File possibleBuildFile = new File(this.getPackageDir() + "/install.xml");
            if (!possibleBuildFile.exists()) {
                throw new ConfigurationException("Either a build file or a chain file must be specified");
            }
            installXML = possibleBuildFile;
        } else if (!this.getChainFile().exists()) {
            throw new ConfigurationException("The chain file you specified " + this.getChainFile() + " does not exist");
        }
        this.setInstallFile(installXML);
        if (productData != null) {
            this.setProductData(productData);
        } else {
            this.setSolstice(true);
            this.setProductInfo();
        }
        if (this.getInstallContexts().get(this.getAltSku()) == null) {
            this.getInstallContexts().put(this.getAltSku(), new InstallationContext(this));
        }
        if (sidProperty != null) {
            this.setProperty("SID", sidProperty);
        }
        if (platformProperty != null && platformProperty.length() > 0) {
            log.info("Using host value passed via -platform:  " + platformProperty);
            this.setProperty("Host", platformProperty);
            this.setProperty(PLATFORMVIASDW, platformProperty);
        }
        if (scConsumerProperty != null) {
            this.setProperty("SHAREDCOMPONENTCONSUMER", scConsumerProperty);
        }
        this.setProperty(INSTALL_FILENAME, installXML.getName());
        this.setProperty("VJRHome", System.getProperty("VJRHome"));
        if (payloadDir != null) {
            this.getCurrentContext().setPayloadDir(payloadDir);
        }
        log.info("Handling the product data and deployment data.");
        this.setInstallData();
    }

    private void setProductData(String productData) {
        this._prtPackage = false;
        try {
            ProdPkg productPackage = SchemaUtils.unmarshal(new File(productData), ProdPkg.class);
            String altsku = productPackage.getAltSku();
            this.setAltSku(altsku);
            this.setProductDataPath(productData);
            this.setProperty(ALT_SKU, altsku);
            if (this.getInstallFile() == null) {
                throw new InstallException(3, null, this.getBundle().messageString("Controller.InvalidSequencing"), this.getEnBundle().messageString("Controller.InvalidSequencing"), null);
            }
            this.setProperty(INITIAL_INSTALL_LOCATION, this.getInstallFile().getAbsolutePath());
            this.setProperty(TWELVE_BYTE_CODE, productPackage.getSoftwareCode());
            if (productPackage.getAltSku().contains("prt")) {
                log.info("prt package detected");
                this._prtPackage = true;
                this.setProperty(HOST, TaskHelper.getOS_Suffix());
            } else {
                this.setProperty(HOST, productPackage.getProdDefn().getPlat());
            }
            log.info("Setting Host property to: " + this.getHost());
            if (productPackage.getLang().equalsIgnoreCase("xx") && productPackage.getAltSku().contains("prt")) {
                this.setProperty("HostMultiPlatform", "prt");
            }
            this.setProperty(PRODUCT_NAME, productPackage.getProdName().getV());
            this.setProperty(PRODUCT_VERSION, productPackage.getProdVer().getV());
            this.setProperty(CUSTOMER_FACING_VERSION, productPackage.getCustVer().getV());
            this.setProperty(PRODUCT_LANGUAGE, productPackage.getLang());
            this.setProperty(MAINTENANCE_VERSION, productPackage.getMaintLevel());
            this.setProperty(ALT_SKU_TYPE, productPackage.getAltSkuType());
            this.setProperty("VJR", "SASVersionedJarRepository");
            this.setProperty("VJRVersion", productPackage.getSasRelease());
            this.setProperty("MVA_VJRPicklistDir", this.getProperty("VJR") + File.separator + "picklist");
            String language = productPackage.getLang();
            this.setProperty(LOCALE, this.getLocale(language));
            this.setProperty(DISPLAY_LANGUAGE, this.getDisplayLanguage(language));
        }
        catch (JAXBException e) {
            log.error(e.getMessage());
        }
    }

    private void setProductInfo() {
        this.setProperty(ALT_SKU, this.getAltSku());
        this.setProperty(INITIAL_INSTALL_LOCATION, this.getInstallFile().getAbsolutePath());
        log.info("Host property is: " + this.getHost());
        if (this.getProperty(PRODUCT_LANGUAGE).equalsIgnoreCase("xx") && this.getAltSku().contains("prt")) {
            this.setProperty("HostMultiPlatform", "prt");
        }
        this.setProperty("VJR", "SASVersionedJarRepository");
        this.setProperty("MVA_VJRPicklistDir", this.getProperty("VJR") + File.separator + "picklist");
        String language = this.getProperty(PRODUCT_LANGUAGE);
        this.setProperty(LOCALE, this.getLocale(language));
        this.setProperty(DISPLAY_LANGUAGE, this.getDisplayLanguage(language));
    }

    public String getDisplayLanguage(String langCode) {
        if ("XX".equalsIgnoreCase(langCode)) {
            return "";
        }
        if (Utilities.getOS() == 8) {
            Vector<String> encodings = new Vector<String>(Arrays.asList("C0", "F0", "R0", "W0", "W2", "W3", "W5", "W6", "W7", "W8", "W9", "WA", "WB", "WU", "NE"));
            for (String encoding : encodings) {
                if (!encoding.equalsIgnoreCase(langCode)) continue;
                return "";
            }
        }
        String propname = "Common.LangCode" + langCode.toUpperCase() + ".txt";
        String displayLanguage = null;
        try {
            displayLanguage = this.getBundle().messageString(propname);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (displayLanguage == null) {
            displayLanguage = langCode.toUpperCase();
        }
        return displayLanguage;
    }

    private String getLocale(String langCode) {
        String sasLocale = null;
        String sysLocale = this.getSystemLocale();
        HashMap<String, String> locales = new HashMap<String, String>();
        locales.put("en", sysLocale);
        locales.put("ar", "Arabic");
        locales.put("cs", "Czech");
        locales.put("da", "Danish");
        locales.put("nl", "Dutch");
        locales.put("fi", "Finnish");
        locales.put("fr", "French");
        locales.put("fc", "French");
        locales.put("fs", "French");
        locales.put("de", "German");
        locales.put("ds", "German");
        locales.put("el", "Greek");
        locales.put("iw", "Hebrew");
        locales.put("hu", "Hungarian");
        locales.put("it", "Italian");
        locales.put("no", "Norwegian");
        locales.put("pl", "Polish");
        locales.put("pt", "Portuguese");
        locales.put("ru", "Russian");
        locales.put("sk", "Slovak");
        locales.put("sl", "Slovenian");
        locales.put("es", "Spanish");
        locales.put("em", "Spanish");
        locales.put("sv", "Swedish");
        locales.put("th", "Thai");
        locales.put("tr", "Turkish");
        sasLocale = (String)locales.get(langCode.toLowerCase());
        if (sasLocale == null) {
            log.info("Could not find a mapping for language code " + langCode);
            log.info("Defaulting to system locale " + sysLocale);
            sasLocale = sysLocale;
        }
        return sasLocale;
    }

    private String getSystemLocale() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        return "".equals(country) ? language : language + "_" + country;
    }

    private void setHotfixProperties() {
        if (this.isMvsMVAHotfix() && MvsextractTask.installProperties.getProperty("zos.hotfix.included", FALSE).equalsIgnoreCase(TRUE)) {
            if (this.isHostMVS()) {
                this.setProperty("ProductHome", this.getProperty("zos.high.level.qualifier"));
            } else if (this.isHostZ64()) {
                this.setProperty("ProductHome", this.getProperty("z64.high.level.qualifier"));
            } else {
                log.warn("Unable to set ProductHome for MVS MVA Hot fix for " + this.getProperty(TWELVE_BYTE_CODE));
            }
        } else if (this.getSDMApplyHotfixProperty().equals("FALSE")) {
            String destination;
            DeploymentPackage pkg;
            String productHomeForHotFix = _productHomeInfo.get(this.buildHostHomeKey());
            if (this._prtPackage && this.isNullOrEmpty(productHomeForHotFix)) {
                productHomeForHotFix = _productHomeInfo.get(this.buildPropertyHomeKey());
            }
            if (this.isNullOrEmpty(productHomeForHotFix) && (pkg = this.deploymentParameters.getProductPackage(this.getProperty(TWELVE_BYTE_CODE))) != null && (destination = pkg.getDestination()) != null && !destination.equals("")) {
                productHomeForHotFix = destination;
            }
            if (!this.isNullOrEmpty(productHomeForHotFix)) {
                this.setProperty("ProductHome", productHomeForHotFix);
            } else {
                String productHome = this.getSASController().getInstallLocation(true);
                this.setProperty("ProductHome", productHome);
                log.debug(String.format("Setting product home to %s for hot fix", productHome));
            }
        } else {
            this.setProperty("ProductHome", this.getSASController().getInstallLocation(true));
        }
    }

    private void setDeploymentData() {
        boolean destinationFound = false;
        this.setProperty(SYSREQPACKAGE, FALSE);
        this.loadDeploymentDataFile();
        if (this.getDeployment() != null) {
            ItTasks project = this.getDeployment();
            if (project.getFalseSkus() != null) {
                this.setProperty(SYSREQPACKAGE, TRUE);
            }
            if (project.getInstall() != null) {
                com.sas.tools.installs.schema.ittasks.InstallType install = project.getInstall();
                Hotfix hotfix = install.getHotfix();
                if (hotfix != null) {
                    this.setProperty(HOTFIX_VERSION, hotfix.getName());
                    Version hfVersion = hotfix.getVersion();
                    if (hfVersion != null) {
                        if (hfVersion.getMin() != null) {
                            this.setProperty(MINIMUM_MAINT_VERSION, hfVersion.getMin().getValue());
                        }
                        if (hfVersion.getMax() != null) {
                            this.setProperty(MAXIMUM_MAINT_VERSION, hfVersion.getMax().getValue());
                            this.setProperty(MAXIMUM_MAINT_EXCLUSIVE, hfVersion.getMax().isExclusive() + "");
                        }
                    }
                    this.setProperty("SecurityFix", hotfix.getSecurityFix() ? TRUE : FALSE);
                }
                if (this.isHotfix()) {
                    this.setHotfixProperties();
                    destinationFound = true;
                } else if (install.getDestination() != null) {
                    List<DestinationType> destinations = install.getDestination();
                    for (DestinationType destination : destinations) {
                        String prefix;
                        AltskuProperties props;
                        String dest;
                        String platform = destination.getPlatform();
                        String targetHost = destination.getTargethost();
                        if (platform != null && !platform.equals("") && targetHost != null && !targetHost.equals("") && (!platform.equalsIgnoreCase(this.getProperty("Host")) || !targetHost.equalsIgnoreCase(TaskHelper.getOS_Suffix())) || destination == null) continue;
                        if (TaskHelper.getOS() == 1) {
                            this.getSASController().findWindowsSharedFiles();
                            this.setProperty("SHAREDFILES", this.getProperty("SHAREDFILES"));
                            this.setProperty("SHAREDFILES32", this.getProperty("SHAREDFILES32"));
                        }
                        if ((dest = (props = new AltskuProperties(this, this.getAltSku())).resolve(destination.getValue())).equals(destination.getValue())) {
                            if (new File(destination.getValue()).exists()) {
                                prefix = "";
                            } else {
                                String altPrefix;
                                prefix = System.getProperty("SASHome") + "/";
                                DeploymentPackage pkg = this.deploymentParameters.getSkuPackage(this.getAltSku());
                                if (pkg != null && (altPrefix = pkg.getAlternateSASHome()) != null && !altPrefix.equals("")) {
                                    prefix = altPrefix + "/";
                                    log.info("An alternate SAS home is being used to construct the product home path for " + this._altSku + ": " + prefix);
                                }
                            }
                        } else {
                            prefix = "";
                            destination.setValue(Utils.fixPathSlashes(dest));
                        }
                        this.setProperty("ProductHome", Utils.fixPathSlashes(prefix + dest));
                        destinationFound = true;
                        if (TaskHelper.getOS() == 8 || TaskHelper.getOS() == 6) continue;
                        this.setProperty("sascfg.sasuser", installProperties.getProperty("sascfg.sasuser"));
                        this.setProperty("sascfg.work", installProperties.getProperty("sascfg.work"));
                    }
                }
            }
        }
        if (!destinationFound) {
            log.info("Destination value not defined.");
        } else {
            this.setProperty(this.buildPropertyHomeKey(), this.getProductHome());
            _productHomeInfo.put(this.buildPropertyHomeKey(), this.getProductHome());
            _productHomeInfo.put(this.buildHostHomeKey(), this.getProductHome());
        }
        log.info("ProductHome set to " + this.getProductHome());
    }

    private void setInstallData() {
        String installFileName = this.getPackageDir() + File.separator + INSTALL_XML;
        File installFile = new File(installFileName);
        if (installFile.exists()) {
            log.info("unmarshalling install.xml at " + installFileName + " for the destination info");
            Project project = null;
            try {
                project = SchemaUtils.unmarshal(installFile, Project.class);
                if (project.getMode() != null && project.getMode().equals(UNINSTALL)) {
                    this.setProperty(UNINSTALL, TRUE);
                    uninstall_mode = true;
                    log.info("Setting operational mode to uninstall");
                } else {
                    this.setProperty(UNINSTALL, FALSE);
                    log.info("Setting operational mode to install");
                    uninstall_mode = false;
                }
            }
            catch (JAXBException e) {
                log.error("error unmarshalling install.xml", (Throwable)e);
            }
        }
    }

    public void loadInstall() throws Exception {
        FileInputStream stream = new FileInputStream(this.getInstallFile());
        Project projectPackage = SchemaUtils.unmarshal(stream, Project.class);
        stream.close();
        this.getCurrentContext().setProject(projectPackage);
        List<Target> targetList = projectPackage.getTarget();
        Vector<InstallationTask> tasksForBuild = new Vector<InstallationTask>();
        for (String target : this.targets) {
            for (Target xmlTarget : targetList) {
                if (!target.equals(xmlTarget.getName())) continue;
                tasksForBuild.addAll(this.initializeTasks(xmlTarget));
            }
        }
        this.getInstallTasksPerAltSku().put(this.getAltSku(), tasksForBuild);
    }

    public Vector<InstallationTask> initializeTasks(Target target) throws Exception {
        Vector<InstallationTask> retval = new Vector<InstallationTask>();
        InstallationTask iTask = null;
        for (InstallType oTask : target.getTasks()) {
            iTask = this.createTask(oTask.getClass().getName() + "Task");
            if (iTask == null) continue;
            iTask.setTarget(target);
            iTask.setData(oTask);
            iTask.setAltSku(this.getAltSku());
            if (Globals.g_debug && Globals.g_vjronly && (!(iTask instanceof ExtractTask) || !((ExtractTask)iTask).getSource().equalsIgnoreCase("vjr"))) continue;
            retval.add(iTask);
        }
        return retval;
    }

    public InstallationTask createTask(String taskName) throws Exception {
        taskName = taskName.substring(taskName.lastIndexOf(46) + 1, taskName.length());
        taskName.replaceFirst(String.valueOf(taskName.charAt(0)), String.valueOf(Character.toUpperCase(taskName.charAt(0))));
        Class<?> taskClass = Class.forName(TASK_PACKAGE + taskName);
        if (taskClass == null) {
            log.error("Could not find corresponding class for " + taskName + ".  Exiting");
            this.getView().packageVerificationFailure(this.getBundle().messageString("Controller.UnknownTask"));
            return null;
        }
        InstallationTask retval = (InstallationTask)taskClass.newInstance();
        retval.setController(this);
        retval.setUndo(uninstall_mode);
        return retval;
    }

    private void initializePlugins() {
        this.getCurrentContext().addProgressListener(this.getWriteValidationInstance());
        BuildHelpIndexDiskSpaceChecking buildHelpListener = new BuildHelpIndexDiskSpaceChecking();
        buildHelpListener.setController(this);
        this.getCurrentContext().addSetupListener(buildHelpListener);
    }

    private synchronized WriteValidationFile getWriteValidationInstance() {
        if (this.writeValidiationInstance == null) {
            this.writeValidiationInstance = new WriteValidationFile(this);
        }
        return this.writeValidiationInstance;
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        boolean removed = dir.delete();
        log.info("removing " + dir.getAbsolutePath() + ":  " + removed);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript() throws Exception {
        if (TaskHelper.getOS() == 1) {
            this.getSASController().saveWindowsSharedFiles();
        }
        this.getNotifier().fireInstallStartedNotification();
        this.setStarted(true);
        if (!uninstall_mode && this.getBackupRoot() != null && TRUE.equalsIgnoreCase(this.getProperty(CREATE_BACKUP_LOC)) && installProperties.getProperty("sdm.postinstall") == "FALSE") {
            if (this._chainfileLines.size() > 0) {
                int index = this.getAltSkus().indexOf(this.getAltSku());
                if (index <= this._chainfileLines.size() && FALSE.equalsIgnoreCase(this.getProperty(SYSREQPACKAGE))) {
                    this.setupBackup(this._chainfileLines.get(index));
                }
            } else if (FALSE.equalsIgnoreCase(this.getProperty(SYSREQPACKAGE))) {
                this.setupBackup(null);
            }
        }
        this._throwable = null;
        boolean paused = false;
        Vector<InstallationTask> tasksToRun = this.getInstallTasksPerAltSku().get(this.getAltSku());
        this._rollbackSuccessful = true;
        InstallationTask lastTask = null;
        Object object = tasksToRun.iterator();
        while (object.hasNext()) {
            InstallationTask task;
            lastTask = task = object.next();
            try {
                if (task.executeOnCurrentHost() && task.isConstraintMet()) {
                    Controller controller = this;
                    synchronized (controller) {
                        try {
                            while (this.isInterrupt()) {
                                log.info("Pausing task executions to wait for user verification with regard to cancellation");
                                paused = true;
                                this.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.isInstallCancelled()) {
                        log.info("user confirmed cancellation.  Rolling back changes");
                        InstallException ex = new InstallException();
                        ex.setSeverity(4);
                        throw ex;
                    }
                    if (paused) {
                        paused = false;
                        log.info("user decided to proceed.  Continuing installation");
                    }
                    InstallationTask runTask = Globals.g_debug ? new PerfLogDelegateTask(task) : task;
                    runTask.execute();
                    runTask.postExecute();
                }
                this._throwable = null;
            }
            catch (Throwable ex) {
                this._throwable = ex;
                Controller.logStackTrace(ex);
                if (!this.handleRuntimeError(task)) continue;
                break;
            }
        }
        if (this.isInstallCancelled()) {
            this.getNotifier().fireInstallationCancelledNotification();
            return;
        }
        try {
            this.getNotifier().fireInstallCompleteNotification();
        }
        catch (Throwable ex) {
            this._throwable = ex;
            this.handleRuntimeError(lastTask);
        }
        if (this._throwable == null) {
            object = this;
            synchronized (object) {
                try {
                    while (this.isInterrupt()) {
                        log.info("all task executions complete, but waiting for user verification with regard to cancellation");
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.isInstallCancelled()) {
                log.info("The installation was cancelled. Rolling back changes made so far.");
                this._rollbackSuccessful = this.rollbackStartingWithTask(lastTask);
                this._throwable = new Exception();
            } else if (paused) {
                paused = false;
                log.info("user chose to continue.  Proceeding with install");
            }
        }
        if (this.isInstallCancelled()) {
            this.getNotifier().fireInstallationCancelledNotification();
            return;
        }
        this.postExecute(this._throwable, this._rollbackSuccessful);
    }

    public boolean handleRuntimeError(InstallationTask task) {
        Throwable wrappedException = null;
        if (FALSE.equalsIgnoreCase(this.getProperty(CREATE_BACKUP_LOC))) {
            this.getView().exitWithoutRollback();
        }
        wrappedException = this._throwable instanceof InstallException && ((InstallException)this._throwable).getCause() != null ? ((InstallException)this._throwable).getCause() : this._throwable;
        Controller.logStackTrace(wrappedException);
        if (this._throwable instanceof InstallException && (((InstallException)this._throwable).getSeverity() == 4 || wrappedException instanceof ClosedByInterruptException)) {
            log.info("The installation was cancelled. Rolling back changes made so far.");
            this._rollbackSuccessful = this.rollbackStartingWithTask(task);
            return true;
        }
        if (task.getFailureAction().equals("rollbackAndFail") || this._throwable instanceof InstallException && ((InstallException)this._throwable).getSeverity() != 0) {
            String failureDescription = this.getBundle().messageString("Controller.InstallationFailure");
            String logDescription = this.getEnBundle().messageString("Controller.InstallationFailure");
            if (wrappedException.getMessage() != null) {
                failureDescription = failureDescription + "<BR>" + this.getBundle().messageString("Controller.ErrorDetails") + "<BR>" + wrappedException.getLocalizedMessage();
                logDescription = logDescription + "\n" + this.getEnBundle().messageString("Controller.ErrorDetails") + "\n" + wrappedException.getLocalizedMessage();
            }
            failureDescription = failureDescription + "<BR>" + this.getBundle().messageString("Controller.RollbackWarning");
            log.error(logDescription);
            this.getView().displayConfirmationMessage(failureDescription, 0);
            this._rollbackSuccessful = this.rollbackStartingWithTask(task);
            this.getNotifier().fireFailureNotification(failureDescription);
            return true;
        }
        if (task.getFailureAction().equals("prompt")) {
            if (this.getView().rollbackFailurePrompt(wrappedException.getLocalizedMessage(), this._throwable)) {
                log.error("user chose to rollback after error");
                this._rollbackSuccessful = this.rollbackStartingWithTask(task);
                return true;
            }
            while (this._throwable != null) {
                try {
                    log.error("user chose to retry after error");
                    task.retry();
                    this._throwable = null;
                }
                catch (Throwable f) {
                    this._throwable = f;
                    log.error("An error occurred during processing:  " + f.getMessage());
                }
            }
        }
        return false;
    }

    private void loadDeploymentDataFile() {
        String deploymentDataFileName = this.getPackageDir() + File.separator + DEPLOYMENT_XML;
        log.info("Processing deployment data: " + deploymentDataFileName);
        if (new File(deploymentDataFileName).exists()) {
            this.setDeploymentDataPath(deploymentDataFileName);
            log.info("unmarshalling deployment data");
            ItTasks deploymentData = null;
            try {
                deploymentData = SchemaUtils.unmarshal(new File(deploymentDataFileName), ItTasks.class);
            }
            catch (JAXBException e) {
                log.error("deployment data parse failure", (Throwable)e);
            }
            this.setDeployment(deploymentData);
        } else {
            log.info("unable to find: " + deploymentDataFileName);
        }
    }

    public ItTasks getDeployment() {
        return this.getCurrentContext().getDeployment();
    }

    public void setDeployment(ItTasks info) {
        this.getCurrentContext().setDeployment(info);
    }

    public void installCleanup() {
        if (this.isUninstall()) {
            File delDir;
            String product = this.getProperty(TWELVE_BYTE_CODE);
            log.info("attempting to clean up any leftover files for uninstall of " + product);
            try {
                File backupRoot = new File(this.getBackupRoot());
                log.info("removing backup metadata: " + backupRoot);
                if (backupRoot.delete()) {
                    String sasHome;
                    String productHome;
                    if (this.cleanupBackupParent(backupRoot) && (productHome = this.getProductHome()).startsWith(sasHome = this.getProperty("SASHome"))) {
                        File dir = new File(productHome);
                        boolean empty = true;
                        while (!sasHome.equals(dir.getPath()) && empty) {
                            empty = dir.list().length == 0 && dir.delete();
                            if (!empty) continue;
                            dir = dir.getParentFile();
                        }
                    }
                } else {
                    log.error("Could not remove backup root: " + backupRoot);
                }
            }
            catch (Exception e) {
                log.error("Error cleaning up " + product + " backup metadata", (Throwable)e);
            }
            if (!baseDeleteOnExit && (delDir = new File(this.getProperty("SASHOME"), "SASFoundation")).exists()) {
                delDir.deleteOnExit();
                delDir = new File(delDir, SASRELEASE);
                if (delDir.exists()) {
                    delDir.deleteOnExit();
                    baseDeleteOnExit = true;
                }
            }
            while (!dirDeleteOnExit.empty()) {
                delDir = dirDeleteOnExit.pop();
                if (!delDir.exists()) continue;
                delDir.deleteOnExit();
            }
            while (!fileDeleteOnExit.empty()) {
                File delFile = fileDeleteOnExit.pop();
                if (!delFile.exists()) continue;
                delFile.deleteOnExit();
            }
        }
    }

    public void maintenanceCleanup() {
        if (uninstall_mode) {
            log.info("attempting to clean up any leftover files");
            File overallBackupRoot = new File(this.getBackupRoot());
            log.info("trying to remove backups specific to this install:  " + overallBackupRoot);
            if (overallBackupRoot.delete()) {
                this.cleanupBackupParent(overallBackupRoot);
            } else {
                log.error("Could not remove chained package backup root:  " + overallBackupRoot);
            }
        }
    }

    private boolean cleanupBackupParent(File backupRoot) {
        File parent = backupRoot.getParentFile();
        String product = this.getProperty(TWELVE_BYTE_CODE);
        boolean removed = false;
        if (parent.listFiles().length == 0) {
            log.info("No other IT install data exists for " + product + ", removing " + parent);
            removed = parent.delete();
            if (!removed) {
                log.error("Could not remove " + product + " install data directory " + parent);
            }
        } else {
            log.info("Other IT install data exists for " + product + ", not removing " + parent);
        }
        return removed;
    }

    private boolean hasTarget(String targetTask) {
        return this.targets.contains(targetTask);
    }

    public void postExecute(Throwable throwable, boolean rollbackSuccessful) throws Exception {
        if (throwable == null) {
            if (!uninstall_mode) {
                log.info("Installation completed successfully.");
            }
            if (this.hasTarget(INSTALL) && !this.vjrHotFix(this.getProperty(ALT_SKU))) {
                try {
                    this.getSASController().postExecute();
                }
                catch (Exception e) {
                    String msg = "Failure in postexecute";
                    log.error("Failure in postexecute", (Throwable)e);
                    this.getNotifier().fireInstallationFailureNotification("Failure in postexecute");
                }
            }
        }
        if (uninstall_mode) {
            File parent;
            File backupRoot = new File(this.metadataBackupDirectory());
            log.info("removing backup files located at " + backupRoot.getAbsolutePath());
            if (this.deleteDir(backupRoot)) {
                parent = backupRoot.getParentFile();
                if (!parent.delete()) {
                    log.info("Other languages still installed, not removing " + parent);
                }
            } else {
                log.error("Could not remove backup directory: " + backupRoot);
            }
            backupRoot = new File(this.getBackupRootDirectory());
            log.info("removing backup files located at " + backupRoot.getAbsolutePath());
            if (this.deleteDir(backupRoot)) {
                parent = backupRoot.getParentFile();
                if (!parent.delete()) {
                    log.info("Other languages still installed, not removing " + parent);
                }
            } else {
                log.error("Could not remove backup directory: " + backupRoot);
            }
            this.getNotifier().fireInstallationCompleteNotification();
        } else if (throwable != null) {
            if (installProperties.getProperty("sdm.postinstall") == "FALSE") {
                this.getSASController().recordInstallFailure();
            }
            if (!rollbackSuccessful) {
                log.error(this.getEnBundle().messageString("Controller.RollbackHadProblems"));
                this.getView().displayConfirmationMessage(this.getBundle().messageString("Controller.RollbackHadProblems") + this.getView().logReference(false), 0);
                this.getView().rollbackUnsuccessful();
                this.getNotifier().fireInstallationFailureNotification("Failure with failed rollback");
            } else {
                log.info("Rollback Complete.");
                this.getView().rollbackSuccessful();
                this.getNotifier().fireInstallationFailureNotification("Failure with successful rollback");
            }
        } else {
            log.info("Updating install script for uninstall");
            this.getCurrentContext().serializeUninstallMetadata((List<InstallationTask>)this.getInstallTasksPerAltSku().get(this.getAltSku()));
            this.getNotifier().fireInstallationCompleteNotification();
            log.info("Install complete.");
        }
        if (TRUE.equalsIgnoreCase(this.getProperty(PROVIDE_AUDIT_LOGS))) {
            this.getAuditLogger().writePostExecutionLog();
        }
    }

    private boolean vjrHotFix(String altSku) {
        if ("instqualtool__W83001__prt__xx__sp0__1".equals(altSku) || "groovy__W47001__lax__en__sp0__1".equals(altSku) || "groovy__W47001__wx6__en__sp0__1".equals(altSku)) {
            return true;
        }
        if ("instqualtool__M3X004__prt__xx__sp0__1".equals(altSku)) {
            return false;
        }
        return TRUE.equals(this.getProperty("SecurityFix"));
    }

    public static void logStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ex.printStackTrace(pw);
        log.error("An error occurred during processing:  ");
        if (ex instanceof InstallException) {
            log.error(((InstallException)ex).logString());
        } else if (ex.getMessage() != null) {
            log.error(ex.getMessage());
        }
        log.error(sw.toString());
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            sw = new StringWriter();
            pw = new PrintWriter((Writer)sw, true);
            cause.printStackTrace(pw);
            log.error("Caused by:  ");
            if (cause.getMessage() != null) {
                if (cause instanceof InstallException) {
                    log.error(((InstallException)cause).getLogMessage());
                } else {
                    log.error(cause.getMessage());
                }
            }
            log.error(sw.toString());
        }
    }

    public static String stackTraceForError(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ex.printStackTrace(pw);
        pw.print("An error occurred during processing:  \n");
        if (ex instanceof InstallException) {
            pw.print(((InstallException)ex).logString() + "\n");
        } else if (ex.getMessage() != null) {
            pw.print(ex.getMessage() + "\n");
        }
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(pw);
            pw.print("Caused by:  \n");
            if (cause.getMessage() == null) continue;
            if (cause instanceof InstallException) {
                pw.print(((InstallException)cause).getLogMessage() + "\n");
                continue;
            }
            pw.print(cause.getMessage() + "\n");
        }
        return sw.toString();
    }

    public boolean rollbackStartingWithTask(InstallationTask task) {
        if (System.getenv("SKIP_ROLLBACK") != null && System.getenv("SKIP_ROLLBACK").equals(TRUE)) {
            log.info("skipping rollback of tasks per SKIP_ROLLBACK environment variable setting");
            return true;
        }
        Vector<InstallationTask> currentInstallTasks = this.getInstallTasksPerAltSku().get(this.getAltSku());
        Vector reverse = (Vector)currentInstallTasks.clone();
        Collections.reverse(reverse);
        boolean brokenTaskIdentified = false;
        boolean fullySuccessfulRollback = true;
        for (InstallationTask uninstallTask : reverse) {
            if (!brokenTaskIdentified && uninstallTask == task) {
                brokenTaskIdentified = true;
            }
            if (!brokenTaskIdentified) continue;
            try {
                uninstallTask.rollback();
            }
            catch (Exception e) {
                fullySuccessfulRollback = false;
                log.error("Error rolling back task:\n" + uninstallTask.descriptionForLog() + "\n");
                Controller.logStackTrace(e);
            }
        }
        this.getNotifier().fireAllRollbackCompleteNotification();
        log.info("Rollback complete.  The system has been reverted to its original form");
        return fullySuccessfulRollback;
    }

    public boolean preExecute() {
        boolean status = true;
        List tasksToRun = this.getInstallTasksPerAltSku().get(this.getAltSku());
        if (tasksToRun == null) {
            tasksToRun = Collections.emptyList();
        }
        for (int i = 0; status && i < tasksToRun.size(); ++i) {
            InstallationTask task = (InstallationTask)tasksToRun.get(i);
            try {
                if (!task.executeOnCurrentHost()) continue;
                InstallationTask runTask = Globals.g_debug ? new PerfLogDelegateTask(task) : task;
                runTask.preExecute();
                if (installProperties.getProperty("sdw.resume.chain") != "TRUE") continue;
                this.createProcessingTask(task);
                continue;
            }
            catch (Exception e) {
                log.error("An error occurred during pre-execution:  ");
                Controller.logStackTrace(e);
                log.error("The installation was unable to be completed. No changes have been made to your system.");
                try {
                    this.getView().packageVerificationFailure(e.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                status = false;
            }
        }
        if (TRUE.equalsIgnoreCase(this.getProperty(PROVIDE_AUDIT_LOGS))) {
            this.getAuditLogger().writePreExecutionLog();
        }
        return status;
    }

    private void createProcessingTask(InstallationTask task) {
        String className = task.getClass().getName();
        String key = this.getAltSku().concat(className);
        ProcessingTaskInfo info = this.getPostProcessingTasks().get(key);
        if (info != null) {
            ProcessingTask.Priority priority = null;
            ProcessingTaskInfo.Priority infoPriority = info.getPriority();
            priority = infoPriority != null ? ProcessingTask.Priority.valueOf(infoPriority.toString()) : ProcessingTask.Priority.MID;
            ProcessingTask processingTask = info.isInstanceNeeded() ? new ProcessingTask(task, task.getClass(), info.getMethodName(), priority) : new ProcessingTask(task.getClass(), info.getMethodName(), priority);
            if (task instanceof ApplySASLicenseTask) {
                ApplySASLicenseTask.setPostProcessingInitialized(true);
            }
            if (task instanceof ApplyTKLasrLicenseTask) {
                ApplyTKLasrLicenseTask.setPostProcessingInitialized(true);
            }
            if (task instanceof BuildSASRegistryTask) {
                BuildSASRegistryTask.setPostProcessingInitialized(true);
            }
            this.getPostProcessingQueue().add(processingTask);
        }
    }

    public boolean someTaskApplies() {
        Vector<InstallationTask> tasksToRun = this.getInstallTasksPerAltSku().get(this.getAltSku());
        if (tasksToRun == null) {
            log.info("skipping " + this.getAltSku() + " because there are no tasks");
            return false;
        }
        boolean retval = false;
        for (InstallationTask task : tasksToRun) {
            if (!task.executeOnCurrentHost()) continue;
            retval = true;
        }
        if (!retval) {
            log.info("skipping " + this.getAltSku() + " because no tasks apply");
        }
        return retval;
    }

    public String getPackageIdentifier() {
        String maintVer = null;
        if (this.isHotfix() || this.isMaintenance()) {
            maintVer = this.getProperty(MAINTENANCE_VERSION);
        }
        return this.getPackageIdentifier(this.getProperty(TWELVE_BYTE_CODE), this.getProperty(PRODUCT_VERSION), this.getHost(), maintVer, this.getProperty(HOTFIX_VERSION));
    }

    public String getPackageIdentifier(String product, String version, String host, String maintVer, String hotfixVer) {
        StringBuffer packageID = new StringBuffer();
        packageID.append(product).append("_");
        packageID.append(host).append("_");
        packageID.append(version);
        if (maintVer != null && !maintVer.equals("0")) {
            packageID.append("_M").append(maintVer);
        }
        if (hotfixVer != null) {
            packageID.append("_HF").append(hotfixVer);
        }
        return packageID.toString();
    }

    public File getInstallFile() {
        return this._installFile;
    }

    public String getAltSku() {
        PreExecuteThread thread;
        PreExecuteRunnable preExecute;
        if (Thread.currentThread() instanceof PreExecuteThread && (preExecute = (thread = (PreExecuteThread)Thread.currentThread()).getPreExecuteRunnable()) != null) {
            return preExecute.getAltSku();
        }
        return this._altSku;
    }

    public String getBuildFileLocation() {
        if (this._buildFileLocation == null) {
            return this.getInstallFile().getAbsolutePath();
        }
        return this._buildFileLocation;
    }

    public void setBuildFileLocation(String url) {
        this._buildFileLocation = url;
    }

    public void setInstallFile(File buildFile) {
        this._installFile = buildFile;
    }

    public boolean isStarted() {
        return this._started;
    }

    public void setStarted(boolean started) {
        this._started = started;
    }

    public File getLogPath() {
        return this.logPath;
    }

    public void setLogPath(File logPath) {
        if (logPath == null) {
            throw new IllegalArgumentException("log path must not be null");
        }
        if (!logPath.equals(this.logPath)) {
            if (logPath.isFile()) {
                throw new IllegalArgumentException("log path must be directory");
            }
            this._loggingConfigured = false;
            this.logPath = logPath;
        }
    }

    public String getViewClassname() {
        return this._viewClassname;
    }

    public void setViewClassname(String viewClassname) throws Exception {
        this._viewClassname = viewClassname;
        if (this._viewClassname != null) {
            this.setView((MITView)Class.forName(viewClassname).newInstance());
        }
    }

    public MITView getView() {
        return this._view;
    }

    public void setView(MITView view) {
        this._view = view;
        this._view.setController(this);
    }

    public String getPackageDir() {
        return this.getInstallFile().getParent();
    }

    public File getChainFile() {
        return this._chainFile;
    }

    public String getChainFilePath() {
        if (this._chainFilePath == null && this.getChainFile() != null) {
            return this.getChainFile().getAbsolutePath();
        }
        return this._chainFilePath;
    }

    public void setChainFile(File chainFile) {
        this._chainFile = chainFile;
    }

    public void setChainFilePath(String path) {
        this._chainFilePath = path;
    }

    public List<String> getAltSkus() {
        PreExecuteThread thread;
        PreExecuteRunnable preExecute;
        if (Thread.currentThread() instanceof PreExecuteThread && (preExecute = (thread = (PreExecuteThread)Thread.currentThread()).getPreExecuteRunnable()) != null) {
            Vector<String> retval = new Vector<String>();
            retval.add(this.getAltSku());
            return retval;
        }
        assert (this._altSkus.size() <= 1) : "Each Controller should only be handling one altsku";
        return this._altSkus;
    }

    public void setAltSkus(Vector<String> altSkus) {
        assert (altSkus != null);
        assert (altSkus.size() <= 1) : "Each Controller should only be handling one altsku";
        this._altSkus = altSkus;
    }

    public Map<String, Vector<InstallationTask>> getInstallTasksPerAltSku() {
        return this._installTasksPerAltSku;
    }

    protected void setInstallTasksPerBuild(Map<String, Vector<InstallationTask>> installTasksPerAltSku) {
        this._installTasksPerAltSku = installTasksPerAltSku;
    }

    public SASController getSASController() {
        return this._sasController;
    }

    public void setSASController(SASController sasController) {
        this._sasController = sasController;
    }

    protected Map<String, Map<String, String>> getPropertyHelpers() {
        return this._propertyHelpers;
    }

    protected void setPropertyHelpers(Map<String, Map<String, String>> propertyHelpers) {
        this._propertyHelpers = propertyHelpers;
    }

    public SSNResource getBundle() {
        return this._bundle;
    }

    public void setBundle(SSNResource bundle) {
        this._bundle = bundle;
    }

    public boolean isProductVersionCheckingBypassed() {
        return this._versionCheckingBypassed;
    }

    protected void setProductVersionCheckingBypassed(boolean versionCheckingBypassed) {
        this._versionCheckingBypassed = versionCheckingBypassed;
    }

    public boolean isMaintenanceVersionCheckingSkipped() {
        return this._maintenanceVersionCheckingSkipped;
    }

    public boolean isLanguageCheckSkipped() {
        return this._languageCheckSkipped;
    }

    public void setMaintenanceVersionCheckingSkipped(boolean maintVerChkSkipped) {
        this._maintenanceVersionCheckingSkipped = maintVerChkSkipped;
    }

    public void setLanguageCheckSkipped(boolean langChkSkipped) {
        this._languageCheckSkipped = langChkSkipped;
    }

    public boolean alwaysOverwrite() {
        return this._alwaysOverwrite;
    }

    protected void setAlwaysOverwrite(boolean alwaysOverwrite) {
        this._alwaysOverwrite = alwaysOverwrite;
    }

    public String getChainFileEntry() {
        return this._chainFileEntry;
    }

    public void setChainFileEntry(String chainFileEntry) {
        this._chainFileEntry = chainFileEntry;
    }

    public SSNResource getEnBundle() {
        return this._enBundle;
    }

    public void setEnBundle(SSNResource enBundle) {
        this._enBundle = enBundle;
    }

    public FileSystem getFS() {
        return this._fs;
    }

    protected void setFS(FileSystem fileSystem) {
        this._fs = fileSystem;
    }

    public List<String> getChainfileLines() {
        return this._chainfileLines;
    }

    public void setChainfileLines(List<String> chainfileLines) {
        this._chainfileLines = chainfileLines;
    }

    public boolean isInterrupt() {
        return this._interrupt;
    }

    public void setInterrupt(boolean interrupt) {
        this._interrupt = interrupt;
    }

    public String getInstallAppLocation() {
        URL url;
        if (this._sourceLocation == null && (url = Controller.class.getProtectionDomain().getCodeSource().getLocation()) != null) {
            try {
                this._sourceLocation = this.getFS().getParent(URLDecoder.decode(url.getFile(), "UTF-8"));
            }
            catch (Exception e) {
                throw new InstallException(1, null, this.getBundle().messageString("Controller.UninstallSetupError"), "Error setting up uninstall tooling.", e);
            }
        }
        return this._sourceLocation;
    }

    public String getToolVersion() {
        if (this._toolVersion == null) {
            this._toolVersion = Utils.GetJarVersion(Utils.joinPath(this.getInstallAppLocation(), "sas.tools.installs.it.jar"));
        }
        return this._toolVersion;
    }

    public boolean isInstallCancelled() {
        return this._installCancelled;
    }

    public void setInstallCancelled(boolean installCancelled) {
        this._installCancelled = installCancelled;
    }

    public Vector<String> getAllInstallAltskus() {
        return this._allInstallAltskus;
    }

    public void setAllInstallAltskus(Vector<String> allInstallAltskus) {
        this._allInstallAltskus = allInstallAltskus;
    }

    public static ExecutionThread getExecutionThread() {
        return _executionThread;
    }

    public static void setExecutionThread(ExecutionThread executionThread) {
        _executionThread = executionThread;
    }

    public HashMap<String, InstallationContext> getInstallContexts() {
        return this._installContexts;
    }

    public String getProductDataPath() {
        return this.getProperty("ProductDataPath");
    }

    protected void setProductDataPath(String productDataPath) {
        this.setProperty("ProductDataPath", productDataPath);
    }

    public String getDeploymentDataPath() {
        return this.getProperty("DeploymentDataPath");
    }

    protected void setDeploymentDataPath(String deploymentDataPath) {
        this.setProperty("DeploymentDataPath", deploymentDataPath);
    }

    public void setAltSku(String altSku) {
        this._altSku = altSku;
    }

    public int getACEVersion() {
        List<String> keys = Arrays.asList("SOFTWARE\\WOW6432Node\\Microsoft\\Office\\16.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\16.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\ClickToRun\\REGISTRY\\MACHINE\\Software\\Wow6432Node\\Microsoft\\Office\\16.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\ClickToRun\\REGISTRY\\MACHINE\\Software\\Microsoft\\Office\\16.0\\Access Connectivity Engine", "SOFTWARE\\WOW6432Node\\Microsoft\\Office\\15.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\15.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\ClickToRun\\REGISTRY\\MACHINE\\Software\\Wow6432Node\\Microsoft\\Office\\15.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\ClickToRun\\REGISTRY\\MACHINE\\Software\\Microsoft\\Office\\15.0\\Access Connectivity Engine", "SOFTWARE\\WOW6432Node\\Microsoft\\Office\\14.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\14.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\ClickToRun\\REGISTRY\\MACHINE\\Software\\Wow6432Node\\Microsoft\\Office\\14.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\ClickToRun\\REGISTRY\\MACHINE\\Software\\Microsoft\\Office\\14.0\\Access Connectivity Engine", "SOFTWARE\\WOW6432Node\\Microsoft\\Office\\12.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\12.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\ClickToRun\\REGISTRY\\MACHINE\\Software\\Wow6432Node\\Microsoft\\Office\\12.0\\Access Connectivity Engine", "SOFTWARE\\Microsoft\\Office\\ClickToRun\\REGISTRY\\MACHINE\\Software\\Microsoft\\Office\\12.0\\Access Connectivity Engine");
        int existingACE = 0;
        for (String key : keys) {
            File file;
            String rootKey = key + "\\InstallRoot";
            String path = WinRegAPI.getWindowsRegistryValue(8, rootKey, "Path");
            if (path == null || path.length() <= 0) continue;
            if (!key.contains("ClickToRun")) {
                path = path + "ACEODBC.DLL";
            }
            if (!(file = new File(path)).exists()) continue;
            if (key.contains("Wow6432Node")) {
                existingACE = 1;
                log.info("ACE 32-bit driver is installed on 64-bit OS");
                break;
            }
            if (System.getenv("ProgramFiles(x86)") == null) {
                existingACE = 1;
                log.info("ACE 32-bit driver is installed on 32-bit OS");
                break;
            }
            existingACE = 2;
            log.info("ACE 64-bit driver is installed on 64-bit OS");
            break;
        }
        if (existingACE == 0) {
            log.info("ACE driver is NOT installed");
        }
        return existingACE;
    }

    public static void setDirDeleteOnExit(Stack<File> dirsToDelete) {
        dirDeleteOnExit = dirsToDelete;
    }

    public static Stack<File> getDirDeleteOnExit() {
        return dirDeleteOnExit;
    }

    public static void setFileDeleteOnExit(Stack<File> filesToDelete) {
        dirDeleteOnExit = filesToDelete;
    }

    public static Stack<File> getFileDeleteOnExit() {
        return fileDeleteOnExit;
    }

    public boolean isZosHost() {
        String host = this.getProperty(HOST);
        return MVS_HOST.equalsIgnoreCase(host) || Z64_HOST.equalsIgnoreCase(host);
    }

    public boolean isMvsMVAInstall() {
        return this.isZosHost() && this.getProperty("HostMultiPlatform") == null;
    }

    public boolean isMvsMVAHotfix() {
        return this.isMvsMVAInstall() && this.isHotfix();
    }

    public void setSolstice(boolean solstice) {
        this._solstice = solstice;
    }

    public boolean isSolstice() {
        return this._solstice;
    }

    public boolean checkMvsDataSetParams(int function, String value, Properties dsProperties, java.util.logging.Logger sdwLog, boolean quiet, StringBuffer msgs) {
        String location = this.getInstallAppLocation();
        return MvsextractTask.checkMvsDataSetParams(function, value, dsProperties, location, sdwLog, quiet, msgs);
    }

    public String getMvsUserParam(String key) {
        return MvsextractTask.UserParams.get(key);
    }

    public List<String> getMvsFinalJobNames() {
        return MvsextractTask.finalJobNames;
    }

    public Map<String, String> getMvsJobStatus() {
        return MvsextractTask.getJobStatus();
    }

    public boolean isMvsHelpJobPresent() {
        return MvsextractTask.isHelpJobPresent();
    }

    public boolean isMvsStagedInstall() {
        return MvsextractTask.isStagedInstall();
    }

    private String appendTaskNameInLogFileName(String sLogFileName, boolean bInstall) {
        String newLogName = sLogFileName.substring(0, 22);
        if (bInstall) {
            return newLogName + "_install.log";
        }
        return newLogName + "_uninstall.log";
    }

    public boolean isWarning() {
        return this._warning;
    }

    public void setWarning(boolean warning) {
        this._warning = warning;
    }

    public Map<String, ProcessingTaskInfo> getPostProcessingTasks() {
        return this.postProcessingTasks;
    }

    public void setPostProcessingTasks(Map<String, ProcessingTaskInfo> postProcessingTasks) {
        this.postProcessingTasks = postProcessingTasks;
    }

    private String buildPropertyHomeKey() {
        return this.getProperty(TWELVE_BYTE_CODE) + "Home";
    }

    private String buildHostHomeKey() {
        return String.format("%s_%sHome", this.getProperty(TWELVE_BYTE_CODE), this.getHost());
    }

    private boolean isNullOrEmpty(String myString) {
        return myString == null || myString.isEmpty();
    }

    private String getProductHome() {
        return this.getProperty("ProductHome");
    }

    private String getBackupRoot() {
        return this.getProperty("BackupRoot");
    }

    private String getHost() {
        return this.getProperty(HOST);
    }

    private boolean isHostMVS() {
        return this.getHost().equalsIgnoreCase(MVS_HOST);
    }

    private boolean isHostZ64() {
        return this.getHost().equalsIgnoreCase(Z64_HOST);
    }

    private String getSDMApplyHotfixProperty() {
        return installProperties.getProperty("sdm.applyhotfix");
    }

    static {
        _productHomeInfo = new HashMap();
        installProperties = new Properties();
        SASFOUNDATION = File.separator + "SASFoundation" + File.separator + SASRELEASE + File.separator;
        logDate = Calendar.getInstance().getTime();
        _selectedPCFSversion = null;
        dirDeleteOnExit = new Stack();
        fileDeleteOnExit = new Stack();
        baseDeleteOnExit = false;
    }
}

