/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.extension;

import com.sas.tools.installs.extension.ExtensionException;
import com.sas.tools.installs.extension.ExtensionRegistrar;
import com.sas.tools.installs.it.AltskuProperties;
import com.sas.tools.installs.it.HiveKeyRegistry;
import com.sas.tools.installs.it.schema.SchemaUtils;
import com.sas.tools.installs.it.schema.extension.ExtensionsType;
import com.sas.tools.installs.it.schema.extension.InstalledExtensionType;
import com.sas.tools.installs.it.schema.extension.ProductType;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class ExtensionRegistry {
    private final ExtensionsType registry;

    public ExtensionRegistry(File registryXml) {
        try {
            this.registry = SchemaUtils.unmarshal(registryXml, ExtensionsType.class);
        }
        catch (JAXBException e) {
            throw new ExtensionException("can't read extension registry " + registryXml, e);
        }
    }

    public boolean extensionsShared() {
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            if (ext.getProduct().size() <= 1) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getSharedExtensions() {
        TreeSet<String> shared = new TreeSet<String>();
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            if (ext.getProduct().size() <= 1) continue;
            shared.add(ext.getExtname());
        }
        return shared;
    }

    public Collection<String> getExtensions() {
        TreeSet<String> extensions = new TreeSet<String>();
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            extensions.add(ext.getExtname());
        }
        return extensions;
    }

    public Collection<String> getExtensions(String name) {
        TreeSet<String> shared = new TreeSet<String>();
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            List<ProductType> products = ext.getProduct();
            for (ProductType product : products) {
                if (name.equals(product.getName())) {
                    shared.add(ext.getExtname());
                }
                product.getName();
            }
        }
        return shared;
    }

    public String getExtensionDescription(String extension, String progId) {
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            if (!ext.getExtname().equals(extension)) continue;
            if (ext.getProduct().size() > 0) {
                for (ProductType product : ext.getProduct()) {
                    if (!product.getExtension().getCurverkey().equals(progId)) continue;
                    return product.getExtension().getDescription();
                }
                ProductType product = ext.getProduct().get(0);
                return product.getExtension().getDescription();
            }
            throw new ExtensionException("no products registered for " + extension);
        }
        throw new ExtensionException("unknown extension: " + extension);
    }

    public Collection<String> getProductsWithSharedExtensions() {
        TreeSet<String> sharedProducts = new TreeSet<String>();
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            if (ext.getProduct().size() <= 1) continue;
            for (ProductType product : ext.getProduct()) {
                sharedProducts.add(product.getName());
            }
        }
        return sharedProducts;
    }

    public Collection<String> getProductsWithExtensions() {
        TreeSet<String> sasProducts = new TreeSet<String>();
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            for (ProductType product : ext.getProduct()) {
                sasProducts.add(product.getName());
            }
        }
        return sasProducts;
    }

    public Collection<String> getProductsForExtension(String extension) {
        TreeSet<String> products = new TreeSet<String>();
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            if (!ext.getExtname().equals(extension)) continue;
            for (ProductType product : ext.getProduct()) {
                products.add(product.getName());
            }
        }
        return products;
    }

    public void registerDefault(String extension, HiveKeyRegistry winRegistry, AltskuProperties props) {
        this.registerDefault(extension, winRegistry, props, false);
    }

    public void registerDefault(String extension, HiveKeyRegistry winRegistry, AltskuProperties props, boolean deleteUserChoiceKey) {
        boolean foundExt = false;
        for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            if (!ext.getExtname().equals(extension)) continue;
            String productName = props.getProperty("12ByteCode");
            boolean foundProduct = false;
            foundExt = true;
            for (ProductType product : ext.getProduct()) {
                if (!product.getName().equals(productName)) continue;
                ExtensionRegistrar registrar = new ExtensionRegistrar(winRegistry, props);
                foundProduct = true;
                registrar.register(product.getExtension(), ExtensionRegistrar.RegisterAction.DEFAULT, deleteUserChoiceKey);
            }
            if (foundProduct) continue;
            throw new ExtensionException("unknown product: " + productName);
        }
        if (!foundExt) {
            throw new ExtensionException("unknown extension: " + extension);
        }
    }

    public boolean isAlias(String extension, String productCode) {
        boolean alias = false;
        block0: for (InstalledExtensionType ext : this.registry.getInstalledExtension()) {
            if (!ext.getExtname().equals(extension)) continue;
            for (ProductType product : ext.getProduct()) {
                if (!product.getName().equals(productCode)) continue;
                String extRoot = product.getExtension().getRootkey();
                if (extRoot == null || "".equals(extRoot)) {
                    alias = true;
                    break block0;
                }
                alias = false;
                break block0;
            }
        }
        return alias;
    }
}

