/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.extension;

import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.extension.ExtensionException;
import com.sas.tools.installs.it.AltskuProperties;
import com.sas.tools.installs.it.HiveKeyRegistry;
import com.sas.tools.installs.it.Utils;
import com.sas.tools.installs.it.schema.install.gen.Action;
import com.sas.tools.installs.it.schema.install.gen.Extension;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class ExtensionRegistrar {
    private static Logger log = (Logger)LogManager.getLogger(ExtensionRegistrar.class);
    private final HiveKeyRegistry registry;
    private final AltskuProperties props;
    private static int hive = 1;
    private static int type = 109;

    public ExtensionRegistrar(HiveKeyRegistry registry, AltskuProperties props) {
        this.registry = registry;
        this.props = props;
    }

    public boolean register(Extension extension, RegisterAction registerAction) {
        return this.register(extension, registerAction, false);
    }

    public boolean register(Extension extension, RegisterAction registerAction, boolean deleteUserChoiceKey) {
        String curver;
        boolean result = true;
        String extname = extension.getExtname();
        if (!this.validExtensionData(extname, curver = this.props.resolve(extension.getCurverkey()))) {
            return true;
        }
        if (registerAction == RegisterAction.BASIC) {
            result = this.registry.createKey(hive, extname);
            result = this.registry.setValue(hive, extname, "", curver, type);
            if (this.isEnabled(extension.getPersistenthandler())) {
                result = this.registry.setValue(hive, Utils.joinPath(extname, "PersistentHandler"), "", "{5e941d80-bf96-11cd-b579-08002b30bfeb}", type);
            }
            if (!this.isEmpty(extension.getMimetype())) {
                result = this.registry.setValue(hive, extname, "Content Type", extension.getMimetype(), type);
                result = this.registry.setValue(hive, Utils.joinPath("MIME\\Database\\Content Type", extension.getMimetype()), "Extension", extname, type);
            }
            this.registry.createKey(hive, Utils.joinPath(extname, curver));
            if (this.isEnabled(extension.getShellnew())) {
                String shellNewKey = Utils.joinPath(extname, curver, "ShellNew");
                result = this.registry.createKey(hive, shellNewKey);
                result = this.registry.setValue(hive, shellNewKey, "NullFile", "", type);
            }
        }
        if (!this.isEmpty(extension.getRootkey())) {
            if (registerAction == RegisterAction.BASIC) {
                result = this.registry.createKey(hive, extension.getRootkey());
                String curVerKey = Utils.joinPath(extension.getRootkey(), "CurVer");
                result = this.registry.createKey(hive, curVerKey);
                result = this.registry.setValue(hive, curVerKey, "", curver, type);
                result = this.registry.createKey(hive, curver);
                if (!this.isEmpty(extension.getDescription())) {
                    result = this.registry.setValue(hive, curver, "", extension.getDescription(), type);
                }
                if (!this.isEmpty(extension.getEditflags())) {
                    result = this.registry.setValue(hive, curver, "EditFlags", extension.getEditflags(), 101);
                }
                if (extension.getShowext() != null) {
                    if (extension.getShowext().compareTo(BigInteger.ONE) == 0) {
                        result = this.registry.setValue(hive, curver, "AlwaysShowExt", "", type);
                    } else if (extension.getShowext().compareTo(BigInteger.ZERO) == 0) {
                        result = this.registry.setValue(hive, curver, "NeverShowExt", "", type);
                    }
                }
                if (this.isEnabled(extension.getNoopen())) {
                    result = this.registry.setValue(hive, curver, "NoOpen", "", type);
                }
                if (!this.isEmpty(extension.getClsid())) {
                    result = this.registry.setValue(hive, curver, "CLSID", extension.getClsid(), type);
                }
            }
            if (!this.isEmpty(extension.getIconfile()) && extension.getIconnumber() != null) {
                String defaultIconKey = Utils.joinPath(curver, "DefaultIcon");
                result = this.registry.createKey(hive, defaultIconKey);
                if (registerAction == RegisterAction.DEFAULT) {
                    result = this.registry.setValue(hive, defaultIconKey, "", this.props.resolve(extension.getIconfile()) + "," + extension.getIconnumber(), type);
                }
            }
            if (!extension.getAction().isEmpty()) {
                String defaultActionName;
                String shellKey = Utils.joinPath(curver, "shell");
                result = this.registry.createKey(hive, shellKey);
                if (!this.isEmpty(extension.getDefaultaction())) {
                    result = this.registry.setValue(hive, shellKey, "", this.props.resolve(extension.getDefaultaction()), type);
                }
                ActionFilter filter = new ActionFilter(extension);
                List<Action> filteredActions = filter.byRegisterAction(registerAction);
                log.info("Registering " + filteredActions.size() + " actions");
                for (Action action : filteredActions) {
                    result = this.registerAction(action, shellKey);
                }
                if (deleteUserChoiceKey && registerAction == RegisterAction.DEFAULT) {
                    String userChoiceKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension.getExtname() + "\\UserChoice";
                    if (!JNIUtils.libraryLoaded(JNIUtils.JNI_LIB_BASE, WinRegAPI.libNames)) {
                        String missingLib = JNIUtils.getJniLib(SASWinAPI.libNames);
                        log.warn("Unable to remove user choice key " + userChoiceKey + " because the libarary " + missingLib + " could not be loaded");
                    } else if (WinRegAPI.isWindowsRegistryKey64(4, userChoiceKey) || WinRegAPI.isWindowsRegistryKey32(4, userChoiceKey)) {
                        if (WinRegAPI.DelRegKey(4, userChoiceKey)) {
                            log.info("UserChoice key for user id " + System.getProperty("user.name") + " for the extension " + extension + " has been removed: HKEY_CURRENT_USER\\" + userChoiceKey);
                        } else {
                            log.warn("UserChoice key for user id " + System.getProperty("user.name") + " for the extension " + extension + " failed to be removed: HKEY_CURRENT_USER\\" + userChoiceKey);
                        }
                    }
                }
                if (!this.isEmpty(defaultActionName = new DefaultActionFinder().find(extension))) {
                    String defaultCommandKey = Utils.joinPath(this.props.resolve(extension.getCurverkey()), "shell", this.props.resolve(defaultActionName));
                    this.registry.createKey(hive, Utils.joinPath(defaultCommandKey, "command"));
                }
            }
        }
        return result;
    }

    private boolean registerAction(Action action, String shellKey) {
        if (!this.validActionData(action.getName(), action.getCommand())) {
            boolean bl = false;
        }
        String resolvedName = this.props.resolve(action.getName());
        log.info("creating action: " + resolvedName + " for " + shellKey);
        String actionKey = Utils.joinPath(shellKey, resolvedName);
        boolean result = this.registry.createKey(hive, actionKey);
        if (!this.isEmpty(action.getMenu())) {
            result = this.registry.setValue(hive, actionKey, "", this.props.resolve(action.getMenu()), type);
        }
        String commandKey = Utils.joinPath(actionKey, "command");
        result = this.registry.createKey(hive, commandKey);
        result = this.registry.setValue(hive, commandKey, "", this.props.resolve(action.getCommand()), type);
        if (action.getDde() != null) {
            String ddeexecKey = Utils.joinPath(actionKey, "ddeexec");
            result = this.registry.createKey(hive, ddeexecKey);
            result = this.registry.setValue(hive, ddeexecKey, "", action.getDde().getExec(), type);
            if (!this.isEmpty(action.getDde().getApp())) {
                String ddeappKey = Utils.joinPath(ddeexecKey, "application");
                result = this.registry.createKey(hive, ddeappKey);
                result = this.registry.setValue(hive, ddeappKey, "", this.props.resolve(action.getDde().getApp()), type);
            }
            if (!this.isEmpty(action.getDde().getTopic())) {
                String topicKey = Utils.joinPath(ddeexecKey, "topic");
                result = this.registry.createKey(hive, topicKey);
                result = this.registry.setValue(hive, topicKey, "", this.props.resolve(action.getDde().getTopic()), type);
            }
            if (!this.isEmpty(action.getDde().getIfexec())) {
                String ifexecKey = Utils.joinPath(ddeexecKey, "ifexec");
                result = this.registry.createKey(hive, ifexecKey);
                result = this.registry.setValue(hive, ifexecKey, "", this.props.resolve(action.getDde().getTopic()), type);
            }
        }
        return result;
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    private boolean isEnabled(BigInteger feature) {
        BigInteger enabled = BigInteger.ONE;
        return feature != null && feature.compareTo(enabled) == 0;
    }

    protected boolean validExtensionData(String extname, String curVerKey) {
        if (this.isEmpty(extname)) {
            log.warn("invalid extension name: " + extname);
            return false;
        }
        if (this.isEmpty(curVerKey)) {
            log.warn("invalid current version key: " + curVerKey);
            return false;
        }
        return true;
    }

    protected boolean validActionData(String name, String command) {
        if (this.isEmpty(name)) {
            log.warn("invalid action name: " + name);
            return false;
        }
        if (this.isEmpty(command)) {
            log.warn("invalid action command: " + command);
            return false;
        }
        return true;
    }

    public static enum RegisterAction {
        BASIC,
        DEFAULT;

    }

    public class ActionFilter {
        private final Extension extension;
        private final String defaultActionName;

        public ActionFilter(Extension extension) {
            this.extension = extension;
            this.defaultActionName = new DefaultActionFinder().find(extension);
        }

        public List<Action> byRegisterAction(RegisterAction registerAction) {
            ArrayList<Action> actions = new ArrayList<Action>();
            for (Action a : this.extension.getAction()) {
                boolean matches;
                if (registerAction == RegisterAction.DEFAULT) {
                    matches = a.getName().equals(this.defaultActionName);
                } else if (registerAction == RegisterAction.BASIC) {
                    matches = !a.getName().equals(this.defaultActionName);
                } else {
                    throw new ExtensionException("unknown register action " + (Object)((Object)registerAction));
                }
                if (!matches) continue;
                actions.add(a);
            }
            return actions;
        }
    }

    private class DefaultActionFinder {
        private DefaultActionFinder() {
        }

        public String find(Extension extension) {
            String defaultName;
            String explicitDefaultName = extension.getDefaultaction();
            if (!ExtensionRegistrar.this.isEmpty(explicitDefaultName)) {
                defaultName = explicitDefaultName;
            } else {
                Action defaultAction = null;
                for (Action a : extension.getAction()) {
                    if (!"Open".equals(ExtensionRegistrar.this.props.resolve(a.getName()))) continue;
                    defaultAction = a;
                }
                if (defaultAction == null) {
                    defaultAction = extension.getAction().get(0);
                }
                defaultName = defaultAction.getName();
            }
            return defaultName;
        }
    }
}

