/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.filter.visuals;

import com.sas.console.filter.visuals.FilterSelectorPanel;
import com.sas.console.filter.visuals.FilterTablePane;
import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeEvent;
import com.sas.filter.model.FilterSelector;
import com.sas.workspace.WAPanel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JScrollPane;

public class FilterTableView
implements CustomViewInterface {
    private WorkspaceFile m_work;
    private NodeInterface m_node;
    private NeoTableModelInterface m_model;
    private FilterSelector m_filter;
    private FilterSelectorPanel m_filterPanel;
    private FilterTablePane m_customTable;
    private JScrollPane m_view;
    private final Frame m_frame = Workspace.getWorkspace();

    public FilterTableView(WorkspaceFile work, NodeInterface node, NeoTableModelInterface model, FilterSelector filter) {
        this.m_work = work;
        this.m_node = node;
        this.m_model = model;
        this.m_filter = filter;
    }

    public boolean setFilter(FilterSelector filter) {
        if (filter != null) {
            this.m_filter = filter;
            this.m_filterPanel.setSelectedFilter(this.m_filter);
            this.m_model.refresh(this.m_filter);
            return true;
        }
        return false;
    }

    public void saveSettingsAndCleanUp() {
        this.m_node = null;
        this.m_model = null;
        this.m_filter = null;
        this.m_filterPanel = null;
        this.m_customTable = null;
        this.m_view = null;
    }

    public List getToolBarActions() {
        return this.m_customTable.getToolBarActions();
    }

    public List getContextMenuActions() {
        return this.m_customTable.getContextMenuActions();
    }

    public NodeInterface getNode() {
        return this.m_node;
    }

    public Component getComponent() {
        if (this.m_filter != null) {
            if (this.m_view == null) {
                if (this.m_customTable == null) {
                    this.m_customTable = new FilterTablePane(this.m_model, this.m_model.getSettingPrefix());
                }
                this.m_customTable.setRowHeaderVisible(false);
                this.m_filterPanel = new FilterSelectorPanel(this.m_model.getFilters(), this.m_filter, this.m_model, this.m_work, this.m_node);
                this.m_filterPanel.addActionListenerToNow(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FilterTableView.this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
                        FilterSelector filter = FilterTableView.this.m_filterPanel.getSelectedFilter();
                        FilterTableView.this.m_model.refresh(filter);
                        FilterTableView.this.m_frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
                WAPanel panel = new WAPanel();
                panel.setLayout((LayoutManager)new GridBagLayout());
                GridBagConstraints gbc_filter = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
                GridBagConstraints gbc_table = new GridBagConstraints(0, 1, 1, 1, 1.0, 100.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
                panel.add((Component)((Object)this.m_filterPanel), (Object)gbc_filter);
                panel.add((Component)this.m_customTable, (Object)gbc_table);
                this.m_view = new JScrollPane((Component)panel);
            }
            return this.m_view;
        }
        if (this.m_customTable == null) {
            this.m_customTable = new FilterTablePane(this.m_model, "SCHMGR_TABLEVIEW");
        }
        this.m_customTable.setRowHeaderVisible(false);
        return this.m_customTable;
    }

    public FilterTablePane getFilterTablePane() {
        return this.m_customTable;
    }

    public void updateModel(int rows) {
        this.m_customTable.refresh(rows);
    }

    public void pluginChange(PluginChangeEvent evt) {
        CustomViewInterface view;
        List childList = evt.getPairList();
        IntObjPair ioPair = (IntObjPair)childList.get(0);
        Object obj = ioPair.getChild();
        NodeInterface parent = evt.getParentNode();
        int eventType = evt.getEventType();
        if (eventType == 0 && (view = parent.getCustomView()) instanceof FilterTableView) {
            FilterTableView v = (FilterTableView)view;
            v.m_model.pluginChange(evt);
        }
        if (this.m_node == obj) {
            this.m_model.pluginChange(evt);
        } else if (this.m_node == parent) {
            this.m_model.pluginChange(evt);
        }
    }
}

