/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.filter.visuals;

import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.filter.visuals.ValueListBox;
import com.sas.console.plugins.NodeInterface;
import com.sas.filter.model.FilterRule;
import com.sas.filter.model.FilterSelector;
import com.sas.filter.model.FilterUtil;
import com.sas.plugins.PluginResourceBundle;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractTableColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class FilterManagementDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FilterManagementDialog.class);
    private Frame m_frame;
    private NodeInterface m_node;
    private WorkspaceFile m_work;
    private WAPanel m_mainpanel;
    private JComboBox m_cmbFilterList;
    private JTextPane m_description;
    private int m_selectedIndex;
    private NeoTableModelInterface m_tableModel;
    private List<FilterSelector> m_filters;
    private SimpleDateFormat m_formatter = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
    private Properties m_renameList = new Properties();

    public FilterManagementDialog(Frame owner, List<FilterSelector> listOfFilters, FilterSelector defaultfilter, NeoTableModelInterface tableModel, WorkspaceFile work, NodeInterface node) {
        super(owner, m_bundle.getString("FilterManagementDialog.Title.txt"), true);
        this.m_frame = owner;
        this.m_work = work;
        this.m_node = node;
        this.m_tableModel = tableModel;
        this.m_filters = listOfFilters;
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_filter_options");
        this.__initialize(defaultfilter);
        this.m_formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void dispose() {
        super.dispose();
        this.m_frame = null;
        this.m_node = null;
        this.m_mainpanel = null;
        this.m_description = null;
        this.m_tableModel = null;
    }

    public List<FilterSelector> getFilters() {
        return this.m_filters;
    }

    public FilterSelector getSelectedFilter() {
        return (FilterSelector)this.m_cmbFilterList.getSelectedItem();
    }

    public void makeVisible() {
        Workspace.getWorkspace().setStatusText("");
        super.show();
    }

    private void __initialize(FilterSelector defaultfilter) {
        FilterSelector filter;
        String name;
        String desc;
        JLabel instructionsNew = new JLabel(m_bundle.getString("FilterManagementDialog.Instructions.New.txt"));
        JLabel instructionsEdit = new JLabel(m_bundle.getString("FilterManagementDialog.Instructions.Edit.txt"));
        this.m_cmbFilterList = new JComboBox();
        this.m_cmbFilterList.setModel(new DefaultComboBoxModel<Object>(this.m_filters.toArray()));
        this.m_cmbFilterList.setToolTipText(m_bundle.getString("FilterManagementDialog.Filter.ToolTip.txt"));
        this.m_cmbFilterList.setEditable(true);
        String filterText = m_bundle.getString("FilterManagementDialog.Filter.txt");
        JLabel lblFilter = new JLabel(Util.getLabelWithoutMnemonic((String)filterText));
        lblFilter.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)filterText));
        lblFilter.setLabelFor(this.m_cmbFilterList);
        this.m_description = new JTextPane();
        JScrollPane description = new JScrollPane(this.m_description, 20, 31);
        description.setPreferredSize(new Dimension(400, 75));
        String descText = m_bundle.getString("FilterManagementDialog.FilterDesc.txt");
        JLabel lblDesc = new JLabel(Util.getLabelWithoutMnemonic((String)descText));
        lblDesc.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)descText));
        lblDesc.setToolTipText(m_bundle.getString("FilterManagementDialog.FilterDesc.ToolTip.txt"));
        lblDesc.setLabelFor(description);
        if (defaultfilter != null) {
            for (int i = 0; i < this.m_filters.size(); ++i) {
                if (!this.m_filters.get(i).toString().equals(defaultfilter.toString())) continue;
                this.m_selectedIndex = i;
                this.m_cmbFilterList.setSelectedIndex(this.m_selectedIndex);
                desc = defaultfilter.getDescription();
                if (desc != null) {
                    this.m_description.setText(desc);
                }
                break;
            }
        } else if (this.m_cmbFilterList.getItemCount() != 0) {
            this.m_selectedIndex = 0;
            this.m_cmbFilterList.setSelectedIndex(this.m_selectedIndex);
            FilterSelector filter2 = (FilterSelector)this.m_cmbFilterList.getSelectedItem();
            desc = filter2.getDescription();
            if (desc != null) {
                this.m_description.setText(desc);
            }
        }
        this.m_cmbFilterList.addActionListener(new FilterComboBoxListener());
        this.m_description.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
            }

            @Override
            public void focusLost(FocusEvent fe) {
                FilterSelector filter = (FilterSelector)FilterManagementDialog.this.m_cmbFilterList.getSelectedItem();
                filter.setDescription(FilterManagementDialog.this.m_description.getText());
            }
        });
        JButton saveAs = new JButton(m_bundle.getString("FilterManagementDialog.Button.SaveAs.txt"));
        saveAs.addActionListener(new saveAsActionListener());
        JButton delete = new JButton(m_bundle.getString("FilterManagementDialog.Button.Delete.txt"));
        delete.addActionListener(new deleteActionListener());
        JSeparator separator = new JSeparator(0);
        rulesPanel rulesPanel2 = new rulesPanel(this.m_tableModel, defaultfilter);
        JButton addRow = new JButton(m_bundle.getString("FilterManagementDialog.Button.AddRow.txt"));
        addRow.addActionListener(new addActionListener());
        JButton reset = new JButton(m_bundle.getString("FilterManagementDialog.Button.Reset.txt"));
        reset.addActionListener(new resetActionListener());
        Dimension d = delete.getPreferredSize();
        Dimension s = saveAs.getPreferredSize();
        Dimension a = addRow.getPreferredSize();
        Dimension r = reset.getPreferredSize();
        int w1 = Math.max(d.width, s.width);
        int w2 = Math.max(a.width, r.width);
        int w = Math.max(w1, w2);
        int h1 = Math.max(d.height, s.height);
        int h2 = Math.max(a.height, r.height);
        int h = Math.max(h1, h2);
        Dimension dim = new Dimension(w, h);
        saveAs.setPreferredSize(dim);
        delete.setPreferredSize(dim);
        addRow.setPreferredSize(dim);
        reset.setPreferredSize(dim);
        GridBagConstraints gbc_new = new GridBagConstraints(0, 0, 6, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_edit = new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 11, 2, new Insets(0, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_label = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_filters = new GridBagConstraints(1, 2, 4, 1, 1.0, 1.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_saveas = new GridBagConstraints(5, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_label2 = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_desc = new GridBagConstraints(1, 3, 4, 3, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_delete = new GridBagConstraints(5, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_separator = new GridBagConstraints(0, 6, 6, 2, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_fpanel = new GridBagConstraints(0, 8, 5, 5, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_btnAdd = new GridBagConstraints(5, 8, 1, 1, 1.0, 1.0, 12, 0, new Insets(15, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_btnReset = new GridBagConstraints(5, 9, 1, 1, 1.0, 1.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0);
        this.m_mainpanel = new WAPanel();
        this.m_mainpanel.setLayout((LayoutManager)new GridBagLayout());
        this.m_mainpanel.add((Component)instructionsNew, (Object)gbc_new);
        this.m_mainpanel.add((Component)instructionsEdit, (Object)gbc_edit);
        this.m_mainpanel.add((Component)lblFilter, (Object)gbc_label);
        this.m_mainpanel.add((Component)this.m_cmbFilterList, (Object)gbc_filters);
        this.m_mainpanel.add((Component)saveAs, (Object)gbc_saveas);
        this.m_mainpanel.add((Component)lblDesc, (Object)gbc_label2);
        this.m_mainpanel.add((Component)description, (Object)gbc_desc);
        this.m_mainpanel.add((Component)delete, (Object)gbc_delete);
        this.m_mainpanel.add((Component)separator, (Object)gbc_separator);
        this.m_mainpanel.add((Component)rulesPanel2, (Object)gbc_fpanel);
        this.m_mainpanel.add((Component)addRow, (Object)gbc_btnAdd);
        this.m_mainpanel.add((Component)reset, (Object)gbc_btnReset);
        this.setMainPanel(this.m_mainpanel);
        boolean enablePanel = true;
        Object item = this.m_cmbFilterList.getSelectedItem();
        if (item instanceof FilterSelector && ((name = (filter = (FilterSelector)item).toString()).compareTo(FilterUtil.ALLRULE) == 0 || name.compareTo(FilterUtil.NONERULE) == 0)) {
            enablePanel = false;
        }
        if (enablePanel) {
            saveAs.setEnabled(true);
            delete.setEnabled(true);
            addRow.setEnabled(true);
            reset.setEnabled(true);
            rulesPanel2.setEnabled(true);
        } else {
            saveAs.setEnabled(true);
            delete.setEnabled(false);
            addRow.setEnabled(false);
            reset.setEnabled(false);
            rulesPanel2.setEnabled(false);
        }
    }

    private static String isValidFilterName(String newname) {
        String message = null;
        if (newname == null || newname.length() == 0) {
            message = m_bundle.getString("FilterManagementDialog.MissingName.txt");
        } else if (newname.indexOf(62) != -1 || newname.indexOf(60) != -1) {
            message = m_bundle.messageString("FilterManagementDialog.InvalidFilterName.fmt", (Object)newname);
        }
        return message;
    }

    private boolean filterExists(String name) {
        for (int i = 0; i < this.m_filters.size(); ++i) {
            FilterSelector filter = this.m_filters.get(i);
            if (name.compareTo(filter.toString()) != 0) continue;
            return true;
        }
        return false;
    }

    private FilterSelector updateFilter(String name, FilterSelector filter, String tag) {
        FilterSelector neoFilter = null;
        String oldName = filter.toString();
        String content = filter.generateDefinition();
        if (oldName.compareTo(name) == 0) {
            neoFilter = filter;
        } else {
            for (int i = 0; i < this.m_filters.size(); ++i) {
                FilterSelector f = this.m_filters.get(i);
                if (name.compareTo(f.toString()) != 0) continue;
                neoFilter = f;
                break;
            }
            neoFilter.initFromDefinition(content, true);
            if (oldName.compareTo(FilterUtil.ALLRULE) != 0 && oldName.compareTo(FilterUtil.NONERULE) != 0) {
                FilterSelector junk = FilterUtil.getFilter((WorkspaceFile)this.m_work, (String)oldName, (String)tag);
                filter.initFromDefinition(junk.generateDefinition(), true);
            }
        }
        if (!FilterUtil.updateFilter((WorkspaceFile)this.m_work, (FilterSelector)neoFilter, (String)tag)) {
            Workspace.getWorkspace().setStatusText(m_bundle.messageString("FilterManagementDialog.CannotUpdateRule.fmt", (Object)filter.toString()));
            return null;
        }
        return neoFilter;
    }

    private void resetFilterPanel(FilterSelector filter) {
        this.m_mainpanel.removeAll();
        this.m_mainpanel = null;
        this.setMainPanel(null);
        this.__initialize(filter);
        this.invalidate();
    }

    private void resetFilter(FilterSelector filter) {
        String tag = this.m_tableModel.getFilterPropertyKeyPrefix(this.m_node);
        FilterSelector junk = FilterUtil.getFilter((WorkspaceFile)this.m_work, (String)filter.toString(), (String)tag);
        filter.initFromDefinition(junk.generateDefinition(), true);
    }

    protected boolean onOK() {
        String message = null;
        String tag = this.m_tableModel.getFilterPropertyKeyPrefix(this.m_node);
        int numOfFilters = this.m_filters.size();
        for (int i = 0; i < numOfFilters; ++i) {
            FilterSelector filter = this.m_filters.get(i);
            String filterName = filter.toString();
            if (filterName == null || filterName.length() == 0) {
                MessageUtil.displayMessage((String)m_bundle.getString("FilterManagementDialog.MissingName.txt"), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
            if (filterName.compareTo(FilterUtil.ALLRULE) != 0 && filterName.compareTo(FilterUtil.NONERULE) != 0 && !this.validateFilter(filter)) {
                MessageUtil.displayMessage((String)m_bundle.getString("FilterManagementDialog.InvalidValueForColumn.txt"), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
            if (FilterUtil.updateFilter((WorkspaceFile)this.m_work, (FilterSelector)filter, (String)tag)) continue;
            message = m_bundle.messageString("FilterManagementDialog.CannotUpdateRule.fmt", (Object)filter.toString());
        }
        if (message != null) {
            Workspace.getWorkspace().setStatusText(message);
        }
        return super.onOK();
    }

    protected boolean onCancel() {
        int numOfFilters = this.m_filters.size();
        for (int i = 0; i < numOfFilters; ++i) {
            FilterSelector filter = this.m_filters.get(i);
            String oldname = (String)this.m_renameList.get(filter.toString());
            if (oldname != null && oldname.length() > 0) {
                filter.setName(oldname);
            }
            this.resetFilter(filter);
        }
        return super.onCancel();
    }

    private boolean validateFilter(FilterSelector filter) {
        ArrayList<String> columns = new ArrayList<String>();
        HashMap<String, Vector<FilterRule>> rulesPerColumn = new HashMap<String, Vector<FilterRule>>();
        int numRules = filter.getRuleCount();
        for (int i = 0; i < numRules; ++i) {
            Vector<FilterRule> list;
            FilterRule rule = filter.getRule(i);
            String colname = rule.getColumnName();
            if (!this.validateValue(filter.toString(), colname, rule, this.m_formatter)) {
                rule.setValue("");
                return false;
            }
            if (!columns.contains(colname)) {
                columns.add(colname);
            }
            if ((list = (Vector<FilterRule>)rulesPerColumn.get(colname)) == null) {
                list = new Vector<FilterRule>();
            }
            list.add(rule);
            rulesPerColumn.put(colname, list);
        }
        for (String colname : columns) {
            List list = (List)rulesPerColumn.get(colname);
            if (list.size() <= 1 || this.validateRules(filter.toString(), colname, list)) continue;
            return false;
        }
        return true;
    }

    private boolean validateRules(String filtername, String colname, List<?> rules) {
        int columnType = this.m_tableModel.getColumnType(colname);
        if (columnType == 2) {
            Date gtdate = null;
            Date ltdate = null;
            for (FilterRule rule : rules) {
                try {
                    Date date = this.m_formatter.parse(rule.getValue());
                    switch (rule.getCondition()) {
                        case 4: {
                            if (gtdate == null) {
                                gtdate = date;
                                break;
                            }
                            if (!gtdate.before(date)) break;
                            gtdate = date;
                            break;
                        }
                        case 5: {
                            if (ltdate == null) {
                                ltdate = date;
                                break;
                            }
                            if (!ltdate.after(date)) break;
                            ltdate = date;
                        }
                    }
                }
                catch (ParseException ex) {
                    return false;
                }
            }
            if (gtdate != null && ltdate != null && gtdate.after(ltdate)) {
                MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingDateRulesPerColumn.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        } else if (columnType == 1) {
            Long eqNum = null;
            ArrayList<Long> neNum = null;
            Long gtNum = null;
            Long ltNum = null;
            for (FilterRule rule : rules) {
                Long num = Long.valueOf(rule.getValue());
                switch (rule.getCondition()) {
                    case 4: {
                        if (gtNum == null) {
                            gtNum = num;
                            break;
                        }
                        if (gtNum.compareTo(num) <= 0) break;
                        gtNum = num;
                        break;
                    }
                    case 5: {
                        if (ltNum == null) {
                            ltNum = num;
                            break;
                        }
                        if (ltNum.compareTo(num) >= 0) break;
                        ltNum = num;
                        break;
                    }
                    case 6: {
                        if (eqNum == null) {
                            eqNum = num;
                            break;
                        }
                        if (eqNum.compareTo(num) == 0) break;
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.TwoEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                    case 7: {
                        if (neNum == null) {
                            neNum = new ArrayList<Long>();
                        }
                        neNum.add(num);
                    }
                }
            }
            if (eqNum != null) {
                if (neNum != null) {
                    for (Long neVal : neNum) {
                        if (neVal.compareTo(eqNum) != 0) continue;
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.TwoNEEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                } else {
                    if (gtNum != null && gtNum.compareTo(eqNum) >= 0) {
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.TwoGTEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                    if (ltNum != null && ltNum.compareTo(eqNum) <= 0) {
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.TwoLTEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                }
            } else if (gtNum != null && ltNum != null && gtNum.compareTo(ltNum) >= 0) {
                MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.GTLTValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        } else if (columnType == 3) {
            Double eqNum = null;
            ArrayList<Double> neNum = null;
            Double gtNum = null;
            Double ltNum = null;
            for (FilterRule rule : rules) {
                Double num = Double.valueOf(rule.getValue());
                switch (rule.getCondition()) {
                    case 4: {
                        if (gtNum == null) {
                            gtNum = num;
                            break;
                        }
                        if (gtNum.compareTo(num) <= 0) break;
                        gtNum = num;
                        break;
                    }
                    case 5: {
                        if (ltNum == null) {
                            ltNum = num;
                            break;
                        }
                        if (ltNum.compareTo(num) >= 0) break;
                        ltNum = num;
                        break;
                    }
                    case 6: {
                        if (eqNum == null) {
                            eqNum = num;
                            break;
                        }
                        if (eqNum.compareTo(num) == 0) break;
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.TwoEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                    case 7: {
                        if (neNum == null) {
                            neNum = new ArrayList<Double>();
                        }
                        neNum.add(num);
                    }
                }
            }
            if (eqNum != null) {
                if (neNum != null) {
                    for (Double neVal : neNum) {
                        if (neVal.compareTo(eqNum) != 0) continue;
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.TwoNEEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                } else {
                    if (gtNum != null && gtNum.compareTo(eqNum) >= 0) {
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.TwoGTEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                    if (ltNum != null && ltNum.compareTo(eqNum) <= 0) {
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.TwoLTEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                }
            } else if (gtNum != null && ltNum != null && gtNum.compareTo(ltNum) >= 0) {
                MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingNumRulesPerColumn.GTLTValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        } else if (columnType == 4) {
            com.sas.filter.model.Timestamp eqNum = null;
            ArrayList<com.sas.filter.model.Timestamp> neNum = null;
            com.sas.filter.model.Timestamp gtNum = null;
            com.sas.filter.model.Timestamp ltNum = null;
            for (FilterRule rule : rules) {
                com.sas.filter.model.Timestamp num = (com.sas.filter.model.Timestamp)com.sas.filter.model.Timestamp.valueOf((String)rule.getValue());
                switch (rule.getCondition()) {
                    case 4: {
                        if (gtNum == null) {
                            gtNum = num;
                            break;
                        }
                        if (!gtNum.after((Timestamp)num)) break;
                        gtNum = num;
                        break;
                    }
                    case 5: {
                        if (ltNum == null) {
                            ltNum = num;
                            break;
                        }
                        if (!ltNum.before((Timestamp)num)) break;
                        ltNum = num;
                        break;
                    }
                    case 6: {
                        if (eqNum == null) {
                            eqNum = num;
                            break;
                        }
                        if (eqNum.compareTo((Timestamp)num) == 0) break;
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingTimestampRulesPerColumn.TwoEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                    case 7: {
                        if (neNum == null) {
                            neNum = new ArrayList<com.sas.filter.model.Timestamp>();
                        }
                        neNum.add(num);
                    }
                }
            }
            if (eqNum != null) {
                if (neNum != null) {
                    for (com.sas.filter.model.Timestamp neVal : neNum) {
                        if (neVal.compareTo((Timestamp)eqNum) != 0) continue;
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingTimestampRulesPerColumn.TwoNEEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                } else {
                    if (gtNum != null && gtNum.compareTo(eqNum) >= 0) {
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingTimestampRulesPerColumn.TwoGTEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                    if (ltNum != null && ltNum.compareTo(eqNum) <= 0) {
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingTimestampRulesPerColumn.TwoLTEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                }
            } else if (gtNum != null && ltNum != null && gtNum.compareTo(ltNum) >= 0) {
                MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingTimestampRulesPerColumn.GTLTValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        } else {
            String eqStr = null;
            ArrayList<String> cStr = null;
            String sStr = null;
            String eStr = null;
            ArrayList<String> mStr = null;
            for (FilterRule rule : rules) {
                String str = rule.getValue();
                switch (rule.getCondition()) {
                    case 1: {
                        if (sStr == null) {
                            sStr = str;
                            break;
                        }
                        if (!sStr.startsWith(str) && !str.startsWith(sStr)) {
                            MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingStrRulesPerColumn.TwoStartValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                            return false;
                        }
                        if (!sStr.startsWith(str)) break;
                        sStr = str;
                        break;
                    }
                    case 2: {
                        if (eStr == null) {
                            eStr = str;
                            break;
                        }
                        if (!eStr.startsWith(str) && !str.startsWith(eStr)) {
                            MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingStrRulesPerColumn.TwoEndValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                            return false;
                        }
                        if (!eStr.endsWith(str)) break;
                        eStr = str;
                        break;
                    }
                    case 0: {
                        if (eqStr == null) {
                            eqStr = str;
                            break;
                        }
                        if (eqStr.compareTo(str) == 0) break;
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingStrRulesPerColumn.TwoEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                    case 3: {
                        if (cStr == null) {
                            cStr = new ArrayList<String>();
                        }
                        cStr.add(str);
                        break;
                    }
                    case 8: {
                        if (mStr == null) {
                            mStr = new ArrayList<String>();
                        }
                        mStr.add(str);
                    }
                }
            }
            if (eqStr != null) {
                if (cStr != null) {
                    for (String val : cStr) {
                        if (eqStr.indexOf(val) != -1) continue;
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingStrRulesPerColumn.TwoCEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                } else if (mStr == null) {
                    if (sStr != null && !eqStr.startsWith(sStr)) {
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingStrRulesPerColumn.TwoSEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                    if (eStr != null && !eqStr.endsWith(eStr)) {
                        MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.ConflictingStrRulesPerColumn.TwoEEQValues.fmt", (Object)filtername, (Object)colname), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean validateValue(String filtername, String colname, FilterRule rule, DateFormat formatter) {
        int columnType = this.m_tableModel.getColumnType(colname);
        String value = rule.getValue();
        if (columnType == 2) {
            Date date = null;
            try {
                date = formatter.parse(value);
                return true;
            }
            catch (ParseException ex) {
                try {
                    SimpleDateFormat neoformatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
                    neoformatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                    date = neoformatter.parse(value);
                    rule.setValue(formatter.format(date));
                    return true;
                }
                catch (ParseException e) {
                    String message = m_bundle.messageString("FilterManagementDialog.InvalidValue.NotDate.fmt", (Object)colname, (Object)"ddMMMyyyy:HH:mm:ss");
                    if (filtername != null) {
                        message = m_bundle.messageString("FilterManagementDialog.FilterInvalidValue.NotDate.fmt", (Object)filtername, (Object)colname, (Object)"ddMMMyyyy:HH:mm:ss");
                    }
                    MessageUtil.displayMessage((String)message, (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                    return false;
                }
            }
        }
        if (columnType == 1) {
            try {
                Long.valueOf(value);
                return true;
            }
            catch (NumberFormatException nfe) {
                String message = m_bundle.messageString("FilterManagementDialog.InvalidValue.NotNumeric.fmt", (Object)colname, (Object)"ddMMMyyyy:HH:mm:ss");
                if (filtername != null) {
                    message = m_bundle.messageString("FilterManagementDialog.FilterInvalidValue.NotNumeric.fmt", (Object)filtername, (Object)colname, (Object)"ddMMMyyyy:HH:mm:ss");
                }
                MessageUtil.displayMessage((String)message, (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        }
        if (columnType == 3) {
            try {
                Double.valueOf(value);
                return true;
            }
            catch (NumberFormatException ex) {
                String message = m_bundle.messageString("FilterManagementDialog.InvalidValue.NotNumeric.fmt", (Object)colname, (Object)"ddMMMyyyy:HH:mm:ss");
                if (filtername != null) {
                    message = m_bundle.messageString("FilterManagementDialog.FilterInvalidValue.NotNumeric.fmt", (Object)filtername, (Object)colname, (Object)"ddMMMyyyy:HH:mm:ss");
                }
                MessageUtil.displayMessage((String)message, (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        }
        if (columnType == 4) {
            try {
                com.sas.filter.model.Timestamp.valueOf((String)value);
                return true;
            }
            catch (IllegalArgumentException ex) {
                String message = m_bundle.messageString("FilterManagementDialog.InvalidValue.NotTimestamp.fmt", (Object)colname, (Object)"ddMMMyyyy:HH:mm:ss");
                if (filtername != null) {
                    message = m_bundle.messageString("FilterManagementDialog.FilterInvalidValue.NotTimestamp.fmt", (Object)filtername, (Object)colname, (Object)"ddMMMyyyy:HH:mm:ss");
                }
                MessageUtil.displayMessage((String)message, (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        }
        return true;
    }

    private FilterSelector addFilter(String name, FilterSelector filter) {
        String oldName = filter.toString();
        String content = filter.generateDefinition();
        String tag = this.m_tableModel.getFilterPropertyKeyPrefix(this.m_node);
        if (this.filterExists(name)) {
            int rc = MessageUtil.displayMessage((String)m_bundle.messageString("FilterManagementDialog.FilterAlreadyExists.fmt", (Object)name), (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)1, (int)0);
            if (rc == 1) {
                return null;
            }
            return this.updateFilter(name, filter, tag);
        }
        FilterSelector temp = new FilterSelector(name);
        temp.initFromDefinition(content, true);
        this.m_filters.add(temp);
        this.m_cmbFilterList.addItem(temp);
        this.m_cmbFilterList.setSelectedItem(temp);
        FilterUtil.writeFilter((WorkspaceFile)this.m_work, (FilterSelector)temp, (String)tag);
        FilterSelector junk = FilterUtil.getFilter((WorkspaceFile)this.m_work, (String)oldName, (String)tag);
        filter.initFromDefinition(junk.generateDefinition(), true);
        return temp;
    }

    private class FilterComboBoxListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = FilterManagementDialog.this.m_cmbFilterList.getSelectedItem();
            FilterSelector filter = null;
            if (obj != null && !FilterManagementDialog.this.m_filters.isEmpty()) {
                if (!(obj instanceof FilterSelector)) {
                    filter = (FilterSelector)FilterManagementDialog.this.m_filters.get(FilterManagementDialog.this.m_selectedIndex);
                    String message = FilterManagementDialog.isValidFilterName(obj.toString());
                    if (message != null) {
                        MessageUtil.displayMessage((String)message, (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0);
                        Workspace.getWorkspace().setStatusText(message);
                    } else {
                        String tag = FilterManagementDialog.this.m_tableModel.getFilterPropertyKeyPrefix(FilterManagementDialog.this.m_node);
                        if (filter.toString().compareTo(FilterUtil.ALLRULE) == 0 || filter.toString().compareTo(FilterUtil.NONERULE) == 0) {
                            filter = FilterManagementDialog.this.addFilter(obj.toString(), filter);
                            if (filter == null) {
                                return;
                            }
                            FilterManagementDialog.this.m_renameList.setProperty(obj.toString(), "");
                        } else {
                            FilterUtil.removeFilter((WorkspaceFile)FilterManagementDialog.this.m_work, (FilterSelector)filter, (String)tag);
                            FilterManagementDialog.this.m_renameList.setProperty(obj.toString(), filter.toString());
                            filter.setName(obj.toString());
                            FilterUtil.writeFilter((WorkspaceFile)FilterManagementDialog.this.m_work, (FilterSelector)filter, (String)tag);
                        }
                    }
                } else {
                    filter = (FilterSelector)obj;
                }
            }
            FilterManagementDialog.this.resetFilterPanel(filter);
        }
    }

    private class saveAsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String name = null;
            int retc = 1;
            while (name == null) {
                FilterNameDialog dia = new FilterNameDialog(FilterManagementDialog.this.m_frame, m_bundle.getString("FilterManagementDialog.FilterName.Title.txt"));
                dia.setHelpProduct("scheduler");
                dia.setHelpTopic("window_filter_saveas");
                dia.show();
                retc = dia.getReturnValue();
                name = dia.getName();
                dia.dispose();
                if (retc != 1) continue;
                String message = FilterManagementDialog.isValidFilterName(name);
                if (retc != 1 || message == null) continue;
                MessageUtil.displayMessage((String)message, (String)m_bundle.getString("FilterManagementDialog.Title.txt"), (int)0);
                name = null;
            }
            if (retc == 2) {
                return;
            }
            Object obj = FilterManagementDialog.this.m_cmbFilterList.getSelectedItem();
            FilterSelector filter = (FilterSelector)obj;
            FilterSelector neoFilter = FilterManagementDialog.this.addFilter(name, filter);
            if (neoFilter != null && !neoFilter.equals(filter)) {
                FilterManagementDialog.this.resetFilterPanel(neoFilter);
            }
        }
    }

    private class deleteActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            FilterSelector filter = (FilterSelector)FilterManagementDialog.this.m_cmbFilterList.getSelectedItem();
            FilterManagementDialog.this.m_filters.remove(filter);
            FilterManagementDialog.this.m_cmbFilterList.removeItem(filter);
            FilterManagementDialog.this.m_selectedIndex = 0;
            if (FilterManagementDialog.this.m_cmbFilterList.getItemCount() > 0) {
                FilterManagementDialog.this.m_cmbFilterList.setSelectedIndex(FilterManagementDialog.this.m_selectedIndex);
            }
            if (filter != null && filter.getDescription() != null) {
                FilterManagementDialog.this.m_description.setText(filter.getDescription());
            }
            String tag = FilterManagementDialog.this.m_tableModel.getFilterPropertyKeyPrefix(FilterManagementDialog.this.m_node);
            FilterUtil.removeFilter((WorkspaceFile)FilterManagementDialog.this.m_work, (FilterSelector)filter, (String)tag);
        }
    }

    private class rulesPanel
    extends JScrollPane {
        private static final long serialVersionUID = 1L;
        private FilterSelector mc_filter;
        private WAPanel mc_panel;

        public rulesPanel(NeoTableModelInterface tableModel, FilterSelector filter) {
            this.mc_filter = filter;
            this.__myinitialize(tableModel);
        }

        public FilterSelector getFilter() {
            return this.mc_filter;
        }

        private void __myinitialize(NeoTableModelInterface tableModel) {
            int i;
            TitledBorder title = new TitledBorder(m_bundle.getString("FilterManagementDialog.BottomPanel.Title.txt"));
            this.setBorder(title);
            GridBagConstraints gbc_AND = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_panel = new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0);
            GridBagConstraints gbc_delete = new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0);
            this.mc_panel = new WAPanel();
            this.mc_panel.setLayout((LayoutManager)new GridBagLayout());
            String andString = m_bundle.getString("FilterManagementDialog.Label.And.txt");
            ImageIcon deleteIcon = Resources.getImageIcon((String)"DeleteBlack.gif");
            int numRules = this.mc_filter != null ? this.mc_filter.getRuleCount() : 0;
            for (i = 0; i < numRules; ++i) {
                FilterRule rule = this.mc_filter.getRule(i);
                rulePanel rpanel = new rulePanel(FilterManagementDialog.this.m_tableModel, rule);
                gbc_AND.gridy = i;
                gbc_panel.gridy = i;
                gbc_delete.gridy = i;
                if (i == 0) {
                    this.mc_panel.add((Component)new JLabel(""), (Object)gbc_AND);
                } else {
                    this.mc_panel.add((Component)new JLabel(andString), (Object)gbc_AND);
                }
                this.mc_panel.add((Component)((Object)rpanel), (Object)gbc_panel);
                JButton delete = new JButton();
                delete.setIcon(deleteIcon);
                delete.addActionListener(new deleteActionListener(rule));
                this.mc_panel.add((Component)delete, (Object)gbc_delete);
            }
            i = numRules;
            while (i < 10 - numRules) {
                gbc_AND.gridy = i;
                gbc_panel.gridy = i;
                gbc_delete.gridy = i++;
                this.mc_panel.add((Component)new JLabel(" "), (Object)gbc_AND);
                this.mc_panel.add((Component)new JLabel(" "), (Object)gbc_panel);
                this.mc_panel.add((Component)new JLabel(" "), (Object)gbc_delete);
            }
            this.setViewportView((Component)this.mc_panel);
            this.setVerticalScrollBarPolicy(20);
            this.setLayout(new ScrollPaneLayout());
            this.setPreferredSize(new Dimension(475, 250));
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            int num = this.mc_panel.getComponentCount();
            for (int x = 0; x < num; ++x) {
                Component c = this.mc_panel.getComponent(x);
                if (!(c instanceof rulePanel) && !(c instanceof JButton)) continue;
                c.setEnabled(enabled);
            }
        }

        private class rulePanel
        extends WAPanel {
            private static final long serialVersionUID = 1L;
            private FilterRule mc_rule;
            private JComboBox mc_cmbName;
            private JComboBox mc_cmbOper;
            private JComponent mc_value;
            private JTextField mc_valueText;
            private JComboBox mc_valueBox;
            private ValueListBox mc_valueList;

            public rulePanel(NeoTableModelInterface tableModel, FilterRule rule) {
                this.mc_rule = rule;
                this.__myinitialize(tableModel);
            }

            public FilterRule getRule() {
                return this.mc_rule;
            }

            private void __myinitialize(NeoTableModelInterface tableModel) {
                String namestr = this.mc_rule.getColumnName();
                this.mc_cmbName = new JComboBox();
                int numCols = tableModel.getColumnCount();
                for (int i = 0; i < numCols; ++i) {
                    WsAbstractTableColumn col = tableModel.getColumn(i);
                    this.mc_cmbName.addItem(col.getName());
                    if (col.getName().compareTo(namestr) != 0) continue;
                    this.mc_cmbName.setSelectedIndex(i);
                }
                this.mc_rule.setColumnName((String)this.mc_cmbName.getSelectedItem());
                Dimension dim = this.mc_cmbName.getPreferredSize();
                this.mc_cmbName.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        rulePanel.this.mc_rule.setColumnName((String)rulePanel.this.mc_cmbName.getSelectedItem());
                        rulePanel.this.setConditionCombo(rulePanel.this.mc_cmbOper, rulePanel.this.mc_rule);
                        rulePanel.this.mc_value = rulePanel.this.setValueComponent();
                        FilterManagementDialog.this.resetFilterPanel(rulesPanel.this.mc_filter);
                    }
                });
                this.mc_cmbOper = new JComboBox();
                this.setConditionCombo(this.mc_cmbOper, this.mc_rule);
                this.mc_cmbOper.setPreferredSize(dim);
                this.mc_cmbOper.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        rulePanel.this.mc_rule.setCondition(FilterRule.getCondition((String)((String)rulePanel.this.mc_cmbOper.getSelectedItem())));
                        rulePanel.this.mc_value = rulePanel.this.setValueComponent();
                        FilterManagementDialog.this.resetFilterPanel(rulesPanel.this.mc_filter);
                    }
                });
                this.mc_value = this.setValueComponent();
                this.mc_value.setPreferredSize(dim);
                GridBagConstraints gbc_Name = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
                GridBagConstraints gbc_Oper = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 5, 0, 0), 0, 0);
                GridBagConstraints gbc_Value = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 12, 2, new Insets(0, 5, 0, 0), 0, 0);
                this.setLayout(new GridBagLayout());
                this.add(this.mc_cmbName, gbc_Name);
                this.add(this.mc_cmbOper, gbc_Oper);
                this.add(this.mc_value, gbc_Value);
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.mc_cmbName.setEnabled(enabled);
                this.mc_cmbOper.setEnabled(enabled);
                this.mc_value.setEnabled(enabled);
            }

            private void setConditionCombo(JComboBox box, FilterRule rule) {
                box.removeAllItems();
                int columnType = FilterManagementDialog.this.m_tableModel.getColumnType(rule.getColumnName());
                if (columnType == 2) {
                    box.addItem(FilterRule.getConditionName((int)4));
                    box.addItem(FilterRule.getConditionName((int)5));
                    switch (rule.getCondition()) {
                        case 4: {
                            this.mc_cmbOper.setSelectedIndex(0);
                            break;
                        }
                        case 5: {
                            this.mc_cmbOper.setSelectedIndex(1);
                        }
                    }
                } else if (columnType == 1) {
                    box.addItem(FilterRule.getConditionName((int)4));
                    box.addItem(FilterRule.getConditionName((int)5));
                    box.addItem(FilterRule.getConditionName((int)6));
                    box.addItem(FilterRule.getConditionName((int)7));
                    switch (rule.getCondition()) {
                        case 4: {
                            this.mc_cmbOper.setSelectedIndex(0);
                            break;
                        }
                        case 5: {
                            this.mc_cmbOper.setSelectedIndex(1);
                            break;
                        }
                        case 6: {
                            this.mc_cmbOper.setSelectedIndex(2);
                            break;
                        }
                        case 7: {
                            this.mc_cmbOper.setSelectedIndex(3);
                        }
                    }
                } else if (columnType == 3) {
                    box.addItem(FilterRule.getConditionName((int)4));
                    box.addItem(FilterRule.getConditionName((int)5));
                    box.addItem(FilterRule.getConditionName((int)6));
                    box.addItem(FilterRule.getConditionName((int)7));
                    switch (rule.getCondition()) {
                        case 4: {
                            this.mc_cmbOper.setSelectedIndex(0);
                            break;
                        }
                        case 5: {
                            this.mc_cmbOper.setSelectedIndex(1);
                            break;
                        }
                        case 6: {
                            this.mc_cmbOper.setSelectedIndex(2);
                            break;
                        }
                        case 7: {
                            this.mc_cmbOper.setSelectedIndex(3);
                        }
                    }
                } else if (columnType == 4) {
                    box.addItem(FilterRule.getConditionName((int)4));
                    box.addItem(FilterRule.getConditionName((int)5));
                    box.addItem(FilterRule.getConditionName((int)6));
                    box.addItem(FilterRule.getConditionName((int)7));
                    switch (rule.getCondition()) {
                        case 4: {
                            this.mc_cmbOper.setSelectedIndex(0);
                            break;
                        }
                        case 5: {
                            this.mc_cmbOper.setSelectedIndex(1);
                            break;
                        }
                        case 6: {
                            this.mc_cmbOper.setSelectedIndex(2);
                            break;
                        }
                        case 7: {
                            this.mc_cmbOper.setSelectedIndex(3);
                        }
                    }
                } else {
                    box.addItem(FilterRule.getConditionName((int)0));
                    box.addItem(FilterRule.getConditionName((int)3));
                    box.addItem(FilterRule.getConditionName((int)1));
                    box.addItem(FilterRule.getConditionName((int)2));
                    if (FilterManagementDialog.this.m_tableModel.hasValueSet(this.mc_rule.getColumnName())) {
                        box.addItem(FilterRule.getConditionName((int)8));
                    }
                    switch (rule.getCondition()) {
                        case 0: {
                            this.mc_cmbOper.setSelectedIndex(0);
                            break;
                        }
                        case 3: {
                            this.mc_cmbOper.setSelectedIndex(1);
                            break;
                        }
                        case 1: {
                            this.mc_cmbOper.setSelectedIndex(2);
                            break;
                        }
                        case 2: {
                            this.mc_cmbOper.setSelectedIndex(3);
                            break;
                        }
                        case 8: {
                            this.mc_cmbOper.setSelectedIndex(4);
                        }
                    }
                }
            }

            private JComponent setValueComponent() {
                boolean hasSetValues = false;
                boolean multiSelect = false;
                int columnType = FilterManagementDialog.this.m_tableModel.getColumnType(this.mc_rule.getColumnName());
                if (FilterManagementDialog.this.m_tableModel.hasValueSet(this.mc_rule.getColumnName())) {
                    block0 : switch (columnType) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 4: {
                            switch (this.mc_rule.getCondition()) {
                                case 0: 
                                case 6: 
                                case 7: {
                                    hasSetValues = true;
                                    multiSelect = false;
                                    break block0;
                                }
                                case 8: {
                                    hasSetValues = true;
                                    multiSelect = true;
                                    break block0;
                                }
                            }
                            hasSetValues = false;
                            multiSelect = false;
                            break;
                        }
                        default: {
                            hasSetValues = true;
                        }
                    }
                }
                if (hasSetValues) {
                    if (multiSelect) {
                        List<?> values = FilterManagementDialog.this.m_tableModel.getValueSet(this.mc_rule.getColumnName());
                        this.mc_valueList = new ValueListBox(FilterManagementDialog.this.m_frame, values.toArray());
                        this.mc_valueList.setSelectedValue(this.mc_rule.getValue());
                        this.mc_valueList.addListSelectionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                rulePanel.this.mc_rule.setValue(rulePanel.this.mc_valueList.getSelectedValue().toString());
                            }
                        });
                        return this.mc_valueList;
                    }
                    this.mc_valueBox = new JComboBox();
                    this.mc_valueBox.setRenderer(new MyCellRenderer(columnType));
                    textbox selected = null;
                    List<?> values = FilterManagementDialog.this.m_tableModel.getValueSet(this.mc_rule.getColumnName());
                    if (values != null) {
                        for (Object obj : values) {
                            String value = obj.toString();
                            textbox str = new textbox(value);
                            this.mc_valueBox.addItem(str);
                            if (value.compareTo(this.mc_rule.getValue()) != 0) continue;
                            selected = str;
                        }
                    }
                    if (selected != null) {
                        this.mc_valueBox.setSelectedItem(selected);
                    } else {
                        this.mc_valueBox.setSelectedIndex(-1);
                    }
                    this.mc_valueBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            rulePanel.this.mc_rule.setValue(rulePanel.this.mc_valueBox.getSelectedItem().toString());
                        }
                    });
                    return this.mc_valueBox;
                }
                this.mc_valueText = new JTextField(this.mc_rule.getValue());
                String tooltip = FilterManagementDialog.this.m_tableModel.getToolTip(this.mc_rule.getColumnName());
                if (tooltip != null) {
                    this.mc_valueText.setToolTipText(tooltip);
                }
                this.mc_valueText.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        FilterRule temp = new FilterRule();
                        temp.setValue(rulePanel.this.mc_valueText.getText());
                        if (FilterManagementDialog.this.validateValue(null, rulePanel.this.mc_rule.getColumnName(), temp, FilterManagementDialog.this.m_formatter)) {
                            String value = temp.getValue();
                            if (value.compareTo(rulePanel.this.mc_valueText.getText()) != 0) {
                                rulePanel.this.mc_valueText.setText(value);
                            }
                            rulePanel.this.mc_rule.setValue(value);
                        } else {
                            rulePanel.this.mc_valueText.setText("");
                        }
                    }
                });
                this.mc_valueText.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        FilterRule temp = new FilterRule();
                        temp.setValue(rulePanel.this.mc_valueText.getText());
                        if (FilterManagementDialog.this.validateValue(null, rulePanel.this.mc_rule.getColumnName(), temp, FilterManagementDialog.this.m_formatter)) {
                            String value = temp.getValue();
                            if (value.compareTo(rulePanel.this.mc_valueText.getText()) != 0) {
                                rulePanel.this.mc_valueText.setText(value);
                            }
                            rulePanel.this.mc_rule.setValue(value);
                        } else {
                            rulePanel.this.mc_valueText.setText("");
                        }
                    }
                });
                return this.mc_valueText;
            }
        }

        private class deleteActionListener
        implements ActionListener {
            FilterRule mc_rule = null;

            public deleteActionListener(FilterRule rule) {
                this.mc_rule = rule;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                rulesPanel.this.mc_filter.removeRule(this.mc_rule);
                FilterManagementDialog.this.resetFilterPanel(rulesPanel.this.mc_filter);
            }
        }

        private class textbox
        extends JComponent {
            private static final long serialVersionUID = 1L;
            private String mc_value;

            public textbox(String value) {
                this.mc_value = value;
            }

            @Override
            public String toString() {
                return this.mc_value;
            }

            @Override
            public String getToolTipText() {
                return this.mc_value;
            }
        }

        private class MyCellRenderer
        extends BasicComboBoxRenderer {
            private static final long serialVersionUID = 1L;
            int mc_type;

            public MyCellRenderer(int type) {
                this.mc_type = type;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                    if (-1 < index) {
                        list.setToolTipText(value.toString());
                    }
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setFont(list.getFont());
                String text = "";
                if (this.mc_type == 2) {
                    text = "ddMMMyyyy:HH:mm:ss";
                } else if (value != null) {
                    text = value.toString();
                }
                this.setText(text);
                return this;
            }
        }
    }

    private class addActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            FilterSelector filter = (FilterSelector)FilterManagementDialog.this.m_cmbFilterList.getSelectedItem();
            if (filter == null) {
                filter = new FilterSelector(m_bundle.getString("FilterManagementDialog.newfilter.name.txt"));
                FilterManagementDialog.this.m_filters.add(filter);
                FilterManagementDialog.this.m_cmbFilterList.addItem(filter);
                FilterManagementDialog.this.m_cmbFilterList.setSelectedItem(filter);
            }
            filter.addRule(new FilterRule("", 0, ""));
            FilterManagementDialog.this.resetFilterPanel(filter);
        }
    }

    private class resetActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            FilterSelector filter = (FilterSelector)FilterManagementDialog.this.m_cmbFilterList.getSelectedItem();
            FilterManagementDialog.this.resetFilter(filter);
            FilterManagementDialog.this.resetFilterPanel(filter);
        }
    }

    private static class FilterNameDialog
    extends WAStandardDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private NamePanel mc_panel = new NamePanel();
        private String mc_name;

        public FilterNameDialog(Frame owner, String title) {
            super(owner, title, true);
            super.setMainPanel((WAPanel)this.mc_panel);
        }

        public void dispose() {
            if (this.mc_panel != null) {
                this.mc_name = this.mc_panel.getName();
            }
            super.dispose();
            this.mc_panel = null;
        }

        public String getName() {
            if (this.mc_panel != null) {
                this.mc_name = this.mc_panel.getName();
            }
            return this.mc_name;
        }

        private static class NamePanel
        extends WAPanel {
            private static final long serialVersionUID = 1L;
            private JLabel mc_nameLabel = new JLabel(FilterManagementDialog.access$300().getString("FilterManagementDialog.FilterName.Label.Name.txt"));
            private JTextField mc_nameText = new JTextField(15);
            private String mc_nameStr;

            public NamePanel() {
                this.__layoutWidgets();
            }

            public void saveSettingsAndCleanUp() {
                if (this.mc_nameText != null) {
                    this.mc_nameStr = this.mc_nameText.getText();
                }
                this.mc_nameLabel = null;
                this.mc_nameText = null;
            }

            public boolean validateData() {
                this.mc_nameStr = this.mc_nameText.getText();
                return this.mc_nameStr != null && this.mc_nameStr.indexOf(62) == -1 && this.mc_nameStr.indexOf(60) == -1;
            }

            public String getName() {
                if (this.mc_nameText != null) {
                    this.mc_nameStr = this.mc_nameText.getText();
                }
                return this.mc_nameStr;
            }

            private void __layoutWidgets() {
                GridBagLayout gridBagLayout = new GridBagLayout();
                this.setLayout(gridBagLayout);
                int gridy = 0;
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy;
                gbc.anchor = 17;
                gbc.fill = 0;
                gbc.insets = new Insets(12, 12, 0, 0);
                gridBagLayout.setConstraints(this.mc_nameLabel, gbc);
                this.add(this.mc_nameLabel);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = gridy;
                gbc.weightx = 1.0;
                gbc.anchor = 17;
                gbc.fill = 2;
                gbc.insets = new Insets(12, 12, 0, 12);
                gridBagLayout.setConstraints(this.mc_nameText, gbc);
                this.add(this.mc_nameText);
            }
        }
    }
}

