/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.tilechart;

import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.tilechart.TileChartModel;
import com.sas.graphics.util.cell.CategorizationInfo;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ColorRampLegendCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.cell.MatrixModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.RangeInfo;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.tilechart.TileChartCell;
import com.sas.graphics.util.cell.tilechart.TileChartCellModel;
import com.sas.graphics.util.cell.tilechart.TileChartLegendCell;
import com.sas.graphics.util.cell.tilechart.TileChartMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.DiscreteRangeToColorMapper;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class TileChartMatrix
extends Matrix {
    private transient TileChartMatrixModel model;
    private transient Variable[] idVariableArray;
    private transient double lowCV;
    private transient double highCV;
    private TileChartCell tileCell;
    private transient LegendCell colorRampLegend;
    private List tileCellList;
    private TileCellFactory tileCellFactory = new TileCellFactory();
    private TileChartCellModel tileChartCellModel;
    private Variable sizeVtkVars;

    public TileChartMatrix(Channel channel) {
        super(channel);
    }

    public void setModel(TileChartMatrixModel newModel) {
        if (this.model != newModel) {
            TileChartMatrixModel oldModel = this.model;
            this.model = newModel;
            this.reconstruct();
            this.firePropertyChange("model", oldModel, newModel);
        }
    }

    public TileChartMatrixModel getModel() {
        return this.model;
    }

    @Override
    protected MatrixModel getMatrixModel() {
        return this.getModel();
    }

    @Override
    protected synchronized void construct() {
        ColorMapper colorMapper;
        this.colorRampLegend = null;
        TileChartMatrixModel chartMatrixModel = this.getModel();
        if (chartMatrixModel == null) {
            throw new IllegalStateException(RB.getStringResource("graphModelNotSpecified.ex.txt"));
        }
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            return;
        }
        if (dataSource.getVariable(chartMatrixModel.getIdRole()) == null) {
            throw new IllegalStateException(RB.getStringResource("idVariableNotSpecified.ex.txt"));
        }
        this.sizeVtkVars = dataSource.getVariable(chartMatrixModel.getSizeRole(), 0);
        boolean validSize = this.sizeVtkVars != null;
        validSize = this.sizeVtkVars instanceof NumericVariable;
        boolean allMissingOrNonPositiveData = true;
        int numObs = validSize ? this.sizeVtkVars.getValueCount() : 0;
        for (int obs = 0; obs < numObs && allMissingOrNonPositiveData; ++obs) {
            allMissingOrNonPositiveData = this.sizeVtkVars.isMissing(obs) || (Double)Variable.getValue((Variable)this.sizeVtkVars, (int)obs, (boolean)false) <= 0.0;
        }
        if (!validSize || allMissingOrNonPositiveData) {
            this.setDataSource(null, RB.getStringResource("TileChartMatrix.", "InvalidSizeData.txt"));
            throw new IllegalStateException(RB.getStringResource("TileChartMatrix.", "InvalidSizeData.txt"));
        }
        this.idVariableArray = dataSource.getVariable(chartMatrixModel.getIdRole());
        Variable colorVtkVar = dataSource.getVariable(chartMatrixModel.getColorRole(), 0);
        dataSource.getVariable(chartMatrixModel.getWebLinkRole());
        this.tileChartCellModel = new TileChartCellModel();
        this.tileChartCellModel.setIdRole(chartMatrixModel.getIdRole());
        this.tileChartCellModel.setSizeRole(chartMatrixModel.getSizeRole());
        this.tileChartCellModel.setColorRole(chartMatrixModel.getColorRole());
        this.tileChartCellModel.setXRole(chartMatrixModel.getXRole());
        this.tileChartCellModel.setYRole(chartMatrixModel.getYRole());
        this.tileChartCellModel.setAuxiliaryRole(chartMatrixModel.getAuxiliaryRole());
        this.tileChartCellModel.setDataTipRole(chartMatrixModel.getDataTipRole());
        this.tileChartCellModel.setWebLinkRole(chartMatrixModel.getWebLinkRole());
        this.tileChartCellModel.setSizeSelectionRole(chartMatrixModel.getSizeSelectionRole());
        this.tileChartCellModel.setColorSelectionRole(chartMatrixModel.getColorSelectionRole());
        this.tileChartCellModel.setTileChartModel(chartMatrixModel.getTileChartModel());
        this.tileChartCellModel.setDataTree(chartMatrixModel.getDataTree());
        this.tileChartCellModel.setActionProvider(chartMatrixModel.getActionProvider());
        this.tileChartCellModel.setWallColor(WALL_COLOR);
        this.tileChartCellModel.setAntialiasedGraphics(new Boolean(chartMatrixModel.getTileChartModel().isAntialiasedGraphics()));
        this.tileChartCellModel.setAntialiasedText(new Boolean(chartMatrixModel.getTileChartModel().isAntialiasedText()));
        this.tileChartCellModel.setColorVariableDiscrete(chartMatrixModel.isColorVariableDiscrete());
        int frameVisibilityPolicy = this.tileChartCellModel.getTileChartModel().getFrameLineStyle().getVisibilityPolicy();
        if (frameVisibilityPolicy == 10200) {
            this.setMatrixCellOutlineVisible(dataSource.getVariable(chartMatrixModel.getRowRole()) != null || dataSource.getVariable(chartMatrixModel.getColumnRole()) != null);
        } else {
            this.setMatrixCellOutlineVisible(frameVisibilityPolicy == 10201);
        }
        this.setMatrixCellOutlineLineStyle(this.tileChartCellModel.getTileChartModel().getFrameLineStyle());
        if (this.tileCell == null || this.tileChartCellModel.getPreferredSize() == null) {
            this.tileChartCellModel.setPreferredSize(new Dimension(640, 480));
        }
        this.tileCellList = this.addMatrixCellComponents(this.tileCellFactory, this.tileChartCellModel, new DataSource[]{dataSource});
        this.tileCell = (TileChartCell)this.tileCellList.get(0);
        this.tileCell.colorMapper = colorMapper = this._makeColorMapper(dataSource, chartMatrixModel, chartMatrixModel.getTileChartModel());
        this.tileCell.tileChartRendererModel.setColorMapper(colorMapper);
        this.tileCell.construct();
        this.model.setTileValues(this.tileCell.getTileValues());
        if (this.idVariableArray != null) {
            String[] idLabels = new String[this.idVariableArray.length];
            for (int ii = 0; ii < this.idVariableArray.length; ++ii) {
                idLabels[ii] = this.idVariableArray[ii].getLabel();
            }
            this.model.setIDLabels(idLabels);
        }
        if (colorVtkVar != null) {
            this.colorRampLegend = this._addLegend(dataSource, chartMatrixModel, chartMatrixModel.getTileChartModel());
        }
    }

    public String[] getCurRootTile() {
        return this.tileCell != null ? this.tileCell.getRootTilePath() : null;
    }

    public String[] getTileAtPosition(Point2D p) {
        return this.tileCell.getTileAtPosition(p).getPath();
    }

    public void setCurRootTile(String[] rootPath) {
        if (this.tileCell == null) {
            this.construct();
        }
        if (this.tileCell != null) {
            this.tileCell.setRootTilePath(rootPath);
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        super.setBounds(x, y, width, height);
        if (this.colorRampLegend != null) {
            Dimension lps = this.colorRampLegend.getPreferredSize();
            int place = this.getModel().getTileChartModel().getLegendModel().getPlacement();
            if (place == 3 || place == 7) {
                this.colorRampLegend.setPreferredSize(new Dimension(lps.width, (int)((double)height * 0.75)));
            } else {
                this.colorRampLegend.setPreferredSize(new Dimension((int)((double)width * 0.75), lps.height));
            }
        }
    }

    private ColorMapper _makeColorMapper(DataSource ds, TileChartMatrixModel matrixModel, TileChartModel graphModel) {
        DataElementStyles dataElementStyles = graphModel.getDataElementStyles();
        if (ds == null || dataElementStyles == null || dataElementStyles.getFillStyles() == null || dataElementStyles.getFillStyles().length < 1) {
            return null;
        }
        ContinuousRangeToColorMapper colorMapper = null;
        Variable colorVariable = ds.getVariable(matrixModel.getColorRole(), 0);
        if (matrixModel.isColorVariableDiscrete()) {
            if (colorVariable instanceof StringVariable) {
                NumericVariable v = this.dataSource.getBaseVariable((StringVariable)colorVariable);
                if (colorVariable.getConnection() instanceof NumericVariable) {
                    NumericVariable nv = (NumericVariable)colorVariable.getConnection();
                    NumericVariable sortednv = new NumericVariable();
                    sortednv.setFormat(nv.getFormat());
                    sortednv.connectFrom(nv);
                    sortednv.setFormattedValueMissingValueExceptionsEnabled(false);
                    sortednv.init();
                    VariableProcessor vp = new VariableProcessor();
                    vp.addVariable((Variable)sortednv);
                    vp.setSort((Variable)sortednv, 1);
                    vp.init();
                    StringVariable sv = new StringVariable();
                    sv.connectFrom(sortednv);
                    sv.init();
                    colorVariable = sv;
                }
            }
            if (this.dataSource.isRelationalData()) {
                colorMapper = GTKUtil.MapperFactory.newFormattedValueStringToColorMapper(colorVariable, dataElementStyles.getFillStyles(), dataElementStyles.getDiscreteFillColors());
            }
        } else {
            colorMapper = new ContinuousRangeToColorMapper();
        }
        return colorMapper;
    }

    private LegendCell _addLegend(DataSource ds, TileChartMatrixModel matrixModel, TileChartModel graphModel) {
        TileChartLegendCell tileChartLegendCell = null;
        Variable variable = ds.getVariable(matrixModel.getColorRole(), 0);
        if (variable != null) {
            LegendModel lm = graphModel.getLegendModel();
            Variable colorVtkVar = this.dataSource.getVariable(matrixModel.getColorRole(), 0);
            int placement = lm.getPlacement();
            if (placement == 10200) {
                placement = 5;
            }
            LegendCellModel lcm = matrixModel.isColorVariableDiscrete() ? new LegendCellModel() : new ColorRampLegendCellModel();
            switch (placement) {
                case 3: {
                    lcm.setOrientation(new Integer(1));
                    break;
                }
                case 7: {
                    lcm.setOrientation(new Integer(1));
                    break;
                }
                case 1: {
                    lcm.setOrientation(new Integer(0));
                    break;
                }
                default: {
                    lcm.setOrientation(new Integer(0));
                }
            }
            lcm.setPlacement(new Integer(placement));
            lcm.setAntialiasedText(new Boolean(graphModel.isAntialiasedText()));
            lcm.setAntialiasedGraphics(new Boolean(graphModel.isAntialiasedGraphics()));
            lcm.setDefaultLabel(variable.getLabel());
            lcm.setLegendModel(graphModel.getLegendModel());
            lcm.setFrameLineStyleVisibilityPolicyForAutomatic(Boolean.FALSE);
            lcm.setBackgroundVisible(Boolean.FALSE);
            Color[] colors = null;
            double[] colorPositions = null;
            Double[] cpDubs = null;
            boolean useCat = this.dataSource.isCategorized(variable);
            if (!matrixModel.isColorVariableDiscrete()) {
                if (useCat) {
                    RangeInfo[] rangeInfos = this.dataSource.categorize(variable);
                    if (rangeInfos == null) {
                        useCat = false;
                    } else {
                        SegmentedRangeStyle altSegmentedRangeStyle = new SegmentedRangeStyle();
                        altSegmentedRangeStyle.setDataElementStyles(graphModel.getDataElementStyles());
                        altSegmentedRangeStyle.setPaletteType(12102);
                        SegmentedRangeStyle segmentedRangeStyle = this.dataSource.getSegmentedRangeStyle(variable);
                        CategorizationInfo categorizationInfo = new CategorizationInfo(this.dataSource.getCategorizationModel(variable), segmentedRangeStyle, altSegmentedRangeStyle, rangeInfos);
                        if (categorizationInfo != null && rangeInfos != null) {
                            Util.collate(categorizationInfo);
                            DiscreteRangeToColorMapper mapper = GTKUtil.MapperFactory.newNonContinuousColorMapper(categorizationInfo);
                            int numRanges = categorizationInfo.getRangeInfos().length;
                            colors = new Color[numRanges * 2];
                            colorPositions = new double[numRanges * 2];
                            cpDubs = new Double[numRanges * 2];
                            String[] labels = new String[numRanges + 1];
                            Double[] labelPos = new Double[numRanges + 1];
                            double lowVal = categorizationInfo.getRangeInfos()[0].getStartValue();
                            double highVal = categorizationInfo.getRangeInfos()[numRanges - 1].getEndValue();
                            double valRange = highVal - lowVal;
                            boolean tweakedStart = false;
                            boolean tweakedEnd = false;
                            if (categorizationInfo.getRangeInfos()[0].getEndValue() - categorizationInfo.getRangeInfos()[0].getStartValue() == 0.0) {
                                categorizationInfo.getRangeInfos()[0].setEndValue(categorizationInfo.getRangeInfos()[0].getStartValue() + 0.001);
                                categorizationInfo.getRangeInfos()[1].setStartValue(categorizationInfo.getRangeInfos()[0].getEndValue());
                                tweakedStart = true;
                                mapper.getRangeSegments()[0].setMax(mapper.getRangeSegments()[0].getMin() + 0.001);
                                mapper.getRangeSegments()[1].setMin(mapper.getRangeSegments()[0].getMax());
                            }
                            if (categorizationInfo.getRangeInfos()[numRanges - 1].getEndValue() - categorizationInfo.getRangeInfos()[numRanges - 1].getStartValue() == 0.0) {
                                categorizationInfo.getRangeInfos()[numRanges - 1].setStartValue(categorizationInfo.getRangeInfos()[numRanges - 1].getEndValue() - 0.001);
                                categorizationInfo.getRangeInfos()[numRanges - 2].setEndValue(categorizationInfo.getRangeInfos()[numRanges - 1].getStartValue());
                                tweakedEnd = true;
                                mapper.getRangeSegments()[numRanges - 1].setMin(mapper.getRangeSegments()[numRanges - 1].getMax() - 0.001);
                                mapper.getRangeSegments()[numRanges - 2].setMax(mapper.getRangeSegments()[numRanges - 1].getMin());
                            }
                            colors[0] = mapper.getValue(categorizationInfo.getRangeInfos()[0].getStartValue());
                            colors[1] = colors[0];
                            colorPositions[0] = (categorizationInfo.getRangeInfos()[0].getStartValue() - lowVal) / valRange;
                            colorPositions[1] = (categorizationInfo.getRangeInfos()[0].getEndValue() - lowVal) / valRange;
                            cpDubs[0] = new Double(colorPositions[0]);
                            cpDubs[1] = new Double(colorPositions[1]);
                            labels[0] = categorizationInfo.getRangeInfos()[0].getFormattedStartValue();
                            labelPos[0] = new Double((categorizationInfo.getRangeInfos()[0].getStartValue() - lowVal) / valRange);
                            for (int ii = 1; ii < numRanges; ++ii) {
                                double midRangeVal = categorizationInfo.getRangeInfos()[ii].getStartValue() + (categorizationInfo.getRangeInfos()[ii].getEndValue() - categorizationInfo.getRangeInfos()[ii].getStartValue()) / 2.0;
                                colors[ii * 2] = mapper.getValue(midRangeVal);
                                colors[ii * 2 + 1] = colors[ii * 2];
                                colorPositions[ii * 2] = (categorizationInfo.getRangeInfos()[ii].getStartValue() - lowVal) / valRange;
                                colorPositions[ii * 2 + 1] = (categorizationInfo.getRangeInfos()[ii].getEndValue() - lowVal) / valRange;
                                cpDubs[ii * 2] = new Double(colorPositions[ii * 2]);
                                cpDubs[ii * 2 + 1] = new Double(colorPositions[ii * 2 + 1]);
                                labels[ii] = categorizationInfo.getRangeInfos()[ii].getFormattedStartValue();
                                labelPos[ii] = new Double((categorizationInfo.getRangeInfos()[ii].getStartValue() - lowVal) / valRange);
                            }
                            double MIN_END_GAP = 0.01;
                            if (tweakedStart) {
                                colorPositions[1] = colorPositions[1] + 0.01;
                                colorPositions[2] = colorPositions[2] + 0.01;
                                if (colorPositions.length >= 4 && colorPositions[1] > colorPositions[3]) {
                                    colorPositions[1] = colorPositions[0] + (colorPositions[3] - colorPositions[0]) / 2.0;
                                    colorPositions[2] = colorPositions[1];
                                }
                                cpDubs[1] = new Double(colorPositions[1]);
                                cpDubs[2] = new Double(colorPositions[2]);
                            }
                            if (tweakedEnd) {
                                int numCP = colorPositions.length;
                                int n = numCP - 2;
                                colorPositions[n] = colorPositions[n] - 0.01;
                                int n2 = numCP - 3;
                                colorPositions[n2] = colorPositions[n2] - 0.01;
                                cpDubs[numCP - 2] = new Double(colorPositions[numCP - 2]);
                                cpDubs[numCP - 3] = new Double(colorPositions[numCP - 3]);
                            }
                            labels[numRanges] = categorizationInfo.getRangeInfos()[numRanges - 1].getFormattedEndValue();
                            labelPos[numRanges] = new Double((categorizationInfo.getRangeInfos()[numRanges - 1].getEndValue() - lowVal) / valRange);
                            if (valRange == 0.0) {
                                cpDubs[0] = new Double(0.0);
                                cpDubs[1] = new Double(1.0);
                                labelPos[0] = new Double(0.0);
                                labelPos[1] = new Double(1.0);
                            }
                            ((ColorRampLegendCellModel)lcm).setColors(colors);
                            ((ColorRampLegendCellModel)lcm).setColorValues(cpDubs);
                            ((ColorRampLegendCellModel)lcm).setLabels(labels);
                            ((ColorRampLegendCellModel)lcm).setLabelValues(labelPos);
                            Color missingColor = graphModel.getDataElementStyles().getMissingFillStyle().getSolidFillColor();
                            if (missingColor.getAlpha() < 255) {
                                missingColor = new Color(missingColor.getRed(), missingColor.getGreen(), missingColor.getBlue());
                            }
                            this.tileCell.colorMapper.setMissingReplacement(missingColor);
                            this.tileCell.colorMapper.setReplaceMissingValues(true);
                            this.tileCell.colorMapper.setLabelMissingValues(true);
                            lcm.setColorMapper(this.tileCell.colorMapper);
                            this.tileChartCellModel.setColorMapper((ColorMapper)mapper);
                        }
                    }
                }
                if (!useCat) {
                    int colorPaletteType = graphModel.getColorPaletteType();
                    DataElementStyles dataElementStyles = graphModel.getDataElementStyles();
                    switch (colorPaletteType) {
                        default: {
                            colors = new Color[3];
                            colorPositions = new double[3];
                            colors[0] = dataElementStyles.getContinuousFillThreeColorStartColor();
                            colorPositions[0] = 0.0;
                            colors[1] = dataElementStyles.getContinuousFillThreeColorNeutralColor();
                            colorPositions[1] = 0.5;
                            colors[2] = dataElementStyles.getContinuousFillThreeColorEndColor();
                            colorPositions[2] = 1.0;
                            break;
                        }
                        case 11801: {
                            colors = new Color[2];
                            colorPositions = new double[2];
                            colors[0] = dataElementStyles.getContinuousFillTwoColorStartColor();
                            colorPositions[0] = 0.0;
                            colors[1] = dataElementStyles.getContinuousFillTwoColorEndColor();
                            colorPositions[1] = 1.0;
                            break;
                        }
                        case 11806: {
                            ColorPosition[] colorSpectrum = dataElementStyles.getContinuousColorSpectrum();
                            colorPositions = new double[colorSpectrum.length];
                            colors = new Color[colorSpectrum.length];
                            for (int ii = 0; ii < colorSpectrum.length; ++ii) {
                                colorPositions[ii] = colorSpectrum[ii].getPosition();
                                colors[ii] = colorSpectrum[ii].getColor();
                            }
                        }
                    }
                    boolean symmetric = graphModel.getLegendModel().isSymmetricEnabled();
                    this.lowCV = !Double.isNaN(graphModel.getMinimumColorValue()) ? graphModel.getMinimumColorValue() : graphModel.getLegendModel().getMinimum();
                    this.highCV = !Double.isNaN(graphModel.getMaximumColorValue()) ? graphModel.getMaximumColorValue() : graphModel.getLegendModel().getMaximum();
                    if (Double.isNaN(this.highCV)) {
                        this.highCV = this.tileCell.getHighColorDataValue();
                    }
                    if (Double.isNaN(this.lowCV)) {
                        this.lowCV = this.tileCell.getLowColorDataValue();
                    }
                    if (Double.isInfinite(this.highCV)) {
                        this.highCV = 0.0;
                    }
                    if (Double.isInfinite(this.lowCV)) {
                        this.lowCV = 0.0;
                    }
                    if (symmetric) {
                        double base = graphModel.getLegendModel().getBaseline();
                        if (!Double.isNaN(graphModel.getMinimumColorValue()) && Double.isNaN(graphModel.getMaximumColorValue())) {
                            this.highCV = base + (base - this.lowCV);
                        } else if (!Double.isNaN(graphModel.getMaximumColorValue()) && Double.isNaN(graphModel.getMinimumColorValue())) {
                            this.lowCV = base - (this.highCV - base);
                        } else if (Double.isNaN(graphModel.getMaximumColorValue()) && Double.isNaN(graphModel.getMinimumColorValue())) {
                            if (this.highCV - base > base - this.lowCV) {
                                this.lowCV = base - (this.highCV - base);
                            } else {
                                this.highCV = base + (base - this.lowCV);
                            }
                        }
                    }
                    if (this.lowCV > this.highCV) {
                        return tileChartLegendCell;
                    }
                    GTKFormat colorFormatter = colorVtkVar.getFormat();
                    if (colorFormatter.getFormats()[0] instanceof SASFormat && ((SASFormat)colorFormatter.getFormats()[0]).getName().indexOf("BEST") >= 0) {
                        colorFormatter.setFormat((Format)this.findBESTRFormat(this.lowCV, this.highCV));
                        Variable sizeVtkVar = this.dataSource.getVariable(matrixModel.getSizeRole(), 0);
                        if (sizeVtkVar.getRootVariable().getLabel().equals(colorVtkVar.getRootVariable().getLabel())) {
                            GTKFormat sizeFormatter = sizeVtkVar.getFormat();
                            sizeFormatter.setFormat((Format)this.findBESTRFormat(this.lowCV, this.highCV));
                        }
                    }
                    cpDubs = null;
                    if (colorPositions != null && colorPositions.length > 0 && colors.length == colorPositions.length) {
                        cpDubs = new Double[colorPositions.length];
                        for (int ii = 0; ii < colorPositions.length; ++ii) {
                            cpDubs[ii] = new Double(colorPositions[ii]);
                        }
                    } else {
                        cpDubs = this.distributePositionsEvenly(colors.length);
                    }
                    if (Math.abs(this.highCV - this.lowCV) < 1.0E-7 || Double.isInfinite(this.highCV)) {
                        Color middleColor = colors[colors.length / 2];
                        for (int ii = 0; ii < colors.length; ++ii) {
                            colors[ii] = middleColor;
                        }
                    }
                    ((ColorRampLegendCellModel)lcm).setColors(colors);
                    ((ColorRampLegendCellModel)lcm).setColorValues(cpDubs);
                    Color missingColor = graphModel.getDataElementStyles().getMissingFillStyle().getSolidFillColor();
                    if (missingColor.getAlpha() < 255) {
                        missingColor = new Color(missingColor.getRed(), missingColor.getGreen(), missingColor.getBlue());
                    }
                    this.tileCell.colorMapper.setMissingReplacement(missingColor);
                    this.tileCell.colorMapper.setReplaceMissingValues(true);
                    this.tileCell.colorMapper.setLabelMissingValues(true);
                    lcm.setColorMapper(this.tileCell.colorMapper);
                    if (Double.isInfinite(this.highCV)) {
                        ((ColorRampLegendCellModel)lcm).setLowValue(new Double(0.0));
                        ((ColorRampLegendCellModel)lcm).setHighValue(new Double(0.0));
                    } else {
                        ((ColorRampLegendCellModel)lcm).setLowValue(new Double(this.lowCV));
                        if (this.highCV == this.lowCV || colorFormatter != null) {
                            ((ColorRampLegendCellModel)lcm).setHighValue(new Double(this.highCV));
                        } else {
                            ((ColorRampLegendCellModel)lcm).setHighValue(new Double(this.highCV * 1.0000001));
                        }
                    }
                    ((ColorRampLegendCellModel)lcm).setValueFormat(colorFormatter);
                    this.tileCell.setLowColorLegendValue(this.lowCV);
                    this.tileCell.setHighColorLegendValue(this.highCV);
                }
            } else {
                lcm.setColorMapper(this.tileCell.colorMapper);
            }
            tileChartLegendCell = new TileChartLegendCell(lcm, this.getChannel(), placement, this.sizeVtkVars.getLabel(), this.tileChartCellModel.isColorVariableDiscrete());
            this.addLegend(tileChartLegendCell, placement);
            this.tileCell.setLegendColors(colors);
            this.tileCell.setLegendColorPositions(colorPositions);
            tileChartLegendCell.setAntiAliasingEnabled(graphModel.isAntialiasedGraphics());
            tileChartLegendCell.setTextAntiAliasingEnabled(graphModel.isAntialiasedText());
        }
        return tileChartLegendCell;
    }

    private DecimalFormat findBESTRFormat(double n1, double n2) {
        String pattern = "";
        n1 = Math.abs(n1);
        n2 = Math.abs(n2);
        double range = Math.abs(n2 - n1);
        int plod1 = this.positionsLeftOfDecimal(n1);
        int plod2 = this.positionsLeftOfDecimal(n2);
        int prod1 = this.positionsRightOfDecimal(n1);
        int prod2 = this.positionsRightOfDecimal(n2);
        int maxplod = Math.max(plod1, plod2);
        int maxprod = Math.max(prod1, prod2);
        if (this.nonSignificantPositionsRightOfDecimal(range) > 0) {
            maxprod = this.nonSignificantPositionsRightOfDecimal(range) + 2;
        } else {
            switch (maxplod) {
                case 0: {
                    maxprod = Math.min(maxprod, 10);
                    break;
                }
                case 1: {
                    maxprod = Math.min(maxprod, 3);
                    break;
                }
                case 2: {
                    maxprod = Math.min(maxprod, 2);
                    break;
                }
                case 3: {
                    maxprod = Math.min(maxprod, 1);
                    break;
                }
                default: {
                    maxprod = Math.min(maxprod, 0);
                }
            }
        }
        while (maxprod >= 0 && !this.zeroAtDecimalPos(maxprod, n1) && !this.zeroAtDecimalPos(maxprod, n2)) {
            --maxprod;
        }
        boolean useSeperators = false;
        if (maxplod > 5) {
            useSeperators = true;
        }
        while (maxplod > 1) {
            pattern = pattern + "#";
            if (!useSeperators || --maxplod % 3 != 0) continue;
            pattern = pattern + ",";
        }
        pattern = pattern + "0";
        if (maxprod >= 1) {
            pattern = pattern + ".";
        }
        while (maxprod > 0) {
            pattern = pattern + "0";
            --maxprod;
        }
        DecimalFormat bestr = new DecimalFormat(pattern);
        return bestr;
    }

    private boolean zeroAtDecimalPos(int pos, double n) {
        while (pos > 0) {
            n *= 10.0;
            --pos;
        }
        n = (int)n;
        n *= 0.1;
        return (n -= (double)((int)n)) != 0.0;
    }

    private int positionsLeftOfDecimal(double d) {
        int nPos = 1;
        double growingD = 1.0;
        while (d >= growingD) {
            growingD *= 10.0;
            ++nPos;
        }
        return --nPos;
    }

    private int positionsRightOfDecimal(double d) {
        int nPos = 0;
        if (d < 9.223372036854776E18) {
            d -= (double)((long)d);
            while (d != 0.0) {
                d *= 10.0;
                d -= (double)((long)d);
                ++nPos;
            }
        }
        return nPos;
    }

    private int nonSignificantPositionsRightOfDecimal(double d) {
        int nPos = 0;
        if (d == 0.0) {
            return 0;
        }
        while ((double)((int)d) == 0.0) {
            d *= 10.0;
            ++nPos;
        }
        return nPos;
    }

    public ChartImageMapInfo2[] getImageMapInfo() {
        int cellCount;
        if (this.getErrorMessage() != null) {
            return null;
        }
        ChartImageMapInfo2[] tileChartImageMapInfos = null;
        List cells = this.getCells();
        if (this.dataSource != null && this.dataSource.getValueCount() > 0 && this.model != null && cells != null && (cellCount = cells.size()) > 0) {
            ArrayList l = new ArrayList();
            this.addVariableListImageMapInfo(l);
            this.addCellImageMapInfo(l);
            this.addLegendImageMapInfo(l);
            this.addMatrixAxesImageMapInfo(l);
            tileChartImageMapInfos = ChartImageMapInfo2.listToArray(l);
        }
        return tileChartImageMapInfos;
    }

    private void addMatrixAxesImageMapInfo(List imageMapInfoList) {
    }

    private void addVariableListImageMapInfo(List imageMapInfoList) {
        VariableList columnVariableList = Util.newVariablelist(this.dataSource, this.model.getColumnRole());
        VariableList rowVariableList = Util.newVariablelist(this.dataSource, this.model.getRowRole());
        VariableList idVariableList = Util.newVariablelist(this.dataSource, this.model.getIdRole());
        VariableList responseVariableList = Util.newVariablelist(this.dataSource, new Object[]{this.model.getSizeRole(), this.model.getColorRole()});
        VariableList dataTipVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getDataTipRole());
        VariableList auxiliaryVariableList = Util.newVariablelistFromVariableArray(this.dataSource, this.model.getAuxiliaryRole());
        if (this.dataSource.getVariable(this.model.getIdRole())[0] instanceof OLAPLevelVariable) {
            idVariableList = Util.newVariablelist(this.dataSource, this.model.getIdHierRole());
        }
        imageMapInfoList.add(new ChartImageMapInfo2(columnVariableList, rowVariableList, idVariableList, null, responseVariableList, null, dataTipVariableList, auxiliaryVariableList));
    }

    private void addCellImageMapInfo(List imageMapInfoList) {
        List cells = this.getCells();
        int size = cells.size();
        for (int ii = 0; ii < size; ++ii) {
            int jj;
            TileChartCell cell = (TileChartCell)cells.get(ii);
            DataSource cellDataSource = cell.getDataSource();
            Variable[] cellColumnVariables = cellDataSource.getVariable(this.model.getColumnRole());
            Variable[] cellRowVariables = cellDataSource.getVariable(this.model.getRowRole());
            ValueList columnValueList = null;
            ValueList rowValueList = null;
            if (cellColumnVariables != null) {
                for (jj = cellColumnVariables.length - 1; jj >= 0; --jj) {
                    if (cellColumnVariables[jj] instanceof StringVariable) {
                        columnValueList = GTKUtil.toValueList((Variable)((StringVariable)cellColumnVariables[jj]), 0, columnValueList);
                        continue;
                    }
                    if (!(cellColumnVariables[jj] instanceof NumericVariable)) continue;
                    columnValueList = GTKUtil.toValueList((Variable)((NumericVariable)cellColumnVariables[jj]), 0, columnValueList);
                }
            }
            if (cellRowVariables != null) {
                for (jj = cellRowVariables.length - 1; jj >= 0; --jj) {
                    if (cellRowVariables[jj] instanceof StringVariable) {
                        rowValueList = GTKUtil.toValueList((Variable)((StringVariable)cellRowVariables[jj]), 0, rowValueList);
                        continue;
                    }
                    if (!(cellRowVariables[jj] instanceof NumericVariable)) continue;
                    rowValueList = GTKUtil.toValueList((Variable)((NumericVariable)cellRowVariables[jj]), 0, rowValueList);
                }
            }
            if (cell == null) continue;
            imageMapInfoList.add(cell.getImageMapInfo());
        }
    }

    private void addLegendImageMapInfo(List imageMapInfoList) {
        ChartImageMapInfo2 tempInfo = null;
        LabelZoneList responseLabelZoneList = null;
        tempInfo = new ChartImageMapInfo2(null, null, null, null, null, null, null, null, null, responseLabelZoneList, null);
        tempInfo.source = this.colorRampLegend;
        imageMapInfoList.add(tempInfo);
    }

    private Double[] distributePositionsEvenly(int num) {
        Double[] nv = new Double[num];
        for (int ii = 0; ii < num; ++ii) {
            nv[ii] = new Double(num > 1 ? (double)ii / ((double)num - 1.0) : 0.0);
        }
        return nv;
    }

    @Override
    protected List getCells() {
        return this.tileCellList;
    }

    @Override
    public Component getBrushableComponent() {
        if (this.tileCell != null) {
            return this.tileCell;
        }
        return this;
    }

    public void recreateCell() {
        this.tileCellFactory.reset();
    }

    public JPopupMenu newPopupMenu(int x, int y) {
        if (this.tileCell != null) {
            Point p = Util.toDescendent(x, y, this, this.tileCell);
            return this.tileCell.newPopupMenu(p.x, p.y);
        }
        return null;
    }

    public boolean zoom(int x, int y) {
        if (this.tileCell != null) {
            Point p = Util.toDescendent(x, y, this, this.tileCell);
            return this.tileCell.zoom(p.x, p.y);
        }
        return false;
    }

    private static class TileCellFactory
    implements Matrix.CellFactoryInterface {
        private TileChartCell tileChartCell = null;

        private TileCellFactory() {
        }

        @Override
        public JComponent newCellComponent(SimpleModelInterface cellModel, DataSource[] dataSource, Channel channel) {
            if (dataSource != null && dataSource.length > 0 && this.tileChartCell == null) {
                this.tileChartCell = new TileChartCell((TileChartCellModel)cellModel, dataSource[0], channel);
            }
            return this.tileChartCell;
        }

        public void reset() {
            this.tileChartCell = null;
        }
    }
}

