/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.tilechart;

import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.tilechart.JSizeLegend;
import com.sas.graphics.util.gl.Channel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.border.EmptyBorder;

public class TileChartLegendCell
extends LegendCell {
    int placement;
    JSizeLegend sizeLegend;

    public TileChartLegendCell(LegendCellModel cellModel, Channel channel, int placement, String sizeLabel, boolean discreteColorVar) {
        super(cellModel, channel);
        this.placement = placement;
        this.sizeLegend = new JSizeLegend(sizeLabel);
        this.sizeLegend.setLabelStyle(cellModel.getLegendModel().getLabelTextStyle());
        this.sizeLegend.setPlacement(placement);
        if (discreteColorVar) {
            this.sizeLegend.setLabelPlacement(1);
        }
        if (placement == 5 || placement == 1) {
            this.sizeLegend.setBorder(new EmptyBorder(0, 0, 0, 30));
            this.add((Component)this.sizeLegend, "West");
        } else {
            this.sizeLegend.setBorder(new EmptyBorder(30, 0, 0, 0));
            this.add((Component)this.sizeLegend, "South");
        }
    }

    @Override
    public Dimension getPreferredSize(Dimension constraints) {
        Dimension jSizeLegendPrefSize = null;
        Dimension c = new Dimension();
        if (this.sizeLegend != null) {
            jSizeLegendPrefSize = this.sizeLegend.getPreferredSize();
            if (constraints != null) {
                c.width = constraints.width;
                c.height = constraints.height;
                if (this.placement == 1 || this.placement == 5) {
                    c.width -= jSizeLegendPrefSize.width;
                } else {
                    c.height -= jSizeLegendPrefSize.height;
                }
            }
        }
        Dimension jLegendPrefSize = super.getPreferredSize(c);
        if (this.sizeLegend == null) {
            return jLegendPrefSize;
        }
        Dimension tileLegendCellPrefSize = new Dimension();
        if (this.placement == 1 || this.placement == 5) {
            if (jSizeLegendPrefSize.height != 0 && jLegendPrefSize.height != 0) {
                tileLegendCellPrefSize.width = jSizeLegendPrefSize.width + jLegendPrefSize.width;
                tileLegendCellPrefSize.height = Math.max(jSizeLegendPrefSize.height, jLegendPrefSize.height);
            }
        } else if (jSizeLegendPrefSize.width != 0 && jLegendPrefSize.width != 0) {
            tileLegendCellPrefSize.width = Math.max(jSizeLegendPrefSize.width, jLegendPrefSize.width);
            tileLegendCellPrefSize.height = jSizeLegendPrefSize.height + jLegendPrefSize.height;
        }
        return tileLegendCellPrefSize;
    }
}

