/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.tilechart;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.SwingActionProvider;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.LabelValuePair;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.tilechart.TileChartHighlightModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.GenericActionProviderView;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.tilechart.ColorCompare;
import com.sas.graphics.util.cell.tilechart.SizeCompare;
import com.sas.graphics.util.cell.tilechart.TileChartCellModel;
import com.sas.graphics.util.cell.tilechart.URLMenuItem;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.tile.BIPTileChartRenderer;
import com.sas.graphics.util.gtk.render.tile.Tile;
import com.sas.graphics.util.gtk.render.tile.TileChartRendererModel;
import com.sas.graphics.util.gtk.render.tile.TileChartRendererSelectResult;
import com.sas.graphics.util.gtk.render.tile.TileSelectDetail;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.util.ActionList;
import com.sas.swing.visuals.util.ActionUIFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class TileChartCell
extends Cell {
    private transient Variable[] idVariableArray;
    private transient Variable sizeVariable;
    private transient Variable colorVariable;
    private transient Variable[] dataTipVariableArray;
    private transient Variable[] auxiliaryVariableArray;
    private transient Object idRole;
    private transient Object sizeRole;
    private transient Object colorRole;
    private transient Object xRole;
    private transient Object yRole;
    private transient Object webLinkRole;
    private transient Object sizeSelectionRole;
    private transient Object colorSelectionRole;
    private transient Object dataTipRole;
    private transient Object auxiliaryRole;
    private transient String[] idLabel;
    private static String rootTileName = "root";
    private transient double[] legendColorPositions;
    private transient Color[] legendColors;
    private transient int curLevel = 0;
    private transient SwingActionProvider actionProvider = null;
    private transient Rectangle globalBounds = new Rectangle();
    private transient ArrayList activeStatusAL = new ArrayList();
    private transient ArrayList zoomNames = new ArrayList();
    private transient NumericVector missingVals = new NumericVector();
    public Hashtable levelName2RectHash = null;
    private final transient DataSource dataSource;
    private final transient TileChartCellModel cellModel;
    int previousLayout = 0;
    private static final boolean ZOOM_IN = true;
    private static final boolean ZOOM_OUT = false;
    private static final String ZOOM_IN_ACTION_COMMAND = "zoomIn";
    private static final String ZOOM_OUT_ACTION_COMMAND = "zoomOut";
    private static final String WEB_LINK_ACTION_COMMAND = "webLink";
    private static final double ARROW_SIZE = 15.0;
    private static final double ARROW_THICKNESS = 8.0;
    private static final Color SHADOW_COLOR = Color.lightGray;
    public boolean isAnimating = false;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_HIGHLIGHT = 1;
    public static final int ACTION_ZOOM_IN = 2;
    public static final int ACTION_ZOOM_OUT = 3;
    public static final int ACTION_GUTTER = 4;
    private int curAction = 0;
    private Tile curTile = null;
    public double lowColorDataValue = Double.POSITIVE_INFINITY;
    public double highColorDataValue = Double.NEGATIVE_INFINITY;
    public double lowColorLegendValue = Double.POSITIVE_INFINITY;
    public double highColorLegendValue = Double.NEGATIVE_INFINITY;
    static final boolean DR_G_DEMO = false;
    RepaintManager rpm = RepaintManager.currentManager(this);
    private ActionSupportFilter columnFilter;
    private ActionSupportFilter titleFilter;
    private ActionUIFactory actionUIFactory = new ActionUIFactory();
    public ColorMapper colorMapper;
    private BIPTileChartRenderer tileChartRenderer;
    public TileChartRendererModel tileChartRendererModel;
    Thread animator;
    int fps = 50;
    int numFrames = 30;
    int frame = 0;
    int minDelay = 12;
    int aveDelay = this.fps > 0 ? 1000 / this.fps : 100;
    Tile drillTile;
    boolean aspect;
    Rectangle2D.Double dr;
    Rectangle2D.Double cr;
    Rectangle2D.Double or;
    Runnable animate = new Runnable(){

        @Override
        public void run() {
            DataTreeGroupNode root = (DataTreeGroupNode)TileChartCell.this.tileChartRendererModel.getDataTree();
            TileChartCell.this.isAnimating = true;
            long tm = System.currentTimeMillis();
            while (TileChartCell.this.frame <= TileChartCell.this.numFrames) {
                SwingUtilities.invokeLater(TileChartCell.this.doAnimate);
                try {
                    double delayFactor = (double)(TileChartCell.this.numFrames - TileChartCell.this.frame) / (double)TileChartCell.this.numFrames;
                    delayFactor *= delayFactor;
                    tm = (long)((double)tm + ((double)TileChartCell.this.minDelay + (double)TileChartCell.this.aveDelay * delayFactor));
                    Thread.sleep(Math.max(0L, tm - System.currentTimeMillis()));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
                ++TileChartCell.this.frame;
            }
            if (TileChartCell.this.frame > TileChartCell.this.numFrames) {
                this.stop();
                TileChartCell.this.zoomNames.clear();
                for (DefaultMutableTreeNode curNode = TileChartCell.this.tileChartRendererModel.getCurrentRootTile().treeNode; curNode != root; curNode = (DefaultMutableTreeNode)curNode.getParent()) {
                    TileChartCell.this.zoomNames.add(((Tile)curNode.getUserObject()).idValue);
                }
                TileChartCell.this.isAnimating = false;
            }
        }

        public void stop() {
            if (!TileChartCell.this.aspect) {
                TileChartCell.this.tileChartRendererModel.setCurrentRootTile(TileChartCell.this.drillTile);
                if ((Rectangle2D.Double)TileChartCell.this.levelName2RectHash.get(TileChartCell.this.drillTile.idValue) != null) {
                    TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect = (Rectangle2D.Double)TileChartCell.this.levelName2RectHash.get(TileChartCell.this.drillTile.idValue);
                }
            } else {
                TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect = TileChartCell.this.dr;
            }
            TileChartCell.this.animator = null;
            TileChartCell.this.frame = -1;
            SwingUtilities.invokeLater(TileChartCell.this.doAnimate);
        }
    };
    Runnable doAnimate = new Runnable(){

        @Override
        public void run() {
            if (TileChartCell.this.frame == -1) {
                TileChartCell.this.recalculateDataValues(TileChartCell.this.tileChartRendererModel.getCurrentRootTile().treeNode);
                TileChartCell.this.updateDatatipLabels(false);
                TileChartCell.this.setUpLevelName2RectHash();
                TileChartCell.this.tileChartRenderer.startCreateTree(TileChartCell.this.tileChartRendererModel.getCurrentRootTile().treeNode, TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect, new Point2D.Double(TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect.x, TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect.y));
                Tile tt = TileChartCell.this.getTileAtPosition(TileChartCell.this.lastMousePos);
                TileChartCell.this.curTile = tt;
                TileChartCell.this.curAction = 1;
                TileChartCell.this.repaint();
            } else {
                TileChartCell.this.cr.width = TileChartCell.this.or.width + (double)TileChartCell.this.frame * ((TileChartCell.this.dr.width - TileChartCell.this.or.width) / (double)TileChartCell.this.numFrames);
                TileChartCell.this.cr.height = TileChartCell.this.or.height + (double)TileChartCell.this.frame * ((TileChartCell.this.dr.height - TileChartCell.this.or.height) / (double)TileChartCell.this.numFrames);
                TileChartCell.this.cr.x = TileChartCell.this.or.x + (double)TileChartCell.this.frame * ((TileChartCell.this.dr.x - TileChartCell.this.or.x) / (double)TileChartCell.this.numFrames);
                TileChartCell.this.cr.y = TileChartCell.this.or.y + (double)TileChartCell.this.frame * ((TileChartCell.this.dr.y - TileChartCell.this.or.y) / (double)TileChartCell.this.numFrames);
                TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect = TileChartCell.this.cr;
                TileChartCell.this.recalculateDataValues(TileChartCell.this.tileChartRendererModel.getCurrentRootTile().treeNode);
                TileChartCell.this.updateDatatipLabels(false);
                TileChartCell.this.setUpLevelName2RectHash();
                TileChartCell.this.tileChartRenderer.startCreateTree(TileChartCell.this.tileChartRendererModel.getCurrentRootTile().treeNode, TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect, new Point2D.Double(TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect.x, TileChartCell.this.tileChartRendererModel.getCurrentRootTile().rect.y));
                TileChartCell.this.repaint();
            }
        }
    };
    private static final int MARKER_MARGIN = 3;
    private Object uniqueId;
    private Point2D.Double lastMousePos = new Point2D.Double();
    private Tile tt;
    private final ActionListener myActionHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (TileChartCell.ZOOM_IN_ACTION_COMMAND.equals(actionCommand)) {
                TileChartCell.this.zoomTowardTile(TileChartCell.this.tt);
            } else if (TileChartCell.ZOOM_OUT_ACTION_COMMAND.equals(actionCommand)) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)TileChartCell.this.tileChartRendererModel.getCurrentRootTile().treeNode.getParent();
                if (node != null) {
                    TileChartCell.this.curTile = (Tile)node.getUserObject();
                    TileChartCell.this.curAction = 3;
                    TileChartCell.this.repaint();
                }
            } else if (TileChartCell.WEB_LINK_ACTION_COMMAND.equals(actionCommand) && ((TileChartCell)TileChartCell.this).tt.webLinks != null) {
                String cmdLine = "rundll32 url.dll,FileProtocolHandler " + ((URLMenuItem)e.getSource()).getUrl();
                try {
                    Runtime.getRuntime().exec(cmdLine);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    };

    public TileChartCell(TileChartCellModel cellModel, DataSource dataSource, Channel channel) {
        super(cellModel, channel);
        this.cellModel = cellModel;
        this.setOpaque(false);
        this.dataSource = dataSource;
        this.setAntiAliasingEnabled(false);
        this.setSelectionModel(dataSource.getDataSourceSelectionModel());
        GenericActionProviderView actionProviderView = new GenericActionProviderView(this);
        this.columnFilter = new ActionSupportFilter("OLAP_TABLEVIEW_SUPPORT", "COLUMN_HEADER_AREA", (ActionProviderViewInterface)actionProviderView);
        this.titleFilter = new ActionSupportFilter("OLAP_TABLEVIEW_SUPPORT", "TITLE_AREA", (ActionProviderViewInterface)actionProviderView);
        try {
            Object o = dataSource.getModel();
            if (o instanceof OLAPDataSetInterface) {
                OLAPDataSetInterface od = (OLAPDataSetInterface)o;
                if (od instanceof GraphOLAPDataSet) {
                    od = ((GraphOLAPDataSet)od).getDelegateModel();
                }
                this.columnFilter.setAttribute("model", (Object)od);
                this.titleFilter.setAttribute("model", (Object)od);
            }
        }
        catch (AttributeSetException e2) {
            e2.printStackTrace();
        }
        this.tileChartRenderer = new BIPTileChartRenderer();
        this.tileChartRendererModel = this.tileChartRenderer.getRendererModel();
        this.tileChartRendererModel.setRootTile(new Tile(rootTileName));
        this.tileChartRenderer.setChannel(channel);
        this.tileChartRenderer.sizeOrigRootTile(this.globalBounds, GTKUtil.mapToGTKTextStyle(cellModel.getTileChartModel().getStatusLineTextStyle()));
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Rectangle newR = new Rectangle(x, y, w, h);
        if (this.globalBounds.equals(newR)) {
            return;
        }
        super.setBounds(x, y, w, h);
        if (this.tileChartRendererModel.getRootTile().rect == null) {
            this.tileChartRendererModel.getRootTile().rect = new Rectangle2D.Double(x, y, w, h);
        }
        if (this.tileChartRendererModel.getRootTile() != null) {
            this.globalBounds = newR;
            this.tileChartRenderer.sizeOrigRootTile(this.globalBounds, GTKUtil.mapToGTKTextStyle(this.cellModel.getTileChartModel().getStatusLineTextStyle()));
        }
        if (this.tileChartRendererModel.getCurrentRootTile() != null && this.tileChartRendererModel.getRootPath() == null) {
            this.tileChartRendererModel.getCurrentRootTile().rect = (Rectangle2D.Double)this.tileChartRendererModel.getRootTile().rect.clone();
        }
        this.tileChartRendererModel.setTreeToBeRecreated(true);
    }

    @Override
    protected synchronized void construct() {
        Rectangle b;
        this.idVariableArray = null;
        this.sizeVariable = null;
        this.colorVariable = null;
        if (this.dataSource == null) {
            return;
        }
        this.globalBounds = b = this.getBounds();
        this.idRole = this.cellModel.getIdRole();
        this.sizeRole = this.cellModel.getSizeRole();
        this.colorRole = this.cellModel.getColorRole();
        this.xRole = this.cellModel.getXRole();
        this.yRole = this.cellModel.getYRole();
        this.webLinkRole = this.cellModel.getWebLinkRole();
        this.sizeSelectionRole = this.cellModel.getSizeSelectionRole();
        this.colorSelectionRole = this.cellModel.getColorSelectionRole();
        this.dataTipRole = this.cellModel.getDataTipRole();
        this.auxiliaryRole = this.cellModel.getAuxiliaryRole();
        this.actionProvider = this.cellModel.getActionProvider();
        this.idVariableArray = this.dataSource.getVariable(this.idRole);
        this.sizeVariable = this.dataSource.getVariable(this.sizeRole, 0);
        this.colorVariable = this.dataSource.getVariable(this.colorRole, 0);
        this.dataTipVariableArray = Util.getGTKVariableArray(this.dataSource, this.dataTipRole);
        this.auxiliaryVariableArray = Util.getGTKVariableArray(this.dataSource, this.auxiliaryRole);
        this.populateRendererModel();
        if (this.tileChartRendererModel.isColorVariableDiscrete()) {
            this.tileChartRendererModel.setColorMap((StringToColorMap)((StringToColorMapper)this.colorMapper).getValueMap());
        }
        if (this.tileChartRendererModel.isTreeToBeReattached()) {
            double[] dataValues = this.tileChartRenderer.attachTilesToDataTree();
            this.lowColorDataValue = dataValues[0];
            this.highColorDataValue = dataValues[1];
            if (!this.cellModel.isColorVariableDiscrete()) {
                if (this.highColorLegendValue == Double.NEGATIVE_INFINITY) {
                    this.highColorLegendValue = this.highColorDataValue;
                }
                if (this.lowColorLegendValue == Double.POSITIVE_INFINITY) {
                    this.lowColorLegendValue = this.lowColorDataValue;
                }
            }
            this.addOtherTiles();
            this.tileChartRendererModel.setTreeToBeReattached(false);
        }
        this.updateDatatipLabels(false);
    }

    private void populateRendererModel() {
        this.tileChartRendererModel.setTileVariable(this.dataSource.getVariable(this.idRole));
        this.tileChartRendererModel.setColorVariable(this.dataSource.getVariable(this.colorRole, 0));
        this.tileChartRendererModel.setSizeVariable((NumericVariable)this.dataSource.getVariable(this.sizeRole, 0));
        this.tileChartRendererModel.setDataTree((DefaultMutableTreeNode)this.cellModel.getDataTree());
        this.tileChartRendererModel.setXVariable(this.dataSource.getVariable(this.xRole, 0));
        this.tileChartRendererModel.setYVariable(this.dataSource.getVariable(this.yRole, 0));
        this.tileChartRendererModel.setWebLinkVariableArray(this.dataSource.getVariable(this.webLinkRole));
        this.tileChartRendererModel.setDataTipVariableArray(Util.getGTKVariableArray(this.dataSource, this.dataTipRole));
        this.tileChartRendererModel.setDetailLevel(this.cellModel.getTileChartModel().getDetailLevel());
        int layout = this.cellModel.getTileChartModel().getLayoutType();
        switch (layout) {
            case 0: {
                this.tileChartRendererModel.setLayout(RendererUtil.TileChartLayout.LAYOUT_STANDARD);
                break;
            }
            case 3: {
                this.tileChartRendererModel.setLayout(RendererUtil.TileChartLayout.LAYOUT_FLOW);
                break;
            }
            case 2: {
                this.tileChartRendererModel.setLayout(RendererUtil.TileChartLayout.LAYOUT_GEOGRAPHIC);
                break;
            }
            case 1: {
                this.tileChartRendererModel.setLayout(RendererUtil.TileChartLayout.LAYOUT_TOGGLE);
            }
        }
        int maxLevels = this.tileChartRendererModel.getTileVariable().length;
        for (int i = 1; i <= maxLevels; ++i) {
            LineStyle ls = this.cellModel.getTileChartModel().getOutlineLineStyle(i);
            if (ls == null) continue;
            this.tileChartRendererModel.setOutlineLineStyle(GTKUtil.mapToGTKLineStyle(ls), i);
        }
        this.tileChartRendererModel.setDataLabelLevel(this.cellModel.getTileChartModel().getDataLabelLevel());
        if (this.cellModel.getTileChartModel().getDataLabelTextStyle() != null) {
            this.tileChartRendererModel.setDataLabelTextStyle(GTKUtil.mapAdvancedTextStyleToGTKTextStyle(this.cellModel.getTileChartModel().getDataLabelTextStyle()));
            this.tileChartRendererModel.setDataLabelVisible(this.cellModel.getTileChartModel().getDataLabelTextStyle().isVisible());
        } else {
            this.tileChartRendererModel.setDataLabelTextStyle(new com.sas.graphics.util.gtk.TextStyle());
            this.tileChartRendererModel.setDataLabelVisible(false);
        }
        this.tileChartRendererModel.setStatusLineTextStyle(GTKUtil.mapToGTKTextStyle(this.cellModel.getTileChartModel().getStatusLineTextStyle()));
        this.tileChartRendererModel.setStatusLineVisible(this.cellModel.getTileChartModel().getStatusLineTextStyle().isVisible());
        this.tileChartRendererModel.setMissingColor(this.cellModel.getTileChartModel().getDataElementStyles().getMissingFillStyle().getSolidFillColor());
        if (this.cellModel.getColorMapper() != null) {
            this.tileChartRendererModel.setColorMapper(this.cellModel.getColorMapper());
        }
        this.tileChartRendererModel.setSizeSelectionVariable(this.dataSource.getVariable(this.sizeSelectionRole, 0));
        this.tileChartRendererModel.setColorSelectionVariable(this.dataSource.getVariable(this.colorSelectionRole, 0));
        this.tileChartRendererModel.setSelectedPercentageVariable(this.dataSource.getSelectedPercentageVariable());
        this.tileChartRendererModel.setSelectionColor(this.cellModel.getTileChartModel().getBrushModel().getSelectionColor());
        this.tileChartRendererModel.setSelectionAccentColor(this.cellModel.getTileChartModel().getBrushModel().getSelectionAccentColor());
        this.tileChartRendererModel.setColorVariableDiscrete(this.cellModel.isColorVariableDiscrete());
        this.tileChartRendererModel.setMinimumColorValue(this.cellModel.getTileChartModel().getMinimumColorValue());
        this.tileChartRendererModel.setMaximumColorValue(this.cellModel.getTileChartModel().getMaximumColorValue());
        this.tileChartRendererModel.setOutOfRangeColor(this.cellModel.getTileChartModel().getDataElementStyles().getOutOfRangeFillStyle().getSolidFillColor());
    }

    private void addOtherTiles() {
        DataTreeGroupNode root = (DataTreeGroupNode)this.tileChartRendererModel.getDataTree();
        Enumeration depthEnum = root.depthFirstEnumeration();
        int validOtherTiles = 0;
        while (depthEnum.hasMoreElements()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)depthEnum.nextElement();
            if (curNode.isLeaf()) continue;
            DataTreeGroupNode curGroupNode = (DataTreeGroupNode)curNode;
            Tile curTile = (Tile)curGroupNode.getUserObject();
            if (curTile.otherTile) {
                return;
            }
            validOtherTiles = 0;
            for (int ii = 0; ii < curGroupNode.getChildCount(); ++ii) {
                curNode = (DefaultMutableTreeNode)curGroupNode.getChildAt(ii);
                if (curNode.isLeaf()) continue;
                DataTreeGroupNode childNode = (DataTreeGroupNode)curNode;
                Tile childTile = (Tile)childNode.getUserObject();
                if (!childTile.otherQualify) continue;
                ++validOtherTiles;
            }
            if (validOtherTiles < 2) continue;
            double otherSize = 0.0;
            int childPos = 0;
            DataTreeGroupNode otherNode = new DataTreeGroupNode();
            double summarizedOtherColor = 0.0;
            for (int ii = curGroupNode.getChildCount() - 1; ii >= 0; --ii) {
                curNode = (DefaultMutableTreeNode)curGroupNode.getChildAt(ii);
                if (curNode.isLeaf()) continue;
                DataTreeGroupNode childNode = (DataTreeGroupNode)curNode;
                Tile childTile = (Tile)childNode.getUserObject();
                if (!childTile.otherQualify) continue;
                otherSize += childTile.sizeValue;
                childTile.inOther = true;
                otherNode.insert((MutableTreeNode)childNode, childPos++);
            }
            Tile otherTile = new Tile(this.cellModel.getTileChartModel().getOtherLabel(), otherSize, Double.NaN);
            otherTile.otherTile = true;
            otherNode.setUserObject((Object)otherTile);
            otherNode.setFormattedValue(otherTile.idValue);
            otherNode.setValue((Object)otherTile.idValue);
            curGroupNode.insert((MutableTreeNode)otherNode, curGroupNode.getChildCount());
            for (int ii = otherNode.getChildCount() - 1; ii >= 0; --ii) {
                curNode = (DefaultMutableTreeNode)otherNode.getChildAt(ii);
                if (curNode.isLeaf()) continue;
                DataTreeGroupNode childNode = (DataTreeGroupNode)curNode;
                Tile childTile = (Tile)childNode.getUserObject();
                if (!childTile.otherQualify) continue;
                summarizedOtherColor += childTile.sizeValue * (childTile.colorValue / ((Tile)otherNode.getUserObject()).sizeValue);
            }
            otherTile.colorValue = summarizedOtherColor;
        }
    }

    @Override
    public void paint(Graphics g) {
        int curLayout = this.cellModel.getTileChartModel().getLayoutType();
        if (curLayout != this.previousLayout) {
            this.tileChartRendererModel.setTreeToBeRecreated(true);
            this.previousLayout = curLayout;
        }
        super.paint(g);
        this.curAction = 0;
    }

    private void animateDataZoom() {
        this.animateDataZoom(true);
    }

    private void animateDataZoom(boolean showIt) {
        Tile tt;
        DataTreeGroupNode root = (DataTreeGroupNode)this.tileChartRendererModel.getDataTree();
        this.frame = 0;
        if (!this.aspect) {
            this.or = this.tileChartRendererModel.getCurrentRootTile().rect;
            DefaultMutableTreeNode curDrillNode = this.drillTile.treeNode;
            Rectangle2D.Double newRootRect = (Rectangle2D.Double)this.levelName2RectHash.get(((Tile)curDrillNode.getUserObject()).idValue);
            if (newRootRect == null) {
                newRootRect = this.tileChartRendererModel.getCurrentRootTile().rect;
            }
            this.recalculateDataValues(this.drillTile.treeNode);
            this.updateDatatipLabels(false);
            this.setUpLevelName2RectHash();
            this.tileChartRenderer.startCreateTree(this.drillTile.treeNode, newRootRect, new Point2D.Double(newRootRect.x, newRootRect.y));
            this.dr = this.tileChartRendererModel.getCurrentRootTile().rect;
        } else {
            this.or = this.drillTile.rect;
            this.dr = new Rectangle2D.Double();
            double destAspect = this.drillTile.rect.height / this.drillTile.rect.width;
            double origRootAspect = this.tileChartRendererModel.getRootTile().rect.height / this.tileChartRendererModel.getRootTile().rect.width;
            if (destAspect < origRootAspect) {
                this.dr.width = this.tileChartRendererModel.getRootTile().rect.width;
                this.dr.height = this.dr.width / this.drillTile.rect.width * this.drillTile.rect.height;
                this.dr.x = this.tileChartRendererModel.getRootTile().rect.x;
                this.dr.y = (this.tileChartRendererModel.getRootTile().rect.height - this.dr.height) / 2.0;
            } else {
                this.dr.height = this.tileChartRendererModel.getRootTile().rect.height;
                this.dr.width = this.dr.height / this.drillTile.rect.height * this.drillTile.rect.width;
                this.dr.y = this.tileChartRendererModel.getRootTile().rect.y;
                this.dr.x = this.tileChartRendererModel.getRootTile().rect.x + (this.tileChartRendererModel.getRootTile().rect.width - this.dr.width) / 2.0;
            }
            this.tileChartRendererModel.setCurrentRootTile(this.drillTile);
            this.levelName2RectHash.put(this.drillTile.idValue, this.dr.clone());
        }
        if (!Util.isHeadless()) {
            // empty if block
        }
        if (!this.aspect) {
            this.tileChartRendererModel.setCurrentRootTile(this.drillTile);
        } else {
            this.tileChartRendererModel.getCurrentRootTile().rect = this.dr;
            this.recalculateDataValues(this.tileChartRendererModel.getCurrentRootTile().treeNode);
            this.updateDatatipLabels(false);
            this.setUpLevelName2RectHash();
            this.tileChartRenderer.startCreateTree(this.tileChartRendererModel.getCurrentRootTile().treeNode, this.dr, new Point2D.Double(this.dr.x, this.dr.y));
        }
        this.zoomNames.clear();
        for (DefaultMutableTreeNode curNode = this.tileChartRendererModel.getCurrentRootTile().treeNode; curNode != root; curNode = (DefaultMutableTreeNode)curNode.getParent()) {
            this.zoomNames.add(((Tile)curNode.getUserObject()).idValue);
        }
        this.curTile = tt = this.getTileAtPosition(this.lastMousePos);
        this.curAction = 1;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Channel channel = this.getChannel();
        this.updateChannel();
        channel.setSingleBufferGraphics(g);
        this.getNetworkRoot().removeAllElements();
        if (this.tileChartRendererModel.isTreeToBeReattached()) {
            double[] dataValues = this.tileChartRenderer.attachTilesToDataTree();
            this.lowColorDataValue = dataValues[0];
            this.highColorDataValue = dataValues[1];
            if (!this.cellModel.isColorVariableDiscrete()) {
                if (this.highColorLegendValue == Double.NEGATIVE_INFINITY) {
                    this.highColorLegendValue = this.highColorDataValue;
                }
                if (this.lowColorLegendValue == Double.POSITIVE_INFINITY) {
                    this.lowColorLegendValue = this.lowColorDataValue;
                }
            }
            this.tileChartRendererModel.setTreeToBeReattached(false);
        }
        if (this.tileChartRendererModel.isTreeToBeRecreated()) {
            this.recalculateDataValues(this.tileChartRendererModel.getCurrentRootTile().treeNode);
            this.updateDatatipLabels(false);
            this.setUpLevelName2RectHash();
            this.tileChartRenderer.startCreateTree(this.tileChartRendererModel.getCurrentRootTile().treeNode, this.tileChartRendererModel.getCurrentRootTile().rect, new Point2D.Double(this.tileChartRendererModel.getCurrentRootTile().rect.x, this.tileChartRendererModel.getCurrentRootTile().rect.y));
            this.tileChartRendererModel.setTreeToBeRecreated(false);
        }
        if (this.tileChartRendererModel.getRootPath() != null && this.tileChartRendererModel.getRootPath().length > 0) {
            this.setRootPath();
        }
        this.tileChartRenderer.startDrawTree(this.tileChartRendererModel.getCurrentRootTile().treeNode, this.lowColorLegendValue, this.highColorLegendValue);
        this.tileChartRenderer.drawStatusLine(this.zoomNames, this.cellModel.getTileChartModel().getOtherLabel());
        switch (this.curAction) {
            default: {
                break;
            }
            case 2: {
                this.zoomTo(this.curTile, true);
                return;
            }
            case 3: {
                this.zoomTo(this.curTile, false);
                return;
            }
            case 4: 
        }
        TileChartHighlightModel[] highlights = this.cellModel.getTileChartModel().getHighlightModelList();
        if (highlights != null) {
            for (int ii = 0; ii < highlights.length; ++ii) {
                TileChartHighlightModel curHighlight = highlights[ii];
                this.highlightTiles(curHighlight);
            }
        }
        if (this.curAction == 1 && this.curTile != null && this.cellModel.getTileChartModel().getDataTipModel().isVisible()) {
            this.highlightTile(this.tileChartRendererModel.getCurrentRootTile(), this.cellModel.getTileChartModel().getDataTipHighlightModel());
            this.curTile = null;
        }
    }

    private void highlightTiles(TileChartHighlightModel highlightSet) {
        block87: {
            Enumeration<TreeNode> depthEnum;
            int numVisibleLevels;
            block86: {
                String compareStr;
                if (this.isAnimating) {
                    return;
                }
                numVisibleLevels = 0;
                numVisibleLevels = this.tileChartRenderer.isOLAPData(this.tileChartRendererModel.getTileVariable()) ? this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1 : Math.min(this.tileChartRendererModel.getDetailLevel(), this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1);
                depthEnum = this.tileChartRendererModel.getCurrentRootTile().treeNode.depthFirstEnumeration();
                if (highlightSet.getType() != 2 || highlightSet.getResponse() != 22) break block86;
                String string = compareStr = highlightSet.isIgnoreCase() ? highlightSet.getFindStr().toUpperCase() : highlightSet.getFindStr();
                while (depthEnum.hasMoreElements()) {
                    String thisStr;
                    DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)depthEnum.nextElement();
                    if (!curNode.isLeaf()) continue;
                    DataTreeGroupNode curGroupNode = (DataTreeGroupNode)curNode.getParent();
                    String origStr = curGroupNode.getFormattedValue();
                    String string2 = thisStr = highlightSet.isExactMatch() ? origStr : origStr.substring(0, Math.min(compareStr.length(), origStr.length()));
                    if (highlightSet.isIgnoreCase()) {
                        thisStr = thisStr.toUpperCase();
                    }
                    if (!thisStr.equals(compareStr)) continue;
                    this.highlightTile((Tile)curGroupNode.getUserObject(), highlightSet);
                }
                break block87;
            }
            Vector<Object> v = new Vector<Object>();
            Tile[] leafTiles = null;
            while (depthEnum.hasMoreElements()) {
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)depthEnum.nextElement();
                if (!(curNode instanceof DataTreeGroupNode) || numVisibleLevels == this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1 && !this.tileChartRenderer.isLeafTile(curNode) || curNode.getLevel() - this.tileChartRendererModel.getCurrentRootTile().treeNode.getLevel() != numVisibleLevels) continue;
                DataTreeGroupNode curGroupNode = (DataTreeGroupNode)curNode;
                if (highlightSet.getResponse() == 20 && Double.isNaN(((Tile)curGroupNode.getUserObject()).colorValue)) continue;
                v.add(curGroupNode.getUserObject());
            }
            leafTiles = new Tile[v.size()];
            leafTiles = v.toArray(leafTiles);
            if (highlightSet.getResponse() == 20) {
                Arrays.sort(leafTiles, new ColorCompare(this.cellModel.getTileChartModel()));
                v.clear();
                for (int jj = 0; jj < leafTiles.length; ++jj) {
                    if (leafTiles[jj].missingColor != null) continue;
                    v.add(leafTiles[jj]);
                }
                if (v.size() < leafTiles.length) {
                    leafTiles = new Tile[v.size()];
                    leafTiles = v.toArray(leafTiles);
                }
                if (!this.cellModel.getTileChartModel().isColorVariableNumeric() && highlightSet.getCondition() != 12) {
                    return;
                }
            } else {
                Arrays.sort(leafTiles, new SizeCompare());
                int numInvalid = 0;
                while (leafTiles[numInvalid].sizeValue <= 0.0) {
                    ++numInvalid;
                }
                if (numInvalid > 0) {
                    Tile[] newLT = new Tile[leafTiles.length - numInvalid];
                    System.arraycopy(leafTiles, numInvalid, newLT, 0, leafTiles.length - numInvalid);
                    leafTiles = newLT;
                }
            }
            if (leafTiles.length <= 0) {
                return;
            }
            double number = highlightSet.getValue();
            int firstTileIndex = 0;
            int lastTileIndex = 0;
            switch (highlightSet.getCondition()) {
                case 10: {
                    if (number <= 0.0) {
                        return;
                    }
                    lastTileIndex = leafTiles.length - 1;
                    int n = firstTileIndex = (int)number < leafTiles.length ? leafTiles.length - (int)number : 0;
                    if (highlightSet.getResponse() == 20) {
                        while (firstTileIndex > 0 && leafTiles[firstTileIndex].colorValue == leafTiles[firstTileIndex - 1].colorValue) {
                            --firstTileIndex;
                        }
                    } else {
                        while (firstTileIndex > 0 && leafTiles[firstTileIndex].sizeValue == leafTiles[firstTileIndex - 1].sizeValue) {
                            --firstTileIndex;
                        }
                    }
                    break;
                }
                case 11: {
                    if (number <= 0.0) {
                        return;
                    }
                    int n = lastTileIndex = (int)number < leafTiles.length ? (int)number - 1 : leafTiles.length - 1;
                    if (highlightSet.getResponse() == 20) {
                        while (lastTileIndex < leafTiles.length - 1 && leafTiles[lastTileIndex].colorValue == leafTiles[lastTileIndex + 1].colorValue) {
                            ++lastTileIndex;
                        }
                    } else {
                        while (lastTileIndex < leafTiles.length - 1 && leafTiles[lastTileIndex].sizeValue == leafTiles[lastTileIndex + 1].sizeValue) {
                            ++lastTileIndex;
                        }
                    }
                    break;
                }
                case 12: {
                    int curIndex;
                    if (highlightSet.getResponse() == 20) {
                        if (this.cellModel.getTileChartModel().isColorVariableNumeric()) {
                            if (number < leafTiles[0].colorValue || number > leafTiles[leafTiles.length - 1].colorValue) {
                                curIndex = -1;
                                firstTileIndex = -1;
                            } else {
                                for (curIndex = 0; leafTiles[curIndex].colorValue < number && curIndex < leafTiles.length - 1; ++curIndex) {
                                }
                                if (leafTiles[curIndex].colorValue != number) {
                                    curIndex = -1;
                                    firstTileIndex = -1;
                                } else {
                                    firstTileIndex = curIndex++;
                                    while (curIndex < leafTiles.length - 1 && leafTiles[curIndex].colorValue == number) {
                                        ++curIndex;
                                    }
                                }
                            }
                        } else {
                            String searchStr = highlightSet.getFindStr();
                            if (leafTiles[0].formattedColor.compareTo(searchStr) > 0 || leafTiles[leafTiles.length - 1].formattedColor.compareTo(searchStr) < 0) {
                                curIndex = -1;
                                firstTileIndex = -1;
                            } else {
                                while (leafTiles[curIndex].formattedColor.compareTo(searchStr) < 0 && curIndex < leafTiles.length - 1) {
                                    ++curIndex;
                                }
                                if (leafTiles[curIndex].formattedColor.compareTo(searchStr) != 0) {
                                    curIndex = -1;
                                    firstTileIndex = -1;
                                } else {
                                    firstTileIndex = curIndex++;
                                    while (curIndex < leafTiles.length && leafTiles[curIndex].formattedColor.equals(searchStr)) {
                                        ++curIndex;
                                    }
                                }
                            }
                        }
                    } else if (number < leafTiles[0].sizeValue || number > leafTiles[leafTiles.length - 1].sizeValue) {
                        curIndex = -1;
                        firstTileIndex = -1;
                    } else {
                        while (leafTiles[curIndex].sizeValue < number && curIndex < leafTiles.length - 1) {
                            ++curIndex;
                        }
                        if (leafTiles[curIndex].sizeValue != number) {
                            curIndex = -1;
                            firstTileIndex = -1;
                        } else {
                            firstTileIndex = curIndex++;
                            while (curIndex < leafTiles.length - 1 && leafTiles[curIndex].sizeValue == number) {
                                ++curIndex;
                            }
                        }
                    }
                    lastTileIndex = curIndex - 1;
                    break;
                }
                case 13: {
                    int curIndex;
                    if (highlightSet.getResponse() == 20) {
                        while (curIndex < leafTiles.length && leafTiles[curIndex].colorValue <= number) {
                            ++curIndex;
                        }
                    } else {
                        while (curIndex < leafTiles.length && leafTiles[curIndex].sizeValue <= number) {
                            ++curIndex;
                        }
                    }
                    firstTileIndex = curIndex == leafTiles.length ? leafTiles.length : curIndex;
                    lastTileIndex = curIndex < leafTiles.length ? leafTiles.length - 1 : leafTiles.length;
                    break;
                }
                case 15: {
                    int curIndex;
                    if (highlightSet.getResponse() == 20) {
                        while (curIndex < leafTiles.length && leafTiles[curIndex].colorValue < number) {
                            ++curIndex;
                        }
                    } else {
                        while (curIndex < leafTiles.length && leafTiles[curIndex].sizeValue < number) {
                            ++curIndex;
                        }
                    }
                    firstTileIndex = curIndex == leafTiles.length ? leafTiles.length : curIndex;
                    lastTileIndex = curIndex < leafTiles.length ? leafTiles.length - 1 : leafTiles.length;
                    break;
                }
                case 14: {
                    int curIndex;
                    if (highlightSet.getResponse() == 20) {
                        if (number < leafTiles[0].colorValue) {
                            curIndex = -1;
                        } else if (leafTiles[leafTiles.length - 1].colorValue < number) {
                            curIndex = leafTiles.length - 1;
                        } else {
                            for (curIndex = leafTiles.length - 1; curIndex >= 0 && leafTiles[curIndex].colorValue >= number; --curIndex) {
                            }
                        }
                    } else if (number < leafTiles[0].sizeValue) {
                        curIndex = -1;
                    } else if (leafTiles[leafTiles.length - 1].colorValue < number) {
                        curIndex = leafTiles.length - 1;
                    } else {
                        for (curIndex = leafTiles.length - 1; curIndex >= 0 && leafTiles[curIndex].sizeValue >= number; --curIndex) {
                        }
                    }
                    lastTileIndex = curIndex;
                    break;
                }
                case 16: {
                    int curIndex;
                    if (highlightSet.getResponse() == 20) {
                        if (number < leafTiles[0].colorValue) {
                            curIndex = -1;
                        } else if (leafTiles[leafTiles.length - 1].colorValue <= number) {
                            curIndex = leafTiles.length - 1;
                        } else {
                            for (curIndex = leafTiles.length - 1; curIndex >= 0 && leafTiles[curIndex].colorValue > number; --curIndex) {
                            }
                        }
                    } else if (number < leafTiles[0].sizeValue) {
                        curIndex = -1;
                    } else if (leafTiles[leafTiles.length - 1].colorValue <= number) {
                        curIndex = leafTiles.length - 1;
                    } else {
                        for (curIndex = leafTiles.length; curIndex >= 0 && leafTiles[curIndex].sizeValue > number; --curIndex) {
                        }
                    }
                    lastTileIndex = curIndex;
                    break;
                }
            }
            if (firstTileIndex < 0 || lastTileIndex >= leafTiles.length) break block87;
            for (int ii = firstTileIndex; ii <= lastTileIndex; ++ii) {
                this.highlightTile(leafTiles[ii], highlightSet);
            }
        }
    }

    public void highlightTile(Tile tile, int highlightStyle) {
        TileChartHighlightModel highlightModel = new TileChartHighlightModel("__DATATIP__", "");
        highlightModel.setStyle(31);
        this.highlightTile(tile, highlightModel);
    }

    public void highlightTile(Tile tile, TileChartHighlightModel highlightModel) {
        if (tile.sizeValue <= 0.0 || this.isAnimating) {
            return;
        }
        Channel channel = this.getChannel();
        int highlightStyle = highlightModel.getStyle();
        switch (highlightStyle) {
            case 34: {
                LineStyle curLS = highlightModel.getOutline();
                if (curLS == null || curLS.getVisibilityPolicy() == 10202) break;
                channel.glPolygonMode(2);
                channel.glLineWidth((float)((int)curLS.getThickness().getMagnitude((Object)"px")));
                channel.glColor(curLS.getColor());
                channel.glRect(tile.rect.x, tile.rect.y, tile.rect.x + tile.rect.width, tile.rect.y + tile.rect.height);
                break;
            }
            case 32: {
                TextStyle curTS = highlightModel.getTextStyle();
                String labelText = this.tileChartRenderer.createTileLabel(tile, RendererUtil.DataLabel.ID);
                if (labelText == "") break;
                this.tileChartRenderer.drawTileLabel(labelText, tile, GTKUtil.mapToGTKTextStyle(curTS));
                break;
            }
            case 33: {
                if (highlightModel.getMarkerStyle() == null || highlightModel.getMarkerStyle().getSymbol() == -1) break;
                int markerSize = (int)highlightModel.getMarkerStyle().getSize().getMagnitude((Object)"px");
                double posx = tile.rect.x + tile.rect.width / 2.0;
                double posy = tile.rect.y + tile.rect.height / 2.0;
                double markerAdjust = markerSize / 2 + 3;
                switch (highlightModel.getMarkerPosition()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        posy += tile.rect.height / 2.0 - markerAdjust;
                        break;
                    }
                    case 5: {
                        posy = posy - tile.rect.height / 2.0 + markerAdjust;
                        break;
                    }
                    case 3: {
                        posx += tile.rect.width / 2.0 - markerAdjust;
                        break;
                    }
                    case 7: {
                        posx = posx - tile.rect.width / 2.0 + markerAdjust;
                        break;
                    }
                    case 2: {
                        posy += tile.rect.height / 2.0 - markerAdjust;
                        posx += tile.rect.width / 2.0 - markerAdjust;
                        break;
                    }
                    case 4: {
                        posy = posy - tile.rect.height / 2.0 + markerAdjust;
                        posx += tile.rect.width / 2.0 - markerAdjust;
                        break;
                    }
                    case 6: {
                        posy = posy - tile.rect.height / 2.0 + markerAdjust;
                        posx = posx - tile.rect.width / 2.0 + markerAdjust;
                        break;
                    }
                    case 8: {
                        posy += tile.rect.height / 2.0 - markerAdjust;
                        posx = posx - tile.rect.width / 2.0 + markerAdjust;
                        break;
                    }
                }
                channel.glEdgeColor(Color.black);
                channel.glColor(highlightModel.getMarkerStyle().getColor());
                channel.setMarkerType(highlightModel.getMarkerStyle().getSymbol());
                channel.setMarkerSize(markerSize);
                channel.glBegin(4);
                channel.glVertex(posx, posy);
                channel.glEnd();
                break;
            }
            case 38: {
                double destWidth;
                double destHeight;
                if (highlightModel.getImage() == null) break;
                channel.glTexEnv(10, 2, 4);
                channel.glTexEnv(10, 1, 2);
                Image fillImage = highlightModel.getImage().getImage();
                if (fillImage == null || highlightModel.getImage().getIconHeight() <= 0 || highlightModel.getImage().getIconHeight() <= 0) break;
                channel.glTexImage2D(fillImage);
                channel.glColor(tile.fillColor);
                channel.glEnable(10);
                channel.glEnable(12);
                channel.glPolygonMode(3);
                double fillImageAspect = (double)highlightModel.getImage().getIconHeight() / (double)highlightModel.getImage().getIconWidth();
                double tileAspect = tile.rect.height / tile.rect.width;
                if (fillImageAspect > tileAspect) {
                    destHeight = tile.rect.height;
                    destWidth = destHeight / fillImageAspect;
                } else {
                    destWidth = tile.rect.width;
                    destHeight = destWidth * fillImageAspect;
                }
                double adjustFactor = 0.85;
                double x1 = tile.rect.x + (tile.rect.width - (destWidth *= adjustFactor)) / 2.0;
                double y1 = tile.rect.y + (tile.rect.height - (destHeight *= adjustFactor)) / 2.0;
                double x2 = x1 + destWidth;
                double y2 = y1 + destHeight;
                channel.glRect(x1, y1, x2, y2);
                channel.glDisable(10);
                break;
            }
            case 30: 
            case 31: 
            case 36: 
            case 37: {
                if (highlightStyle == 35) break;
                TextStyle ts = highlightModel.getTextStyle();
                Color bg = highlightModel.getBackground().getSolidFillColor();
                Color windowBG = this.cellModel.getTileChartModel().getBackgroundFillStyle().getSolidFillColor();
                if (bg.getRed() == windowBG.getRed() && bg.getGreen() == windowBG.getGreen() && bg.getBlue() == windowBG.getBlue()) {
                    bg = new Color(Math.max(bg.getRed() - 15, 0), Math.max(bg.getGreen() - 15, 0), Math.max(bg.getBlue() - 15, 0), bg.getAlpha());
                }
                String s = this.toDataTip(tile, highlightStyle, this.idLabel);
                channel.glSelect2DFont(ts.getFont());
                double tipWidth = channel.glGetTextWidth(s);
                double textHeight = channel.glGetTextHeight(s);
                boolean leftOfTile = false;
                boolean arrowAtBottom = false;
                boolean supressArrow = false;
                double posx = tile.rect.x + tile.rect.width;
                if (tile.rect.x - this.tileChartRendererModel.getCurrentRootTile().rect.x > this.tileChartRendererModel.getCurrentRootTile().rect.x + this.tileChartRendererModel.getCurrentRootTile().rect.width - (tile.rect.x + tile.rect.width)) {
                    posx = tile.rect.x;
                    leftOfTile = true;
                }
                if (leftOfTile && tile.rect.x - (tipWidth + 15.0) < (double)this.globalBounds.x) {
                    supressArrow = true;
                    posx = tile.rect.x + tile.rect.width / 2.0 + 15.0;
                } else if (!leftOfTile && tile.rect.x + tile.rect.width + (tipWidth + 15.0) > (double)(this.globalBounds.x + this.globalBounds.width)) {
                    supressArrow = true;
                    posx = tile.rect.x + tile.rect.width / 2.0 - 15.0;
                }
                if (!leftOfTile && supressArrow && posx + tipWidth + 15.0 > this.tileChartRendererModel.getCurrentRootTile().rect.x + this.tileChartRendererModel.getCurrentRootTile().rect.width) {
                    posx = 0.0;
                } else if (leftOfTile && supressArrow && posx - (tipWidth + 15.0) < this.tileChartRendererModel.getCurrentRootTile().rect.x) {
                    posx = this.tileChartRendererModel.getCurrentRootTile().rect.x - 15.0;
                    leftOfTile = false;
                }
                double posy = tile.rect.y + tile.rect.height / 2.0;
                if (posy < this.tileChartRendererModel.getCurrentRootTile().rect.height / 2.0) {
                    arrowAtBottom = true;
                }
                if (!arrowAtBottom && posy + 4.0 - textHeight < (double)this.globalBounds.y) {
                    posy = tile.rect.y + tile.rect.height - 4.0;
                } else if (arrowAtBottom && posy - 4.0 + textHeight > (double)this.globalBounds.height) {
                    posy = tile.rect.y + 4.0;
                }
                channel.glColor(bg);
                channel.glPolygonMode(3);
                channel.glBegin(2);
                channel.glTextAlign(0, 0);
                if (leftOfTile) {
                    if (!supressArrow) {
                        channel.glVertex(posx - 15.0, posy + 4.0, 0.0);
                        channel.glVertex(posx - 15.0, posy - 4.0, 0.0);
                        channel.glVertex(posx, posy, 0.0);
                    }
                    channel.glEnd();
                    channel.glColor(SHADOW_COLOR);
                    if (arrowAtBottom) {
                        channel.glColor(bg);
                        channel.glRect(posx - 15.0 - 1.0, posy - 4.0, posx - 15.0 - (channel.glGetTextWidth(s) + 5.0), posy - 4.0 + textHeight);
                    } else {
                        channel.glColor(bg);
                        channel.glRect(posx - 15.0 - 1.0, posy + 4.0, posx - 15.0 - (channel.glGetTextWidth(s) + 5.0), posy + 4.0 - textHeight);
                    }
                    channel.glColor(ts.getColor());
                    if (ts.getShadowStyle() != null && ts.getShadowStyle().isVisible()) {
                        channel.glEnable(11);
                        channel.setShadowColor(ts.getShadowStyle().getColor());
                        channel.setShadowOffset((int)ts.getShadowStyle().getOffsetX().getMagnitude((Object)"px"), (int)ts.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
                        channel.setShadowSoftness((float)ts.getShadowStyle().getSoftness());
                    }
                    if (arrowAtBottom) {
                        channel.gl2DText(s, posx - 15.0 - (channel.glGetTextWidth(s) + 2.0), posy - 4.0 + textHeight, 0.0);
                        break;
                    }
                    channel.gl2DText(s, posx - 15.0 - (channel.glGetTextWidth(s) + 2.0), posy + 4.0, 0.0);
                    break;
                }
                if (!supressArrow) {
                    channel.glVertex(posx + 15.0, posy + 4.0, 0.0);
                    channel.glVertex(posx + 15.0, posy - 4.0, 0.0);
                    channel.glVertex(posx, posy, 0.0);
                }
                channel.glEnd();
                channel.glColor(SHADOW_COLOR);
                if (arrowAtBottom) {
                    channel.glColor(bg);
                    channel.glRect(posx + 15.0, posy - 4.0, posx + 15.0 + channel.glGetTextWidth(s) + 4.0, posy - 4.0 + textHeight);
                } else {
                    channel.glColor(bg);
                    channel.glRect(posx + 15.0, posy + 4.0, posx + 15.0 + channel.glGetTextWidth(s) + 4.0, posy + 4.0 - textHeight);
                }
                channel.glSelect2DFont(ts.getFont());
                channel.glColor(ts.getColor());
                if (ts.getShadowStyle() != null && ts.getShadowStyle().isVisible()) {
                    channel.glEnable(11);
                    channel.setShadowColor(ts.getShadowStyle().getColor());
                    channel.setShadowOffset((int)ts.getShadowStyle().getOffsetX().getMagnitude((Object)"px"), (int)ts.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
                    channel.setShadowSoftness((float)ts.getShadowStyle().getSoftness());
                }
                if (arrowAtBottom) {
                    channel.gl2DText(s, posx + 15.0 + 3.0, posy - 4.0 + textHeight, 0.0);
                    break;
                }
                channel.gl2DText(s, posx + 15.0 + 3.0, posy + 4.0, 0.0);
                break;
            }
        }
    }

    public String toDataTip(Tile tile, int detail) {
        return this.toDataTip(tile, detail, null);
    }

    public String toDataTip(Tile tile, int detail, String[] labels) {
        String tip;
        tile.formattedSize = tile.formattedSize.trim();
        tile.formattedColor = tile.formattedColor.trim();
        switch (detail) {
            case 30: {
                tip = tile.idValue;
                break;
            }
            case 36: {
                tip = labels[labels.length - 3] + ": " + tile.idValue + "\n" + labels[labels.length - 2] + ": " + tile.formattedSize;
                if (labels[labels.length - 2].equals(labels[labels.length - 1])) break;
                tip = tip + "\n" + labels[labels.length - 1] + ": " + tile.formattedColor;
                break;
            }
            case 31: {
                tip = tile.idPathMultiLine(labels);
                break;
            }
            case 37: {
                tip = "Custom";
                break;
            }
            default: {
                tip = "";
            }
        }
        return tip.trim();
    }

    public void highlightTiles(Tile[] tiles, int highlightStyle) {
        for (int ii = 0; ii < tiles.length; ++ii) {
            this.highlightTile(tiles[ii], highlightStyle);
        }
    }

    protected double getLowColorDataValue() {
        return this.lowColorDataValue;
    }

    protected double getHighColorDataValue() {
        return this.highColorDataValue;
    }

    protected void setLowColorLegendValue(double l) {
        this.lowColorLegendValue = l;
    }

    protected double getLowColorLegendValue() {
        return this.lowColorLegendValue;
    }

    protected void setHighColorLegendValue(double h) {
        this.highColorLegendValue = h;
    }

    protected double getHighColorLegendValue() {
        return this.highColorLegendValue;
    }

    protected void setLegendColorPositions(double[] pos) {
        this.legendColorPositions = pos;
        this.mapColors();
    }

    protected double[] getLegendColorPositions() {
        return this.legendColorPositions;
    }

    protected void setLegendColors(Color[] cols) {
        this.legendColors = cols;
        this.mapColors();
    }

    protected Color[] getLegendColors() {
        return this.legendColors;
    }

    private void mapColors() {
        ColorMapper colorMapper;
        int ii;
        Color[] newCols;
        double[] newVals;
        Color[] colors = this.getLegendColors();
        double[] values = this.getLegendColorPositions();
        if (values != null && colors.length != values.length) {
            return;
        }
        if (values != null && values[0] > 0.0) {
            newVals = new double[values.length + 1];
            newCols = new Color[colors.length + 1];
            newVals[0] = 0.0;
            newCols[0] = colors[0];
            for (ii = 0; ii < values.length; ++ii) {
                newVals[ii + 1] = values[ii];
                newCols[ii + 1] = colors[ii];
            }
            values = newVals;
            colors = newCols;
        }
        if (values != null && values[values.length - 1] < 1.0) {
            newVals = new double[values.length + 1];
            newCols = new Color[colors.length + 1];
            for (ii = 0; ii < values.length; ++ii) {
                newVals[ii] = values[ii];
                newCols[ii] = colors[ii];
            }
            newVals[values.length] = 1.0;
            newCols[colors.length] = colors[colors.length - 1];
            values = newVals;
            colors = newCols;
        }
        if ((colorMapper = this.tileChartRendererModel.getColorMapper()) instanceof ContinuousRangeToColorMapper) {
            if (colors != null) {
                ((ContinuousRangeToColorMapper)colorMapper).setColorSpectrumColors(colors);
                if (values == null || values.length < 1 || colors.length != values.length) {
                    values = this.distributePositionsEvenly(colors.length);
                }
                ((ContinuousRangeToColorMapper)colorMapper).setColorSpectrumValues(values);
            }
            ((ContinuousRangeToColorMapper)colorMapper).input.connectFrom((NumericPipe)this.missingVals);
        }
        this.tileChartRenderer.initColorMapper();
    }

    private double[] distributePositionsEvenly(int num) {
        double[] nv = new double[num];
        for (int ii = 0; ii < num; ++ii) {
            nv[ii] = num > 1 ? (double)ii / ((double)num - 1.0) : 0.0;
        }
        return nv;
    }

    @Override
    protected PickInfo[] select(int x, int y, int w, int h, boolean isControlDown, boolean isSelectClosest, boolean isModified) {
        block4: {
            block6: {
                ArrayList tileList;
                block5: {
                    if (this.getSelectRoot() == null || this.getSelectionModel() == null || w <= 0 || h <= 0 || (tileList = this.tileChartRenderer.getTileAtPosition((Rectangle2D)new Rectangle(x, this.globalBounds.height - y, w, h), this.isAnimating)) == null || tileList.size() <= 0) break block4;
                    if (!isSelectClosest) break block5;
                    if (tileList.size() <= 0) break block6;
                    Tile tile = (Tile)tileList.get(0);
                    DataTreeGroupNode gn = (DataTreeGroupNode)tile.treeNode;
                    Iterator iter = gn.getValueIndexIterator();
                    if (!iter.hasNext()) break block6;
                    Integer bigI = (Integer)iter.next();
                    int valueIndex = bigI;
                    if (this.dataSource.isOLAPData()) {
                        isModified = this.select(valueIndex, this.sizeVariable.getColumnName(), isControlDown, isSelectClosest, isModified);
                        isModified = this.select(valueIndex, this.colorVariable.getColumnName(), isControlDown, isSelectClosest, isModified);
                    } else {
                        isModified = this.select(valueIndex, this.sizeVariable.getColumnName(), isControlDown, isSelectClosest, isModified);
                    }
                    break block6;
                }
                for (int ii = 0; ii < tileList.size(); ++ii) {
                    Tile tile = (Tile)tileList.get(ii);
                    DataTreeGroupNode gn = (DataTreeGroupNode)tile.treeNode;
                    Iterator iter = gn.getValueIndexIterator();
                    while (iter.hasNext()) {
                        int valueIndex = (Integer)iter.next();
                        isModified = this.select(valueIndex, this.sizeVariable.getColumnName(), isControlDown, isSelectClosest, isModified);
                        isModified = this.select(valueIndex, this.colorVariable.getColumnName(), isControlDown, isSelectClosest, isModified);
                    }
                }
            }
            this.repaint();
        }
        return null;
    }

    public ChartImageMapInfo2 getImageMapInfo() {
        if (this.tileChartRendererModel.isTreeToBeRecreated()) {
            this.recalculateDataValues(this.tileChartRendererModel.getCurrentRootTile().treeNode);
            this.updateDatatipLabels(false);
            this.setUpLevelName2RectHash();
            this.tileChartRenderer.startCreateTree(this.tileChartRendererModel.getCurrentRootTile().treeNode, this.tileChartRendererModel.getCurrentRootTile().rect, new Point2D.Double(this.tileChartRendererModel.getCurrentRootTile().rect.x, this.tileChartRendererModel.getCurrentRootTile().rect.y));
            this.tileChartRendererModel.setTreeToBeRecreated(false);
        }
        ChartImageMapInfo2 tileChartImageMapInfo = null;
        ArrayList<ChartValueZone> dataElementValueZonesAL = new ArrayList<ChartValueZone>();
        ArrayList<LabelZoneList> lzlAL = new ArrayList<LabelZoneList>();
        LabelZoneList categoryLabelZoneList = null;
        LabelZoneList curLZL = null;
        LabelZoneList thisLZL = null;
        Vector selectableShapes = this.tileChartRenderer.computeSelectableShapes();
        for (int i = 0; i < selectableShapes.size(); ++i) {
            Tile tile;
            SelectableShape sShape = (SelectableShape)selectableShapes.get(i);
            TileChartRendererSelectResult selectResult = (TileChartRendererSelectResult)sShape.getSelectResult();
            if (((TileSelectDetail)selectResult.getDetail()).getType() == 1) {
                TileSelectDetail tileDetail = (TileSelectDetail)selectResult.getDetail();
                thisLZL = new LabelZoneList(sShape.getShape(), tileDetail.getVariableName(), tileDetail.getVariableLabel(), null);
                lzlAL.add(thisLZL);
                continue;
            }
            ValueList categoryValueList = null;
            ValueList lastVL = null;
            ValueList curVL = null;
            Tile tempTile = tile = ((TileSelectDetail)selectResult.getDetail()).getTile();
            Object o = ((DataTreeGroupNode)tile.treeNode).getValue();
            String[] path = tile.getPath();
            DataTreeGroupNode tempGN = (DataTreeGroupNode)tile.treeNode;
            DefaultMutableTreeNode stashedRootNode = null;
            if (o instanceof TupleElementInterface) {
                while (tempGN.getParent() instanceof DataTreeGroupNode) {
                    tempGN = (DataTreeGroupNode)tempGN.getParent();
                }
                stashedRootNode = (DefaultMutableTreeNode)tempGN.getParent();
                tempGN.setParent(null);
                curVL = Util.DataTreeGroupNodeUtil.toValueList((DataTreeGroupNode)tile.treeNode);
                tempGN.setParent((MutableTreeNode)stashedRootNode);
            } else {
                for (int l = path.length - 1; l >= 0; --l) {
                    lastVL = curVL = new ValueList(path[l], path[l], lastVL);
                }
            }
            categoryValueList = curVL;
            ValueList colorResponseValueList = new ValueList(new Double(tile.colorValue), tile.formattedColor, null);
            colorResponseValueList = this.cellModel.isColorVariableDiscrete() ? new ValueList(tile.colorLabel, tile.formattedColor.trim(), null) : new ValueList(new Double(tile.colorValue), tile.formattedColor.trim(), null);
            ValueList responseValueList = new ValueList(new Double(tile.sizeValue), tile.formattedSize, colorResponseValueList);
            int obsIndex = selectResult.getValueIndex();
            ValueList dataTipValueList = GTKUtil.toValueList(this.dataTipVariableArray, obsIndex);
            ValueList auxiliaryValueList = GTKUtil.toValueList(this.auxiliaryVariableArray, obsIndex);
            ChartValueZone elementValueZone = new ChartValueZone(sShape.getShape(), null, null, categoryValueList, null, responseValueList, null, dataTipValueList, auxiliaryValueList);
            dataElementValueZonesAL.add(elementValueZone);
        }
        ChartValueZone[] dataElementValueZones = dataElementValueZonesAL.toArray(new ChartValueZone[0]);
        LabelZoneList lastLZL = null;
        for (int ii = lzlAL.size() - 1; ii >= 0; --ii) {
            thisLZL = (LabelZoneList)lzlAL.get(ii);
            lastLZL = curLZL = new LabelZoneList(thisLZL.getShape(), thisLZL.getName(), thisLZL.getLabel(), lastLZL);
        }
        categoryLabelZoneList = curLZL;
        tileChartImageMapInfo = new ChartImageMapInfo2(null, null, null, null, dataElementValueZones, null, null, categoryLabelZoneList, null, null, null);
        tileChartImageMapInfo.source = this;
        return tileChartImageMapInfo;
    }

    public void setActionVisible(String arg0, String arg1, boolean arg2) {
    }

    public boolean isActionVisible(String arg0, String arg1) {
        return true;
    }

    public Collection listAreaTypes() {
        return null;
    }

    public Collection listActionTypes(String arg0) {
        return null;
    }

    public void setActionSupportType(String arg0) {
    }

    public String getActionSupportType() {
        return null;
    }

    public Object getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(Object uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void zoomTo(Tile dt, boolean as) {
        this.tileChartRendererModel.setRootPath(null);
        if (dt == null) {
            return;
        }
        this.drillTile = dt;
        this.aspect = as;
        this.animateDataZoom();
    }

    private void calculateLocalDataRange(Tile localRoot) {
        int numVisibleLevels = 0;
        numVisibleLevels = this.tileChartRenderer.isOLAPData(this.tileChartRendererModel.getTileVariable()) ? this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1 : Math.min(this.tileChartRendererModel.getDetailLevel(), this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1);
        double lowD = Double.POSITIVE_INFINITY;
        double highD = Double.NEGATIVE_INFINITY;
        DefaultMutableTreeNode lrNode = localRoot.treeNode;
        Enumeration<TreeNode> en = lrNode.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)en.nextElement();
            if (!this.tileChartRenderer.isLeafTile(curNode) && curNode.getDepth() != numVisibleLevels - 1 || !(curNode instanceof DataTreeGroupNode)) continue;
            DataTreeGroupNode curGroupNode = (DataTreeGroupNode)curNode;
            Tile curTile = (Tile)curGroupNode.getUserObject();
            if (curTile.missingColor == null && curTile.sizeValue > 0.0) {
                highD = Math.max(highD, curTile.colorValue);
                lowD = Math.min(lowD, curTile.colorValue);
                continue;
            }
            if (curTile.missingColor == null) continue;
            this.missingVals.addValue(curTile.missingColor);
        }
        if (lowD <= highD) {
            this.lowColorDataValue = lowD;
            this.highColorDataValue = highD;
        }
    }

    public Tile getTileAtPosition(Point2D point) {
        if (this.tileChartRendererModel.getCurrentRootTile() == null || this.tileChartRendererModel.getCurrentRootTile().treeNode == null || this.tileChartRendererModel.getCurrentRootTile().sizeValue <= 0.0) {
            return null;
        }
        return this.tileChartRenderer.getTileAtPosition(point, this.tileChartRendererModel.getCurrentRootTile().treeNode, this.isAnimating);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cellModel.getPreferredSize() == null) {
            return new Dimension(20, 20);
        }
        return this.cellModel.getPreferredSize();
    }

    public Dimension getIndividualPreferredSize() {
        return new Dimension(640, 480);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public PickInfo pick(int x, int y) {
        int numVisibleLevels = 0;
        numVisibleLevels = this.tileChartRenderer.isOLAPData(this.tileChartRendererModel.getTileVariable()) ? this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1 : Math.min(this.tileChartRendererModel.getDetailLevel(), this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1);
        PickInfo pickInfo = null;
        Tile tile = this.getTileAtPosition(new Point2D.Double(x, this.getBounds().height - y));
        if (tile != null) {
            if (((DataTreeGroupNode)tile.treeNode).getValueIndexCount() > 1 || numVisibleLevels < this.idVariableArray.length) {
                Vector lvp = new Vector();
                DefaultMutableTreeNode curNode = tile.treeNode;
                if (this.cellModel.getTileChartModel().getDataTipModel().getContent() == 11401 && this.dataTipVariableArray != null && this.dataTipVariableArray.length > 0) {
                    for (int ii = 0; ii < this.dataTipVariableArray.length; ++ii) {
                        Hashtable<String, Object> entry = new Hashtable<String, Object>();
                        entry.put(PickInfo.VISIBLE, Boolean.TRUE);
                        if (this.dataTipVariableArray.length > 1) {
                            entry.put(PickInfo.ID, this.dataTipRole.toString() + ii);
                        } else {
                            entry.put(PickInfo.ID, this.dataTipRole);
                        }
                        entry.put(PickInfo.LABEL, this.dataTipVariableArray[ii].getLabel());
                        entry.put(PickInfo.VALUE, ((Tile)curNode.getUserObject()).formattedDataTip[ii]);
                        entry.put(PickInfo.FORMATTED_VALUE, ((Tile)curNode.getUserObject()).formattedDataTip[ii]);
                        lvp.add(entry);
                    }
                } else {
                    this.curLevel = this.tileChartRendererModel.getCurrentRootTile().treeNode.getLevel();
                    for (int ii = numVisibleLevels + this.curLevel - 1; ii > this.curLevel - 1; --ii) {
                        Hashtable<String, Object> entry = new Hashtable<String, Object>();
                        entry.put(PickInfo.VISIBLE, Boolean.TRUE);
                        if (this.idVariableArray.length > 1) {
                            entry.put(PickInfo.ID, this.idRole.toString() + ii);
                        } else {
                            entry.put(PickInfo.ID, this.idRole);
                        }
                        entry.put(PickInfo.LABEL, this.idVariableArray[ii - 1].getLabel());
                        entry.put(PickInfo.VALUE, ((Tile)curNode.getUserObject()).idValue);
                        entry.put(PickInfo.FORMATTED_VALUE, ((Tile)curNode.getUserObject()).idValue);
                        curNode = (DefaultMutableTreeNode)curNode.getParent();
                        lvp.add(0, entry);
                    }
                    if (this.sizeVariable != null) {
                        Hashtable<String, Object> entry = new Hashtable<String, Object>();
                        entry.put(PickInfo.VISIBLE, Boolean.TRUE);
                        entry.put(PickInfo.ID, this.sizeRole);
                        entry.put(PickInfo.LABEL, this.sizeVariable.getLabel().trim());
                        entry.put(PickInfo.VALUE, new Double(tile.sizeValue));
                        entry.put(PickInfo.FORMATTED_VALUE, tile.formattedSize.trim());
                        lvp.add(entry);
                    }
                    if (this.colorVariable != null && (!this.colorVariable.getLabel().trim().equals(this.sizeVariable.getLabel().trim()) || tile.colorValue != tile.sizeValue && !this.cellModel.isColorVariableDiscrete())) {
                        Hashtable<String, Object> entry = new Hashtable<String, Object>();
                        entry.put(PickInfo.VISIBLE, Boolean.TRUE);
                        entry.put(PickInfo.ID, this.colorRole);
                        entry.put(PickInfo.LABEL, this.colorVariable.getLabel().trim());
                        if (this.cellModel.isColorVariableDiscrete()) {
                            entry.put(PickInfo.VALUE, tile.colorLabel.trim());
                        } else {
                            entry.put(PickInfo.VALUE, new Double(tile.colorValue));
                        }
                        entry.put(PickInfo.FORMATTED_VALUE, tile.formattedColor.trim());
                        lvp.add(entry);
                    }
                }
                pickInfo = new PickInfo(new Vector[]{lvp}, ((DataTreeGroupNode)tile.treeNode).getFirstValueIndex(), this.getDataSource().getModel(), x, y, null);
            } else {
                int index = ((DataTreeGroupNode)tile.treeNode).getFirstValueIndex();
                pickInfo = new PickInfo(this.getLabelValuePairs(index), index, this.getDataSource().getModel(), x, y, null);
            }
        }
        return pickInfo;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        Rectangle b = this.getBounds();
        return new PickInfo(this.getLabelValuePairs(obsIndex), obsIndex, this.getDataSource().getModel(), b.width / 2, 0, null);
    }

    private boolean doesEntryExist(Vector labelValuePairs, String label, String formattedValue) {
        boolean found = false;
        for (int i = 0; i < labelValuePairs.size(); ++i) {
            Hashtable ht = (Hashtable)labelValuePairs.get(i);
            String entryLabel = (String)ht.get(PickInfo.LABEL);
            String entryFmtValue = (String)ht.get(PickInfo.FORMATTED_VALUE);
            if (!entryLabel.equals(label) || !entryFmtValue.equals(formattedValue)) continue;
            found = true;
            break;
        }
        return found;
    }

    private Vector[] getLabelValuePairs(int obsIndex) {
        Vector labelValuePairs = new Vector();
        boolean nonTipVarsVisible = this.dataTipVariableArray == null || this.dataTipVariableArray.length <= 0 || this.dataTipVariableArray[0] == null || this.cellModel.getTileChartModel().getDataTipModel().getContent() != 11401;
        GTKUtil.PickInfoAccess.addLabelValuePairs_ReverseOrder(labelValuePairs, this.idRole, this.idVariableArray, obsIndex, nonTipVarsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.sizeRole, this.sizeVariable, obsIndex, nonTipVarsVisible);
        Object co = GTKUtil.VariableAccess.getValue(this.colorVariable, obsIndex);
        double cv = co instanceof Double ? (Double)co : Double.NaN;
        double sv = (Double)GTKUtil.VariableAccess.getValue(this.sizeVariable, obsIndex);
        String fcv = GTKUtil.VariableAccess.getFormattedValueTrim(this.colorVariable, obsIndex);
        String fsv = GTKUtil.VariableAccess.getFormattedValueTrim(this.sizeVariable, obsIndex);
        if (this.colorVariable != null && !this.doesEntryExist(labelValuePairs, this.colorVariable.getLabel(), fcv)) {
            GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.colorRole, this.colorVariable, obsIndex, nonTipVarsVisible);
        }
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.dataTipRole, this.dataTipVariableArray, obsIndex, true);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.auxiliaryRole, this.auxiliaryVariableArray, obsIndex, false);
        return new Vector[]{labelValuePairs};
    }

    private String trimEndCommas(String s, boolean reverse) {
        if (reverse) {
            int endComma = s.length() - 2;
            int beginComma = s.length() - 2;
            String revS = "";
            while (beginComma > 0 && (beginComma = s.lastIndexOf(",", endComma - 1)) >= 0) {
                revS = revS + s.substring(beginComma + 2, endComma + 1);
                endComma = beginComma;
            }
            if (beginComma < 0) {
                revS = revS + s.substring(0, endComma + 1) + " ";
            }
            s = revS;
        }
        while (s.trim().endsWith(",")) {
            s = s.trim();
            s = s.substring(0, s.length() - 1);
        }
        while (s.trim().startsWith(",")) {
            s = s.trim();
            s = s.substring(1, s.length());
        }
        return s;
    }

    public JPopupMenu newPopupMenu(int x, int y) {
        DataTreeGroupNode gn;
        if (this.isAnimating) {
            return null;
        }
        Point2D.Double p = new Point2D.Double(x, this.getBounds().height - y);
        this.tt = this.getTileAtPosition(p);
        DataTreeGroupNode dataTreeGroupNode = gn = this.tt != null ? (DataTreeGroupNode)this.tt.treeNode : null;
        if (gn != null && gn.getValue() instanceof TupleElementInterface) {
            while (gn.getLevelIndex() != 0) {
                gn = (DataTreeGroupNode)gn.getParent();
            }
            TupleElementInterface tupleElement = (TupleElementInterface)gn.getValue();
            try {
                this.columnFilter.setAttribute("tupleElement", (Object)tupleElement);
                this.columnFilter.setAttribute("isMeasure", (Object)Boolean.FALSE);
                Object object = this.columnFilter.getAttribute("model");
                if (object instanceof BusinessQueryToOLAPDataSetAdapter) {
                    try {
                        Method getBusinessQueryMethod = object.getClass().getMethod("getBusinessQuery", null);
                        Object businessQuery = getBusinessQueryMethod.invoke(object, null);
                        Class<?> olapCellRendererManagerClass = Class.forName("com.sas.swing.visuals.olaptableview.OLAPCellRendererManager");
                        Class[] classes = new Class[]{Class.forName("com.sas.iquery.metadata.business.BusinessQuery"), TupleElementInterface.class};
                        Method findDataItemMethod = olapCellRendererManagerClass.getMethod("findDataItem", classes);
                        Object dataItem = findDataItemMethod.invoke(null, businessQuery, tupleElement);
                        this.columnFilter.setAttribute("dataItem", dataItem);
                    }
                    catch (SecurityException getBusinessQueryMethod) {
                    }
                    catch (NoSuchMethodException getBusinessQueryMethod) {
                    }
                    catch (IllegalArgumentException getBusinessQueryMethod) {
                    }
                    catch (IllegalAccessException getBusinessQueryMethod) {
                    }
                    catch (InvocationTargetException getBusinessQueryMethod) {
                    }
                    catch (ClassNotFoundException getBusinessQueryMethod) {}
                }
            }
            catch (AttributeSetException e) {
                e.printStackTrace();
            }
            if (this.actionProvider != null) {
                com.sas.actionprovider.ActionList actions = this.actionProvider.getActions(this.columnFilter);
                return this.actionUIFactory.getPopupMenu((ActionList)actions);
            }
        } else if (this.tileChartRenderer.isOLAPData(this.idVariableArray)) {
            SelectableShape selectableShape = this.getStatusLineAtPosition(p);
            if (selectableShape != null) {
                block51: {
                    TileChartRendererSelectResult selectResult = (TileChartRendererSelectResult)selectableShape.getSelectResult();
                    TileSelectDetail tileDetail = (TileSelectDetail)selectResult.getDetail();
                    String levelName = tileDetail.getVariableName();
                    try {
                        OLAPLevelVariable olv = (OLAPLevelVariable)this.idVariableArray[this.curLevel];
                        int axisNum = olv.getFactory().getAxisNumber(levelName);
                        AxisInterface axis = null;
                        try {
                            axis = olv.getFactory().getResultSet().getResultSetMetadata().getAxes(axisNum, 1)[0];
                            this.titleFilter.setAttribute("uniqueLevelName", (Object)levelName);
                            this.titleFilter.setAttribute("axisLabel", (Object)olv.getHierachyLabel());
                            this.titleFilter.setAttribute("axis", (Object)axis);
                            this.titleFilter.setAttribute("levelLabel", (Object)tileDetail.getVariableLabel());
                            this.titleFilter.setAttribute("isMeasure", (Object)Boolean.FALSE);
                            Object object = this.columnFilter.getAttribute("model");
                            if (!(object instanceof BusinessQueryToOLAPDataSetAdapter)) break block51;
                            try {
                                Method getBusinessQueryMethod = object.getClass().getMethod("getBusinessQuery", null);
                                Object businessQuery = getBusinessQueryMethod.invoke(object, null);
                                Class<?> olapCellRendererManagerClass = Class.forName("com.sas.swing.visuals.olaptableview.OLAPCellRendererManager");
                                Class[] classes = new Class[]{Class.forName("com.sas.iquery.metadata.business.BusinessQuery"), OLAPDataSetInterface.class, String.class};
                                Method findDataItemMethod = olapCellRendererManagerClass.getMethod("findDataItem", classes);
                                Object dataItem = findDataItemMethod.invoke(null, businessQuery, object, levelName);
                                this.titleFilter.setAttribute("dataItem", dataItem);
                            }
                            catch (SecurityException getBusinessQueryMethod) {
                            }
                            catch (NoSuchMethodException getBusinessQueryMethod) {
                            }
                            catch (IllegalArgumentException getBusinessQueryMethod) {
                            }
                            catch (IllegalAccessException getBusinessQueryMethod) {
                            }
                            catch (InvocationTargetException getBusinessQueryMethod) {
                            }
                            catch (ClassNotFoundException getBusinessQueryMethod) {
                            }
                        }
                        catch (OLAPException e1) {
                            e1.printStackTrace();
                        }
                    }
                    catch (AttributeSetException e) {
                        e.printStackTrace();
                    }
                }
                if (this.actionProvider != null) {
                    com.sas.actionprovider.ActionList actions = this.actionProvider.getActions(this.titleFilter);
                    return this.actionUIFactory.getPopupMenu((ActionList)actions);
                }
            }
        } else if (this.tt != null) {
            Tile curTile = this.tt;
            ArrayList<Tile> levels = new ArrayList<Tile>();
            while (curTile.idValue != rootTileName) {
                levels.add(curTile);
                curTile = (Tile)((DefaultMutableTreeNode)curTile.treeNode.getParent()).getUserObject();
            }
            JPopupMenu popup = new JPopupMenu();
            String zoomInTo = null;
            int drillLevel = this.zoomNames.size();
            if (levels.size() - this.zoomNames.size() - 1 >= 0) {
                zoomInTo = ((Tile)levels.get((int)(levels.size() - this.zoomNames.size() - 1))).idValue;
            }
            if (this.zoomNames.size() + 1 < this.idVariableArray.length) {
                JMenuItem zoomInItem = new JMenuItem(RB.getStringResource("TileChartCell.", "DrillDownMenuEntry.txt") + " " + zoomInTo);
                zoomInItem.addActionListener(this.myActionHandler);
                zoomInItem.setActionCommand(ZOOM_IN_ACTION_COMMAND);
                popup.add(zoomInItem);
            }
            if (this.zoomNames.size() > 0) {
                String zoomOutTo = this.idVariableArray[this.zoomNames.size() - 1].getLabel();
                JMenuItem zoomOutItem = new JMenuItem(RB.getStringResource("TileChartCell.", "DrillUpMenuEntry.txt") + " " + zoomOutTo);
                zoomOutItem.addActionListener(this.myActionHandler);
                zoomOutItem.setActionCommand(ZOOM_OUT_ACTION_COMMAND);
                popup.add(zoomOutItem);
            }
            if (this.tt.webLinks != null && this.tt.webLinks.length > 0) {
                if (popup.getSubElements().length > 0) {
                    popup.addSeparator();
                }
                String[] preLabels = new String[this.cellModel.getTileChartModel().getWebLabels().length];
                System.arraycopy(this.cellModel.getTileChartModel().getWebLabels(), 0, preLabels, 0, this.cellModel.getTileChartModel().getWebLabels().length);
                String[] preLinks = new String[this.cellModel.getTileChartModel().getWebLinks().length];
                System.arraycopy(this.cellModel.getTileChartModel().getWebLinks(), 0, preLinks, 0, this.cellModel.getTileChartModel().getWebLinks().length);
                int count = drillLevel;
                ArrayList levPops = this.cellModel.getTileChartModel().getLevLabels();
                if (levPops != null && levPops.size() > 0 && preLabels.length == 0) {
                    ArrayList<String> allLabelsAtLevel = new ArrayList<String>();
                    ArrayList<String> allValuesAtLevel = new ArrayList<String>();
                    for (ArrayList array : levPops) {
                        try {
                            LabelValuePair pair = (LabelValuePair)array.get(drillLevel);
                            allLabelsAtLevel.add(pair.getLabel());
                            allValuesAtLevel.add(pair.getValue());
                        }
                        catch (Exception pair) {}
                    }
                    String[] labels = allLabelsAtLevel.toArray(new String[0]);
                    String[] values = allValuesAtLevel.toArray(new String[0]);
                    try {
                        labels = this.stringSubstitute(labels, this.tt.webLinks);
                        values = this.stringSubstitute(values, this.tt.webLinks);
                    }
                    catch (Exception pair) {
                        // empty catch block
                    }
                    if (labels.length == 0) {
                        try {
                            String[] label = this.stringSubstitute(preLabels, this.tt.webLinks);
                            String[] links = this.stringSubstitute(preLinks, this.tt.webLinks);
                            URLMenuItem webLinkItem = new URLMenuItem(label[drillLevel], links[drillLevel]);
                            webLinkItem.addActionListener(this.myActionHandler);
                            webLinkItem.setActionCommand(WEB_LINK_ACTION_COMMAND);
                            popup.add(webLinkItem);
                        }
                        catch (Exception label) {}
                    } else {
                        for (int k = 0; k < labels.length; ++k) {
                            if (labels[k] == null || values[k] == null) continue;
                            URLMenuItem webLinkItem = new URLMenuItem(labels[k], values[k]);
                            webLinkItem.addActionListener(this.myActionHandler);
                            webLinkItem.setActionCommand(WEB_LINK_ACTION_COMMAND);
                            popup.add(webLinkItem);
                        }
                    }
                } else {
                    String[] labels = this.stringSubstitute(preLabels, this.tt.webLinks);
                    String[] links = this.stringSubstitute(preLinks, this.tt.webLinks);
                    int numEntries = Math.min(labels.length, links.length);
                    for (int jj = 0; jj < numEntries; ++jj) {
                        URLMenuItem webLinkItem = new URLMenuItem(labels[jj], links[jj]);
                        webLinkItem.addActionListener(this.myActionHandler);
                        webLinkItem.setActionCommand(WEB_LINK_ACTION_COMMAND);
                        popup.add(webLinkItem);
                    }
                }
            }
            if (popup.getSubElements().length > 0) {
                return popup;
            }
        }
        return null;
    }

    public boolean zoom(int x, int y) {
        DataTreeGroupNode gn;
        if (this.isAnimating) {
            return false;
        }
        Point2D.Double p = new Point2D.Double(x, this.getBounds().height - y);
        this.tt = this.getTileAtPosition(p);
        DataTreeGroupNode dataTreeGroupNode = gn = this.tt != null ? (DataTreeGroupNode)this.tt.treeNode : null;
        if (gn == null || !(gn.getValue() instanceof TupleElementInterface)) {
            if (this.tt != null && !this.cellModel.getTileChartModel().getBrushModel().isSelectionAllowed()) {
                Tile curTile = this.tt;
                ArrayList<Tile> levels = new ArrayList<Tile>();
                while (curTile.idValue != rootTileName) {
                    levels.add(curTile);
                    curTile = (Tile)((DefaultMutableTreeNode)curTile.treeNode.getParent()).getUserObject();
                }
                if (this.zoomNames.size() + 1 < this.idVariableArray.length) {
                    return this.zoomTowardTile(this.tt);
                }
            } else {
                SelectableShape selectableShape = this.getStatusLineAtPosition(new Point2D.Double(x, y));
                if (selectableShape != null) {
                    TileChartRendererSelectResult selectResult = (TileChartRendererSelectResult)selectableShape.getSelectResult();
                    TileSelectDetail tileDetail = (TileSelectDetail)selectResult.getDetail();
                    for (int i = 0; i < this.idVariableArray.length; ++i) {
                        if (!tileDetail.getVariableName().equals(this.idVariableArray[i].getName())) continue;
                        this.curLevel = i + 1;
                        break;
                    }
                    DefaultMutableTreeNode node = this.tileChartRendererModel.getCurrentRootTile().treeNode;
                    int level = node.getLevel() - this.curLevel;
                    for (int i = 0; i < level; ++i) {
                        node = (DefaultMutableTreeNode)node.getParent();
                    }
                    this.curTile = (Tile)node.getUserObject();
                    this.curAction = 3;
                    this.repaint();
                    return true;
                }
            }
        }
        return false;
    }

    private String[] stringSubstitute(String[] strs, String[] subs) {
        for (int ii = 0; ii < strs.length; ++ii) {
            boolean badString = false;
            while (strs[ii].indexOf("{&") != -1 && !badString) {
                int subNumber;
                int startSub = strs[ii].indexOf("{&");
                int endSub = strs[ii].indexOf("}", startSub);
                if (endSub == -1) {
                    badString = true;
                    continue;
                }
                try {
                    subNumber = Integer.parseInt(strs[ii].substring(startSub + 2, endSub));
                }
                catch (NumberFormatException e) {
                    badString = true;
                    continue;
                }
                if (subs.length >= subNumber) {
                    String newStr;
                    strs[ii] = newStr = strs[ii].substring(0, startSub) + subs[subNumber - 1] + strs[ii].substring(endSub + 1, strs[ii].length());
                    continue;
                }
                badString = true;
            }
        }
        return strs;
    }

    private boolean zoomTowardTile(Tile tt) {
        int numVisibleLevels = 0;
        numVisibleLevels = this.tileChartRenderer.isOLAPData(this.tileChartRendererModel.getTileVariable()) ? this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1 : Math.min(this.tileChartRendererModel.getDetailLevel(), this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1);
        boolean zoomToNewDetail = this.cellModel.getTileChartModel().isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_TILECHART_ZOOM_TO_DETAIL);
        DefaultMutableTreeNode node = tt.treeNode;
        if (numVisibleLevels == 1) {
            numVisibleLevels = 1;
        } else {
            if (node.getParent() == this.tileChartRendererModel.getCurrentRootTile().treeNode) {
                return false;
            }
            while ((node = (DefaultMutableTreeNode)node.getParent()).getParent() != this.tileChartRendererModel.getCurrentRootTile().treeNode) {
            }
        }
        if (node.getChildCount() == 0) {
            return false;
        }
        this.curTile = (Tile)node.getUserObject();
        while (zoomToNewDetail && this.curTile.treeNode.getChildCount() == 1 && !this.tileChartRenderer.isLeafTile((DefaultMutableTreeNode)this.curTile.treeNode.getChildAt(0))) {
            this.curTile = (Tile)((DefaultMutableTreeNode)this.curTile.treeNode.getChildAt(0)).getUserObject();
        }
        this.curAction = 2;
        this.repaint();
        return true;
    }

    private SelectableShape getStatusLineAtPosition(Point2D pos) {
        Vector selectableShapes = this.tileChartRenderer.computeSelectableShapes();
        for (int i = 0; i < selectableShapes.size(); ++i) {
            SelectableShape selectShape = (SelectableShape)selectableShapes.get(i);
            TileChartRendererSelectResult selectResult = (TileChartRendererSelectResult)selectShape.getSelectResult();
            int type = ((TileSelectDetail)selectResult.getDetail()).getType();
            if (type != 1 || !selectShape.getShape().contains(pos)) continue;
            return selectShape;
        }
        return null;
    }

    public String[] getTileValues() {
        DataTreeGroupNode root = (DataTreeGroupNode)this.tileChartRendererModel.getDataTree();
        if (root != null) {
            Enumeration depthEnum = root.depthFirstEnumeration();
            HashSet<String> vals = new HashSet<String>();
            while (depthEnum.hasMoreElements()) {
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)depthEnum.nextElement();
                if (!curNode.isLeaf()) continue;
                curNode = (DataTreeGroupNode)curNode.getParent();
                vals.add(((Tile)curNode.getUserObject()).idValue);
            }
            Object[] sa = vals.toArray(new String[0]);
            Arrays.sort(sa);
            return sa;
        }
        return new String[0];
    }

    public String[] getRootTilePath() {
        return this.tileChartRenderer.getRootPath();
    }

    private void setRootPath() {
        this.tileChartRenderer.setRootTilePath();
        this.zoomNames.clear();
        DataTreeGroupNode root = (DataTreeGroupNode)this.tileChartRendererModel.getDataTree();
        for (DefaultMutableTreeNode curNode = this.tileChartRendererModel.getCurrentRootTile().treeNode; curNode != root; curNode = (DefaultMutableTreeNode)curNode.getParent()) {
            this.zoomNames.add(((Tile)curNode.getUserObject()).idValue);
        }
    }

    public void setRootTilePath(String[] path) {
        this.tileChartRendererModel.setRootPath(path);
        this.repaint((int)this.tileChartRendererModel.getCurrentRootTile().rect.x, (int)this.tileChartRendererModel.getCurrentRootTile().rect.y, (int)this.tileChartRendererModel.getCurrentRootTile().rect.width, (int)this.tileChartRendererModel.getCurrentRootTile().rect.height);
    }

    private void setUpLevelName2RectHash() {
        Rectangle2D.Double maybeRoot;
        if (this.levelName2RectHash == null) {
            this.levelName2RectHash = new Hashtable(this.tileChartRendererModel.getRootTile().treeNode.getDepth());
        }
        if ((maybeRoot = (Rectangle2D.Double)this.levelName2RectHash.get(rootTileName)) == null || maybeRoot.width != this.tileChartRendererModel.getRootTile().rect.width || maybeRoot.height != this.tileChartRendererModel.getRootTile().rect.height) {
            this.levelName2RectHash.put(rootTileName, this.tileChartRendererModel.getRootTile().rect.clone());
        }
    }

    private void updateDatatipLabels(boolean forceUpdate) {
        int numVisibleLevels = 0;
        numVisibleLevels = this.tileChartRenderer.isOLAPData(this.tileChartRendererModel.getTileVariable()) ? this.dataSource.getVariable("tileVariable").length : Math.min(this.tileChartRendererModel.getDetailLevel(), this.tileChartRendererModel.getCurrentRootTile().treeNode.getDepth() - 1);
        int rootLevel = this.tileChartRendererModel.getCurrentRootTile().treeNode.getLevel() - 1;
        Variable[] idVariableArray = this.tileChartRendererModel.getTileVariable();
        if (forceUpdate || this.idLabel == null || numVisibleLevels != this.idLabel.length - 2 && numVisibleLevels <= idVariableArray.length) {
            this.idLabel = new String[numVisibleLevels + 2];
            for (int zz = rootLevel; zz < rootLevel + numVisibleLevels; ++zz) {
                this.idLabel[zz - rootLevel] = idVariableArray[zz].getLabel().trim();
            }
            this.idLabel[numVisibleLevels] = this.tileChartRendererModel.getSizeVariable().getLabel().trim();
            this.idLabel[numVisibleLevels + 1] = this.tileChartRendererModel.getColorVariable().getLabel().trim();
        }
    }

    void recalculateDataValues(DefaultMutableTreeNode curNode) {
        if (this.cellModel.getTileChartModel().isColorByVisibleTiles() || this.curAction == 3) {
            this.calculateLocalDataRange((Tile)curNode.getUserObject());
            LegendModel lm = this.cellModel.getTileChartModel().getLegendModel();
            if (lm.isSymmetricEnabled()) {
                double base = lm.getBaseline();
                if (this.highColorDataValue - base > base - this.lowColorDataValue) {
                    this.lowColorDataValue = base - (this.highColorDataValue - base);
                } else {
                    this.highColorDataValue = base + (base - this.lowColorDataValue);
                }
            }
            if (this.cellModel.getTileChartModel().isColorByVisibleTiles()) {
                this.lowColorDataValue = Double.isInfinite(this.lowColorDataValue) ? 0.0 : this.lowColorDataValue;
                this.highColorDataValue = Double.isInfinite(this.highColorDataValue) ? 0.0 : this.highColorDataValue;
                this.lowColorLegendValue = this.lowColorDataValue;
                this.highColorLegendValue = this.highColorDataValue;
                lm.setMinimum(this.lowColorDataValue);
                lm.setMaximum(this.highColorDataValue);
            }
        }
    }
}

