/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.tilechart;

import com.sas.graphics.components.ShadowStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class JSizeLegend
extends JComponent {
    String label;
    String displayLabel;
    int labelPlacement = 5;
    TextStyle labelStyle = new TextStyle();
    int placement = 5;
    int margin = 5;
    final int idealSquareSize = 35;
    final int arrowSpace = 5;
    final int arrowSize = 3;

    public JSizeLegend(String label, int placement) {
        this.label = label;
        this.displayLabel = this.truncateLabel(label);
        this.placement = placement;
    }

    public JSizeLegend() {
        this("", 5);
    }

    public JSizeLegend(String label) {
        this(label, 5);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle2D labelBB;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle b = this.getBounds();
        int squareULX = (int)b.getCenterX();
        int squareULY = this.margin;
        double w = b.getWidth();
        double h = b.getHeight();
        g2.setFont(this.labelStyle.getFont());
        if (this.labelStyle.isVisible()) {
            labelBB = g2.getFont().getStringBounds(this.displayLabel, g2.getFontRenderContext());
        } else {
            labelBB = new Rectangle2D.Double();
            this.margin = 0;
        }
        int squareSize = 0;
        if (this.placement == 5 || this.placement == 1) {
            squareSize = Math.min((int)(w - (double)(this.margin * 2) - 6.0 - 5.0), (int)(h - labelBB.getHeight() - (double)(this.margin * 2) - 6.0 - 5.0));
            squareSize = Math.min(squareSize, 35);
        } else {
            squareSize = Math.min((int)(w - labelBB.getHeight() - (double)(this.margin * 2) - 6.0 - 5.0), (int)(h - (double)(this.margin * 2) - 6.0 - 5.0));
            squareSize = Math.min(squareSize, 35);
        }
        switch (this.placement) {
            case 5: {
                squareULX -= squareSize / 2;
                if (this.labelPlacement != 1) break;
                squareULY = b.height / 2 - squareSize / 2 + this.margin;
                break;
            }
            case 3: {
                squareULX = this.labelPlacement == 1 ? b.x : 8;
                squareULY = (int)(b.getHeight() / 2.0 - (double)(squareSize / 2));
                break;
            }
            case 1: {
                squareULX -= squareSize / 2;
                squareULY = b.y + b.height / 2 - squareSize / 2 + this.margin;
                break;
            }
            case 7: {
                squareULX = this.labelPlacement == 1 ? b.x + b.width / 2 - squareSize / 2 : (int)b.getX() + (int)b.getWidth() - squareSize - this.margin - 1;
                squareULY = (int)(b.getHeight() / 2.0 - (double)(squareSize / 2));
                break;
            }
        }
        g2.setColor(new Color(208, 217, 237));
        g2.fillRect(squareULX, squareULY, squareSize, squareSize);
        g2.setColor(Color.black);
        g2.drawRect(squareULX, squareULY, squareSize, squareSize);
        Point p1 = new Point(squareULX - 5, squareULY);
        Point p2 = new Point(squareULX - 5, squareULY + squareSize);
        g2.setColor(new Color(0.0f, 0.0f, 0.0f));
        g2.drawLine(p1.x, p1.y, p2.x, p2.y);
        int[] xp = new int[3];
        int[] yp = new int[3];
        xp[0] = p1.x - 3;
        yp[0] = p1.y + 3;
        xp[1] = p1.x;
        yp[1] = p1.y;
        xp[2] = p1.x + 3;
        yp[2] = p1.y + 3;
        g2.drawPolygon(xp, yp, 3);
        g2.fillPolygon(xp, yp, 3);
        xp[0] = p2.x - 3;
        yp[0] = p2.y - 3;
        xp[1] = p2.x;
        yp[1] = p2.y;
        xp[2] = p2.x + 3;
        yp[2] = p2.y - 3;
        g2.drawPolygon(xp, yp, 3);
        g2.fillPolygon(xp, yp, 3);
        p1.x = squareULX;
        p1.y = squareULY + squareSize + 5;
        p2.x = squareULX + squareSize;
        p2.y = p1.y;
        g2.drawLine(p1.x, p1.y, p2.x, p2.y);
        xp[0] = p1.x + 3;
        yp[0] = p1.y + 3;
        xp[1] = p1.x;
        yp[1] = p1.y;
        xp[2] = p1.x + 3;
        yp[2] = p1.y - 3;
        g2.drawPolygon(xp, yp, 3);
        g2.fillPolygon(xp, yp, 3);
        xp[0] = p2.x - 3;
        yp[0] = p2.y + 3;
        xp[1] = p2.x;
        yp[1] = p2.y;
        xp[2] = p2.x - 3;
        yp[2] = p2.y - 3;
        g2.drawPolygon(xp, yp, 3);
        g2.fillPolygon(xp, yp, 3);
        this.drawLabel(g, b, squareULX, squareSize, labelBB);
    }

    private void drawLabel(Graphics g, Rectangle b, int squareULX, int squareSize, Rectangle2D labelBB) {
        if (!this.labelStyle.isVisible()) {
            return;
        }
        ShadowStyle shadow = this.labelStyle.getShadowStyle();
        Channel ch = new Channel((Component)this, 2);
        ch.glEnable(14);
        JSizeLegend.updateChannel(ch, this.getBounds().width, this.getBounds().height);
        ch.setSingleBufferGraphics(g);
        switch (this.placement) {
            case 5: {
                if (this.labelPlacement == 1) {
                    RasterLabel.drawRasterLabel((Channel)ch, (String)this.displayLabel, (Color)this.labelStyle.getColor(), (double)0.0, (int)0, (int)0, (boolean)false, (boolean)false, (double)b.width, (double)b.height, (Font)this.labelStyle.getFont(), null, (boolean)shadow.isVisible(), (Color)shadow.getColor(), (int)((int)shadow.getOffsetX().getMagnitude((Object)"px")), (int)((int)shadow.getOffsetY().getMagnitude((Object)"px")), (double)((double)(squareULX + squareSize / 2) - labelBB.getWidth() / 2.0), (double)(this.margin - 1), (double)0.0);
                    break;
                }
                RasterLabel.drawRasterLabel((Channel)ch, (String)this.displayLabel, (Color)this.labelStyle.getColor(), (double)0.0, (int)0, (int)3, (boolean)false, (boolean)false, (double)b.width, (double)b.height, (Font)this.labelStyle.getFont(), null, (boolean)shadow.isVisible(), (Color)shadow.getColor(), (int)((int)shadow.getOffsetX().getMagnitude((Object)"px")), (int)((int)shadow.getOffsetY().getMagnitude((Object)"px")), (double)((double)(squareULX + squareSize / 2) - labelBB.getWidth() / 2.0), (double)(b.height - this.margin / 2 + 1), (double)0.0);
                break;
            }
            case 3: {
                if (this.labelPlacement == 1) {
                    RasterLabel.drawRasterLabel((Channel)ch, (String)this.displayLabel, (Color)this.labelStyle.getColor(), (double)0.0, (int)0, (int)0, (boolean)false, (boolean)false, (double)b.width, (double)b.height, (Font)this.labelStyle.getFont(), null, (boolean)shadow.isVisible(), (Color)shadow.getColor(), (int)((int)shadow.getOffsetX().getMagnitude((Object)"px")), (int)((int)shadow.getOffsetY().getMagnitude((Object)"px")), (double)((int)((double)(squareULX + squareSize / 2) - labelBB.getWidth() / 2.0)), (double)this.margin, (double)0.0);
                    break;
                }
                RasterLabel.drawRasterLabel((Channel)ch, (String)this.displayLabel, (Color)this.labelStyle.getColor(), (double)-90.0, (int)2, (int)1, (boolean)false, (boolean)false, (double)b.width, (double)b.height, (Font)this.labelStyle.getFont(), null, (boolean)shadow.isVisible(), (Color)shadow.getColor(), (int)((int)shadow.getOffsetX().getMagnitude((Object)"px")), (int)((int)shadow.getOffsetY().getMagnitude((Object)"px")), (double)(b.getWidth() - (double)this.margin + 2.0), (double)(b.getHeight() / 2.0), (double)0.0);
                break;
            }
            case 1: {
                RasterLabel.drawRasterLabel((Channel)ch, (String)this.displayLabel, (Color)this.labelStyle.getColor(), (double)0.0, (int)0, (int)0, (boolean)false, (boolean)false, (double)b.width, (double)b.height, (Font)this.labelStyle.getFont(), null, (boolean)shadow.isVisible(), (Color)shadow.getColor(), (int)((int)shadow.getOffsetX().getMagnitude((Object)"px")), (int)((int)shadow.getOffsetY().getMagnitude((Object)"px")), (double)((double)(squareULX + squareSize / 2) - labelBB.getWidth() / 2.0), (double)(this.margin - 1), (double)0.0);
                break;
            }
            case 7: {
                if (this.labelPlacement == 1) {
                    RasterLabel.drawRasterLabel((Channel)ch, (String)this.displayLabel, (Color)this.labelStyle.getColor(), (double)0.0, (int)0, (int)0, (boolean)false, (boolean)false, (double)b.width, (double)b.height, (Font)this.labelStyle.getFont(), null, (boolean)shadow.isVisible(), (Color)shadow.getColor(), (int)((int)shadow.getOffsetX().getMagnitude((Object)"px")), (int)((int)shadow.getOffsetY().getMagnitude((Object)"px")), (double)((int)(b.getWidth() / 2.0 - labelBB.getWidth() / 2.0)), (double)this.margin, (double)0.0);
                    break;
                }
                RasterLabel.drawRasterLabel((Channel)ch, (String)this.displayLabel, (Color)this.labelStyle.getColor(), (double)90.0, (int)0, (int)1, (boolean)false, (boolean)false, (double)b.width, (double)b.height, (Font)this.labelStyle.getFont(), null, (boolean)shadow.isVisible(), (Color)shadow.getColor(), (int)((int)shadow.getOffsetX().getMagnitude((Object)"px")), (int)((int)shadow.getOffsetY().getMagnitude((Object)"px")), (double)-1.0, (double)(b.getHeight() / 2.0), (double)0.0);
                break;
            }
        }
    }

    private String truncateLabel(String l) {
        int LABEL_MAX_LENGTH = 20;
        String tl = l;
        if (l.length() > 20) {
            tl = l.substring(0, 17) + "...";
        }
        return tl;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension drc = super.getPreferredSize();
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        if (g2 == null) {
            BufferedImage bi = new BufferedImage(10, 10, 1);
            g2 = (Graphics2D)bi.getGraphics();
        }
        Rectangle2D labelBB = this.labelStyle.getFont().getStringBounds(this.displayLabel, g2.getFontRenderContext());
        drc.width = 35 + this.margin * 2 + 10 + 3;
        drc.height = 35 + this.margin * 2 + 10 + 3;
        if (this.labelPlacement == 1) {
            drc.width = Math.max(drc.width, (int)labelBB.getWidth());
            drc.height += (int)labelBB.getHeight();
        } else if (this.placement == 5 || this.placement == 1) {
            drc.width = Math.max(drc.width, (int)labelBB.getWidth());
            drc.height += (int)labelBB.getHeight();
        } else {
            drc.width += (int)labelBB.getHeight();
            drc.height = Math.max(drc.height, (int)labelBB.getWidth());
        }
        Insets in = this.getInsets();
        drc.width += in.left + in.right;
        drc.height += in.top + in.bottom;
        return drc;
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setPlacement(int placement) {
        this.placement = placement;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.displayLabel = this.truncateLabel(label);
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle labelStyle) {
        this.labelStyle = labelStyle;
    }

    public int getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(int placement) {
        this.labelPlacement = placement;
    }

    private static void updateChannel(Channel channel, int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        channel.glDisable(27);
        channel.glViewport(0, 0, width, height);
        channel.glOrtho(0.0, (double)width, (double)height, 0.0, -1.0, 1.0);
        channel.gluLookAt(0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0);
        channel.glDisable(4);
        channel.glDisable(3);
    }
}

