/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.tilechart;

import java.awt.Color;

class GradientColorMapper {
    private transient double[] valueList;
    private transient Color[] colorList;

    public GradientColorMapper(double[] values, Color[] colors) {
        if (values == null) {
            int num = colors.length;
            double[] nv = new double[num];
            for (int ii = 0; ii < num; ++ii) {
                nv[ii] = num > 1 ? (double)ii / ((double)num - 1.0) : 0.0;
            }
        }
        if (values.length != colors.length) {
            // empty if block
        }
        this.valueList = values;
        this.colorList = colors;
    }

    public GradientColorMapper(double value1, double value2, Color color1, Color color2) {
        this.valueList[0] = value1;
        this.valueList[1] = value2;
        this.colorList[0] = color1;
        this.colorList[1] = color2;
    }

    protected synchronized Color getColor(double atValue) {
        if (atValue <= this.valueList[0]) {
            return this.colorList[0];
        }
        if (atValue >= this.valueList[this.valueList.length - 1]) {
            return this.colorList[this.colorList.length - 1];
        }
        int position = 0;
        while (atValue >= this.valueList[position + 1]) {
            ++position;
        }
        double v1 = this.valueList[position];
        Color c1 = this.colorList[position];
        double c1r = c1.getRed();
        double c1g = c1.getGreen();
        double c1b = c1.getBlue();
        double v2 = this.valueList[position + 1];
        Color c2 = this.colorList[position + 1];
        double c2r = c2.getRed();
        double c2g = c2.getGreen();
        double c2b = c2.getBlue();
        double red = (atValue - v1) / (v2 - v1) * (c2r - c1r) + c1r;
        double green = (atValue - v1) / (v2 - v1) * (c2g - c1g) + c1g;
        double blue = (atValue - v1) / (v2 - v1) * (c2b - c1b) + c1b;
        return new Color((float)(red / 256.0), (float)(green / 256.0), (float)(blue / 256.0));
    }
}

