/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.sparkline;

import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.sparkline.SparklineModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.sparkline.SparklineCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class SparklineCell
extends Cell
implements ChartImageMapInfo.ChartImageMapInfoAuthorInterface {
    private static final long serialVersionUID = 1L;
    private final transient DataSource dataSource;

    public SparklineCell(SparklineCellModel cellModel, DataSource dataSource, Object columnOrdinal, Object rowOrdinal, Channel channel) {
        super(cellModel, channel);
        this.dataSource = dataSource;
        SparklineModel graphModel = cellModel.getGraphModel();
        this.setAntiAliasingEnabled(graphModel.isAntialiasedGraphics());
        this.setTextAntiAliasingEnabled(graphModel.isAntialiasedText());
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    protected synchronized void construct() {
    }

    @Override
    public void paintComponent(Graphics gc) {
        Graphics2D g = (Graphics2D)gc;
        if (g != null) {
            super.paintComponent(g);
            Rectangle componentBounds = this.getBounds();
            Insets insets = this.getInsets();
            if (componentBounds != null) {
                if (insets != null) {
                    componentBounds.x = insets.left;
                    componentBounds.y = insets.top;
                    componentBounds.width = componentBounds.width - insets.left - insets.right - 1;
                    componentBounds.height = componentBounds.height - insets.top - insets.bottom - 1;
                } else {
                    componentBounds.x = 0;
                    componentBounds.y = 0;
                    --componentBounds.width;
                    --componentBounds.height;
                }
            }
            this.renderSparkline(g);
        }
    }

    private void renderSparkline(Graphics g) {
        SparklineCellModel cellModel = (SparklineCellModel)this.getModel();
        Object responseRole = cellModel.getResponseRole();
        NumericVariable responseVariable = (NumericVariable)this.dataSource.getVariable(responseRole, 0);
        if (responseVariable == null) {
            return;
        }
        responseVariable.init();
        if (responseVariable.getValueCount() < 1) {
            return;
        }
        try {
            responseVariable.value.getValue(0);
        }
        catch (MissingValueException e) {
            return;
        }
        Graphics2D gc = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHints(hints);
        Insets insets = this.getInsets();
        Rectangle drawSpace = this.getBounds();
        drawSpace.x = insets.left;
        drawSpace.y = insets.top;
        drawSpace.width = drawSpace.width - insets.left - insets.right - 1;
        drawSpace.height = drawSpace.height - insets.top - insets.bottom - 1;
        int numValues = responseVariable.getValueCount();
        double lowValue = responseVariable.getMin();
        double highValue = responseVariable.getMax();
        double delta = highValue - lowValue;
        double currentX = drawSpace.x;
        double currentVal = 0.0;
        try {
            currentVal = responseVariable.value.getValue(0);
        }
        catch (MissingValueException e) {
            e.printStackTrace();
        }
        double relativeVerticalPosition = (currentVal - lowValue) / delta;
        double segmentWidth = (drawSpace.getMaxX() - drawSpace.getMinX()) / (double)(numValues - 1);
        int lastXValue = (int)currentX;
        int lastYValue = (int)(drawSpace.getMaxY() - (drawSpace.getMaxY() - drawSpace.getMinY()) * relativeVerticalPosition);
        gc.setColor(Color.black);
        for (int i = 1; i < numValues; ++i) {
            currentX += segmentWidth;
            try {
                currentVal = responseVariable.value.getValue(i);
            }
            catch (MissingValueException e) {
                e.printStackTrace();
            }
            relativeVerticalPosition = (currentVal - lowValue) / delta;
            int xValue = (int)currentX;
            int yValue = (int)(drawSpace.getMaxY() - (drawSpace.getMaxY() - drawSpace.getMinY()) * relativeVerticalPosition);
            gc.drawLine(lastXValue, lastYValue, xValue, yValue);
            lastXValue = xValue;
            lastYValue = yValue;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }

    @Override
    public ChartImageMapInfo getChartImageMapInfo() {
        return null;
    }
}

