/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.scatterplot;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.ContentsModel;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.MessageModel;
import com.sas.graphics.components.PlotValueZone;
import com.sas.graphics.components.util.scatterplot.ScatterPlotModel;
import com.sas.graphics.util.ZoomScrollBar;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.AxisCell;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.GridDimension;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.LabelPane;
import com.sas.graphics.util.cell.MatrixContainer2;
import com.sas.graphics.util.cell.PlotImageMapInfo2;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValuePane;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.cell.scatterplot.ScatterComposite;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotCell;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.tree.TreeNode;

public class ScatterPlotMatrixContainer
extends MatrixContainer2 {
    private static final int PLACEMENT_SPECIAL = -11302;
    private static final int MIN_AXIS_LENGTH = (int)((double)Util.MIN_FONT_HEIGHT * 2.5);
    private final transient ValueTree columnTree;
    private final transient ValueTree rowTree;
    private final transient boolean isRowEast;
    private final transient CellPane matrixCellPane;
    private final transient CellPane xAxisCellPane;
    private transient LabelPane xAxisLabelPane;
    private final transient CellPane yAxisCellPane;
    private transient LabelPane yAxisLabelPane;
    private final transient CellPane y2AxisCellPane;
    private transient LabelPane y2AxisLabelPane;
    private final transient ValuePane columnMatrixAxisValuePane;
    private final transient LabelPane columnMatrixAxisLabelPane;
    private final transient ValuePane rowMatrixAxisValuePane;
    private final transient LabelPane rowMatrixAxisLabelPane;
    private final transient JComponent messagesComponent;
    private final transient int xAxisLabelPlacementPolicy;
    private final transient int yAxisLabelPlacementPolicy;
    private final transient int y2AxisLabelPlacementPolicy;
    private final transient AxisModel yAxisModel;
    private final transient AxisModel y2AxisModel;
    private final transient AxisModel xAxisModel;
    private transient LayoutCache layoutCache;
    private final transient ZoomScrollBar columnScrollBar;
    private final transient ZoomScrollBar rowScrollBar;
    private final transient MatrixContainer2.ScrollModelProjection columnScrollModelProjection;
    private final transient MatrixContainer2.ScrollModelProjection rowScrollModelProjection;
    private transient Rectangle mb = null;
    private static int NORTH = 0;
    private static int MATRIX = 1;
    private static int SOUTH = 2;
    private static int WEST = 0;
    private static int EAST = 2;

    public ScatterPlotMatrixContainer(ScatterPlotMatrixModel scatterPlotMatrixModel, DataSource dataSource, ValueTree columnTree, ValueTree rowTree, CellPane.CellComponentFactory scatterPlotCellFactory, CellPane.CellComponentFactory xAxisCellFactory, CellPane.CellComponentFactory yAxisCellFactory, CellPane.CellComponentFactory y2AxisCellFactory, MessageModel messageModel, SwingActionProvider actionProvider, boolean isRowEast, boolean isAntiAliasingEnabled, boolean isTextAntiAliasingEnabled, Channel channel) {
        super(isAntiAliasingEnabled, isTextAntiAliasingEnabled, channel);
        this.setLayout(null);
        this.setOpaque(false);
        ScatterPlotModel graphModel = null;
        this.columnTree = columnTree;
        this.rowTree = rowTree;
        graphModel = scatterPlotMatrixModel.getScatterPlotModel();
        if (scatterPlotMatrixModel == null || dataSource == null || columnTree == null || rowTree == null || scatterPlotCellFactory == null) {
            throw new IllegalStateException("required parameter is null");
        }
        this.xAxisLabelPlacementPolicy = scatterPlotMatrixModel.getScatterPlotModel().getXAxisModel() != null ? graphModel.getXAxisModel().getLabelPlacementPolicy() : 10200;
        this.yAxisLabelPlacementPolicy = scatterPlotMatrixModel.getScatterPlotModel().getYAxisModel() != null ? graphModel.getYAxisModel().getLabelPlacementPolicy() : 10200;
        this.y2AxisLabelPlacementPolicy = scatterPlotMatrixModel.getScatterPlotModel().getY2AxisModel() != null ? graphModel.getY2AxisModel().getLabelPlacementPolicy() : 10200;
        this.yAxisModel = graphModel.getYAxisModel();
        this.y2AxisModel = graphModel.getY2AxisModel();
        this.xAxisModel = graphModel.getXAxisModel();
        this.matrixCellPane = new CellPane(columnTree, rowTree, scatterPlotCellFactory, channel);
        ContentsModel axisModel = scatterPlotMatrixModel.getColumnModel();
        HierarchicalPane[] cmap = Util.newMatrixAxisPanes(columnTree, axisModel, dataSource.getDataSourceSelectionModel(), actionProvider, channel);
        this.columnMatrixAxisLabelPane = (LabelPane)cmap[0];
        this.columnMatrixAxisValuePane = (ValuePane)cmap[1];
        axisModel = scatterPlotMatrixModel.getRowModel();
        HierarchicalPane[] rmap = Util.newMatrixAxisPanes(rowTree, axisModel, dataSource.getDataSourceSelectionModel(), actionProvider, channel);
        this.rowMatrixAxisLabelPane = (LabelPane)rmap[0];
        this.rowMatrixAxisValuePane = (ValuePane)rmap[1];
        axisModel = scatterPlotMatrixModel.getScatterPlotModel().getXAxisModel();
        Variable[] labelVariables = ScatterPlotMatrixContainer.newLabelVariables((AxisModel)axisModel, dataSource, scatterPlotMatrixModel.getXRole());
        HierarchicalPane[] xap = Util.newColumnWiseAxisPanes(columnTree, (AxisModel)axisModel, xAxisCellFactory, labelVariables, null, channel);
        this.xAxisLabelPane = (LabelPane)xap[0];
        this.xAxisCellPane = (CellPane)xap[1];
        labelVariables = ScatterPlotMatrixContainer.newLabelVariables(this.yAxisModel, dataSource, scatterPlotMatrixModel.getYRole());
        HierarchicalPane[] yap = Util.newRowWiseAxisPanes(rowTree, this.yAxisModel, yAxisCellFactory, labelVariables, null, channel);
        LabelPane yalp = (LabelPane)yap[0];
        this.yAxisCellPane = (CellPane)yap[1];
        Variable[] labelVariables2 = ScatterPlotMatrixContainer.newLabelVariables(this.y2AxisModel, dataSource, scatterPlotMatrixModel.getY2Role());
        HierarchicalPane[] y2ap = Util.newRowWiseAxisPanes(rowTree, this.y2AxisModel, y2AxisCellFactory, labelVariables2, null, channel);
        LabelPane y2alp = (LabelPane)y2ap[0];
        this.y2AxisCellPane = (CellPane)y2ap[1];
        LegendModel legendModel = scatterPlotMatrixModel.getScatterPlotModel().getColorLegendModel();
        if (legendModel.isVisible()) {
            if (yalp != null && y2alp == null) {
                if (this.yAxisModel.getLabelPlacementPolicy() == 10200 && yalp.getContentPanelComponentCount() > 1) {
                    yalp = this.yAxisModel.isAdjustValueMagnitudeEnabled() ? new LabelPane(rowTree, this.yAxisModel.getLabelTextStyle(), channel) : null;
                }
            } else if (yalp == null && y2alp != null && this.y2AxisModel.getLabelPlacementPolicy() == 10200 && y2alp.getContentPanelComponentCount() > 1) {
                y2alp = this.y2AxisModel.isAdjustValueMagnitudeEnabled() ? new LabelPane(rowTree, this.y2AxisModel.getLabelTextStyle(), channel) : null;
            }
        }
        this.yAxisLabelPane = yalp;
        this.y2AxisLabelPane = y2alp;
        if (this.rowMatrixAxisValuePane == null) {
            isRowEast = this.yAxisCellPane == null && this.y2AxisCellPane != null;
        }
        this.isRowEast = isRowEast;
        if (scatterPlotMatrixModel.getDisplayPolicy() == 10002) {
            ZoomScrollBar[] zsba = ScatterPlotMatrixContainer.newColumnRowZoomScrollBars();
            this.columnScrollModelProjection = super.putScrollModel(zsba[0].getModel());
            this.rowScrollModelProjection = super.putScrollModel(zsba[1].getModel());
            this.columnScrollBar = zsba[0];
            this.add((JScrollBar)this.columnScrollBar, "columnScrollBar");
            this.rowScrollBar = zsba[1];
            this.add((JScrollBar)this.rowScrollBar, "rowScrollBar");
        } else {
            this.columnScrollModelProjection = super.putScrollModel(new DefaultBoundedRangeModel(0, 100, 0, 100));
            this.rowScrollModelProjection = super.putScrollModel(new DefaultBoundedRangeModel(0, 100, 0, 100));
            this.rowScrollBar = null;
            this.columnScrollBar = null;
        }
        this.messagesComponent = Util.Message.createMessageComponent(messageModel, channel);
        this.add((Component)this.messagesComponent, (Object)"message");
        this.add(this.matrixCellPane, "MatrixCellPane");
        this.add(this.columnMatrixAxisValuePane, "ColumnMatrixAxisValuePane");
        this.add(this.columnMatrixAxisLabelPane, "ColumnMatrixAxisLabelPane");
        this.add(this.rowMatrixAxisValuePane, "RowMatrixAxisValuePane");
        this.add(this.rowMatrixAxisLabelPane, "RowMatrixAxisLabelPane");
        this.add(this.xAxisCellPane, "xAxisCellPane");
        this.add(this.xAxisLabelPane, "xAxisLabelPane");
        this.add(this.yAxisCellPane, "yAxisCellPane");
        this.add(this.yAxisLabelPane, "yAxisLabelPane");
        this.add(this.y2AxisCellPane, "y2AxisCellPane");
        this.add(this.y2AxisLabelPane, "y2AxisLabelPane");
    }

    @Override
    public void dispose() {
        this.removeAll();
    }

    @Override
    public void removeAll() {
        this.disposeOfCells();
        super.removeAll();
    }

    private void disposeOfCells() {
        if (this.matrixCellPane != null) {
            this.matrixCellPane.dispose();
        }
    }

    @Override
    public Component getBrushableComponent() {
        if (this.matrixCellPane != null) {
            return this.matrixCellPane;
        }
        return this;
    }

    @Override
    public Component[] getMatrixCellComponents() {
        if (this.matrixCellPane == null) {
            return new JComponent[0];
        }
        return this.matrixCellPane.getContentPanelComponents();
    }

    public Component[] getXAxisCellComponents() {
        if (this.xAxisCellPane == null) {
            return new JComponent[0];
        }
        return this.xAxisCellPane.getContentPanelComponents();
    }

    public Component[] getYAxisCellComponents() {
        if (this.yAxisCellPane == null) {
            return new JComponent[0];
        }
        return this.yAxisCellPane.getContentPanelComponents();
    }

    public Component[] getY2AxisCellComponents() {
        if (this.y2AxisCellPane == null) {
            return new JComponent[0];
        }
        return this.y2AxisCellPane.getContentPanelComponents();
    }

    public void addSpecialYAxisLabel(String specialLabel) {
        if (this.layoutCache != null) {
            throw new IllegalStateException("");
        }
        this.yAxisLabelPane = ScatterPlotMatrixContainer.addSpecialAxisLabel(this.yAxisLabelPane, this.yAxisModel, specialLabel, this.getChannel());
        this.add(this.yAxisLabelPane, "yAxisLabelPane");
    }

    public void addSpecialY2AxisLabel(String specialLabel) {
        if (this.layoutCache != null) {
            throw new IllegalStateException("");
        }
        this.y2AxisLabelPane = ScatterPlotMatrixContainer.addSpecialAxisLabel(this.y2AxisLabelPane, this.y2AxisModel, specialLabel, this.getChannel());
        this.add(this.y2AxisLabelPane, "y2AxisLabelPane");
    }

    public void addSpecialXAxisLabel(String specialLabel) {
        if (this.layoutCache != null) {
            throw new IllegalStateException("");
        }
        this.xAxisLabelPane = ScatterPlotMatrixContainer.addSpecialAxisLabel(this.xAxisLabelPane, this.xAxisModel, specialLabel, this.getChannel());
        this.add(this.xAxisLabelPane, "xAxisLabelPane");
    }

    private static LabelPane addSpecialAxisLabel(LabelPane axisLabelPane, AxisModel axisModel, String specialLabel, Channel channel) {
        if (specialLabel != null) {
            Variable[] labelVariables = axisLabelPane == null ? null : axisLabelPane.getVariables();
            LabelPane.LabelComponentFactory labelComponentFactory = ScatterPlotMatrixContainer.newSpecialLabelingLabelComponentFactory(axisModel, channel);
            labelVariables = ScatterPlotMatrixContainer.addSpecialLabeling(labelVariables, specialLabel);
            axisLabelPane = new LabelPane(labelVariables, labelComponentFactory, channel);
        }
        return axisLabelPane;
    }

    private LayoutCache _layoutCache() {
        if (this.layoutCache == null) {
            this.layoutCache = new LayoutCache();
        }
        return this.layoutCache;
    }

    @Override
    public Dimension getPreferredSize() {
        return this._layoutCache().getPreferredSize();
    }

    private static int _computeYWidth(Dimension yaps, Dimension yalps, int yAxisLabelPlacement) {
        int yWidth = 0;
        switch (yAxisLabelPlacement) {
            default: {
                yWidth = yaps.width;
                break;
            }
            case 11306: {
                yWidth = yalps.width + yaps.width;
                break;
            }
            case 11302: {
                yWidth = Math.max(yaps.width, yalps.width);
            }
        }
        return yWidth;
    }

    private static int[] _computeWidths(Dimension yaps, Dimension y2aps, Dimension xalps, Dimension yalps, Dimension y2alps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int xAxisLabelPlacement, int yAxisLabelPlacement, int y2AxisLabelPlacement, boolean isRowEast) {
        return ScatterPlotMatrixContainer._computeWidths(null, yaps, y2aps, null, xalps, yalps, y2alps, null, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, isRowEast);
    }

    private static int[] _computeWidths(Dimension xaps, Dimension yaps, Dimension y2aps, Dimension mps, Dimension xalps, Dimension yalps, Dimension y2alps, GridDimension cmaps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int xAxisLabelPlacement, int yAxisLabelPlacement, int y2AxisLabelPlacement, boolean isRowEast) {
        int xalpsWidthEast = 0;
        int xalpsWidthWest = 0;
        switch (xAxisLabelPlacement) {
            case 11301: 
            case 11302: 
            case 11303: {
                if (y2aps.width > 0) {
                    xalpsWidthWest = xalps.width;
                    break;
                }
                xalpsWidthEast = xalps.width;
                break;
            }
            case -11302: {
                if (isRowEast) {
                    xalpsWidthEast = xalps.width;
                    break;
                }
                xalpsWidthWest = xalps.width;
                break;
            }
        }
        int westWidth = ScatterPlotMatrixContainer._computeYWidth(yaps, yalps, yAxisLabelPlacement);
        int eastWidth = ScatterPlotMatrixContainer._computeYWidth(y2aps, y2alps, y2AxisLabelPlacement);
        int rmaps_prefWidth = 0;
        int i1 = rmaps.getGridSize().width;
        for (int i = 0; i < i1; ++i) {
            rmaps_prefWidth += Math.max(rmaps.getColWidth(i), rmalps.getColWidth(i));
        }
        if (isRowEast) {
            eastWidth = Math.max(eastWidth + rmaps_prefWidth, Math.max(cmalps.width, xalpsWidthEast));
            if (xalpsWidthWest > westWidth) {
                westWidth = xalpsWidthWest;
            }
        } else {
            westWidth = Math.max(westWidth + rmaps_prefWidth, Math.max(cmalps.width, xalpsWidthWest));
            if (xalpsWidthEast > eastWidth) {
                eastWidth = xalpsWidthEast;
            }
        }
        int matrixWidth = 0;
        if (mps != null) {
            int spacer;
            matrixWidth = Math.max(mps.width, Math.max(xaps.width, cmaps.width));
            if (xAxisLabelPlacement == 11306 && matrixWidth < xalps.width) {
                matrixWidth = xalps.width;
            }
            int yLabelMatrixWidth = 0;
            if (yAxisLabelPlacement == 11301) {
                yLabelMatrixWidth = yalps.width;
            } else if (yAxisLabelPlacement == 11303) {
                yLabelMatrixWidth = Math.max(0, yalps.width - yaps.width);
            }
            int y2LabelMatrixWidth = 0;
            if (y2AxisLabelPlacement == 11301) {
                y2LabelMatrixWidth = y2alps.width;
            } else if (y2AxisLabelPlacement == 11303) {
                y2LabelMatrixWidth = Math.max(0, y2alps.width - y2aps.width);
            }
            int n = spacer = yLabelMatrixWidth > 0 && y2LabelMatrixWidth > 0 ? Util.MIN_FONT_WIDTH * 2 : 0;
            if (yLabelMatrixWidth + y2LabelMatrixWidth + spacer > matrixWidth) {
                matrixWidth = yLabelMatrixWidth + y2LabelMatrixWidth + spacer;
            }
        }
        return new int[]{westWidth, matrixWidth, eastWidth};
    }

    private static int[] _computeHeights(Dimension xaps, Dimension xalps, Dimension yalps, Dimension y2alps, GridDimension cmaps, GridDimension cmalps, GridDimension rmalps, int xAxisLabelPlacement, int yAxisLabelPlacement, int y2AxisLabelPlacement) {
        return ScatterPlotMatrixContainer._computeHeights(xaps, null, null, null, xalps, yalps, y2alps, cmaps, cmalps, null, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement);
    }

    private static int[] _computeHeights(Dimension xaps, Dimension yaps, Dimension y2aps, Dimension mps, Dimension xalps, Dimension yalps, Dimension y2alps, GridDimension cmaps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int xAxisLabelPlacement, int yAxisLabelPlacement, int y2AxisLabelPlacement) {
        int yalph = yAxisLabelPlacement == 11306 ? 0 : yalps.height;
        int y2alph = y2AxisLabelPlacement == 11306 ? 0 : y2alps.height;
        int northHeight = Math.max(Math.max(yalph, y2alph), rmalps.height);
        int cmaps_prefHeight = 0;
        int i1 = cmaps.getGridSize().height;
        for (int i = 0; i < i1; ++i) {
            cmaps_prefHeight += Math.max(cmaps.getRowHeight(i), cmalps.getRowHeight(i));
        }
        int southHeight = cmaps_prefHeight;
        switch (xAxisLabelPlacement) {
            case 11301: 
            case 11303: {
                southHeight += xaps.height;
                break;
            }
            case -11302: 
            case 11302: {
                southHeight += Math.max(xaps.height, xalps.height);
                break;
            }
            case 11306: {
                southHeight += xaps.height + xalps.height;
            }
        }
        int matrixHeight = 0;
        if (mps != null) {
            matrixHeight = Math.max(Math.max(yaps.height, y2aps.height), Math.max(mps.height, rmaps.height));
            int yLabelMatrixHeight = 0;
            if (yAxisLabelPlacement == 11306) {
                yLabelMatrixHeight = yalps.height;
            }
            int y2LabelMatrixHeight = 0;
            if (y2AxisLabelPlacement == 11306) {
                y2LabelMatrixHeight = y2alps.height;
            }
            if (Math.max(yLabelMatrixHeight, y2LabelMatrixHeight) > matrixHeight) {
                matrixHeight = Math.max(yLabelMatrixHeight, y2LabelMatrixHeight);
            }
            switch (xAxisLabelPlacement) {
                case 11301: 
                case 11303: {
                    if (xalps.height - xaps.height <= matrixHeight) break;
                    matrixHeight = xalps.height - xaps.height;
                }
            }
        }
        return new int[]{northHeight, matrixHeight, southHeight};
    }

    private static int _computeCellWidth(Rectangle r, Dimension xalps, Dimension yalps, Dimension y2alps, Dimension yaps, Dimension y2aps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int xAxisLabelPlacement, int yAxisLabelPlacement, int y2AxisLabelPlacement, int columnLevelCount, int columnLeafCount, boolean isRowEast) {
        int[] widths = ScatterPlotMatrixContainer._computeWidths(yaps, y2aps, xalps, yalps, y2alps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, isRowEast);
        int eastWidth = widths[EAST];
        int westWidth = widths[WEST];
        return (r.width - (westWidth + eastWidth)) / columnLeafCount;
    }

    private static int _computeCellHeight(Rectangle r, Dimension xaps, Dimension xalps, Dimension yalps, Dimension y2alps, GridDimension cmaps, GridDimension cmalps, GridDimension rmalps, int rowLeafCount, int xAxisLabelPlacement, int yAxisLabelPlacement, int y2AxisLabelPlacement) {
        int[] heights = ScatterPlotMatrixContainer._computeHeights(xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement);
        int northHeight = heights[NORTH];
        int southHeight = heights[SOUTH];
        return (r.height - (northHeight + southHeight)) / rowLeafCount;
    }

    private static boolean _restrictColumnAndXAxisLabelWidths(Dimension yaps, Dimension y2aps, Dimension xalps, Dimension yalps, Dimension y2alps, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int xAxisLabelPlacement, int yAxisLabelPlacement, int y2AxisLabelPlacement, boolean isRowEast) {
        int yWidth = ScatterPlotMatrixContainer._computeYWidth(yaps, yalps, yAxisLabelPlacement);
        int y2Width = ScatterPlotMatrixContainer._computeYWidth(y2aps, y2alps, y2AxisLabelPlacement);
        int salpsWidth = Math.max(xAxisLabelPlacement == -11302 ? xalps.width : 0, cmalps.width);
        int rmaps_prefWidth = 0;
        int i1 = rmaps.getGridSize().width;
        for (int i = 0; i < i1; ++i) {
            rmaps_prefWidth += Math.max(rmaps.getColWidth(i), rmalps.getColWidth(i));
        }
        int maxSLWidth = rmaps_prefWidth + (isRowEast ? y2Width : yWidth);
        if (salpsWidth > maxSLWidth) {
            cmalps.width = Math.min(cmalps.width, maxSLWidth);
            if (xAxisLabelPlacement == -11302) {
                xalps.width = Math.min(xalps.width, maxSLWidth);
            }
            return true;
        }
        return false;
    }

    @Override
    public void layout() {
        this._layout(this._layoutCache());
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    private void _layout(LayoutCache layoutCache) {
        int minCellHeight;
        int cellHeight;
        int maxMatrixWidth;
        int minCellWidth;
        Rectangle b = this.getBounds();
        Insets i = this.getInsets();
        Rectangle r = new Rectangle(i.left, i.top, b.width - (i.left + i.right), b.height - (i.top + i.bottom));
        int columnCount = Math.max(1, layoutCache.getColumnLevelCount());
        int columnLeafCount = layoutCache.getColumnLeafCount();
        int rowLeafCount = layoutCache.getRowLeafCount();
        int yLevelCount = layoutCache.getYLevelCount();
        int xLevelCount = layoutCache.getXLevelCount();
        int y2LevelCount = layoutCache.getY2LevelCount();
        int xAxisLabelPlacement = layoutCache.getXAxisLabelPlacement();
        int yAxisLabelPlacement = layoutCache.getYAxisLabelPlacement();
        int y2AxisLabelPlacement = layoutCache.getY2AxisLabelPlacement();
        Dimension minimumCellSize = layoutCache.getMinimumCellSize();
        if (minimumCellSize.width < MIN_AXIS_LENGTH) {
            minimumCellSize.width = MIN_AXIS_LENGTH;
        }
        if (minimumCellSize.height < MIN_AXIS_LENGTH) {
            minimumCellSize.height = MIN_AXIS_LENGTH;
        }
        if (b.width <= 0 || b.height <= 0) {
            this.disablePanes("InsufficientDisplaySpace.ex.txt");
            return;
        }
        Dimension mps = layoutCache.getMatrixPreferredSize();
        Dimension xaps = layoutCache.getXAxisPreferredSize();
        Dimension xalps = layoutCache.getXAxisLabelPreferredSize();
        Dimension yaps = layoutCache.getYAxisPreferredSize();
        Dimension yalps = layoutCache.getYAxisLabelPreferredSize();
        Dimension y2aps = layoutCache.getY2AxisPreferredSize();
        Dimension y2alps = layoutCache.getY2AxisLabelPreferredSize();
        GridDimension cmaps = layoutCache.getColumnMatrixAxisPreferredSize();
        GridDimension cmalps = layoutCache.getColumnMatrixAxisLabelPreferredSize();
        GridDimension rmaps = layoutCache.getRowMatrixAxisPreferredSize();
        GridDimension rmalps = layoutCache.getRowMatrixAxisLabelPreferredSize();
        Map mc2w = layoutCache.getMatrixColumnToPreferredWidth();
        Map mr2h = layoutCache.getMatrixRowToPreferredHeight();
        AlignableComponentConstraints mc = new AlignableComponentConstraints();
        AlignableComponentConstraints xac = new AlignableComponentConstraints();
        AlignableComponentConstraints xalc = new AlignableComponentConstraints();
        AlignableComponentConstraints yac = new AlignableComponentConstraints();
        AlignableComponentConstraints yalc = new AlignableComponentConstraints();
        AlignableComponentConstraints y2ac = new AlignableComponentConstraints();
        AlignableComponentConstraints y2alc = new AlignableComponentConstraints();
        AlignableComponentConstraints cmac = new AlignableComponentConstraints();
        AlignableComponentConstraints cmalc = new AlignableComponentConstraints();
        AlignableComponentConstraints rmac = new AlignableComponentConstraints();
        AlignableComponentConstraints rmalc = new AlignableComponentConstraints();
        this.mb = mc.getBounds();
        Rectangle xab = xac.getBounds();
        Rectangle xalb = xalc.getBounds();
        Rectangle yab = yac.getBounds();
        Rectangle yalb = yalc.getBounds();
        Rectangle y2ab = y2ac.getBounds();
        Rectangle y2alb = y2alc.getBounds();
        Rectangle cmab = cmac.getBounds();
        Rectangle cmalb = cmalc.getBounds();
        Rectangle rmab = rmac.getBounds();
        Rectangle rmalb = rmalc.getBounds();
        ZoomScrollBar columnScrollBar = layoutCache.getColumnScrollBar();
        ZoomScrollBar rowScrollBar = layoutCache.getRowScrollBar();
        MatrixContainer2.ScrollModelProjection columnScrollModelProjection = layoutCache.getColumnScrollModelProjection();
        MatrixContainer2.ScrollModelProjection rowScrollModelProjection = layoutCache.getRowScrollModelProjection();
        int cellWidth = ScatterPlotMatrixContainer._computeCellWidth(r, xalps, yalps, y2alps, yaps, y2aps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, columnCount, columnLeafCount, this.isRowEast);
        if (cellWidth < (minCellWidth = Math.max((int)((double)((maxMatrixWidth = Math.max(Math.max(cmaps.width, mps.width), xaps.width)) / columnLeafCount) * 0.2), minimumCellSize.width))) {
            if (rmaps.width > 0 && ScatterPlotMatrixContainer._restrictColumnAndXAxisLabelWidths(yaps, y2aps, xalps, yalps, y2alps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, this.isRowEast)) {
                cellWidth = ScatterPlotMatrixContainer._computeCellWidth(r, xalps, yalps, y2alps, yaps, y2aps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, columnCount, columnLeafCount, this.isRowEast);
            }
            if (cellWidth < minCellWidth) {
                if (yalps.width > yaps.width && yAxisLabelPlacement == 11302) {
                    yAxisLabelPlacement = 11303;
                }
                if (y2alps.width > y2aps.width && y2AxisLabelPlacement == 11302) {
                    y2AxisLabelPlacement = 11303;
                }
                if (rmaps.width > 0) {
                    ScatterPlotMatrixContainer._restrictColumnAndXAxisLabelWidths(yaps, y2aps, xalps, yalps, y2alps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, this.isRowEast);
                }
                if ((cellWidth = ScatterPlotMatrixContainer._computeCellWidth(r, xalps, yalps, y2alps, yaps, y2aps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, columnCount, columnLeafCount, this.isRowEast)) < minCellWidth && ScatterPlotMatrixContainer._restrictColumnAndXAxisLabelWidths(yaps, y2aps, xalps, yalps, y2alps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, this.isRowEast)) {
                    cellWidth = ScatterPlotMatrixContainer._computeCellWidth(r, xalps, yalps, y2alps, yaps, y2aps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, columnCount, columnLeafCount, this.isRowEast);
                }
                if (cellWidth < minCellWidth && rmalps.width > rmaps.width) {
                    rmalps.width = rmaps.width;
                    ScatterPlotMatrixContainer._restrictColumnAndXAxisLabelWidths(yaps, y2aps, xalps, yalps, y2alps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, this.isRowEast);
                    cellWidth = ScatterPlotMatrixContainer._computeCellWidth(r, xalps, yalps, y2alps, yaps, y2aps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, columnCount, columnLeafCount, this.isRowEast);
                }
                if (cellWidth < (minCellWidth = minimumCellSize.width)) {
                    yaps.width = layoutCache.getYAxisMinimumSize().width;
                    y2aps.width = layoutCache.getY2AxisMinimumSize().width;
                    ScatterPlotMatrixContainer._restrictColumnAndXAxisLabelWidths(yaps, y2aps, xalps, yalps, y2alps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, this.isRowEast);
                    cellWidth = ScatterPlotMatrixContainer._computeCellWidth(r, xalps, yalps, y2alps, yaps, y2aps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, columnCount, columnLeafCount, this.isRowEast);
                    if (cellWidth < minCellWidth) {
                        rmalps.height = 0;
                        rmalps.width = 0;
                        rmaps.height = 0;
                        rmaps.width = 0;
                        yaps.width = layoutCache.getYAxisPreferredSize().width;
                        y2aps.width = layoutCache.getY2AxisPreferredSize().width;
                        if (xAxisLabelPlacement != 11306) {
                            xalps = layoutCache.getXAxisLabelPreferredSize();
                        }
                        cmalps = layoutCache.getColumnMatrixAxisLabelPreferredSize();
                        ScatterPlotMatrixContainer._restrictColumnAndXAxisLabelWidths(yaps, y2aps, xalps, yalps, y2alps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, this.isRowEast);
                        cellWidth = ScatterPlotMatrixContainer._computeCellWidth(r, xalps, yalps, y2alps, yaps, y2aps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, columnCount, columnLeafCount, this.isRowEast);
                        if (cellWidth < minCellWidth) {
                            yaps.width = layoutCache.getYAxisMinimumSize().width;
                            y2aps.width = layoutCache.getY2AxisMinimumSize().width;
                            cmalps.height = 0;
                            cmalps.width = 0;
                            xalps.width = 0;
                            cellWidth = ScatterPlotMatrixContainer._computeCellWidth(r, xalps, yalps, y2alps, yaps, y2aps, cmalps, rmaps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, columnCount, columnLeafCount, this.isRowEast);
                        }
                        if (cellWidth < 1) {
                            this.disablePanes("InsufficientDisplaySpace.ex.txt");
                            return;
                        }
                    }
                }
            }
        }
        int matrixWidth = 0;
        this._applyAutomaticJustification(xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement, this.isRowEast);
        matrixWidth = ScatterPlotMatrixContainer._scaleMap(mc2w, cellWidth * columnLeafCount);
        if (xaps.width != 0 || xaps.height != 0) {
            ValueTree columnTree = this.xAxisCellPane.getTree();
            DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(columnTree);
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                JComponent xAxis;
                Integer axisWidth;
                DataTreeGroupNode columnNode = colTreeLeaves[ii];
                if (columnNode == null || (axisWidth = (Integer)mc2w.get(columnNode)) == null || (xAxis = this.xAxisCellPane.getCellComponent((TreeNode)columnNode)) == null) continue;
                xAxis.setBounds(0, 0, axisWidth, r.height);
            }
            xaps.height = CellPane.getUniformPreferredSize((CellPane)this.xAxisCellPane).height;
        }
        if ((cellHeight = ScatterPlotMatrixContainer._computeCellHeight(r, xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, rowLeafCount, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement)) < (minCellHeight = minimumCellSize.height)) {
            cmalps.height = cmaps.height;
            cellHeight = ScatterPlotMatrixContainer._computeCellHeight(r, xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, rowLeafCount, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement);
            if (cellHeight < minCellHeight) {
                boolean isYAxisLabelCullingEnabled = yAxisLabelPlacement != 11306;
                boolean isY2AxisLabelCullingEnabled = y2AxisLabelPlacement != 11306;
                GridDimension altrmalps = new GridDimension(rmalps);
                Dimension altyalps = new Dimension(yalps.width, yalps.height);
                Dimension alty2alps = new Dimension(y2alps.width, y2alps.height);
                rmalps.height = 0;
                rmalps.width = 0;
                if (isYAxisLabelCullingEnabled) {
                    yalps.height = 0;
                    yalps.width = 0;
                }
                if (isY2AxisLabelCullingEnabled) {
                    y2alps.height = 0;
                    y2alps.width = 0;
                }
                if ((cellHeight = ScatterPlotMatrixContainer._computeCellHeight(r, xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, rowLeafCount, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement)) < minCellHeight) {
                    Dimension altxaps = new Dimension(xaps.width, xaps.height);
                    Dimension altxalps = new Dimension(xalps.width, xalps.height);
                    xaps.height = 0;
                    xaps.width = 0;
                    xalps.height = 0;
                    xalps.width = 0;
                    cellHeight = ScatterPlotMatrixContainer._computeCellHeight(r, xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, rowLeafCount, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement);
                    if (cellHeight < minCellHeight) {
                        cmaps.height = 0;
                        cmaps.width = 0;
                        cmalps.height = 0;
                        cmalps.width = 0;
                        rmalps.apply(altrmalps);
                        yalps.width = altyalps.width;
                        yalps.height = altyalps.height;
                        y2alps.width = alty2alps.width;
                        y2alps.height = alty2alps.height;
                        xaps.width = altxaps.width;
                        xaps.height = altxaps.height;
                        xalps.width = altxalps.width;
                        xalps.height = altxalps.height;
                        cellHeight = ScatterPlotMatrixContainer._computeCellHeight(r, xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, rowLeafCount, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement);
                        if (cellHeight < minCellHeight) {
                            rmalps.height = 0;
                            rmalps.width = 0;
                            if (isYAxisLabelCullingEnabled) {
                                yalps.height = 0;
                                yalps.width = 0;
                            }
                            if (isY2AxisLabelCullingEnabled) {
                                y2alps.height = 0;
                                y2alps.width = 0;
                            }
                            if ((cellHeight = ScatterPlotMatrixContainer._computeCellHeight(r, xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, rowLeafCount, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement)) < minCellHeight) {
                                xaps.height = 0;
                                xaps.width = 0;
                                xalps.height = 0;
                                xalps.width = 0;
                                cellHeight = ScatterPlotMatrixContainer._computeCellHeight(r, xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, rowLeafCount, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement);
                            }
                        }
                    }
                }
            }
        }
        if (cellHeight < minCellHeight) {
            this.disablePanes("InsufficientDisplaySpace.ex.txt");
            return;
        }
        GridDimension.mergeWidths(rmaps, rmalps);
        GridDimension.mergeHeights(cmaps, cmalps);
        Insets margin = new Insets(0, 0, 0, 0);
        int xalpsWidth = xAxisLabelPlacement == 11306 ? 0 : xalps.width;
        int yWidth = ScatterPlotMatrixContainer._computeYWidth(yaps, yalps, yAxisLabelPlacement);
        int y2Width = ScatterPlotMatrixContainer._computeYWidth(y2aps, y2alps, y2AxisLabelPlacement);
        int westWidth = yWidth;
        int eastWidth = y2Width;
        if (this.isRowEast) {
            eastWidth = Math.max(eastWidth + rmaps.width, Math.max(cmalps.width, xalpsWidth));
        } else {
            westWidth = Math.max(westWidth + rmaps.width, Math.max(cmalps.width, xalpsWidth));
        }
        int totalPaneWidth = westWidth + matrixWidth + eastWidth;
        if (totalPaneWidth > r.width) {
            matrixWidth = Math.max(0, (r.width - (westWidth + eastWidth)) / columnLeafCount * columnLeafCount);
            totalPaneWidth = westWidth + matrixWidth + eastWidth;
        }
        int maxSpacer = Util.MIN_FONT_WIDTH / 2;
        int excessPixels = r.width - totalPaneWidth;
        int ymaGap = Math.min(maxSpacer, excessPixels);
        margin.left = (excessPixels -= ymaGap) / 2;
        margin.right = excessPixels - margin.left;
        int salGap = 0;
        int salpsWidth = cmalps.width;
        if (xAxisLabelPlacement == -11302) {
            salpsWidth = Math.max(salpsWidth, xalps.width);
        }
        if (this.isRowEast) {
            eastWidth += ymaGap;
            if ((eastWidth += ymaGap) > salpsWidth) {
                salGap = Math.min(maxSpacer, eastWidth - salpsWidth);
            }
        } else if ((westWidth += ymaGap) > salpsWidth) {
            salGap = Math.min(maxSpacer, westWidth - salpsWidth);
        }
        int startX = r.x + margin.left;
        int matrixStartX = startX + westWidth;
        if (this.isRowEast) {
            cmab.width = xab.width = matrixWidth;
            this.mb.width = xab.width;
            cmab.x = xab.x = matrixStartX;
            this.mb.x = xab.x;
            yab.width = yaps.width;
            yab.x = this.mb.x - yab.width;
            cmalb.width = cmalps.width;
            xalb.width = xalps.width;
            cmalb.x = xalb.x = cmab.x + cmab.width + salGap;
            if (this.columnMatrixAxisValuePane == null || this.columnMatrixAxisValuePane.getContentPanelComponents().length == 0) {
                xalb.x = (int)((double)this.mb.x + (double)this.mb.width * 0.5 - (double)xalps.width * 0.5);
            }
            y2ab.width = y2aps.width;
            y2ab.x = this.mb.x + this.mb.width;
            rmab.width = rmalb.width = rmaps.width;
            rmab.x = rmalb.x = y2ab.x + y2ab.width + ymaGap;
        } else {
            cmab.width = xab.width = matrixWidth;
            this.mb.width = xab.width;
            cmab.x = xab.x = matrixStartX;
            this.mb.x = xab.x;
            yab.width = yaps.width;
            yab.x = this.mb.x - yab.width;
            xalb.width = xalps.width;
            xalb.x = this.mb.x - xalb.width - salGap;
            if (this.columnMatrixAxisValuePane == null || this.columnMatrixAxisValuePane.getContentPanelComponents().length == 0) {
                xalb.x = (int)((double)this.mb.x + (double)this.mb.width * 0.5 - (double)xalps.width * 0.5);
            }
            rmab.width = rmalb.width = rmaps.width;
            rmab.x = rmalb.x = matrixStartX - yWidth - ymaGap - rmab.width;
            cmalb.width = cmalps.width;
            cmalb.x = matrixStartX - cmalb.width - salGap;
            y2ab.width = y2aps.width;
            y2ab.x = this.mb.x + this.mb.width - 1;
        }
        int[] yAxesWidths = ScatterPlotMatrixContainer._computeYAxesLabelMaxWidths(yab, y2ab, yalps, y2alps, yAxisLabelPlacement, y2AxisLabelPlacement, matrixWidth);
        int maxYAxisLabelWidth = yAxesWidths[0];
        int maxY2AxisLabelWidth = yAxesWidths[1];
        yalb.width = Math.min(yalps.width, maxYAxisLabelWidth);
        switch (yAxisLabelPlacement) {
            case 11306: {
                yalb.x = yab.x - yalb.width;
                break;
            }
            case 11303: {
                if (yalb.width < yab.width) {
                    yalb.x = yab.x + yab.width - yalb.width;
                    break;
                }
                yalb.x = yab.x;
                break;
            }
            case 11301: {
                yalb.x = matrixStartX;
                break;
            }
            case 11302: {
                yalb.x = matrixStartX - yalb.width;
            }
        }
        y2alb.width = Math.min(y2alps.width, maxY2AxisLabelWidth);
        switch (y2AxisLabelPlacement) {
            case 11306: {
                y2alb.x = y2ab.x + y2ab.width;
                break;
            }
            case 11303: {
                if (y2alb.width < y2ab.width) {
                    y2alb.x = y2ab.x;
                    break;
                }
                y2alb.x = y2ab.x + y2ab.width - y2alb.width;
                break;
            }
            case 11301: {
                y2alb.x = y2ab.x - y2alb.width;
                break;
            }
            case 11302: {
                y2alb.x = y2ab.x;
            }
        }
        int[] heights = ScatterPlotMatrixContainer._computeHeights(xaps, xalps, yalps, y2alps, cmaps, cmalps, rmalps, xAxisLabelPlacement, yAxisLabelPlacement, y2AxisLabelPlacement);
        int northHeight = heights[NORTH];
        int matrixHeight = ScatterPlotMatrixContainer._scaleMap(mr2h, cellHeight * rowLeafCount);
        int southHeight = heights[SOUTH];
        int excessPixels2 = r.height - (northHeight + matrixHeight + southHeight);
        margin.top = excessPixels2 / 2;
        margin.bottom = excessPixels2 - margin.top;
        int startY = r.y + margin.top;
        int topOfMatrixY = startY + northHeight;
        yalb.height = yalps.height;
        switch (yAxisLabelPlacement) {
            case 11301: 
            case 11302: 
            case 11303: {
                yalb.y = topOfMatrixY - yalps.height;
                break;
            }
            case 11306: {
                yalb.height = Math.min(yalps.height, matrixHeight);
                yalb.y = topOfMatrixY + matrixHeight / 2 - yalb.height / 2;
            }
        }
        y2alb.height = y2alps.height;
        switch (y2AxisLabelPlacement) {
            case 11301: 
            case 11302: 
            case 11303: {
                y2alb.y = topOfMatrixY - y2alps.height;
                break;
            }
            case 11306: {
                y2alb.height = Math.min(y2alps.height, matrixHeight);
                y2alb.y = topOfMatrixY + matrixHeight / 2 - y2alb.height / 2;
            }
        }
        rmalb.height = rmalps.height;
        rmalb.y = topOfMatrixY - rmalb.height;
        y2ab.y = rmab.y = topOfMatrixY;
        yab.y = rmab.y;
        this.mb.y = rmab.y;
        y2ab.height = rmab.height = matrixHeight;
        yab.height = rmab.height;
        this.mb.height = rmab.height;
        xab.height = xaps.height;
        xab.y = topOfMatrixY + matrixHeight - 1;
        xalb.height = xalps.height;
        switch (xAxisLabelPlacement) {
            case 11301: {
                xalb.y = topOfMatrixY + matrixHeight - xalb.height;
                cmab.y = cmalb.y = xab.y + xab.height;
                break;
            }
            case 11303: {
                xalb.y = topOfMatrixY + matrixHeight + xab.height - xalb.height;
                cmab.y = cmalb.y = xab.y + xab.height;
                break;
            }
            case -11302: 
            case 11302: {
                xalb.y = topOfMatrixY + matrixHeight;
                cmab.y = cmalb.y = xab.y + Math.max(xab.height, xalb.height);
                break;
            }
            case 11306: {
                xalb.y = topOfMatrixY + matrixHeight + xab.height;
                cmab.y = cmalb.y = xab.y + xab.height + xalb.height;
            }
        }
        cmab.height = cmalb.height = cmaps.height;
        ScatterPlotMatrixContainer.applyPaneBounds(this.matrixCellPane, this.mb);
        ScatterPlotMatrixContainer.applyPaneBounds(this.columnMatrixAxisValuePane, cmab);
        ScatterPlotMatrixContainer.applyPaneBounds(this.columnMatrixAxisLabelPane, cmalb);
        ScatterPlotMatrixContainer.applyPaneBounds(this.rowMatrixAxisValuePane, rmab);
        ScatterPlotMatrixContainer.applyPaneBounds(this.rowMatrixAxisLabelPane, rmalb);
        ScatterPlotMatrixContainer.applyPaneBounds(this.xAxisCellPane, xab);
        ScatterPlotMatrixContainer.applyPaneBounds(this.xAxisLabelPane, xalb);
        ScatterPlotMatrixContainer.applyPaneBounds(this.yAxisCellPane, yab);
        ScatterPlotMatrixContainer.applyPaneBounds(this.yAxisLabelPane, yalb);
        ScatterPlotMatrixContainer.applyPaneBounds(this.y2AxisCellPane, y2ab);
        ScatterPlotMatrixContainer.applyPaneBounds(this.y2AxisLabelPane, y2alb);
        if (this.messagesComponent != null) {
            int x1 = yab.x;
            int x2 = y2ab.x + y2ab.width;
            int y1 = this.mb.y;
            int y2 = this.mb.y + xab.y + xab.height;
            Rectangle display = new Rectangle(x1, y1, x2 - x1, y2 - y1);
            Dimension wps = this.messagesComponent.getPreferredSize();
            Rectangle wmb = new Rectangle();
            wmb.width = Math.min(wps.width, display.width);
            wmb.height = Math.min(wps.height, display.height);
            wmb.x = display.x + (display.width - wmb.width) / 2;
            wmb.y = display.y + (display.height - wmb.height) / 2;
            ScatterPlotMatrixContainer.applyBounds(this.messagesComponent, wmb);
        }
        if (columnScrollBar != null) {
            Rectangle csbb = new Rectangle(this.mb.x, this.mb.y + this.mb.height, this.mb.width, 13);
            columnScrollBar.setBounds(csbb.x, csbb.y, csbb.width, csbb.height);
        }
        if (rowScrollBar != null) {
            Rectangle rsbb = this.yAxisCellPane == null && this.y2AxisCellPane != null ? new Rectangle(this.mb.x + this.mb.width + 1, this.mb.y, 13, this.mb.height) : new Rectangle(this.mb.x - 13, this.mb.y, 13, this.mb.height);
            rowScrollBar.setBounds(rsbb.x, rsbb.y, rsbb.width, rsbb.height);
        }
        columnScrollModelProjection.setViewportSize(this.mb.width);
        rowScrollModelProjection.setViewportSize(this.mb.height);
        double columnViewSize = columnScrollModelProjection.calculateViewSize();
        double rowViewSize = rowScrollModelProjection.calculateViewSize();
        cellHeight = rowScrollModelProjection.calculateViewSize() / rowLeafCount;
        int scrollX = columnScrollModelProjection.calculateViewScroll();
        int scrollY = rowScrollModelProjection.calculateViewScroll();
        int matrixScrollX = scrollX;
        int matrixScrollY = scrollY;
        boolean rowScrollX = false;
        int rowScrollY = matrixScrollY;
        int colScrollX = matrixScrollX;
        boolean colScrollY = false;
        ScatterPlotMatrixContainer._scaleMap(mc2w, (int)columnViewSize);
        ScatterPlotMatrixContainer._scaleMap(mr2h, (int)rowViewSize);
        ScatterPlotMatrixContainer._setGridWidthsFromMap(this.matrixCellPane, mc2w, cmaps);
        ScatterPlotMatrixContainer._setGridHeightsFromMap(this.matrixCellPane, mr2h, rmaps);
        Font fontUsed = null;
        boolean isColumn = true;
        if (columnLeafCount > 1) {
            this._resetForceFit(this.xAxisCellPane);
            this._resetValueFont(this.xAxisCellPane, isColumn);
            CellPane.doLayoutByColumn(this.xAxisCellPane, xac, mc2w, colScrollX, 0);
            String fitUsed = this._findFitUsed(this.xAxisCellPane);
            fontUsed = this._findSmallestValueFontUsed(this.xAxisCellPane, isColumn);
            if (fitUsed != null || fontUsed != null) {
                if (fitUsed != null) {
                    this._forceFit(this.xAxisCellPane, fitUsed);
                }
                if (fontUsed != null) {
                    this._forceValueFont(this.xAxisCellPane, fontUsed, isColumn);
                }
                CellPane.doLayoutByColumn(this.xAxisCellPane, xac, mc2w, colScrollX, 0);
            }
        } else {
            CellPane.doLayoutByColumn(this.xAxisCellPane, xac, mc2w, colScrollX, 0);
        }
        if (xLevelCount > 0) {
            LabelPane.doLayout(this.xAxisLabelPane, 5, xalb.width, xalb.height / xLevelCount);
        }
        if (rowLeafCount > 1) {
            isColumn = false;
            this._resetValueFont(this.yAxisCellPane, isColumn);
            CellPane.doLayoutByRow(this.yAxisCellPane, yac, mr2h, 0, rowScrollY);
            fontUsed = this._findSmallestValueFontUsed(this.yAxisCellPane, isColumn);
            if (fontUsed != null) {
                this._forceValueFont(this.yAxisCellPane, fontUsed, isColumn);
                CellPane.doLayoutByRow(this.yAxisCellPane, yac, mr2h, 0, rowScrollY);
            }
        } else {
            CellPane.doLayoutByRow(this.yAxisCellPane, yac, mr2h, 0, rowScrollY);
        }
        if (yLevelCount > 0) {
            if (yAxisLabelPlacement == 11306) {
                LabelPane.doLayout(this.yAxisLabelPane, 3, yalb.width / yLevelCount, yalb.height);
            } else {
                LabelPane.doLayout(this.yAxisLabelPane, 5, yalb.width, yalb.height / yLevelCount);
            }
        }
        if (rowLeafCount > 1) {
            isColumn = false;
            this._resetValueFont(this.yAxisCellPane, isColumn);
            CellPane.doLayoutByRow(this.y2AxisCellPane, y2ac, mr2h, 0, rowScrollY);
            fontUsed = this._findSmallestValueFontUsed(this.yAxisCellPane, isColumn);
            if (fontUsed != null) {
                this._forceValueFont(this.yAxisCellPane, fontUsed, isColumn);
                CellPane.doLayoutByRow(this.y2AxisCellPane, y2ac, mr2h, 0, rowScrollY);
            }
        } else {
            CellPane.doLayoutByRow(this.y2AxisCellPane, y2ac, mr2h, 0, rowScrollY);
        }
        if (y2LevelCount > 0) {
            if (y2AxisLabelPlacement == 11306) {
                LabelPane.doLayout(this.y2AxisLabelPane, 7, y2alb.width / y2LevelCount, y2alb.height);
            } else {
                LabelPane.doLayout(this.y2AxisLabelPane, 5, y2alb.width, y2alb.height / y2LevelCount);
            }
        }
        int leafGrowthDirection = this.isRowEast ? 7 : 3;
        ValuePane.doLayout(this.rowMatrixAxisValuePane, leafGrowthDirection, rmaps, 0, 0);
        LabelPane.doLayout(this.rowMatrixAxisLabelPane, leafGrowthDirection, rmalps);
        leafGrowthDirection = 1;
        ValuePane.doLayout(this.columnMatrixAxisValuePane, leafGrowthDirection, cmaps, 0, 0);
        LabelPane.doLayout(this.columnMatrixAxisLabelPane, leafGrowthDirection, cmalps);
        AlignableComponentConstraints constraints = new AlignableComponentConstraints();
        constraints.getBounds().width = cellWidth;
        constraints.getBounds().height = cellHeight;
        CellPane.doLayoutByColumnAndRow(this.matrixCellPane, constraints, mc2w, mr2h, matrixScrollX, matrixScrollY);
    }

    private void _resetForceFit(CellPane cellPane) {
        String forceFitToUse = null;
        boolean reset = true;
        this._fitConsistency(cellPane, forceFitToUse, reset);
    }

    private String _findFitUsed(CellPane cellPane) {
        String forceFitToUse = null;
        boolean reset = false;
        return this._fitConsistency(cellPane, forceFitToUse, reset);
    }

    private String _forceFit(CellPane cellPane, String forceFitToUse) {
        boolean reset = false;
        return this._fitConsistency(cellPane, forceFitToUse, reset);
    }

    private String _fitConsistency(CellPane cellPane, String forceFitToUse, boolean resetForceFit) {
        String fitUsed = null;
        int indexOfFitUsed = -1;
        int tempIndex = -1;
        AxisCellModel axisCellModel = null;
        DataTreeGroupNode[] treeLeaves = null;
        if (cellPane != null && (treeLeaves = GTKUtil.getLeafNodes(cellPane.getColumnTree())) != null) {
            for (int ii = 0; ii < treeLeaves.length; ++ii) {
                String used;
                JComponent cellComponent = cellPane.getCellComponent((TreeNode)treeLeaves[ii]);
                if (cellComponent == null || !(cellComponent instanceof AxisCell)) continue;
                axisCellModel = ((AxisCell)cellComponent).getAxisModel();
                if (forceFitToUse != null) {
                    axisCellModel.setForceFitAlgorithm(forceFitToUse);
                    continue;
                }
                if (resetForceFit) {
                    axisCellModel.setForceFitAlgorithm(null);
                    continue;
                }
                if (axisCellModel == null || axisCellModel.getFitAlgorithmUsed() == null || (used = axisCellModel.getFitAlgorithmUsed()) == null || used.length() <= 0) continue;
                String[] fitAlg = axisCellModel.getFitAlgorithm();
                for (int xx = 0; xx < fitAlg.length; ++xx) {
                    if (fitAlg[xx].indexOf(used) < 0) continue;
                    tempIndex = xx;
                }
                if (tempIndex <= indexOfFitUsed) continue;
                indexOfFitUsed = tempIndex;
                fitUsed = fitAlg[indexOfFitUsed];
            }
        }
        return fitUsed;
    }

    private void _resetValueFont(CellPane cellPane, boolean columnValues) {
        Font forceFontToUse = null;
        boolean reset = true;
        boolean isColumn = columnValues;
        this._fontConsistency(cellPane, forceFontToUse, reset, isColumn);
    }

    private Font _findSmallestValueFontUsed(CellPane cellPane, boolean columnValues) {
        Font forceFontToUse = null;
        boolean reset = false;
        boolean isColumn = columnValues;
        return this._fontConsistency(cellPane, forceFontToUse, reset, isColumn);
    }

    private void _forceValueFont(CellPane cellPane, Font forceFontToUse, boolean columnValues) {
        boolean reset = false;
        boolean isColumn = columnValues;
        this._fontConsistency(cellPane, forceFontToUse, reset, isColumn);
    }

    private Font _fontConsistency(CellPane cellPane, Font forceFontToUse, boolean resetForceFont, boolean isColumn) {
        Font smallestFontUsed = null;
        AxisCellModel axisCellModel = null;
        DataTreeGroupNode[] treeLeaves = null;
        if (cellPane != null && (treeLeaves = isColumn ? GTKUtil.getLeafNodes(cellPane.getColumnTree()) : GTKUtil.getLeafNodes(cellPane.getRowTree())) != null) {
            for (int ii = 0; ii < treeLeaves.length; ++ii) {
                JComponent cellComponent = cellPane.getCellComponent((TreeNode)treeLeaves[ii]);
                if (cellComponent == null || !(cellComponent instanceof AxisCell)) continue;
                axisCellModel = ((AxisCell)cellComponent).getAxisModel();
                if (forceFontToUse != null) {
                    axisCellModel.setValueFontForced(forceFontToUse);
                    continue;
                }
                if (resetForceFont) {
                    axisCellModel.setValueFontForced(null);
                    continue;
                }
                Font valueFont = axisCellModel.getValueFontUsed();
                if (valueFont == null || smallestFontUsed != null && valueFont.getSize() >= smallestFontUsed.getSize()) continue;
                smallestFontUsed = valueFont;
            }
        }
        return smallestFontUsed;
    }

    private static Map _maxMap(Map map1, Map map2) {
        if (map1 == null) {
            return map2 == null ? null : new HashMap(map2);
        }
        if (map2 == null) {
            return map1 == null ? null : new HashMap(map1);
        }
        Set keySet = map1.keySet();
        try {
            keySet.addAll(map2.keySet());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Object[] keys = keySet.toArray();
        HashMap<Object, Integer> newMap = new HashMap<Object, Integer>(keys.length);
        for (int ii = 0; ii < keys.length; ++ii) {
            Integer cellSize1 = (Integer)map1.get(keys[ii]);
            Integer cellSize2 = (Integer)map2.get(keys[ii]);
            if (cellSize1 != null && cellSize2 != null) {
                if (cellSize1 > cellSize2) {
                    newMap.put(keys[ii], cellSize1);
                    continue;
                }
                newMap.put(keys[ii], cellSize2);
                continue;
            }
            if (cellSize1 != null) {
                newMap.put(keys[ii], cellSize1);
                continue;
            }
            if (cellSize2 == null) continue;
            newMap.put(keys[ii], cellSize2);
        }
        return newMap;
    }

    private static void _setGridWidthsFromMap(CellPane p, Map m, GridDimension d) {
        if (m == null) {
            return;
        }
        DataTreeGroupNode[] colLeaves = GTKUtil.getLeafNodes(p.getColumnTree());
        if (colLeaves == null) {
            return;
        }
        Dimension ds = d.getGridSize();
        d.setGridSize(colLeaves.length, false, ds.height, false);
        for (int i = 0; i < colLeaves.length; ++i) {
            Integer ww = (Integer)m.get(colLeaves[i]);
            int w = ww;
            d.setColWidth(i, w);
        }
    }

    private static void _setGridHeightsFromMap(CellPane p, Map m, GridDimension d) {
        if (m == null) {
            return;
        }
        DataTreeGroupNode[] rowLeaves = GTKUtil.getLeafNodes(p.getRowTree());
        if (rowLeaves == null) {
            return;
        }
        Dimension ds = d.getGridSize();
        d.setGridSize(ds.width, false, rowLeaves.length, false);
        for (int i = 0; i < rowLeaves.length; ++i) {
            Integer hh = (Integer)m.get(rowLeaves[i]);
            int h = hh;
            d.setRowHeight(i, h);
        }
    }

    private static int _getMapSize(Map map) {
        if (map != null) {
            int mapSize = 0;
            Object[] keys = map.keySet().toArray();
            if (keys != null) {
                for (int ii = 0; ii < keys.length; ++ii) {
                    Integer cellSize = (Integer)map.get(keys[ii]);
                    if (cellSize == null || cellSize < 0) continue;
                    mapSize += cellSize.intValue();
                }
                return mapSize;
            }
        }
        return -1;
    }

    private static int _scaleMap(Map map, int size) {
        if (map != null && size >= 0) {
            int mapSize = 0;
            Object[] keys = map.keySet().toArray();
            if (keys != null) {
                for (int ii = 0; ii < keys.length; ++ii) {
                    Integer cellSize = (Integer)map.get(keys[ii]);
                    if (cellSize == null || cellSize < 0) continue;
                    mapSize += cellSize.intValue();
                }
                if (mapSize < 1) {
                    return -1;
                }
                double ratio = (double)size / (double)mapSize;
                int newMapSize = 0;
                for (int ii = 0; ii < keys.length; ++ii) {
                    Integer cellSize = (Integer)map.get(keys[ii]);
                    if (cellSize == null || cellSize < 0) continue;
                    int newCellSize = (int)((double)cellSize.intValue() * ratio);
                    map.put(keys[ii], new Integer(newCellSize));
                    newMapSize += newCellSize;
                }
                return newMapSize;
            }
        }
        return -1;
    }

    private static int[] _computeYAxesLabelMaxWidths(Rectangle yab, Rectangle y2ab, Dimension yalps, Dimension y2alps, int yAxisLabelPlacement, int y2AxisLabelPlacement, int matrixWidth) {
        boolean y2AxisClaim;
        int maxYAxisLabelWidth = yalps.width;
        int maxY2AxisLabelWidth = y2alps.width;
        boolean yAxisClaim = yalps.width > 0 && (yAxisLabelPlacement == 11301 || yAxisLabelPlacement == 11303);
        boolean bl = y2AxisClaim = y2alps.width > 0 && (y2AxisLabelPlacement == 11301 || y2AxisLabelPlacement == 11303);
        if (yAxisClaim && !y2AxisClaim) {
            maxYAxisLabelWidth = matrixWidth;
            if (yAxisLabelPlacement == 11303) {
                maxYAxisLabelWidth += yab.width;
            }
        } else if (!yAxisClaim && y2AxisClaim) {
            maxY2AxisLabelWidth = matrixWidth;
            if (y2AxisLabelPlacement == 11303) {
                maxY2AxisLabelWidth += y2ab.width;
            }
        } else if (yAxisClaim && y2AxisClaim) {
            int desiredYAxisMatrixWidth = yalps.width;
            if (yAxisLabelPlacement == 11303) {
                desiredYAxisMatrixWidth -= yab.width;
            }
            int desiredY2AxisMatrixWidth = y2alps.width;
            if (y2AxisLabelPlacement == 11303) {
                desiredY2AxisMatrixWidth -= y2ab.width;
            }
            if (desiredYAxisMatrixWidth + desiredY2AxisMatrixWidth < matrixWidth) {
                maxYAxisLabelWidth = yalps.width;
                maxY2AxisLabelWidth = y2alps.width;
            } else if (desiredYAxisMatrixWidth < matrixWidth / 2) {
                maxYAxisLabelWidth = yalps.width;
                maxY2AxisLabelWidth = matrixWidth - desiredYAxisMatrixWidth;
                if (y2AxisLabelPlacement == 11303) {
                    maxY2AxisLabelWidth += y2ab.width;
                }
            } else if (desiredY2AxisMatrixWidth < matrixWidth / 2) {
                maxY2AxisLabelWidth = y2alps.width;
                maxYAxisLabelWidth = matrixWidth - desiredY2AxisMatrixWidth;
                if (yAxisLabelPlacement == 11303) {
                    maxYAxisLabelWidth += yab.width;
                }
            } else {
                maxYAxisLabelWidth = matrixWidth / 2;
                if (yAxisLabelPlacement == 11303) {
                    maxYAxisLabelWidth += yab.width;
                }
                maxY2AxisLabelWidth = matrixWidth / 2;
                if (y2AxisLabelPlacement == 11303) {
                    maxY2AxisLabelWidth += y2ab.width;
                }
            }
        }
        return new int[]{maxYAxisLabelWidth, maxY2AxisLabelWidth};
    }

    private void _applyAutomaticJustification(int xAxisLabelPlacement, int yAxisLabelPlacement, int y2AxisLabelPlacement, boolean isRowEast) {
        switch (yAxisLabelPlacement) {
            case 11306: {
                StringComponent.applyAutomaticJustification(this.yAxisLabelPane, 0);
                break;
            }
            default: {
                StringComponent.applyAutomaticJustification(this.yAxisLabelPane, 2);
                break;
            }
            case 11301: {
                StringComponent.applyAutomaticJustification(this.yAxisLabelPane, 2);
                break;
            }
            case 11302: {
                StringComponent.applyAutomaticJustification(this.yAxisLabelPane, 4);
            }
        }
        switch (y2AxisLabelPlacement) {
            case 11306: {
                StringComponent.applyAutomaticJustification(this.y2AxisLabelPane, 0);
                break;
            }
            default: {
                StringComponent.applyAutomaticJustification(this.y2AxisLabelPane, 4);
                break;
            }
            case 11301: {
                StringComponent.applyAutomaticJustification(this.y2AxisLabelPane, 4);
                break;
            }
            case 11302: {
                StringComponent.applyAutomaticJustification(this.y2AxisLabelPane, 2);
            }
        }
        switch (xAxisLabelPlacement) {
            case 11306: {
                StringComponent.applyAutomaticJustification(this.xAxisLabelPane, 0);
                break;
            }
            default: {
                StringComponent.applyAutomaticJustification(this.xAxisLabelPane, isRowEast ? 2 : 4);
                break;
            }
            case 11301: 
            case 11302: 
            case 11303: {
                StringComponent.applyAutomaticJustification(this.xAxisLabelPane, 2);
            }
        }
        if (isRowEast) {
            StringComponent.applyAutomaticJustification(this.columnMatrixAxisLabelPane, 2);
        } else {
            StringComponent.applyAutomaticJustification(this.columnMatrixAxisLabelPane, 4);
        }
    }

    public ZoomScrollBar getColumnScrollBar() {
        return this.columnScrollBar;
    }

    public ZoomScrollBar getRowScrollBar() {
        return this.rowScrollBar;
    }

    public MatrixContainer2.ScrollModelProjection getColumnScrollModelProjection() {
        return this.columnScrollModelProjection;
    }

    public MatrixContainer2.ScrollModelProjection getRowScrollModelProjection() {
        return this.rowScrollModelProjection;
    }

    public PlotImageMapInfo2 getImageMapInfo() {
        PlotValueZone[] columnValueZones = this.columnMatrixAxisValuePane == null ? null : this.columnMatrixAxisValuePane.toPlotValueZones(this, 0);
        PlotValueZone[] rowValueZones = this.rowMatrixAxisValuePane == null ? null : this.rowMatrixAxisValuePane.toPlotValueZones(this, 1);
        PlotValueZone[] xValueZones = null;
        PlotValueZone[] yValueZones = null;
        PlotValueZone[] y2ValueZones = null;
        PlotValueZone[] sizeValueZones = null;
        PlotValueZone[] groupValueZones = null;
        PlotValueZone[] dataElementValueZones = null;
        LabelZoneList columnLabelZoneList = this.columnMatrixAxisLabelPane == null ? null : this.columnMatrixAxisLabelPane.toLabelZoneList(this);
        LabelZoneList rowLabelZoneList = this.rowMatrixAxisLabelPane == null ? null : this.rowMatrixAxisLabelPane.toLabelZoneList(this);
        LabelZoneList xLabelZoneList = this.xAxisLabelPane == null ? null : this.xAxisLabelPane.toLabelZoneList(this);
        LabelZoneList yLabelZoneList = this.yAxisLabelPane == null ? null : this.yAxisLabelPane.toLabelZoneList(this);
        LabelZoneList y2LabelZoneList = this.y2AxisLabelPane == null ? null : this.y2AxisLabelPane.toLabelZoneList(this);
        LabelZoneList sizeLabelZoneList = null;
        LabelZoneList groupLabelZoneList = null;
        PlotImageMapInfo2 imageMapInfo = new PlotImageMapInfo2(columnValueZones, rowValueZones, xValueZones, yValueZones, y2ValueZones, sizeValueZones, groupValueZones, dataElementValueZones, columnLabelZoneList, rowLabelZoneList, xLabelZoneList, yLabelZoneList, y2LabelZoneList, sizeLabelZoneList, groupLabelZoneList);
        imageMapInfo.source = this;
        return imageMapInfo;
    }

    private class LayoutCache {
        private final Dimension mps;
        private final Dimension xaps;
        private final Dimension xalps;
        private final Dimension yaps;
        private final Dimension yalps;
        private final Dimension y2aps;
        private final Dimension y2alps;
        private final Dimension yams;
        private final Dimension y2ams;
        private final GridDimension cmaps;
        private final GridDimension cmalps;
        private final GridDimension rmaps;
        private final GridDimension rmalps;
        private final Map matrixRowToPreferredHeight;
        private final Map matrixColumnToPreferredWidth;
        private final int xAxisLabelPlacement;
        private final int yAxisLabelPlacement;
        private final int y2AxisLabelPlacement;
        private final int columnLeafCount;
        private final int rowLeafCount;
        private final int xLevelCount;
        private final int yLevelCount;
        private final int y2LevelCount;
        private final int columnLevelCount;
        private final int rowLevelCount;
        private final boolean containsNonMissingData;
        private final Dimension preferredSize;
        private final Dimension minimumCellSize;

        public LayoutCache() {
            boolean isYAxisPresent;
            DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(ScatterPlotMatrixContainer.this.columnTree);
            DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(ScatterPlotMatrixContainer.this.rowTree);
            this.columnLevelCount = ScatterPlotMatrixContainer.this.columnTree.getVariableCount();
            this.rowLevelCount = ScatterPlotMatrixContainer.this.rowTree.getVariableCount();
            this.xLevelCount = ScatterPlotMatrixContainer.this.xAxisLabelPane == null ? 0 : ScatterPlotMatrixContainer.this.xAxisLabelPane.getContentPanelComponents().length;
            this.yLevelCount = ScatterPlotMatrixContainer.this.yAxisLabelPane == null ? 0 : ScatterPlotMatrixContainer.this.yAxisLabelPane.getContentPanelComponents().length;
            this.y2LevelCount = ScatterPlotMatrixContainer.this.y2AxisLabelPane == null ? 0 : ScatterPlotMatrixContainer.this.y2AxisLabelPane.getContentPanelComponents().length;
            this.columnLeafCount = colTreeLeaves.length;
            this.rowLeafCount = rowTreeLeaves.length;
            this.yAxisLabelPlacement = ScatterPlotMatrixContainer.this.yAxisLabelPlacementPolicy == 10200 ? 11303 : (ScatterPlotMatrixContainer.this.yAxisLabelPlacementPolicy == 11306 && this.rowLevelCount > 0 ? 11303 : ScatterPlotMatrixContainer.this.yAxisLabelPlacementPolicy);
            if (this.yAxisLabelPlacement == 11306) {
                Util.rotateStringComponents(ScatterPlotMatrixContainer.this.yAxisLabelPane, 90.0);
            }
            this.y2AxisLabelPlacement = ScatterPlotMatrixContainer.this.y2AxisLabelPlacementPolicy == 10200 ? 11303 : (ScatterPlotMatrixContainer.this.y2AxisLabelPlacementPolicy == 11306 && this.rowLevelCount > 0 ? 11303 : ScatterPlotMatrixContainer.this.y2AxisLabelPlacementPolicy);
            if (this.y2AxisLabelPlacement == 11306) {
                Util.rotateStringComponents(ScatterPlotMatrixContainer.this.y2AxisLabelPane, 270.0);
            }
            boolean bl = ScatterPlotMatrixContainer.this.yAxisCellPane == null ? false : (isYAxisPresent = ScatterPlotMatrixContainer.this.yAxisCellPane.getContentPanelComponents().length > 0);
            boolean isY2AxisPresent = ScatterPlotMatrixContainer.this.y2AxisCellPane == null ? false : ScatterPlotMatrixContainer.this.y2AxisCellPane.getContentPanelComponents().length > 0;
            this.xAxisLabelPlacement = this.columnLevelCount > 0 ? -11302 : 11306;
            this.containsNonMissingData = this._containsNonMissingData(colTreeLeaves, rowTreeLeaves);
            Map mr2h = CellPane.getRowToPreferredHeight(ScatterPlotMatrixContainer.this.matrixCellPane);
            Map mc2w = CellPane.getColumnToPreferredWidth(ScatterPlotMatrixContainer.this.matrixCellPane);
            Map xc2w = CellPane.getColumnToPreferredWidth(ScatterPlotMatrixContainer.this.xAxisCellPane);
            Map yr2h = CellPane.getRowToPreferredHeight(ScatterPlotMatrixContainer.this.yAxisCellPane);
            Map y2r2h = CellPane.getRowToPreferredHeight(ScatterPlotMatrixContainer.this.y2AxisCellPane);
            this.matrixColumnToPreferredWidth = ScatterPlotMatrixContainer._maxMap(mc2w, xc2w);
            this.matrixRowToPreferredHeight = ScatterPlotMatrixContainer._maxMap(ScatterPlotMatrixContainer._maxMap(mr2h, yr2h), y2r2h);
            this.mps = new Dimension(ScatterPlotMatrixContainer._getMapSize(this.matrixColumnToPreferredWidth), ScatterPlotMatrixContainer._getMapSize(this.matrixRowToPreferredHeight));
            this.xaps = CellPane.getPreferredSize(ScatterPlotMatrixContainer.this.xAxisCellPane);
            this.yaps = CellPane.getPreferredSize(ScatterPlotMatrixContainer.this.yAxisCellPane);
            this.y2aps = CellPane.getPreferredSize(ScatterPlotMatrixContainer.this.y2AxisCellPane);
            this.yams = CellPane.getMinimumSize(ScatterPlotMatrixContainer.this.yAxisCellPane);
            this.y2ams = CellPane.getMinimumSize(ScatterPlotMatrixContainer.this.y2AxisCellPane);
            this.xalps = LabelPane.getPreferredSize(ScatterPlotMatrixContainer.this.xAxisLabelPane, 5);
            this.yalps = LabelPane.getPreferredSize(ScatterPlotMatrixContainer.this.yAxisLabelPane, 5);
            this.y2alps = LabelPane.getPreferredSize(ScatterPlotMatrixContainer.this.y2AxisLabelPane, 5);
            this.cmaps = ValuePane.getPreferredGridSize(ScatterPlotMatrixContainer.this.columnMatrixAxisValuePane, 1);
            this.rmaps = ValuePane.getPreferredGridSize(ScatterPlotMatrixContainer.this.rowMatrixAxisValuePane, 3);
            this.cmalps = LabelPane.getPreferredGridSize(ScatterPlotMatrixContainer.this.columnMatrixAxisLabelPane, 1);
            this.rmalps = LabelPane.getPreferredGridSize(ScatterPlotMatrixContainer.this.rowMatrixAxisLabelPane, 3);
            this.preferredSize = this._getPreferredSize();
            this.minimumCellSize = this._getMinimumCellSize();
        }

        private boolean _containsNonMissingData(Variable x, Variable y) {
            if (x == null || y == null) {
                return false;
            }
            for (int i = 0; i < x.getValueCount(); ++i) {
                try {
                    if (x instanceof NumericVariable) {
                        ((NumericVariable)x).value.getValue(i);
                    } else {
                        ((StringVariable)x).value.getValue(i);
                    }
                    if (y instanceof NumericVariable) {
                        ((NumericVariable)y).value.getValue(i);
                    } else {
                        ((StringVariable)y).value.getValue(i);
                    }
                }
                catch (MissingValueException mv) {
                    continue;
                }
                return true;
            }
            return false;
        }

        private boolean _containsNonMissingData(DataTreeGroupNode[] colTreeLeaves, DataTreeGroupNode[] rowTreeLeaves) {
            if (colTreeLeaves == null || rowTreeLeaves == null) {
                return false;
            }
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    JComponent component = ScatterPlotMatrixContainer.this.matrixCellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                    if (!(component instanceof ScatterPlotCell)) continue;
                    ScatterPlotCell cell = (ScatterPlotCell)component;
                    ScatterComposite comp = (ScatterComposite)cell.getComposite();
                    Variable[] xv = comp.getXVariable();
                    Variable[] yv = comp.getYVariable();
                    if (xv != null) {
                        if (yv != null) {
                            if (xv.length > 1 && yv.length > 1) {
                                int length = Math.min(xv.length, yv.length);
                                for (int vv = 0; vv < length; ++vv) {
                                    if (!this._containsNonMissingData(xv[vv], yv[vv])) continue;
                                    return true;
                                }
                                continue;
                            }
                            Variable[] v1 = xv;
                            Variable[] v2 = yv;
                            if (v1.length > 1) {
                                v1 = yv;
                                v2 = xv;
                            }
                            for (int kk = 0; kk < v2.length; ++kk) {
                                if (!this._containsNonMissingData(v1[0], v2[kk])) continue;
                                return true;
                            }
                            continue;
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private Dimension _newDimension(Dimension d) {
            return new Dimension(d.width, d.height);
        }

        private GridDimension _newGridDimension(GridDimension d) {
            return new GridDimension(d);
        }

        private Map _newMap(Map map) {
            return map == null ? null : new HashMap(map);
        }

        private void _maxMinimumSize(HierarchicalPane pane, Dimension ms, boolean isWidthEnabled, boolean isHeightEnabled) {
            if (pane != null) {
                Component[] c = pane.getContentPanelComponents();
                for (int ii = 0; ii < c.length; ++ii) {
                    Dimension cms = c[ii].getMinimumSize();
                    if (cms == null) continue;
                    if (isWidthEnabled && ms.width < cms.width) {
                        ms.width = cms.width;
                    }
                    if (!isHeightEnabled || ms.height >= cms.height) continue;
                    ms.height = cms.height;
                }
            }
        }

        private Dimension _getMinimumCellSize() {
            Dimension ms = new Dimension(0, 0);
            this._maxMinimumSize(ScatterPlotMatrixContainer.this.matrixCellPane, ms, true, true);
            return ms;
        }

        private Dimension _getPreferredSize() {
            int w = 0;
            int[] widths = ScatterPlotMatrixContainer._computeWidths(this.xaps, this.yaps, this.y2aps, this.mps, this.xalps, this.yalps, this.y2alps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, this.xAxisLabelPlacement, this.yAxisLabelPlacement, this.y2AxisLabelPlacement, ScatterPlotMatrixContainer.this.isRowEast);
            int westWidth = widths[WEST];
            int matrixWidth = widths[MATRIX];
            int eastWidth = widths[EAST];
            w = westWidth + matrixWidth + eastWidth;
            w += Util.MIN_FONT_WIDTH * 2;
            int h = 0;
            int[] heights = ScatterPlotMatrixContainer._computeHeights(this.xaps, this.yaps, this.y2aps, this.mps, this.xalps, this.yalps, this.y2alps, this.cmaps, this.cmalps, this.rmaps, this.rmalps, this.xAxisLabelPlacement, this.yAxisLabelPlacement, this.y2AxisLabelPlacement);
            int northHeight = heights[NORTH];
            int matrixHeight = heights[MATRIX];
            int southHeight = heights[SOUTH];
            h = northHeight + matrixHeight + southHeight;
            if (ScatterPlotMatrixContainer.this.messagesComponent != null) {
                Dimension wps = ScatterPlotMatrixContainer.this.messagesComponent.getPreferredSize();
                w = Math.max(w, wps.width);
                h = Math.max(h, wps.height);
            }
            Insets insets = ScatterPlotMatrixContainer.this.getInsets();
            return new Dimension(w += insets.top + insets.bottom, h += insets.left + insets.right);
        }

        public Dimension getMinimumCellSize() {
            return this._newDimension(this.minimumCellSize);
        }

        public Dimension getPreferredSize() {
            return this._newDimension(this.preferredSize);
        }

        public Dimension getMatrixPreferredSize() {
            return this._newDimension(this.mps);
        }

        public Dimension getXAxisPreferredSize() {
            return this._newDimension(this.xaps);
        }

        public Dimension getXAxisLabelPreferredSize() {
            return this._newDimension(this.xalps);
        }

        public Dimension getYAxisPreferredSize() {
            return this._newDimension(this.yaps);
        }

        public Dimension getYAxisLabelPreferredSize() {
            return this._newDimension(this.yalps);
        }

        public Dimension getY2AxisPreferredSize() {
            return this._newDimension(this.y2aps);
        }

        public Dimension getY2AxisLabelPreferredSize() {
            return this._newDimension(this.y2alps);
        }

        public Dimension getYAxisMinimumSize() {
            return this._newDimension(this.yams);
        }

        public Dimension getY2AxisMinimumSize() {
            return this._newDimension(this.y2ams);
        }

        public GridDimension getColumnMatrixAxisPreferredSize() {
            return this._newGridDimension(this.cmaps);
        }

        public GridDimension getColumnMatrixAxisLabelPreferredSize() {
            return this._newGridDimension(this.cmalps);
        }

        public GridDimension getRowMatrixAxisPreferredSize() {
            return this._newGridDimension(this.rmaps);
        }

        public GridDimension getRowMatrixAxisLabelPreferredSize() {
            return this._newGridDimension(this.rmalps);
        }

        public Map getMatrixRowToPreferredHeight() {
            return this._newMap(this.matrixRowToPreferredHeight);
        }

        public Map getMatrixColumnToPreferredWidth() {
            return this._newMap(this.matrixColumnToPreferredWidth);
        }

        public int getColumnLeafCount() {
            return this.columnLeafCount;
        }

        public int getColumnLevelCount() {
            return this.columnLevelCount;
        }

        public int getRowLeafCount() {
            return this.rowLeafCount;
        }

        public int getRowLevelCount() {
            return this.rowLevelCount;
        }

        public int getXLevelCount() {
            return this.xLevelCount;
        }

        public int getYLevelCount() {
            return this.yLevelCount;
        }

        public int getY2LevelCount() {
            return this.y2LevelCount;
        }

        public int getXAxisLabelPlacement() {
            return this.xAxisLabelPlacement;
        }

        public int getYAxisLabelPlacement() {
            return this.yAxisLabelPlacement;
        }

        public int getY2AxisLabelPlacement() {
            return this.y2AxisLabelPlacement;
        }

        public boolean containsNonMissingData() {
            return this.containsNonMissingData;
        }

        public ZoomScrollBar getColumnScrollBar() {
            return ScatterPlotMatrixContainer.this.columnScrollBar;
        }

        public ZoomScrollBar getRowScrollBar() {
            return ScatterPlotMatrixContainer.this.rowScrollBar;
        }

        public MatrixContainer2.ScrollModelProjection getColumnScrollModelProjection() {
            return ScatterPlotMatrixContainer.this.columnScrollModelProjection;
        }

        public MatrixContainer2.ScrollModelProjection getRowScrollModelProjection() {
            return ScatterPlotMatrixContainer.this.rowScrollModelProjection;
        }
    }
}

