/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.scatterplot;

import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.SimpleModelInterface;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.scatterplot.ScatterComposite;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import java.awt.Dimension;

public class ScatterPlotCell
extends Cell
implements PlotImageMapInfo.PlotImageMapInfoAuthorInterface {
    private final transient ScatterComposite scatter;
    private final transient Composite selectionScatter;
    private final transient ValueList columnValueList;
    private final transient ValueList rowValueList;
    private final transient DataSource dataSource;
    private final transient DataSource selectionDataSource;

    public ScatterPlotCell(ScatterPlotCellModel cellModel, DataSource newDataSource, DataSource newSelectionDataSource, Object columnOrdinal, Object rowOrdinal, Channel channel) {
        super(cellModel, channel);
        this.dataSource = newDataSource;
        this.selectionDataSource = newSelectionDataSource;
        this.columnValueList = Util.DataTreeGroupNodeUtil.toValueList(columnOrdinal);
        this.rowValueList = Util.DataTreeGroupNodeUtil.toValueList(rowOrdinal);
        GraphModel graphModel = cellModel.getScatterPlotMatrixModel().getGraphModel();
        this.setAntiAliasingEnabled(graphModel.isAntialiasedGraphics());
        this.setTextAntiAliasingEnabled(graphModel.isAntialiasedText());
        Channel ch = this.getChannel();
        this.scatter = new ScatterComposite(cellModel, this.dataSource, ch);
        NetworkRoot root = this.getNetworkRoot();
        root.removeAllElements();
        root.addElement((Element)this.scatter);
        if (this.selectionDataSource != null) {
            this.selectionScatter = this.scatter.createSelectionComposite(this.selectionDataSource);
            NetworkRoot selectionRoot = this.createSelectionNetworkRoot(this.dataSource.getDataSourceSelectionModel());
            if (selectionRoot != null) {
                selectionRoot.removeAllElements();
                selectionRoot.addElement((Element)this.selectionScatter);
            }
        } else {
            this.selectionScatter = null;
            if (this.dataSource != null) {
                this.setSelectionModel(this.dataSource.getDataSourceSelectionModel());
            }
        }
    }

    @Override
    public Composite getComposite() {
        return this.scatter;
    }

    @Override
    public DataSource getDataSource() {
        return this.scatter.getDataSource();
    }

    @Override
    protected synchronized void construct() {
        this.scatter.construct(this.getColumn(), this.getRow());
        NetworkRoot root = this.getNetworkRoot();
        root.removeAllElements();
        int count = this.scatter.getElementCount();
        for (int i = 0; i < count; ++i) {
            Composite c = new Composite();
            c.transform.translateX.connectFrom((NumericPipe)this.scatter.transform.translateX);
            c.transform.translateY.connectFrom((NumericPipe)this.scatter.transform.translateY);
            Element e = this.scatter.getElement(i);
            c.addElement(e);
            root.addElement((Element)c);
        }
        NetworkRoot selroot = this.getSelectionNetworkRoot();
        if (selroot != null) {
            selroot.removeAllElements();
            DataSource dataSource = this.getDataSource();
            if (dataSource != null && dataSource.getValueCount() > 0 && this.selectionScatter != null) {
                int scount = this.selectionScatter.getElementCount();
                for (int i = 0; i < scount; ++i) {
                    Composite c = new Composite();
                    c.transform.translateX.connectFrom((NumericPipe)this.scatter.transform.translateX);
                    c.transform.translateY.connectFrom((NumericPipe)this.scatter.transform.translateY);
                    Element e = this.selectionScatter.getElement(i);
                    c.addElement(e);
                    selroot.addElement((Element)c);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.scatter == null || this.scatter.getDataSource() == null) {
            return super.getPreferredSize();
        }
        return this.scatter.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.scatter == null || this.scatter.getDataSource() == null) {
            return super.getMinimumSize();
        }
        return this.scatter.getMinimumSize();
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        this.scatter.setAnimationFrame(animationPosition);
        if (this.selectionDataSource != null) {
            this.selectionDataSource.setAnimationPosition(animationPosition);
        }
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.scatter != null) {
            int c = this.scatter.getMarkerCount();
            double area = width * height;
            if (this.scatter.getDataSource().isAnimationEnabled()) {
                this.setDoubleBufferPolicy(10202);
            } else if (this.selectionScatter != null || c > 2999 && area > 0.0 && area / (double)c < 81.0) {
                this.setDoubleBufferPolicy(10201);
            } else {
                this.setDoubleBufferPolicy(10200);
            }
        }
        if (width != 0 && height != 0) {
            this.scatter.setBounds(x, y, width, height);
            this.setPreferredSize(this.scatter.getPreferredSize());
        }
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        if (this.scatter == null || this.scatter.getDataSource() == null) {
            return null;
        }
        return this.scatter.createPickInfo(x, y, obsIndex);
    }

    @Override
    protected SimpleModelInterface getModel() {
        return super.getModel();
    }

    double[] getXRange() {
        return this.scatter.getXRange();
    }

    double[] getYRange() {
        return this.scatter.getYRange();
    }

    double[] getY2Range() {
        return this.scatter.getY2Range();
    }

    void setXMapper(NumericMapper mapper) {
        this.scatter.setXMapper(mapper);
    }

    void setYMapper(NumericMapper mapper) {
        this.scatter.setYMapper(mapper);
    }

    void setY2Mapper(NumericMapper mapper) {
        this.scatter.setY2Mapper(mapper);
    }

    void setXAxisCellModel(AxisCellModel model) {
        this.scatter.setXAxisCellModel(model);
    }

    void setYAxisCellModel(AxisCellModel model) {
        this.scatter.setYAxisCellModel(model);
    }

    void setY2AxisCellModel(AxisCellModel model) {
        this.scatter.setY2AxisCellModel(model);
    }

    @Override
    public PlotImageMapInfo getPlotImageMapInfo() {
        if (this.scatter != null && this.scatter.getDataSource() != null && this.scatter.getDataSource().getValueCount() > 0) {
            this.updateChannel();
            return this.scatter.getImageMapInfo(this.columnValueList, this.rowValueList, this.getNetworkRoot(), this);
        }
        return null;
    }

    @Override
    protected void updateChannel() {
        super.updateChannel();
        this.scatter.updateChannel();
    }

    public void selectionChanged() {
        this.invalidateBuffer();
        this.scatter.selectionChanged();
    }
}

