/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.radarchart;

import com.sas.graphics.util.cell.radarchart.Circle2;
import com.sas.graphics.util.cell.radarchart.Radar;
import com.sas.graphics.util.cell.radarchart.RadarSelectDetail;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class RadarElement
extends Element {
    public final StringProperty category = new StringProperty((PropertyContainer)this, true);
    public final StringProperty subgroup = new StringProperty((PropertyContainer)this, false);
    public final NumericProperty response = new NumericProperty((PropertyContainer)this, true);
    public final ColorProperty fillColor = new ColorProperty((PropertyContainer)this, true);
    public final ColorProperty outlineColor = new ColorProperty((PropertyContainer)this, true);
    public final NumericProperty lineThickness = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty lineStippleFactor = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty lineStipplePattern = new NumericProperty((PropertyContainer)this, true);
    public final BooleanProperty highlightOn = new BooleanProperty((PropertyContainer)this, true);
    public final ColorProperty highlightFillColor = new ColorProperty((PropertyContainer)this, true);
    protected int myValueCount;
    protected int radarType = 0;
    protected ContinuousRangeToNumericMapper[] responseMapper;
    protected double innerRadius;
    protected double radius;
    protected Font responseRingFont;
    protected double sectorWidth = 1.0;
    protected boolean fillPolygons = true;
    private Radar radar;

    public RadarElement(Radar radar) {
        super((ATransform)new Transform());
        this.radar = radar;
    }

    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        super.init(initAction);
        if (this.subgroup.isConnected()) {
            this.subgroup.init(initAction);
        }
        this.myValueCount = initAction.getValueCount();
        if (this.myValueCount == -1) {
            this.myValueCount = 1;
        }
        initAction.popValueCount();
        this.setValueCount(1);
        initAction.setValueCount(1);
        if (!initAction.beenInitialized((PropertyContainer)this)) {
            // empty if block
        }
    }

    protected void render(ABuildAction buildAction) throws MissingValueException {
        Channel ch = (Channel)buildAction.getGraphicsContext();
        ch.glPushAttrib(0);
        switch (this.radarType) {
            case 0: {
                this.drawPolygonRadar(buildAction, this.radar.angles, this.radar.categories, -1.0);
                break;
            }
            case 1: {
                this.drawSectorRadar(buildAction, this.radar.startRadiusMap, this.radar.angles, this.radar.categories, this.radar.stride, false);
                break;
            }
            case 2: {
                this.drawSpokeRadar(buildAction, this.radar.startRadiusMap, this.radar.angles, this.radar.categories, this.radar.stride);
                break;
            }
            case 3: {
                this.drawSectorRadar(buildAction, this.radar.startRadiusMap, this.radar.angles, this.radar.categories, this.radar.stride, true);
                break;
            }
            case 4: {
                this.drawCalendarRadar(buildAction, this.radar.startRadiusMap, this.radar.angles, this.radar.stride, this.radar.categories, this.radar.subgroups);
                break;
            }
            case 5: {
                this.drawPolygonRadar(buildAction, this.radar.angles, this.radar.categories, this.radar.stride / 2.0);
            }
        }
        ch.glPopAttrib();
    }

    private void drawSectorRadar(ABuildAction buildAction, Map startRadiusMap, Map angles, List categories, double stride, boolean chord) throws MissingValueException {
        Channel ch = (Channel)buildAction.getGraphicsContext();
        for (int i = 0; i < this.myValueCount; ++i) {
            double responseLength;
            String categoryValue = Radar.getValueReplaceMissing(this.category, i);
            ContinuousRangeToNumericMapper mapper = this.responseMapper[categories.indexOf(categoryValue)];
            try {
                responseLength = mapper.getValue(this.response.getValue(i));
            }
            catch (MissingValueException e) {
                responseLength = mapper.getOutputMin();
            }
            double angle = (Double)angles.get(categoryValue);
            double startRadius = (Double)startRadiusMap.get(categoryValue);
            startRadiusMap.put(categoryValue, new Double(startRadius + responseLength));
            double extentAngle = stride * this.sectorWidth;
            double polygonStartAngle = angle - extentAngle / 2.0;
            if (polygonStartAngle < 0.0) {
                polygonStartAngle = 360.0 + polygonStartAngle;
            }
            if (buildAction.isUseNameStack()) {
                ch.glLoadName((Object)new RadarSelectDetail(1, null, i, null));
            }
            ch.glColor(this.fillColor.getValue(i));
            ch.glEdgeColor(Color.BLACK);
            ch.glPolygonMode(BuildAction.getGLFillStyle((boolean)this.fillPolygons, (boolean)true));
            if (chord) {
                this.drawChordPolygon(buildAction, polygonStartAngle, extentAngle, responseLength, startRadius);
            } else {
                ch.glWedge(0.0, 0.0, startRadius, responseLength + startRadius, polygonStartAngle, extentAngle);
            }
            if (!this.highlightOn.getValue(i)) continue;
            ch.glPolygonMode(6);
            ch.glColor(this.highlightFillColor.getValue(i));
            if (chord) {
                this.drawChordPolygon(buildAction, polygonStartAngle, extentAngle, responseLength, startRadius);
                continue;
            }
            ch.glWedge(0.0, 0.0, startRadius, responseLength + startRadius, polygonStartAngle, extentAngle);
        }
        ch.glEnd();
    }

    private void drawPolygonRadar(ABuildAction buildAction, Map angles, List categories, double coronaAngle) throws MissingValueException {
        int i;
        Channel ch = (Channel)buildAction.getGraphicsContext();
        LinkedHashMap<String, ArrayList<Integer>> subgroupMap = new LinkedHashMap<String, ArrayList<Integer>>();
        HashMap<String, Boolean> highlightMap = new HashMap<String, Boolean>();
        for (i = 0; i < this.myValueCount; ++i) {
            String subgroupValue = Radar.getValueReplaceMissing(this.subgroup, i);
            Boolean subgroupHighlight = (Boolean)highlightMap.get(subgroupValue);
            boolean hightlight = false;
            if (subgroupHighlight != null) {
                hightlight = subgroupHighlight;
            }
            highlightMap.put(subgroupValue, new Boolean(hightlight |= this.highlightOn.getValue(i)));
            ArrayList<Integer> responseList = (ArrayList<Integer>)subgroupMap.get(subgroupValue);
            if (responseList == null) {
                responseList = new ArrayList<Integer>();
                subgroupMap.put(subgroupValue, responseList);
            }
            responseList.add(new Integer(i));
        }
        ch.glPolygonMode(BuildAction.getGLFillStyle((boolean)this.fillPolygons, (boolean)false));
        this.drawGeometry(buildAction, subgroupMap, angles, categories, 2, highlightMap, coronaAngle, (ColorPipe)this.fillColor);
        this.drawGeometry(buildAction, subgroupMap, angles, categories, 1, null, coronaAngle, (ColorPipe)this.outlineColor);
        ch.setMarkerSize(6);
        ch.setMarkerType(3);
        for (i = 0; i < this.myValueCount; ++i) {
            double responseLength;
            String categoryValue = Radar.getValueReplaceMissing(this.category, i);
            ContinuousRangeToNumericMapper mapper = this.responseMapper[categories.indexOf(categoryValue)];
            double angle = (Double)angles.get(categoryValue);
            try {
                responseLength = mapper.getValue(this.response.getValue(i));
            }
            catch (MissingValueException e) {
                continue;
            }
            double x = Math.cos(Math.toRadians(angle)) * responseLength;
            double y = Math.sin(Math.toRadians(angle)) * responseLength;
            if (buildAction.isUseNameStack()) {
                ch.glLoadName((Object)new RadarSelectDetail(1, null, i, null));
            }
            ch.glPolygonMode(2);
            if (this.highlightOn.getValue(i)) {
                ch.glColor(this.highlightFillColor.getValue(i));
            } else {
                ch.glColor(new Color(0, 0, 0, 0));
            }
            ch.glBegin(4);
            ch.glVertex(x, y, 0.0);
            ch.glEnd();
        }
    }

    private void drawSpokeRadar(ABuildAction buildAction, Map startRadiusMap, Map angles, List categories, double stride) throws MissingValueException {
        Channel ch = (Channel)buildAction.getGraphicsContext();
        for (int i = 0; i < this.myValueCount; ++i) {
            double responseLength;
            String categoryValue = Radar.getValueReplaceMissing(this.category, i);
            ContinuousRangeToNumericMapper mapper = this.responseMapper[categories.indexOf(categoryValue)];
            double angle = (Double)angles.get(categoryValue);
            try {
                responseLength = mapper.getValue(this.response.getValue(i));
            }
            catch (MissingValueException e) {
                responseLength = mapper.getOutputMin();
            }
            double x = Math.cos(Math.toRadians(angle)) * responseLength;
            double y = Math.sin(Math.toRadians(angle)) * responseLength;
            ch.glBegin(1);
            if (buildAction.isUseNameStack()) {
                ch.glLoadName((Object)new RadarSelectDetail(1, null, i, null));
            }
            ch.glColor(this.fillColor.getValue(i));
            ch.glVertex(0.0, 0.0);
            ch.glVertex(x, y);
            ch.glEnd();
            Circle2.drawCircle(ch, this.innerRadius, Color.gray, Color.gray, false, true);
        }
    }

    private void drawCalendarRadar(ABuildAction buildAction, Map startRadiusMap, Map angles, double stride, List categories, List subgroups) throws MissingValueException {
        Channel ch = (Channel)buildAction.getGraphicsContext();
        double radiusPerRing = (this.radius - this.innerRadius) / (double)subgroups.size();
        double angleClosestTo90 = Double.MAX_VALUE;
        for (int categoryIndex = 0; categoryIndex < categories.size(); ++categoryIndex) {
            String categoryValue = (String)categories.get(categoryIndex);
            for (int subgroupIndex = 0; subgroupIndex < subgroups.size(); ++subgroupIndex) {
                int i;
                Color wedgeColor = this.fillColor.getConnection() instanceof ContinuousRangeToColorMapper ? ((ContinuousRangeToColorMapper)this.fillColor.getConnection()).getOutOfRangeColor() : new Color(0, 0, 0, 0);
                String subgroupValue = (String)subgroups.get(subgroupIndex);
                double angle = (Double)angles.get(categoryValue);
                double startRadius = (Double)startRadiusMap.get(categoryValue);
                startRadiusMap.put(categoryValue, new Double(startRadius + radiusPerRing));
                double polygonStartAngle = angle - stride / 2.0;
                if (polygonStartAngle < 0.0) {
                    polygonStartAngle = 360.0 + polygonStartAngle;
                }
                for (i = 0; i < this.myValueCount; ++i) {
                    String currentCategory = Radar.getValueReplaceMissing(this.category, i);
                    String currentSubgroup = Radar.getValueReplaceMissing(this.subgroup, i);
                    if (!categoryValue.equals(currentCategory) || !subgroupValue.equals(currentSubgroup)) continue;
                    wedgeColor = this.fillColor.getValue(i);
                    if (!buildAction.isUseNameStack()) break;
                    ch.glLoadName((Object)new RadarSelectDetail(1, null, i, null));
                    break;
                }
                ch.glColor(wedgeColor);
                ch.glEdgeColor(Color.BLACK);
                ch.glPolygonMode(4);
                ch.glWedge(0.0, 0.0, startRadius + this.innerRadius, radiusPerRing + startRadius + this.innerRadius, polygonStartAngle, stride);
                if (Math.abs(angle - 90.0) < Math.abs(angleClosestTo90 - 90.0)) {
                    angleClosestTo90 = angle;
                }
                if (i >= this.myValueCount || !this.highlightOn.getValue(i)) continue;
                ch.glPolygonMode(6);
                ch.glColor(this.highlightFillColor.getValue(i));
                ch.glWedge(0.0, 0.0, startRadius + this.innerRadius, radiusPerRing + startRadius + this.innerRadius, polygonStartAngle, stride);
            }
            ch.glColor(Color.BLACK);
            ch.glTextAlign(1, 3);
            if (this.responseRingFont == null) continue;
            ch.glSelect2DFont(this.responseRingFont);
        }
        if (!buildAction.isUseNameStack()) {
            for (int subgroupIndex = 0; subgroupIndex < subgroups.size(); ++subgroupIndex) {
                double length = (double)subgroupIndex * radiusPerRing + this.innerRadius + radiusPerRing / 2.0;
                double x = Math.cos(Math.toRadians(angleClosestTo90)) * length;
                double y = Math.sin(Math.toRadians(angleClosestTo90)) * length;
                ch.glAlignment(1, 1);
                ch.gl2DText(((String)subgroups.get(subgroupIndex)).trim(), x, y, 0.0);
            }
        }
    }

    private boolean isPicking(ABuildAction buildAction) {
        return buildAction.isUseNameStack();
    }

    private void drawGeometry(ABuildAction buildAction, Map subgroupMap, Map angles, List categories, int geometryType, Map highlightMap, double coronaAngle, ColorPipe color) throws MissingValueException {
        ArrayList list;
        Channel ch = (Channel)buildAction.getGraphicsContext();
        Set keySet = subgroupMap.keySet();
        Iterator it = keySet.iterator();
        if (geometryType == 1) {
            ch.setLineJoinStyle(2);
            ch.setLineCapStyle(1);
            ch.glEnable(6);
        }
        while (it.hasNext()) {
            String subgroupValue = (String)it.next();
            list = (ArrayList)subgroupMap.get(subgroupValue);
            int firstIndex = (Integer)list.get(0);
            ch.glBegin(geometryType);
            if (this.isPicking(buildAction)) {
                ch.glLoadName((Object)new RadarSelectDetail(2, subgroupValue, firstIndex, list));
            }
            if (geometryType == 1) {
                int factor = (int)this.lineStippleFactor.getValue(firstIndex);
                int pattern = (int)this.lineStipplePattern.getValue(firstIndex);
                float thickness = (float)this.lineThickness.getValue(firstIndex);
                ch.glLineWidth(thickness);
                ch.glLineStipple(factor, pattern);
            }
            for (int j = 0; j < list.size(); ++j) {
                int index = (Integer)list.get(j);
                this.addVertex(buildAction, angles, categories, index, coronaAngle, color);
            }
            if (geometryType == 1) {
                this.addVertex(buildAction, angles, categories, firstIndex, -1.0, color);
            }
            ch.glEnd();
        }
        if (highlightMap != null && !this.isPicking(buildAction)) {
            for (String subgroupValue : keySet) {
                list = (ArrayList)subgroupMap.get(subgroupValue);
                if (!((Boolean)highlightMap.get(subgroupValue)).booleanValue()) continue;
                ch.glBegin(geometryType);
                ch.glPolygonMode(6);
                for (int j = 0; j < list.size(); ++j) {
                    int index = (Integer)list.get(j);
                    this.addVertex(buildAction, angles, categories, index, (ColorPipe)this.highlightFillColor, coronaAngle);
                }
                ch.glEnd();
            }
        }
    }

    private void addVertex(ABuildAction buildAction, Map angles, List categories, int index, double coronaAngle, ColorPipe color) throws MissingValueException {
        this.addVertex(buildAction, angles, categories, index, color, coronaAngle);
    }

    private void addVertex(ABuildAction buildAction, Map angles, List categories, int index, ColorPipe colorPipe, double coronaAngle) throws MissingValueException {
        double responseLength;
        Channel ch = (Channel)buildAction.getGraphicsContext();
        ch.glColor(colorPipe.getValue(index));
        String categoryValue = Radar.getValueReplaceMissing(this.category, index);
        ContinuousRangeToNumericMapper mapper = this.responseMapper[categories.indexOf(categoryValue)];
        double angle = (Double)angles.get(categoryValue);
        try {
            responseLength = mapper.getValue(this.response.getValue(index));
        }
        catch (MissingValueException e) {
            responseLength = 0.0;
        }
        this.addVertex(buildAction, Math.toRadians(angle), responseLength);
        if (coronaAngle != -1.0) {
            this.addVertex(buildAction, Math.toRadians(angle - coronaAngle), mapper.getOutputMin());
        }
    }

    private void addVertex(ABuildAction buildAction, double angle, double length) {
        Channel ch = (Channel)buildAction.getGraphicsContext();
        double x = Math.cos(angle) * length;
        double y = Math.sin(angle) * length;
        ch.glVertex(x, y);
    }

    private void drawChordPolygon(ABuildAction buildAction, double polygonStartAngle, double stride, double responseLength, double startRadius) {
        Channel ch = (Channel)buildAction.getGraphicsContext();
        ch.glBegin(2);
        double strideRadians = Math.toRadians(stride);
        double angleRadians = Math.toRadians(polygonStartAngle);
        double tan = Math.tan(Math.toRadians(stride / 2.0));
        double a = responseLength + startRadius;
        double b = a * tan;
        double c = Math.sqrt(a * a + b * b);
        this.addVertex(buildAction, angleRadians, c);
        this.addVertex(buildAction, angleRadians + strideRadians, c);
        this.addVertex(buildAction, angleRadians + strideRadians, startRadius);
        this.addVertex(buildAction, angleRadians, startRadius);
        ch.glEnd();
    }

    protected void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
    }

    public SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack stack = (Stack)rawDetail;
        int sdi = (Integer)stack.get(startIndex);
        return (SelectDetail)stack.get(startIndex + sdi - 1);
    }
}

