/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.radarchart;

import com.sas.MissingValues;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TickStyle;
import com.sas.graphics.components.radarchart.RadarChartModel;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.cell.AxisCellModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.radarchart.AngleToJustification;
import com.sas.graphics.util.cell.radarchart.Circle2;
import com.sas.graphics.util.cell.radarchart.Radar;
import com.sas.graphics.util.cell.radarchart.RadarChartCellModel;
import com.sas.graphics.util.cell.radarchart.RadarSelectDetail;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorMissingValueReplacement;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.ComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.graphics.util.gtk.gl.SelectResult;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class RadarChartCell
extends Cell {
    private static final transient double TWO_PI = Math.PI * 2;
    private static final transient double TITLE_PADDING = 4.0;
    private static final transient int MIN_LABEL_FONT_SIZE = 8;
    private static final transient double MAX_LABEL_SIZE = 0.25;
    private final transient Calculator xPosCalc = new Calculator("(cos(inA) * inB)");
    private final transient Calculator yPosCalc = new Calculator("(sin(inA) * inB)");
    private transient NumericVariable singleResponse;
    private transient StringVariable categoryVariable;
    private transient Variable[] responseVariableArray;
    private transient StringVariable subgroupVariable;
    private transient Variable[] selectionVariableArray = null;
    private transient Variable[] dataTipVariableArray;
    private transient Variable[] auxiliaryVariableArray;
    private transient DataSource dataSource;
    private final transient RadarChartCellModel cellModel;
    private transient double radius = 0.0;
    private transient double innerRadius = 0.0;
    private transient StringToNumericMapper axisMapper;
    private transient AxisModel defaultAxisModel;
    private transient ArrayList dependentAxisCellModelList;
    private transient RadarChartModel graphModel;
    private transient int radarType;
    private transient StringVector labelVector;
    private transient ContinuousRangeToNumericMapper[] responseMapper;
    static final String[] CONT_FIT_BEST_ALG = new String[]{"thinkeependshrink"};
    private static double[] ranges = new double[]{0.39269908169872414, 1.1780972450961724, 1.9634954084936207, 2.748893571891069, 3.5342917352885173, 4.319689898685965, 5.105088062083414, 5.890486225480862, 6.675884388878311};
    private static int[] hJustification = new int[]{1, 0, 0, 0, 1, 2, 2, 2, 1, 1};
    private static int[] vJustification = new int[]{0, 0, 1, 3, 3, 3, 1, 1, 0, 0};

    public RadarChartCell(RadarChartCellModel cellModel, DataSource dataSource, Channel channel) {
        super(cellModel, channel);
        this.cellModel = cellModel;
        this.graphModel = cellModel.getRadarChartModel();
        this.radarType = this.graphModel.getRadarType();
        this.defaultAxisModel = this.graphModel.getAxisModel();
        this.setOpaque(false);
        this.setAntiAliasingEnabled(this.graphModel.isAntialiasedGraphics());
        this.setTextAntiAliasingEnabled(this.graphModel.isAntialiasedText());
        this.dataSource = dataSource;
        this.setSelectionModel(dataSource.getDataSourceSelectionModel());
    }

    @Override
    protected synchronized void construct() {
        this.initVariables();
        if (!this.isDataValid()) {
            return;
        }
        this.initAxisMapper();
        Composite composite = this.getComposite();
        Rectangle bounds = this.getBounds();
        if (this.defaultAxisModel.getLabelTextStyle().isVisible()) {
            composite.addElement((Element)this.createLabels());
        } else {
            this.initRadii();
        }
        this.initDependentAxisMappers();
        this.initResponseMapper();
        if (this.graphModel.getAxisModel().getGridLineStyle().getVisibilityPolicy() == 10201 && !this.defaultAxisModel.isGridInFront()) {
            composite.addElement((Element)this.createGridLines());
        }
        if (this.defaultAxisModel.isVisible() && (this.radarType == 10904 && this.graphModel.isDrawSectorOnAxis() || this.radarType == 10905)) {
            composite.addElement((Element)this.createAxes());
        }
        composite.addElement((Element)this.createRadar());
        if (this.defaultAxisModel.isVisible() && (this.radarType == 10903 || this.radarType == 10907 || this.radarType == 10904 && !this.graphModel.isDrawSectorOnAxis())) {
            composite.addElement((Element)this.createAxes());
        }
        if (this.graphModel.getAxisModel().getGridLineStyle().getVisibilityPolicy() == 10201 && this.defaultAxisModel.isGridInFront()) {
            composite.addElement((Element)this.createGridLines());
        }
        if (this.responseMapper != null && this.responseMapper.length > 0 && this.defaultAxisModel.getReferenceLineModels() != null && this.radarType != 10906) {
            composite.addElement((Element)this.createReferenceCircles());
            if (this.isReferenceLabelsEnabled()) {
                composite.addElement((Element)this.createResponseScale());
            }
        }
        composite.transform.translateX.setValue((double)(bounds.width / 2));
        composite.transform.translateY.setValue((double)(bounds.height / 2));
    }

    private boolean isDataValid() {
        if (this.categoryVariable == null || this.singleResponse == null) {
            return false;
        }
        if (this.radarType != 10900 && this.radarType != 10901) {
            if (this.categoryVariable.getUniqueValueCount() < 3) {
                return false;
            }
            if (this.subgroupVariable != null && this.radarType != 10900 && this.radarType != 10901) {
                boolean enoughValues = false;
                HashMap<String, Integer> catSubMap = new HashMap<String, Integer>();
                for (int i = 0; i < this.categoryVariable.getValueCount(); ++i) {
                    String subgroup;
                    try {
                        this.singleResponse.value.getValue(i);
                    }
                    catch (MissingValueException e) {
                        continue;
                    }
                    try {
                        subgroup = this.subgroupVariable.formattedValue.getValue(i);
                    }
                    catch (MissingValueException e) {
                        subgroup = e.getMissingValue().toString();
                    }
                    Integer count = (Integer)catSubMap.get(subgroup);
                    if (count == null) {
                        count = new Integer(1);
                    } else {
                        if (count == 2) {
                            enoughValues = true;
                            break;
                        }
                        count = new Integer(count + 1);
                    }
                    catSubMap.put(subgroup, count);
                }
                return enoughValues;
            }
        }
        return true;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    private void initVariables() {
        if (this.dataSource != null && this.cellModel != null) {
            Object categoryRole = this.cellModel.getCategoryRole();
            Object responseRole = this.cellModel.getResponseRole();
            Object subgroupRole = this.cellModel.getSubgroupRole();
            Object selectionRole = this.cellModel.getSelectionRole();
            Object dataTipRole = this.cellModel.getDataTipRole();
            Object auxiliaryRole = this.cellModel.getAuxiliaryRole();
            this.categoryVariable = (StringVariable)this.dataSource.getVariable(categoryRole, 0);
            this.responseVariableArray = this.dataSource.getVariable(responseRole);
            this.selectionVariableArray = this.dataSource.getVariable(selectionRole);
            this.dataTipVariableArray = Util.getGTKVariableArray(this.dataSource, dataTipRole);
            this.auxiliaryVariableArray = Util.getGTKVariableArray(this.dataSource, auxiliaryRole);
            if (subgroupRole != null) {
                this.subgroupVariable = (StringVariable)this.dataSource.getVariable(subgroupRole, 0);
            }
            this.singleResponse = (NumericVariable)this.responseVariableArray[0];
        }
    }

    private void initAxisMapper() {
        this.axisMapper = new StringToNumericMapper();
        this.axisMapper.input.connectFrom(this.categoryVariable.formattedValue);
        this.axisMapper.setLabelMissingValues(true);
        double radstart = Math.toRadians((double)this.cellModel.getStartAngle().intValue() % 360.0);
        this.axisMapper.setStartValue(7.853981633974483 - radstart);
        this.axisMapper.setStrideValue(-(Math.PI * 2 / (double)this.categoryVariable.getUniqueValueCount()));
    }

    private void initRadii() {
        this.radius = this.calculateRadius(this.defaultAxisModel.getLabelTextStyle().getFont(), this.categoryVariable.formattedUniqueValue);
        if (this.radarType == 10906) {
            double d = this.innerRadius = this.defaultAxisModel.getStartOffset() != null ? this.defaultAxisModel.getStartOffset().getMagnitude((Object)"px") : this.radius / 5.0;
            if (this.innerRadius >= this.radius) {
                this.innerRadius = this.radius / 5.0;
            }
        } else if (this.radarType != 10900 && this.radarType != 10904 && this.radarType != 10905) {
            double d = this.innerRadius = this.defaultAxisModel.getStartOffset() != null ? this.defaultAxisModel.getStartOffset().getMagnitude((Object)"px") : this.radius / 3.0;
            if (this.innerRadius >= this.radius) {
                this.innerRadius = this.radius / 3.0;
            }
        }
    }

    private void initDependentAxisMappers() {
        if (this.dependentAxisCellModelList == null) {
            this.dependentAxisCellModelList = new ArrayList();
            int categoryCount = this.categoryVariable.getUniqueValueCount();
            StringVector categories = this.cellModel.getCategories();
            AxisCellModel[] dependentAxisCellModel = this.cellModel.getDependentAxisCellModel();
            for (int i = 0; i < categoryCount; ++i) {
                String currentCat = "";
                try {
                    currentCat = this.categoryVariable.formattedUniqueValue.getValue(i);
                }
                catch (MissingValueException mve) {
                    currentCat = ValueMap.getDefaultMissingValueLabel((MissingValues)mve.getMissingValue());
                }
                for (int j = 0; j < categories.getValueCount(); ++j) {
                    try {
                        if (!currentCat.equals(categories.getValue(j))) continue;
                        dependentAxisCellModel[j].computeParameters(this.getChannel(), this.radius);
                        this.dependentAxisCellModelList.add(dependentAxisCellModel[j]);
                        continue;
                    }
                    catch (MissingValueException mve) {
                        if (!currentCat.equals(ValueMap.getDefaultMissingValueLabel((MissingValues)mve.getMissingValue()))) continue;
                        dependentAxisCellModel[j].computeParameters(this.getChannel(), this.radius);
                        this.dependentAxisCellModelList.add(dependentAxisCellModel[j]);
                    }
                }
            }
        }
    }

    private void initResponseMapper() {
        int categoryCount = this.categoryVariable.getUniqueValueCount();
        this.responseMapper = new ContinuousRangeToNumericMapper[categoryCount];
        for (int i = 0; i < categoryCount; ++i) {
            this.responseMapper[i] = new ContinuousRangeToNumericMapper();
            this.responseMapper[i].shareMap((ContinuousRangeToNumericMapper)((AxisCellModel)this.dependentAxisCellModelList.get(i)).getMapper());
            this.responseMapper[i].input.connectFrom(this.singleResponse.value);
            this.responseMapper[i].setOutputMin(this.innerRadius);
            this.responseMapper[i].setOutputMax(this.radius);
        }
    }

    private Radar createRadar() {
        Radar radar = new Radar();
        double angleStart = (90 - this.cellModel.getStartAngle().intValue()) % 360;
        if (this.radarType == 10906) {
            ContinuousRangeToColorMapper responseColorMapper = (ContinuousRangeToColorMapper)this.cellModel.getFillMapper();
            ContinuousRangeToColorMapper continuousRangeToColorMapper = new ContinuousRangeToColorMapper();
            continuousRangeToColorMapper.shareMap(responseColorMapper);
            continuousRangeToColorMapper.input.connectFrom(this.singleResponse.value);
            ColorMissingValueReplacement colorMissingValueReplacement = new ColorMissingValueReplacement();
            colorMissingValueReplacement.input.connectFrom((ColorPipe)continuousRangeToColorMapper);
            colorMissingValueReplacement.setReplacementValue(continuousRangeToColorMapper.getOutOfRangeColor());
            ColorMissingValueReplacement fillMapper = colorMissingValueReplacement;
            radar.fillColor.connectFrom((ColorPipe)fillMapper);
        } else if (this.subgroupVariable != null) {
            StringToColorMapper subgroupColorMapper = (StringToColorMapper)this.cellModel.getFillMapper();
            StringToColorMapper stringToFillColorMapper = new StringToColorMapper();
            stringToFillColorMapper.shareMap(subgroupColorMapper);
            stringToFillColorMapper.input.connectFrom(this.subgroupVariable.formattedValue);
            StringToColorMapper fillMapper = stringToFillColorMapper;
            radar.fillColor.connectFrom((ColorPipe)fillMapper);
            if (this.graphModel.isLineEnabled()) {
                StringToColorMapper lineColorMapper = (StringToColorMapper)this.cellModel.getLineColorMapper();
                StringToNumberMapper lineThicknessMapper = this.cellModel.getLineThicknessMapper();
                StringToNumberMapper lineStippleFactorMapper = this.cellModel.getLineStippleFactorMapper();
                StringToNumberMapper lineStipplePatternMapper = this.cellModel.getLineStipplePatternMapper();
                if (lineColorMapper != null) {
                    StringToColorMapper stringToLineColorMapper = new StringToColorMapper();
                    stringToLineColorMapper.shareMap(lineColorMapper);
                    stringToLineColorMapper.input.connectFrom(this.subgroupVariable.formattedValue);
                    radar.outlineColor.connectFrom((ColorPipe)stringToLineColorMapper);
                }
                if (lineThicknessMapper != null) {
                    radar.lineThickness.connectFrom((NumericPipe)RadarChartCell.newLocalFormattedStringToNumberMapper(lineThicknessMapper, this.subgroupVariable));
                }
                if (lineStippleFactorMapper != null) {
                    radar.lineStippleFactor.connectFrom((NumericPipe)RadarChartCell.newLocalFormattedStringToNumberMapper(lineStippleFactorMapper, this.subgroupVariable));
                }
                if (lineStipplePatternMapper != null) {
                    radar.lineStipplePattern.connectFrom((NumericPipe)RadarChartCell.newLocalFormattedStringToNumberMapper(lineStipplePatternMapper, this.subgroupVariable));
                }
            } else {
                radar.outlineColor.connectFrom((ColorPipe)fillMapper);
                radar.lineThickness.setValue(1.0);
            }
        } else {
            radar.fillColor.setValue(this.cellModel.getColorScheme()[0]);
            StrokeLineStyle lineStyle = this.graphModel.getDataElementStyles().getLineStyles()[0];
            if (this.graphModel.isLineEnabled() && lineStyle != null) {
                GTKUtil.LineAttributes lineAttributes = GTKUtil.getLineAttributes(lineStyle);
                radar.outlineColor.setValue(lineStyle.getColor());
                radar.lineThickness.setValue(lineStyle.getThickness().getMagnitude((Object)"px"));
                radar.lineStippleFactor.setValue((double)lineAttributes.stippleFactor);
                radar.lineStipplePattern.setValue((double)lineAttributes.stipplePattern);
            }
        }
        if (this.subgroupVariable != null) {
            radar.subgroup.connectFrom(this.subgroupVariable.formattedValue);
        }
        switch (this.radarType) {
            case 10902: 
            case 10903: {
                radar.setRadarType(0);
                radar.setFillPolygons(this.graphModel.isFillEnabled());
                break;
            }
            case 10904: {
                radar.setRadarType(1);
                radar.setSectorWidth(this.graphModel.getSectorWidth());
                break;
            }
            case 10900: 
            case 10901: {
                radar.setRadarType(2);
                radar.setInnerRadius(this.innerRadius);
                break;
            }
            case 10905: {
                radar.setRadarType(3);
                radar.setSectorWidth(this.graphModel.getSectorWidth());
                break;
            }
            case 10906: {
                radar.setRadarType(4);
                radar.setResponseRingFont(this.defaultAxisModel.getValueTextStyle().getFont());
                break;
            }
            case 10907: {
                radar.setRadarType(5);
                radar.setFillPolygons(this.graphModel.isFillEnabled());
            }
        }
        radar.category.connectFrom(this.categoryVariable.formattedValue);
        radar.response.connectFrom(this.singleResponse.value);
        radar.setStartAngle(angleStart);
        radar.setResponseMapper(this.responseMapper);
        radar.setRadius(this.radius);
        radar.setInnerRadius(this.innerRadius);
        this.selectEnable((Element)radar, -1, null);
        this.applySelection((Element)radar);
        return radar;
    }

    private static StringToNumberMapper newLocalFormattedStringToNumberMapper(StringToNumberMapper globalMapper, StringVariable variable) {
        StringToNumberMapper localMapper = new StringToNumberMapper();
        localMapper.shareMap(globalMapper);
        localMapper.input.connectFrom(variable.formattedValue);
        return localMapper;
    }

    private Composite createAxes() {
        Composite axes = new Composite();
        this.categoryVariable.getUniqueValueCount();
        this.axisMapper.init(new AInitAction());
        AxisStyle axisToLabel = null;
        double labelAxisAngle = Double.MAX_VALUE;
        for (int i = 0; i < this.categoryVariable.getUniqueValueCount(); ++i) {
            RectangularAxis axis = new RectangularAxis();
            AxisCellModel depAxis = (AxisCellModel)this.dependentAxisCellModelList.get(i);
            NumericMapper dependentAxisMapper = depAxis.getMapper();
            NumericPipe values = depAxis.getValues();
            StringPipe valueLabels = depAxis.getValueLabels();
            AxisStyle gtkAxisStyle = this.createGTKAxisStyle(this.defaultAxisModel);
            axis.labelColor.setValue(this.defaultAxisModel.getValueTextStyle().getColor());
            axis.setLength(this.radius);
            axis.setOrientation(1);
            axis.setFitAlgorithm(new String[]{"thin", "nolabels"});
            if (values != null) {
                axis.labelOffset.connectFrom(values);
            } else {
                axis.labelOffset.connectFrom(dependentAxisMapper.uniqueValue);
            }
            if (valueLabels != null) {
                axis.labels.connectFrom(valueLabels);
            } else {
                axis.labels.connectFrom(dependentAxisMapper.label);
            }
            double angle = 0.0;
            try {
                angle = this.axisMapper.uniqueValue.getValue(i);
                if (this.radarType == 10904 && !this.graphModel.isDrawSectorOnAxis()) {
                    angle += this.axisMapper.getStrideValue() / 2.0;
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            while (angle < 0.0) {
                angle = Math.PI * 2 + angle;
            }
            while (angle > Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            if (this.radarType == 10904 && this.graphModel.getAxisModel().getValueTextStyle().isVisible() && Math.abs(angle - 0.7853981633974483) < Math.abs(labelAxisAngle - 0.7853981633974483)) {
                labelAxisAngle = angle;
                axisToLabel = gtkAxisStyle;
            }
            axis.transform.rotationAxisZ.setValue(angle);
            axis.transform.rotationAngle.setValue(angle);
            int[] justifications = new int[2];
            this.getJustificationByAngle(angle, justifications);
            gtkAxisStyle.getLabelStyle().setHorizontalJustification(justifications[0]);
            gtkAxisStyle.getLabelStyle().setVerticalJustification(justifications[1]);
            axis.getStyle().getLabelStyle().setHorizontalJustification(i);
            axis.getStyle().getLabelStyle().setVerticalJustification(i);
            if (this.graphModel.isUniformAxes() && (this.radarType == 10904 || i > 0)) {
                gtkAxisStyle.setLabelsOn(false);
            }
            axis.setStyle(gtkAxisStyle);
            axes.addElement((Element)axis);
            axis.selectEnabled.setValue(false);
        }
        if (axisToLabel != null) {
            axisToLabel.setLabelsOn(true);
        }
        return axes;
    }

    private void selectEnable(Element element, int index, NumericVector overridenIndexes) {
        ArrayList<Integer> overridenIndexesList = null;
        if (overridenIndexes != null) {
            overridenIndexesList = new ArrayList<Integer>();
            for (int i = 0; i < overridenIndexes.getValueCount() - 1; ++i) {
                try {
                    overridenIndexesList.add(new Integer((int)overridenIndexes.getValue(i)));
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        int selectionOptions = 5;
        if (element instanceof Radar && this.selectionVariableArray != null && this.selectionVariableArray.length > 0) {
            selectionOptions |= 2;
        }
        Util.SelectInfo.selectEnable(element, (Variable)this.singleResponse, selectionOptions);
        ((Util.SelectInfo)element.getUserData()).userData = new Integer(index);
    }

    private void applySelection(Element element) {
        if (this.selectionVariableArray != null && this.selectionVariableArray.length > 0 && this.selectionVariableArray[0] instanceof NumericVariable) {
            NumericVariable selectionVariable = (NumericVariable)this.selectionVariableArray[0];
            if (element instanceof Radar) {
                Radar radar = (Radar)element;
                radar.highlightOn.connectFrom(selectionVariable.value);
                radar.highlightFillColor.setValue(this.graphModel.getBrushModel().getSelectionColor());
            }
        }
    }

    private AxisStyle createGTKAxisStyle(AxisModel model) {
        TextStyle ts;
        AxisStyle gtkAxisStyle = new AxisStyle();
        if (model.getAxisLineStyle() != null) {
            StrokeLineStyle ls = model.getAxisLineStyle();
            gtkAxisStyle.setAxisLineOn(ls.getVisibilityPolicy() != 10202);
            gtkAxisStyle.setAxisLineColor(ls.getColor());
            GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(ls);
            gtkAxisStyle.setLineWidth(gla.lineWidth);
            if (gla.stipplePattern != 0) {
                gtkAxisStyle.setLineStipple(gla.stipplePattern, gla.stippleFactor);
            }
            gtkAxisStyle.getMajorTickStyle().setColor(model.getMajorTickStyle().getLineStyle().getColor());
            gtkAxisStyle.getMinorTickStyle().setColor(model.getMinorTickStyle().getLineStyle().getColor());
        }
        if ((ts = model.getValueTextStyle()) != null) {
            gtkAxisStyle.setLabelsOn(ts.isVisible());
            gtkAxisStyle.getLabelStyle().setColor(ts.getColor());
            gtkAxisStyle.getLabelStyle().setFont(ts.getFont());
            gtkAxisStyle.getLabelStyle().setShadowColor(ts.getShadowStyle().getColor());
            gtkAxisStyle.getLabelStyle().setShadowOn(ts.getShadowStyle().isVisible());
            gtkAxisStyle.getLabelStyle().setShadowSoftness((float)ts.getShadowStyle().getSoftness());
            gtkAxisStyle.getLabelStyle().setShadowOffsetX((int)ts.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            gtkAxisStyle.getLabelStyle().setShadowOffsetY((int)ts.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
        }
        gtkAxisStyle.setLineWidth((int)model.getAxisLineStyle().getThickness().getMagnitude((Object)"px"));
        if (model.getContinuousMajorTickPositionPolicy() != 10701) {
            gtkAxisStyle.setShowThinnedTicks(false);
        }
        TickStyle tickStyle = model.getMajorTickStyle();
        gtkAxisStyle.getMajorTickStyle().setColor(tickStyle.getLineStyle().getColor());
        gtkAxisStyle.getMajorTickStyle().setLineWidth((int)tickStyle.getLineStyle().getThickness().getMagnitude((Object)"px"));
        gtkAxisStyle.setMajorTickMarksOn(tickStyle.getLineStyle().getVisibilityPolicy() != 10202);
        tickStyle = model.getMinorTickStyle();
        gtkAxisStyle.getMinorTickStyle().setColor(tickStyle.getLineStyle().getColor());
        gtkAxisStyle.getMinorTickStyle().setLineWidth((int)tickStyle.getLineStyle().getThickness().getMagnitude((Object)"px"));
        gtkAxisStyle.getMinorTickStyle().setMinorTickCount(model.getContinuousMinorTickCount());
        gtkAxisStyle.setMinorTickMarksOn(tickStyle.getLineStyle().getVisibilityPolicy() == 10201);
        return gtkAxisStyle;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.cellModel.getPreferredSize();
    }

    public Dimension getIndividualPreferredSize() {
        if (this.dataSource == null) {
            return super.getPreferredSize();
        }
        this.initVariables();
        if (this.cellModel == null || this.categoryVariable == null) {
            return super.getPreferredSize();
        }
        this.initDependentAxisMappers();
        Font labelFont = this.defaultAxisModel.getLabelTextStyle().getFont();
        if (this.dependentAxisCellModelList.size() > 0) {
            double axisLength = ((AxisCellModel)this.dependentAxisCellModelList.get(0)).getPreferredLength() + 4.0;
            double maxLabelSize = 1.0 * axisLength;
            double longestLabelWidth = 0.0;
            if (this.defaultAxisModel.getLabelTextStyle().isVisible() && this.defaultAxisModel.getLabelPlacementPolicy() != 11301) {
                longestLabelWidth = this.calculateLongestLabelWidth(labelFont, this.categoryVariable.formattedUniqueValue);
            }
            longestLabelWidth = Math.min(longestLabelWidth, maxLabelSize);
            int xPref = (int)((axisLength + longestLabelWidth + 4.0) * 2.0 + 0.5);
            int yPref = (int)((axisLength + 4.0) * 2.0 + 0.5);
            Channel channel = this.getChannel();
            if (channel != null) {
                channel.glSelect2DFont(labelFont);
                yPref = (int)((double)yPref + channel.glGetTextHeight() * 2.0);
            }
            this.initResponseMapper();
            if (this.isReferenceLabelsEnabled()) {
                this.initResponseMapper();
                yPref = (int)((double)yPref + this.createResponseScale().getPreferredMetrics(channel).getHeight());
            }
            return new Dimension(xPref + 5, yPref + 5);
        }
        return new Dimension(0, 0);
    }

    @Override
    public PickInfo[] select(int x, int y, int w, int h, boolean isControlDown, boolean isModified) {
        if (w == 1 && h == 1) {
            PickInfo[] pickInfoArray;
            PickInfo pickInfo = this.select(x, y, isControlDown);
            if (pickInfo != null) {
                PickInfo[] pickInfoArray2 = new PickInfo[1];
                pickInfoArray = pickInfoArray2;
                pickInfoArray2[0] = pickInfo;
            } else {
                pickInfoArray = null;
            }
            return pickInfoArray;
        }
        return super.select(x, y, w, h, isControlDown, isModified);
    }

    @Override
    protected Util.SelectInfo getSelectInfo(SelectResult sr) {
        Util.SelectInfo selectInfo = new Util.SelectInfo();
        Util.SelectInfo superInfo = super.getSelectInfo(sr);
        if (sr != null) {
            SelectDetail sd;
            if (superInfo != null) {
                selectInfo.userData = superInfo.userData;
                selectInfo.variableName = superInfo.variableName;
                selectInfo.variableNames = superInfo.variableNames;
                selectInfo.variant = superInfo.variant;
            }
            if ((sd = sr.getDetail()) instanceof RadarSelectDetail) {
                RadarSelectDetail rsd = (RadarSelectDetail)sd;
                selectInfo.overridenIndices = rsd.getAllIndices();
            }
            return selectInfo;
        }
        return superInfo;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return new PickInfo(this.getLabelValuePairs(obsIndex, false), obsIndex, this.getDataSource().getModel(), x, y, null);
    }

    public PickInfo createPickInfo(int x, int y, int obsIndex, boolean subgroupOnly) {
        return new PickInfo(this.getLabelValuePairs(obsIndex, subgroupOnly), obsIndex, this.getDataSource().getModel(), x, y, null);
    }

    @Override
    public PickInfo createPickInfo(int x, int y, SelectResult sr) {
        SelectDetail sd;
        PickInfo pi = null;
        super.createPickInfo(x, y, sr);
        if (sr != null && (sd = sr.getDetail()) instanceof RadarSelectDetail) {
            RadarSelectDetail rsd = (RadarSelectDetail)sd;
            if (rsd.getDetailType() == 1) {
                pi = this.createPickInfo(x, y, rsd.getValueIndex(), false);
            } else if (rsd.getDetailType() == 2) {
                int obsIndex = rsd.getValueIndex();
                Vector labelValuePairs = GTKUtil.PickInfoAccess.addLabelValuePairs(null, this.cellModel.getSubgroupRole(), (Variable)this.subgroupVariable, obsIndex, true);
                pi = new PickInfo(new Vector[]{labelValuePairs}, rsd.getValueIndex(), this.getDataSource().getModel(), x, y, null);
            }
        }
        return pi;
    }

    private Vector[] getLabelValuePairs(int obsIndex, boolean subgroupOnly) {
        boolean graphDataIsVisible;
        Vector labelValuePairs = new Vector();
        Object categoryRole = this.cellModel.getCategoryRole();
        Object responseRole = this.cellModel.getResponseRole();
        Object subgroupRole = this.cellModel.getSubgroupRole();
        boolean bl = graphDataIsVisible = this.dataTipVariableArray == null || this.dataTipVariableArray.length <= 0 || this.dataTipVariableArray[0] == null || this.graphModel.getDataTipModel().getContent() != 11401;
        if (!subgroupOnly) {
            GTKUtil.PickInfoAccess.addLabelValuePairs_NumericOnly(labelValuePairs, responseRole, this.responseVariableArray, obsIndex, graphDataIsVisible);
            GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, categoryRole, (Variable)this.categoryVariable, obsIndex, graphDataIsVisible);
        }
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, subgroupRole, (Variable)this.subgroupVariable, obsIndex, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getDataTipRole(), this.dataTipVariableArray, obsIndex, true);
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, this.cellModel.getAuxiliaryRole(), this.auxiliaryVariableArray, obsIndex, false);
        return new Vector[]{labelValuePairs};
    }

    private Composite createLabels() {
        Composite labels = new Composite();
        Font styleLabelFont = this.defaultAxisModel.getLabelTextStyle().getFont();
        Rectangle bounds = this.getBounds();
        RasterLabel axisLabels = new RasterLabel();
        axisLabels.trimOn.setValue(true);
        if (this.defaultAxisModel.getLabel() == null) {
            this.labelVector = new StringVector();
            for (int i = 0; i < this.categoryVariable.getUniqueValueCount(); ++i) {
                String titleAddition = ((AxisCellModel)this.dependentAxisCellModelList.get(i)).getTitleAddition();
                titleAddition = titleAddition == null || this.graphModel.isUniformAxes() && i != 0 ? "" : " " + titleAddition;
                try {
                    this.labelVector.addValue(this.categoryVariable.formattedUniqueValue.getValue(i) + titleAddition);
                    continue;
                }
                catch (MissingValueException e) {
                    this.labelVector.addValue(e.getMissingValue().toString() + titleAddition);
                }
            }
            axisLabels.string.connectFrom((StringPipe)this.labelVector);
        } else {
            axisLabels.string.setValue(this.defaultAxisModel.getLabel());
        }
        boolean labelsFit = this.shrinkLabels(styleLabelFont, axisLabels, bounds);
        if (!labelsFit) {
            labelsFit = this.truncateAndShrinkLabels(styleLabelFont, axisLabels, bounds);
        }
        if (labelsFit) {
            TextStyle ts = this.defaultAxisModel.getLabelTextStyle();
            axisLabels.shadowColor.setValue(ts.getShadowStyle().getColor());
            axisLabels.shadowOffsetX.setValue((int)ts.getShadowStyle().getOffsetX().getMagnitude((Object)"px"));
            axisLabels.shadowOffsetY.setValue((int)ts.getShadowStyle().getOffsetY().getMagnitude((Object)"px"));
            axisLabels.shadowOn.setValue(ts.getShadowStyle().isVisible());
            labels.addElement((Element)axisLabels);
        } else {
            this.radius = (double)Math.min(bounds.width / 2, bounds.height / 2) - 8.0;
            if (this.defaultAxisModel.getStartOffset() == null || this.innerRadius >= this.radius) {
                this.calculateInnerRadius();
            }
        }
        return labels;
    }

    private boolean shrinkLabels(Font labelFont, RasterLabel axisLabels, Rectangle bounds) {
        boolean labelsFit = false;
        while (!labelsFit && labelFont.getSize() > 8) {
            this.radius = this.calculateRadius(labelFont, (StringPipe)axisLabels.string);
            if (this.defaultAxisModel.getStartOffset() == null || this.innerRadius >= this.radius) {
                this.calculateInnerRadius();
            }
            if (this.radarType == 10900) {
                this.innerRadius = 0.0;
            }
            this.xPosCalc.inB.setValue(this.radius + 4.0);
            this.yPosCalc.inB.setValue(this.radius + 4.0);
            this.xPosCalc.inA.connectFrom(this.axisMapper.uniqueValue);
            this.yPosCalc.inA.connectFrom(this.axisMapper.uniqueValue);
            axisLabels.transform.translateX.connectFrom(this.xPosCalc.value);
            axisLabels.transform.translateY.connectFrom(this.yPosCalc.value);
            axisLabels.transform.translateZ.setValue(0.0);
            AngleToJustification hJustification = new AngleToJustification(0, this.defaultAxisModel.getLabelPlacementPolicy() == 11301);
            AngleToJustification vJustification = new AngleToJustification(1, this.defaultAxisModel.getLabelPlacementPolicy() == 11301);
            hJustification.input.connectFrom(this.axisMapper.uniqueValue);
            vJustification.input.connectFrom(this.axisMapper.uniqueValue);
            axisLabels.horizontalJustification.connectFrom(hJustification.value);
            axisLabels.verticalJustification.connectFrom(vJustification.value);
            TextStyle ts = this.defaultAxisModel.getLabelTextStyle();
            if (ts != null) {
                axisLabels.color.setValue(ts.getColor());
            }
            axisLabels.setFont(labelFont);
            axisLabels.init(new AInitAction());
            labelsFit = this.doLabelsFit(axisLabels, labelFont, bounds);
            if (labelsFit) continue;
            labelFont = FontManager.getFont((String)labelFont.getFamily(), (int)labelFont.getStyle(), (int)(labelFont.getSize() - 1));
            axisLabels.setFont(labelFont);
        }
        return labelsFit;
    }

    private boolean truncateAndShrinkLabels(Font labelFont, RasterLabel axisLabels, Rectangle bounds) {
        this.truncate(axisLabels);
        return this.shrinkLabels(labelFont, axisLabels, bounds);
    }

    void truncate(RasterLabel axisLabels) {
        StringVector truncatedLabels = new StringVector();
        if (this.defaultAxisModel.getLabel() == null) {
            for (int i = 0; i < this.labelVector.getValueCount(); ++i) {
                try {
                    String label = this.labelVector.getValue(i);
                    if (label.length() > 6) {
                        label = label.substring(0, 3) + "...";
                    }
                    truncatedLabels.addValue(label);
                    continue;
                }
                catch (MissingValueException e) {
                    truncatedLabels.addValue(e.getMissingValue());
                }
            }
            if (axisLabels != null) {
                axisLabels.string.connectFrom((StringPipe)truncatedLabels);
            }
        } else {
            String label = this.defaultAxisModel.getLabel();
            if (label.length() > 6) {
                label = label.substring(0, 3) + "...";
                if (axisLabels != null) {
                    axisLabels.string.setValue(label);
                }
            }
            truncatedLabels.addValue(label);
        }
    }

    private Composite createReferenceCircles() {
        Composite circles = new Composite();
        Color axisColor = this.defaultAxisModel.getAxisLineStyle().getColor();
        ReferenceLineModel[] referenceCircleModels = this.graphModel.getAxisModel().getReferenceLineModels();
        for (int num = 0; num < referenceCircleModels.length; ++num) {
            double rad;
            if (!referenceCircleModels[num].isVisible() || referenceCircleModels[num].getLineStyle() != null && referenceCircleModels[num].getLineStyle().getVisibilityPolicy() == 10202 || (rad = referenceCircleModels[num].getPosition()) < 0.0 || rad > 1.0) continue;
            Circle2 circle = new Circle2();
            circle.radius.setValue(rad * (this.radius - this.innerRadius) + this.innerRadius);
            circle.precision.setValue(180);
            circle.edgeColor.setValue(Color.black);
            circle.fillOn.setValue(false);
            circle.edgeOn.setValue(true);
            StrokeLineStyle lineStyle = referenceCircleModels[num].getLineStyle();
            if (lineStyle != null) {
                circle.color.setValue(lineStyle.getColor());
            } else {
                circle.color.setValue(axisColor);
            }
            circle.selectEnabled.setValue(false);
            circles.addElement((Element)circle);
        }
        return circles;
    }

    private Composite createGridLines() {
        int i;
        Composite gridLines = new Composite();
        int numLines = 5;
        int inc = (int)((this.radius - this.innerRadius) / (double)numLines);
        StrokeLineStyle gridStyle = this.defaultAxisModel.getGridLineStyle();
        Calculator[] xCalc = new Calculator[numLines];
        Calculator[] yCalc = new Calculator[numLines];
        GTKUtil.LineAttributes gla = GTKUtil.getLineAttributes(gridStyle);
        for (i = 0; i < numLines; ++i) {
            xCalc[i] = new Calculator("(cos(inA) * inB)");
            yCalc[i] = new Calculator("(sin(inA) * inB)");
            xCalc[i].inB.setValue(this.innerRadius + (double)(inc * (i + 1)));
            yCalc[i].inB.setValue(this.innerRadius + (double)(inc * (i + 1)));
            xCalc[i].inA.connectFrom(this.axisMapper.uniqueValue);
            yCalc[i].inA.connectFrom(this.axisMapper.uniqueValue);
        }
        for (i = 0; i < numLines; ++i) {
            try {
                for (int j = 0; j < this.axisMapper.getUniqueValueCount() - 1; ++j) {
                    LineSegment line = new LineSegment();
                    line.beginX.setValue(xCalc[i].getValue(j));
                    line.beginY.setValue(yCalc[i].getValue(j));
                    line.endX.setValue(xCalc[i].getValue(j + 1));
                    line.endY.setValue(yCalc[i].getValue(j + 1));
                    line.color.setValue(gridStyle.getColor());
                    line.lineWidth.setValue((double)gla.lineWidth);
                    line.setStipple(gla.stipplePattern, gla.stippleFactor);
                    gridLines.addElement((Element)line);
                }
                LineSegment lastLine = new LineSegment();
                lastLine.beginX.setValue(xCalc[i].getValue(0));
                lastLine.beginY.setValue(yCalc[i].getValue(0));
                lastLine.endX.setValue(xCalc[i].getValue(this.axisMapper.getUniqueValueCount() - 1));
                lastLine.endY.setValue(yCalc[i].getValue(this.axisMapper.getUniqueValueCount() - 1));
                lastLine.color.setValue(gridStyle.getColor());
                lastLine.lineWidth.setValue((double)gla.lineWidth);
                lastLine.setStipple(gla.stipplePattern, gla.stippleFactor);
                gridLines.addElement((Element)lastLine);
                continue;
            }
            catch (MissingValueException mve) {
                return new Composite();
            }
        }
        return gridLines;
    }

    private RectangularAxis createResponseScale() {
        Channel channel = this.getChannel();
        StringVector labels = new StringVector();
        NumericVector positions = new NumericVector();
        ReferenceLineModel[] referenceCircleModels = this.graphModel.getAxisModel().getReferenceLineModels();
        for (int i = 0; i < referenceCircleModels.length; ++i) {
            AdvancedTextStyle textStyle = referenceCircleModels[i].getTextStyle();
            if (textStyle != null && !textStyle.isVisible()) continue;
            if (referenceCircleModels[i].getLabel() != null) {
                labels.addValue(referenceCircleModels[i].getLabel());
            } else {
                double label = referenceCircleModels[i].getPosition() * this.responseMapper[0].getInputMax();
                labels.addValue(this.singleResponse.getFormatter().format((Object)new Double(label)));
            }
            positions.addValue(referenceCircleModels[i].getPosition() * (this.radius - this.innerRadius) + this.innerRadius);
        }
        RectangularAxis responseScale = new RectangularAxis();
        responseScale.labelOffset.connectFrom((NumericPipe)positions);
        responseScale.labels.connectFrom((StringPipe)labels);
        responseScale.setFitAlgorithm(CONT_FIT_BEST_ALG);
        responseScale.getStyle().setAxisLineOn(false);
        responseScale.getStyle().getLabelStyle().setFont(this.defaultAxisModel.getValueTextStyle().getFont());
        channel.glSelect2DFont(this.defaultAxisModel.getLabelTextStyle().getFont());
        double translateY = this.radius + channel.glGetTextHeight() + 4.0;
        responseScale.transform.translateY.setValue(-translateY);
        return responseScale;
    }

    private void getJustificationByAngle(double angle, int[] justifications) {
        int i;
        double offset = angle % (Math.PI * 2);
        if (offset < 0.0) {
            offset += Math.PI * 2;
        }
        for (i = 0; i < ranges.length && offset > ranges[i]; ++i) {
        }
        justifications[0] = hJustification[i];
        justifications[1] = vJustification[i];
    }

    private double calculateLongestLabelWidth(Font labelFont, StringPipe strings) {
        this.categoryVariable = (StringVariable)this.dataSource.getVariable(this.cellModel.getCategoryRole(), 0);
        if (this.categoryVariable == null) {
            return 0.0;
        }
        int valueCount = this.categoryVariable.getValueCount();
        String curLabel = "";
        Channel channel = this.getChannel();
        double longestLabelWidth = 0.0;
        if (channel != null) {
            if (labelFont != null) {
                channel.glSelect2DFont(labelFont);
            }
            for (int zz = 0; zz < valueCount; ++zz) {
                try {
                    curLabel = strings.getValue(zz).trim();
                }
                catch (MissingValueException e) {
                    curLabel = ValueMap.getDefaultMissingValueLabel((MissingValues)e.getMissingValue());
                }
                longestLabelWidth = Math.max(longestLabelWidth, channel.glGetTextWidth(curLabel));
            }
        }
        return longestLabelWidth;
    }

    private double calculateRadius(Font labelFont, StringPipe strings) {
        Channel channel = this.getChannel();
        Rectangle bounds = this.getBounds();
        int longestLabelWidth = 0;
        double textHeight = 0.0;
        int maxLabelWidth = (int)(bounds.getWidth() * 0.25);
        int maxLabelHeight = (int)(bounds.getHeight() * 0.25);
        if (this.defaultAxisModel.getLabelTextStyle().isVisible()) {
            longestLabelWidth = this.defaultAxisModel.getLabelPlacementPolicy() == 11301 || !this.defaultAxisModel.getLabelTextStyle().isVisible() ? 0 : (int)this.calculateLongestLabelWidth(labelFont, strings);
            longestLabelWidth = Math.min(longestLabelWidth, maxLabelWidth);
            textHeight = Math.min(channel.glGetTextHeight(), (double)maxLabelHeight);
        }
        double responseScaleHeight = 0.0;
        if (this.isReferenceLabelsEnabled()) {
            this.initResponseMapper();
            RectangularAxis responseScale = this.createResponseScale();
            responseScaleHeight = responseScale.getPreferredMetrics(channel).getHeight();
        }
        this.radius = Math.min((double)bounds.width / 2.0 - (double)longestLabelWidth - 8.0, (double)bounds.height / 2.0 - textHeight - responseScaleHeight - 8.0);
        return this.radius;
    }

    private void calculateInnerRadius() {
        this.innerRadius = this.radarType == 10906 ? this.radius * 0.2 : (this.radarType != 10900 && this.radarType != 10904 && this.radarType != 10905 ? this.radius * 0.3333333333333333 : 0.0);
    }

    private boolean doLabelsFit(RasterLabel axisLabels, Font labelFont, Rectangle bounds) {
        boolean labelsFit = true;
        for (int i = 1; i < this.axisMapper.getUniqueValueCount() && labelsFit; ++i) {
            ComputeBoundingBoxAction ia1 = new ComputeBoundingBoxAction(this.getChannel());
            ComputeBoundingBoxAction ia2 = new ComputeBoundingBoxAction(this.getChannel());
            ia1.setValueIndex(i - 1);
            ia2.setValueIndex(i);
            try {
                axisLabels.getBoundingBox((AComputeBoundingBoxAction)ia1);
                axisLabels.getBoundingBox((AComputeBoundingBoxAction)ia2);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            BoundingBox bbox1 = new BoundingBox(ia1.getElementBoundingBox());
            BoundingBox bbox2 = new BoundingBox(ia2.getElementBoundingBox());
            Vec3d size = bbox1.getSize();
            size.x += 2.0;
            size.y += 2.0;
            bbox1.setSize(size);
            try {
                bbox1.setCenter(this.xPosCalc.value.getValue(i - 1), this.yPosCalc.value.getValue(i - 1), 0.0);
                bbox2.setCenter(this.xPosCalc.value.getValue(i), this.yPosCalc.value.getValue(i), 0.0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            bbox1.intersection(bbox2);
            if (bbox1.isEmpty() && !(bbox2.getSize().x > ((double)bounds.width - 8.0) * 0.25)) continue;
            labelsFit = false;
        }
        return labelsFit;
    }

    public int getCategoryUniqueValueCount() {
        return this.categoryVariable.getUniqueValueCount();
    }

    public double getResponseAxisRangeMax(String category) {
        double max = 0.0;
        for (int i = 0; i < this.singleResponse.getValueCount(); ++i) {
            String currentCategory;
            try {
                currentCategory = this.categoryVariable.formattedValue.getValue(i);
            }
            catch (MissingValueException e) {
                currentCategory = e.getMissingValue().toString();
            }
            if (category != null && !currentCategory.equals(category)) continue;
            try {
                if (this.radarType == 10904 || this.radarType == 10905) {
                    max += this.singleResponse.value.getValue(i);
                    continue;
                }
                max = Math.max(max, this.singleResponse.value.getValue(i));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return max;
    }

    private boolean isReferenceLabelsEnabled() {
        ReferenceLineModel[] referenceCircleModels = this.graphModel.getAxisModel().getReferenceLineModels();
        if (referenceCircleModels != null && this.graphModel.isUniformAxes() && this.radarType != 10906) {
            for (int i = 0; i < referenceCircleModels.length; ++i) {
                if (!referenceCircleModels[i].isVisible()) continue;
                return true;
            }
        }
        return false;
    }
}

