/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.radarchart;

import com.sas.graphics.util.cell.radarchart.RadarElement;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.gl.Composite;
import java.awt.Font;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Radar
extends Composite {
    public static final int RADAR_TYPE_POLYGON = 0;
    public static final int RADAR_TYPE_SECTOR = 1;
    public static final int RADAR_TYPE_SPOKE = 2;
    public static final int RADAR_TYPE_CHORD = 3;
    public static final int RADAR_TYPE_CALENDAR = 4;
    public static final int RADAR_TYPE_CORONA = 5;
    public final StringProperty category;
    public final StringProperty subgroup;
    public final NumericProperty response;
    public final ColorProperty fillColor;
    public final ColorProperty outlineColor;
    public final NumericProperty lineThickness;
    public final NumericProperty lineStippleFactor;
    public final NumericProperty lineStipplePattern;
    public final BooleanProperty highlightOn;
    public final ColorProperty highlightFillColor;
    protected List categories = new ArrayList();
    protected List subgroups = new ArrayList();
    protected Map angles;
    protected Map startRadiusMap;
    protected double stride;
    protected double startAngle;
    private RadarElement radarElement = new RadarElement(this);

    public Radar() {
        this.category = this.radarElement.category;
        this.subgroup = this.radarElement.subgroup;
        this.response = this.radarElement.response;
        this.fillColor = this.radarElement.fillColor;
        this.outlineColor = this.radarElement.outlineColor;
        this.lineThickness = this.radarElement.lineThickness;
        this.lineStippleFactor = this.radarElement.lineStippleFactor;
        this.lineStipplePattern = this.radarElement.lineStipplePattern;
        this.highlightOn = this.radarElement.highlightOn;
        this.highlightFillColor = this.radarElement.highlightFillColor;
        this.radarElement.selectEnabled.connectFrom((BooleanPipe)this.selectEnabled);
        this.radarElement.selectDetailEnabled.connectFrom((BooleanPipe)this.selectDetailEnabled);
        this.addElement(this.radarElement);
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        int i;
        this.categories = new ArrayList();
        this.subgroups = new ArrayList();
        for (i = 0; i < this.radarElement.myValueCount; ++i) {
            String categoryValue = Radar.getValueReplaceMissing(this.category, i);
            String subgroupValue = Radar.getValueReplaceMissing(this.subgroup, i);
            if (!this.categories.contains(categoryValue)) {
                this.categories.add(categoryValue);
            }
            if (this.subgroups.contains(subgroupValue)) continue;
            this.subgroups.add(subgroupValue);
        }
        this.stride = 360.0 / (double)this.categories.size();
        double angle = this.startAngle;
        this.angles = new LinkedHashMap();
        this.startRadiusMap = new LinkedHashMap();
        for (i = 0; i < this.categories.size(); ++i) {
            while (angle < 0.0) {
                angle += 360.0;
            }
            while (angle > 360.0) {
                angle -= 360.0;
            }
            this.angles.put(this.categories.get(i), new Double(angle));
            angle -= this.stride;
            this.startRadiusMap.put(this.categories.get(i), new Double(0.0));
        }
        super.render(buildAction);
    }

    protected static String getValueReplaceMissing(StringProperty stringProperty, int index) {
        String string;
        try {
            string = stringProperty.getValue(index);
        }
        catch (MissingValueException e) {
            string = e.getMissingValue().toString();
        }
        return string;
    }

    public void setFillPolygons(boolean fillPolygons) {
        this.radarElement.fillPolygons = fillPolygons;
    }

    public void setInnerRadius(double innerRadius) {
        this.radarElement.innerRadius = innerRadius;
    }

    public void setRadarType(int radarType) {
        this.radarElement.radarType = radarType;
    }

    public void setRadius(double radius) {
        this.radarElement.radius = radius;
    }

    public void setResponseMapper(ContinuousRangeToNumericMapper[] responseMapper) {
        this.radarElement.responseMapper = responseMapper;
    }

    public void setResponseRingFont(Font responseRingFont) {
        this.radarElement.responseRingFont = responseRingFont;
    }

    public void setSectorWidth(double sectorWidth) {
        this.radarElement.sectorWidth = sectorWidth;
    }

    public void setStartAngle(double startAngle) {
        this.startAngle = startAngle;
    }

    public void setUserData(Object o) {
        super.setUserData(o);
        this.radarElement.setUserData(o);
    }
}

