/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.radarchart;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ALabel;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;

class AngleToJustification
extends PropertyContainer
implements IntegerPipe {
    public static final int HORIZONTAL_JUSTIFICATION = 0;
    public static final int VERTICAL_JUSTIFICATION = 1;
    private int justification = 0;
    private boolean inside;
    public final NumericProperty input = new NumericProperty((PropertyContainer)this, true);
    public final IntegerPipe value = this;
    private static double[] ranges = new double[]{0.39269908169872414, 1.1780972450961724, 1.9634954084936207, 2.748893571891069, 3.5342917352885173, 4.319689898685965, 5.105088062083414, 5.890486225480862, 6.675884388878311};
    private static int[] hJustification = new int[]{2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 2, 1, 2};
    private static int[] vJustification = new int[]{3, 0, 0, 0, 0, 3, 3, 3, 1, 1, 3, 3, 3};

    public AngleToJustification() {
        this(0);
    }

    public AngleToJustification(int justification) {
        this(justification, false);
    }

    public AngleToJustification(int justification, boolean inside) {
        this.justification = justification;
        this.inside = inside;
    }

    public void init(AInitAction initAction) {
        super.init(initAction);
    }

    public void setJustification(int newJustification) {
        this.justification = newJustification;
    }

    public int getValue(int i) throws MissingValueException {
        int[] justifications = new int[2];
        double angle = this.input.getValue(i);
        if (this.inside) {
            AngleToJustification.getJustificationByAngle(angle, justifications);
            return justifications[this.justification];
        }
        ALabel.getJustificationByAngle((double)angle, (int[])justifications);
        return justifications[this.justification];
    }

    public static void getJustificationByAngle(double angle, int[] justifications) {
        int i;
        double offset = angle % (Math.PI * 2);
        if (offset < 0.0) {
            offset += Math.PI * 2;
        }
        for (i = 0; i < ranges.length && offset > ranges[i]; ++i) {
        }
        justifications[0] = hJustification[i];
        justifications[1] = vJustification[i];
    }
}

