/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.piechart;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.MessageModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.piechart.PieChartModel;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.GridDimension;
import com.sas.graphics.util.cell.HierarchicalPane;
import com.sas.graphics.util.cell.LabelPane;
import com.sas.graphics.util.cell.MatrixContainer2;
import com.sas.graphics.util.cell.StringComponent;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValuePane;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.cell.piechart.PieChartCell;
import com.sas.graphics.util.cell.piechart.PieChartMatrixModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;

public class PieChartMatrixContainer
extends MatrixContainer2 {
    private final transient ValueTree columnTree;
    private final transient ValueTree rowTree;
    private final transient boolean rowIsEast;
    private final transient CellPane cellPane;
    private final transient ValuePane columnMatrixAxisValuePane;
    private final transient LabelPane columnMatrixAxisLabelPane;
    private final transient ValuePane rowMatrixAxisValuePane;
    private final transient LabelPane rowMatrixAxisLabelPane;
    private final transient LabelPane responseLabelPane;
    private final transient JComponent messagesComponent;
    private transient LayoutCache layoutCache;

    public PieChartMatrixContainer(PieChartMatrixModel pieChartMatrixModel, DataSource dataSource, ValueTree columnTree, ValueTree rowTree, CellPane.CellComponentFactory pieChartCellFactory, MessageModel messageModel, SwingActionProvider actionProvider, boolean rowIsEast, boolean isAntiAliasingEnabled, boolean isTextAntiAliasingEnabled, Channel channel) {
        super(isAntiAliasingEnabled, isTextAntiAliasingEnabled, channel);
        this.setLayout(null);
        this.setOpaque(false);
        this.columnTree = columnTree;
        this.rowTree = rowTree;
        this.rowIsEast = rowIsEast;
        if (pieChartMatrixModel == null || dataSource == null || columnTree == null || rowTree == null || pieChartCellFactory == null) {
            throw new IllegalStateException("required parameter is null");
        }
        LineStyle frameLineStyle = null;
        PieChartModel pieChartModel = pieChartMatrixModel.getPieChartModel();
        if (pieChartModel != null) {
            frameLineStyle = pieChartModel.getFrameLineStyle();
        }
        this.cellPane = new CellPane(columnTree, rowTree, pieChartCellFactory, frameLineStyle, channel);
        GraphMatrixAxisModel axisModel = pieChartMatrixModel.getPieChartModel().getColumnAxisModel();
        HierarchicalPane[] cmap = Util.newMatrixAxisPanes(columnTree, axisModel, dataSource.getDataSourceSelectionModel(), actionProvider, channel);
        this.columnMatrixAxisLabelPane = (LabelPane)cmap[0];
        this.columnMatrixAxisValuePane = (ValuePane)cmap[1];
        axisModel = pieChartMatrixModel.getPieChartModel().getRowAxisModel();
        HierarchicalPane[] rmap = Util.newMatrixAxisPanes(rowTree, axisModel, dataSource.getDataSourceSelectionModel(), actionProvider, channel);
        this.rowMatrixAxisLabelPane = (LabelPane)rmap[0];
        this.rowMatrixAxisValuePane = (ValuePane)rmap[1];
        Variable[] labelVariables = dataSource.getVariable(pieChartMatrixModel.getResponseRole());
        if (labelVariables != null && labelVariables.length == 1) {
            AdvancedTextStyle labelTextStyle = pieChartMatrixModel.getPieChartModel().getResponseLabelTextStyle();
            this.responseLabelPane = pieChartMatrixModel.getPieChartModel().getResponseLabelVisiblePolicy() != 10202 && labelTextStyle.isVisible() ? new LabelPane(labelVariables, (TextStyle)labelTextStyle, channel) : null;
        } else {
            this.responseLabelPane = null;
        }
        this.messagesComponent = Util.Message.createMessageComponent(messageModel, channel);
        this.add((Component)this.messagesComponent, (Object)"message");
        this.add(this.columnMatrixAxisValuePane, "ColumnMatrixAxisValuePane");
        this.add(this.columnMatrixAxisLabelPane, "ColumnMatrixAxisLabelPane");
        this.add(this.rowMatrixAxisValuePane, "RowMatrixAxisValuePane");
        this.add(this.rowMatrixAxisLabelPane, "RowMatrixAxisLabelPane");
        this.add(this.responseLabelPane, "ResponseLabelPane");
        this.add(this.cellPane, "MatrixCellPane");
    }

    @Override
    public void dispose() {
        this.removeAll();
    }

    @Override
    public void removeAll() {
        this.disposeOfCells();
        super.removeAll();
    }

    private void disposeOfCells() {
        if (this.cellPane != null) {
            this.cellPane.dispose();
        }
    }

    @Override
    public Component getBrushableComponent() {
        if (this.cellPane != null) {
            return this.cellPane;
        }
        return this;
    }

    @Override
    public Component[] getMatrixCellComponents() {
        if (this.cellPane == null) {
            return new JComponent[0];
        }
        return this.cellPane.getContentPanelComponents();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.layoutCache == null) {
            this.layoutCache = new LayoutCache();
        }
        return this.layoutCache.getPreferredSize();
    }

    private int _computeCellWidth(Rectangle r, GridDimension cmalps, GridDimension rmaps, GridDimension rmalps, int columnLeafCount) {
        int westWidth = 0;
        int eastWidth = 0;
        int rmaps_prefWidth = 0;
        int i1 = rmaps.getGridSize().width;
        for (int i = 0; i < i1; ++i) {
            rmaps_prefWidth += Math.max(rmaps.getColWidth(i), rmalps.getColWidth(i));
        }
        if (this.rowIsEast) {
            eastWidth += Math.max(rmaps_prefWidth, cmalps.width);
        } else {
            westWidth += Math.max(rmaps_prefWidth, cmalps.width);
        }
        return (r.width - (westWidth + eastWidth)) / columnLeafCount;
    }

    private int _computeCellHeight(Rectangle r, GridDimension cmaps, GridDimension cmalps, GridDimension rmalps, Dimension rlps, int rowLeafCount) {
        int cmaps_prefHeight = 0;
        int i1 = cmaps.getGridSize().height;
        for (int i = 0; i < i1; ++i) {
            cmaps_prefHeight += Math.max(cmaps.getRowHeight(i), cmalps.getRowHeight(i));
        }
        int northHeight = Math.max(rmalps.height, rlps.height);
        int southHeight = cmaps_prefHeight;
        return (r.height - (southHeight + northHeight)) / rowLeafCount;
    }

    @Override
    public void layout() {
        int maxMatrixWidth;
        int minCellWidth;
        Rectangle b = this.getBounds();
        Insets i = this.getInsets();
        Rectangle r = new Rectangle(i.left, i.top, b.width - (i.left + i.right), b.height - (i.top + i.bottom));
        if (this.layoutCache == null) {
            this.layoutCache = new LayoutCache();
        }
        int columnLeafCount = this.layoutCache.getColumnLeafCount();
        int rowLeafCount = this.layoutCache.getRowLeafCount();
        int responseLevelCount = this.layoutCache.getResponseLevelCount();
        Dimension minimumCellSize = this.layoutCache.getMinimumCellSize();
        if (b.width <= 0 || b.height <= 0) {
            this.disablePanes("InsufficientDisplaySpace.ex.txt");
            return;
        }
        if (this.layoutCache.getCategoryCount() == 0) {
            this.disablePanes("BlankMessage.txt");
            return;
        }
        Dimension mps = this.layoutCache.getMatrixPreferredSize();
        GridDimension cmaps = this.layoutCache.getColumnMatrixAxisPreferredSize();
        GridDimension cmalps = this.layoutCache.getColumnMatrixAxisLabelPreferredSize();
        GridDimension rmaps = this.layoutCache.getRowMatrixAxisPreferredSize();
        GridDimension rmalps = this.layoutCache.getRowMatrixAxisLabelPreferredSize();
        Dimension rlps = this.layoutCache.getResponseLabelPreferredSize();
        AlignableComponentConstraints mc = new AlignableComponentConstraints();
        AlignableComponentConstraints cmac = new AlignableComponentConstraints();
        AlignableComponentConstraints cmalc = new AlignableComponentConstraints();
        AlignableComponentConstraints rmac = new AlignableComponentConstraints();
        AlignableComponentConstraints rmalc = new AlignableComponentConstraints();
        AlignableComponentConstraints rlc = new AlignableComponentConstraints();
        Rectangle mb = mc.getBounds();
        Rectangle cmab = cmac.getBounds();
        Rectangle cmalb = cmalc.getBounds();
        Rectangle rmab = rmac.getBounds();
        Rectangle rmalb = rmalc.getBounds();
        Rectangle rlb = rlc.getBounds();
        int cellWidth = this._computeCellWidth(r, cmalps, rmaps, rmalps, columnLeafCount);
        if (cellWidth < (minCellWidth = Math.max((int)((double)((maxMatrixWidth = Math.max(cmaps.width, mps.width)) / columnLeafCount) * 0.2), minimumCellSize.width))) {
            if (rmaps.width > 0 && rmalps.width > rmaps.width) {
                rmalps.width = rmaps.width;
            }
            if (rmaps.width > 0 && cmalps.width > rmaps.width) {
                cmalps.width = rmaps.width;
            }
            if ((cellWidth = this._computeCellWidth(r, cmalps, rmaps, rmalps, columnLeafCount)) < (minCellWidth = minimumCellSize.width)) {
                cmalps.height = 0;
                cmalps.width = 0;
                rmalps.height = 0;
                rmalps.width = 0;
                rmaps.height = 0;
                rmaps.width = 0;
                cellWidth = this._computeCellWidth(r, cmalps, rmaps, rmalps, columnLeafCount);
                if (cellWidth < minimumCellSize.width) {
                    this.disablePanes("InsufficientDisplaySpace.ex.txt");
                    return;
                }
            }
        }
        GridDimension.mergeWidths(rmalps, rmaps);
        cmaps.setColWidth(0, cellWidth);
        this._applyAutomaticJustification(this.rowIsEast);
        int cellHeight = this._computeCellHeight(r, cmaps, cmalps, rmalps, rlps, rowLeafCount);
        int maxMatrixHeight = Math.max(mps.height, rmaps.height);
        int minCellHeight = Math.max((int)((double)(maxMatrixHeight / rowLeafCount) * 0.2), minimumCellSize.height);
        if (cellHeight < minCellHeight) {
            if (cmaps.height > 0) {
                cmalps.height = cmaps.height;
                cellHeight = this._computeCellHeight(r, cmaps, cmalps, rmalps, rlps, rowLeafCount);
            }
            minCellHeight = Math.max(rmaps.height / rowLeafCount, minimumCellSize.height);
            if (rmaps.height > 0 && cellHeight < minCellHeight) {
                rlps.height = 0;
                rlps.width = 0;
                rmalps.height = 0;
                rmalps.width = 0;
                cellHeight = this._computeCellHeight(r, cmaps, cmalps, rmalps, rlps, rowLeafCount);
            }
            if (cellHeight < (minCellHeight = minimumCellSize.height)) {
                cmalps.height = 0;
                cmalps.width = 0;
                cmaps.height = 0;
                cmaps.width = 0;
                cellHeight = this._computeCellHeight(r, cmaps, cmalps, rmalps, rlps, rowLeafCount);
                if (cellHeight < minimumCellSize.height) {
                    this.disablePanes("InsufficientDisplaySpace.ex.txt");
                    return;
                }
            }
        }
        GridDimension.mergeHeights(cmaps, cmalps);
        rmaps.setRowHeight(0, cellHeight);
        Insets margin = new Insets(0, 0, 0, 0);
        int westWidth = this.rowIsEast ? 0 : Math.max(cmalps.width, rmaps.width);
        int matrixWidth = cellWidth * columnLeafCount;
        int eastWidth = this.rowIsEast ? Math.max(cmalps.width, rmaps.width) : 0;
        mps.width = cmaps.width = matrixWidth;
        int maxSpacer = Util.MIN_FONT_WIDTH / 2;
        int excessPixels = r.width - (westWidth + matrixWidth + eastWidth);
        margin.left = excessPixels / 2;
        margin.right = excessPixels - margin.left;
        int cmalGap = 0;
        if (this.rowIsEast) {
            if (eastWidth > cmalps.width) {
                cmalGap = Math.min(maxSpacer, eastWidth - cmalps.width);
            }
        } else if (westWidth > cmalps.width) {
            cmalGap = Math.min(maxSpacer, westWidth - cmalps.width);
        }
        int startX = r.x + margin.left;
        int matrixStartX = startX + westWidth;
        if (this.rowIsEast) {
            mb.x = cmab.x = startX;
            mb.width = cmab.width = matrixWidth;
            rlb.x = startX;
            rlb.width = Math.min(rlps.width, matrixWidth);
            rmab.x = rmalb.x = mb.x + mb.width;
            rmab.width = rmalb.width = rmaps.width;
            cmalb.x = rmab.x + cmalGap;
            cmalb.width = cmalps.width;
        } else {
            mb.x = cmab.x = matrixStartX;
            mb.width = cmab.width = matrixWidth;
            rmab.width = rmalb.width = rmaps.width;
            rmab.x = rmalb.x = matrixStartX - rmab.width;
            cmalb.width = cmalps.width;
            cmalb.x = matrixStartX - cmalb.width - cmalGap;
            rlb.width = Math.min(rlps.width, matrixWidth);
            rlb.x = mb.x;
        }
        int northHeight = Math.max(rmalps.height, rlps.height);
        int matrixHeight = cellHeight * rowLeafCount;
        int southHeight = cmaps.height;
        int excessPixels2 = r.height - (northHeight + matrixHeight + southHeight);
        margin.top = excessPixels2 / 2;
        margin.bottom = excessPixels2 - margin.top;
        int startY = margin.top;
        int topOfMatrixY = startY + northHeight;
        rmalb.height = rmalps.height;
        rmalb.y = topOfMatrixY - rmalb.height;
        rlb.height = rlps.height;
        rlb.y = topOfMatrixY - rlb.height;
        mb.y = rmab.y = topOfMatrixY;
        mb.height = rmab.height = matrixHeight;
        cmab.y = cmalb.y = mb.y + mb.height;
        cmab.height = cmalb.height = cmaps.height;
        --cmab.y;
        ++rmab.x;
        PieChartMatrixContainer.applyPaneBounds(this.cellPane, mb);
        PieChartMatrixContainer.applyPaneBounds(this.columnMatrixAxisValuePane, cmab);
        PieChartMatrixContainer.applyPaneBounds(this.columnMatrixAxisLabelPane, cmalb);
        PieChartMatrixContainer.applyPaneBounds(this.rowMatrixAxisValuePane, rmab);
        PieChartMatrixContainer.applyPaneBounds(this.rowMatrixAxisLabelPane, rmalb);
        PieChartMatrixContainer.applyPaneBounds(this.responseLabelPane, rlb);
        if (this.messagesComponent != null) {
            int x1 = mb.x;
            int x2 = mb.x + mb.width;
            int y1 = mb.y;
            int y2 = mb.y + mb.height;
            Rectangle display = new Rectangle(x1, y1, x2 - x1, y2 - y1);
            Dimension wps = this.messagesComponent.getPreferredSize();
            Rectangle wmb = new Rectangle();
            wmb.width = Math.min(wps.width, display.width);
            wmb.height = Math.min(wps.height, display.height);
            wmb.x = display.x + (display.width - wmb.width) / 2;
            wmb.y = display.y + (display.height - wmb.height) / 2;
            PieChartMatrixContainer.applyBounds(this.messagesComponent, wmb);
        }
        int leafGrowthDirection = this.rowIsEast ? 7 : 3;
        ValuePane.doLayout(this.rowMatrixAxisValuePane, leafGrowthDirection, rmaps, 0, 0);
        LabelPane.doLayout(this.rowMatrixAxisLabelPane, leafGrowthDirection, rmalps);
        leafGrowthDirection = 1;
        ValuePane.doLayout(this.columnMatrixAxisValuePane, leafGrowthDirection, cmaps, 0, 0);
        LabelPane.doLayout(this.columnMatrixAxisLabelPane, leafGrowthDirection, cmalps);
        AlignableComponentConstraints constraints = new AlignableComponentConstraints();
        constraints.getBounds().height = cellHeight;
        constraints.getBounds().width = cellWidth;
        CellPane.doLayout(this.cellPane, constraints, 0, 0);
        if (responseLevelCount > 0) {
            int levelHeight = rlb.height / responseLevelCount;
            LabelPane.doLayout(this.responseLabelPane, 5, rlb.width, levelHeight);
        }
    }

    private void _applyAutomaticJustification(boolean rowIsEast) {
        if (rowIsEast) {
            StringComponent.applyAutomaticJustification(this.columnMatrixAxisLabelPane, 2);
        } else {
            StringComponent.applyAutomaticJustification(this.columnMatrixAxisLabelPane, 4);
        }
    }

    public ChartImageMapInfo2 getImageMapInfo() {
        ChartValueZone[] columnValueZones = this.columnMatrixAxisValuePane == null ? null : this.columnMatrixAxisValuePane.toChartValueZones(this, 0);
        ChartValueZone[] rowValueZones = this.rowMatrixAxisValuePane == null ? null : this.rowMatrixAxisValuePane.toChartValueZones(this, 1);
        ChartValueZone[] categoryValueZones = null;
        ChartValueZone[] subgroupValueZones = null;
        ChartValueZone[] dataElementValueZones = null;
        LabelZoneList columnLabelZoneList = this.columnMatrixAxisLabelPane == null ? null : this.columnMatrixAxisLabelPane.toLabelZoneList(this);
        LabelZoneList rowLabelZoneList = this.rowMatrixAxisLabelPane == null ? null : this.rowMatrixAxisLabelPane.toLabelZoneList(this);
        LabelZoneList categoryLabelZoneList = null;
        LabelZoneList subgroupLabelZoneList = null;
        LabelZoneList responseLabelZoneList = this.responseLabelPane == null ? null : this.responseLabelPane.toLabelZoneList(this);
        LabelZoneList response2LabelZoneList = null;
        ChartImageMapInfo2 imageMapInfo = new ChartImageMapInfo2(columnValueZones, rowValueZones, categoryValueZones, subgroupValueZones, dataElementValueZones, columnLabelZoneList, rowLabelZoneList, categoryLabelZoneList, subgroupLabelZoneList, responseLabelZoneList, response2LabelZoneList);
        imageMapInfo.source = this;
        return imageMapInfo;
    }

    private class LayoutCache {
        private final Dimension mps;
        private final GridDimension cmaps;
        private final GridDimension cmalps;
        private final GridDimension rmaps;
        private final GridDimension rmalps;
        private final Dimension rlps;
        private final int columnLeafCount;
        private final int rowLeafCount;
        private final int columnLevelCount;
        private final int rowLevelCount;
        private final int responseLevelCount;
        private final int categoryCount;
        private final Dimension preferredSize;
        private final Dimension minimumCellSize;

        public LayoutCache() {
            this.mps = CellPane.getUniformPreferredSize(PieChartMatrixContainer.this.cellPane);
            this.cmaps = ValuePane.getPreferredGridSize(PieChartMatrixContainer.this.columnMatrixAxisValuePane, 1);
            this.cmalps = LabelPane.getPreferredGridSize(PieChartMatrixContainer.this.columnMatrixAxisLabelPane, 1);
            this.rmaps = ValuePane.getPreferredGridSize(PieChartMatrixContainer.this.rowMatrixAxisValuePane, 3);
            this.rmalps = LabelPane.getPreferredGridSize(PieChartMatrixContainer.this.rowMatrixAxisLabelPane, 3);
            this.rlps = LabelPane.getPreferredSize(PieChartMatrixContainer.this.responseLabelPane, 5);
            DataTreeGroupNode[] colTreeLeaves = GTKUtil.getLeafNodes(PieChartMatrixContainer.this.columnTree);
            DataTreeGroupNode[] rowTreeLeaves = GTKUtil.getLeafNodes(PieChartMatrixContainer.this.rowTree);
            this.columnLevelCount = Math.max(1, PieChartMatrixContainer.this.columnTree.getVariableCount());
            this.rowLevelCount = Math.max(1, PieChartMatrixContainer.this.rowTree.getVariableCount());
            this.columnLeafCount = colTreeLeaves.length;
            this.rowLeafCount = rowTreeLeaves.length;
            this.responseLevelCount = PieChartMatrixContainer.this.responseLabelPane != null ? PieChartMatrixContainer.this.responseLabelPane.getContentPanelComponents().length : 0;
            this.preferredSize = this._getPreferredSize();
            int tmpCategoryCount = 0;
            for (int ii = 0; ii < colTreeLeaves.length; ++ii) {
                for (int jj = 0; jj < rowTreeLeaves.length; ++jj) {
                    JComponent component = PieChartMatrixContainer.this.cellPane.getCellComponent((TreeNode)colTreeLeaves[ii], (TreeNode)rowTreeLeaves[jj]);
                    if (!(component instanceof PieChartCell)) continue;
                    tmpCategoryCount += ((PieChartCell)component).getCategoryUniqueValueCount();
                }
            }
            this.categoryCount = tmpCategoryCount;
            this.minimumCellSize = this._getMinimumCellSize();
        }

        private Dimension _newDimension(Dimension d) {
            return new Dimension(d.width, d.height);
        }

        private GridDimension _newGridDimension(GridDimension d) {
            return new GridDimension(d);
        }

        private Dimension _getMinimumCellSize() {
            Dimension ms = new Dimension(0, 0);
            Component[] c = PieChartMatrixContainer.this.cellPane.getContentPanelComponents();
            for (int ii = 0; ii < c.length; ++ii) {
                Dimension cms = c[ii].getMinimumSize();
                if (ms.width < cms.width) {
                    ms.width = cms.width;
                }
                if (ms.height >= cms.height) continue;
                ms.height = cms.height;
            }
            return ms;
        }

        private Dimension _getPreferredSize() {
            int cellMatrixWidth = Math.max(this.mps.width, this.cmaps.width);
            int rowWidth = Math.max(this.rmaps.width, this.rmalps.width);
            rowWidth = Math.max(rowWidth, this.cmalps.width);
            int w = rowWidth + cellMatrixWidth;
            int columnHeight = Math.max(this.cmaps.height, this.cmalps.height);
            int matrixHeight = Math.max(this.rmaps.height, this.mps.height);
            int h = columnHeight + matrixHeight + this.rmalps.height;
            if (PieChartMatrixContainer.this.messagesComponent != null) {
                Dimension wps = PieChartMatrixContainer.this.messagesComponent.getPreferredSize();
                w = Math.max(w, wps.width);
                h = Math.max(h, wps.height);
            }
            Insets insets = PieChartMatrixContainer.this.getInsets();
            return new Dimension(w += insets.top + insets.bottom, h += insets.left + insets.right);
        }

        public Dimension getMinimumCellSize() {
            return this._newDimension(this.minimumCellSize);
        }

        public Dimension getPreferredSize() {
            return this._newDimension(this.preferredSize);
        }

        public Dimension getMatrixPreferredSize() {
            return this._newDimension(this.mps);
        }

        public GridDimension getColumnMatrixAxisPreferredSize() {
            return this._newGridDimension(this.cmaps);
        }

        public GridDimension getColumnMatrixAxisLabelPreferredSize() {
            return this._newGridDimension(this.cmalps);
        }

        public GridDimension getRowMatrixAxisPreferredSize() {
            return this._newGridDimension(this.rmaps);
        }

        public GridDimension getRowMatrixAxisLabelPreferredSize() {
            return this._newGridDimension(this.rmalps);
        }

        public Dimension getResponseLabelPreferredSize() {
            return this._newDimension(this.rlps);
        }

        public int getColumnLeafCount() {
            return this.columnLeafCount;
        }

        public int getColumnLevelCount() {
            return this.columnLevelCount;
        }

        public int getRowLeafCount() {
            return this.rowLeafCount;
        }

        public int getRowLevelCount() {
            return this.rowLevelCount;
        }

        public int getResponseLevelCount() {
            return this.responseLevelCount;
        }

        public int getCategoryCount() {
            return this.categoryCount;
        }
    }
}

