/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.pathanalysischart;

import com.sas.MissingValues;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.pathanalysischart.CompositeTableDataModel;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChart;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartDataModel;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartModel;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartTableDataModel;
import com.sas.graphics.components.pathanalysischart.PathTableDataModel;
import com.sas.graphics.components.pathanalysischart.VolumeTableDataModel;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.LabelComponent;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.LegendCellModel;
import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.pathanalysischart.IOFlowTable;
import com.sas.graphics.util.cell.pathanalysischart.Link;
import com.sas.graphics.util.cell.pathanalysischart.Node;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class PathAnalysisChartCell
extends JPanel {
    public static final String[] STRING_ARRAY = new String[0];
    private static final String PAC_RB_KEY = "PathAnalysisChart.";
    private static final String PAC_RB_EXT = ".txt";
    private PathAnalysisChart chart;
    private PathAnalysisChartModel displayModel;
    private PathAnalysisChartTableDataModel nodeModel;
    private VolumeTableDataModel volumeModel;
    private CompositeTableDataModel compositeModel;
    private TableModel nodeData;
    private TableModel volumeData;
    private TableModel compositeData;
    private LegendCell legend;
    Node outsideNode;
    private Vector allNodes;
    private Vector allRoots;
    private Hashtable compositeParents;
    private HashSet allComposites;
    private HashSet compositesExpanded;
    private Vector[] levelNodes;
    private double[] levelInflow;
    private double[] levelOutflow;
    private String[] allTypes;
    private Vector allFlows;
    private int numFlows;
    private int minLevel;
    private int maxLevel;
    private int maxLevelNodes;
    private int[] areaRowCounts;
    private int[][] areaRowHeights;
    private double maxIncoming;
    private double maxOutgoing;
    private double maxNodeVolume;
    private Dimension prefSize;
    private int chartPadding;
    private int titleHeight;
    private int nodeMinHeight;
    private int nodeMinWidth;
    private int nodeGapVert;
    private int levelHeight;
    private int pathTableHeight;
    private int pathTableWidth;
    private int inflowMidHeight;
    private int outflowMidHeight;
    private int minGapWidth;
    private int maxGapWidth;
    private int topNodeGap;
    private int bottomNodeGap;
    private int curveInnerHeightMin;
    private int curveOuterHeightMin;
    private int inflowX0;
    private int inflowX1;
    private int outflowX0;
    private int outflowX1;
    private int legendX0;
    private int nodeX0;
    private int nodeX1;
    private int barH;
    private int boxW;
    private double scale;
    private boolean showPathTables;
    private boolean dataValid;
    private boolean spacingValid = false;
    private boolean locationsValid;
    private ColumnWidthController tableColumnWidths;
    private Vector mouseMotionSubcomponents;
    ChildToParentEventRelay childToParentEventRelay;
    static final ChartValueZone[] chartValueZoneTemplate = new ChartValueZone[0];

    public PathAnalysisChartCell(PathAnalysisChartDataModel d, PathAnalysisChartModel m) {
        this.setLayout(null);
        this.prefSize = new Dimension(0, 0);
        this.tableColumnWidths = new ColumnWidthController();
        this.mouseMotionSubcomponents = new Vector();
        this.childToParentEventRelay = new ChildToParentEventRelay();
        this.setDisplayModel(m);
        this.setDataModel(d);
    }

    public void setDataModel(PathAnalysisChartDataModel d) {
        this._findChart();
        this.invalidateData();
        this.nodeModel = (PathAnalysisChartTableDataModel)d;
        if (d != null) {
            this.applyData();
        }
    }

    public void setDisplayModel(PathAnalysisChartModel m) {
        this.invalidateData();
        this.displayModel = m;
    }

    public PathAnalysisChartDataModel getDataModel() {
        return this.nodeModel;
    }

    public PathAnalysisChartModel getDisplayModel() {
        return this.displayModel;
    }

    public boolean isOutsideNode(Node n) {
        return n == this.outsideNode;
    }

    public Node getOutsideNode() {
        return this.outsideNode;
    }

    public void setOutsideNode(Node n) {
        if (this.outsideNode != null) {
            throw new IllegalArgumentException(PathAnalysisChartCell._nls("outsideNodeAlreadySet"));
        }
        this.outsideNode = n;
    }

    public String getTypeName(int i) {
        return this.allTypes[i];
    }

    public int getTypeNameCount() {
        return this.allTypes.length;
    }

    @Override
    public void doLayout() {
        if (this.nodeModel == null) {
            return;
        }
        this._applyData();
        this._initSpacing();
        this._assignLocations();
    }

    @Override
    public void invalidate() {
        this.locationsValid = false;
        this.spacingValid = false;
        this.prefSize.width = 0;
        this.prefSize.height = 0;
        super.invalidate();
    }

    public void invalidateData() {
        this.dataValid = false;
        this.invalidate();
    }

    private void _applyData() {
        if (!this.dataValid) {
            this.applyData();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.doLayout();
        return this.prefSize;
    }

    public void applyData() {
        int numPaths;
        int lvl;
        Node n;
        this.allNodes = new Vector();
        if (this.nodeModel == null) {
            return;
        }
        this.nodeData = this.nodeModel.getModel();
        this.volumeModel = this.nodeModel.getVolumeTableDataModel();
        this.volumeData = this.volumeModel.getModel();
        this.compositeModel = this.nodeModel.getCompositeTableDataModel();
        if (this.compositeModel != null) {
            this.compositeData = this.compositeModel.getModel();
        }
        Variable srcNodeVar = this.volumeModel.getSourceNodeVariable();
        Variable dstNodeVar = this.volumeModel.getDestinationNodeVariable();
        Variable srcTypeVar = this.volumeModel.getSourceTypeVariable();
        Variable dstTypeVar = this.volumeModel.getDestinationTypeVariable();
        Variable volumeVar = this.volumeModel.getVolumeVariable();
        int srcNodeCol = PathAnalysisChartCell.findColumnIndex(srcNodeVar, this.volumeData);
        int dstNodeCol = PathAnalysisChartCell.findColumnIndex(dstNodeVar, this.volumeData);
        int srcTypeCol = PathAnalysisChartCell.findColumnIndex(srcTypeVar, this.volumeData);
        int dstTypeCol = PathAnalysisChartCell.findColumnIndex(dstTypeVar, this.volumeData);
        int volumeCol = PathAnalysisChartCell.findColumnIndex(volumeVar, this.volumeData);
        if (this.displayModel != null && this.displayModel.getTypeNameCount() > 0) {
            this.allTypes = this.displayModel.getTypeNames();
        } else {
            Vector<String> tt = new Vector<String>();
            for (int rx = 0; rx < this.volumeData.getRowCount(); ++rx) {
                String t = (String)this.volumeData.getValueAt(rx, srcTypeCol);
                if (!tt.contains(t)) {
                    tt.add(t);
                }
                if (tt.contains(t = (String)this.volumeData.getValueAt(rx, dstTypeCol))) continue;
                tt.add(t);
            }
            this.allTypes = tt.toArray(STRING_ARRAY);
        }
        this.allFlows = new Vector();
        for (int rx = 0; rx < this.volumeData.getRowCount(); ++rx) {
            String dstType;
            String srcType = (String)this.volumeData.getValueAt(rx, srcTypeCol);
            Pair flow = new Pair(srcType, dstType = (String)this.volumeData.getValueAt(rx, dstTypeCol));
            if (this.allFlows.contains(flow)) continue;
            this.allFlows.add(flow);
        }
        this.numFlows = this.allFlows.size();
        this.allComposites = new HashSet();
        this.compositeParents = new Hashtable();
        this.compositesExpanded = new HashSet();
        if (this.compositeData != null) {
            Variable vparent = this.compositeModel.getCompositeNodeVariable();
            Variable vchild = this.compositeModel.getContainedNodeVariable();
            int xparent = PathAnalysisChartCell.findColumnIndex(vparent, this.compositeData);
            int xchild = PathAnalysisChartCell.findColumnIndex(vchild, this.compositeData);
            for (int rx = 0; rx < this.compositeData.getRowCount(); ++rx) {
                String parentName = (String)this.compositeData.getValueAt(rx, xparent);
                String childName = (String)this.compositeData.getValueAt(rx, xchild);
                this.compositeParents.put(childName, parentName);
                this.allComposites.add(parentName);
            }
            String[] expNodes = this.displayModel.getExpandedComposites();
            for (int i = 0; i < expNodes.length; ++i) {
                this.compositesExpanded.add(expNodes[i]);
            }
        }
        this.outsideNode = this._getNode("_OUTSIDE_");
        for (int rx = 0; rx < this.volumeData.getRowCount(); ++rx) {
            String srcNode = (String)this.volumeData.getValueAt(rx, srcNodeCol);
            String dstNode = (String)this.volumeData.getValueAt(rx, dstNodeCol);
            String srcType = (String)this.volumeData.getValueAt(rx, srcTypeCol);
            String dstType = (String)this.volumeData.getValueAt(rx, dstTypeCol);
            if (this._nodeIsHiddenComposite(srcNode) || this._nodeIsHiddenComposite(dstNode)) continue;
            Node f = this._getNode(srcNode);
            Node t = this._getNode(dstNode);
            Pair flow = new Pair(srcType, dstType);
            int flowIndex = this.allFlows.indexOf(flow);
            f.addSuccessor(t);
            t.addPredecessor(f);
            double[] volumes = f.getFlowVolumes(t);
            Object x = this.volumeData.getValueAt(rx, volumeCol);
            volumes[flowIndex] = x == null ? 0.0 : (x instanceof Double ? (Double)x : (x instanceof Integer ? ((Integer)x).doubleValue() : 0.0));
            f.setFlowVolumes(t, volumes);
        }
        Enumeration e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            n.computeVolumeTotals();
        }
        this.allRoots = new Vector();
        e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            Collection np;
            n = (Node)e.nextElement();
            if (n == this.outsideNode || (np = n.getAllPredecessors()).size() != 0 && (np.size() != 1 || !np.contains(this.outsideNode))) continue;
            this.allRoots.add(n);
        }
        this._assignLevels();
        this.levelInflow = new double[this.maxLevel + 1];
        this.levelOutflow = new double[this.maxLevel + 1];
        for (lvl = 0; lvl <= this.maxLevel; ++lvl) {
            this.levelOutflow[lvl] = 0.0;
            this.levelInflow[lvl] = 0.0;
            Vector nodes = this.levelNodes[lvl];
            for (int i = 0; i < nodes.size(); ++i) {
                int f;
                Node n2 = (Node)nodes.elementAt(i);
                double[] v = this.outsideNode.getFlowVolumes(n2);
                for (f = 0; f < v.length; ++f) {
                    int n3 = lvl;
                    this.levelInflow[n3] = this.levelInflow[n3] + v[f];
                }
                v = n2.getFlowVolumes(this.outsideNode);
                for (f = 0; f < v.length; ++f) {
                    int n4 = lvl;
                    this.levelOutflow[n4] = this.levelOutflow[n4] + v[f];
                }
            }
        }
        this.maxLevelNodes = 0;
        for (lvl = 0; lvl <= this.maxLevel; ++lvl) {
            int numNodes = this.levelNodes[lvl].size();
            if (numNodes <= this.maxLevelNodes) continue;
            this.maxLevelNodes = numNodes;
        }
        this.maxIncoming = 0.0;
        Collection os = this.outsideNode.getAllSuccessors();
        for (Node n5 : os) {
            double n_inflow = 0.0;
            for (int vx = 0; vx < this.numFlows; ++vx) {
                n_inflow += this.outsideNode.getFlowVolume(n5, vx);
            }
            if (!(n_inflow > this.maxIncoming)) continue;
            this.maxIncoming = n_inflow;
        }
        this.maxOutgoing = 0.0;
        Collection op = this.outsideNode.getAllPredecessors();
        for (Node n6 : op) {
            double n_outflow = 0.0;
            for (int vx = 0; vx < this.numFlows; ++vx) {
                n_outflow += n6.getFlowVolume(this.outsideNode, vx);
            }
            if (!(n_outflow > this.maxOutgoing)) continue;
            this.maxOutgoing = n_outflow;
        }
        this.maxNodeVolume = 0.0;
        Enumeration e2 = this.allNodes.elements();
        while (e2.hasMoreElements()) {
            Node n7 = (Node)e2.nextElement();
            if (n7 == this.outsideNode) continue;
            double nodeVolume = 0.0;
            for (int tx = 0; tx < this.allTypes.length; ++tx) {
                nodeVolume += n7.getTypeVolume(tx);
            }
            if (!(nodeVolume > this.maxNodeVolume)) continue;
            this.maxNodeVolume = nodeVolume;
        }
        boolean bl = this.showPathTables = this.displayModel.isShowingTables() && this.nodeModel.getPathTableDataModel() != null;
        if (this.showPathTables && (numPaths = this._readPathData(this.nodeModel.getPathTableDataModel())) == 0) {
            this.showPathTables = false;
        }
        this._validateData();
        this._validateData_v920();
        LegendCellModel lcm = new LegendCellModel();
        lcm.setLegendModel(new LegendModel());
        StringVector typevec = new StringVector(this.allTypes.length);
        ColorVector colorvec = new ColorVector(this.allTypes.length);
        for (int tx = 0; tx < this.allTypes.length; ++tx) {
            typevec.addValue(this.allTypes[tx]);
            Color c = this.displayModel.getDataElementStyles().getDiscreteFillColors()[tx];
            colorvec.addValue(c);
        }
        lcm.setStringVector(typevec);
        lcm.setColorVector(colorvec);
        lcm.setOrientation(new Integer(1));
        lcm.setDefaultLabel(this.displayModel.getTypeLabel());
        lcm.getLegendModel().getBackgroundFillStyle().setSolidFillColor(Color.white);
        lcm.getLegendModel().getFrameLineStyle().setColor(new Color(153, 153, 153));
        Font nodeFont = this.displayModel.getNodeTextStyle().getFont();
        lcm.getLegendModel().getValueTextStyle().setFont(nodeFont);
        lcm.getLegendModel().getLabelTextStyle().setFont(nodeFont);
        this.legend = new LegendCell(lcm, null);
        this.dataValid = true;
    }

    private void _initSpacing() {
        int h;
        IOFlowTable t;
        int maxTableHeight;
        int i;
        if (this.spacingValid) {
            return;
        }
        if (this.displayModel == null || this.nodeModel == null) {
            this.prefSize.width = 0;
            this.prefSize.height = 0;
            return;
        }
        this._fillNodeDisplayAreaRowCounts();
        this.nodeMinWidth = 150;
        this.barH = 20;
        this.boxW = this.nodeMinWidth - 1;
        this._fillNodeDisplayRowHeights();
        int nodeHeight = 0;
        int minBarW = -1;
        int minBarY = -1;
        int minBarH = -1;
        int maxLeftLabel = 0;
        int maxRightLabel = 0;
        Node ni = null;
        for (int i2 = 0; i2 < this.allNodes.size(); ++i2) {
            int lvl;
            ni = (Node)this.allNodes.elementAt(i2);
            if (ni == this.outsideNode) continue;
            ni.doLayout();
            Dimension nd = ni.getPreferredSize();
            int k = nd.height;
            if (k > nodeHeight) {
                nodeHeight = k;
            }
            k = ni.getBarW();
            if (minBarW < 0 || k < minBarW) {
                minBarW = k;
            }
            k = ni.getBarY() + ni.getBoxY();
            if (minBarY < 0 || k < minBarY) {
                minBarY = k;
            }
            k = ni.getBarH();
            if (minBarH < 0 || k < minBarH) {
                minBarH = k;
            }
            if (this.levelNodes[lvl = ni.getLevel()].size() != 1) continue;
            k = ni.getBoxX();
            if (k > maxLeftLabel) {
                maxLeftLabel = k;
            }
            if ((k = nd.width - (ni.getBoxX() + ni.getBoxW())) <= maxRightLabel) continue;
            maxRightLabel = k;
        }
        this.titleHeight = 0;
        this.chartPadding = 10;
        this.pathTableHeight = 100;
        this.pathTableWidth = 240;
        this.curveInnerHeightMin = 20;
        this.curveOuterHeightMin = this.curveInnerHeightMin + this.pathTableHeight;
        int inflowOverlap = minBarY;
        int outflowOverlap = nodeHeight - (minBarY + minBarH);
        this.nodeGapVert = this.curveOuterHeightMin - Math.min(inflowOverlap, outflowOverlap);
        if (this.nodeGapVert < 0) {
            this.nodeGapVert = 0;
        }
        this.inflowMidHeight = this.curveOuterHeightMin - this.pathTableHeight / 2 + (inflowOverlap + this.nodeGapVert - this.curveOuterHeightMin) / 2;
        this.outflowMidHeight = this.curveOuterHeightMin - this.pathTableHeight / 2 + (outflowOverlap + this.nodeGapVert - this.curveOuterHeightMin) / 2;
        this.prefSize.height = 800;
        this.prefSize.width = 400;
        this.levelHeight = nodeHeight + this.nodeGapVert;
        this.scale = (double)minBarW / this.maxNodeVolume;
        double s = (double)(this.nodeGapVert + minBarY - this.curveInnerHeightMin) / this.maxIncoming;
        if (s < this.scale) {
            this.scale = s;
        }
        if (this.scale > 1.0) {
            this.scale = Math.floor(this.scale);
        }
        this.minGapWidth = 20;
        this.maxGapWidth = 100;
        int maxPrefWidth = 800 - (2 * this.chartPadding + (this.showPathTables ? 2 * this.pathTableWidth + 2 * this.minGapWidth : 0));
        int maxLevelWidth = maxLeftLabel + this.nodeMinWidth + maxRightLabel;
        for (int lvl = 0; lvl <= this.maxLevel; ++lvl) {
            Vector nodes = this.levelNodes[lvl];
            int levelWidth = 0;
            for (i = 0; i < nodes.size(); ++i) {
                Node n = (Node)nodes.elementAt(i);
                Dimension ns = n.getPreferredSize();
                levelWidth += ns.width;
            }
            int w0 = levelWidth + (nodes.size() + 1) * this.minGapWidth;
            int w1 = levelWidth + (nodes.size() + 1) * this.maxGapWidth;
            if (w0 > maxPrefWidth) {
                if (w0 <= maxLevelWidth) continue;
                maxLevelWidth = w0;
                continue;
            }
            if (w1 < maxPrefWidth) {
                if (w1 <= maxLevelWidth) continue;
                maxLevelWidth = w1;
                continue;
            }
            if (maxPrefWidth <= maxLevelWidth) continue;
            maxLevelWidth = maxPrefWidth;
        }
        this.prefSize.width = maxLevelWidth + 2 * this.chartPadding + (this.showPathTables ? 2 * this.pathTableWidth + 2 * this.minGapWidth : 0);
        this.inflowX0 = this.chartPadding;
        this.inflowX1 = this.inflowX0 + (this.showPathTables ? this.pathTableWidth : 0);
        this.outflowX1 = this.prefSize.width - this.chartPadding;
        this.outflowX0 = this.outflowX1 - this.pathTableWidth;
        this.legendX0 = this.outflowX0 + 40;
        this.nodeX0 = maxLeftLabel;
        this.nodeX1 = this.nodeX0 + this.nodeMinWidth;
        int extraSpace = maxLevelWidth - (maxLeftLabel + this.nodeMinWidth + maxRightLabel);
        if (extraSpace > 0) {
            int tooFarLeft = (maxLevelWidth - this.nodeX1 - maxLeftLabel) / 2;
            if (tooFarLeft > extraSpace) {
                tooFarLeft = extraSpace;
            }
            if (tooFarLeft < -extraSpace) {
                tooFarLeft = -extraSpace;
            }
            this.nodeX0 += tooFarLeft;
        }
        this.nodeX0 += this.inflowX1 + (this.showPathTables ? this.minGapWidth : 0);
        this.nodeX1 = this.nodeX0 + this.nodeMinWidth;
        this.topNodeGap = this.nodeGapVert;
        if (this.showPathTables) {
            int tgap;
            Vector nodes = this.levelNodes[0];
            maxTableHeight = 0;
            for (i = 0; i < nodes.size(); ++i) {
                Node n = (Node)nodes.elementAt(i);
                t = n.getInflowTable();
                if (!t.isVisible() || (h = t.getPreferredSize().height) <= maxTableHeight) continue;
                maxTableHeight = h;
            }
            if (maxTableHeight > 0 && (tgap = this.inflowMidHeight + maxTableHeight / 2 - inflowOverlap) > this.topNodeGap) {
                this.topNodeGap = tgap;
            }
        }
        this.bottomNodeGap = 0;
        if (this.levelOutflow[this.maxLevel] > 0.0) {
            this.bottomNodeGap = this.nodeGapVert;
        }
        if (this.showPathTables) {
            int bgap;
            Vector nodes = this.levelNodes[this.maxLevel];
            maxTableHeight = 0;
            for (i = 0; i < nodes.size(); ++i) {
                Node n = (Node)nodes.elementAt(i);
                t = n.getOutflowTable();
                if (!t.isVisible() || (h = t.getPreferredSize().height) <= maxTableHeight) continue;
                maxTableHeight = h;
            }
            if (maxTableHeight > 0 && (bgap = this.outflowMidHeight + maxTableHeight / 2 - outflowOverlap) > this.bottomNodeGap) {
                this.bottomNodeGap = bgap;
            }
        }
        this.prefSize.height = this.titleHeight + 2 * this.chartPadding + (this.maxLevel + 1) * nodeHeight + this.topNodeGap + this.maxLevel * this.nodeGapVert + this.bottomNodeGap;
        this.spacingValid = true;
    }

    private void _assignLocations() {
        Node n;
        if (this.locationsValid) {
            return;
        }
        this._putElementsOnChart();
        this.inflowX0 = this.chartPadding;
        this.inflowX1 = this.inflowX0 + (this.showPathTables ? this.pathTableWidth : 0);
        this.outflowX1 = this.prefSize.width - this.chartPadding;
        this.outflowX0 = this.outflowX1 - (this.showPathTables ? this.pathTableWidth : 0);
        if (this.showPathTables) {
            this.legendX0 = this.outflowX0 + this.minGapWidth;
        }
        for (int lvl = 0; lvl <= this.maxLevel; ++lvl) {
            int nodeGapH;
            Vector nodes = this.levelNodes[lvl];
            int y = this.titleHeight + this.chartPadding + this.topNodeGap + lvl * this.levelHeight;
            int numLevelNodes = nodes.size();
            int levelWidth = 0;
            for (int i = 0; i < numLevelNodes; ++i) {
                Node n2 = (Node)nodes.elementAt(i);
                levelWidth += n2.getPreferredSize().width;
            }
            int availSpace = this.outflowX0 - this.inflowX1;
            int extraSpace = availSpace - levelWidth;
            int nodeGapH0 = nodeGapH = extraSpace / (numLevelNodes + 1);
            if (nodeGapH > this.maxGapWidth) {
                nodeGapH = this.maxGapWidth;
                nodeGapH0 = (availSpace - levelWidth - (numLevelNodes - 1) * nodeGapH) / 2;
            }
            int x = this.inflowX1 + nodeGapH0;
            for (int nx = 0; nx < numLevelNodes; ++nx) {
                Dimension ftps;
                IOFlowTable ft;
                Node n3 = (Node)nodes.elementAt(nx);
                if (nx == 0 && numLevelNodes == 1) {
                    x = this.nodeX0 - n3.getBoxX();
                }
                n3.setLocation(x, y);
                x += n3.getPreferredSize().width;
                if (nx < numLevelNodes - 1) {
                    x += nodeGapH;
                }
                Rectangle nb = n3.getBounds();
                int maxx = nb.x + nb.width + this.chartPadding;
                int maxy = nb.y + nb.height + this.chartPadding;
                if (maxx > this.prefSize.width) {
                    this.prefSize.width = maxx;
                }
                if (maxy > this.prefSize.height) {
                    this.prefSize.height = maxy;
                }
                if ((ft = n3.getInflowTable()) != null) {
                    ftps = ft.getPreferredSize();
                    ft.setBounds(this.inflowX0, y + n3.getBoxY() + n3.getBarY() - this.inflowMidHeight - ftps.height / 2, this.pathTableWidth, ftps.height);
                }
                if ((ft = n3.getOutflowTable()) == null) continue;
                ftps = ft.getPreferredSize();
                ft.setBounds(this.outflowX0, y + n3.getBoxY() + n3.getBarY() + n3.getBarH() + this.outflowMidHeight - ftps.height / 2, this.pathTableWidth, ftps.height);
            }
            if (lvl != 0 || this.showPathTables) continue;
            this.legendX0 = x + (this.minGapWidth + this.maxGapWidth) / 2;
        }
        Enumeration e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            n.makeOutgoingLinks();
        }
        e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            n.makeIncomingLinks();
        }
        e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            if (n == this.outsideNode) continue;
            n.makeInflowCurve();
            n.makeOutflowCurve();
        }
        Dimension lps = this.legend.getPreferredSize();
        this.legend.setBounds(this.legendX0, 40, lps.width, lps.height);
        int widthNeededForLegend = this.legendX0 + lps.width + this.chartPadding;
        if (widthNeededForLegend > this.prefSize.width) {
            this.prefSize.width = widthNeededForLegend;
            if (!this.showPathTables) {
                this.outflowX0 = this.prefSize.width - this.chartPadding;
            }
        }
        this.locationsValid = true;
    }

    private void _fillNodeDisplayAreaRowCounts() {
        this.areaRowCounts = new int[4];
        for (int area = 1; area <= 4; ++area) {
            int loc1 = -1;
            int loc2 = -1;
            switch (area) {
                case 1: {
                    loc1 = 11302;
                    loc2 = 11308;
                    break;
                }
                case 2: {
                    loc1 = 11301;
                    loc2 = 11308;
                    break;
                }
                case 3: {
                    loc1 = 11301;
                    loc2 = 11307;
                    break;
                }
                case 4: {
                    loc1 = 11302;
                    loc2 = 11307;
                }
            }
            Vector items = this.nodeModel.getNodeLabelDisplayInfo(loc1, loc2, Integer.MIN_VALUE, Integer.MIN_VALUE);
            int maxAreaRow = -1;
            for (int i = 0; i < items.size(); ++i) {
                PathAnalysisChartTableDataModel.NodeDisplayItem ni = (PathAnalysisChartTableDataModel.NodeDisplayItem)items.get(i);
                int row = ni.getLocation()[3];
                if (row < 0) {
                    row = -row - 1;
                }
                if (row <= maxAreaRow) continue;
                maxAreaRow = row;
            }
            this.areaRowCounts[area - 1] = maxAreaRow + 1;
        }
    }

    private void _fillNodeDisplayRowHeights() {
        this.areaRowHeights = new int[4][];
        for (int area = 1; area <= 4; ++area) {
            int loc1 = -1;
            int loc2 = -1;
            switch (area) {
                case 1: {
                    loc1 = 11302;
                    loc2 = 11308;
                    break;
                }
                case 2: {
                    loc1 = 11301;
                    loc2 = 11308;
                    break;
                }
                case 3: {
                    loc1 = 11301;
                    loc2 = 11307;
                    break;
                }
                case 4: {
                    loc1 = 11302;
                    loc2 = 11307;
                }
            }
            this.areaRowHeights[area - 1] = new int[this.areaRowCounts[area - 1]];
            for (int row = 0; row < this.areaRowCounts[area - 1]; ++row) {
                this.areaRowHeights[area - 1][row] = -1;
            }
            Vector items = this.nodeModel.getNodeLabelDisplayInfo(loc1, loc2, Integer.MIN_VALUE, Integer.MIN_VALUE);
            Vector comps = new Vector();
            for (int i = 0; i < items.size(); ++i) {
                PathAnalysisChartTableDataModel.NodeDisplayItem item = (PathAnalysisChartTableDataModel.NodeDisplayItem)items.get(i);
                int row = item.getLocation()[3];
                if (row < 0) {
                    row = -row - 1;
                }
                Enumeration e = this.allNodes.elements();
                while (e.hasMoreElements()) {
                    Node n = (Node)e.nextElement();
                    if (n == this.outsideNode) continue;
                    comps.clear();
                    n.findDisplayItemComps(item, comps);
                    for (int j = 0; j < comps.size(); ++j) {
                        Component c = (Component)comps.elementAt(j);
                        Dimension d = c.getPreferredSize();
                        if (d.height <= this.areaRowHeights[area - 1][row]) continue;
                        this.areaRowHeights[area - 1][row] = d.height;
                    }
                }
            }
            for (int row = 0; row < this.areaRowHeights[area - 1].length; ++row) {
                if (this.areaRowHeights[area - 1][row] != -1) continue;
                this.areaRowHeights[area - 1][row] = 16;
            }
        }
    }

    private void _validateData() {
        this._rejectCycles();
    }

    private void _validateData_v920() {
        if (this.allRoots.size() > 1) {
            String rootNames = "";
            for (int i = 0; i < this.allRoots.size(); ++i) {
                rootNames = rootNames + " " + ((Node)this.allRoots.get(i)).getName();
            }
            throw new IllegalArgumentException(PathAnalysisChartCell._nls("tooManyRoots", rootNames));
        }
    }

    private void _rejectCycles() {
        Node n;
        Enumeration e;
        Enumeration e2 = this.allNodes.elements();
        while (e2.hasMoreElements()) {
            Node n2 = (Node)e2.nextElement();
            n2.setDAG(false);
        }
        this.outsideNode.setDAG(true);
        int foundDagNodes = 1;
        while (foundDagNodes > 0) {
            foundDagNodes = 0;
            e = this.allNodes.elements();
            while (e.hasMoreElements()) {
                n = (Node)e.nextElement();
                foundDagNodes += this._testDag(n);
            }
        }
        e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            if (n.isDAG()) continue;
            throw new IllegalArgumentException(PathAnalysisChartCell._nls("cyclicData"));
        }
    }

    private void _assignLevels() {
        Node n;
        this.maxLevel = -1;
        this.minLevel = -1;
        Enumeration e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            n.setLevel(-1);
        }
        for (int rx = 0; rx < this.allRoots.size(); ++rx) {
            Node root = (Node)this.allRoots.get(rx);
            this._assignLevel(root, 0);
        }
        this.levelNodes = new Vector[this.maxLevel + 1];
        for (int lvl = 0; lvl <= this.maxLevel; ++lvl) {
            this.levelNodes[lvl] = new Vector();
        }
        e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            int lvl;
            n = (Node)e.nextElement();
            if (n == this.outsideNode || (lvl = n.getLevel()) < 0) continue;
            this.levelNodes[lvl].add(n);
        }
    }

    private void _assignLevel(Node n, int newLevel) {
        if (n == this.outsideNode) {
            return;
        }
        int oldLevel = n.getLevel();
        if (newLevel > oldLevel) {
            n.setLevel(newLevel);
            if (this.minLevel == -1 || newLevel < this.minLevel) {
                this.minLevel = newLevel;
            }
            if (this.maxLevel == -1 || newLevel > this.maxLevel) {
                this.maxLevel = newLevel;
            }
            Collection ns = n.getAllSuccessors();
            for (Node s : ns) {
                if (s == this.outsideNode || s.getLevel() > newLevel) continue;
                this._assignLevel(s, newLevel + 1);
            }
        }
    }

    private int _readPathData(PathTableDataModel m) {
        Node n;
        if (m == null) {
            return 0;
        }
        Enumeration e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            Node n2 = (Node)e.nextElement();
            if (n2 == this.outsideNode) continue;
            n2.getInflowTable().clear();
            n2.getOutflowTable().clear();
        }
        TableModel t = m.getModel();
        if (t == null) {
            return 0;
        }
        int nodeCol = PathAnalysisChartCell.findColumnIndex(m.getNodeVariable(), t);
        int typeCol = PathAnalysisChartCell.findColumnIndex(m.getTypeVariable(), t);
        int dirCol = PathAnalysisChartCell.findColumnIndex(m.getDirectionVariable(), t);
        int pathCol = PathAnalysisChartCell.findColumnIndex(m.getPathVariable(), t);
        int descCol = PathAnalysisChartCell.findColumnIndex(m.getDescriptionVariable(), t);
        int volCol = PathAnalysisChartCell.findColumnIndex(m.getCountVariable(), t);
        int idCol = PathAnalysisChartCell.findColumnIndex(m.getIdVariable(), t);
        int parentCol = PathAnalysisChartCell.findColumnIndex(m.getParentIdVariable(), t);
        int pathCount = 0;
        if (nodeCol < 0 || typeCol < 0 || dirCol < 0 || pathCol < 0 || descCol < 0 || volCol < 0) {
            return 0;
        }
        Enumeration e2 = this.allNodes.elements();
        while (e2.hasMoreElements()) {
            n = (Node)e2.nextElement();
            if (n == this.outsideNode) continue;
            n.getInflowTable().setDisplayedAsTree(false);
            n.getOutflowTable().setDisplayedAsTree(false);
        }
        for (int rx = 0; rx < t.getRowCount(); ++rx) {
            Node n3;
            String path = (String)t.getValueAt(rx, pathCol);
            String desc = (String)t.getValueAt(rx, descCol);
            String node = (String)t.getValueAt(rx, nodeCol);
            String type = (String)t.getValueAt(rx, typeCol);
            String dir = (String)t.getValueAt(rx, dirCol);
            Number volume = (Number)t.getValueAt(rx, volCol);
            Object id = null;
            Object parent = null;
            if (idCol != -1) {
                id = t.getValueAt(rx, idCol);
            }
            if (parentCol != -1) {
                parent = t.getValueAt(rx, parentCol);
            }
            if ((n3 = this._findNode(node)) == null) continue;
            IOFlowTable pt = dir.toUpperCase().startsWith("IN") ? n3.getInflowTable() : n3.getOutflowTable();
            pt.add(type, path, desc, volume, id, parent, rx);
            ++pathCount;
        }
        this.tableColumnWidths.reset();
        e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            if (n == this.outsideNode) continue;
            n.getInflowTable().computeColumnWidths();
            n.getOutflowTable().computeColumnWidths();
        }
        return pathCount;
    }

    int getTableColumnWidth(IOFlowTable t, int columnIndex) {
        return this.tableColumnWidths.getColumnWidth(t, columnIndex);
    }

    void setTableColumnWidth(IOFlowTable t, int columnIndex, int width) {
        this.tableColumnWidths.setColumnWidth(t, columnIndex, width);
    }

    private void _putElementsOnChart() {
        Node n;
        this.removeAll();
        for (int i = 0; i < this.mouseMotionSubcomponents.size(); ++i) {
            Component c = (Component)this.mouseMotionSubcomponents.get(i);
            c.removeMouseMotionListener(this.childToParentEventRelay);
        }
        this.mouseMotionSubcomponents.removeAllElements();
        Enumeration e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            if (!this._nodeIsVisible(n.getName())) continue;
            this.add(n);
        }
        e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            if (n == this.outsideNode || !this._nodeIsVisible(n.getName())) continue;
            IOFlowTable t = n.getInflowTable();
            if (t.getRowCount() > 0) {
                this.add((Component)((Object)t));
                t.addMouseMotionListener(this.childToParentEventRelay);
                this.mouseMotionSubcomponents.add(t);
            }
            if ((t = n.getOutflowTable()).getRowCount() <= 0) continue;
            this.add((Component)((Object)t));
            t.addMouseMotionListener(this.childToParentEventRelay);
            this.mouseMotionSubcomponents.add(t);
        }
        this.add(this.legend);
    }

    private int _testDag(Node n) {
        if (n.isDAG()) {
            return 0;
        }
        Collection ns = n.getAllSuccessors();
        for (Node s : ns) {
            if (s.isDAG()) continue;
            return 0;
        }
        n.setDAG(true);
        int newDagCount = 1;
        Collection np = n.getAllPredecessors();
        for (Node p : np) {
            newDagCount += this._testDag(p);
        }
        return newDagCount;
    }

    @Override
    public void paint(Graphics g) {
        Node n;
        Enumeration e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            if (!this._nodeIsVisible(n.getName())) continue;
            n.paintBackground(g);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.displayModel.isAntialiasedGraphics() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        e = this.allNodes.elements();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            n.paintLinks(g);
        }
        super.paint(g);
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    SASFormat getFormat(String formatName) {
        if (this.chart == null) {
            return null;
        }
        return SASFormat.getInstance((String)formatName, (Locale)this.chart.getLocale());
    }

    public ChartImageMapInfo2 getImageMapInfo() {
        ChartValueZone[] nodeZones = this._getNodeZones();
        ChartValueZone[] nodeDataZones = this._getNodeDataZones();
        ChartValueZone[] nodeLabelZones = this._getNodeLabelZones();
        ChartValueZone[] barSegmentZones = this._getBarSegmentZones();
        ChartValueZone[] linkZones = this._getLinkZones();
        ChartValueZone[] locationDataZones = this._getIOLocationDataZones();
        ChartValueZone[] locationLabelZones = this._getIOLocationLabelZones();
        int len = nodeDataZones.length + barSegmentZones.length + linkZones.length + locationDataZones.length;
        ChartValueZone[] dataZones = new ChartValueZone[len];
        int i = 0;
        ChartValueZone[] src = nodeDataZones;
        len = src.length;
        System.arraycopy(src, 0, dataZones, i, len);
        i += len;
        src = barSegmentZones;
        len = src.length;
        System.arraycopy(src, 0, dataZones, i, len);
        i += len;
        src = linkZones;
        len = src.length;
        System.arraycopy(src, 0, dataZones, i, len);
        i += len;
        src = locationDataZones;
        len = src.length;
        System.arraycopy(src, 0, dataZones, i, len);
        len = nodeLabelZones.length + locationLabelZones.length;
        ChartValueZone[] rowZones = new ChartValueZone[len];
        i = 0;
        src = nodeLabelZones;
        len = src.length;
        System.arraycopy(src, 0, rowZones, i, len);
        i += len;
        src = locationLabelZones;
        len = src.length;
        System.arraycopy(src, 0, rowZones, i, len);
        ChartValueZone[] catZones = nodeZones;
        ChartImageMapInfo2 map = new ChartImageMapInfo2(null, rowZones, catZones, null, dataZones);
        map.source = this;
        return map;
    }

    private ChartValueZone[] _getNodeZones() {
        Vector<ChartValueZone> zones = new Vector<ChartValueZone>();
        Enumeration ne = this.allNodes.elements();
        while (ne.hasMoreElements()) {
            Node n = (Node)ne.nextElement();
            if (n == this.outsideNode) continue;
            String nodeName = n.getName();
            zones.add(new ChartValueZone(new Rectangle(n.getX(), n.getY(), n.getWidth(), n.getHeight()), null, new ValueList("_NODE", "_NODE", null), new ValueList(nodeName, nodeName, null), null, null, null, this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getDataTipVariable()), this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getAuxilliaryVariable())));
        }
        return zones.toArray(chartValueZoneTemplate);
    }

    private ChartValueZone[] _getBarSegmentZones() {
        Vector<ChartValueZone> zones = new Vector<ChartValueZone>();
        double scale = this.getScale();
        Enumeration ne = this.allNodes.elements();
        while (ne.hasMoreElements()) {
            Node n = (Node)ne.nextElement();
            if (n == this.outsideNode) continue;
            String nodeName = n.getName();
            double precedingVolume = 0.0;
            for (int tx = 0; tx < this.getTypeNameCount(); ++tx) {
                double typeVolume = n.getTypeVolume(tx);
                int x = n.getBoxX() + n.getBarX() + (int)(precedingVolume * scale);
                int y = n.getBoxY() + n.getBarY();
                int w = (int)(typeVolume * scale);
                int h = n.getBarH();
                String typeName = this.getTypeName(tx);
                if (w > 0) {
                    zones.add(new ChartValueZone(new Rectangle(n.getX() + x, n.getY() + y, w, h), null, new ValueList("_NODE", "_NODE", new ValueList("_BAR", "_BAR", null)), new ValueList(nodeName, nodeName, null), new ValueList(typeName, typeName, null), new ValueList(new Double(typeVolume), null, null), null, this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getDataTipVariable()), this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getAuxilliaryVariable())));
                }
                h = 16;
                TextStyle t = this.getDisplayModel().getNodeTextStyle();
                if (t != null && t.getFont() != null) {
                    h = t.getFont().getSize();
                }
                w = h / 2 * ("" + typeVolume).length();
                if (tx % 2 == 1) {
                    y += n.getBarH() + h + 1;
                }
                zones.add(new ChartValueZone(new Rectangle(n.getX() + x, n.getY() + (y -= h), w, h), null, new ValueList("_NODE", "_NODE", new ValueList("_BARLABEL", "_BARLABEL", null)), new ValueList(nodeName, nodeName, null), new ValueList(typeName, typeName, null), new ValueList(new Double(typeVolume), "" + typeVolume, null), null, this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getDataTipVariable()), this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getAuxilliaryVariable())));
                precedingVolume += typeVolume;
            }
        }
        return zones.toArray(chartValueZoneTemplate);
    }

    private ChartValueZone[] _getLinkZones() {
        Vector<ChartValueZone> zones = new Vector<ChartValueZone>();
        Enumeration ne = this.allNodes.elements();
        while (ne.hasMoreElements()) {
            Node n = (Node)ne.nextElement();
            String fromNode = n.getName();
            Vector links = n.getOutgoingLinks();
            Enumeration le = links.elements();
            while (le.hasMoreElements()) {
                Link l = (Link)le.nextElement();
                String toNode = l.getToNode().getName();
                String fromType = l.getFromType();
                String toType = l.getToType();
                double volume = n.getFlowVolume(this._findNode(toNode), this.getFlowIndex(fromType, toType));
                if (volume == 0.0) continue;
                zones.add(new ChartValueZone(l.getOutline(), null, new ValueList("_LINK", "_LINK", null), new ValueList(fromNode, fromNode, new ValueList(toNode, toNode, null)), new ValueList(l.getFromType(), l.getFromType(), new ValueList(l.getToType(), l.getToType(), null)), new ValueList(new Double(volume), null, null), null, this._makeValueList(l.getRowIndex(), fromNode, this.volumeModel.getSourceNodeVariable(), fromType, this.volumeModel.getSourceTypeVariable(), toNode, this.volumeModel.getDestinationNodeVariable(), toType, this.volumeModel.getDestinationTypeVariable(), this.volumeModel.getModel(), this.volumeModel.getDataTipVariable()), this._makeValueList(l.getRowIndex(), fromNode, this.volumeModel.getSourceNodeVariable(), fromType, this.volumeModel.getSourceTypeVariable(), toNode, this.volumeModel.getDestinationNodeVariable(), toType, this.volumeModel.getDestinationTypeVariable(), this.volumeModel.getModel(), this.volumeModel.getAuxilliaryVariable())));
            }
        }
        return zones.toArray(chartValueZoneTemplate);
    }

    private ChartValueZone[] _getNodeLabelZones() {
        int ALL = Integer.MIN_VALUE;
        Vector<ChartValueZone> zones = new Vector<ChartValueZone>();
        Enumeration ne = this.allNodes.elements();
        while (ne.hasMoreElements()) {
            Node n = (Node)ne.nextElement();
            if (n == this.outsideNode) continue;
            String nodeName = n.getName();
            Vector items = this.nodeModel.getNodeLabelDisplayInfo(ALL, ALL, ALL, ALL);
            Enumeration ie = items.elements();
            while (ie.hasMoreElements()) {
                Variable iv;
                PathAnalysisChartTableDataModel.NodeDisplayItem i = (PathAnalysisChartTableDataModel.NodeDisplayItem)ie.nextElement();
                if (i == null || (iv = i.getVariable()) == null) continue;
                String itemName = iv.getColumnName();
                String itemLabel = iv.getLabel();
                Component ic = n.getDisplayItemLabelComponent(i);
                if (ic == null) continue;
                zones.add(new ChartValueZone(new Rectangle(ic.getX(), ic.getY(), ic.getWidth(), ic.getHeight()), null, new ValueList("_NODEDATA", "_NODEDATA", new ValueList(itemName, itemLabel, null)), new ValueList(nodeName, nodeName, null), null, null, null, this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getDataTipVariable()), this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getAuxilliaryVariable())));
            }
        }
        return zones.toArray(chartValueZoneTemplate);
    }

    private ChartValueZone[] _getNodeDataZones() {
        int ALL = Integer.MIN_VALUE;
        Vector<ChartValueZone> zones = new Vector<ChartValueZone>();
        Vector items = this.nodeModel.getNodeLabelDisplayInfo(ALL, ALL, ALL, ALL);
        Enumeration ie = items.elements();
        while (ie.hasMoreElements()) {
            int ix;
            Variable iv;
            PathAnalysisChartTableDataModel.NodeDisplayItem i = (PathAnalysisChartTableDataModel.NodeDisplayItem)ie.nextElement();
            if (i == null || (iv = i.getVariable()) == null || (ix = PathAnalysisChartCell.findColumnIndex(iv, this.nodeData)) == -1) continue;
            String itemName = iv.getColumnName();
            String itemLabel = iv.getLabel();
            Enumeration ne = this.allNodes.elements();
            while (ne.hasMoreElements()) {
                Node n = (Node)ne.nextElement();
                if (n == this.outsideNode) continue;
                String nodeName = n.getName();
                Component ic = n.getDisplayItemDataComponent(i);
                if (ic == null) continue;
                int nodeNameCol = PathAnalysisChartCell.findColumnIndex(this.nodeModel.getNodeVariable(), this.nodeData);
                Object unformattedData = null;
                String formattedData = null;
                for (int rx = 0; rx < this.nodeData.getRowCount(); ++rx) {
                    if (!nodeName.equals(this.nodeData.getValueAt(rx, nodeNameCol))) continue;
                    unformattedData = this.nodeData.getValueAt(rx, ix);
                }
                if (unformattedData instanceof Component) {
                    formattedData = null;
                } else if (ic instanceof LabelComponent) {
                    formattedData = ((LabelComponent)ic).getLabel();
                }
                zones.add(new ChartValueZone(new Rectangle(ic.getX(), ic.getY(), ic.getWidth(), ic.getHeight()), null, new ValueList("_NODEDATA", "_NODEDATA", new ValueList(itemName, itemLabel, null)), new ValueList(nodeName, nodeName, null), null, new ValueList(unformattedData, formattedData, null), null, this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getDataTipVariable()), this._makeValueList(n.getRowIndex(), nodeName, this.nodeModel.getNodeVariable(), this.nodeModel.getModel(), this.nodeModel.getAuxilliaryVariable())));
            }
        }
        return zones.toArray(chartValueZoneTemplate);
    }

    private ChartValueZone[] _getIOLocationDataZones() {
        Vector zones = new Vector();
        Vector<IOFlowTable> done = new Vector<IOFlowTable>();
        Enumeration ne = this.allNodes.elements();
        while (ne.hasMoreElements()) {
            IOFlowTable outflow;
            Node n = (Node)ne.nextElement();
            if (n == this.outsideNode) continue;
            IOFlowTable inflow = n.getInflowTable();
            if (inflow != null && !done.contains((Object)inflow)) {
                inflow.getDataZoneInfo(zones);
                done.add(inflow);
            }
            if ((outflow = n.getOutflowTable()) == null || done.contains((Object)outflow)) continue;
            outflow.getDataZoneInfo(zones);
            done.add(outflow);
        }
        return zones.toArray(chartValueZoneTemplate);
    }

    private ChartValueZone[] _getIOLocationLabelZones() {
        Vector zones = new Vector();
        Vector<IOFlowTable> done = new Vector<IOFlowTable>();
        Enumeration ne = this.allNodes.elements();
        while (ne.hasMoreElements()) {
            IOFlowTable outflow;
            Node n = (Node)ne.nextElement();
            if (n == this.outsideNode) continue;
            IOFlowTable inflow = n.getInflowTable();
            if (inflow != null && !done.contains((Object)inflow)) {
                inflow.getLabelZoneInfo(zones);
                done.add(inflow);
            }
            if ((outflow = n.getOutflowTable()) == null || done.contains((Object)outflow)) continue;
            outflow.getLabelZoneInfo(zones);
            done.add(outflow);
        }
        return zones.toArray(chartValueZoneTemplate);
    }

    public PickInfo pick(int x, int y) {
        PickInfo pi = null;
        ChartImageMapInfo2 map = this.getImageMapInfo();
        map.translate(this);
        ChartValueZone[] datazones = map.getDataElementValueZones();
        for (int i = 0; i < datazones.length; ++i) {
            ChartValueZone datazone = datazones[i];
            if (!datazone.getShape().contains(x, y)) continue;
            ValueList rowvalue = datazone.getRowValue();
            if (rowvalue.getUnformattedValue().equals("_LINK") && (pi = this._createLinkPickInfo(datazone, i, x, y)) != null) {
                return pi;
            }
            if (!rowvalue.getUnformattedValue().equals("_INFLOW") && !rowvalue.getUnformattedValue().equals("_OUTFLOW") || (pi = this._createPathPickInfo(datazone, i, x, y)) == null) continue;
            return pi;
        }
        ChartValueZone[] catzones = map.getCategoryValueZones();
        for (int i = 0; i < catzones.length; ++i) {
            ValueList rowvalue;
            ChartValueZone catzone = catzones[i];
            if (!catzone.getShape().contains(x, y) || !(rowvalue = catzone.getRowValue()).getUnformattedValue().equals("_NODE") || (pi = this._createNodePickInfo(catzone, i, x, y)) == null) continue;
            return pi;
        }
        return null;
    }

    private PickInfo _createNodePickInfo(ChartValueZone nodeDataZone, int obsIndex, int ex, int ey) {
        return this._createPickInfo(nodeDataZone, obsIndex, ex, ey, this.nodeModel, this.nodeModel.getDataTipVariable());
    }

    private PickInfo _createPathPickInfo(ChartValueZone pathDataZone, int obsIndex, int ex, int ey) {
        PathTableDataModel m = this.nodeModel.getPathTableDataModel();
        return this._createPickInfo(pathDataZone, obsIndex, ex, ey, m, m.getDataTipVariable());
    }

    private PickInfo _createLinkPickInfo(ChartValueZone linkDataZone, int obsIndex, int ex, int ey) {
        return this._createPickInfo(linkDataZone, obsIndex, ex, ey, this.volumeModel, this.volumeModel.getDataTipVariable());
    }

    private PickInfo _createPickInfo(ChartValueZone dataZone, int obsIndex, int ex, int ey, Object model, Variable[] dtVars) {
        return this._createPickInfo(dataZone, obsIndex, ex, ey, model, dtVars, null);
    }

    private PickInfo _createPickInfo(ChartValueZone dataZone, int obsIndex, int ex, int ey, Object model, Variable[] dtVars, ValueList dtValues) {
        if (dtVars == null || dtVars.length == 0) {
            return null;
        }
        if (dtValues == null) {
            dtValues = dataZone.getDataTipValue();
        }
        if (dtValues == null) {
            return null;
        }
        Vector[] labelValueCollection = new Vector[1];
        Vector labelValues = labelValueCollection[0] = new Vector();
        ValueList dtValue = dtValues;
        for (int i = 0; i < dtVars.length; ++i) {
            Hashtable<String, Object> labelValue = new Hashtable<String, Object>();
            labelValue.put(PickInfo.LABEL, dtVars[i] == null ? "" : dtVars[i].getLabel());
            labelValue.put(PickInfo.VALUE, dtValue == null ? null : dtValue.getUnformattedValue());
            labelValue.put(PickInfo.FORMATTED_VALUE, dtValue == null ? "" : dtValue.getFormattedValue());
            labelValue.put(PickInfo.VISIBLE, Boolean.TRUE);
            labelValues.add(labelValue);
            if (dtValue == null) continue;
            dtValue = dtValue.getNext();
        }
        return new PickInfo(labelValueCollection, obsIndex, model, ex, ey, null);
    }

    double getScale() {
        return this.scale;
    }

    int getChartPadding() {
        return this.chartPadding;
    }

    int getLevelHeight() {
        return this.levelHeight;
    }

    int getCurveInnerHeight() {
        return this.curveInnerHeightMin;
    }

    int getInflowX0() {
        return this.inflowX0;
    }

    int getInflowX1() {
        return this.inflowX1;
    }

    int getOutflowX0() {
        return this.outflowX0;
    }

    int getOutflowX1() {
        return this.outflowX1;
    }

    int getBarH() {
        return this.barH;
    }

    int getBoxW() {
        return this.boxW;
    }

    int getNodeMinHeight() {
        return this.nodeMinHeight;
    }

    int getNodeMinWidth() {
        return this.nodeMinWidth;
    }

    int getPathTableHeight() {
        return this.pathTableHeight;
    }

    int getPathTableWidth() {
        return this.pathTableWidth;
    }

    int getInflowMidHeight() {
        return this.inflowMidHeight;
    }

    int getOutflowMidHeight() {
        return this.outflowMidHeight;
    }

    int getNodeDisplayAreaRows(int area) {
        return this.areaRowCounts[area - 1];
    }

    int getNodeDisplayHeight(int area, int row) {
        return this.areaRowHeights[area - 1][row];
    }

    double getLevelInflow(int n) {
        return this.levelInflow[n];
    }

    double getLevelOutflow(int n) {
        return this.levelOutflow[n];
    }

    int getNumberOfFlows() {
        return this.numFlows;
    }

    String getFlowSourceType(int fx) {
        return ((Pair)this.allFlows.get(fx)).getSource();
    }

    String getFlowDestinationType(int fx) {
        return ((Pair)this.allFlows.get(fx)).getDestination();
    }

    int getFlowIndex(String srcType, String dstType) {
        return this.allFlows.indexOf(new Pair(srcType, dstType));
    }

    protected void construct() {
    }

    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }

    private Node _findNode(String nodeName) {
        for (int i = 0; i < this.allNodes.size(); ++i) {
            Node n = (Node)this.allNodes.get(i);
            if (!n.getName().equals(nodeName)) continue;
            return n;
        }
        return null;
    }

    private Node _getNode(String nodeName) {
        Node n = this._findNode(nodeName);
        if (n == null) {
            n = new Node(this, nodeName);
            this.allNodes.add(n);
            if (this._nodeIsVisible(nodeName)) {
                n.setComposite(this.allComposites.contains(nodeName));
            }
        }
        return n;
    }

    ValueList _makeValueList(int rx, Object id, Variable idVar, TableModel table, Variable[] varList) {
        Object row_id;
        if (varList == null || varList.length == 0) {
            return null;
        }
        int idx = PathAnalysisChartCell.findColumnIndex(idVar, table);
        if (idx < 0) {
            return null;
        }
        if (rx >= 0 && rx <= table.getRowCount() - 1 && (row_id = table.getValueAt(rx, idx)) != null && row_id.equals(id)) {
            return this._makeValueList(rx, table, varList);
        }
        for (rx = 0; rx < table.getRowCount(); ++rx) {
            row_id = table.getValueAt(rx, idx);
            if (row_id == null || !row_id.equals(id)) continue;
            return this._makeValueList(rx, table, varList);
        }
        return null;
    }

    ValueList _makeValueList(int rx, Object id1, Variable idVar1, Object id2, Variable idVar2, Object id3, Variable idVar3, Object id4, Variable idVar4, TableModel table, Variable[] varList) {
        if (varList == null || varList.length == 0) {
            return null;
        }
        int idx1 = PathAnalysisChartCell.findColumnIndex(idVar1, table);
        int idx2 = PathAnalysisChartCell.findColumnIndex(idVar2, table);
        int idx3 = PathAnalysisChartCell.findColumnIndex(idVar3, table);
        int idx4 = PathAnalysisChartCell.findColumnIndex(idVar4, table);
        if (idx1 < 0 || idx2 < 0 || idx3 < 0 || idx4 < 0) {
            return null;
        }
        if (rx >= 0 && rx <= table.getRowCount() - 1) {
            Object row_id1 = table.getValueAt(rx, idx1);
            Object row_id2 = table.getValueAt(rx, idx2);
            Object row_id3 = table.getValueAt(rx, idx3);
            Object row_id4 = table.getValueAt(rx, idx4);
            if (row_id1 != null && row_id1.equals(id1) && row_id2 != null && row_id1.equals(id2) && row_id3 != null && row_id1.equals(id3) && row_id4 != null && row_id1.equals(id4)) {
                return this._makeValueList(rx, table, varList);
            }
        }
        if ((rx = this._findObservationIndex(table, idVar1, id1, idVar2, id2, idVar3, id3, idVar4, id4)) >= 0) {
            return this._makeValueList(rx, table, varList);
        }
        return null;
    }

    private ValueList _makeValueList(int rx, TableModel t, Variable[] vars) {
        ValueList vlist = null;
        for (int i = vars.length - 1; i >= 0; --i) {
            Variable var = vars[i];
            int cx = PathAnalysisChartCell.findColumnIndex(var, t);
            Object unformatted = t.getValueAt(rx, cx);
            String formatted = this.getFormattedValueAt(rx, t, var);
            vlist = new ValueList(unformatted, formatted, vlist);
        }
        return vlist;
    }

    private int _findObservationIndex(TableModel table, Variable var1, Object value1, Variable var2, Object value2, Variable var3, Object value3, Variable var4, Object value4) {
        int cx1 = PathAnalysisChartCell.findColumnIndex(var1, table);
        int cx2 = PathAnalysisChartCell.findColumnIndex(var2, table);
        int cx3 = PathAnalysisChartCell.findColumnIndex(var3, table);
        int cx4 = PathAnalysisChartCell.findColumnIndex(var4, table);
        if (cx1 < 0 || cx2 < 0 || cx3 < 0 || cx4 < 0) {
            return -1;
        }
        for (int rx = 0; rx < table.getRowCount(); ++rx) {
            Object row_value1 = table.getValueAt(rx, cx1);
            Object row_value2 = table.getValueAt(rx, cx2);
            Object row_value3 = table.getValueAt(rx, cx3);
            Object row_value4 = table.getValueAt(rx, cx4);
            if (row_value1 == null || !row_value1.equals(value1) || row_value2 == null || !row_value2.equals(value2) || row_value3 == null || !row_value3.equals(value3) || row_value4 == null || !row_value4.equals(value4)) continue;
            return rx;
        }
        return -1;
    }

    public String getFormattedValueAt(int rx, TableModel t, Variable var) {
        int cx = PathAnalysisChartCell.findColumnIndex(var, t);
        String format = var.getFormat();
        Object unformatted = t.getValueAt(rx, cx);
        String formatted = null;
        if (unformatted == null) {
            formatted = "<null>";
        } else if (unformatted instanceof MissingValues) {
            formatted = ".";
        }
        if (format != null && !format.equals("image")) {
            SASFormat f = this.getFormat(format);
            formatted = f.format(unformatted);
        } else {
            formatted = unformatted.toString();
        }
        return formatted;
    }

    private boolean _nodeIsVisible(String nodeName) {
        if (nodeName.equals("_OUTSIDE_")) {
            return false;
        }
        return !this._nodeIsHiddenComposite(nodeName);
    }

    private boolean _nodeIsHiddenComposite(String nodeName) {
        if (this.allComposites.size() == 0) {
            return false;
        }
        if (this.allComposites.contains(nodeName) && this.compositesExpanded.contains(nodeName)) {
            return true;
        }
        Object pn = this.compositeParents.get(nodeName);
        while (pn != null) {
            if (!this.compositesExpanded.contains(pn)) {
                return true;
            }
            pn = this.compositeParents.get(pn);
        }
        return false;
    }

    static int[] findColumnIndex(Variable[] var, TableModel tm) {
        if (var == null) {
            return null;
        }
        int[] idx = new int[var.length];
        for (int i = 0; i < var.length; ++i) {
            idx[i] = PathAnalysisChartCell.findColumnIndex(var[i], tm);
            if (idx[i] != -1) continue;
            return null;
        }
        return idx;
    }

    static int findColumnIndex(Variable var, TableModel tm) {
        if (var == null) {
            return -1;
        }
        int colnum = var.getColumnIndex();
        if (colnum == -1) {
            colnum = PathAnalysisChartCell.findColumnIndex(var.getColumnName(), tm);
        }
        return colnum;
    }

    static int findColumnIndex(String colname, TableModel tm) {
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            if (!tm.getColumnName(i).equals(colname)) continue;
            return i;
        }
        return -1;
    }

    private void _findChart() {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof PathAnalysisChart); p = p.getParent()) {
        }
        if (p != null) {
            this.chart = (PathAnalysisChart)p;
        }
    }

    private static String _nls(String key) {
        return RB.getStringResource(PAC_RB_KEY, key + PAC_RB_EXT);
    }

    private static String _nls(String key, String p0) {
        return Message.format((String)PathAnalysisChartCell._nls(key), (Object)p0);
    }

    private class ColumnWidthController {
        private static final int MINWIDTH = 20;
        int length;
        int[] inflowColWidths;
        int[] outflowColWidths;

        public ColumnWidthController() {
            this.reset();
        }

        public void reset() {
            this.length = 0;
            this.inflowColWidths = new int[0];
            this.outflowColWidths = new int[0];
        }

        public void setColumnWidth(IOFlowTable t, int c, int w) {
            int[] array;
            if (c < 0) {
                return;
            }
            this.extendArrays(c);
            int[] nArray = array = t.isInflow() ? this.inflowColWidths : this.outflowColWidths;
            if (w > array[c]) {
                array[c] = w;
            }
        }

        public int getColumnWidth(IOFlowTable t, int c) {
            return c < 0 || c >= this.length ? -1 : (t.isInflow() ? this.inflowColWidths[c] : this.outflowColWidths[c]);
        }

        private void extendArrays(int colIndex) {
            this.inflowColWidths = this.extendArray(this.inflowColWidths, colIndex);
            this.outflowColWidths = this.extendArray(this.outflowColWidths, colIndex);
            this.length = this.inflowColWidths.length;
        }

        private int[] extendArray(int[] array, int colIndex) {
            if (colIndex >= array.length) {
                int i;
                int len = colIndex + 10;
                int[] newArray = new int[len];
                for (i = 0; i < array.length; ++i) {
                    newArray[i] = array[i];
                }
                for (i = array.length; i < len; ++i) {
                    newArray[i] = 20;
                }
                array = newArray;
            }
            return array;
        }
    }

    private class ChildToParentEventRelay
    implements MouseMotionListener {
        private ChildToParentEventRelay() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Object src;
            if (PathAnalysisChartCell.this.chart != null && (src = e.getSource()) instanceof Component) {
                Component e_source = (Component)src;
                Point chartXY = SwingUtilities.convertPoint(e_source, e.getX(), e.getY(), PathAnalysisChartCell.this.chart);
                MouseEvent e2 = new MouseEvent(PathAnalysisChartCell.this.chart, e.getID(), e.getWhen(), e.getModifiers(), (int)chartXY.getX(), (int)chartXY.getY(), e.getClickCount(), e.isPopupTrigger());
                PathAnalysisChartCell.this.chart.dispatchEvent(e2);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private class Pair {
        public String src;
        public String dst;

        public Pair(String source, String destination) {
            this.src = source;
            this.dst = destination;
        }

        public String getSource() {
            return this.src;
        }

        public String getDestination() {
            return this.dst;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Pair)) {
                return false;
            }
            Pair thatp = (Pair)that;
            return (this.src == thatp.src || this.src != null && this.src.equals(thatp.src)) && (this.dst == thatp.dst || this.dst != null && this.dst.equals(thatp.dst));
        }
    }
}

