/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.pathanalysischart;

import com.sas.MissingValues;
import com.sas.graphics.components.ChartValueZone;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.ValueList;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartModel;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartTableDataModel;
import com.sas.graphics.components.pathanalysischart.PathTableDataModel;
import com.sas.graphics.components.pathanalysischart.VolumeTableDataModel;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.LabelComponent;
import com.sas.graphics.util.cell.pathanalysischart.Curve;
import com.sas.graphics.util.cell.pathanalysischart.IOFlowTable;
import com.sas.graphics.util.cell.pathanalysischart.Link;
import com.sas.graphics.util.cell.pathanalysischart.PathAnalysisChartCell;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;

class Node
extends JPanel {
    private static final int nodeDisplayItemHorizontalPadding = 2;
    private PathAnalysisChartCell containingCell;
    private String name;
    private int rowIndex;
    private Node[] successors;
    private Node[] predecessors;
    private IOFlowTable inflowTable;
    private IOFlowTable outflowTable;
    private Curve inflowCurve;
    private Curve outflowCurve;
    private double[][] flowVolumes;
    private double[] typeVolumes;
    private double totalIncomingVolume;
    private double totalOutgoingVolume;
    private Vector[] incomingLinks;
    private Vector[] outgoingLinks;
    private boolean dag;
    private int level;
    private int boxX;
    private int boxY;
    private int boxW;
    private int boxH;
    private int barX;
    private int barY;
    private int barW;
    private int barH;
    private int[] colRelativeXs;
    private IdentityHashMap itemRelativeLocations;
    private Dimension mySize;
    private boolean composite;
    private HashMap displayItemLabels;
    private HashMap displayItemData;
    private Vector barSegmentLabels;

    public Node(PathAnalysisChartCell c, String s) {
        this.containingCell = c;
        this.name = s;
        this.mySize = new Dimension(c.getNodeMinWidth(), c.getNodeMinHeight());
        this.setLayout(null);
        this.successors = new Node[0];
        this.predecessors = new Node[0];
        this.flowVolumes = new double[0][];
        this.typeVolumes = new double[0];
        int ntypes = this.containingCell.getTypeNameCount();
        this.incomingLinks = new Vector[ntypes];
        this.outgoingLinks = new Vector[ntypes];
        for (int tx = 0; tx < ntypes; ++tx) {
            this.incomingLinks[tx] = new Vector();
            this.outgoingLinks[tx] = new Vector();
        }
        this.composite = false;
        this.dag = false;
        if (!this.name.equals("_OUTSIDE_")) {
            String fmtName;
            PathTableDataModel pathModel = this.getTableDataModel().getPathTableDataModel();
            this.inflowTable = new IOFlowTable(c, this, true);
            this.outflowTable = new IOFlowTable(c, this, false);
            if (pathModel != null && (fmtName = pathModel.getCountVariable().getFormat()) != null) {
                SASFormat fmt = this.containingCell.getFormat(fmtName);
                this.inflowTable.setColumnFormat(0, fmt);
                this.outflowTable.setColumnFormat(0, fmt);
            }
            this._addNodeDisplayItems();
        }
        this.itemRelativeLocations = new IdentityHashMap();
    }

    public boolean isOutsideNode() {
        return this.containingCell.isOutsideNode(this);
    }

    public void setComposite(boolean b) {
        this.composite = b;
    }

    private void _addNodeDisplayItems() {
        this.displayItemLabels = new HashMap();
        this.displayItemData = new HashMap();
        PathAnalysisChartTableDataModel dataModel = this.getTableDataModel();
        int ANY = Integer.MIN_VALUE;
        Vector items = dataModel.getNodeLabelDisplayInfo(ANY, ANY, ANY, ANY);
        this._makeDisplayItemComps(items);
    }

    @Override
    public void doLayout() {
        int w;
        Vector centerComps;
        Vector rightItems;
        int row;
        int rowCount;
        int loc2;
        int loc1;
        int area;
        int maxBarSegmentX = 0;
        this.itemRelativeLocations.clear();
        PathAnalysisChartTableDataModel dataModel = this.getTableDataModel();
        int nodeMinWidth = this.containingCell.getNodeMinWidth();
        int boxPadding = 5;
        this.boxW = this.containingCell.getBoxW();
        this.barX = boxPadding;
        this.barW = this.boxW - 3 * boxPadding;
        this.barH = this.containingCell.getBarH();
        int areaGap = 10;
        int cx = nodeMinWidth / 2;
        this.colRelativeXs = new int[3];
        this.colRelativeXs[0] = boxPadding;
        this.colRelativeXs[1] = cx;
        this.colRelativeXs[2] = nodeMinWidth - boxPadding;
        for (area = 1; area <= 4; ++area) {
            switch (area) {
                default: {
                    loc1 = 11302;
                    loc2 = 11308;
                    break;
                }
                case 2: {
                    loc1 = 11301;
                    loc2 = 11308;
                    break;
                }
                case 3: {
                    loc1 = 11301;
                    loc2 = 11307;
                    break;
                }
                case 4: {
                    loc1 = 11302;
                    loc2 = 11307;
                }
            }
            rowCount = this.containingCell.getNodeDisplayAreaRows(area);
            for (row = 0; row < rowCount; ++row) {
                Vector leftItems = dataModel.getNodeLabelDisplayInfo(loc1, loc2, 11304, row);
                Vector centerItems = dataModel.getNodeLabelDisplayInfo(loc1, loc2, 11306, row);
                rightItems = dataModel.getNodeLabelDisplayInfo(loc1, loc2, 11305, row);
                Vector leftComps = this.findDisplayItemComps(leftItems);
                centerComps = this.findDisplayItemComps(centerItems);
                Vector rightComps = this.findDisplayItemComps(rightItems);
                int leftWidth = this._getNodeDisplayItemWidth(leftComps);
                int centerWidth = this._getNodeDisplayItemWidth(centerComps);
                int rightWidth = this._getNodeDisplayItemWidth(rightComps);
                int leftX = cx;
                int rightX = cx;
                if (!centerComps.isEmpty()) {
                    leftX = cx - centerWidth / 2 - areaGap - leftWidth;
                    rightX = cx + centerWidth / 2 + areaGap + rightWidth;
                } else if (rightComps.isEmpty() && !leftComps.isEmpty()) {
                    leftX = boxPadding;
                } else if (leftComps.isEmpty() && !rightComps.isEmpty()) {
                    rightX = nodeMinWidth - boxPadding;
                } else {
                    int totalWidth = leftWidth + areaGap + rightWidth;
                    if (totalWidth > nodeMinWidth) {
                        leftX = cx - totalWidth / 2;
                        rightX = cx + totalWidth / 2;
                    }
                }
                this.colRelativeXs[0] = Math.min(this.colRelativeXs[0], leftX);
                this.colRelativeXs[2] = Math.max(this.colRelativeXs[2], rightX);
            }
        }
        this.boxX = Math.max(0, -this.colRelativeXs[0]);
        int y = 0;
        for (area = 1; area <= 4; ++area) {
            loc1 = -1;
            loc2 = -1;
            switch (area) {
                case 1: {
                    loc1 = 11302;
                    loc2 = 11308;
                    break;
                }
                case 2: {
                    loc1 = 11301;
                    loc2 = 11308;
                    break;
                }
                case 3: {
                    loc1 = 11301;
                    loc2 = 11307;
                    break;
                }
                case 4: {
                    loc1 = 11302;
                    loc2 = 11307;
                }
            }
            if (area == 2) {
                this.boxY = y + 4;
                y += 8;
            }
            if (area == 3) {
                int maxBarSegmentLabelHeight = 0;
                for (int i = 0; i < this.barSegmentLabels.size(); ++i) {
                    Component c = (Component)this.barSegmentLabels.elementAt(i);
                    Dimension d = c.getPreferredSize();
                    if (d.height <= maxBarSegmentLabelHeight) continue;
                    maxBarSegmentLabelHeight = d.height;
                }
                int labelY0 = y;
                this.barY = y + maxBarSegmentLabelHeight + 1 - this.boxY;
                int labelY1 = y + maxBarSegmentLabelHeight + 1 + this.barH + 1;
                double scale = this.containingCell.getScale();
                double precedingVolume = 0.0;
                maxBarSegmentX = this.boxX + this.barX;
                for (int i = 0; i < this.barSegmentLabels.size(); ++i) {
                    Component c = (Component)this.barSegmentLabels.elementAt(i);
                    Dimension d = c.getPreferredSize();
                    c.setSize(d);
                    double px = (double)(this.boxX + this.barX) + precedingVolume * scale;
                    double py = i % 2 == 0 ? (double)labelY0 : (double)labelY1;
                    this.itemRelativeLocations.put(c, new Point((int)px, (int)py));
                    if (px + (double)d.width > (double)maxBarSegmentX) {
                        maxBarSegmentX = (int)Math.ceil(px) + d.width;
                    }
                    precedingVolume += this.typeVolumes[i];
                }
                y += this.barH + 2 * maxBarSegmentLabelHeight + 2;
            }
            if (area == 4) {
                this.boxH = y + 4 - this.boxY;
                y += 8;
            }
            rowCount = this.containingCell.getNodeDisplayAreaRows(area);
            for (row = 0; row < rowCount; ++row) {
                Vector leftItems = dataModel.getNodeLabelDisplayInfo(loc1, loc2, 11304, row);
                Vector centerItems = dataModel.getNodeLabelDisplayInfo(loc1, loc2, 11306, row);
                rightItems = dataModel.getNodeLabelDisplayInfo(loc1, loc2, 11305, row);
                Vector leftComps = this.findDisplayItemComps(leftItems);
                centerComps = this.findDisplayItemComps(centerItems);
                Vector rightComps = this.findDisplayItemComps(rightItems);
                int leftWidth = this._getNodeDisplayItemWidth(leftComps);
                int centerWidth = this._getNodeDisplayItemWidth(centerComps);
                int rightWidth = this._getNodeDisplayItemWidth(rightComps);
                for (int just = 0; just < 3; ++just) {
                    Vector comps;
                    int loc3;
                    switch (just) {
                        case 0: {
                            loc3 = 11304;
                            comps = leftComps;
                            w = leftWidth;
                            break;
                        }
                        case 1: {
                            loc3 = 11306;
                            comps = centerComps;
                            w = centerWidth;
                            break;
                        }
                        case 2: {
                            loc3 = 11305;
                            comps = rightComps;
                            w = rightWidth;
                            break;
                        }
                        default: {
                            loc3 = Integer.MIN_VALUE;
                            comps = null;
                            w = -1;
                        }
                    }
                    int x = this.colRelativeXs[just];
                    if (loc1 == 11302) {
                        if (loc3 == 11304 && x > 0 && x <= boxPadding) {
                            x = 0;
                        }
                        if (loc3 == 11305 && x >= nodeMinWidth - boxPadding && x < nodeMinWidth) {
                            x = nodeMinWidth;
                        }
                    }
                    if (loc1 == 11301 && loc3 != 11306) {
                        if (loc3 == 11304) {
                            if (!centerComps.isEmpty() && boxPadding + leftWidth + areaGap + centerWidth / 2 < nodeMinWidth / 2 || centerComps.isEmpty() && !rightComps.isEmpty() && boxPadding + leftWidth + areaGap + rightWidth + boxPadding < nodeMinWidth || centerComps.isEmpty() && rightComps.isEmpty() && boxPadding + leftWidth + boxPadding < nodeMinWidth) {
                                x = boxPadding;
                            }
                        } else if (loc3 == 11305 && (!centerComps.isEmpty() && nodeMinWidth / 2 + centerWidth / 2 + areaGap + rightWidth + boxPadding < nodeMinWidth || centerComps.isEmpty() && !leftComps.isEmpty() && boxPadding + leftWidth + areaGap + rightWidth + boxPadding < nodeMinWidth || centerComps.isEmpty() && leftComps.isEmpty() && boxPadding + rightWidth + boxPadding < nodeMinWidth)) {
                            x = nodeMinWidth;
                        }
                    }
                    switch (loc3) {
                        case 11304: {
                            break;
                        }
                        case 11306: {
                            x -= w / 2;
                            break;
                        }
                        case 11305: {
                            x -= w;
                        }
                    }
                    for (int i = 0; i < comps.size(); ++i) {
                        Component c = (Component)comps.get(i);
                        Dimension d = c.getPreferredSize();
                        c.setSize(d);
                        if (c instanceof LabelComponent) {
                            d.width += 3;
                        }
                        this.itemRelativeLocations.put(c, new Point(this.boxX + x, y));
                        x += d.width;
                        x += 2;
                    }
                }
                y += this.containingCell.getNodeDisplayHeight(area, row);
            }
        }
        w = Math.max(Math.max(nodeMinWidth, this.colRelativeXs[2]), maxBarSegmentX) - Math.min(0, this.colRelativeXs[0]);
        int h = y;
        this.setSize(w, h);
    }

    int getBarX() {
        return this.barX;
    }

    int getBarY() {
        return this.barY;
    }

    int getBarW() {
        return this.barW;
    }

    int getBarH() {
        return this.barH;
    }

    int getBoxX() {
        return this.boxX;
    }

    int getBoxY() {
        return this.boxY;
    }

    int getBoxW() {
        return this.boxW;
    }

    int getBoxH() {
        return this.boxH;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.mySize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.mySize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.mySize;
    }

    @Override
    public Dimension getSize() {
        return this.mySize;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.setWidth(w);
        this.setHeight(h);
    }

    public void setWidth(int w) {
        this.mySize.width = w;
    }

    public void setHeight(int h) {
        this.mySize.height = h;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        for (Component c : this.itemRelativeLocations.keySet()) {
            if (c.getParent() != this.containingCell) {
                this.containingCell.add(c);
            }
            Point itemLocation = (Point)this.itemRelativeLocations.get(c);
            c.setLocation(x + itemLocation.x, y + itemLocation.y);
        }
        super.setBounds(x, y, w, h);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addPredecessor(Node p) {
        if (this.hasPredecessor(p)) {
            return;
        }
        Node[] np = new Node[this.predecessors.length + 1];
        for (int i = 0; i < this.predecessors.length; ++i) {
            np[i] = this.predecessors[i];
        }
        np[np.length - 1] = p;
        this.predecessors = np;
    }

    public boolean hasPredecessor(Node p) {
        return this.getPredecessorIndex(p) != -1;
    }

    public Collection getAllPredecessors() {
        return Arrays.asList(this.predecessors);
    }

    private int getPredecessorCount() {
        return this.predecessors.length;
    }

    private Node getPredecessor(int i) {
        return i >= 0 && i < this.predecessors.length ? this.predecessors[i] : null;
    }

    private int getPredecessorIndex(Node p) {
        for (int i = 0; i < this.predecessors.length; ++i) {
            if (p != this.predecessors[i]) continue;
            return i;
        }
        return -1;
    }

    public void addSuccessor(Node s) {
        if (this.hasSuccessor(s)) {
            return;
        }
        Node[] ns = new Node[this.successors.length + 1];
        for (int i = 0; i < this.successors.length; ++i) {
            ns[i] = this.successors[i];
        }
        ns[ns.length - 1] = s;
        this.successors = ns;
    }

    public boolean hasSuccessor(Node s) {
        return this.getSuccessorIndex(s) != -1;
    }

    public Collection getAllSuccessors() {
        return Arrays.asList(this.successors);
    }

    private int getSuccessorCount() {
        return this.successors.length;
    }

    private Node getSuccessor(int i) {
        return i >= 0 && i < this.successors.length ? this.successors[i] : null;
    }

    private int getSuccessorIndex(Node s) {
        for (int i = 0; i < this.successors.length; ++i) {
            if (s != this.successors[i]) continue;
            return i;
        }
        return -1;
    }

    public void setFlowVolume(Node s, int fx, double v) {
        if (!this.hasSuccessor(s)) {
            this.addSuccessor(s);
        }
        int sx = this.getSuccessorIndex(s);
        int numFlowVars = this.containingCell.getNumberOfFlows();
        this._extendFlowVolumes(sx, numFlowVars);
        this.flowVolumes[sx][fx] = v;
    }

    public void setFlowVolumes(Node s, double[] v) {
        int numFlowVars = this.containingCell.getNumberOfFlows();
        if (!this.hasSuccessor(s)) {
            this.addSuccessor(s);
        }
        int sx = this.getSuccessorIndex(s);
        this._extendFlowVolumes(sx, numFlowVars);
        for (int j = 0; j < v.length; ++j) {
            this.flowVolumes[sx][j] = v[j];
        }
    }

    public double[] getFlowVolumes(Node s) {
        int sx = this.getSuccessorIndex(s);
        if (sx >= 0 && sx < this.flowVolumes.length && this.flowVolumes[sx] != null) {
            return this.flowVolumes[sx];
        }
        int numFlowVars = this.containingCell.getNumberOfFlows();
        return new double[numFlowVars];
    }

    public double getFlowVolume(Node s, int fx) {
        int numFlowVars = this.containingCell.getNumberOfFlows();
        return fx >= 0 && fx < numFlowVars ? this.getFlowVolumes(s)[fx] : 0.0;
    }

    public double getTypeVolume(int tx) {
        return this.typeVolumes[tx];
    }

    public void computeVolumeTotals() {
        int numFlows = this.containingCell.getNumberOfFlows();
        this.typeVolumes = new double[this.containingCell.getTypeNameCount()];
        for (int tx = 0; tx < this.typeVolumes.length; ++tx) {
            String type = this.containingCell.getTypeName(tx);
            double incomingTypeVolume = 0.0;
            double outgoingTypeVolume = 0.0;
            for (int fx = 0; fx < numFlows; ++fx) {
                String dt = this.containingCell.getFlowDestinationType(fx);
                String st = this.containingCell.getFlowSourceType(fx);
                if (dt.equals(type)) {
                    for (int px = 0; px < this.getPredecessorCount(); ++px) {
                        Node p = this.getPredecessor(px);
                        incomingTypeVolume += p.getFlowVolume(this, fx);
                    }
                }
                if (!st.equals(type)) continue;
                for (int sx = 0; sx < this.getSuccessorCount(); ++sx) {
                    Node s = this.getSuccessor(sx);
                    outgoingTypeVolume += this.getFlowVolume(s, fx);
                }
            }
            this.typeVolumes[tx] = outgoingTypeVolume > incomingTypeVolume ? outgoingTypeVolume : incomingTypeVolume;
        }
        this.totalOutgoingVolume = 0.0;
        this.totalIncomingVolume = 0.0;
        for (int px = 0; px < this.getPredecessorCount(); ++px) {
            Node p = this.getPredecessor(px);
            for (int fx = 0; fx < numFlows; ++fx) {
                this.totalIncomingVolume += p.getFlowVolume(this, fx);
            }
        }
        for (int sx = 0; sx < this.flowVolumes.length; ++sx) {
            double[] volumeToEachType = this.flowVolumes[sx];
            for (int vx = 0; vx < volumeToEachType.length; ++vx) {
                this.totalOutgoingVolume += volumeToEachType[vx];
            }
        }
        this.barSegmentLabels = this._makeBarSegmentLabelComps();
    }

    public void setInflowTable(IOFlowTable t) {
        this.inflowTable = t;
    }

    public IOFlowTable getInflowTable() {
        return this.inflowTable;
    }

    public void setOutflowTable(IOFlowTable t) {
        this.outflowTable = t;
    }

    public IOFlowTable getOutflowTable() {
        return this.outflowTable;
    }

    public Vector getIncomingLinks() {
        Vector links = new Vector();
        for (int tx = 0; tx < this.incomingLinks.length; ++tx) {
            links.addAll(this.incomingLinks[tx]);
        }
        return links;
    }

    public Vector getOutgoingLinks() {
        Vector links = new Vector();
        for (int tx = 0; tx < this.outgoingLinks.length; ++tx) {
            links.addAll(this.outgoingLinks[tx]);
        }
        return links;
    }

    public void makeInflowCurve() {
        double scale = this.containingCell.getScale();
        double finishLineLength = this.containingCell.getLevelInflow(this.getLevel()) * scale;
        Node fromNode = this.containingCell.getOutsideNode();
        int x0 = this.containingCell.getInflowX1();
        int y0 = this.getY() + this.boxY + this.barY;
        int s0x = this.getX() + this.boxX + this.barX;
        int s0y = y0;
        int f0x = x0;
        int f0y = y0 - this.containingCell.getInflowMidHeight() + (int)(finishLineLength / 2.0);
        double dxy = 9999999.9;
        Link steepest = null;
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            Vector links = fromNode.outgoingLinks[tx];
            for (int i = 0; i < links.size(); ++i) {
                int kfy;
                int ksx;
                double kdxy;
                Link k = (Link)links.elementAt(i);
                if (k.getToNode() != this || !((kdxy = (double)((ksx = s0x + (int)(k.getToPosition() * scale)) - x0 - (y0 - (kfy = f0y - (int)(k.getFromPosition() * scale))))) < dxy)) continue;
                dxy = kdxy;
                steepest = k;
            }
        }
        if (steepest == null) {
            this.inflowCurve = null;
            return;
        }
        int ksx = s0x + (int)(steepest.getToPosition() * scale);
        int ksy = s0y;
        int kfx = f0x;
        int kfy = f0y - (int)(steepest.getFromPosition() * scale);
        int cx = ksx;
        int cy = ksy;
        int ch = kfy - ksy;
        int cw = kfx - ksx;
        this.inflowCurve = new Curve(cx, cy, cw, ch);
    }

    public Curve getInflowCurve() {
        return this.inflowCurve;
    }

    public void makeOutflowCurve() {
        double scale = this.containingCell.getScale();
        double finishLineLength = this.containingCell.getLevelOutflow(this.getLevel()) * scale;
        Node toNode = this.containingCell.getOutsideNode();
        int x0 = this.containingCell.getOutflowX0();
        int y0 = this.getY() + this.boxY + this.barY + this.containingCell.getBarH();
        int s0x = this.getX() + this.boxX + this.barX;
        int s0y = y0;
        int f0x = x0;
        int f0y = y0 + this.containingCell.getOutflowMidHeight() + (int)(finishLineLength / 2.0);
        double dxy = 9.99999999E7;
        Link steepest = null;
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            Vector links = toNode.incomingLinks[tx];
            for (int i = 0; i < links.size(); ++i) {
                int kfy;
                int ksx;
                double kdxy;
                Link k = (Link)links.elementAt(i);
                if (k.getFromNode() != this || !((kdxy = (double)(x0 - (ksx = s0x + (int)((k.getFromPosition() + k.getFromVolume()) * scale)) - ((kfy = f0y - (int)((k.getToPosition() + k.getToVolume()) * scale)) - y0))) < dxy)) continue;
                dxy = kdxy;
                steepest = k;
            }
        }
        if (steepest == null) {
            this.outflowCurve = null;
            return;
        }
        int ksx = s0x + (int)((steepest.getFromPosition() + steepest.getFromVolume()) * scale);
        int ksy = s0y;
        int kfx = f0x;
        int kfy = f0y - (int)((steepest.getToPosition() + steepest.getToVolume()) * scale);
        int cx = ksx;
        int cy = ksy;
        int ch = kfy - ksy;
        int cw = kfx - ksx;
        this.outflowCurve = new Curve(cx, cy, cw, ch);
    }

    public Curve getOutflowCurve() {
        return this.outflowCurve;
    }

    public void makeOutgoingLinks() {
        if (this == this.containingCell.outsideNode) {
            this.makeInflowLinks();
            return;
        }
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            this.outgoingLinks[tx].clear();
        }
        double precedingTypesVolume = 0.0;
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            double precedingVolume = precedingTypesVolume;
            int outsx = this.getSuccessorIndex(this.containingCell.outsideNode);
            for (int sx = 0; sx <= this.getSuccessorCount(); ++sx) {
                if (sx == outsx) continue;
                Node s = sx < this.getSuccessorCount() ? this.getSuccessor(sx) : this.containingCell.outsideNode;
                precedingVolume = this._makeOutgoingLinks(s, tx, precedingVolume);
            }
            precedingTypesVolume += this.getTypeVolume(tx);
        }
    }

    private void makeInflowLinks() {
        if (this != this.containingCell.outsideNode) {
            return;
        }
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            this.outgoingLinks[tx].clear();
        }
        boolean moreLevels = true;
        int lvl = 0;
        while (moreLevels) {
            double precedingVolume = 0.0;
            moreLevels = false;
            for (int sx = 0; sx < this.getSuccessorCount(); ++sx) {
                Node s = this.getSuccessor(sx);
                if (s == this) continue;
                if (s.getLevel() > lvl) {
                    moreLevels = true;
                }
                if (s.getLevel() != lvl) continue;
                for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
                    precedingVolume = this._makeOutgoingLinks(s, tx, precedingVolume);
                }
            }
            ++lvl;
        }
    }

    private double _makeOutgoingLinks(Node s, int tx, double position) {
        PathAnalysisChartModel displayModel = this.containingCell.getDisplayModel();
        int numFlowVars = this.containingCell.getNumberOfFlows();
        Color c = displayModel.getDataElementStyles().getDiscreteFillColors()[tx];
        c = c.brighter();
        Color linkColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), 100);
        String typeName = this.containingCell.getTypeName(tx);
        Vector links = this.outgoingLinks[tx];
        for (int fx = 0; fx < numFlowVars; ++fx) {
            double linkVolume;
            String srcType = this.containingCell.getFlowSourceType(fx);
            String dstType = this.containingCell.getFlowDestinationType(fx);
            if (!srcType.equals(typeName) || !((linkVolume = this.getFlowVolume(s, fx)) > 0.0)) continue;
            Link k = new Link(this.containingCell, this, srcType, s, dstType, linkVolume);
            k.setFromColor(linkColor);
            links.add(k);
            k.setFromPosition(position);
            position += linkVolume;
        }
        return position;
    }

    public void makeIncomingLinks() {
        if (this == this.containingCell.outsideNode) {
            this.makeOutflowLinks();
            return;
        }
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            this.incomingLinks[tx].clear();
        }
        double precedingTypesVolume = 0.0;
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            double precedingVolume = precedingTypesVolume;
            int outpx = this.getPredecessorIndex(this.containingCell.outsideNode);
            for (int px = -1; px < this.getPredecessorCount(); ++px) {
                if (px == outpx) continue;
                Node p = px >= 0 ? this.getPredecessor(px) : this.containingCell.outsideNode;
                precedingVolume = this._makeIncomingLinks(p, tx, precedingVolume);
            }
            precedingTypesVolume += this.getTypeVolume(tx);
        }
    }

    private void makeOutflowLinks() {
        if (this != this.containingCell.outsideNode) {
            return;
        }
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            this.incomingLinks[tx].clear();
        }
        boolean moreLevels = true;
        int lvl = 0;
        while (moreLevels) {
            double precedingVolume = 0.0;
            moreLevels = false;
            for (int px = 0; px < this.getPredecessorCount(); ++px) {
                Node p = this.getPredecessor(px);
                if (p == this) continue;
                if (p.getLevel() > lvl) {
                    moreLevels = true;
                }
                if (p.getLevel() != lvl) continue;
                for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
                    precedingVolume = this._makeIncomingLinks(p, tx, precedingVolume);
                }
            }
            ++lvl;
        }
    }

    private double _makeIncomingLinks(Node p, int tx, double position) {
        int numFlowVars = this.containingCell.getNumberOfFlows();
        String dstType = this.containingCell.getTypeName(tx);
        Vector links = this.incomingLinks[tx];
        for (int fx = 0; fx < numFlowVars; ++fx) {
            if (!this.containingCell.getFlowDestinationType(fx).equals(dstType)) continue;
            String srcType = this.containingCell.getFlowSourceType(fx);
            double linkVolume = p.getFlowVolume(this, fx);
            Link k = p.getOutgoingLink(this, srcType, dstType);
            if (k != null) {
                links.add(k);
                k.setToPosition(position);
            }
            if (!(linkVolume > 0.0)) continue;
            position += linkVolume;
        }
        return position;
    }

    private Link getOutgoingLink(Node toNode, String fromType, String toType) {
        Vector links = null;
        for (int tx = 0; tx < this.outgoingLinks.length; ++tx) {
            String typeName = this.containingCell.getTypeName(tx);
            if (!typeName.equals(fromType)) continue;
            links = this.outgoingLinks[tx];
            break;
        }
        if (links == null) {
            return null;
        }
        for (int i = 0; i < links.size(); ++i) {
            Link k = (Link)links.elementAt(i);
            if (k.getFromNode() != this || !k.getFromType().equals(fromType) || k.getToNode() != toNode || !k.getToType().equals(toType)) continue;
            return k;
        }
        return null;
    }

    public void setDAG(boolean b) {
        this.dag = b;
    }

    public boolean isDAG() {
        return this.dag;
    }

    public void setLevel(int i) {
        this.level = i;
    }

    public int getLevel() {
        return this.level;
    }

    public void setRowIndex(int i) {
        this.rowIndex = i;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public void paintBackground(Graphics g) {
        int i0;
        if (this.level == -1) {
            return;
        }
        g.translate(this.getX(), this.getY());
        for (int i = i0 = this.composite ? 2 : 0; i >= 0; --i) {
            int ii = 4 * i;
            g.setColor(new Color(240, 240, 240));
            g.fillRect(this.boxX + ii, this.boxY - ii, this.boxW, this.boxH);
            g.setColor(new Color(153, 153, 153));
            g.drawRect(this.boxX + ii, this.boxY - ii, this.boxW, this.boxH);
        }
        g.translate(-this.getX(), -this.getY());
    }

    @Override
    public void paint(Graphics g) {
        if (this.level == -1) {
            return;
        }
        double scale = this.containingCell.getScale();
        double precedingVolume = 0.0;
        Rectangle2D.Double r = new Rectangle2D.Double();
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            Color typeColor = this.containingCell.getDisplayModel().getDataElementStyles().getDiscreteFillColors()[tx];
            g.setColor(typeColor);
            double x = (double)(this.boxX + this.barX) + precedingVolume * scale;
            double y = this.boxY + this.barY;
            double w = this.typeVolumes[tx] * scale;
            double h = this.containingCell.getBarH();
            if (!this.containingCell.getDisplayModel().isAntialiasedGraphics()) {
                double xd = x;
                x = Math.floor(xd + 0.5);
                w = Math.floor(xd + w + 0.5) - x;
            }
            r.setRect(x, y, w, h);
            ((Graphics2D)g).fill(r);
            precedingVolume += this.typeVolumes[tx];
        }
        super.paint(g);
    }

    public void paintLinks(Graphics g) {
        for (int tx = 0; tx < this.outgoingLinks.length; ++tx) {
            Vector links = this.outgoingLinks[tx];
            for (int i = 0; i < links.size(); ++i) {
                Link k = (Link)links.elementAt(i);
                k.paint(g);
            }
        }
    }

    private void _extendFlowVolumes(int sx, int nf) {
        if (sx > this.flowVolumes.length - 1) {
            int i;
            double[][] nv = new double[sx + 1][];
            for (i = 0; i < this.flowVolumes.length; ++i) {
                nv[i] = this.flowVolumes[i];
            }
            for (i = this.flowVolumes.length; i < this.successors.length; ++i) {
                double[] z = new double[nf];
                for (int j = 0; j < nf; ++j) {
                    z[j] = 0.0;
                }
                nv[i] = z;
            }
            this.flowVolumes = nv;
        }
    }

    public ChartImageMapInfo2 getImageMapInfo() {
        if (this.level == -1) {
            return null;
        }
        ChartValueZone[] nodeValueZone = new ChartValueZone[]{new ChartValueZone(this.getBounds(), null, null, new ValueList(this.name, this.name, null), null, null, null, null, null)};
        ChartImageMapInfo2 map = new ChartImageMapInfo2(null, null, null, null, nodeValueZone, null, null, null, null, null, null);
        map.source = this;
        return map;
    }

    private Object _getNodeLabelValue(Variable v) {
        TableModel tm = this.getTableDataModel().getModel();
        Variable nodeNameVar = this.getTableDataModel().getNodeVariable();
        int nodeNameCx = PathAnalysisChartCell.findColumnIndex(nodeNameVar, tm);
        int labelCx = PathAnalysisChartCell.findColumnIndex(v, tm);
        for (int rx = 0; rx < tm.getRowCount(); ++rx) {
            if (!tm.getValueAt(rx, nodeNameCx).equals(this.name)) continue;
            return tm.getValueAt(rx, labelCx);
        }
        return null;
    }

    private SASFormat _getNodeLabelFormat() {
        Variable volumeVar;
        VolumeTableDataModel volumeModel;
        String formatName;
        Variable pathCountVar;
        String volumeFormatName = null;
        SASFormat volumeFormat = null;
        PathAnalysisChartTableDataModel dataModel = this.getTableDataModel();
        PathTableDataModel pathModel = dataModel.getPathTableDataModel();
        if (pathModel != null && (pathCountVar = pathModel.getCountVariable()) != null && (formatName = pathCountVar.getFormat()) != null) {
            volumeFormatName = formatName;
        }
        if ((volumeModel = dataModel.getVolumeTableDataModel()) != null && (volumeVar = volumeModel.getVolumeVariable()) != null && (formatName = volumeVar.getFormat()) != null) {
            volumeFormatName = formatName;
        }
        if (volumeFormatName != null) {
            volumeFormat = this.containingCell.getFormat(volumeFormatName);
        }
        return volumeFormat;
    }

    private Vector _makeDisplayItemComps(Vector items) {
        PathAnalysisChartModel displayModel = this.containingCell.getDisplayModel();
        PathAnalysisChartTableDataModel dataModel = this.getTableDataModel();
        TableModel data = dataModel.getModel();
        Vector<LabelComponent> compVec = new Vector<LabelComponent>();
        for (int ix = 0; ix < items.size(); ++ix) {
            Variable var;
            PathAnalysisChartTableDataModel.NodeDisplayItem m = (PathAnalysisChartTableDataModel.NodeDisplayItem)items.get(ix);
            if (m == null || (var = m.getVariable()) == null) continue;
            Component comp = null;
            TextStyle t = m.getLabelStyle();
            if (t == null) {
                t = displayModel.getNodeTextStyle();
            }
            if (t.isVisible()) {
                String label = var.getLabel();
                if (label != null && !label.trim().endsWith(":")) {
                    label = label + ":";
                }
                comp = new LabelComponent(label, t);
            }
            if (comp != null) {
                compVec.add((LabelComponent)comp);
                this.displayItemLabels.put(m, comp);
            }
            comp = null;
            int cx = PathAnalysisChartCell.findColumnIndex(var, data);
            Object dataValue = this._getNodeLabelValue(var);
            Class<?> colClass = data.getColumnClass(cx);
            String fmtName = var.getFormat();
            if (Component.class.isAssignableFrom(colClass)) {
                if (dataValue instanceof Component) {
                    comp = (Component)dataValue;
                }
            } else if (dataValue != null && fmtName != null && fmtName.equalsIgnoreCase("image")) {
                ImageIcon ii = null;
                if (dataValue instanceof URL) {
                    ii = new ImageIcon((URL)dataValue);
                } else if (dataValue instanceof String) {
                    String sv = (String)dataValue;
                    if (sv.startsWith("http:")) {
                        try {
                            ii = new ImageIcon(new URL(sv));
                        }
                        catch (Exception exception) {}
                    } else {
                        URL url = this.getClass().getClassLoader().getResource(sv);
                        try {
                            ii = new ImageIcon(url, sv);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (ii != null) {
                    comp = new ImageComponent(ii);
                }
            } else {
                t = m.getDataStyle();
                if (t == null) {
                    t = displayModel.getNodeTextStyle();
                }
                if (t.isVisible()) {
                    String dataString;
                    if (dataValue == null) {
                        dataString = "<null>";
                    } else if (dataValue instanceof MissingValues) {
                        dataString = ".";
                    } else if (var.getFormat() != null) {
                        SASFormat f = this.containingCell.getFormat(fmtName);
                        dataString = f.format(dataValue).trim();
                    } else {
                        dataString = dataValue.toString();
                    }
                    comp = new LabelComponent(dataString, t);
                }
            }
            if (comp == null) continue;
            compVec.add((LabelComponent)comp);
            this.displayItemData.put(m, comp);
        }
        return compVec;
    }

    Vector findDisplayItemComps(Vector items) {
        Vector compVec = new Vector();
        for (int ix = 0; ix < items.size(); ++ix) {
            PathAnalysisChartTableDataModel.NodeDisplayItem m = (PathAnalysisChartTableDataModel.NodeDisplayItem)items.get(ix);
            this.findDisplayItemComps(m, compVec);
        }
        return compVec;
    }

    void findDisplayItemComps(PathAnalysisChartTableDataModel.NodeDisplayItem item, Vector result) {
        if (item == null) {
            return;
        }
        Component comp = (Component)this.displayItemLabels.get(item);
        if (comp != null) {
            result.add(comp);
        }
        if ((comp = (Component)this.displayItemData.get(item)) != null) {
            result.add(comp);
        }
    }

    public Component getDisplayItemLabelComponent(PathAnalysisChartTableDataModel.NodeDisplayItem m) {
        return (Component)this.displayItemLabels.get(m);
    }

    public Component getDisplayItemDataComponent(PathAnalysisChartTableDataModel.NodeDisplayItem m) {
        return (Component)this.displayItemData.get(m);
    }

    private int _getNodeDisplayItemWidth(Vector v) {
        int width = 0;
        for (int i = 0; i < v.size(); ++i) {
            if (i > 0) {
                width += 2;
            }
            Component c = (Component)v.get(i);
            width += (int)c.getPreferredSize().getWidth();
            if (!(c instanceof LabelComponent)) continue;
            width += 3;
        }
        return width;
    }

    private Vector _makeBarSegmentLabelComps() {
        Vector<LabelComponent> comps = new Vector<LabelComponent>();
        PathAnalysisChartTableDataModel dataModel = this.getTableDataModel();
        VolumeTableDataModel volumeModel = dataModel.getVolumeTableDataModel();
        TableModel volumeData = volumeModel.getModel();
        Variable volumeVar = volumeModel.getVolumeVariable();
        int volumeCx = PathAnalysisChartCell.findColumnIndex(volumeVar, volumeData);
        Class<?> volumeClass = volumeModel.getModel().getColumnClass(volumeCx);
        boolean integerData = Integer.class.isAssignableFrom(volumeClass);
        IllegalArgumentException x2 = null;
        for (int tx = 0; tx < this.containingCell.getTypeNameCount(); ++tx) {
            LabelComponent comp = null;
            TextStyle labelStyle = this.containingCell.getDisplayModel().getNodeTextStyle();
            SASFormat fmt = this._getNodeLabelFormat();
            try {
                String dataString = fmt != null ? fmt.format((Object)new Double(this.typeVolumes[tx])).trim() : (integerData ? "" + (int)this.typeVolumes[tx] : "" + this.typeVolumes[tx]);
                comp = new LabelComponent(dataString, labelStyle);
            }
            catch (IllegalArgumentException argx) {
                x2 = new IllegalArgumentException(this.getName() + ", " + this.containingCell.getTypeName(tx) + ", double:" + this.typeVolumes[tx] + "  ><  " + fmt.getName());
                x2.initCause(argx);
            }
            comps.add(comp);
        }
        if (x2 != null) {
            throw x2;
        }
        return comps;
    }

    private PathAnalysisChartTableDataModel getTableDataModel() {
        return (PathAnalysisChartTableDataModel)this.containingCell.getDataModel();
    }

    private class ImageComponent
    extends JPanel {
        Dimension mySize;
        int rounding;
        Image mypic;

        public ImageComponent(ImageIcon ii) {
            this(ii, null, -1);
        }

        public ImageComponent(ImageIcon ii, String toolTip) {
            this(ii, toolTip, -1);
        }

        public ImageComponent(ImageIcon ii, int cornerRadius) {
            this(ii, null, cornerRadius);
        }

        public ImageComponent(ImageIcon ii, String toolTip, int cornerRadius) {
            this.mypic = ii.getImage();
            ii.setImageObserver(this);
            this.setOpaque(true);
            this.setSizeFromIcon();
            int n = this.rounding = cornerRadius >= 0 ? cornerRadius : ii.getIconWidth();
            if (toolTip != null) {
                this.setToolTipText(toolTip);
            }
        }

        private void setSizeFromIcon() {
            int w = this.mypic.getWidth(this);
            int h = this.mypic.getHeight(this);
            this.mySize = new Dimension(w, h);
            this.setSize(w, h);
            this.setMinimumSize(this.mySize);
            this.setMaximumSize(this.mySize);
            this.setPreferredSize(this.mySize);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.mypic, 0, 0, this);
        }
    }
}

