/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.pathanalysischart;

import com.sas.graphics.util.cell.RB;
import com.sas.graphics.util.cell.pathanalysischart.Curve;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

class LinkRenderer {
    private static final String PAC_RB_KEY = "PathAnalysisChart.";
    private static final String PAC_RB_EXT = ".txt";
    private static final int curveResolution = 10;

    LinkRenderer() {
    }

    public static void paint(Graphics g, int s0x, int s0y, int s1x, int s1y, boolean svert, Color sc, int f0x, int f0y, int f1x, int f1y, boolean fvert, Color fc, Curve rc) {
        LinkRenderer.paint(g, (double)s0x, (double)s0y, (double)s1x, (double)s1y, svert, sc, (double)f0x, (double)f0y, (double)f1x, (double)f1y, fvert, fc, rc);
    }

    public static void paint(Graphics g, double s0x, double s0y, double s1x, double s1y, boolean svert, Color sc, double f0x, double f0y, double f1x, double f1y, boolean fvert, Color fc, Curve rc) {
        if (fc == null) {
            fc = sc;
        }
        if (!sc.equals(fc)) {
            throw new IllegalArgumentException(LinkRenderer.nls("singleColorPaths"));
        }
        g.setColor(sc);
        Shape shape = LinkRenderer.getOutline(s0x, s0y, s1x, s1y, svert, f0x, f0y, f1x, f1y, fvert, rc, false);
        if (shape instanceof Shape) {
            ((Graphics2D)g).fill(shape);
        }
    }

    public static Shape getOutline(int s0x, int s0y, int s1x, int s1y, boolean svert, int f0x, int f0y, int f1x, int f1y, boolean fvert, Curve rc) {
        return LinkRenderer.getOutline((double)s0x, (double)s0y, (double)s1x, (double)s1y, svert, (double)f0x, (double)f0y, (double)f1x, (double)f1y, fvert, rc);
    }

    public static Shape getOutline(double s0x, double s0y, double s1x, double s1y, boolean svert, double f0x, double f0y, double f1x, double f1y, boolean fvert, Curve rc) {
        return LinkRenderer.getOutline(s0x, s0y, s1x, s1y, svert, f0x, f0y, f1x, f1y, fvert, rc, true);
    }

    private static Shape getOutline(double s0x, double s0y, double s1x, double s1y, boolean svert, double f0x, double f0y, double f1x, double f1y, boolean fvert, Curve guide, boolean shape) {
        return svert ? LinkRenderer._makeInflow(s0x, s0y, s1x, s1y, f0x, f0y, f1x, f1y, guide, shape) : (fvert ? LinkRenderer._makeOutflow(s0x, s0y, s1x, s1y, f0x, f0y, f1x, f1y, guide, shape) : (s0x < f0x ? LinkRenderer._makeRightShift(s0x, s0y, s1x, s1y, f0x, f0y, f1x, f1y, shape) : (s0x == f0x ? LinkRenderer._makeVertical(s0x, s0y, s1x, s1y, f0x, f0y, f1x, f1y, shape) : (s0x > f0x ? LinkRenderer._makeLeftShift(s0x, s0y, s1x, s1y, f0x, f0y, f1x, f1y, shape) : LinkRenderer._makeBogusPolygon(s0x, s0y, s1x, s1y, f0x, f0y, f1x, f1y)))));
    }

    private static Shape _makeBogusPolygon(double s0x, double s0y, double s1x, double s1y, double f0x, double f0y, double f1x, double f1y) {
        GeneralPath p = new GeneralPath(1, 4);
        p.moveTo((float)s0x, (float)s0y);
        p.lineTo((float)s1x, (float)s1y);
        p.lineTo((float)f1x, (float)f1y);
        p.lineTo((float)f0x, (float)f0y);
        return p;
    }

    private static Shape _makeInflow(double s0x, double s0y, double s1x, double s1y, double f0x, double f0y, double f1x, double f1y, Curve c, boolean polygon) {
        int cn = c.getNumberOfPoints();
        double fcx = c.getX(0);
        double scy = c.getY(cn - 1);
        double dy0 = scy - s0y;
        double dy1 = scy - s1y;
        double dx0 = f0x - fcx;
        double xshift = dx0 - dy0;
        return LinkRenderer._makeOutlineFromCurveAndOffsets(c, dy0, dy1, xshift);
    }

    private static Shape _makeOutflow(double s0x, double s0y, double s1x, double s1y, double f0x, double f0y, double f1x, double f1y, Curve c, boolean polygon) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        int cn = c.getNumberOfPoints();
        double scx = c.getX(0);
        double fcy = c.getY(cn - 1);
        double dy0 = f0y - fcy;
        double dy1 = f1y - fcy;
        double dx0 = scx - s0x;
        double xshift = dy0 - dx0;
        return LinkRenderer._makeOutlineFromCurveAndOffsets(c, dy0, dy1, xshift);
    }

    private static Shape _makeRightShift(double s0x, double s0y, double s1x, double s1y, double f0x, double f0y, double f1x, double f1y, boolean polygon) {
        double theta;
        int i;
        double q1 = Math.sqrt(2.0) / 2.0;
        double q2 = 1.0 - q1;
        double width = s1x - s0x;
        double sx = (s0x + s1x) / 2.0;
        double sy = (s0y + s1y) / 2.0;
        double fx = (f0x + f1x) / 2.0;
        double fy = (f0y + f1y) / 2.0;
        double mx = (sx + fx) / 2.0;
        double my = (sy + fy) / 2.0;
        double rx = (mx - sx) / q2;
        double ry = (my - sy) / q1;
        double[] px = new double[19];
        double[] py = new double[19];
        double cx = sx + rx;
        double cy = sy;
        double a0 = -Math.PI;
        double a1 = a0 + 0.7853981633974483;
        double step = (a1 - a0) / 9.0;
        for (i = 0; i < 10; ++i) {
            theta = a0 + (double)i * step;
            px[i] = cx + rx * Math.cos(theta);
            py[i] = cy - ry * Math.sin(theta);
        }
        cx = fx - rx;
        cy = fy;
        a0 = 0.7853981633974483;
        a1 = 0.0;
        step = (a1 - a0) / 9.0;
        for (i = 1; i < 10; ++i) {
            theta = a0 + (double)i * step;
            px[10 + i - 1] = cx + rx * Math.cos(theta);
            py[10 + i - 1] = cy - ry * Math.sin(theta);
        }
        double[] p2pAngles = LinkRenderer._makeLineSegmentAngles(px, py);
        double[] pAngles = LinkRenderer._makePointAngles(-1.5707963267948966, -1.5707963267948966, p2pAngles);
        return LinkRenderer._makeOutlineFromCenterPointsAndAngles(px, py, width / 2.0, pAngles, polygon);
    }

    private static Shape _makeLeftShift(double s0x, double s0y, double s1x, double s1y, double f0x, double f0y, double f1x, double f1y, boolean polygon) {
        double theta;
        int i;
        double q1 = Math.sqrt(2.0) / 2.0;
        double q2 = 1.0 - q1;
        double width = s1x - s0x;
        double sx = (s0x + s1x) / 2.0;
        double sy = (s0y + s1y) / 2.0;
        double fx = (f0x + f1x) / 2.0;
        double fy = (f0y + f1y) / 2.0;
        double mx = (sx + fx) / 2.0;
        double my = (sy + fy) / 2.0;
        double rx = (sx - mx) / q2;
        double ry = (my - sy) / q1;
        double[] px = new double[19];
        double[] py = new double[19];
        double cx = sx - rx;
        double cy = sy;
        double a0 = 0.0;
        double a1 = -0.7853981633974483;
        double step = (a1 - a0) / 9.0;
        for (i = 0; i < 10; ++i) {
            theta = a0 + (double)i * step;
            px[i] = cx + rx * Math.cos(theta);
            py[i] = cy - ry * Math.sin(theta);
        }
        cx = fx + rx;
        cy = fy;
        a0 = 2.356194490192345;
        a1 = Math.PI;
        step = (a1 - a0) / 9.0;
        for (i = 1; i < 10; ++i) {
            theta = a0 + (double)i * step;
            px[10 + i - 1] = cx + rx * Math.cos(theta);
            py[10 + i - 1] = cy - ry * Math.sin(theta);
        }
        double[] p2pAngles = LinkRenderer._makeLineSegmentAngles(px, py);
        double[] pAngles = LinkRenderer._makePointAngles(-1.5707963267948966, -1.5707963267948966, p2pAngles);
        return LinkRenderer._makeOutlineFromCenterPointsAndAngles(px, py, width / 2.0, pAngles, polygon);
    }

    private static Rectangle2D.Double _makeVertical(double s0x, double s0y, double s1x, double s1y, double f0x, double f0y, double f1x, double f1y, boolean polygon) {
        double x = LinkRenderer.min(s0x, s1x, f0x, f1x);
        double y = LinkRenderer.min(s0y, s1y, f0y, f1y);
        double w = LinkRenderer.max(s0x, s1x, f0x, f1x) - x;
        double h = LinkRenderer.max(s0y, s1y, f0y, f1y) - y;
        return new Rectangle2D.Double(x, y, w, h);
    }

    private static double[] _makeLineSegmentAngles(double[] px, double[] py) {
        double[] angles = new double[px.length - 1];
        for (int i = 0; i < angles.length; ++i) {
            angles[i] = Math.atan2(py[i] - py[i + 1], px[i + 1] - px[i]);
        }
        return angles;
    }

    private static double[] _makePointAngles(double first, double last, double[] lineSegmentAngles) {
        int len = lineSegmentAngles.length + 1;
        double[] angles = new double[len];
        angles[0] = first;
        angles[len - 1] = last;
        for (int i = 1; i < len - 1; ++i) {
            angles[i] = (lineSegmentAngles[i - 1] + lineSegmentAngles[i]) / 2.0;
        }
        return angles;
    }

    private static GeneralPath _makeOutlineFromCenterPointsAndAngles(double[] px, double[] py, double w2, double[] angle, boolean polygonRequired) {
        int i;
        GeneralPath p = new GeneralPath(1, 2 * px.length);
        double normal = angle[0] + 1.5707963267948966;
        p.moveTo((float)(px[0] + w2 * Math.cos(normal)), (float)(py[0] - w2 * Math.sin(normal)));
        for (i = 1; i < px.length; ++i) {
            normal = angle[i] + 1.5707963267948966;
            p.lineTo((float)(px[i] + w2 * Math.cos(normal)), (float)(py[i] - w2 * Math.sin(normal)));
        }
        for (i = px.length - 1; i >= 0; --i) {
            normal = angle[i] - 1.5707963267948966;
            p.lineTo((float)(px[i] + w2 * Math.cos(normal)), (float)(py[i] - w2 * Math.sin(normal)));
        }
        return p;
    }

    private static Shape _makeOutlineFromCurveAndOffsets(Curve c, double d0, double d1, double xadj) {
        int n = c.getNumberOfPoints();
        GeneralPath p = new GeneralPath(1, 2 * n);
        double epsilon = 1.0E-5;
        int j1 = 2 * n - 1;
        double d = d0;
        for (int j = 0; j <= j1; ++j) {
            int i;
            int n2 = i = j < n ? j : j1 - j;
            if (j == n) {
                d = d1;
            }
            double normal = c.getNormal(i);
            double x = c.getX(i) + d * Math.cos(normal) + epsilon;
            if (i < n - 1) {
                x += xadj;
            }
            double y = c.getY(i) + d * Math.sin(normal) + epsilon;
            if (j == 0) {
                p.moveTo((float)x, (float)y);
                continue;
            }
            p.lineTo((float)x, (float)y);
        }
        return p;
    }

    private static String nls(String key) {
        return RB.getStringResource(PAC_RB_KEY, key + PAC_RB_EXT);
    }

    private static double min(double a, double b) {
        return a <= b ? a : b;
    }

    private static double max(double a, double b) {
        return a >= b ? a : b;
    }

    private static double min(double a, double b, double c, double d) {
        return LinkRenderer.min(LinkRenderer.min(a, b), LinkRenderer.min(c, d));
    }

    private static double max(double a, double b, double c, double d) {
        return LinkRenderer.max(LinkRenderer.max(a, b), LinkRenderer.max(c, d));
    }
}

