/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.mapchart;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;

public class EsriIdToCompositeId
extends PropertyContainer {
    public final StringProperty input = new StringProperty((PropertyContainer)this, true);
    public final StringPipe value = new Converter();

    private class Converter
    implements StringPipe {
        private Converter() {
        }

        public String getValue(int index) throws MissingValueException {
            String s = EsriIdToCompositeId.this.input.getValue(index);
            int commaIndex = s.indexOf(",");
            if (commaIndex > 0) {
                String stateFips = s.substring(0, commaIndex).trim();
                String countyFips = s.substring(commaIndex + 1, s.length()).trim();
                try {
                    double ds = Double.parseDouble(stateFips);
                    double dc = Double.parseDouble(countyFips);
                    if (dc > 999.0) {
                        s = ds + "/" + (dc -= 1000.0 * ds);
                    }
                }
                catch (NumberFormatException ds) {}
            } else if (s.length() > 3) {
                String stateFips = s.substring(0, 2);
                String countyFips = s.substring(2, 5);
                try {
                    double ds = Double.parseDouble(stateFips);
                    double dc = Double.parseDouble(countyFips);
                    s = ds + "/" + dc;
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    double fips = Double.parseDouble(s);
                    s = fips + "";
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return s;
        }

        public void init(AInitAction initAction) {
            EsriIdToCompositeId.this.input.init(initAction);
        }

        public void reset(AResetAction resetAction) {
            EsriIdToCompositeId.this.input.reset(resetAction);
        }

        public Formatter getFormatter() {
            return EsriIdToCompositeId.this.input.getFormatter();
        }
    }
}

