/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.kpichart;

import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.kpichart.KPIChartModel;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.kpichart.KPIChartCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.kpi.KPIChartCache;
import com.sas.graphics.util.gtk.render.kpi.KPIChartCustomSkinModel;
import com.sas.graphics.util.gtk.render.kpi.KPIChartRenderer;
import com.sas.graphics.util.gtk.render.kpi.KPIChartRendererModel;
import com.sas.graphics.util.gtk.render.kpi.KPIChartSegmentedRangeColorModel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;

public class KPIChartCell
extends Cell
implements ChartImageMapInfo.ChartImageMapInfoAuthorInterface {
    private static final long serialVersionUID = 1L;
    private final transient DataSource dataSource;
    public static final String RB_KEY = "KPIChartCell.";
    KPIChartCache imageCache;
    double factor = 1.0;
    boolean adjustMagnitude = false;
    String[] formattedSegmentValues;
    KPIChartRendererModel kpiRendererModel;
    KPIChartRenderer kpiRenderer;
    int orientation;
    boolean displayGraph = true;
    boolean show3DElements;
    boolean showBorder = this.show3DElements = true;
    double ratio = 1.0;

    public KPIChartCell(KPIChartCellModel cellModel, DataSource dataSource, Object columnOrdinal, Object rowOrdinal, Channel channel) {
        super(cellModel, channel);
        this.dataSource = dataSource;
        KPIChartModel graphModel = cellModel.getGraphModel();
        this.setAntiAliasingEnabled(graphModel.isAntialiasedGraphics());
        this.setTextAntiAliasingEnabled(graphModel.isAntialiasedText());
        this.kpiRenderer = new KPIChartRenderer();
        this.kpiRendererModel = this.kpiRenderer.getRendererModel();
        this.populateRendererModel();
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setAnimationFrame(AnimationPosition animationPosition) {
        if (this.dataSource.isAnimationEnabled() && this.dataSource.setAnimationPosition(animationPosition)) {
            this.repaint();
        }
    }

    public void setImageCache(KPIChartCache map) {
        this.imageCache = map;
    }

    private void populateRendererModel() {
        KPIChartCellModel cellModel = (KPIChartCellModel)this.getModel();
        KPIChartModel kpiModel = cellModel.getGraphModel();
        this.kpiRendererModel.setActualValueVisiblityEnabled(kpiModel.getActualValueTextStyle().isVisible());
        this.kpiRendererModel.setRangeValueVisiblityEnabled(kpiModel.getRangeValueTextStyle().isVisible());
        this.kpiRendererModel.setActualValueTextStyle(GTKUtil.mapToGTKTextStyle(kpiModel.getActualValueTextStyle()));
        this.kpiRendererModel.setRangeValueTextStyle(GTKUtil.mapToGTKTextStyle(kpiModel.getRangeValueTextStyle()));
        Object actualRole = cellModel.getActualRole();
        NumericVariable actualVariable = (NumericVariable)this.dataSource.getVariable(actualRole, 0);
        actualVariable.init();
        this.kpiRendererModel.setActualVariable(actualVariable);
        this.orientation = kpiModel.getOrientation();
        int kpiType = kpiModel.getKPIChartType();
        if (this.orientation == 10200) {
            if (kpiType == 21002 || kpiType == 21003) {
                this.orientation = 0;
            } else if (kpiType == 21001) {
                this.orientation = 1;
            }
        }
        this.kpiRendererModel.setOrientation(this.orientation);
        switch (kpiType) {
            case 21002: {
                this.kpiRendererModel.setKPIChartType(RendererUtil.KPIChartType.BULLET);
                break;
            }
            case 21000: {
                this.kpiRendererModel.setKPIChartType(RendererUtil.KPIChartType.DIAL);
                break;
            }
            case 21003: {
                this.kpiRendererModel.setKPIChartType(RendererUtil.KPIChartType.SLIDER);
                break;
            }
            case 21004: {
                this.kpiRendererModel.setKPIChartType(RendererUtil.KPIChartType.SPEEDOMETER_FULL);
                break;
            }
            case 21005: {
                this.kpiRendererModel.setKPIChartType(RendererUtil.KPIChartType.SPEEDOMETER_HALF);
                break;
            }
            case 21006: {
                this.kpiRendererModel.setKPIChartType(RendererUtil.KPIChartType.SPEEDOMETER_QUARTER);
                break;
            }
            case 21001: {
                this.kpiRendererModel.setKPIChartType(RendererUtil.KPIChartType.TRAFFIC_LIGHT);
            }
        }
        KPIChartSegmentedRangeColorModel colorModel = new KPIChartSegmentedRangeColorModel(kpiModel.getSegmentedRangeColorModel().getSegmentedRangeModel().getSegmentedRange(), kpiModel.getSegmentedRangeColorModel().getSegmentedRangeModel().isBoundaryInHigherSegment(), kpiModel.getSegmentedRangeColorModel().getSegmentColors(), kpiModel.getSegmentedRangeColorModel().getActiveSegmentColors());
        this.kpiRendererModel.setSegmentedRangeColorModel(colorModel);
        this.kpiRendererModel.setAdjustMagnitudeValueEnabled(kpiModel.isAdjustValueMagnitudeEnabled());
        int skin = kpiModel.getSkin();
        switch (skin) {
            case 12302: {
                this.kpiRendererModel.setSkin(RendererUtil.Skin.MODERN);
                break;
            }
            case 12300: {
                this.kpiRendererModel.setSkin(RendererUtil.Skin.NONE);
                break;
            }
            case 12301: {
                this.kpiRendererModel.setSkin(RendererUtil.Skin.SATIN);
                break;
            }
            case 10200: {
                if (kpiModel.getCustomSkinModel() != null) {
                    this.kpiRendererModel.setSkin(RendererUtil.Skin.CUSTOM);
                    break;
                }
                this.kpiRendererModel.setSkin(RendererUtil.Skin.NONE);
            }
        }
        this.mapCustomSkinModel();
        this.kpiRendererModel.setTargetVariable(this.dataSource.getTargetVariable(cellModel.getActualRole(), 0));
    }

    @Override
    protected synchronized void construct() {
    }

    @Override
    public void paintComponent(Graphics gc) {
        Graphics2D g = (Graphics2D)gc;
        if (g != null) {
            super.paintComponent(g);
            NumericVariable actualVariable = this.kpiRendererModel.getActualVariable();
            if (actualVariable == null) {
                return;
            }
            actualVariable.init();
            if (actualVariable.getValueCount() < 1) {
                return;
            }
            Rectangle componentBounds = this.getBounds();
            Insets insets = this.getInsets();
            if (componentBounds != null) {
                if (insets != null) {
                    componentBounds.x = insets.left;
                    componentBounds.y = insets.top;
                    componentBounds.width = componentBounds.width - insets.left - insets.right - 1;
                    componentBounds.height = componentBounds.height - insets.top - insets.bottom - 1;
                } else {
                    componentBounds.x = 0;
                    componentBounds.y = 0;
                    --componentBounds.width;
                    --componentBounds.height;
                }
                if (componentBounds.width <= 0 || componentBounds.height <= 0) {
                    return;
                }
                this.kpiRenderer.renderKPI(g, componentBounds);
            }
        }
    }

    private void mapCustomSkinModel() {
        KPIChartCellModel kpiCellModel = (KPIChartCellModel)this.getModel();
        KPIChartModel kpiModel = kpiCellModel.getGraphModel();
        com.sas.graphics.components.kpichart.KPIChartCustomSkinModel kpiCustomSkinModel = kpiModel.getCustomSkinModel();
        if (kpiCustomSkinModel != null) {
            if (this.kpiRendererModel.getCustomSkinModel() == null) {
                this.kpiRendererModel.setCustomSkinModel(new KPIChartCustomSkinModel());
            }
            if (kpiCustomSkinModel.getBulletSkinModel() != null) {
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setHorizontalBorderIcon(kpiCustomSkinModel.getBulletSkinModel().getHorizontalBorderIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setHorizontalEffectsIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getHorizontalEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setHorizontalIndicatorCapIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getHorizontalIndicatorCapIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setHorizontalIndicatorIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getHorizontalIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setHorizontalShadowIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getHorizontalShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setHorizontalTargetIndicatorIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getHorizontalTargetIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setVerticalBorderIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getVerticalBorderIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setVerticalEffectsIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getVerticalEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setVerticalIndicatorCapIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getVerticalIndicatorCapIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setVerticalIndicatorIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getVerticalIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setVerticalShadowIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getVerticalShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getBulletSkinModel().setVerticalTargetIndicatorIcon(kpiModel.getCustomSkinModel().getBulletSkinModel().getVerticalTargetIndicatorIcon());
            }
            if (kpiCustomSkinModel.getSliderSkinModel() != null) {
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setHorizontalBorderIcon(kpiCustomSkinModel.getSliderSkinModel().getHorizontalBorderIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setHorizontalEffectsIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getHorizontalEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setHorizontalTintedIndicatorIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getHorizontalTintedIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setHorizontalIndicatorIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getHorizontalIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setHorizontalShadowIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getHorizontalShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setHorizontalTargetIndicatorIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getHorizontalTargetIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setVerticalBorderIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getVerticalBorderIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setVerticalEffectsIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getVerticalEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setVerticalTintedIndicatorIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getVerticalTintedIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setVerticalIndicatorIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getVerticalIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setVerticalShadowIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getVerticalShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getSliderSkinModel().setVerticalTargetIndicatorIcon(kpiModel.getCustomSkinModel().getSliderSkinModel().getVerticalTargetIndicatorIcon());
            }
            if (kpiCustomSkinModel.getDialSkinModel() != null) {
                this.kpiRendererModel.getCustomSkinModel().getDialSkinModel().setBorderIcon(kpiModel.getCustomSkinModel().getDialSkinModel().getBorderIcon());
                this.kpiRendererModel.getCustomSkinModel().getDialSkinModel().setIndicatorIcon(kpiModel.getCustomSkinModel().getDialSkinModel().getIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getDialSkinModel().setIndicatorShadowIcon(kpiModel.getCustomSkinModel().getDialSkinModel().getIndicatorShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getDialSkinModel().setSegmentEffectsIcon(kpiModel.getCustomSkinModel().getDialSkinModel().getSegmentEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getDialSkinModel().setTargetIndicatorIcon(kpiModel.getCustomSkinModel().getDialSkinModel().getTargetIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getDialSkinModel().setTargetIndicatorShadowIcon(kpiModel.getCustomSkinModel().getDialSkinModel().getTargetIndicatorShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getDialSkinModel().setTintedLayerEffectsIcon(kpiModel.getCustomSkinModel().getDialSkinModel().getTintedLayerEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getDialSkinModel().setTintedLayerIcon(kpiModel.getCustomSkinModel().getDialSkinModel().getTintedLayerIcon());
            }
            if (kpiCustomSkinModel.getSpeedometerFullSkinModel() != null) {
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setColorBandMaskValueIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getColorBandMaskValueIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setColorBandMaskNoValueIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getColorBandMaskNoValueIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setMajorTickmarkIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getMajorTickmarkIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setMinorTickmarkIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getMinorTickmarkIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setBorderIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getBorderIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setIndicatorIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setIndicatorShadowIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getIndicatorShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setTargetIndicatorIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getTargetIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setTargetIndicatorShadowIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getTargetIndicatorShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setTintedLayerEffectsIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getTintedLayerEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setTintedLayerIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getTintedLayerIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setValueHubIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getValueHubIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerFullSkinModel().setValueHubPlacementIcon(kpiModel.getCustomSkinModel().getSpeedometerFullSkinModel().getValueHubPlacementIcon());
            }
            if (kpiCustomSkinModel.getSpeedometerHalfSkinModel() != null) {
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setMajorTickmarkIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getMajorTickmarkIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setMinorTickmarkIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getMinorTickmarkIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setBorderIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getBorderIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setIndicatorIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setIndicatorShadowIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getIndicatorShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setTargetIndicatorIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getTargetIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setTargetIndicatorShadowIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getTargetIndicatorShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setTintedLayerEffectsIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getTintedLayerEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerHalfSkinModel().setTintedLayerIcon(kpiModel.getCustomSkinModel().getSpeedometerHalfSkinModel().getTintedLayerIcon());
            }
            if (kpiCustomSkinModel.getSpeedometerQuarterSkinModel() != null) {
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setMajorTickmarkIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getMajorTickmarkIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setMinorTickmarkIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getMinorTickmarkIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setBorderIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getBorderIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setIndicatorIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setIndicatorShadowIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getIndicatorShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setTargetIndicatorIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getTargetIndicatorIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setTargetIndicatorShadowIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getTargetIndicatorShadowIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setTintedLayerEffectsIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getTintedLayerEffectsIcon());
                this.kpiRendererModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().setTintedLayerIcon(kpiModel.getCustomSkinModel().getSpeedometerQuarterSkinModel().getTintedLayerIcon());
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = this.kpiRenderer.getPreferredSize();
        return prefSize;
    }

    @Override
    public PickInfo pick(int x, int y) {
        return this.createPickInfo(x, y, -1);
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        KPIChartCellModel kpiCellModel = (KPIChartCellModel)this.getModel();
        Object actualRole = kpiCellModel.getActualRole();
        NumericVariable actualVariable = (NumericVariable)this.dataSource.getVariable(actualRole, 0);
        NumericVariable targetVariable = this.dataSource.getTargetVariable(actualRole, 0);
        Object dataTipVariableArray = null;
        boolean graphDataIsVisible = dataTipVariableArray == null || (dataTipVariableArray).length <= 0 || dataTipVariableArray[0] == null || kpiCellModel.getGraphModel().getDataTipModel().getContent() != 11401;
        Vector labelValuePairs = new Vector();
        GTKUtil.PickInfoAccess.addLabelValuePairs(labelValuePairs, actualRole, (Variable)actualVariable, 0, graphDataIsVisible);
        GTKUtil.PickInfoAccess.addLabelValuePairs_IgnoreMissing(labelValuePairs, actualRole, (Variable)targetVariable, 0, graphDataIsVisible);
        return new PickInfo(new Vector[]{labelValuePairs}, 0, this.dataSource.getModel(), x, y, null);
    }

    @Override
    public ChartImageMapInfo getChartImageMapInfo() {
        return null;
    }
}

