/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.ganttchart;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.graphics.util.ZoomScrollBar;
import com.sas.graphics.util.ZoomScrollBarUI;
import com.sas.graphics.util.cell.AlignableComponentConstraints;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.CompoundTimeAxisCell;
import com.sas.graphics.util.cell.CompoundTimeAxisCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.MatrixContainer2;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ValueTree;
import com.sas.graphics.util.cell.ganttchart.GanttChartCellModel;
import com.sas.graphics.util.gl.Channel;
import com.sas.swing.visuals.treetable.TreeTable;
import com.sas.swing.visuals.treetable.TreeTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultMutableTreeNode;

public class GanttChartMatrixContainer
extends MatrixContainer2 {
    private final transient ValueTree rowTree;
    private final transient CellPane cellPane;
    private final transient CellPane dateAxisCellPane;
    private final transient GanttChartCellModel ganttChartCellModel;
    private final transient ZoomScrollBar dateAxisScrollBar;
    private final transient JScrollBar taskAxisScrollBar;
    private transient LayoutCache layoutCache;
    private final transient MatrixContainer2.ScrollModelProjection scrollModelProjectionX;
    private final transient MatrixContainer2.ScrollModelProjection scrollModelProjectionY;

    public GanttChartMatrixContainer(GanttChartCellModel ganttChartCellModel, DataSource dataSource, CellPane.CellComponentFactory ganttChartCellFactory, CellPane.CellComponentFactory dateAxisCellFactory, SwingActionProvider actionProvider, boolean isAntiAliasingEnabled, boolean isTextAntiAliasingEnabled, Channel channel) {
        super(isAntiAliasingEnabled, isTextAntiAliasingEnabled, channel);
        this.setLayout(null);
        this.setOpaque(false);
        if (ganttChartCellModel == null || dataSource == null || ganttChartCellFactory == null) {
            throw new IllegalStateException("required parameter is null");
        }
        this.ganttChartCellModel = ganttChartCellModel;
        this.rowTree = ValueTree.createTrees(null, null, null)[0];
        this.cellPane = new CellPane(null, this.rowTree, ganttChartCellFactory, channel);
        this.dateAxisCellPane = new CellPane(null, this.rowTree, dateAxisCellFactory, channel);
        Color trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        int alpha = 20;
        UIManager.put("ScrollBar.trackHighlight", Util.newColor(trackHighlightColor, alpha));
        BoundedRangeModel dateAxisScrollModel = ganttChartCellModel.getDateAxisScrollModel();
        this.dateAxisScrollBar = new ZoomScrollBar(0);
        ZoomScrollBarUI zsbUI = (ZoomScrollBarUI)this.dateAxisScrollBar.getUI();
        zsbUI.setShowArrows(true);
        zsbUI.setShowNewLook(true);
        zsbUI.setHandleSize(6);
        UIManager.put("ScrollBar.trackHighlight", trackHighlightColor);
        if (dateAxisScrollModel != null) {
            this.dateAxisScrollBar.setModel(dateAxisScrollModel);
        }
        this.scrollModelProjectionX = super.putScrollModel(this.dateAxisScrollBar.getModel());
        BoundedRangeModel taskAxisScrollModel = ganttChartCellModel.getTaskAxisScrollModel();
        this.taskAxisScrollBar = new JScrollBar(1);
        if (taskAxisScrollModel != null) {
            this.taskAxisScrollBar.setModel(taskAxisScrollModel);
        }
        this.scrollModelProjectionY = super.putScrollModel(this.taskAxisScrollBar.getModel());
        this.add(this.dateAxisCellPane, "DateAxisCellPane");
        this.add(this.cellPane, "GanttMatrixCellPane");
        this.add((JScrollBar)this.dateAxisScrollBar, "dateAxisScrollBar");
        this.add(this.taskAxisScrollBar, "taskAxisScrollBar");
    }

    @Override
    public void dispose() {
        this.removeAll();
    }

    private void disposeOfCells() {
        if (this.cellPane != null) {
            this.cellPane.dispose();
        }
    }

    @Override
    public Component getBrushableComponent() {
        if (this.cellPane != null) {
            return this.cellPane;
        }
        return this;
    }

    @Override
    public void removeAll() {
        DefaultBoundedRangeModel dummyModel = new DefaultBoundedRangeModel();
        this.dateAxisScrollBar.setModel((BoundedRangeModel)dummyModel);
        this.taskAxisScrollBar.setModel(dummyModel);
        this.removeAllScrollModels();
        this.disposeOfCells();
        super.removeAll();
    }

    @Override
    public Component[] getMatrixCellComponents() {
        if (this.cellPane == null) {
            return new JComponent[0];
        }
        return this.cellPane.getContentPanelComponents();
    }

    public Component[] getDateAxisCellComponents() {
        if (this.dateAxisCellPane == null) {
            return new JComponent[0];
        }
        return this.dateAxisCellPane.getContentPanelComponents();
    }

    public ZoomScrollBar getDateAxisScrollBar() {
        return this.dateAxisScrollBar;
    }

    public JScrollBar getTaskAxisScrollBar() {
        return this.taskAxisScrollBar;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.layoutCache == null) {
            this.layoutCache = new LayoutCache();
        }
        return this.layoutCache.getPreferredSize();
    }

    private int _computeCellWidth(Rectangle r, Dimension tasbps) {
        int westWidth = 0;
        int eastWidth = tasbps.width;
        return Math.max(0, r.width - (westWidth + eastWidth));
    }

    private int _computeCellHeight(Rectangle r, Dimension daps, Dimension dasbps) {
        int northHeight = daps.height;
        int southHeight = dasbps.height;
        return Math.max(0, r.height - (southHeight + northHeight));
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    @Override
    public void layout() {
        int matrixStartX;
        int startY;
        int minCellHeight;
        Rectangle b = this.getBounds();
        Insets i = this.getInsets();
        Rectangle r = new Rectangle(i.left, i.top, Math.max(0, b.width - (i.left + i.right)), Math.max(0, b.height - (i.top + i.bottom)));
        if (this.layoutCache == null) {
            this.layoutCache = new LayoutCache();
        }
        Dimension minimumCellSize = this.layoutCache.getMinimumCellSize();
        if (r.width < minimumCellSize.width || r.height < minimumCellSize.height) {
            this.disablePanes();
            return;
        }
        if (this.layoutCache.getTaskCount() == 0) {
            this.disablePanes();
            return;
        }
        Dimension daps = this.layoutCache.getDateAxisPreferredSize();
        Dimension dasbps = this.layoutCache.getDateAxisScrollBarPreferredSize();
        Dimension tasbps = this.layoutCache.getTaskAxisScrollBarPreferredSize();
        int maxMatrixHeight = this.layoutCache.getMaxMatrixHeight();
        AlignableComponentConstraints mc = new AlignableComponentConstraints();
        AlignableComponentConstraints dac = new AlignableComponentConstraints();
        Rectangle mb = mc.getBounds();
        Rectangle dab = dac.getBounds();
        Rectangle dasbb = new Rectangle();
        Rectangle tasbb = new Rectangle();
        Insets margin = new Insets(0, 0, 0, 0);
        int cellHeight = this._computeCellHeight(r, daps, dasbps);
        if (cellHeight < (minCellHeight = minimumCellSize.height)) {
            this.disablePanes();
            return;
        }
        int matrixHeight = Math.min(cellHeight, maxMatrixHeight);
        dab.y = startY = r.y + margin.top;
        dab.height = daps.height;
        mb.y = tasbb.y = dab.y + dab.height;
        mb.height = tasbb.height = matrixHeight;
        dasbb.height = dasbps.height;
        dasbb.y = r.y + r.height - dasbb.height;
        BoundedRangeModel scrollModelY = this.scrollModelProjectionY.getModel();
        if (mb.height < maxMatrixHeight) {
            int extent;
            int min;
            int max;
            double valueLocation = (double)scrollModelY.getValue() / (double)(scrollModelY.getMaximum() - scrollModelY.getMinimum());
            int value = (int)(valueLocation * (double)((max = maxMatrixHeight) - (min = 0)));
            if (value + (extent = mb.height) >= max) {
                value = max - extent;
            }
            scrollModelY.setRangeProperties(value, extent, min, max, false);
        } else {
            int min = scrollModelY.getMinimum();
            int max = scrollModelY.getMaximum();
            scrollModelY.setRangeProperties(min, max - min, min, max, false);
            if (!this.scrollModelProjectionY.isZoomed()) {
                tasbps.height = 0;
                tasbps.width = 0;
            }
        }
        int cellWidth = this._computeCellWidth(r, tasbps);
        int minCellWidth = minimumCellSize.width;
        if (cellWidth < minCellWidth) {
            this.disablePanes();
            return;
        }
        int westWidth = 0;
        int matrixWidth = cellWidth;
        int startX = r.x + margin.left;
        dab.x = dasbb.x = (matrixStartX = startX + westWidth);
        mb.x = dasbb.x;
        dab.width = dasbb.width = matrixWidth;
        mb.width = dasbb.width;
        tasbb.width = tasbps.width;
        tasbb.x = r.x + r.width - tasbb.width;
        GanttChartMatrixContainer.applyPaneBounds(this.cellPane, mb);
        GanttChartMatrixContainer.applyPaneBounds(this.dateAxisCellPane, dab);
        GanttChartMatrixContainer.applyScrollBarBounds((JScrollBar)this.dateAxisScrollBar, dasbb);
        GanttChartMatrixContainer.applyScrollBarBounds(this.taskAxisScrollBar, tasbb);
        this.scrollModelProjectionX.setViewportSize(mb.width);
        this.scrollModelProjectionY.setViewportSize(mb.height);
        int matrixWidth2 = this.scrollModelProjectionX.calculateViewSize();
        int matrixHeight2 = this.scrollModelProjectionY.calculateViewSize();
        int scrollX = this.scrollModelProjectionX.calculateViewScroll();
        int scrollY = this.scrollModelProjectionY.calculateViewScroll();
        AlignableComponentConstraints constraints = new AlignableComponentConstraints();
        constraints.getBounds().width = matrixWidth2;
        constraints.getBounds().height = dab.height;
        CellPane.doLayout(this.dateAxisCellPane, constraints, scrollX, 0);
        constraints = new AlignableComponentConstraints();
        constraints.getBounds().width = matrixWidth2;
        constraints.getBounds().height = matrixHeight2;
        CellPane.doLayout(this.cellPane, constraints, scrollX, scrollY);
    }

    public ChartImageMapInfo2 getImageMapInfo() {
        return null;
    }

    private class LayoutCache {
        private final Dimension mps;
        private final Dimension daps;
        private final Dimension dasbps;
        private final Dimension tasbps;
        private final int maxMatrixHeight;
        private final int taskCount;
        private final Dimension preferredSize;
        private final Dimension minimumCellSize;

        public LayoutCache() {
            int oldHeaderHeight;
            this.mps = CellPane.getPreferredSize(GanttChartMatrixContainer.this.cellPane);
            this.daps = CellPane.getPreferredSize(GanttChartMatrixContainer.this.dateAxisCellPane);
            this.dasbps = GanttChartMatrixContainer.this.dateAxisScrollBar.getPreferredSize();
            this.tasbps = GanttChartMatrixContainer.this.taskAxisScrollBar.getPreferredSize();
            TreeTable treeTable = (TreeTable)GanttChartMatrixContainer.this.ganttChartCellModel.getTable();
            this.preferredSize = this._getPreferredSize();
            this.taskCount = treeTable != null ? treeTable.getRowCount() : 0;
            int tableRowHeight = treeTable.getRowHeight();
            this.maxMatrixHeight = this.taskCount * tableRowHeight;
            JTableHeader tableHeader = treeTable.getTableHeader();
            int tthph = oldHeaderHeight = tableHeader.getPreferredSize().height;
            TreeTableHeader tth = null;
            if (tableHeader instanceof TreeTableHeader && (tth = (TreeTableHeader)tableHeader).isPreferredHeightSet()) {
                int overriding_tthph = tthph;
                tth.unsetPreferredHeight();
                tthph = tth.getPreferredHeight();
                tth.setPreferredHeight(overriding_tthph);
            }
            DefaultMutableTreeNode rr = GanttChartMatrixContainer.this.dateAxisCellPane.getRowTree().getRoot();
            CompoundTimeAxisCell axisCell = (CompoundTimeAxisCell)GanttChartMatrixContainer.this.dateAxisCellPane.getCellComponent(rr);
            CompoundTimeAxisCellModel axisCellModel = (CompoundTimeAxisCellModel)axisCell.getAxisModel();
            int gchph = axisCell.getPreferredSize().height;
            int newHeaderHeight = Math.max(tthph, gchph);
            if (newHeaderHeight <= 0) {
                newHeaderHeight = 20;
            }
            if (newHeaderHeight != oldHeaderHeight) {
                if (tth != null) {
                    tth.setPreferredHeight(newHeaderHeight);
                } else {
                    tableHeader.setPreferredSize(new Dimension(tableHeader.getPreferredSize().width, newHeaderHeight));
                }
            }
            if (newHeaderHeight != this.daps.height) {
                axisCell.invalidatePreferredSizeCache();
                axisCellModel.setCatAxisAdj(new Double(newHeaderHeight));
                this.daps.height = newHeaderHeight;
            }
            this.minimumCellSize = this._getMinimumCellSize();
        }

        private Dimension _newDimension(Dimension d) {
            return new Dimension(d.width, d.height);
        }

        private Dimension _getMinimumCellSize() {
            Dimension ms = new Dimension(2, 2);
            return ms;
        }

        private Dimension _getPreferredSize() {
            int w = this.mps.width + this.tasbps.width;
            int h = this.mps.height + this.daps.height + this.dasbps.height;
            Insets insets = GanttChartMatrixContainer.this.getInsets();
            w += insets.top + insets.bottom;
            h += insets.left + insets.right;
            return new Dimension(800, 600);
        }

        public Dimension getMinimumCellSize() {
            return this._newDimension(this.minimumCellSize);
        }

        public Dimension getPreferredSize() {
            return this._newDimension(this.preferredSize);
        }

        public Dimension getMatrixPreferredSize() {
            return this._newDimension(this.mps);
        }

        public Dimension getDateAxisPreferredSize() {
            return this._newDimension(this.daps);
        }

        public Dimension getDateAxisScrollBarPreferredSize() {
            return this._newDimension(this.dasbps);
        }

        public Dimension getTaskAxisScrollBarPreferredSize() {
            return this._newDimension(this.tasbps);
        }

        public int getTaskCount() {
            return this.taskCount;
        }

        public int getMaxMatrixHeight() {
            return this.maxMatrixHeight;
        }
    }
}

