/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.cell.ganttchart;

import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.TableAxisModel;
import com.sas.graphics.util.ZoomScrollBar;
import com.sas.graphics.util.cell.Cell;
import com.sas.graphics.util.cell.CellPane;
import com.sas.graphics.util.cell.CompoundTimeAxisCell;
import com.sas.graphics.util.cell.CompoundTimeAxisCellModel;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.ganttchart.GanttChartCell;
import com.sas.graphics.util.cell.ganttchart.GanttChartCellModel;
import com.sas.graphics.util.cell.ganttchart.GanttChartMatrixContainer;
import com.sas.graphics.util.cell.ganttchart.GanttTreeTable;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.swing.visuals.treetable.TreeTableHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class GanttChartComposite
extends Cell {
    protected GanttTreeTable treeTable;
    protected JScrollPane tableScrollPane;
    protected JSplitPane splitPane;
    protected JPanel myPane;
    protected TableAxisModel tableAxisModel;
    int colIdx = -1;
    protected GanttChartCellModel ganttChartCellModel;
    protected DataSource[] dataSource;
    protected GanttChartCell chartCell;
    protected CompoundTimeAxisCell axisCell;
    int rowHeight;
    protected Memento memento;
    protected JScrollBar taskAxisScrollBar = null;
    protected ZoomScrollBar dateAxisScrollBar = null;
    protected JScrollBar tableColumnScrollBar = null;
    protected boolean validateTreeCalled = false;
    protected boolean initializeDateAxisScrollBarEnabled = false;
    protected boolean initializeTaskAxisScrollBarEnabled = false;
    protected boolean initializeTableColumnScrollBarEnabled = false;
    protected GanttChartMatrixContainer ganttChartCellContainer;
    static Color gridColor;

    public GanttChartComposite(GanttChartCellModel newCellModel, DataSource[] ds, Channel channel) {
        super(newCellModel, channel);
        this.setLayout(new BorderLayout());
        this.ganttChartCellModel = newCellModel;
        this.dataSource = ds;
        this.ganttChartCellModel.setLocalDateAxisCellModel(new CompoundTimeAxisCellModel(null, this.ganttChartCellModel.getDependentAxisCellModel()));
        this.ganttChartCellContainer = new GanttChartMatrixContainer(newCellModel, ds[0], new GanttChartCellComponentFactory(this.ganttChartCellModel, ds, channel), new CompoundTimeAxisCell.CompoundTimeAxisCellComponentFactory(this.ganttChartCellModel.getLocalDateAxisCellModel(), channel), null, newCellModel.getAntialiasedGraphics(), newCellModel.getAntialiasedText(), channel);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        this.ganttChartCellContainer.setBorder(emptyBorder);
        this.chartCell = (GanttChartCell)this.ganttChartCellContainer.getMatrixCellComponents()[0];
        this.memento = this.ganttChartCellModel.getMemento();
        if (this.ganttChartCellModel.getInitializeDateAxisScrollBar() != null) {
            this.initializeDateAxisScrollBarEnabled = this.ganttChartCellModel.getInitializeDateAxisScrollBar();
        }
        if (this.ganttChartCellModel.getInitializeTaskAxisScrollBar() != null) {
            this.initializeTaskAxisScrollBarEnabled = this.ganttChartCellModel.getInitializeTaskAxisScrollBar();
        }
        if (this.ganttChartCellModel.getInitializeTableColumnScrollBar() != null) {
            this.initializeTableColumnScrollBarEnabled = this.ganttChartCellModel.getInitializeTableColumnScrollBar();
        }
        this.treeTable = (GanttTreeTable)((Object)this.ganttChartCellModel.getTable());
        this.treeTable.setScrollsOnExpand(false);
        this.tableAxisModel = this.ganttChartCellModel.getTableAxisModel();
        TableColumnModel columnModel = this.treeTable.getColumnModel();
        Font cellFont = this.tableAxisModel.getValueTextStyle().getFont();
        Font headerFont = this.tableAxisModel.getLabelTextStyle().getFont();
        Color celltextColor = this.tableAxisModel.getValueTextStyle().getColor();
        Color headertextColor = this.tableAxisModel.getLabelTextStyle().getColor();
        Font rowSelectionFont = this.tableAxisModel.getRowSelectionFontStyle().getRowSelectionFontStlye();
        Color rowSelectionFontColor = this.tableAxisModel.getRowSelectionFontStyle().getRowSelectionTextColorStlye();
        Color rowSelectionBgColor = this.tableAxisModel.getValueCellStyle().getRowSelectionBackgroundColor();
        gridColor = this.tableAxisModel.getValueCellStyle().getFrameLineStyle().getColor();
        Color[] backgroundColor = this.tableAxisModel.getValueCellStyle().getBackgroundColors();
        int thickness = 1;
        this.treeTable.setBackground(backgroundColor[0]);
        this.treeTable.setFont(cellFont);
        this.treeTable.setForeground(celltextColor);
        this.treeTable.getZones().setLineColor(gridColor);
        this.treeTable.setGridColor(gridColor);
        this.treeTable.setBorder(BorderFactory.createLineBorder(gridColor, thickness));
        this.treeTable.setSelectionBackground(rowSelectionBgColor);
        this.treeTable.setSelectionForeground(rowSelectionFontColor);
        this.treeTable.setFont(rowSelectionFont, true);
        this.treeTable.setFontForeground(rowSelectionFontColor, true);
        for (int i = 0; i < this.treeTable.getTreeRowCount(); ++i) {
            if (!this.treeTable.isRowSelected(i)) continue;
            this.treeTable.setFont(rowSelectionFont, true);
            this.treeTable.setFontForeground(rowSelectionFontColor, true);
            this.treeTable.setSelectionForeground(rowSelectionFontColor);
            this.treeTable.setSelectionBackground(rowSelectionBgColor);
        }
        Color headerGridColor = this.tableAxisModel.getLabelCellStyle().getFrameLineStyle().getColor();
        Color[] headerBackgroundColor = this.tableAxisModel.getLabelCellStyle().getBackgroundColors();
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        tableHeader.setBackground(headerBackgroundColor[0]);
        tableHeader.setFont(headerFont);
        tableHeader.setForeground(headertextColor);
        tableHeader.setBorder(BorderFactory.createLineBorder(headerGridColor, thickness));
        this.chartCell.localDateAxisCellModel.setReusePreferredSize(Boolean.TRUE);
        this.axisCell = (CompoundTimeAxisCell)this.ganttChartCellContainer.getDateAxisCellComponents()[0];
        this.axisCell.setBorder(BorderFactory.createLineBorder(this.chartCell.localDateAxisCellModel.getAxisColor(), thickness));
        this.taskAxisScrollBar = this.ganttChartCellContainer.getTaskAxisScrollBar();
        this.dateAxisScrollBar = this.ganttChartCellContainer.getDateAxisScrollBar();
        this.rowHeight = this.treeTable.getRowHeight();
        this.taskAxisScrollBar.setUnitIncrement(this.rowHeight);
        this.taskAxisScrollBar.setBlockIncrement(5 * this.rowHeight);
        this.dateAxisScrollBar.setUnitIncrement(15 * this.rowHeight);
        this.dateAxisScrollBar.setBlockIncrement(30 * this.rowHeight);
        AdjustmentListener al = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                GanttChartComposite.this.chartCell.setCurrentTaskScrollValue(ae.getValue());
            }
        };
        this.taskAxisScrollBar.addAdjustmentListener(al);
        if (columnModel.getColumnCount() > 0) {
            this.tableScrollPane = new JScrollPane((Component)((Object)this.treeTable), 20, 32);
            this.tableScrollPane.setColumnHeader(new JViewport());
            this.tableScrollPane.setBorder(emptyBorder);
            this.tableScrollPane.setOpaque(false);
            this.tableScrollPane.getViewport().setOpaque(false);
            this.tableScrollPane.getColumnHeader().setOpaque(false);
            if (this.treeTable.getAutoResizeMode() != 0) {
                BlankScrollBar lbs = new BlankScrollBar(0);
                this.tableScrollPane.setHorizontalScrollBar(lbs);
            }
            this.tableScrollPane.setVerticalScrollBarPolicy(21);
            this.tableScrollPane.getVerticalScrollBar().setModel(this.taskAxisScrollBar.getModel());
            this.splitPane = new JSplitPane(1, this.tableScrollPane, this.ganttChartCellContainer);
            this.splitPane.setOpaque(false);
            this.splitPane.setDividerSize(6);
            this.splitPane.setContinuousLayout(true);
            this.splitPane.setBorder(BorderFactory.createLineBorder(this.ganttChartCellModel.getGanttChartModel().getFrameLineStyle().getColor()));
            this.add((Component)this.splitPane, "Center");
        } else {
            this.tableScrollPane = null;
            this.splitPane = null;
            this.add((Component)this.ganttChartCellContainer, "Center");
        }
        if (this.memento != null) {
            int oldTableHeaderHeight;
            if (this.splitPane != null) {
                this.splitPane.setDividerLocation(this.memento.dividerLocation);
            }
            if ((oldTableHeaderHeight = tableHeader.getHeight()) != this.memento.headerHeight) {
                if (tableHeader instanceof TreeTableHeader) {
                    TreeTableHeader tth = (TreeTableHeader)tableHeader;
                    tth.setPreferredHeight(this.memento.headerHeight);
                } else {
                    tableHeader.setPreferredSize(new Dimension(tableHeader.getPreferredSize().width, this.memento.headerHeight));
                }
            }
        }
    }

    @Override
    public void dispose() {
        JScrollBar sb;
        if (this.ganttChartCellContainer != null) {
            this.ganttChartCellContainer.removeAll();
        }
        if (this.tableScrollPane != null && (sb = this.tableScrollPane.getVerticalScrollBar()) != null) {
            sb.setModel(new DefaultBoundedRangeModel());
        }
        if (this.chartCell != null) {
            this.chartCell.dispose();
        }
        this.memento = null;
    }

    public final void _hideSuccessorColumns(TableColumnModel columnModel, GanttChartCell chartCell) {
        if (chartCell.componentSuccessorVariables != null) {
            ArrayList succVar = (ArrayList)chartCell.componentSuccessorVariables;
            for (int ii = 0; ii < succVar.size(); ++ii) {
                int colIdx = -1;
                try {
                    colIdx = columnModel.getColumnIndex(succVar.get(ii));
                }
                catch (IllegalArgumentException e) {
                    colIdx = -1;
                }
                if (colIdx == -1) continue;
                columnModel.removeColumn(columnModel.getColumn(colIdx));
            }
        }
    }

    @Override
    protected synchronized void construct() {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public boolean isValidateTree() {
        return this.validateTreeCalled;
    }

    @Override
    public void validateTree() {
        this.validateTreeCalled = true;
        Rectangle b = this.getBounds();
        if (b.width + b.height > 0 && this.initializeDateAxisScrollBarEnabled) {
            this.initializeDateAxisScrollBarEnabled = false;
            int dividerSize = 0;
            if (this.splitPane != null) {
                dividerSize = this.splitPane.getDividerSize();
            }
            int cellContainerWidth = this.ganttChartCellContainer.getWidth() == 0 ? 2000 : this.ganttChartCellContainer.getWidth();
            int verticalScrollBarWidth = this.taskAxisScrollBar.getWidth();
            int ganttCellWidth = cellContainerWidth - dividerSize / 2 - verticalScrollBarWidth;
            this.chartCell.setRangeModelExtent(ganttCellWidth);
            BoundedRangeModel scrollModel = this.dateAxisScrollBar.getModel();
            CompoundTimeAxisCellModel dateAxisCellModel = this.ganttChartCellModel.getLocalDateAxisCellModel();
            ContinuousRangeToNumericMapper dMapper = (ContinuousRangeToNumericMapper)dateAxisCellModel.getMapper();
            int extent = Math.max(0, dateAxisCellModel.getLength().intValue());
            int length = Math.max(0, (int)(dMapper.getOutputMax() - dMapper.getOutputMin()));
            double position = this.ganttChartCellModel.getGanttChartModel().getViewStart();
            int value = Double.isNaN(position) || position <= dMapper.getInputMin() || position >= dMapper.getInputMax() ? 0 : (int)(dMapper.getOutputMin() + (dMapper.getOutputMax() - dMapper.getOutputMin()) / (dMapper.getInputMax() - dMapper.getInputMin()) * (position - dMapper.getInputMin()));
            this.dateAxisScrollBar.setValues(value, extent, 0, length);
            this.taskAxisScrollBar.setValues(0, 100, 0, 100);
        }
        if (this.splitPane != null) {
            if (this.splitPane.getDividerLocation() <= 0) {
                double leftySize = this.treeTable.getAutoResizeMode() == 0 && this.treeTable.getSize().getWidth() > 0.0 ? this.treeTable.getSize().getWidth() : this.treeTable.getPreferredSize().getWidth();
                int splitPaneWidth = this.getWidth();
                int leftSpace = (int)Math.min(leftySize, (double)splitPaneWidth * 0.25);
                this.splitPane.setDividerLocation(leftSpace <= 0 ? -1 : leftSpace);
            }
            Dimension d = this.treeTable.getPreferredScrollableViewportSize();
            d.width = this.splitPane.getDividerLocation();
            this.treeTable.setPreferredScrollableViewportSize(d);
        }
        super.validateTree();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int oldTableHeaderHeight;
        int newTableHeaderHeight;
        TreeTableHeader tth;
        super.setBounds(x, y, width, height);
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        int hph = tableHeader.getPreferredSize().height;
        if (tableHeader instanceof TreeTableHeader && (tth = (TreeTableHeader)tableHeader).isPreferredHeightSet()) {
            tth.unsetPreferredHeight();
            int overridden_hph = hph;
            hph = tth.getPreferredHeight();
            tth.setPreferredHeight(overridden_hph);
        }
        if ((newTableHeaderHeight = Math.max(hph, this.axisCell.getPreferredSize().height)) <= 0) {
            newTableHeaderHeight = 20;
        }
        if ((oldTableHeaderHeight = tableHeader.getPreferredSize().height) != newTableHeaderHeight) {
            if (tableHeader instanceof TreeTableHeader) {
                TreeTableHeader tth2 = (TreeTableHeader)tableHeader;
                tth2.setPreferredHeight(newTableHeaderHeight);
            } else {
                tableHeader.setPreferredSize(new Dimension(tableHeader.getPreferredSize().width, newTableHeaderHeight));
            }
            this.axisCell.invalidatePreferredSizeCache();
            CompoundTimeAxisCellModel cellModel = (CompoundTimeAxisCellModel)this.axisCell.getAxisModel();
            cellModel.setCatAxisAdj(new Double(newTableHeaderHeight));
        }
    }

    public Memento _getMemento() {
        if (this.memento != null) {
            this.memento = null;
        }
        this.memento = new Memento();
        this.memento.dividerLocation = this.splitPane != null ? this.splitPane.getDividerLocation() : -1;
        if (this.tableColumnScrollBar != null) {
            this.memento.tableColumnScrollBarValue = this.tableColumnScrollBar.getValue();
        }
        this.memento.taskAxisScrollBarValue = this.taskAxisScrollBar.getValue();
        this.memento.columnWidth = new int[this.treeTable.getColumnCount()];
        for (int ii = 0; ii < this.treeTable.getColumnCount(); ++ii) {
            this.memento.columnWidth[ii] = this.treeTable.getColumnModel().getColumn(ii).getWidth();
        }
        this.memento.headerHeight = this.treeTable.getTableHeader().getHeight();
        return this.memento;
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    @Override
    public PickInfo createPickInfo(int x, int y, int obsIndex) {
        return null;
    }

    public Component getBrushableComponent() {
        if (this.ganttChartCellContainer != null) {
            return this.ganttChartCellContainer.getBrushableComponent();
        }
        return this;
    }

    @Override
    public PickInfo pick(int x, int y) {
        Point p = Util.toDescendent(x, y, this, this.chartCell);
        x = p.x;
        y = p.y;
        return this.chartCell.pick(x, y);
    }

    @Override
    public PickInfo[] pick(int x, int y, int w, int h) {
        Point p = Util.toDescendent(x, y, this, this.chartCell);
        x = p.x;
        y = p.y;
        return this.chartCell.pick(x, y, w, h);
    }

    @Override
    public PickInfo select(int x, int y, boolean isControlDown) {
        Point p = Util.toDescendent(x, y, this, this.chartCell);
        x = p.x;
        y = p.y;
        return this.chartCell.select(x, y, isControlDown);
    }

    @Override
    public PickInfo[] select(int x, int y, int w, int h, boolean isControlDown, boolean isModified) {
        Point p = Util.toDescendent(x, y, this, this.chartCell);
        x = p.x;
        y = p.y;
        return this.chartCell.select(x, y, w, h, isControlDown, isModified);
    }

    public static class GanttChartCellComponentFactory
    implements CellPane.CellComponentFactory {
        private final DataSource[] dataSource;
        private final GanttChartCellModel cellModel;
        private final Channel channel;

        public GanttChartCellComponentFactory(GanttChartCellModel cellModel, DataSource[] dataSource, Channel channel) {
            if (cellModel == null) {
                throw new IllegalStateException("null GanttChartCellModel not supported.");
            }
            this.cellModel = cellModel;
            if (dataSource == null) {
                throw new IllegalStateException("null DataSource not supported.");
            }
            this.dataSource = dataSource;
            this.channel = channel;
        }

        @Override
        public JComponent newCellComponent(TreeNode node) {
            return new GanttChartCell(this.cellModel, this.dataSource, this.channel);
        }

        @Override
        public JComponent newCellComponent(TreeNode columnNode, TreeNode rowNode) {
            throw new IllegalStateException("Not yet Supported");
        }
    }

    public static class Memento {
        int dividerLocation;
        public int tableColumnScrollBarValue;
        public int taskAxisScrollBarValue;
        int[] columnWidth;
        int headerHeight;
    }

    private class BlankScrollBar
    extends JScrollBar {
        BlankScrollBarUI blankUI;

        public BlankScrollBar(int orientation) {
            super(orientation, 0, 0, 0, 0);
            this.blankUI = new BlankScrollBarUI();
            this.setUI(this.blankUI);
            this.blankUI.ignoreListeners();
        }

        @Override
        public void setValues(int newValue, int newExtent, int newMin, int newMax) {
        }

        @Override
        public Component add(Component c) {
            return null;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(gridColor);
            g.drawRect(0, 0, this.getSize().width, this.getSize().height);
        }

        @Override
        protected void processMouseEvent(MouseEvent m) {
        }

        private class BlankScrollBarUI
        extends BasicScrollBarUI {
            private BlankScrollBarUI() {
            }

            public void ignoreListeners() {
                this.uninstallListeners();
            }
        }
    }
}

